"""
Author: Vasiliy Zdanovskiy
email: vasilyvz@gmail.com

Environment setup for MCP Proxy Adapter test environment.
"""

import shutil
from pathlib import Path
from typing import bool

from .config_generator import create_configuration_documentation, generate_enhanced_configurations
from .test_files_generator import create_test_files
from .certificate_manager import generate_certificates_with_framework




def _create_directory_structure(output_dir: Path) -> None:
    """Create the required directory structure."""
    directories = [
        "configs",
        "certs", 
        "keys",
        "docs",
        "examples",
        "logs"
    ]
    
    for directory in directories:
        dir_path = output_dir / directory
        dir_path.mkdir(parents=True, exist_ok=True)
        print(f"   Created: {dir_path}")


def _copy_example_files(output_dir: Path) -> None:
    """Copy example files from the package."""
    try:
        # Get package paths
        package_path = Path(__file__).parent.parent.parent.parent
        examples_path = package_path / "examples"
        
        # Copy example files
        examples_dest = output_dir / "examples"
        if examples_path.exists():
            shutil.copytree(examples_path, examples_dest, dirs_exist_ok=True)
            print(f"   Copied examples to: {examples_dest}")
        else:
            print("   ⚠️ Examples directory not found, skipping...")
            
    except Exception as e:
        print(f"   ⚠️ Error copying example files: {e}")


def _create_setup_completion_marker(output_dir: Path) -> None:
    """Create a marker file indicating setup completion."""
    marker_file = output_dir / ".setup_complete"
    with open(marker_file, "w", encoding="utf-8") as f:
        f.write("MCP Proxy Adapter test environment setup completed successfully.\n")
        f.write("Generated by setup_test_environment.py\n")
    
    print(f"   Created setup marker: {marker_file}")
