/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], "2.1.0-rc.2");
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
438: function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(1).__importStar(e(439));o.Tables=r,e(7).register_models(r)},
439: function _(a,g,r){Object.defineProperty(r,"__esModule",{value:!0});const e=a(1);e.__exportStar(a(440),r),e.__exportStar(a(462),r);var t=a(441);r.DataTable=t.DataTable;var o=a(465);r.TableColumn=o.TableColumn;var n=a(457);r.TableWidget=n.TableWidget;var u=a(466);r.AvgAggregator=u.AvgAggregator,r.MinAggregator=u.MinAggregator,r.MaxAggregator=u.MaxAggregator,r.SumAggregator=u.SumAggregator;var l=a(467);r.GroupingInfo=l.GroupingInfo,r.DataCube=l.DataCube},
440: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1).__importStar(e(18)),r=e(68),a=e(66),n=e(71),l=e(441),u=e(459);class d extends a.DOMView{constructor(e){const{model:t,parent:i}=e.column;super(Object.assign({model:t,parent:i},e)),this.args=e,this.initialize(),this.render()}get emptyValue(){return null}initialize(){super.initialize(),this.inputEl=this._createInput(),this.defaultValue=null}async lazy_initialize(){throw new Error("unsupported")}css_classes(){return super.css_classes().concat(u.bk_cell_editor)}render(){super.render(),this.args.container.append(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()}renderEditor(){}disableNavigation(){this.inputEl.addEventListener("keydown",e=>{switch(e.keyCode){case r.Keys.Left:case r.Keys.Right:case r.Keys.Up:case r.Keys.Down:case r.Keys.PageUp:case r.Keys.PageDown:e.stopImmediatePropagation()}})}destroy(){this.remove()}focus(){this.inputEl.focus()}show(){}hide(){}position(){}getValue(){return this.inputEl.value}setValue(e){this.inputEl.value=e}serializeValue(){return this.getValue()}isValueChanged(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue}applyValue(e,t){const i=this.args.grid.getData(),s=i.index.indexOf(e[l.DTINDEX_NAME]);i.setField(s,this.args.column.field,t)}loadValue(e){const t=e[this.args.column.field];this.defaultValue=null!=t?t:this.emptyValue,this.setValue(this.defaultValue)}validateValue(e){if(this.args.column.validator){const t=this.args.column.validator(e);if(!t.valid)return t}return{valid:!0,msg:null}}validate(){return this.validateValue(this.getValue())}}i.CellEditorView=d,d.__name__="CellEditorView";class o extends n.Model{}i.CellEditor=o,o.__name__="CellEditor";class _ extends d{get emptyValue(){return""}_createInput(){return r.input({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}}i.StringEditorView=_,_.__name__="StringEditorView";class c extends o{static init_StringEditor(){this.prototype.default_view=_,this.define({completions:[s.Array,[]]})}}i.StringEditor=c,c.__name__="StringEditor",c.init_StringEditor();class p extends d{_createInput(){return r.textarea()}}i.TextEditorView=p,p.__name__="TextEditorView";class h extends o{static init_TextEditor(){this.prototype.default_view=p}}i.TextEditor=h,h.__name__="TextEditor",h.init_TextEditor();class E extends d{_createInput(){return r.select()}renderEditor(){for(const e of this.model.options)this.inputEl.appendChild(r.option({value:e},e));this.focus()}}i.SelectEditorView=E,E.__name__="SelectEditorView";class V extends o{static init_SelectEditor(){this.prototype.default_view=E,this.define({options:[s.Array,[]]})}}i.SelectEditor=V,V.__name__="SelectEditor",V.init_SelectEditor();class m extends d{_createInput(){return r.input({type:"text"})}}i.PercentEditorView=m,m.__name__="PercentEditorView";class f extends o{static init_PercentEditor(){this.prototype.default_view=m}}i.PercentEditor=f,f.__name__="PercentEditor",f.init_PercentEditor();class x extends d{_createInput(){return r.input({type:"checkbox",value:"true"})}renderEditor(){this.focus()}loadValue(e){this.defaultValue=!!e[this.args.column.field],this.inputEl.checked=this.defaultValue}serializeValue(){return this.inputEl.checked}}i.CheckboxEditorView=x,x.__name__="CheckboxEditorView";class w extends o{static init_CheckboxEditor(){this.prototype.default_view=x}}i.CheckboxEditor=w,w.__name__="CheckboxEditor",w.init_CheckboxEditor();class g extends d{_createInput(){return r.input({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}remove(){super.remove()}serializeValue(){return parseInt(this.getValue(),10)||0}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}validateValue(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid integer"}:super.validateValue(e)}}i.IntEditorView=g,g.__name__="IntEditorView";class v extends o{static init_IntEditor(){this.prototype.default_view=g,this.define({step:[s.Number,1]})}}i.IntEditor=v,v.__name__="IntEditor",v.init_IntEditor();class y extends d{_createInput(){return r.input({type:"text"})}renderEditor(){this.inputEl.focus(),this.inputEl.select()}remove(){super.remove()}serializeValue(){return parseFloat(this.getValue())||0}loadValue(e){super.loadValue(e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()}validateValue(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid number"}:super.validateValue(e)}}i.NumberEditorView=y,y.__name__="NumberEditorView";class b extends o{static init_NumberEditor(){this.prototype.default_view=y,this.define({step:[s.Number,.01]})}}i.NumberEditor=b,b.__name__="NumberEditor",b.init_NumberEditor();class I extends d{_createInput(){return r.input({type:"text"})}}i.TimeEditorView=I,I.__name__="TimeEditorView";class N extends o{static init_TimeEditor(){this.prototype.default_view=I}}i.TimeEditor=N,N.__name__="TimeEditor",N.init_TimeEditor();class C extends d{_createInput(){return r.input({type:"text"})}get emptyValue(){return new Date}renderEditor(){this.inputEl.focus(),this.inputEl.select()}destroy(){super.destroy()}show(){super.show()}hide(){super.hide()}position(){return super.position()}getValue(){}setValue(e){}}i.DateEditorView=C,C.__name__="DateEditorView";class D extends o{static init_DateEditor(){this.prototype.default_view=C}}i.DateEditor=D,D.__name__="DateEditor",D.init_DateEditor()},
441: function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),o=e(442),n=e(446),l=e(447),r=e(448),d=s.__importStar(e(18)),a=e(24),h=e(8),c=e(9),u=e(17),_=e(72),m=e(188),g=e(457),p=e(458),b=e(459),f=s.__importDefault(e(460)),w=s.__importDefault(e(461));i.DTINDEX_NAME="__bkdt_internal_index__";class x{constructor(e,t){this.init(e,t)}init(e,t){if(i.DTINDEX_NAME in e.data)throw new Error(`special name ${i.DTINDEX_NAME} cannot be used as a data table column`);this.source=e,this.view=t,this.index=this.view.indices}getLength(){return this.index.length}getItem(e){const t={};for(const i of u.keys(this.source.data))t[i]=this.source.data[i][this.index[e]];return t[i.DTINDEX_NAME]=this.index[e],t}getField(e,t){return t==i.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]}setField(e,t,i){const s=this.index[e];this.source.patch({[t]:[[s,i]]})}getItemMetadata(e){return null}getRecords(){return c.range(0,this.getLength()).map(e=>this.getItem(e))}sort(e){let t=e.map(e=>[e.sortCol.field,e.sortAsc?1:-1]);0==t.length&&(t=[[i.DTINDEX_NAME,1]]);const s=this.getRecords(),o=this.index.slice();this.index.sort((function(e,i){for(const[n,l]of t){const t=s[o.indexOf(e)][n],r=s[o.indexOf(i)][n],d=t==r?0:t>r?l:-l;if(0!=d)return d}return 0}))}}i.TableDataProvider=x,x.__name__="TableDataProvider";class C extends p.WidgetView{constructor(){super(...arguments),this._in_selection_update=!1,this._warned_not_reorderable=!1}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render()),this.connect(this.model.source.streaming,()=>this.updateGrid()),this.connect(this.model.source.patching,()=>this.updateGrid()),this.connect(this.model.source.change,()=>this.updateGrid()),this.connect(this.model.source.properties.data.change,()=>this.updateGrid()),this.connect(this.model.source.selected.change,()=>this.updateSelection()),this.connect(this.model.source.selected.properties.indices.change,()=>this.updateSelection())}remove(){var e;null===(e=this.grid)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),f.default,w.default]}_update_layout(){this.layout=new m.LayoutItem,this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.grid.resizeCanvas()}updateGrid(){if(this.model.view.compute_indices(),this.data.init(this.model.source,this.model.view),this.model.sortable){const e=this.grid.getColumns(),t=this.grid.getSortColumns().map(t=>({sortCol:{field:e[this.grid.getColumnIndex(t.columnId)].field},sortAsc:t.sortAsc}));this.data.sort(t)}this.grid.invalidate(),this.grid.render()}updateSelection(){if(this._in_selection_update)return;const{selected:e}=this.model.source,t=e.indices.map(e=>this.data.index.indexOf(e)).sort();this._in_selection_update=!0,this.grid.setSelectedRows(t),this._in_selection_update=!1;const i=this.grid.getViewport(),s=this.model.get_scroll_index(i,t);null!=s&&this.grid.scrollRowToTop(s)}newIndexColumn(){return{id:a.uniqueId(),name:this.model.index_header,field:i.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:b.bk_cell_index,headerCssClass:b.bk_header_index}}css_classes(){return super.css_classes().concat(b.bk_data_table)}render(){let e,t=this.model.columns.map(e=>Object.assign(Object.assign({},e.toColumn()),{parent:this}));if("checkbox"==this.model.selectable&&(e=new n.CheckboxSelectColumn({cssClass:b.bk_cell_select}),t.unshift(e.getColumnDefinition())),null!=this.model.index_position){const e=this.model.index_position,i=this.newIndexColumn();-1==e?t.push(i):e<-1?t.splice(e+1,0,i):t.splice(e,0,i)}let{reorderable:i}=this.model;!i||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(this._warned_not_reorderable||(_.logger.warn("jquery-ui is required to enable DataTable.reorderable"),this._warned_not_reorderable=!0),i=!1);const s={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:i,forceFitColumns:this.model.fit_columns,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height};if(this.data=new x(this.model.source,this.model.view),this.grid=new r.Grid(this.el,this.data,t,s),this.grid.onSort.subscribe((e,i)=>{this.model.sortable&&(t=i.sortCols,this.data.sort(t),this.grid.invalidate(),this.updateSelection(),this.grid.render(),this.model.header_row||this._hide_header(),this.model.update_sort_columns(t))}),!1!==this.model.selectable){this.grid.setSelectionModel(new o.RowSelectionModel({selectActiveRow:null==e})),null!=e&&this.grid.registerPlugin(e);const t={dataItemColumnValueExtractor(e,t){let i=e[t.field];return h.isString(i)&&(i=i.replace(/\n/g,"\\n")),i},includeHeaderWhenCopying:!1};this.grid.registerPlugin(new l.CellExternalCopyManager(t)),this.grid.onSelectedRowsChanged.subscribe((e,t)=>{this._in_selection_update||(this.model.source.selected.indices=t.rows.map(e=>this.data.index[e]))}),this.updateSelection(),this.model.header_row||this._hide_header()}}_hide_header(){for(const e of Array.from(this.el.querySelectorAll(".slick-header-columns")))e.style.height="0px";this.grid.resizeCanvas()}}i.DataTableView=C,C.__name__="DataTableView";class D extends g.TableWidget{constructor(e){super(e),this._sort_columns=[]}get sort_columns(){return this._sort_columns}static init_DataTable(){this.prototype.default_view=C,this.define({columns:[d.Array,[]],fit_columns:[d.Boolean,!0],sortable:[d.Boolean,!0],reorderable:[d.Boolean,!0],editable:[d.Boolean,!1],selectable:[d.Any,!0],index_position:[d.Int,0],index_header:[d.String,"#"],index_width:[d.Int,40],scroll_to_selection:[d.Boolean,!0],header_row:[d.Boolean,!0],row_height:[d.Int,25]}),this.override({width:600,height:400})}update_sort_columns(e){return this._sort_columns=e.map(e=>({field:e.sortCol.field,sortAsc:e.sortAsc})),null}get_scroll_index(e,t){return this.scroll_to_selection&&0!=t.length?c.some(t,t=>e.top<=t&&t<=e.bottom)?null:Math.max(0,Math.min(...t)-1):null}}i.DataTable=D,D.__name__="DataTable",D.init_DataTable()},
442: function _(e,t,n){var o=e(443),r=e(445);t.exports={RowSelectionModel:function(e){var t,n,l,i=[],c=this,u=new r.EventHandler,s={selectActiveRow:!0};function a(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function f(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function h(e){for(var n=[],o=t.getColumns().length-1,l=0;l<e.length;l++)n.push(new r.Range(e[l],0,e[l],o));return n}function w(){return f(i)}function g(e){(i&&0!==i.length||e&&0!==e.length)&&(i=e,c.onSelectedRangesChanged.notify(i))}function v(e,n){l.selectActiveRow&&null!=n.row&&g([new r.Range(n.row,0,n.row,t.getColumns().length-1)])}function p(e){var n=t.getActiveCell();if(t.getOptions().multiSelect&&n&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.which==r.keyCode.UP||e.which==r.keyCode.DOWN)){var o=w();o.sort((function(e,t){return e-t})),o.length||(o=[n.row]);var l,i=o[0],c=o[o.length-1];if((l=e.which==r.keyCode.DOWN?n.row<c||i==c?++c:++i:n.row<c?--c:--i)>=0&&l<t.getDataLength())t.scrollRowIntoView(l),g(h(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(i,c)));e.preventDefault(),e.stopPropagation()}}function y(e){var n=t.getCellFromEvent(e);if(!n||!t.canCellBeActive(n.row,n.cell))return!1;if(!t.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var r=f(i),l=o.inArray(n.row,r);if(-1===l&&(e.ctrlKey||e.metaKey))r.push(n.row),t.setActiveCell(n.row,n.cell);else if(-1!==l&&(e.ctrlKey||e.metaKey))r=o.grep(r,(function(e,t){return e!==n.row})),t.setActiveCell(n.row,n.cell);else if(r.length&&e.shiftKey){var c=r.pop(),u=Math.min(n.row,c),s=Math.max(n.row,c);r=[];for(var a=u;a<=s;a++)a!==c&&r.push(a);r.push(c),t.setActiveCell(n.row,n.cell)}return g(h(r)),e.stopImmediatePropagation(),!0}o.extend(this,{getSelectedRows:w,setSelectedRows:function(e){g(h(e))},getSelectedRanges:function(){return i},setSelectedRanges:g,init:function(n){l=o.extend(!0,{},s,e),t=n,u.subscribe(t.onActiveCellChanged,a(v)),u.subscribe(t.onKeyDown,a(p)),u.subscribe(t.onClick,a(y))},destroy:function(){u.unsubscribeAll()},onSelectedRangesChanged:new r.Event})}}},
443: function _(e,n,f){n.exports="undefined"!=typeof $?$:e(444)},
444: function _(e,t,n){
/*!
     * jQuery JavaScript Library v3.5.0
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2020-04-10T15:07Z
     */
!function(e,n){"use strict";"object"==typeof t&&"object"==typeof t.exports?t.exports=e.document?n(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return n(e)}:n(e)}("undefined"!=typeof window?window:this,(function(e,t){"use strict";var n=[],r=Object.getPrototypeOf,i=n.slice,o=n.flat?function(e){return n.flat.call(e)}:function(e){return n.concat.apply([],e)},a=n.push,s=n.indexOf,u={},l=u.toString,c=u.hasOwnProperty,f=c.toString,p=f.call(Object),d={},h=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},g=function(e){return null!=e&&e===e.window},v=e.document,y={type:!0,src:!0,nonce:!0,noModule:!0};function m(e,t,n){var r,i,o=(n=n||v).createElement("script");if(o.text=e,t)for(r in y)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function x(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?u[l.call(e)]||"object":typeof e}var b=function(e,t){return new b.fn.init(e,t)};function w(e){var t=!!e&&"length"in e&&e.length,n=x(e);return!h(e)&&!g(e)&&("array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e)}b.fn=b.prototype={jquery:"3.5.0",constructor:b,length:0,toArray:function(){return i.call(this)},get:function(e){return null==e?i.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return b.each(this,e)},map:function(e){return this.pushStack(b.map(this,(function(t,n){return e.call(t,n,t)})))},slice:function(){return this.pushStack(i.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(b.grep(this,(function(e,t){return(t+1)%2})))},odd:function(){return this.pushStack(b.grep(this,(function(e,t){return t%2})))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:a,sort:n.sort,splice:n.splice},b.extend=b.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||h(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(b.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||b.isPlainObject(n)?n:{},i=!1,a[t]=b.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},b.extend({expando:"jQuery"+("3.5.0"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==l.call(e))&&(!(t=r(e))||"function"==typeof(n=c.call(t,"constructor")&&t.constructor)&&f.call(n)===p)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){m(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(w(e))for(n=e.length;r<n&&!1!==t.call(e[r],r,e[r]);r++);else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(w(Object(e))?b.merge(n,"string"==typeof e?[e]:e):a.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:s.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,a=0,s=[];if(w(e))for(r=e.length;a<r;a++)null!=(i=t(e[a],a,n))&&s.push(i);else for(a in e)null!=(i=t(e[a],a,n))&&s.push(i);return o(s)},guid:1,support:d}),"function"==typeof Symbol&&(b.fn[Symbol.iterator]=n[Symbol.iterator]),b.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),(function(e,t){u["[object "+t+"]"]=t.toLowerCase()}));var T=
/*!
         * Sizzle CSS Selector Engine v2.3.5
         * https://sizzlejs.com/
         *
         * Copyright JS Foundation and other contributors
         * Released under the MIT license
         * https://js.foundation/
         *
         * Date: 2020-03-14
         */
function(e){var t,n,r,i,o,a,s,u,l,c,f,p,d,h,g,v,y,m,x,b="sizzle"+1*new Date,w=e.document,T=0,C=0,E=ue(),S=ue(),k=ue(),A=ue(),N=function(e,t){return e===t&&(f=!0),0},D={}.hasOwnProperty,j=[],q=j.pop,L=j.push,H=j.push,O=j.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"�":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){p()},ae=be((function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()}),{dir:"parentNode",next:"legend"});try{H.apply(j=O.call(w.childNodes),w.childNodes),j[w.childNodes.length].nodeType}catch(e){H={apply:j.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){for(var n=e.length,r=0;e[n++]=t[r++];);e.length=n-1}}}function se(e,t,r,i){var o,s,l,c,f,h,y,m=t&&t.ownerDocument,w=t?t.nodeType:9;if(r=r||[],"string"!=typeof e||!e||1!==w&&9!==w&&11!==w)return r;if(!i&&(p(t),t=t||d,g)){if(11!==w&&(f=Z.exec(e)))if(o=f[1]){if(9===w){if(!(l=t.getElementById(o)))return r;if(l.id===o)return r.push(l),r}else if(m&&(l=m.getElementById(o))&&x(t,l)&&l.id===o)return r.push(l),r}else{if(f[2])return H.apply(r,t.getElementsByTagName(e)),r;if((o=f[3])&&n.getElementsByClassName&&t.getElementsByClassName)return H.apply(r,t.getElementsByClassName(o)),r}if(n.qsa&&!A[e+" "]&&(!v||!v.test(e))&&(1!==w||"object"!==t.nodeName.toLowerCase())){if(y=e,m=t,1===w&&(U.test(e)||z.test(e))){for((m=ee.test(e)&&ye(t.parentNode)||t)===t&&n.scope||((c=t.getAttribute("id"))?c=c.replace(re,ie):t.setAttribute("id",c=b)),s=(h=a(e)).length;s--;)h[s]=(c?"#"+c:":scope")+" "+xe(h[s]);y=h.join(",")}try{return H.apply(r,m.querySelectorAll(y)),r}catch(t){A(e,!0)}finally{c===b&&t.removeAttribute("id")}}}return u(e.replace($,"$1"),t,r,i)}function ue(){var e=[];return function t(n,i){return e.push(n+" ")>r.cacheLength&&delete t[e.shift()],t[n+" "]=i}}function le(e){return e[b]=!0,e}function ce(e){var t=d.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){for(var n=e.split("|"),i=n.length;i--;)r.attrHandle[n[i]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function de(e){return function(t){return"input"===t.nodeName.toLowerCase()&&t.type===e}}function he(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function ge(e){return function(t){return"form"in t?t.parentNode&&!1===t.disabled?"label"in t?"label"in t.parentNode?t.parentNode.disabled===e:t.disabled===e:t.isDisabled===e||t.isDisabled!==!e&&ae(t)===e:t.disabled===e:"label"in t&&t.disabled===e}}function ve(e){return le((function(t){return t=+t,le((function(n,r){for(var i,o=e([],n.length,t),a=o.length;a--;)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))}))}))}function ye(e){return e&&void 0!==e.getElementsByTagName&&e}for(t in n=se.support={},o=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},p=se.setDocument=function(e){var t,i,a=e?e.ownerDocument||e:w;return a!=d&&9===a.nodeType&&a.documentElement?(h=(d=a).documentElement,g=!o(d),w!=d&&(i=d.defaultView)&&i.top!==i&&(i.addEventListener?i.addEventListener("unload",oe,!1):i.attachEvent&&i.attachEvent("onunload",oe)),n.scope=ce((function(e){return h.appendChild(e).appendChild(d.createElement("div")),void 0!==e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length})),n.attributes=ce((function(e){return e.className="i",!e.getAttribute("className")})),n.getElementsByTagName=ce((function(e){return e.appendChild(d.createComment("")),!e.getElementsByTagName("*").length})),n.getElementsByClassName=K.test(d.getElementsByClassName),n.getById=ce((function(e){return h.appendChild(e).id=b,!d.getElementsByName||!d.getElementsByName(b).length})),n.getById?(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n=t.getElementById(e);return n?[n]:[]}}):(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){var n=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];for(i=t.getElementsByName(e),r=0;o=i[r++];)if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),r.find.TAG=n.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):n.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){for(;n=o[i++];)1===n.nodeType&&r.push(n);return r}return o},r.find.CLASS=n.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&g)return t.getElementsByClassName(e)},y=[],v=[],(n.qsa=K.test(d.querySelectorAll))&&(ce((function(e){var t;h.appendChild(e).innerHTML="<a id='"+b+"'></a><select id='"+b+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+b+"-]").length||v.push("~="),(t=d.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+b+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")})),ce((function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=d.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),h.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")}))),(n.matchesSelector=K.test(m=h.matches||h.webkitMatchesSelector||h.mozMatchesSelector||h.oMatchesSelector||h.msMatchesSelector))&&ce((function(e){n.disconnectedMatch=m.call(e,"*"),m.call(e,"[s!='']:x"),y.push("!=",F)})),v=v.length&&new RegExp(v.join("|")),y=y.length&&new RegExp(y.join("|")),t=K.test(h.compareDocumentPosition),x=t||K.test(h.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},N=t?function(e,t){if(e===t)return f=!0,0;var r=!e.compareDocumentPosition-!t.compareDocumentPosition;return r||(1&(r=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!n.sortDetached&&t.compareDocumentPosition(e)===r?e==d||e.ownerDocument==w&&x(w,e)?-1:t==d||t.ownerDocument==w&&x(w,t)?1:c?P(c,e)-P(c,t):0:4&r?-1:1)}:function(e,t){if(e===t)return f=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==d?-1:t==d?1:i?-1:o?1:c?P(c,e)-P(c,t):0;if(i===o)return pe(e,t);for(n=e;n=n.parentNode;)a.unshift(n);for(n=t;n=n.parentNode;)s.unshift(n);for(;a[r]===s[r];)r++;return r?pe(a[r],s[r]):a[r]==w?-1:s[r]==w?1:0},d):d},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(p(e),n.matchesSelector&&g&&!A[t+" "]&&(!y||!y.test(t))&&(!v||!v.test(t)))try{var r=m.call(e,t);if(r||n.disconnectedMatch||e.document&&11!==e.document.nodeType)return r}catch(e){A(t,!0)}return se(t,d,null,[e]).length>0},se.contains=function(e,t){return(e.ownerDocument||e)!=d&&p(e),x(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=d&&p(e);var i=r.attrHandle[t.toLowerCase()],o=i&&D.call(r.attrHandle,t.toLowerCase())?i(e,t,!g):void 0;return void 0!==o?o:n.attributes||!g?e.getAttribute(t):(o=e.getAttributeNode(t))&&o.specified?o.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,r=[],i=0,o=0;if(f=!n.detectDuplicates,c=!n.sortStable&&e.slice(0),e.sort(N),f){for(;t=e[o++];)t===e[o]&&(i=r.push(o));for(;i--;)e.splice(r[i],1)}return c=null,e},i=se.getText=function(e){var t,n="",r=0,o=e.nodeType;if(o){if(1===o||9===o||11===o){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=i(e)}else if(3===o||4===o)return e.nodeValue}else for(;t=e[r++];)n+=i(t);return n},(r=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=a(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=E[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&E(e,(function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")}))},ATTR:function(e,t,n){return function(r){var i=se.attr(r,e);return null==i?"!="===t:!t||(i+="","="===t?i===n:"!="===t?i!==n:"^="===t?n&&0===i.indexOf(n):"*="===t?n&&i.indexOf(n)>-1:"$="===t?n&&i.slice(-n.length)===n:"~="===t?(" "+i.replace(B," ")+" ").indexOf(n)>-1:"|="===t&&(i===n||i.slice(0,n.length+1)===n+"-"))}},CHILD:function(e,t,n,r,i){var o="nth"!==e.slice(0,3),a="last"!==e.slice(-4),s="of-type"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,f,p,d,h,g=o!==a?"nextSibling":"previousSibling",v=t.parentNode,y=s&&t.nodeName.toLowerCase(),m=!u&&!s,x=!1;if(v){if(o){for(;g;){for(p=t;p=p[g];)if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[a?v.firstChild:v.lastChild],a&&m){for(x=(d=(l=(c=(f=(p=v)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1])&&l[2],p=d&&v.childNodes[d];p=++d&&p&&p[g]||(x=d=0)||h.pop();)if(1===p.nodeType&&++x&&p===t){c[e]=[T,d,x];break}}else if(m&&(x=d=(l=(c=(f=(p=t)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1]),!1===x)for(;(p=++d&&p&&p[g]||(x=d=0)||h.pop())&&((s?p.nodeName.toLowerCase()!==y:1!==p.nodeType)||!++x||(m&&((c=(f=p[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]=[T,x]),p!==t)););return(x-=i)===r||x%r==0&&x/r>=0}}},PSEUDO:function(e,t){var n,i=r.pseudos[e]||r.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return i[b]?i(t):i.length>1?(n=[e,e,"",t],r.setFilters.hasOwnProperty(e.toLowerCase())?le((function(e,n){for(var r,o=i(e,t),a=o.length;a--;)e[r=P(e,o[a])]=!(n[r]=o[a])})):function(e){return i(e,0,n)}):i}},pseudos:{not:le((function(e){var t=[],n=[],r=s(e.replace($,"$1"));return r[b]?le((function(e,t,n,i){for(var o,a=r(e,null,i,[]),s=e.length;s--;)(o=a[s])&&(e[s]=!(t[s]=o))})):function(e,i,o){return t[0]=e,r(t,null,o,n),t[0]=null,!n.pop()}})),has:le((function(e){return function(t){return se(e,t).length>0}})),contains:le((function(e){return e=e.replace(te,ne),function(t){return(t.textContent||i(t)).indexOf(e)>-1}})),lang:le((function(e){return V.test(e||"")||se.error("unsupported lang: "+e),e=e.replace(te,ne).toLowerCase(),function(t){var n;do{if(n=g?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return(n=n.toLowerCase())===e||0===n.indexOf(e+"-")}while((t=t.parentNode)&&1===t.nodeType);return!1}})),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===h},focus:function(e){return e===d.activeElement&&(!d.hasFocus||d.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!r.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve((function(){return[0]})),last:ve((function(e,t){return[t-1]})),eq:ve((function(e,t,n){return[n<0?n+t:n]})),even:ve((function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e})),odd:ve((function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e})),lt:ve((function(e,t,n){for(var r=n<0?n+t:n>t?t:n;--r>=0;)e.push(r);return e})),gt:ve((function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e}))}}).pseudos.nth=r.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})r.pseudos[t]=de(t);for(t in{submit:!0,reset:!0})r.pseudos[t]=he(t);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(e,t,n){var r=t.dir,i=t.next,o=i||r,a=n&&"parentNode"===o,s=C++;return t.first?function(t,n,i){for(;t=t[r];)if(1===t.nodeType||a)return e(t,n,i);return!1}:function(t,n,u){var l,c,f,p=[T,s];if(u){for(;t=t[r];)if((1===t.nodeType||a)&&e(t,n,u))return!0}else for(;t=t[r];)if(1===t.nodeType||a)if(c=(f=t[b]||(t[b]={}))[t.uniqueID]||(f[t.uniqueID]={}),i&&i===t.nodeName.toLowerCase())t=t[r]||t;else{if((l=c[o])&&l[0]===T&&l[1]===s)return p[2]=l[2];if(c[o]=p,p[2]=e(t,n,u))return!0}return!1}}function we(e){return e.length>1?function(t,n,r){for(var i=e.length;i--;)if(!e[i](t,n,r))return!1;return!0}:e[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(e,t,n,r,i,o){return r&&!r[b]&&(r=Ce(r)),i&&!i[b]&&(i=Ce(i,o)),le((function(o,a,s,u){var l,c,f,p=[],d=[],h=a.length,g=o||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(t||"*",s.nodeType?[s]:s,[]),v=!e||!o&&t?g:Te(g,p,e,s,u),y=n?i||(o?e:h||r)?[]:a:v;if(n&&n(v,y,s,u),r)for(l=Te(y,d),r(l,[],s,u),c=l.length;c--;)(f=l[c])&&(y[d[c]]=!(v[d[c]]=f));if(o){if(i||e){if(i){for(l=[],c=y.length;c--;)(f=y[c])&&l.push(v[c]=f);i(null,y=[],l,u)}for(c=y.length;c--;)(f=y[c])&&(l=i?P(o,f):p[c])>-1&&(o[l]=!(a[l]=f))}}else y=Te(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)}))}function Ee(e){for(var t,n,i,o=e.length,a=r.relative[e[0].type],s=a||r.relative[" "],u=a?1:0,c=be((function(e){return e===t}),s,!0),f=be((function(e){return P(t,e)>-1}),s,!0),p=[function(e,n,r){var i=!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):f(e,n,r));return t=null,i}];u<o;u++)if(n=r.relative[e[u].type])p=[be(we(p),n)];else{if((n=r.filter[e[u].type].apply(null,e[u].matches))[b]){for(i=++u;i<o&&!r.relative[e[i].type];i++);return Ce(u>1&&we(p),u>1&&xe(e.slice(0,u-1).concat({value:" "===e[u-2].type?"*":""})).replace($,"$1"),n,u<i&&Ee(e.slice(u,i)),i<o&&Ee(e=e.slice(i)),i<o&&xe(e))}p.push(n)}return we(p)}return me.prototype=r.filters=r.pseudos,r.setFilters=new me,a=se.tokenize=function(e,t){var n,i,o,a,s,u,l,c=S[e+" "];if(c)return t?0:c.slice(0);for(s=e,u=[],l=r.preFilter;s;){for(a in n&&!(i=_.exec(s))||(i&&(s=s.slice(i[0].length)||s),u.push(o=[])),n=!1,(i=z.exec(s))&&(n=i.shift(),o.push({value:n,type:i[0].replace($," ")}),s=s.slice(n.length)),r.filter)!(i=G[a].exec(s))||l[a]&&!(i=l[a](i))||(n=i.shift(),o.push({value:n,type:a,matches:i}),s=s.slice(n.length));if(!n)break}return t?s.length:s?se.error(e):S(e,u).slice(0)},s=se.compile=function(e,t){var n,i=[],o=[],s=k[e+" "];if(!s){for(t||(t=a(e)),n=t.length;n--;)(s=Ee(t[n]))[b]?i.push(s):o.push(s);(s=k(e,function(e,t){var n=t.length>0,i=e.length>0,o=function(o,a,s,u,c){var f,h,v,y=0,m="0",x=o&&[],b=[],w=l,C=o||i&&r.find.TAG("*",c),E=T+=null==w?1:Math.random()||.1,S=C.length;for(c&&(l=a==d||a||c);m!==S&&null!=(f=C[m]);m++){if(i&&f){for(h=0,a||f.ownerDocument==d||(p(f),s=!g);v=e[h++];)if(v(f,a||d,s)){u.push(f);break}c&&(T=E)}n&&((f=!v&&f)&&y--,o&&x.push(f))}if(y+=m,n&&m!==y){for(h=0;v=t[h++];)v(x,b,a,s);if(o){if(y>0)for(;m--;)x[m]||b[m]||(b[m]=q.call(u));b=Te(b)}H.apply(u,b),c&&!o&&b.length>0&&y+t.length>1&&se.uniqueSort(u)}return c&&(T=E,l=w),x};return n?le(o):o}(o,i))).selector=e}return s},u=se.select=function(e,t,n,i){var o,u,l,c,f,p="function"==typeof e&&e,d=!i&&a(e=p.selector||e);if(n=n||[],1===d.length){if((u=d[0]=d[0].slice(0)).length>2&&"ID"===(l=u[0]).type&&9===t.nodeType&&g&&r.relative[u[1].type]){if(!(t=(r.find.ID(l.matches[0].replace(te,ne),t)||[])[0]))return n;p&&(t=t.parentNode),e=e.slice(u.shift().value.length)}for(o=G.needsContext.test(e)?0:u.length;o--&&(l=u[o],!r.relative[c=l.type]);)if((f=r.find[c])&&(i=f(l.matches[0].replace(te,ne),ee.test(u[0].type)&&ye(t.parentNode)||t))){if(u.splice(o,1),!(e=i.length&&xe(u)))return H.apply(n,i),n;break}}return(p||s(e,d))(i,t,!g,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},n.sortStable=b.split("").sort(N).join("")===b,n.detectDuplicates=!!f,p(),n.sortDetached=ce((function(e){return 1&e.compareDocumentPosition(d.createElement("fieldset"))})),ce((function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")}))||fe("type|href|height|width",(function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)})),n.attributes&&ce((function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")}))||fe("value",(function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue})),ce((function(e){return null==e.getAttribute("disabled")}))||fe(R,(function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null})),se}(e);b.find=T,b.expr=T.selectors,b.expr[":"]=b.expr.pseudos,b.uniqueSort=b.unique=T.uniqueSort,b.text=T.getText,b.isXMLDoc=T.isXML,b.contains=T.contains,b.escapeSelector=T.escape;var C=function(e,t,n){for(var r=[],i=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(i&&b(e).is(n))break;r.push(e)}return r},E=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},S=b.expr.match.needsContext;function k(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var A=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function N(e,t,n){return h(t)?b.grep(e,(function(e,r){return!!t.call(e,r,e)!==n})):t.nodeType?b.grep(e,(function(e){return e===t!==n})):"string"!=typeof t?b.grep(e,(function(e){return s.call(t,e)>-1!==n})):b.filter(t,e,n)}b.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?b.find.matchesSelector(r,e)?[r]:[]:b.find.matches(e,b.grep(t,(function(e){return 1===e.nodeType})))},b.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(b(e).filter((function(){for(t=0;t<r;t++)if(b.contains(i[t],this))return!0})));for(n=this.pushStack([]),t=0;t<r;t++)b.find(e,i[t],n);return r>1?b.uniqueSort(n):n},filter:function(e){return this.pushStack(N(this,e||[],!1))},not:function(e){return this.pushStack(N(this,e||[],!0))},is:function(e){return!!N(this,"string"==typeof e&&S.test(e)?b(e):e||[],!1).length}});var D,j=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(b.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||D,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:j.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof b?t[0]:t,b.merge(this,b.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:v,!0)),A.test(r[1])&&b.isPlainObject(t))for(r in t)h(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=v.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):h(e)?void 0!==n.ready?n.ready(e):e(b):b.makeArray(e,this)}).prototype=b.fn,D=b(v);var q=/^(?:parents|prev(?:Until|All))/,L={children:!0,contents:!0,next:!0,prev:!0};function H(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}b.fn.extend({has:function(e){var t=b(e,this),n=t.length;return this.filter((function(){for(var e=0;e<n;e++)if(b.contains(this,t[e]))return!0}))},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&b(e);if(!S.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?a.index(n)>-1:1===n.nodeType&&b.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(o.length>1?b.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?s.call(b(e),this[0]):s.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(b.uniqueSort(b.merge(this.get(),b(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return C(e,"parentNode")},parentsUntil:function(e,t,n){return C(e,"parentNode",n)},next:function(e){return H(e,"nextSibling")},prev:function(e){return H(e,"previousSibling")},nextAll:function(e){return C(e,"nextSibling")},prevAll:function(e){return C(e,"previousSibling")},nextUntil:function(e,t,n){return C(e,"nextSibling",n)},prevUntil:function(e,t,n){return C(e,"previousSibling",n)},siblings:function(e){return E((e.parentNode||{}).firstChild,e)},children:function(e){return E(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(k(e,"template")&&(e=e.content||e),b.merge([],e.childNodes))}},(function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return"Until"!==e.slice(-5)&&(r=n),r&&"string"==typeof r&&(i=b.filter(r,i)),this.length>1&&(L[e]||b.uniqueSort(i),q.test(e)&&i.reverse()),this.pushStack(i)}}));var O=/[^\x20\t\r\n\f]+/g;function P(e){return e}function R(e){throw e}function M(e,t,n,r){var i;try{e&&h(i=e.promise)?i.call(e).done(t).fail(n):e&&h(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}b.Callbacks=function(e){e="string"==typeof e?function(e){var t={};return b.each(e.match(O)||[],(function(e,n){t[n]=!0})),t}(e):b.extend({},e);var t,n,r,i,o=[],a=[],s=-1,u=function(){for(i=i||e.once,r=t=!0;a.length;s=-1)for(n=a.shift();++s<o.length;)!1===o[s].apply(n[0],n[1])&&e.stopOnFalse&&(s=o.length,n=!1);e.memory||(n=!1),t=!1,i&&(o=n?[]:"")},l={add:function(){return o&&(n&&!t&&(s=o.length-1,a.push(n)),function t(n){b.each(n,(function(n,r){h(r)?e.unique&&l.has(r)||o.push(r):r&&r.length&&"string"!==x(r)&&t(r)}))}(arguments),n&&!t&&u()),this},remove:function(){return b.each(arguments,(function(e,t){for(var n;(n=b.inArray(t,o,n))>-1;)o.splice(n,1),n<=s&&s--})),this},has:function(e){return e?b.inArray(e,o)>-1:o.length>0},empty:function(){return o&&(o=[]),this},disable:function(){return i=a=[],o=n="",this},disabled:function(){return!o},lock:function(){return i=a=[],n||t||(o=n=""),this},locked:function(){return!!i},fireWith:function(e,n){return i||(n=[e,(n=n||[]).slice?n.slice():n],a.push(n),t||u()),this},fire:function(){return l.fireWith(this,arguments),this},fired:function(){return!!r}};return l},b.extend({Deferred:function(t){var n=[["notify","progress",b.Callbacks("memory"),b.Callbacks("memory"),2],["resolve","done",b.Callbacks("once memory"),b.Callbacks("once memory"),0,"resolved"],["reject","fail",b.Callbacks("once memory"),b.Callbacks("once memory"),1,"rejected"]],r="pending",i={state:function(){return r},always:function(){return o.done(arguments).fail(arguments),this},catch:function(e){return i.then(null,e)},pipe:function(){var e=arguments;return b.Deferred((function(t){b.each(n,(function(n,r){var i=h(e[r[4]])&&e[r[4]];o[r[1]]((function(){var e=i&&i.apply(this,arguments);e&&h(e.promise)?e.promise().progress(t.notify).done(t.resolve).fail(t.reject):t[r[0]+"With"](this,i?[e]:arguments)}))})),e=null})).promise()},then:function(t,r,i){var o=0;function a(t,n,r,i){return function(){var s=this,u=arguments,l=function(){var e,l;if(!(t<o)){if((e=r.apply(s,u))===n.promise())throw new TypeError("Thenable self-resolution");l=e&&("object"==typeof e||"function"==typeof e)&&e.then,h(l)?i?l.call(e,a(o,n,P,i),a(o,n,R,i)):(o++,l.call(e,a(o,n,P,i),a(o,n,R,i),a(o,n,P,n.notifyWith))):(r!==P&&(s=void 0,u=[e]),(i||n.resolveWith)(s,u))}},c=i?l:function(){try{l()}catch(e){b.Deferred.exceptionHook&&b.Deferred.exceptionHook(e,c.stackTrace),t+1>=o&&(r!==R&&(s=void 0,u=[e]),n.rejectWith(s,u))}};t?c():(b.Deferred.getStackHook&&(c.stackTrace=b.Deferred.getStackHook()),e.setTimeout(c))}}return b.Deferred((function(e){n[0][3].add(a(0,e,h(i)?i:P,e.notifyWith)),n[1][3].add(a(0,e,h(t)?t:P)),n[2][3].add(a(0,e,h(r)?r:R))})).promise()},promise:function(e){return null!=e?b.extend(e,i):i}},o={};return b.each(n,(function(e,t){var a=t[2],s=t[5];i[t[1]]=a.add,s&&a.add((function(){r=s}),n[3-e][2].disable,n[3-e][3].disable,n[0][2].lock,n[0][3].lock),a.add(t[3].fire),o[t[0]]=function(){return o[t[0]+"With"](this===o?void 0:this,arguments),this},o[t[0]+"With"]=a.fireWith})),i.promise(o),t&&t.call(o,o),o},when:function(e){var t=arguments.length,n=t,r=Array(n),o=i.call(arguments),a=b.Deferred(),s=function(e){return function(n){r[e]=this,o[e]=arguments.length>1?i.call(arguments):n,--t||a.resolveWith(r,o)}};if(t<=1&&(M(e,a.done(s(n)).resolve,a.reject,!t),"pending"===a.state()||h(o[n]&&o[n].then)))return a.then();for(;n--;)M(o[n],s(n),a.reject);return a.promise()}});var I=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;b.Deferred.exceptionHook=function(t,n){e.console&&e.console.warn&&t&&I.test(t.name)&&e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)},b.readyException=function(t){e.setTimeout((function(){throw t}))};var W=b.Deferred();function F(){v.removeEventListener("DOMContentLoaded",F),e.removeEventListener("load",F),b.ready()}b.fn.ready=function(e){return W.then(e).catch((function(e){b.readyException(e)})),this},b.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--b.readyWait:b.isReady)||(b.isReady=!0,!0!==e&&--b.readyWait>0||W.resolveWith(v,[b]))}}),b.ready.then=W.then,"complete"===v.readyState||"loading"!==v.readyState&&!v.documentElement.doScroll?e.setTimeout(b.ready):(v.addEventListener("DOMContentLoaded",F),e.addEventListener("load",F));var B=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===x(n))for(s in i=!0,n)B(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,h(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(b(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},$=/^-ms-/,_=/-([a-z])/g;function z(e,t){return t.toUpperCase()}function U(e){return e.replace($,"ms-").replace(_,z)}var X=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function V(){this.expando=b.expando+V.uid++}V.uid=1,V.prototype={cache:function(e){var t=e[this.expando];return t||(t=Object.create(null),X(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[U(t)]=n;else for(r in t)i[U(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][U(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(U):(t=U(t))in r?[t]:t.match(O)||[]).length;for(;n--;)delete r[t[n]]}(void 0===t||b.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!b.isEmptyObject(t)}};var G=new V,Y=new V,Q=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,J=/[A-Z]/g;function K(e,t,n){var r;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(J,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n=function(e){return"true"===e||"false"!==e&&("null"===e?null:e===+e+""?+e:Q.test(e)?JSON.parse(e):e)}(n)}catch(e){}Y.set(e,t,n)}else n=void 0;return n}b.extend({hasData:function(e){return Y.hasData(e)||G.hasData(e)},data:function(e,t,n){return Y.access(e,t,n)},removeData:function(e,t){Y.remove(e,t)},_data:function(e,t,n){return G.access(e,t,n)},_removeData:function(e,t){G.remove(e,t)}}),b.fn.extend({data:function(e,t){var n,r,i,o=this[0],a=o&&o.attributes;if(void 0===e){if(this.length&&(i=Y.get(o),1===o.nodeType&&!G.get(o,"hasDataAttrs"))){for(n=a.length;n--;)a[n]&&0===(r=a[n].name).indexOf("data-")&&(r=U(r.slice(5)),K(o,r,i[r]));G.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof e?this.each((function(){Y.set(this,e)})):B(this,(function(t){var n;if(o&&void 0===t)return void 0!==(n=Y.get(o,e))||void 0!==(n=K(o,e))?n:void 0;this.each((function(){Y.set(this,e,t)}))}),null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each((function(){Y.remove(this,e)}))}}),b.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=G.get(e,t),n&&(!r||Array.isArray(n)?r=G.access(e,t,b.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,(function(){b.dequeue(e,t)}),o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return G.get(e,n)||G.access(e,n,{empty:b.Callbacks("once memory").add((function(){G.remove(e,[t+"queue",n])}))})}}),b.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?b.queue(this[0],e):void 0===t?this:this.each((function(){var n=b.queue(this,e,t);b._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&b.dequeue(this,e)}))},dequeue:function(e){return this.each((function(){b.dequeue(this,e)}))},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=b.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";a--;)(n=G.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var Z=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,ee=new RegExp("^(?:([+-])=|)("+Z+")([a-z%]*)$","i"),te=["Top","Right","Bottom","Left"],ne=v.documentElement,re=function(e){return b.contains(e.ownerDocument,e)},ie={composed:!0};ne.getRootNode&&(re=function(e){return b.contains(e.ownerDocument,e)||e.getRootNode(ie)===e.ownerDocument});var oe=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&re(e)&&"none"===b.css(e,"display")};function ae(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return b.css(e,t,"")},u=s(),l=n&&n[3]||(b.cssNumber[t]?"":"px"),c=e.nodeType&&(b.cssNumber[t]||"px"!==l&&+u)&&ee.exec(b.css(e,t));if(c&&c[3]!==l){for(u/=2,l=l||c[3],c=+u||1;a--;)b.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,b.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var se={};function ue(e){var t,n=e.ownerDocument,r=e.nodeName,i=se[r];return i||(t=n.body.appendChild(n.createElement(r)),i=b.css(t,"display"),t.parentNode.removeChild(t),"none"===i&&(i="block"),se[r]=i,i)}function le(e,t){for(var n,r,i=[],o=0,a=e.length;o<a;o++)(r=e[o]).style&&(n=r.style.display,t?("none"===n&&(i[o]=G.get(r,"display")||null,i[o]||(r.style.display="")),""===r.style.display&&oe(r)&&(i[o]=ue(r))):"none"!==n&&(i[o]="none",G.set(r,"display",n)));for(o=0;o<a;o++)null!=i[o]&&(e[o].style.display=i[o]);return e}b.fn.extend({show:function(){return le(this,!0)},hide:function(){return le(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each((function(){oe(this)?b(this).show():b(this).hide()}))}});var ce,fe,pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i;ce=v.createDocumentFragment().appendChild(v.createElement("div")),(fe=v.createElement("input")).setAttribute("type","radio"),fe.setAttribute("checked","checked"),fe.setAttribute("name","t"),ce.appendChild(fe),d.checkClone=ce.cloneNode(!0).cloneNode(!0).lastChild.checked,ce.innerHTML="<textarea>x</textarea>",d.noCloneChecked=!!ce.cloneNode(!0).lastChild.defaultValue,ce.innerHTML="<option></option>",d.option=!!ce.lastChild;var ge={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&k(e,t)?b.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)G.set(e[n],"globalEval",!t||G.get(t[n],"globalEval"))}ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td,d.option||(ge.optgroup=ge.option=[1,"<select multiple='multiple'>","</select>"]);var me=/<|&#?\w+;/;function xe(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===x(o))b.merge(p,o.nodeType?[o]:o);else if(me.test(o)){for(a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+b.htmlPrefilter(o)+u[2],c=u[0];c--;)a=a.lastChild;b.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));for(f.textContent="",d=0;o=p[d++];)if(r&&b.inArray(o,r)>-1)i&&i.push(o);else if(l=re(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n)for(c=0;o=a[c++];)he.test(o.type||"")&&n.push(o);return f}var be=/^key/,we=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Te=/^([^.]*)(?:\.(.+)|)/;function Ce(){return!0}function Ee(){return!1}function Se(e,t){return e===function(){try{return v.activeElement}catch(e){}}()==("focus"===t)}function ke(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)ke(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Ee;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return b().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=b.guid++)),e.each((function(){b.event.add(this,t,i,r,n)}))}function Ae(e,t,n){n?(G.set(e,t,!1),b.event.add(e,t,{namespace:!1,handler:function(e){var r,o,a=G.get(this,t);if(1&e.isTrigger&&this[t]){if(a.length)(b.event.special[t]||{}).delegateType&&e.stopPropagation();else if(a=i.call(arguments),G.set(this,t,a),r=n(this,t),this[t](),a!==(o=G.get(this,t))||r?G.set(this,t,!1):o={},a!==o)return e.stopImmediatePropagation(),e.preventDefault(),o.value}else a.length&&(G.set(this,t,{value:b.event.trigger(b.extend(a[0],b.Event.prototype),a.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===G.get(e,t)&&b.event.add(e,t,Ce)}b.event={global:{},add:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=G.get(e);if(X(e))for(n.handler&&(n=(o=n).handler,i=o.selector),i&&b.find.matchesSelector(ne,i),n.guid||(n.guid=b.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(t){return void 0!==b&&b.event.triggered!==t.type?b.event.dispatch.apply(e,arguments):void 0}),l=(t=(t||"").match(O)||[""]).length;l--;)d=g=(s=Te.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=b.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=b.event.special[d]||{},c=b.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&b.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(e,r,h,a)||e.addEventListener&&e.addEventListener(d,a)),f.add&&(f.add.call(e,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),b.event.global[d]=!0)},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=G.hasData(e)&&G.get(e);if(v&&(u=v.events)){for(l=(t=(t||"").match(O)||[""]).length;l--;)if(d=g=(s=Te.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){for(f=b.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;o--;)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||b.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(u)&&G.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=b.event.fix(e),l=(G.get(this,"events")||Object.create(null))[u.type]||[],c=b.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){for(a=b.event.handlers.call(this,u,l),t=0;(i=a[t++])&&!u.isPropagationStopped();)for(u.currentTarget=i.elem,n=0;(o=i.handlers[n++])&&!u.isImmediatePropagationStopped();)u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((b.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()));return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&e.button>=1))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?b(i,this).index(l)>-1:b.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(e,t){Object.defineProperty(b.Event.prototype,e,{enumerable:!0,configurable:!0,get:h(t)?function(){if(this.originalEvent)return t(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[e]},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})},fix:function(e){return e[b.expando]?e:new b.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&k(t,"input")&&Ae(t,"click",Ce),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&k(t,"input")&&Ae(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&k(t,"input")&&G.get(t,"click")||k(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},b.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},b.Event=function(e,t){if(!(this instanceof b.Event))return new b.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Ce:Ee,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&b.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[b.expando]=!0},b.Event.prototype={constructor:b.Event,isDefaultPrevented:Ee,isPropagationStopped:Ee,isImmediatePropagationStopped:Ee,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Ce,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Ce,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Ce,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},b.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&be.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&we.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},b.event.addProp),b.each({focus:"focusin",blur:"focusout"},(function(e,t){b.event.special[e]={setup:function(){return Ae(this,e,Se),!1},trigger:function(){return Ae(this,e),!0},delegateType:t}})),b.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},(function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,o=e.handleObj;return i&&(i===r||b.contains(r,i))||(e.type=o.origType,n=o.handler.apply(this,arguments),e.type=t),n}}})),b.fn.extend({on:function(e,t,n,r){return ke(this,e,t,n,r)},one:function(e,t,n,r){return ke(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,b(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Ee),this.each((function(){b.event.remove(this,e,n,t)}))}});var Ne=/<script|<style|<link/i,De=/checked\s*(?:[^=]|=\s*.checked.)/i,je=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function qe(e,t){return k(e,"table")&&k(11!==t.nodeType?t:t.firstChild,"tr")&&b(e).children("tbody")[0]||e}function Le(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function He(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Oe(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(G.hasData(e)&&(s=G.get(e).events))for(i in G.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)b.event.add(t,i,s[i][n]);Y.hasData(e)&&(o=Y.access(e),a=b.extend({},o),Y.set(t,a))}}function Pe(e,t){var n=t.nodeName.toLowerCase();"input"===n&&pe.test(e.type)?t.checked=e.checked:"input"!==n&&"textarea"!==n||(t.defaultValue=e.defaultValue)}function Re(e,t,n,r){t=o(t);var i,a,s,u,l,c,f=0,p=e.length,g=p-1,v=t[0],y=h(v);if(y||p>1&&"string"==typeof v&&!d.checkClone&&De.test(v))return e.each((function(i){var o=e.eq(i);y&&(t[0]=v.call(this,i,o.html())),Re(o,t,n,r)}));if(p&&(a=(i=xe(t,e[0].ownerDocument,!1,e,r)).firstChild,1===i.childNodes.length&&(i=a),a||r)){for(u=(s=b.map(ve(i,"script"),Le)).length;f<p;f++)l=i,f!==g&&(l=b.clone(l,!0,!0),u&&b.merge(s,ve(l,"script"))),n.call(e[f],l,f);if(u)for(c=s[s.length-1].ownerDocument,b.map(s,He),f=0;f<u;f++)l=s[f],he.test(l.type||"")&&!G.access(l,"globalEval")&&b.contains(c,l)&&(l.src&&"module"!==(l.type||"").toLowerCase()?b._evalUrl&&!l.noModule&&b._evalUrl(l.src,{nonce:l.nonce||l.getAttribute("nonce")},c):m(l.textContent.replace(je,""),l,c))}return e}function Me(e,t,n){for(var r,i=t?b.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||b.cleanData(ve(r)),r.parentNode&&(n&&re(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}b.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s=e.cloneNode(!0),u=re(e);if(!(d.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(a=ve(s),r=0,i=(o=ve(e)).length;r<i;r++)Pe(o[r],a[r]);if(t)if(n)for(o=o||ve(e),a=a||ve(s),r=0,i=o.length;r<i;r++)Oe(o[r],a[r]);else Oe(e,s);return(a=ve(s,"script")).length>0&&ye(a,!u&&ve(e,"script")),s},cleanData:function(e){for(var t,n,r,i=b.event.special,o=0;void 0!==(n=e[o]);o++)if(X(n)){if(t=n[G.expando]){if(t.events)for(r in t.events)i[r]?b.event.remove(n,r):b.removeEvent(n,r,t.handle);n[G.expando]=void 0}n[Y.expando]&&(n[Y.expando]=void 0)}}}),b.fn.extend({detach:function(e){return Me(this,e,!0)},remove:function(e){return Me(this,e)},text:function(e){return B(this,(function(e){return void 0===e?b.text(this):this.empty().each((function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)}))}),null,e,arguments.length)},append:function(){return Re(this,arguments,(function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||qe(this,e).appendChild(e)}))},prepend:function(){return Re(this,arguments,(function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=qe(this,e);t.insertBefore(e,t.firstChild)}}))},before:function(){return Re(this,arguments,(function(e){this.parentNode&&this.parentNode.insertBefore(e,this)}))},after:function(){return Re(this,arguments,(function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)}))},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(b.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map((function(){return b.clone(this,e,t)}))},html:function(e){return B(this,(function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Ne.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=b.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(b.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)}),null,e,arguments.length)},replaceWith:function(){var e=[];return Re(this,arguments,(function(t){var n=this.parentNode;b.inArray(this,e)<0&&(b.cleanData(ve(this)),n&&n.replaceChild(t,this))}),e)}}),b.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},(function(e,t){b.fn[e]=function(e){for(var n,r=[],i=b(e),o=i.length-1,s=0;s<=o;s++)n=s===o?this:this.clone(!0),b(i[s])[t](n),a.apply(r,n.get());return this.pushStack(r)}}));var Ie=new RegExp("^("+Z+")(?!px)[a-z%]+$","i"),We=function(t){var n=t.ownerDocument.defaultView;return n&&n.opener||(n=e),n.getComputedStyle(t)},Fe=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Be=new RegExp(te.join("|"),"i");function $e(e,t,n){var r,i,o,a,s=e.style;return(n=n||We(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||re(e)||(a=b.style(e,t)),!d.pixelBoxStyles()&&Ie.test(a)&&Be.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function _e(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function t(){if(c){l.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",c.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",ne.appendChild(l).appendChild(c);var t=e.getComputedStyle(c);r="1%"!==t.top,u=12===n(t.marginLeft),c.style.right="60%",a=36===n(t.right),i=36===n(t.width),c.style.position="absolute",o=12===n(c.offsetWidth/3),ne.removeChild(l),c=null}}function n(e){return Math.round(parseFloat(e))}var r,i,o,a,s,u,l=v.createElement("div"),c=v.createElement("div");c.style&&(c.style.backgroundClip="content-box",c.cloneNode(!0).style.backgroundClip="",d.clearCloneStyle="content-box"===c.style.backgroundClip,b.extend(d,{boxSizingReliable:function(){return t(),i},pixelBoxStyles:function(){return t(),a},pixelPosition:function(){return t(),r},reliableMarginLeft:function(){return t(),u},scrollboxSize:function(){return t(),o},reliableTrDimensions:function(){var t,n,r,i;return null==s&&(t=v.createElement("table"),n=v.createElement("tr"),r=v.createElement("div"),t.style.cssText="position:absolute;left:-11111px",n.style.height="1px",r.style.height="9px",ne.appendChild(t).appendChild(n).appendChild(r),i=e.getComputedStyle(n),s=parseInt(i.height)>3,ne.removeChild(t)),s}}))}();var ze=["Webkit","Moz","ms"],Ue=v.createElement("div").style,Xe={};function Ve(e){var t=b.cssProps[e]||Xe[e];return t||(e in Ue?e:Xe[e]=function(e){for(var t=e[0].toUpperCase()+e.slice(1),n=ze.length;n--;)if((e=ze[n]+t)in Ue)return e}(e)||e)}var Ge=/^(none|table(?!-c[ea]).+)/,Ye=/^--/,Qe={position:"absolute",visibility:"hidden",display:"block"},Je={letterSpacing:"0",fontWeight:"400"};function Ke(e,t,n){var r=ee.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Ze(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=b.css(e,n+te[a],!0,i)),r?("content"===n&&(u-=b.css(e,"padding"+te[a],!0,i)),"margin"!==n&&(u-=b.css(e,"border"+te[a]+"Width",!0,i))):(u+=b.css(e,"padding"+te[a],!0,i),"padding"!==n?u+=b.css(e,"border"+te[a]+"Width",!0,i):s+=b.css(e,"border"+te[a]+"Width",!0,i));return!r&&o>=0&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function et(e,t,n){var r=We(e),i=(!d.boxSizingReliable()||n)&&"border-box"===b.css(e,"boxSizing",!1,r),o=i,a=$e(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Ie.test(a)){if(!n)return a;a="auto"}return(!d.boxSizingReliable()&&i||!d.reliableTrDimensions()&&k(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===b.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===b.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Ze(e,t,n||(i?"border":"content"),o,r,a)+"px"}function tt(e,t,n,r,i){return new tt.prototype.init(e,t,n,r,i)}b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=$e(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=U(t),u=Ye.test(t),l=e.style;if(u||(t=Ve(s)),a=b.cssHooks[t]||b.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=ee.exec(n))&&i[1]&&(n=ae(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(b.cssNumber[s]?"":"px")),d.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=U(t);return Ye.test(t)||(t=Ve(s)),(a=b.cssHooks[t]||b.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=$e(e,t,r)),"normal"===i&&t in Je&&(i=Je[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),b.each(["height","width"],(function(e,t){b.cssHooks[t]={get:function(e,n,r){if(n)return!Ge.test(b.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?et(e,t,r):Fe(e,Qe,(function(){return et(e,t,r)}))},set:function(e,n,r){var i,o=We(e),a=!d.scrollboxSize()&&"absolute"===o.position,s=(a||r)&&"border-box"===b.css(e,"boxSizing",!1,o),u=r?Ze(e,t,r,s,o):0;return s&&a&&(u-=Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-parseFloat(o[t])-Ze(e,t,"border",!1,o)-.5)),u&&(i=ee.exec(n))&&"px"!==(i[3]||"px")&&(e.style[t]=n,n=b.css(e,t)),Ke(0,n,u)}}})),b.cssHooks.marginLeft=_e(d.reliableMarginLeft,(function(e,t){if(t)return(parseFloat($e(e,"marginLeft"))||e.getBoundingClientRect().left-Fe(e,{marginLeft:0},(function(){return e.getBoundingClientRect().left})))+"px"})),b.each({margin:"",padding:"",border:"Width"},(function(e,t){b.cssHooks[e+t]={expand:function(n){for(var r=0,i={},o="string"==typeof n?n.split(" "):[n];r<4;r++)i[e+te[r]+t]=o[r]||o[r-2]||o[0];return i}},"margin"!==e&&(b.cssHooks[e+t].set=Ke)})),b.fn.extend({css:function(e,t){return B(this,(function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=We(e),i=t.length;a<i;a++)o[t[a]]=b.css(e,t[a],!1,r);return o}return void 0!==n?b.style(e,t,n):b.css(e,t)}),e,t,arguments.length>1)}}),b.Tween=tt,tt.prototype={constructor:tt,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||b.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?"":"px")},cur:function(){var e=tt.propHooks[this.prop];return e&&e.get?e.get(this):tt.propHooks._default.get(this)},run:function(e){var t,n=tt.propHooks[this.prop];return this.options.duration?this.pos=t=b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):tt.propHooks._default.set(this),this}},tt.prototype.init.prototype=tt.prototype,tt.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=b.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):1!==e.elem.nodeType||!b.cssHooks[e.prop]&&null==e.elem.style[Ve(e.prop)]?e.elem[e.prop]=e.now:b.style(e.elem,e.prop,e.now+e.unit)}}},tt.propHooks.scrollTop=tt.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},b.fx=tt.prototype.init,b.fx.step={};var nt,rt,it=/^(?:toggle|show|hide)$/,ot=/queueHooks$/;function at(){rt&&(!1===v.hidden&&e.requestAnimationFrame?e.requestAnimationFrame(at):e.setTimeout(at,b.fx.interval),b.fx.tick())}function st(){return e.setTimeout((function(){nt=void 0})),nt=Date.now()}function ut(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=te[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function lt(e,t,n){for(var r,i=(ct.tweeners[t]||[]).concat(ct.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function ct(e,t,n){var r,i,o=0,a=ct.prefilters.length,s=b.Deferred().always((function(){delete u.elem})),u=function(){if(i)return!1;for(var t=nt||st(),n=Math.max(0,l.startTime+l.duration-t),r=1-(n/l.duration||0),o=0,a=l.tweens.length;o<a;o++)l.tweens[o].run(r);return s.notifyWith(e,[l,r,n]),r<1&&a?n:(a||s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{},easing:b.easing._default},n),originalProperties:t,originalOptions:n,startTime:nt||st(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;n<r;n++)l.tweens[n].run(1);return t?(s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l,t])):s.rejectWith(e,[l,t]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=U(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=b.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);o<a;o++)if(r=ct.prefilters[o].call(l,e,c,l.opts))return h(r.stop)&&(b._queueHooks(l.elem,l.opts.queue).stop=r.stop.bind(r)),r;return b.map(c,lt,l),h(l.opts.start)&&l.opts.start.call(e,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l}b.Animation=b.extend(ct,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return ae(n.elem,e,ee.exec(t),n),n}]},tweener:function(e,t){h(e)?(t=e,e=["*"]):e=e.match(O);for(var n,r=0,i=e.length;r<i;r++)n=e[r],ct.tweeners[n]=ct.tweeners[n]||[],ct.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&oe(e),v=G.get(e,"fxshow");for(r in n.queue||(null==(a=b._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always((function(){p.always((function(){a.unqueued--,b.queue(e,"fx").length||a.empty.fire()}))}))),t)if(i=t[r],it.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||b.style(e,r)}if((u=!b.isEmptyObject(t))||!b.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=G.get(e,"display")),"none"===(c=b.css(e,"display"))&&(l?c=l:(le([e],!0),l=e.style.display||l,c=b.css(e,"display"),le([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===b.css(e,"float")&&(u||(p.done((function(){h.display=l})),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always((function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]}))),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=G.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&le([e],!0),p.done((function(){for(r in g||le([e]),G.remove(e,"fxshow"),d)b.style(e,r,d[r])}))),u=lt(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?ct.prefilters.unshift(e):ct.prefilters.push(e)}}),b.speed=function(e,t,n){var r=e&&"object"==typeof e?b.extend({},e):{complete:n||!n&&t||h(e)&&e,duration:e,easing:n&&t||t&&!h(t)&&t};return b.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in b.fx.speeds?r.duration=b.fx.speeds[r.duration]:r.duration=b.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){h(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(oe).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=ct(this,b.extend({},e),o);(i||G.get(this,"finish"))&&t.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(e,t,n){var r=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&this.queue(e||"fx",[]),this.each((function(){var t=!0,i=null!=e&&e+"queueHooks",o=b.timers,a=G.get(this);if(i)a[i]&&a[i].stop&&r(a[i]);else for(i in a)a[i]&&a[i].stop&&ot.test(i)&&r(a[i]);for(i=o.length;i--;)o[i].elem!==this||null!=e&&o[i].queue!==e||(o[i].anim.stop(n),t=!1,o.splice(i,1));!t&&n||b.dequeue(this,e)}))},finish:function(e){return!1!==e&&(e=e||"fx"),this.each((function(){var t,n=G.get(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.stop&&i.stop.call(this,!0),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;t<a;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish}))}}),b.each(["toggle","show","hide"],(function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(ut(t,!0),e,r,i)}})),b.each({slideDown:ut("show"),slideUp:ut("hide"),slideToggle:ut("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},(function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}})),b.timers=[],b.fx.tick=function(){var e,t=0,n=b.timers;for(nt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||b.fx.stop(),nt=void 0},b.fx.timer=function(e){b.timers.push(e),b.fx.start()},b.fx.interval=13,b.fx.start=function(){rt||(rt=!0,at())},b.fx.stop=function(){rt=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fn.delay=function(t,n){return t=b.fx&&b.fx.speeds[t]||t,n=n||"fx",this.queue(n,(function(n,r){var i=e.setTimeout(n,t);r.stop=function(){e.clearTimeout(i)}}))},function(){var e=v.createElement("input"),t=v.createElement("select").appendChild(v.createElement("option"));e.type="checkbox",d.checkOn=""!==e.value,d.optSelected=t.selected,(e=v.createElement("input")).value="t",e.type="radio",d.radioValue="t"===e.value}();var ft,pt=b.expr.attrHandle;b.fn.extend({attr:function(e,t){return B(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each((function(){b.removeAttr(this,e)}))}}),b.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return void 0===e.getAttribute?b.prop(e,t,n):(1===o&&b.isXMLDoc(e)||(i=b.attrHooks[t.toLowerCase()]||(b.expr.match.bool.test(t)?ft:void 0)),void 0!==n?null===n?void b.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=b.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!d.radioValue&&"radio"===t&&k(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(O);if(i&&1===e.nodeType)for(;n=i[r++];)e.removeAttribute(n)}}),ft={set:function(e,t,n){return!1===t?b.removeAttr(e,n):e.setAttribute(n,n),n}},b.each(b.expr.match.bool.source.match(/\w+/g),(function(e,t){var n=pt[t]||b.find.attr;pt[t]=function(e,t,r){var i,o,a=t.toLowerCase();return r||(o=pt[a],pt[a]=i,i=null!=n(e,t,r)?a:null,pt[a]=o),i}}));var dt=/^(?:input|select|textarea|button)$/i,ht=/^(?:a|area)$/i;function gt(e){return(e.match(O)||[]).join(" ")}function vt(e){return e.getAttribute&&e.getAttribute("class")||""}function yt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(O)||[]}b.fn.extend({prop:function(e,t){return B(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each((function(){delete this[b.propFix[e]||e]}))}}),b.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&b.isXMLDoc(e)||(t=b.propFix[t]||t,i=b.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=b.find.attr(e,"tabindex");return t?parseInt(t,10):dt.test(e.nodeName)||ht.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),d.optSelected||(b.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),b.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],(function(){b.propFix[this.toLowerCase()]=this})),b.fn.extend({addClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e))return this.each((function(t){b(this).addClass(e.call(this,t,vt(this)))}));if((t=yt(e)).length)for(;n=this[u++];)if(i=vt(n),r=1===n.nodeType&&" "+gt(i)+" "){for(a=0;o=t[a++];)r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=gt(r))&&n.setAttribute("class",s)}return this},removeClass:function(e){var t,n,r,i,o,a,s,u=0;if(h(e))return this.each((function(t){b(this).removeClass(e.call(this,t,vt(this)))}));if(!arguments.length)return this.attr("class","");if((t=yt(e)).length)for(;n=this[u++];)if(i=vt(n),r=1===n.nodeType&&" "+gt(i)+" "){for(a=0;o=t[a++];)for(;r.indexOf(" "+o+" ")>-1;)r=r.replace(" "+o+" "," ");i!==(s=gt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(e,t){var n=typeof e,r="string"===n||Array.isArray(e);return"boolean"==typeof t&&r?t?this.addClass(e):this.removeClass(e):h(e)?this.each((function(n){b(this).toggleClass(e.call(this,n,vt(this),t),t)})):this.each((function(){var t,i,o,a;if(r)for(i=0,o=b(this),a=yt(e);t=a[i++];)o.hasClass(t)?o.removeClass(t):o.addClass(t);else void 0!==e&&"boolean"!==n||((t=vt(this))&&G.set(this,"__className__",t),this.setAttribute&&this.setAttribute("class",t||!1===e?"":G.get(this,"__className__")||""))}))},hasClass:function(e){var t,n,r=0;for(t=" "+e+" ";n=this[r++];)if(1===n.nodeType&&(" "+gt(vt(n))+" ").indexOf(t)>-1)return!0;return!1}});var mt=/\r/g;b.fn.extend({val:function(e){var t,n,r,i=this[0];return arguments.length?(r=h(e),this.each((function(n){var i;1===this.nodeType&&(null==(i=r?e.call(this,n,b(this).val()):e)?i="":"number"==typeof i?i+="":Array.isArray(i)&&(i=b.map(i,(function(e){return null==e?"":e+""}))),(t=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()])&&"set"in t&&void 0!==t.set(this,i,"value")||(this.value=i))}))):i?(t=b.valHooks[i.type]||b.valHooks[i.nodeName.toLowerCase()])&&"get"in t&&void 0!==(n=t.get(i,"value"))?n:"string"==typeof(n=i.value)?n.replace(mt,""):null==n?"":n:void 0}}),b.extend({valHooks:{option:{get:function(e){var t=b.find.attr(e,"value");return null!=t?t:gt(b.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!k(n.parentNode,"optgroup"))){if(t=b(n).val(),a)return t;s.push(t)}return s},set:function(e,t){for(var n,r,i=e.options,o=b.makeArray(t),a=i.length;a--;)((r=i[a]).selected=b.inArray(b.valHooks.option.get(r),o)>-1)&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),b.each(["radio","checkbox"],(function(){b.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=b.inArray(b(e).val(),t)>-1}},d.checkOn||(b.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})})),d.focusin="onfocusin"in e;var xt=/^(?:focusinfocus|focusoutblur)$/,bt=function(e){e.stopPropagation()};b.extend(b.event,{trigger:function(t,n,r,i){var o,a,s,u,l,f,p,d,y=[r||v],m=c.call(t,"type")?t.type:t,x=c.call(t,"namespace")?t.namespace.split("."):[];if(a=d=s=r=r||v,3!==r.nodeType&&8!==r.nodeType&&!xt.test(m+b.event.triggered)&&(m.indexOf(".")>-1&&(x=m.split("."),m=x.shift(),x.sort()),l=m.indexOf(":")<0&&"on"+m,(t=t[b.expando]?t:new b.Event(m,"object"==typeof t&&t)).isTrigger=i?2:3,t.namespace=x.join("."),t.rnamespace=t.namespace?new RegExp("(^|\\.)"+x.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=r),n=null==n?[t]:b.makeArray(n,[t]),p=b.event.special[m]||{},i||!p.trigger||!1!==p.trigger.apply(r,n))){if(!i&&!p.noBubble&&!g(r)){for(u=p.delegateType||m,xt.test(u+m)||(a=a.parentNode);a;a=a.parentNode)y.push(a),s=a;s===(r.ownerDocument||v)&&y.push(s.defaultView||s.parentWindow||e)}for(o=0;(a=y[o++])&&!t.isPropagationStopped();)d=a,t.type=o>1?u:p.bindType||m,(f=(G.get(a,"events")||Object.create(null))[t.type]&&G.get(a,"handle"))&&f.apply(a,n),(f=l&&a[l])&&f.apply&&X(a)&&(t.result=f.apply(a,n),!1===t.result&&t.preventDefault());return t.type=m,i||t.isDefaultPrevented()||p._default&&!1!==p._default.apply(y.pop(),n)||!X(r)||l&&h(r[m])&&!g(r)&&((s=r[l])&&(r[l]=null),b.event.triggered=m,t.isPropagationStopped()&&d.addEventListener(m,bt),r[m](),t.isPropagationStopped()&&d.removeEventListener(m,bt),b.event.triggered=void 0,s&&(r[l]=s)),t.result}},simulate:function(e,t,n){var r=b.extend(new b.Event,n,{type:e,isSimulated:!0});b.event.trigger(r,null,t)}}),b.fn.extend({trigger:function(e,t){return this.each((function(){b.event.trigger(e,t,this)}))},triggerHandler:function(e,t){var n=this[0];if(n)return b.event.trigger(e,t,n,!0)}}),d.focusin||b.each({focus:"focusin",blur:"focusout"},(function(e,t){var n=function(e){b.event.simulate(t,e.target,b.event.fix(e))};b.event.special[t]={setup:function(){var r=this.ownerDocument||this.document||this,i=G.access(r,t);i||r.addEventListener(e,n,!0),G.access(r,t,(i||0)+1)},teardown:function(){var r=this.ownerDocument||this.document||this,i=G.access(r,t)-1;i?G.access(r,t,i):(r.removeEventListener(e,n,!0),G.remove(r,t))}}}));var wt=e.location,Tt={guid:Date.now()},Ct=/\?/;b.parseXML=function(t){var n;if(!t||"string"!=typeof t)return null;try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){n=void 0}return n&&!n.getElementsByTagName("parsererror").length||b.error("Invalid XML: "+t),n};var Et=/\[\]$/,St=/\r?\n/g,kt=/^(?:submit|button|image|reset|file)$/i,At=/^(?:input|select|textarea|keygen)/i;function Nt(e,t,n,r){var i;if(Array.isArray(t))b.each(t,(function(t,i){n||Et.test(e)?r(e,i):Nt(e+"["+("object"==typeof i&&null!=i?t:"")+"]",i,n,r)}));else if(n||"object"!==x(t))r(e,t);else for(i in t)Nt(e+"["+i+"]",t[i],n,r)}b.param=function(e,t){var n,r=[],i=function(e,t){var n=h(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,(function(){i(this.name,this.value)}));else for(n in e)Nt(n,e[n],t,i);return r.join("&")},b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map((function(){var e=b.prop(this,"elements");return e?b.makeArray(e):this})).filter((function(){var e=this.type;return this.name&&!b(this).is(":disabled")&&At.test(this.nodeName)&&!kt.test(e)&&(this.checked||!pe.test(e))})).map((function(e,t){var n=b(this).val();return null==n?null:Array.isArray(n)?b.map(n,(function(e){return{name:t.name,value:e.replace(St,"\r\n")}})):{name:t.name,value:n.replace(St,"\r\n")}})).get()}});var Dt=/%20/g,jt=/#.*$/,qt=/([?&])_=[^&]*/,Lt=/^(.*?):[ \t]*([^\r\n]*)$/gm,Ht=/^(?:GET|HEAD)$/,Ot=/^\/\//,Pt={},Rt={},Mt="*/".concat("*"),It=v.createElement("a");function Wt(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var r,i=0,o=t.toLowerCase().match(O)||[];if(h(n))for(;r=o[i++];)"+"===r[0]?(r=r.slice(1)||"*",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function Ft(e,t,n,r){var i={},o=e===Rt;function a(s){var u;return i[s]=!0,b.each(e[s]||[],(function(e,s){var l=s(t,n,r);return"string"!=typeof l||o||i[l]?o?!(u=l):void 0:(t.dataTypes.unshift(l),a(l),!1)})),u}return a(t.dataTypes[0])||!i["*"]&&a("*")}function Bt(e,t){var n,r,i=b.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&b.extend(!0,e,r),e}It.href=wt.href,b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:wt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(wt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Mt,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Bt(Bt(e,b.ajaxSettings),t):Bt(b.ajaxSettings,e)},ajaxPrefilter:Wt(Pt),ajaxTransport:Wt(Rt),ajax:function(t,n){"object"==typeof t&&(n=t,t=void 0),n=n||{};var r,i,o,a,s,u,l,c,f,p,d=b.ajaxSetup({},n),h=d.context||d,g=d.context&&(h.nodeType||h.jquery)?b(h):b.event,y=b.Deferred(),m=b.Callbacks("once memory"),x=d.statusCode||{},w={},T={},C="canceled",E={readyState:0,getResponseHeader:function(e){var t;if(l){if(!a)for(a={};t=Lt.exec(o);)a[t[1].toLowerCase()+" "]=(a[t[1].toLowerCase()+" "]||[]).concat(t[2]);t=a[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return l?o:null},setRequestHeader:function(e,t){return null==l&&(e=T[e.toLowerCase()]=T[e.toLowerCase()]||e,w[e]=t),this},overrideMimeType:function(e){return null==l&&(d.mimeType=e),this},statusCode:function(e){var t;if(e)if(l)E.always(e[E.status]);else for(t in e)x[t]=[x[t],e[t]];return this},abort:function(e){var t=e||C;return r&&r.abort(t),S(0,t),this}};if(y.promise(E),d.url=((t||d.url||wt.href)+"").replace(Ot,wt.protocol+"//"),d.type=n.method||n.type||d.method||d.type,d.dataTypes=(d.dataType||"*").toLowerCase().match(O)||[""],null==d.crossDomain){u=v.createElement("a");try{u.href=d.url,u.href=u.href,d.crossDomain=It.protocol+"//"+It.host!=u.protocol+"//"+u.host}catch(e){d.crossDomain=!0}}if(d.data&&d.processData&&"string"!=typeof d.data&&(d.data=b.param(d.data,d.traditional)),Ft(Pt,d,n,E),l)return E;for(f in(c=b.event&&d.global)&&0==b.active++&&b.event.trigger("ajaxStart"),d.type=d.type.toUpperCase(),d.hasContent=!Ht.test(d.type),i=d.url.replace(jt,""),d.hasContent?d.data&&d.processData&&0===(d.contentType||"").indexOf("application/x-www-form-urlencoded")&&(d.data=d.data.replace(Dt,"+")):(p=d.url.slice(i.length),d.data&&(d.processData||"string"==typeof d.data)&&(i+=(Ct.test(i)?"&":"?")+d.data,delete d.data),!1===d.cache&&(i=i.replace(qt,"$1"),p=(Ct.test(i)?"&":"?")+"_="+Tt.guid+++p),d.url=i+p),d.ifModified&&(b.lastModified[i]&&E.setRequestHeader("If-Modified-Since",b.lastModified[i]),b.etag[i]&&E.setRequestHeader("If-None-Match",b.etag[i])),(d.data&&d.hasContent&&!1!==d.contentType||n.contentType)&&E.setRequestHeader("Content-Type",d.contentType),E.setRequestHeader("Accept",d.dataTypes[0]&&d.accepts[d.dataTypes[0]]?d.accepts[d.dataTypes[0]]+("*"!==d.dataTypes[0]?", "+Mt+"; q=0.01":""):d.accepts["*"]),d.headers)E.setRequestHeader(f,d.headers[f]);if(d.beforeSend&&(!1===d.beforeSend.call(h,E,d)||l))return E.abort();if(C="abort",m.add(d.complete),E.done(d.success),E.fail(d.error),r=Ft(Rt,d,n,E)){if(E.readyState=1,c&&g.trigger("ajaxSend",[E,d]),l)return E;d.async&&d.timeout>0&&(s=e.setTimeout((function(){E.abort("timeout")}),d.timeout));try{l=!1,r.send(w,S)}catch(e){if(l)throw e;S(-1,e)}}else S(-1,"No Transport");function S(t,n,a,u){var f,p,v,w,T,C=n;l||(l=!0,s&&e.clearTimeout(s),r=void 0,o=u||"",E.readyState=t>0?4:0,f=t>=200&&t<300||304===t,a&&(w=function(e,t,n){for(var r,i,o,a,s=e.contents,u=e.dataTypes;"*"===u[0];)u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(d,E,a)),!f&&b.inArray("script",d.dataTypes)>-1&&(d.converters["text script"]=function(){}),w=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];for(o=c.shift();o;)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e.throws)t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(d,w,E,f),f?(d.ifModified&&((T=E.getResponseHeader("Last-Modified"))&&(b.lastModified[i]=T),(T=E.getResponseHeader("etag"))&&(b.etag[i]=T)),204===t||"HEAD"===d.type?C="nocontent":304===t?C="notmodified":(C=w.state,p=w.data,f=!(v=w.error))):(v=C,!t&&C||(C="error",t<0&&(t=0))),E.status=t,E.statusText=(n||C)+"",f?y.resolveWith(h,[p,C,E]):y.rejectWith(h,[E,C,v]),E.statusCode(x),x=void 0,c&&g.trigger(f?"ajaxSuccess":"ajaxError",[E,d,f?p:v]),m.fireWith(h,[E,C]),c&&(g.trigger("ajaxComplete",[E,d]),--b.active||b.event.trigger("ajaxStop")))}return E},getJSON:function(e,t,n){return b.get(e,t,n,"json")},getScript:function(e,t){return b.get(e,void 0,t,"script")}}),b.each(["get","post"],(function(e,t){b[t]=function(e,n,r,i){return h(n)&&(i=i||r,r=n,n=void 0),b.ajax(b.extend({url:e,type:t,dataType:i,data:n,success:r},b.isPlainObject(e)&&e))}})),b.ajaxPrefilter((function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")})),b._evalUrl=function(e,t,n){return b.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){b.globalEval(e,t,n)}})},b.fn.extend({wrapAll:function(e){var t;return this[0]&&(h(e)&&(e=e.call(this[0])),t=b(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map((function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e})).append(this)),this},wrapInner:function(e){return h(e)?this.each((function(t){b(this).wrapInner(e.call(this,t))})):this.each((function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)}))},wrap:function(e){var t=h(e);return this.each((function(n){b(this).wrapAll(t?e.call(this,n):e)}))},unwrap:function(e){return this.parent(e).not("body").each((function(){b(this).replaceWith(this.childNodes)})),this}}),b.expr.pseudos.hidden=function(e){return!b.expr.pseudos.visible(e)},b.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},b.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var $t={0:200,1223:204},_t=b.ajaxSettings.xhr();d.cors=!!_t&&"withCredentials"in _t,d.ajax=_t=!!_t,b.ajaxTransport((function(t){var n,r;if(d.cors||_t&&!t.crossDomain)return{send:function(i,o){var a,s=t.xhr();if(s.open(t.type,t.url,t.async,t.username,t.password),t.xhrFields)for(a in t.xhrFields)s[a]=t.xhrFields[a];for(a in t.mimeType&&s.overrideMimeType&&s.overrideMimeType(t.mimeType),t.crossDomain||i["X-Requested-With"]||(i["X-Requested-With"]="XMLHttpRequest"),i)s.setRequestHeader(a,i[a]);n=function(e){return function(){n&&(n=r=s.onload=s.onerror=s.onabort=s.ontimeout=s.onreadystatechange=null,"abort"===e?s.abort():"error"===e?"number"!=typeof s.status?o(0,"error"):o(s.status,s.statusText):o($t[s.status]||s.status,s.statusText,"text"!==(s.responseType||"text")||"string"!=typeof s.responseText?{binary:s.response}:{text:s.responseText},s.getAllResponseHeaders()))}},s.onload=n(),r=s.onerror=s.ontimeout=n("error"),void 0!==s.onabort?s.onabort=r:s.onreadystatechange=function(){4===s.readyState&&e.setTimeout((function(){n&&r()}))},n=n("abort");try{s.send(t.hasContent&&t.data||null)}catch(e){if(n)throw e}},abort:function(){n&&n()}}})),b.ajaxPrefilter((function(e){e.crossDomain&&(e.contents.script=!1)})),b.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter("script",(function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")})),b.ajaxTransport("script",(function(e){var t,n;if(e.crossDomain||e.scriptAttrs)return{send:function(r,i){t=b("<script>").attr(e.scriptAttrs||{}).prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&i("error"===e.type?404:200,e.type)}),v.head.appendChild(t[0])},abort:function(){n&&n()}}}));var zt,Ut=[],Xt=/(=)\?(?=&|$)|\?\?/;b.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Ut.pop()||b.expando+"_"+Tt.guid++;return this[e]=!0,e}}),b.ajaxPrefilter("json jsonp",(function(t,n,r){var i,o,a,s=!1!==t.jsonp&&(Xt.test(t.url)?"url":"string"==typeof t.data&&0===(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Xt.test(t.data)&&"data");if(s||"jsonp"===t.dataTypes[0])return i=t.jsonpCallback=h(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,s?t[s]=t[s].replace(Xt,"$1"+i):!1!==t.jsonp&&(t.url+=(Ct.test(t.url)?"&":"?")+t.jsonp+"="+i),t.converters["script json"]=function(){return a||b.error(i+" was not called"),a[0]},t.dataTypes[0]="json",o=e[i],e[i]=function(){a=arguments},r.always((function(){void 0===o?b(e).removeProp(i):e[i]=o,t[i]&&(t.jsonpCallback=n.jsonpCallback,Ut.push(i)),a&&h(o)&&o(a[0]),a=o=void 0})),"script"})),d.createHTMLDocument=((zt=v.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===zt.childNodes.length),b.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(d.createHTMLDocument?((r=(t=v.implementation.createHTMLDocument("")).createElement("base")).href=v.location.href,t.head.appendChild(r)):t=v),o=!n&&[],(i=A.exec(e))?[t.createElement(i[1])]:(i=xe([e],t,o),o&&o.length&&b(o).remove(),b.merge([],i.childNodes)));var r,i,o},b.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return s>-1&&(r=gt(e.slice(s)),e=e.slice(0,s)),h(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),a.length>0&&b.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done((function(e){o=arguments,a.html(r?b("<div>").append(b.parseHTML(e)).find(r):e)})).always(n&&function(e,t){a.each((function(){n.apply(this,o||[e.responseText,t,e])}))}),this},b.expr.pseudos.animated=function(e){return b.grep(b.timers,(function(t){return e===t.elem})).length},b.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=b.css(e,"position"),c=b(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=b.css(e,"top"),u=b.css(e,"left"),("absolute"===l||"fixed"===l)&&(o+u).indexOf("auto")>-1?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),h(t)&&(t=t.call(e,n,b.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):("number"==typeof f.top&&(f.top+="px"),"number"==typeof f.left&&(f.left+="px"),c.css(f))}},b.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each((function(t){b.offset.setOffset(this,e,t)}));var t,n,r=this[0];return r?r.getClientRects().length?(t=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:t.top+n.pageYOffset,left:t.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===b.css(r,"position"))t=r.getBoundingClientRect();else{for(t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;e&&(e===n.body||e===n.documentElement)&&"static"===b.css(e,"position");)e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=b(e).offset()).top+=b.css(e,"borderTopWidth",!0),i.left+=b.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-b.css(r,"marginTop",!0),left:t.left-i.left-b.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map((function(){for(var e=this.offsetParent;e&&"static"===b.css(e,"position");)e=e.offsetParent;return e||ne}))}}),b.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},(function(e,t){var n="pageYOffset"===t;b.fn[e]=function(r){return B(this,(function(e,r,i){var o;if(g(e)?o=e:9===e.nodeType&&(o=e.defaultView),void 0===i)return o?o[t]:e[r];o?o.scrollTo(n?o.pageXOffset:i,n?i:o.pageYOffset):e[r]=i}),e,r,arguments.length)}})),b.each(["top","left"],(function(e,t){b.cssHooks[t]=_e(d.pixelPosition,(function(e,n){if(n)return n=$e(e,t),Ie.test(n)?b(e).position()[t]+"px":n}))})),b.each({Height:"height",Width:"width"},(function(e,t){b.each({padding:"inner"+e,content:t,"":"outer"+e},(function(n,r){b.fn[r]=function(i,o){var a=arguments.length&&(n||"boolean"!=typeof i),s=n||(!0===i||!0===o?"margin":"border");return B(this,(function(t,n,i){var o;return g(t)?0===r.indexOf("outer")?t["inner"+e]:t.document.documentElement["client"+e]:9===t.nodeType?(o=t.documentElement,Math.max(t.body["scroll"+e],o["scroll"+e],t.body["offset"+e],o["offset"+e],o["client"+e])):void 0===i?b.css(t,n,s):b.style(t,n,i,s)}),t,a?i:void 0,a)}}))})),b.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],(function(e,t){b.fn[t]=function(e){return this.on(t,e)}})),b.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),b.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),(function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}));var Vt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;b.proxy=function(e,t){var n,r,o;if("string"==typeof t&&(n=e[t],t=e,e=n),h(e))return r=i.call(arguments,2),(o=function(){return e.apply(t||this,r.concat(i.call(arguments)))}).guid=e.guid=e.guid||b.guid++,o},b.holdReady=function(e){e?b.readyWait++:b.ready(!0)},b.isArray=Array.isArray,b.parseJSON=JSON.parse,b.nodeName=k,b.isFunction=h,b.isWindow=g,b.camelCase=U,b.type=x,b.now=Date.now,b.isNumeric=function(e){var t=b.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},b.trim=function(e){return null==e?"":(e+"").replace(Vt,"")},"function"==typeof define&&define.amd&&define("jquery",[],(function(){return b}));var Gt=e.jQuery,Yt=e.$;return b.noConflict=function(t){return e.$===b&&(e.$=Yt),t&&e.jQuery===b&&(e.jQuery=Gt),b},void 0===t&&(e.jQuery=e.$=b),b}))},
445: function _(t,i,n){function o(){var t=!1,i=!1;this.stopPropagation=function(){t=!0},this.isPropagationStopped=function(){return t},this.stopImmediatePropagation=function(){i=!0},this.isImmediatePropagationStopped=function(){return i}}function e(){this.__nonDataRow=!0}function r(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function s(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function l(){var t=null;this.isActive=function(i){return i?t===i:null!==t},this.activate=function(i){if(i!==t){if(null!==t)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!i.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!i.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");t=i}},this.deactivate=function(i){if(t!==i)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");t=null},this.commitCurrentEdit=function(){return!t||t.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!t||t.cancelCurrentEdit()}}r.prototype=new e,r.prototype.equals=function(t){return this.value===t.value&&this.count===t.count&&this.collapsed===t.collapsed&&this.title===t.title},s.prototype=new e,i.exports={Event:function(){var t=[];this.subscribe=function(i){t.push(i)},this.unsubscribe=function(i){for(var n=t.length-1;n>=0;n--)t[n]===i&&t.splice(n,1)},this.notify=function(i,n,e){var r;n=n||new o,e=e||this;for(var s=0;s<t.length&&!n.isPropagationStopped()&&!n.isImmediatePropagationStopped();s++)r=t[s].call(e,n,i);return r}},EventData:o,EventHandler:function(){var t=[];this.subscribe=function(i,n){return t.push({event:i,handler:n}),i.subscribe(n),this},this.unsubscribe=function(i,n){for(var o=t.length;o--;)if(t[o].event===i&&t[o].handler===n)return t.splice(o,1),void i.unsubscribe(n);return this},this.unsubscribeAll=function(){for(var i=t.length;i--;)t[i].event.unsubscribe(t[i].handler);return t=[],this}},Range:function(t,i,n,o){void 0===n&&void 0===o&&(n=t,o=i),this.fromRow=Math.min(t,n),this.fromCell=Math.min(i,o),this.toRow=Math.max(t,n),this.toCell=Math.max(i,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(t,i){return t>=this.fromRow&&t<=this.toRow&&i>=this.fromCell&&i<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:e,Group:r,GroupTotals:s,EditorLock:l,GlobalEditorLock:new l,keyCode:{BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,C:67,V:86},preClickClassName:"slick-edit-preclick"}},
446: function _(e,t,o){var l=e(443),c=e(445);t.exports={CheckboxSelectColumn:function(e){var t,o=g(),n=new c.EventHandler,i={},r=!1,d=l.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,hideSelectAllCheckbox:!1,toolTip:"Select/Deselect All",width:30,hideInColumnTitleRow:!1,hideInFilterHeaderRow:!0},e);function a(){t.updateColumnHeader(d.columnId,"","")}function s(){l("#filter-checkbox-selectall-container").hide()}function u(e,c){var n,a,s=t.getSelectedRows(),u={};for(a=0;a<s.length;a++)u[n=s[a]]=!0,u[n]!==i[n]&&(t.invalidateRow(n),delete i[n]);for(a in i)t.invalidateRow(a);(i=u,t.render(),r=s.length&&s.length==t.getDataLength(),d.hideInColumnTitleRow||d.hideSelectAllCheckbox||(r?t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox' checked='checked'><label for='header-selector"+o+"'></label>",d.toolTip):t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",d.toolTip)),d.hideInFilterHeaderRow)||l("#header-filter-selector"+o).prop("checked",r)}function h(e,o){32==e.which&&t.getColumns()[o.cell].id===d.columnId&&(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit()||p(o.row),e.preventDefault(),e.stopImmediatePropagation())}function f(e,o){if(t.getColumns()[o.cell].id===d.columnId&&l(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();p(o.row),e.stopPropagation(),e.stopImmediatePropagation()}}function p(e){i[e]?t.setSelectedRows(l.grep(t.getSelectedRows(),(function(t){return t!=e}))):t.setSelectedRows(t.getSelectedRows().concat(e)),t.setActiveCell(e,function(){if(null===m){m=0;for(var e=t.getColumns(),o=0;o<e.length;o++)e[o].id==d.columnId&&(m=o)}return m}()),t.focus()}function b(e,o){if(o.column.id==d.columnId&&l(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(l(e.target).is(":checked")){for(var c=[],n=0;n<t.getDataLength();n++)c.push(n);t.setSelectedRows(c)}else t.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}var m=null;function g(){return Math.round(1e7*Math.random())}function k(e,t,o,l,c){var n=g()+e;return c?i[e]?"<input id='selector"+n+"' type='checkbox' checked='checked'><label for='selector"+n+"'></label>":"<input id='selector"+n+"' type='checkbox'><label for='selector"+n+"'></label>":null}l.extend(this,{init:function(e){t=e,n.subscribe(t.onSelectedRowsChanged,u).subscribe(t.onClick,f).subscribe(t.onKeyDown,h),d.hideInFilterHeaderRow||function(e){e.onHeaderRowCellRendered.subscribe((function(e,t){"sel"===t.column.field&&(l(t.node).empty(),l("<span id='filter-checkbox-selectall-container'><input id='header-filter-selector"+o+"' type='checkbox'><label for='header-filter-selector"+o+"'></label></span>").appendTo(t.node).on("click",(function(e){b(e,t)})))}))}(e),d.hideInColumnTitleRow||n.subscribe(t.onHeaderClick,b)},destroy:function(){n.unsubscribeAll()},deSelectRows:function(e){var o,c=e.length,n=[];for(o=0;o<c;o++)i[e[o]]&&(n[n.length]=e[o]);t.setSelectedRows(l.grep(t.getSelectedRows(),(function(e){return n.indexOf(e)<0})))},selectRows:function(e){var o,l=e.length,c=[];for(o=0;o<l;o++)i[e[o]]||(c[c.length]=e[o]);t.setSelectedRows(t.getSelectedRows().concat(c))},getColumnDefinition:function(){return{id:d.columnId,name:d.hideSelectAllCheckbox||d.hideInColumnTitleRow?"":"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",toolTip:d.toolTip,field:"sel",width:d.width,resizable:!1,sortable:!1,cssClass:d.cssClass,hideSelectAllCheckbox:d.hideSelectAllCheckbox,formatter:k}},getOptions:function(){return d},setOptions:function(e){if((d=l.extend(!0,{},d,e)).hideSelectAllCheckbox)a(),s();else if(d.hideInColumnTitleRow?a():(r?t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox' checked='checked'><label for='header-selector"+o+"'></label>",d.toolTip):t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",d.toolTip),n.subscribe(t.onHeaderClick,b)),d.hideInFilterHeaderRow)s();else{var c=l("#filter-checkbox-selectall-container");c.show(),c.find('input[type="checkbox"]').prop("checked",r)}}})}}},
447: function _(e,t,o){var l=e(443),n=e(445),a=n.keyCode;t.exports={CellExternalCopyManager:function(e){var t,o,r=this,i=e||{},s=i.copiedCellStyleLayerKey||"copy-manager",u=i.copiedCellStyle||"copied",c=0,d=i.bodyElement||document.body,f=i.onCopyInit||null,h=i.onCopySuccess||null;function C(e){if(i.headerColumnValueExtractor){var t=i.headerColumnValueExtractor(e);if(t)return t}return e.name}function m(e,o,n){if(i.dataItemColumnValueExtractor){var a=i.dataItemColumnValueExtractor(e,o);if(a)return a}var r="";if(o.editor){var s={container:l("<p>"),column:o,position:{top:0,left:0},grid:t,event:n},u=new o.editor(s);u.loadValue(e),r=u.serializeValue(),u.destroy()}else r=e[o.field];return r}function g(e,o,n){if(i.dataItemColumnValueSetter)return i.dataItemColumnValueSetter(e,o,n);if(o.editor){var a={container:l("body"),column:o,position:{top:0,left:0},grid:t},r=new o.editor(a);r.loadValue(e),r.applyValue(e,n),r.destroy()}else e[o.field]=n}function p(e){var t=document.createElement("textarea");return t.style.position="absolute",t.style.left="-1000px",t.style.top=document.body.scrollTop+"px",t.value=e,d.appendChild(t),t.select(),t}function y(e,l){var n;if(!t.getEditorLock().isActive()||t.getOptions().autoEdit){if(e.which==a.ESC&&o&&(e.preventDefault(),w(),r.onCopyCancelled.notify({ranges:o}),o=null),(e.which===a.C||e.which===a.INSERT)&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&(f&&f.call(),0!=(n=t.getSelectionModel().getSelectedRanges()).length)){o=n,v(n),r.onCopyCells.notify({ranges:n});for(var s=t.getColumns(),u="",c=0;c<n.length;c++){for(var y=n[c],D=[],S=y.fromRow;S<y.toRow+1;S++){var R=[],x=t.getDataItem(S);if(""==D&&i.includeHeaderWhenCopying){for(var V=[],E=y.fromCell;E<y.toCell+1;E++)s[E].name.length>0&&V.push(C(s[E]));D.push(V.join("\t"))}for(E=y.fromCell;E<y.toCell+1;E++)R.push(m(x,s[E],e));D.push(R.join("\t"))}u+=D.join("\r\n")+"\r\n"}if(window.clipboardData)return window.clipboardData.setData("Text",u),!0;var b=document.activeElement;if((M=p(u)).focus(),setTimeout((function(){d.removeChild(M),b?b.focus():console.log("Not element to restore focus to after copy?")}),100),h){var I=0;I=1===n.length?n[0].toRow+1-n[0].fromRow:n.length,h.call(this,I)}return!1}if(!i.readOnlyMode&&(e.which===a.V&&(e.ctrlKey||e.metaKey)&&!e.shiftKey||e.which===a.INSERT&&e.shiftKey&&!e.ctrlKey)){var M=p("");return setTimeout((function(){!function(e,t){var o=e.getColumns(),l=t.value.split(/[\n\f\r]/);""==l[l.length-1]&&l.pop();var n=[],a=0;d.removeChild(t);for(var s=0;s<l.length;s++)""!=l[s]?n[a++]=l[s].split("\t"):n[s]=[""];var u=e.getActiveCell(),c=e.getSelectionModel().getSelectedRanges(),f=c&&c.length?c[0]:null,h=null,C=null;if(f)h=f.fromRow,C=f.fromCell;else{if(!u)return;h=u.row,C=u.cell}var m=!1,p=n.length,y=n.length?n[0].length:0;1==n.length&&1==n[0].length&&f&&(m=!0,p=f.toRow-f.fromRow+1,y=f.toCell-f.fromCell+1);var w=e.getData().length-h,D=0;if(w<p&&i.newRowCreator){var S=e.getData();for(D=1;D<=p-w;D++)S.push({});e.setData(S),e.render()}var R=h+p>e.getDataLength();if(i.newRowCreator&&R){var x=h+p-e.getDataLength();i.newRowCreator(x)}var V={isClipboardCommand:!0,clippedRange:n,oldValues:[],cellExternalCopyManager:r,_options:i,setDataItemValueForColumn:g,markCopySelection:v,oneCellToMultiple:m,activeRow:h,activeCell:C,destH:p,destW:y,maxDestY:e.getDataLength(),maxDestX:e.getColumns().length,h:0,w:0,execute:function(){this.h=0;for(var t=0;t<this.destH;t++){this.oldValues[t]=[],this.w=0,this.h++;for(var l=0;l<this.destW;l++){this.w++;var a=h+t,r=C+l;if(a<this.maxDestY&&r<this.maxDestX){e.getCellNode(a,r);var i=e.getDataItem(a);this.oldValues[t][l]=i[o[r].field],m?this.setDataItemValueForColumn(i,o[r],n[0][0]):this.setDataItemValueForColumn(i,o[r],n[t]?n[t][l]:""),e.updateCell(a,r),e.onCellChange.notify({row:a,cell:r,item:i,grid:e})}}}var s={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};this.markCopySelection([s]),e.getSelectionModel().setSelectedRanges([s]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[s]})},undo:function(){for(var t=0;t<this.destH;t++)for(var l=0;l<this.destW;l++){var n=h+t,a=C+l;if(n<this.maxDestY&&a<this.maxDestX){e.getCellNode(n,a);var r=e.getDataItem(n);m?this.setDataItemValueForColumn(r,o[a],this.oldValues[0][0]):this.setDataItemValueForColumn(r,o[a],this.oldValues[t][l]),e.updateCell(n,a),e.onCellChange.notify({row:n,cell:a,item:r,grid:e})}}var i={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};if(this.markCopySelection([i]),e.getSelectionModel().setSelectedRanges([i]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[i]}),D>1){for(var s=e.getData();D>1;D--)s.splice(s.length-1,1);e.setData(s),e.render()}}};i.clipboardCommandHandler?i.clipboardCommandHandler(V):V.execute()}(t,M)}),100),!1}}}function v(e){w();for(var o=t.getColumns(),l={},n=0;n<e.length;n++)for(var a=e[n].fromRow;a<=e[n].toRow;a++){l[a]={};for(var i=e[n].fromCell;i<=e[n].toCell&&i<o.length;i++)l[a][o[i].id]=u}t.setCellCssStyles(s,l),clearTimeout(c),c=setTimeout((function(){r.clearCopySelection()}),2e3)}function w(){t.removeCellCssStyles(s)}l.extend(this,{init:function(e){(t=e).onKeyDown.subscribe(y);var o=e.getSelectionModel();if(!o)throw new Error("Selection model is mandatory for this plugin. Please set a selection model on the grid before adding this plugin: grid.setSelectionModel(new Slick.CellSelectionModel())");o.onSelectedRangesChanged.subscribe((function(e,o){t.focus()}))},destroy:function(){t.onKeyDown.unsubscribe(y)},clearCopySelection:w,handleKeyDown:y,onCopyCells:new n.Event,onCopyCancelled:new n.Event,onPasteCells:new n.Event,setIncludeHeaderWhenCopying:function(e){i.includeHeaderWhenCopying=e}})}}},
448: function _(r,t,o){var _=r(1);_.__exportStar(r(445),t.exports),_.__exportStar(r(449),t.exports),_.__exportStar(r(452),t.exports),_.__exportStar(r(453),t.exports),_.__exportStar(r(454),t.exports),_.__exportStar(r(455),t.exports),_.__exportStar(r(456),t.exports)},
449: function _(require,module,exports){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.3
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(443),Slick=require(445),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(450),$.fn.drop||require(451);var defaults={alwaysShowVerticalScroll:!1,explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,suppressActiveCellChangeOnEdit:!1,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,sortColNumberInSeparateSpan:!1,defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0,viewportClass:null,minRowBuffer:3,emulatePagingWhenScrolling:!0,editorCellNavOnLRKeys:!1},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacer,$footerRow,$footerRowScroller,$footerRowSpacer,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,tabbingDirection=1,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,scrollThrottle=ActionThrottle(render,50),h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[],columnResizeDragging=!1;function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,columnsById={};for(var e=0;e<columns.length;e++){var o=columns[e]=$.extend({},columnDefaults,columns[e]);columnsById[o.id]=e,o.minWidth&&o.width<o.minWidth&&(o.width=o.minWidth),o.maxWidth&&o.width>o.maxWidth&&(o.width=o.maxWidth)}if(options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");editController={commitCurrentEdit,cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScroller),options.showPreHeaderPanel||$preHeaderPanelScroller.hide()),$headerScroller=$("<div class='slick-header ui-state-default' />").appendTo($container),$headers=$("<div class='slick-header-columns' style='left:-1000px' />").appendTo($headerScroller),$headerRowScroller=$("<div class='slick-headerrow ui-state-default' />").appendTo($container),$headerRow=$("<div class='slick-headerrow-columns' />").appendTo($headerRowScroller),$headerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScroller),$topPanelScroller=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($container),$topPanel=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),($viewport=$("<div class='slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container)).css("overflow-y",options.alwaysShowVerticalScroll?"scroll":options.autoHeight?"hidden":"auto"),$viewport.css("overflow-x",options.forceFitColumns?"hidden":"auto"),options.viewportClass&&$viewport.toggleClass(options.viewportClass,!0),$canvas=$("<div class='grid-canvas' />").appendTo($viewport),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),$preHeaderPanelSpacer&&$preHeaderPanelSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headers.width(getHeadersWidth()),$headerRowSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),options.createFooterRow&&($footerRowScroller=$("<div class='slick-footerrow ui-state-default' />").appendTo($container),$footerRow=$("<div class='slick-footerrow-columns' />").appendTo($footerRowScroller),$footerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScroller),options.showFooterRow||$footerRowScroller.hide()),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,viewportW=parseFloat($.css($container[0],"width",!0)),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",(function(e){return $(e.target).is("input,textarea")})),updateColumnCaches(),createColumnHeaders(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&$footerRowScroller.on("scroll",handleFooterRowScroll),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),navigator.userAgent.toLowerCase().match(/webkit/)&&navigator.userAgent.toLowerCase().match(/macintosh/)&&$canvas.on("mousewheel",handleMouseWheel),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each((function(){var e={};for(var o in cssShow)e[o]=this.style[o],this.style[o]=cssShow[o];oldProps.push(e)}))}function restoreCssFromHiddenInit(){$hiddenParents.each((function(e){var o=oldProps[e];for(var t in cssShow)this.style[t]=o[t]}))}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var o=plugins.length;o>=0;o--)if(plugins[o]===e){plugins[o].destroy&&plugins[o].destroy(),plugins.splice(o,1);break}}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(){return $canvas[0]}function measureScrollbar(){var e=$('<div class="'+$viewport.className+'" style="position:absolute; top:-10000px; left:-10000px; overflow:auto; width:100px; height:100px;"></div>').appendTo($viewport),o=$('<div style="width:200px; height:200px; overflow:auto;"></div>').appendTo(e),t={width:e[0].offsetWidth-e[0].clientWidth,height:e[0].offsetHeight-e[0].clientHeight};return o.remove(),e.remove(),t}function getColumnTotalWidth(e){for(var o=0,t=0,l=columns.length;t<l;t++){o+=columns[t].width}return e&&(o+=scrollbarDimensions.width),o}function getHeadersWidth(){var e=getColumnTotalWidth(!options.autoHeight);return Math.max(e,viewportW)+1e3}function getCanvasWidth(){for(var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,o=0,t=columns.length;t--;)o+=columns[t].width;return options.fullWidthRows?Math.max(o,e):o}function updateCanvasWidth(e){var o=canvasWidth;(canvasWidth=getCanvasWidth())!=o&&($canvas.width(canvasWidth),$headerRow.width(canvasWidth),options.createFooterRow&&$footerRow.width(canvasWidth),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$headers.width(getHeadersWidth()),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width);var t=canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0);$headerRowSpacer.width(t),options.createFooterRow&&$footerRowSpacer.width(t),options.createPreHeaderPanel&&$preHeaderPanelSpacer.width(t),(canvasWidth!=o||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",(function(){return!1}))}function getMaxSupportedCssHeight(){for(var e=1e6,o=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,t=$("<div style='display:none' />").appendTo(document.body);;){var l=2*e;if(t.css("height",l),l>o||t.height()!==l)break;e=l}return t.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=$canvas[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewport[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var o=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(o):o,o.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,o,t){if(initialized){var l=getColumnIndex(e);if(null!=l){var n=columns[l],r=$headers.children().eq(l);r&&(void 0!==o&&(columns[l].name=o),void 0!==t&&(columns[l].toolTip=t),trigger(self.onBeforeHeaderCellDestroy,{node:r[0],column:n,grid:self}),r.attr("title",t||"").children().eq(0).html(o),trigger(self.onHeaderCellRendered,{node:r[0],column:n,grid:self}))}}}function getHeader(){return $headers[0]}function getHeaderColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$headers.children().eq(o);return t&&t[0]}function getHeaderRow(){return $headerRow[0]}function getFooterRow(){return $footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getHeaderRowColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$headerRow.children().eq(o);return t&&t[0]}function getFooterRowColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$footerRow.children().eq(o);return t&&t[0]}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function o(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})})),$headers.empty(),$headers.width(getHeadersWidth()),$headerRow.find(".slick-headerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})})),$headerRow.empty(),options.createFooterRow&&($footerRow.find(".slick-footerrow-column").each((function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e})})),$footerRow.empty());for(var t=0;t<columns.length;t++){var l=columns[t],n=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+l.name+"</span>").width(l.width-headerColumnWidthDiff).attr("id",""+uid+l.id).attr("title",l.toolTip||"").data("column",l).addClass(l.headerCssClass||"").appendTo($headers);if((options.enableColumnReorder||l.sortable)&&n.on("mouseenter",e).on("mouseleave",o),l.sortable&&(n.addClass("slick-header-sortable"),n.append("<span class='slick-sort-indicator"+(options.numberedMultiColumnSort&&!options.sortColNumberInSeparateSpan?" slick-sort-indicator-numbered":"")+"' />"),options.numberedMultiColumnSort&&options.sortColNumberInSeparateSpan&&n.append("<span class='slick-sort-indicator-numbered' />")),trigger(self.onHeaderCellRendered,{node:n[0],column:l,grid:self}),options.showHeaderRow){var r=$("<div class='ui-state-default slick-headerrow-column l"+t+" r"+t+"'></div>").data("column",l).appendTo($headerRow);trigger(self.onHeaderRowCellRendered,{node:r[0],column:l,grid:self})}if(options.createFooterRow&&options.showFooterRow){var i=$("<div class='ui-state-default slick-footerrow-column l"+t+" r"+t+"'></div>").data("column",l).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:i[0],column:l})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click((function(e){if(!columnResizeDragging&&(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle"))){var o=$(e.target).closest(".slick-header-column");if(o.length){var t=o.data("column");if(t.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var l=null,n=0;n<sortColumns.length;n++)if(sortColumns[n].columnId==t.id){(l=sortColumns[n]).sortAsc=!l.sortAsc;break}var r=!!l;options.tristateMultiColumnSort?(l||(l={columnId:t.id,sortAsc:t.defaultSortAsc}),r&&l.sortAsc&&(sortColumns.splice(n,1),l=null),options.multiColumnSort||(sortColumns=[]),!l||r&&options.multiColumnSort||sortColumns.push(l)):e.metaKey&&options.multiColumnSort?l&&sortColumns.splice(n,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),l?0==sortColumns.length&&sortColumns.push(l):(l={columnId:t.id,sortAsc:t.defaultSortAsc},sortColumns.push(l))),setSortColumns(sortColumns),options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,(function(e){return{sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}}))},e):trigger(self.onSort,{multiColumnSort:!1,sortCol:sortColumns.length>0?t:null,sortAsc:!(sortColumns.length>0)||sortColumns[0].sortAsc},e)}}}}))}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy"),$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(e,o){o.placeholder.width(o.helper.outerWidth()-headerColumnWidthDiff),$(o.helper).addClass("slick-header-column-active")},beforeStop:function(e,o){$(o.helper).removeClass("slick-header-column-active")},stop:function(e){if(getEditorLock().commitCurrentEdit()){for(var o=$headers.sortable("toArray"),t=[],l=0;l<o.length;l++)t.push(columns[getColumnIndex(o[l].replace(uid,""))]);setColumns(t),trigger(self.onColumnsReordered,{}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function setupColumnResize(){var e,o,t,l,n,r,i,s;(l=$headers.children()).find(".slick-resizable-handle").remove(),l.each((function(e,o){e>=columns.length||columns[e].resizable&&(void 0===i&&(i=e),s=e)})),void 0!==i&&l.each((function(a,c){a>=columns.length||a<i||options.forceFitColumns&&a>=s||($(c),$("<div class='slick-resizable-handle' />").appendTo(c).on("dragstart",(function(i,s){if(!getEditorLock().commitCurrentEdit())return!1;t=i.pageX,$(this).parent().addClass("slick-header-column-active");var c=null,d=null;if(l.each((function(e,o){e>=columns.length||(columns[e].previousWidth=$(o).outerWidth())})),options.forceFitColumns)for(c=0,d=0,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(null!==d&&(o.maxWidth?d+=o.maxWidth-o.previousWidth:d=null),c+=o.previousWidth-Math.max(o.minWidth||0,absoluteColumnMinWidth));var u=0,h=0;for(e=0;e<=a;e++)(o=columns[e]).resizable&&(null!==h&&(o.maxWidth?h+=o.maxWidth-o.previousWidth:h=null),u+=o.previousWidth-Math.max(o.minWidth||0,absoluteColumnMinWidth));null===c&&(c=1e5),null===u&&(u=1e5),null===d&&(d=1e5),null===h&&(h=1e5),r=t+Math.min(c,h),n=t-Math.min(u,d)})).on("drag",(function(l,i){columnResizeDragging=!0;var s,c,d=Math.min(r,Math.max(n,l.pageX))-t;if(d<0){for(c=d,e=a;e>=0;e--)(o=columns[e]).resizable&&(s=Math.max(o.minWidth||0,absoluteColumnMinWidth),c&&o.previousWidth+c<s?(c+=o.previousWidth-s,o.width=s):(o.width=o.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-d,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(c&&o.maxWidth&&o.maxWidth-o.previousWidth<c?(c-=o.maxWidth-o.previousWidth,o.width=o.maxWidth):(o.width=o.previousWidth+c,c=0))}else{for(c=d,e=a;e>=0;e--)(o=columns[e]).resizable&&(c&&o.maxWidth&&o.maxWidth-o.previousWidth<c?(c-=o.maxWidth-o.previousWidth,o.width=o.maxWidth):(o.width=o.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-d,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(s=Math.max(o.minWidth||0,absoluteColumnMinWidth),c&&o.previousWidth+c<s?(c+=o.previousWidth-s,o.width=s):(o.width=o.previousWidth+c,c=0))}applyColumnHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths()})).on("dragend",(function(t,n){var r;for($(this).parent().removeClass("slick-header-column-active"),e=0;e<columns.length;e++)o=columns[e],r=$(l[e]).outerWidth(),o.previousWidth!==r&&o.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{}),setTimeout((function(){columnResizeDragging=!1}),300)})))}))}function getVBoxDelta(e){var o=0;return $.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],(function(t,l){o+=parseFloat(e.css(l))||0})),o}function measureCellPaddingAndBorder(){var e,o=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],t=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],l=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==l[0]&&l[1]>=8||l[0]>=2,e=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,(function(o,t){headerColumnWidthDiff+=parseFloat(e.css(t))||0})),$.each(t,(function(o,t){headerColumnHeightDiff+=parseFloat(e.css(t))||0}))),e.remove();var n=$("<div class='slick-row' />").appendTo($canvas);e=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(n),cellWidthDiff=cellHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,(function(o,t){cellWidthDiff+=parseFloat(e.css(t))||0})),$.each(t,(function(o,t){cellHeightDiff+=parseFloat(e.css(t))||0}))),n.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,o=["."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],t=0;t<columns.length;t++)o.push("."+uid+" .l"+t+" { }"),o.push("."+uid+" .r"+t+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=o.join(" "):$style[0].appendChild(document.createTextNode(o.join(" ")))}function getColumnCssRules(e){var o;if(!stylesheet){var t=document.styleSheets;for(o=0;o<t.length;o++)if((t[o].ownerNode||t[o].owningElement)==$style[0]){stylesheet=t[o];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var l,n,r=stylesheet.cssRules||stylesheet.rules;for(o=0;o<r.length;o++){var i=r[o].selectorText;(l=/\.l\d+/.exec(i))?(n=parseInt(l[0].substr(2,l[0].length-2),10),columnCssRulesL[n]=r[o]):(l=/\.r\d+/.exec(i))&&(n=parseInt(l[0].substr(2,l[0].length-2),10),columnCssRulesR[n]=r[o])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}function trigger(e,o,t){return t=t||new Slick.EventData,(o=o||{}).grid=self,e.notify(o,t,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function autosizeColumns(){var e,o,t,l=[],n=0,r=0,i=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)o=columns[e],l.push(o.width),r+=o.width,o.resizable&&(n+=o.width-Math.max(o.minWidth,absoluteColumnMinWidth));for(t=r;r>i&&n;){var s=(r-i)/n;for(e=0;e<columns.length&&r>i;e++){o=columns[e];var a=l[e];if(!(!o.resizable||a<=o.minWidth||a<=absoluteColumnMinWidth)){var c=Math.max(o.minWidth,absoluteColumnMinWidth),d=Math.floor(s*(a-c))||1;r-=d=Math.min(d,a-c),n-=d,l[e]-=d}}if(t<=r)break;t=r}for(t=r;r<i;){var u=i/r;for(e=0;e<columns.length&&r<i;e++){o=columns[e];var h,p=l[e];r+=h=!o.resizable||o.maxWidth<=p?0:Math.min(Math.floor(u*p)-p,o.maxWidth-p||1e6)||1,l[e]+=r<=i?h:0}if(t>=r)break;t=r}var g=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=l[e]&&(g=!0),columns[e].width=l[e];applyColumnHeaderWidths(),updateCanvasWidth(!0),trigger(self.onAutosizeColumns,{columns}),g&&(invalidateAllRows(),render())}function applyColumnHeaderWidths(){if(initialized){for(var e,o=0,t=$headers.children(),l=columns.length;o<l;o++)e=$(t[o]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[o].width&&e.outerWidth(columns[o].width):e.width()!==columns[o].width-headerColumnWidthDiff&&e.width(columns[o].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,o,t=0,l=0;l<columns.length;l++)e=columns[l].width,(o=getColumnCssRules(l)).left.style.left=t+"px",o.right.style.right=canvasWidth-t-e+"px",t+=columns[l].width}function setSortColumn(e,o){setSortColumns([{columnId:e,sortAsc:o}])}function setSortColumns(e){sortColumns=e;var o=options.numberedMultiColumnSort&&sortColumns.length>1,t=$headers.children();t.removeClass("slick-header-column-sorted").find(".slick-sort-indicator").removeClass("slick-sort-indicator-asc slick-sort-indicator-desc"),t.find(".slick-sort-indicator-numbered").text(""),$.each(sortColumns,(function(e,l){null==l.sortAsc&&(l.sortAsc=!0);var n=getColumnIndex(l.columnId);null!=n&&(t.eq(n).addClass("slick-header-column-sorted").find(".slick-sort-indicator").addClass(l.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),o&&t.eq(n).find(".slick-sort-indicator-numbered").text(e+1))}))}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,o){selectedRows=[];for(var t={},l=0;l<o.length;l++)for(var n=o[l].fromRow;n<=o[l].toRow;n++){t[n]||(selectedRows.push(n),t[n]={});for(var r=o[l].fromCell;r<=o[l].toCell;r++)canCellBeSelected(n,r)&&(t[n][columns[r].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,t),trigger(self.onSelectedRowsChanged,{rows:getSelectedRows()},e)}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,o=0,t=columns.length;o<t;o++)columnPosLeft[o]=e,columnPosRight[o]=e+columns[o].width,e+=columns[o].width}function setColumns(e){columns=e,columnsById={};for(var o=0;o<columns.length;o++){var t=columns[o]=$.extend({},columnDefaults,columns[o]);columnsById[t.id]=o,t.minWidth&&t.width<t.minWidth&&(t.width=t.minWidth),t.maxWidth&&t.width>t.maxWidth&&(t.width=t.maxWidth)}updateColumnCaches(),initialized&&(invalidateAllRows(),createColumnHeaders(),removeCssRules(),createCssRules(),resizeCanvas(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,o){getEditorLock().commitCurrentEdit()&&(makeActiveCellNormal(),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength()),options=$.extend(options,e),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),o||render())}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1)}function setData(e,o){data=e,invalidateAllRows(),updateRowCount(),o&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data.length}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e){options.showTopPanel!=e&&(options.showTopPanel=e,e?$topPanelScroller.slideDown("fast",resizeCanvas):$topPanelScroller.slideUp("fast",resizeCanvas))}function setHeaderRowVisibility(e){options.showHeaderRow!=e&&(options.showHeaderRow=e,e?$headerRowScroller.slideDown("fast",resizeCanvas):$headerRowScroller.slideUp("fast",resizeCanvas))}function setFooterRowVisibility(e){options.showFooterRow!=e&&(options.showFooterRow=e,e?$footerRowScroller.slideDown("fast",resizeCanvas):$footerRowScroller.slideUp("fast",resizeCanvas))}function setPreHeaderPanelVisibility(e){options.showPreHeaderPanel!=e&&(options.showPreHeaderPanel=e,e?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):$preHeaderPanelScroller.slideUp("fast",resizeCanvas))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0));var o=offset;page=Math.min(n-1,Math.floor(e/ph));var t=e-(offset=Math.round(page*cj));offset!=o&&(cleanupRows(getVisibleRange(t)),updateRowPositions());prevScrollTop!=t&&(vScrollDir=prevScrollTop+o<t+offset?1:-1,$viewport[0].scrollTop=lastRenderedScrollTop=scrollTop=prevScrollTop=t,trigger(self.onViewportChanged,{}))}function defaultFormatter(e,o,t,l,n,r){return null==t?"":(t+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e),l=t&&t.columns&&(t.columns[o.id]||t.columns[getColumnIndex(o.id)]);return l&&l.formatter||t&&t.formatter||o.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(o)||options.defaultFormatter}function getEditor(e,o){var t=columns[o],l=data.getItemMetadata&&data.getItemMetadata(e),n=l&&l.columns;return n&&n[t.id]&&void 0!==n[t.id].editor?n[t.id].editor:n&&n[o]&&void 0!==n[o].editor?n[o].editor:t.editor||options.editorFactory&&options.editorFactory.getEditor(t)}function getDataItemValueForColumn(e,o){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,o):e[o.field]}function appendRowHtml(e,o,t,l){var n=getDataItem(o),r="slick-row"+(o<l&&!n?" loading":"")+(o===activeRow&&options.showCellSelection?" active":"")+(o%2==1?" odd":" even");n||(r+=" "+options.addNewRowCssClass);var i,s,a=data.getItemMetadata&&data.getItemMetadata(o);a&&a.cssClasses&&(r+=" "+a.cssClasses),e.push("<div class='ui-widget-content "+r+"' style='top:"+getRowTop(o)+"px'>");for(var c=0,d=columns.length;c<d;c++){if(s=columns[c],i=1,a&&a.columns){var u=a.columns[s.id]||a.columns[c];"*"===(i=u&&u.colspan||1)&&(i=d-c)}if(columnPosRight[Math.min(d-1,c+i-1)]>t.leftPx){if(columnPosLeft[c]>t.rightPx)break;appendCellHtml(e,o,c,i,n)}i>1&&(c+=i-1)}e.push("</div>")}function appendCellHtml(e,o,t,l,n){var r=columns[t],i="slick-cell l"+t+" r"+Math.min(columns.length-1,t+l-1)+(r.cssClass?" "+r.cssClass:"");for(var s in o===activeRow&&t===activeCell&&options.showCellSelection&&(i+=" active"),cellCssClasses)cellCssClasses[s][o]&&cellCssClasses[s][o][r.id]&&(i+=" "+cellCssClasses[s][o][r.id]);var a=null,c="";n&&(a=getDataItemValueForColumn(n,r),null==(c=getFormatter(o,r)(o,t,a,r,n,self))&&(c=""));var d=trigger(self.onBeforeAppendCell,{row:o,cell:t,value:a,dataContext:n})||"";d+=c&&c.addClasses?(d?" ":"")+c.addClasses:"",e.push("<div class='"+i+(d?" "+d:"")+"'>"),n&&e.push("[object Object]"!==Object.prototype.toString.call(c)?c:c.text),e.push("</div>"),rowsCache[o].cellRenderQueue.push(t),rowsCache[o].cellColSpans[t]=l}function cleanupRows(e){for(var o in rowsCache)(o=parseInt(o,10))!==activeRow&&(o<e.top||o>e.bottom)&&removeRowFromCache(o);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,o,t){for(var l in postProcessgroupId++,o)o.hasOwnProperty(l)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|l],columnIdx:0|l,rowIdx:t});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,o,t){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:o,rowIdx:t}),$(e).detach()}function removeRowFromCache(e){var o=rowsCache[e];o&&(o.rowNode&&(rowNodeFromLastMouseWheelEvent===o.rowNode?(o.rowNode.style.display="none",zombieRowNodeFromLastMouseWheelEvent=rowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent=o,zombieRowPostProcessedFromLastMouseWheelEvent=postProcessedRows[e]):options.enableAsyncPostRenderCleanup&&postProcessedRows[e]?queuePostProcessedRowForCleanup(o,postProcessedRows[e],e):$canvas[0].removeChild(o.rowNode)),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var o,t;if(e&&e.length){for(vScrollDir=0,t=e.length,o=0;o<t;o++)currentEditor&&activeRow===e[o]&&makeActiveCellNormal(),rowsCache[e[o]]&&removeRowFromCache(e[o]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){(e||0===e)&&invalidateRows([e])}function applyFormatResultToCellNode(e,o,t){null==e&&(e=""),"[object Object]"===Object.prototype.toString.call(e)?(o.innerHTML=e.text,e.removeClasses&&!t&&$(o).removeClass(e.removeClasses),e.addClasses&&$(o).addClass(e.addClasses)):o.innerHTML=e}function updateCell(e,o){var t=getCellNode(e,o);if(t){var l=columns[o],n=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===o)currentEditor.loadValue(n);else applyFormatResultToCellNode(n?getFormatter(e,l)(e,o,getDataItemValueForColumn(n,l),l,n,self):"",t),invalidatePostProcessingResults(e)}}function updateRow(e){var o=rowsCache[e];if(o){ensureCellNodesInRowsCache(e);var t=getDataItem(e);for(var l in o.cellNodesByColumnIdx)if(o.cellNodesByColumnIdx.hasOwnProperty(l)){var n=columns[l|=0],r=o.cellNodesByColumnIdx[l];e===activeRow&&l===activeCell&&currentEditor?currentEditor.loadValue(t):t?applyFormatResultToCellNode(getFormatter(e,n)(e,l,getDataItemValueForColumn(t,n),n,t,self),r):r.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){return parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-parseFloat($.css($headerScroller[0],"height"))-getVBoxDelta($headerScroller)-(options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0)-(options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0)-(options.createFooterRow&&options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0)-(options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0)}function resizeCanvas(){initialized&&(viewportH=options.autoHeight?options.rowHeight*getDataLengthIncludingAddNew():getViewportHeight(),numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportW=parseFloat($.css($container[0],"width",!0)),options.autoHeight||$viewport.height(viewportH),scrollbarDimensions&&scrollbarDimensions.width||(scrollbarDimensions=measureScrollbar()),options.forceFitColumns&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render())}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),o=getDataLengthIncludingAddNew()+(options.leaveSpaceForNewRows?numVisibleRows-1:0),t=viewportHasVScroll;viewportHasVScroll=options.alwaysShowVerticalScroll||!options.autoHeight&&o*options.rowHeight>viewportH,viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width,makeActiveCellNormal();var l=e-1;for(var r in rowsCache)r>l&&removeRowFromCache(r);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&activeRow>l&&resetActiveCell();var i=h;(th=Math.max(options.rowHeight*o,viewportH-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==i&&($canvas.css("height",h),scrollTop=$viewport[0].scrollTop);var s=scrollTop+offset<=th-viewportH;0==th||0==scrollTop?page=offset=0:scrollTo(s?scrollTop+offset:th-viewportH),h!=i&&options.autoHeight&&resizeCanvas(),options.forceFitColumns&&t!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,o){return null==e&&(e=scrollTop),null==o&&(o=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:o,rightPx:o+viewportW}}function getRenderedRange(e,o){var t=getVisibleRange(e,o),l=Math.round(viewportH/options.rowHeight),n=options.minRowBuffer;return-1==vScrollDir?(t.top-=l,t.bottom+=n):1==vScrollDir?(t.top-=n,t.bottom+=l):(t.top-=n,t.bottom+=n),t.top=Math.max(0,t.top),t.bottom=Math.min(getDataLengthIncludingAddNew()-1,t.bottom),t.leftPx-=viewportW,t.rightPx+=viewportW,t.leftPx=Math.max(0,t.leftPx),t.rightPx=Math.min(canvasWidth,t.rightPx),t}function ensureCellNodesInRowsCache(e){var o=rowsCache[e];if(o&&o.cellRenderQueue.length)for(var t=o.rowNode.lastChild;o.cellRenderQueue.length;){var l=o.cellRenderQueue.pop();o.cellNodesByColumnIdx[l]=t,t=t.previousSibling}}function cleanUpCells(e,o){var t,l,n=rowsCache[o],r=[];for(var i in n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(i)){i|=0;var s=n.cellColSpans[i];(columnPosLeft[i]>e.rightPx||columnPosRight[Math.min(columns.length-1,i+s-1)]<e.leftPx)&&(o==activeRow&&i==activeCell||r.push(i))}for(postProcessgroupId++;null!=(t=r.pop());)l=n.cellNodesByColumnIdx[t],options.enableAsyncPostRenderCleanup&&postProcessedRows[o]&&postProcessedRows[o][t]?queuePostProcessedCellForCleanup(l,t,o):n.rowNode.removeChild(l),delete n.cellColSpans[t],delete n.cellNodesByColumnIdx[t],postProcessedRows[o]&&delete postProcessedRows[o][t]}function cleanUpAndRenderCells(e){for(var o,t,l,n=[],r=[],i=e.top,s=e.bottom;i<=s;i++)if(o=rowsCache[i]){ensureCellNodesInRowsCache(i),cleanUpCells(e,i),t=0;var a=data.getItemMetadata&&data.getItemMetadata(i);a=a&&a.columns;for(var c=getDataItem(i),d=0,u=columns.length;d<u&&!(columnPosLeft[d]>e.rightPx);d++)if(null==(l=o.cellColSpans[d])){if(l=1,a){var h=a[columns[d].id]||a[d];"*"===(l=h&&h.colspan||1)&&(l=u-d)}columnPosRight[Math.min(u-1,d+l-1)]>e.leftPx&&(appendCellHtml(n,i,d,l,c),t++),d+=l>1?l-1:0}else d+=l>1?l-1:0;t&&(t,r.push(i))}if(n.length){var p,g,m=document.createElement("div");for(m.innerHTML=n.join("");null!=(p=r.pop());){var v;for(o=rowsCache[p];null!=(v=o.cellRenderQueue.pop());)g=m.lastChild,o.rowNode.appendChild(g),o.cellNodesByColumnIdx[v]=g}}}function renderRows(e){for(var o=$canvas[0],t=[],l=[],n=!1,r=getDataLength(),i=e.top,s=e.bottom;i<=s;i++)rowsCache[i]||(renderedRows++,l.push(i),rowsCache[i]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(t,i,e,r),activeCellNode&&activeRow===i&&(n=!0),counter_rows_rendered++);if(l.length){var a=document.createElement("div");a.innerHTML=t.join("");for(i=0,s=l.length;i<s;i++)rowsCache[l[i]].rowNode=o.appendChild(a.firstChild);n&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var o in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(o)&&(postProcessedRows[e][o]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache)rowsCache[e].rowNode.style.top=getRowTop(e)+"px"}function render(){if(initialized){scrollThrottle.dequeue();var e=getVisibleRange(),o=getRenderedRange();cleanupRows(o),lastRenderedScrollLeft!=scrollLeft&&cleanUpAndRenderCells(o),renderRows(o),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null,trigger(self.onRendered,{startRow:e.top,endRow:e.bottom,grid:self})}}function handleHeaderScroll(){handleElementScroll($headerScroller[0])}function handleHeaderRowScroll(){handleElementScroll($headerRowScroller[0])}function handleFooterRowScroll(){handleElementScroll($footerRowScroller[0])}function handlePreHeaderPanelScroll(){handleElementScroll($preHeaderPanelScroller[0])}function handleElementScroll(e){var o=e.scrollLeft;o!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=o)}function handleScroll(){scrollTop=$viewport[0].scrollTop,scrollLeft=$viewport[0].scrollLeft;var e=Math.abs(scrollTop-prevScrollTop),o=Math.abs(scrollLeft-prevScrollLeft);if(o&&(prevScrollLeft=scrollLeft,$headerScroller[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScroller[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScroller[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&($preHeaderPanelScroller[0].scrollLeft=scrollLeft)),e)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e<viewportH)scrollTo(scrollTop+offset);else{var t=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),t!=(offset=Math.round(page*cj))&&invalidateAllRows()}if(o||e){var l=Math.abs(lastRenderedScrollLeft-scrollLeft),r=Math.abs(lastRenderedScrollTop-scrollTop);(l>20||r>20)&&(options.forceSyncScrolling||r<viewportH&&l<viewportW?render():scrollThrottle.enqueue(),trigger(self.onViewportChanged,{}))}trigger(self.onScroll,{scrollLeft,scrollTop})}function ActionThrottle(e,o){var t=!1,l=!1;function n(){l=!1}function r(){t=!0,setTimeout(i,o),e()}function i(){l?(n(),r()):t=!1}return{enqueue:function(){t?l=!0:r()},dequeue:n}}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var o=vScrollDir>=0?postProcessFromRow++:postProcessToRow--,t=rowsCache[o];if(t&&!(o>=e)){for(var l in postProcessedRows[o]||(postProcessedRows[o]={}),ensureCellNodesInRowsCache(o),t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(l)){var n=columns[l|=0],r=postProcessedRows[o][l];if(n.asyncPostRender&&"R"!==r){var i=t.cellNodesByColumnIdx[l];i&&n.asyncPostRender(i,o,getDataItem(o),n,"C"===r),postProcessedRows[o][l]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(postProcessedCleanupQueue.length>0){for(var e=postProcessedCleanupQueue[0].groupId;postProcessedCleanupQueue.length>0&&postProcessedCleanupQueue[0].groupId==e;){var o=postProcessedCleanupQueue.shift();if("R"==o.actionType&&$(o.node).remove(),"C"==o.actionType){var t=columns[o.columnIdx];t.asyncPostRenderCleanup&&o.node&&t.asyncPostRenderCleanup(o.node,o.rowIdx,t)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,o){var t,l,n,r;for(var i in rowsCache){if(r=o&&o[i],n=e&&e[i],r)for(l in r)n&&r[l]==n[l]||(t=getCellNode(i,getColumnIndex(l)))&&$(t).removeClass(r[l]);if(n)for(l in n)r&&r[l]==n[l]||(t=getCellNode(i,getColumnIndex(l)))&&$(t).addClass(n[l])}}function addCellCssStyles(e,o){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,null),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,o){var t=cellCssClasses[e];cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,t),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,o,t){if(t=t||100,rowsCache[e]){var l=$(getCellNode(e,o)),n=function(e){e&&setTimeout((function(){l.queue((function(){l.toggleClass(options.cellFlashingCssClass).dequeue(),n(e-1)}))}),t)};n(4)}}function handleMouseWheel(e){var o=$(e.target).closest(".slick-row")[0];o!=rowNodeFromLastMouseWheelEvent&&(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent!=o&&(options.enableAsyncPostRenderCleanup&&zombieRowPostProcessedFromLastMouseWheelEvent?queuePostProcessedRowForCleanup(zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent):$canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent),zombieRowNodeFromLastMouseWheelEvent=null,zombieRowCacheFromLastMouseWheelEvent=null,zombieRowPostProcessedFromLastMouseWheelEvent=null,options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()),rowNodeFromLastMouseWheelEvent=o)}function handleDragInit(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var l=trigger(self.onDragInit,o,e);return!!e.isImmediatePropagationStopped()&&l}function handleDragStart(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var l=trigger(self.onDragStart,o,e);return!!e.isImmediatePropagationStopped()&&l}function handleDrag(e,o){return trigger(self.onDrag,o,e)}function handleDragEnd(e,o){trigger(self.onDragEnd,o,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell},e);var o=e.isImmediatePropagationStopped(),t=Slick.keyCode;if(!o&&!e.shiftKey&&!e.altKey){if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;e.which==t.HOME?o=e.ctrlKey?navigateTop():navigateRowStart():e.which==t.END&&(o=e.ctrlKey?navigateBottom():navigateRowEnd())}if(!o)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=t.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(o=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;if(e.which==t.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==t.PAGE_DOWN?(navigatePageDown(),o=!0):e.which==t.PAGE_UP?(navigatePageUp(),o=!0):e.which==t.LEFT?o=navigateLeft():e.which==t.RIGHT?o=navigateRight():e.which==t.UP?o=navigateUp():e.which==t.DOWN?o=navigateDown():e.which==t.TAB?o=navigateNext():e.which==t.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable(void 0,void 0,e)),o=!0)}if(o){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var o=getCellFromEvent(e);if(o&&(null===currentEditor||activeRow!=o.row||activeCell!=o.cell)&&(trigger(self.onClick,{row:o.row,cell:o.cell},e),!e.isImmediatePropagationStopped()&&canCellBeActive(o.row,o.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(o.row,!1);var t=e.target&&e.target.className===Slick.preClickClassName,l=columns[o.cell],n=!!(options.editable&&l&&l.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(getCellNode(o.row,o.cell),null,t,n,e)}}function handleContextMenu(e){var o=$(e.target).closest(".slick-cell",$canvas);0!==o.length&&(activeCellNode===o[0]&&null!==currentEditor||trigger(self.onContextMenu,{},e))}function handleDblClick(e){var o=getCellFromEvent(e);!o||null!==currentEditor&&activeRow==o.row&&activeCell==o.cell||(trigger(self.onDblClick,{row:o.row,cell:o.cell},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(o.row,o.cell,!0,e))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");trigger(self.onHeaderContextMenu,{column:t},e)}function handleHeaderClick(e){if(!columnResizeDragging){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");t&&trigger(self.onHeaderClick,{column:t},e)}}function handleMouseEnter(e){trigger(self.onMouseEnter,{},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{},e)}function cellExists(e,o){return!(e<0||e>=getDataLength()||o<0||o>=columns.length)}function getCellFromPoint(e,o){for(var t=getRowFromPosition(o),l=0,n=0,r=0;r<columns.length&&n<e;r++)n+=columns[r].width,l++;return l<0&&(l=0),{row:t,cell:l-1}}function getCellFromNode(e){var o=/l\d+/.exec(e.className);if(!o)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(o[0].substr(1,o[0].length-1),10)}function getRowFromNode(e){for(var o in rowsCache)if(rowsCache[o].rowNode===e)return 0|o;return null}function getCellFromEvent(e){var o=$(e.target).closest(".slick-cell",$canvas);if(!o.length)return null;var t=getRowFromNode(o[0].parentNode),l=getCellFromNode(o[0]);return null==t||null==l?null:{row:t,cell:l}}function getCellNodeBox(e,o){if(!cellExists(e,o))return null;for(var t=getRowTop(e),l=t+options.rowHeight-1,n=0,r=0;r<o;r++)n+=columns[r].width;return{top:t,left:n,bottom:l,right:n+columns[o].width}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,o,t){scrollRowIntoView(e,t);var l=getColspan(e,o);internalScrollColumnIntoView(columnPosLeft[o],columnPosRight[o+(l>1?l-1:0)])}function internalScrollColumnIntoView(e,o){var t=scrollLeft+viewportW;e<scrollLeft?($viewport.scrollLeft(e),handleScroll(),render()):o>t&&($viewport.scrollLeft(Math.min(e,o-$viewport[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,o,t,l,n){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));null!=(activeCellNode=e)?(activeRow=getRowFromNode(activeCellNode.parentNode),activeCell=activePosX=getCellFromNode(activeCellNode),null==o&&(o=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&($(activeCellNode).addClass("active"),$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&o&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout((function(){makeActiveCellEditable(void 0,t,n)}),options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,t,n))):activeRow=activeCell=null,l||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,o){var t=getDataLength();return!(e<t&&!getDataItem(e))&&(!(columns[o].cannotTriggerInsert&&e>=t)&&!!getEditor(e,o))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var o=columns[activeCell];applyFormatResultToCellNode(getFormatter(activeRow,o)(activeRow,activeCell,getDataItemValueForColumn(e,o),o,e,self),activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,o,t){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var l=columns[activeCell],n=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:n,column:l})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var r=e||getEditor(activeRow,activeCell);e||r.suppressClearOnEdit||(activeCellNode.innerHTML=""),currentEditor=new r({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:l,item:n||{},event:t,commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),n&&(currentEditor.loadValue(n),o&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var o={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};o.bottom=o.top+o.height,o.right=o.left+o.width;for(var t=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)o.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(o.visible=o.bottom>e.scrollTop&&o.top<e.scrollTop+e.clientHeight),o.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(o.visible=o.right>e.scrollLeft&&o.left<e.scrollLeft+e.clientWidth),o.left-=e.scrollLeft,o.top-=e.scrollTop,e===t&&(o.left+=e.offsetLeft,o.top+=e.offsetTop,t=e.offsetParent),o.bottom=o.top+o.height,o.right=o.left+o.width;return o}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,o){var t=e*options.rowHeight,l=(e+1)*options.rowHeight-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0);(e+1)*options.rowHeight>scrollTop+viewportH+offset?(scrollTo(o?t:l),render()):e*options.rowHeight<scrollTop+offset&&(scrollTo(o?l:t),render())}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var o=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop)+o)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var t=activeRow+o,l=getDataLengthIncludingAddNew();t>=l&&(t=l-1),t<0&&(t=0);for(var n=0,r=null,i=activePosX;n<=activePosX;)canCellBeActive(t,n)&&(r=n),n+=getColspan(t,n);null!==r?(setActiveCellInternal(getCellNode(t,r)),activePosX=i):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function navigateTop(){navigateToRow(0)}function navigateBottom(){navigateToRow(getDataLength()-1)}function navigateToRow(e){var o=getDataLength();if(!o)return!0;if(e<0?e=0:e>=o&&(e=o-1),scrollCellIntoView(e,0,!0),options.enableCellNavigation&&null!=activeRow){for(var t=0,l=null,n=activePosX;t<=activePosX;)canCellBeActive(e,t)&&(l=t),t+=getColspan(e,t);null!==l?(setActiveCellInternal(getCellNode(e,l)),activePosX=n):resetActiveCell()}return!0}function getColspan(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e);if(!t||!t.columns)return 1;var l=t.columns[columns[o].id]||t.columns[o],n=l&&l.colspan;return n="*"===n?columns.length-o:n||1}function findFirstFocusableCell(e){for(var o=0;o<columns.length;){if(canCellBeActive(e,o))return o;o+=getColspan(e,o)}return null}function findLastFocusableCell(e){for(var o=0,t=null;o<columns.length;)canCellBeActive(e,o)&&(t=o),o+=getColspan(e,o);return t}function gotoRight(e,o,t){if(o>=columns.length)return null;do{o+=getColspan(e,o)}while(o<columns.length&&!canCellBeActive(e,o));return o<columns.length?{row:e,cell:o,posX:o}:null}function gotoLeft(e,o,t){if(o<=0)return null;var l=findFirstFocusableCell(e);if(null===l||l>=o)return null;for(var n,r={row:e,cell:l,posX:l};;){if(!(n=gotoRight(r.row,r.cell,r.posX)))return null;if(n.cell>=o)return r;r=n}}function gotoDown(e,o,t){for(var l,n=getDataLengthIncludingAddNew();;){if(++e>=n)return null;for(l=o=0;o<=t;)l=o,o+=getColspan(e,o);if(canCellBeActive(e,l))return{row:e,cell:l,posX:t}}}function gotoUp(e,o,t){for(var l;;){if(--e<0)return null;for(l=o=0;o<=t;)l=o,o+=getColspan(e,o);if(canCellBeActive(e,l))return{row:e,cell:l,posX:t}}}function gotoNext(e,o,t){if(null==e&&null==o&&canCellBeActive(e=o=t=0,o))return{row:e,cell:o,posX:o};var l=gotoRight(e,o,t);if(l)return l;var n=null,r=getDataLengthIncludingAddNew();for(e===r-1&&e--;++e<r;)if(null!==(n=findFirstFocusableCell(e)))return{row:e,cell:n,posX:n};return null}function gotoPrev(e,o,t){if(null==e&&null==o&&canCellBeActive(e=getDataLengthIncludingAddNew()-1,o=t=columns.length-1))return{row:e,cell:o,posX:o};for(var l,n;!l&&!(l=gotoLeft(e,o,t));){if(--e<0)return null;o=0,null!==(n=findLastFocusableCell(e))&&(l={row:e,cell:n,posX:n})}return l}function gotoRowStart(e,o,t){var l=findFirstFocusableCell(e);return null===l?null:{row:e,cell:l,posX:l}}function gotoRowEnd(e,o,t){var l=findLastFocusableCell(e);return null===l?null:{row:e,cell:l,posX:l}}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigateRowStart(){return navigate("home")}function navigateRowEnd(){return navigate("end")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1,home:-1,end:1}[e];var o=(0,{up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext,home:gotoRowStart,end:gotoRowEnd}[e])(activeRow,activeCell,activePosX);if(o){var t=o.row==getDataLength();return scrollCellIntoView(o.row,o.cell,!t&&options.emulatePagingWhenScrolling),setActiveCellInternal(getCellNode(o.row,o.cell)),activePosX=o.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,o){return rowsCache[e]?(ensureCellNodesInRowsCache(e),rowsCache[e].cellNodesByColumnIdx[o]):null}function setActiveCell(e,o,t,l,n){initialized&&(e>getDataLength()||e<0||o>=columns.length||o<0||options.enableCellNavigation&&(scrollCellIntoView(e,o,!1),setActiveCellInternal(getCellNode(e,o),t,l,n)))}function canCellBeActive(e,o){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.focusable)return!!t.focusable;var l=t&&t.columns;return l&&l[columns[o].id]&&void 0!==l[columns[o].id].focusable?!!l[columns[o].id].focusable:l&&l[o]&&void 0!==l[o].focusable?!!l[o].focusable:!!columns[o].focusable}function canCellBeSelected(e,o){if(e>=getDataLength()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.selectable)return!!t.selectable;var l=t&&t.columns&&(t.columns[columns[o].id]||t.columns[o]);return l&&void 0!==l.selectable?!!l.selectable:!!columns[o].selectable}function gotoCell(e,o,t,l){initialized&&(canCellBeActive(e,o)&&getEditorLock().commitCurrentEdit()&&(scrollCellIntoView(e,o,!1),setActiveCellInternal(getCellNode(e,o),t||e===getDataLength()||options.autoEdit,null,options.editable,l),currentEditor||setFocus()))}function commitCurrentEdit(){var e=getDataItem(activeRow),o=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var t=currentEditor.validate();if(t.valid){if(activeRow<getDataLength()){var l={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,o,l)):(l.execute(),makeActiveCellNormal())}else{var n={};currentEditor.applyValue(n,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:n,column:o})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:t,row:activeRow,cell:activeCell,column:o}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var o=[],t=columns.length-1,l=0;l<e.length;l++)o.push(new Slick.Range(e[l],0,e[l],t));return o}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");self&&self.getEditorLock&&!self.getEditorLock().isActive()&&selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.3.23",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsResized:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,onAutosizeColumns:new Slick.Event,onRendered:new Slick.Event,registerPlugin,unregisterPlugin,getColumns,setColumns,getColumnIndex,updateColumnHeader,setSortColumn,setSortColumns,getSortColumns,autosizeColumns,getOptions,setOptions,getData,getDataLength,getDataItem,setData,getSelectionModel,setSelectionModel,getSelectedRows,setSelectedRows,getContainerNode,updatePagingStatusFromView,render,invalidate,invalidateRow,invalidateRows,invalidateAllRows,updateCell,updateRow,getViewport:getVisibleRange,getRenderedRange,resizeCanvas,updateRowCount,scrollRowIntoView,scrollRowToTop,scrollCellIntoView,scrollColumnIntoView,getCanvasNode,getUID,getHeaderColumnWidthDiff,getScrollbarDimensions,getHeadersWidth,getCanvasWidth,focus:setFocus,scrollTo,getCellFromPoint,getCellFromEvent,getActiveCell,setActiveCell,getActiveCellNode,getActiveCellPosition,resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor,getCellNode,getCellNodeBox,canCellBeSelected,canCellBeActive,navigatePrev,navigateNext,navigateUp,navigateDown,navigateLeft,navigateRight,navigatePageUp,navigatePageDown,navigateTop,navigateBottom,navigateRowStart,navigateRowEnd,gotoCell,getTopPanel,setTopPanelVisibility,getPreHeaderPanel,setPreHeaderPanelVisibility,getHeader,getHeaderColumn,setHeaderRowVisibility,getHeaderRow,getHeaderRowColumn,setFooterRowVisibility,getFooterRow,getFooterRowColumn,getGridPosition,flashCell,addCellCssStyles,setCellCssStyles,removeCellCssStyles,getCellCssStyles,init:finishInitialization,destroy,getEditorLock,getEditController}),init()}module.exports={Grid:SlickGrid}},
450: function _(t,e,a){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var n=t(443);n.fn.drag=function(t,e,a){var r="string"==typeof t?t:"",o=n.isFunction(t)?t:n.isFunction(e)?e:null;return 0!==r.indexOf("drag")&&(r="drag"+r),a=(t==o?e:a)||{},o?this.on(r,a,o):this.trigger(r)};var r=n.event,o=r.special,i=o.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(t){var e=n.data(this,i.datakey),a=t.data||{};e.related+=1,n.each(i.defaults,(function(t,n){void 0!==a[t]&&(e[t]=a[t])}))},remove:function(){n.data(this,i.datakey).related-=1},setup:function(){if(!n.data(this,i.datakey)){var t=n.extend({related:0},i.defaults);n.data(this,i.datakey,t),r.add(this,"touchstart mousedown",i.init,t),this.attachEvent&&this.attachEvent("ondragstart",i.dontstart)}},teardown:function(){(n.data(this,i.datakey)||{}).related||(n.removeData(this,i.datakey),r.remove(this,"touchstart mousedown",i.init),i.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",i.dontstart))},init:function(t){if(!i.touched){var e,a=t.data;if(!(0!=t.which&&a.which>0&&t.which!=a.which)&&!n(t.target).is(a.not)&&(!a.handle||n(t.target).closest(a.handle,t.currentTarget).length)&&(i.touched="touchstart"==t.type?this:null,a.propagates=1,a.mousedown=this,a.interactions=[i.interaction(this,a)],a.target=t.target,a.pageX=t.pageX,a.pageY=t.pageY,a.dragging=null,e=i.hijack(t,"draginit",a),a.propagates))return(e=i.flatten(e))&&e.length&&(a.interactions=[],n.each(e,(function(){a.interactions.push(i.interaction(this,a))}))),a.propagates=a.interactions.length,!1!==a.drop&&o.drop&&o.drop.handler(t,a),i.textselect(!1),i.touched?r.add(i.touched,"touchmove touchend",i.handler,a):r.add(document,"mousemove mouseup",i.handler,a),!(!i.touched||a.live)&&void 0}},interaction:function(t,e){var a=t&&t.ownerDocument&&n(t)[e.relative?"position":"offset"]()||{top:0,left:0};return{drag:t,callback:new i.callback,droppable:[],offset:a}},handler:function(t){var e=t.data;switch(t.type){case!e.dragging&&"touchmove":t.preventDefault();case!e.dragging&&"mousemove":if(Math.pow(t.pageX-e.pageX,2)+Math.pow(t.pageY-e.pageY,2)<Math.pow(e.distance,2))break;t.target=e.target,i.hijack(t,"dragstart",e),e.propagates&&(e.dragging=!0);case"touchmove":t.preventDefault();case"mousemove":if(e.dragging){if(i.hijack(t,"drag",e),e.propagates){!1!==e.drop&&o.drop&&o.drop.handler(t,e);break}t.type="mouseup"}case"touchend":case"mouseup":default:i.touched?r.remove(i.touched,"touchmove touchend",i.handler):r.remove(document,"mousemove mouseup",i.handler),e.dragging&&(!1!==e.drop&&o.drop&&o.drop.handler(t,e),i.hijack(t,"dragend",e)),i.textselect(!0),!1===e.click&&e.dragging&&n.data(e.mousedown,"suppress.click",(new Date).getTime()+5),e.dragging=i.touched=!1}},hijack:function(t,e,a,o,d){if(a){var s,c,l,p={event:t.originalEvent,type:t.type},u=e.indexOf("drop")?"drag":"drop",g=o||0,h=isNaN(o)?a.interactions.length:o;t.type=e;var f=function(){};t.originalEvent=new n.Event(p.event,{preventDefault:f,stopPropagation:f,stopImmediatePropagation:f}),a.results=[];do{if(c=a.interactions[g]){if("dragend"!==e&&c.cancelled)continue;l=i.properties(t,a,c),c.results=[],n(d||c[u]||a.droppable).each((function(o,d){if(l.target=d,t.isPropagationStopped=function(){return!1},!1===(s=d?r.dispatch.call(d,t,l):null)?("drag"==u&&(c.cancelled=!0,a.propagates-=1),"drop"==e&&(c[u][o]=null)):"dropinit"==e&&c.droppable.push(i.element(s)||d),"dragstart"==e&&(c.proxy=n(i.element(s)||c.drag)[0]),c.results.push(s),delete t.result,"dropinit"!==e)return s})),a.results[g]=i.flatten(c.results),"dropinit"==e&&(c.droppable=i.flatten(c.droppable)),"dragstart"!=e||c.cancelled||l.update()}}while(++g<h);return t.type=p.type,t.originalEvent=p.event,i.flatten(a.results)}},properties:function(t,e,a){var n=a.callback;return n.drag=a.drag,n.proxy=a.proxy||a.drag,n.startX=e.pageX,n.startY=e.pageY,n.deltaX=t.pageX-e.pageX,n.deltaY=t.pageY-e.pageY,n.originalX=a.offset.left,n.originalY=a.offset.top,n.offsetX=n.originalX+n.deltaX,n.offsetY=n.originalY+n.deltaY,n.drop=i.flatten((a.drop||[]).slice()),n.available=i.flatten((a.droppable||[]).slice()),n},element:function(t){if(t&&(t.jquery||1==t.nodeType))return t},flatten:function(t){return n.map(t,(function(t){return t&&t.jquery?n.makeArray(t):t&&t.length?i.flatten(t):t}))},textselect:function(t){n(document)[t?"off":"on"]("selectstart",i.dontstart).css("MozUserSelect",t?"":"none"),document.unselectable=t?"off":"on"},dontstart:function(){return!1},callback:function(){}};i.callback.prototype={update:function(){o.drop&&this.available.length&&n.each(this.available,(function(t){o.drop.locate(this,t)}))}};var d=r.dispatch;r.dispatch=function(t){if(!(n.data(this,"suppress."+t.type)-(new Date).getTime()>0))return d.apply(this,arguments);n.removeData(this,"suppress."+t.type)},o.draginit=o.dragstart=o.dragend=i},
451: function _(t,e,a){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var n=t(443);n.fn.drop=function(t,e,a){var i="string"==typeof t?t:"",o=n.isFunction(t)?t:n.isFunction(e)?e:null;return 0!==i.indexOf("drop")&&(i="drop"+i),a=(t==o?e:a)||{},o?this.on(i,a,o):this.trigger(i)},n.drop=function(t){t=t||{},o.multi=!0===t.multi?1/0:!1===t.multi?1:isNaN(t.multi)?o.multi:t.multi,o.delay=t.delay||o.delay,o.tolerance=n.isFunction(t.tolerance)?t.tolerance:null===t.tolerance?null:o.tolerance,o.mode=t.mode||o.mode||"intersect"};var i=n.event.special,o=n.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(t){n.data(this,o.datakey).related+=1},remove:function(){n.data(this,o.datakey).related-=1},setup:function(){if(!n.data(this,o.datakey)){n.data(this,o.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),o.targets.push(this)}},teardown:function(){if(!(n.data(this,o.datakey)||{}).related){n.removeData(this,o.datakey);var t=this;o.targets=n.grep(o.targets,(function(e){return e!==t}))}},handler:function(t,e){var a;if(e)switch(t.type){case"mousedown":case"touchstart":a=n(o.targets),"string"==typeof e.drop&&(a=a.filter(e.drop)),a.each((function(){var t=n.data(this,o.datakey);t.active=[],t.anyactive=0,t.winner=0})),e.droppable=a,i.drag.hijack(t,"dropinit",e);break;case"mousemove":case"touchmove":o.event=t,o.timer||o.tolerate(e);break;case"mouseup":case"touchend":o.timer=clearTimeout(o.timer),e.propagates&&(i.drag.hijack(t,"drop",e),i.drag.hijack(t,"dropend",e))}},locate:function(t,e){var a=n.data(t,o.datakey),i=n(t),r=i.offset()||{},d=i.outerHeight(),l=i.outerWidth(),c={elem:t,width:l,height:d,top:r.top,left:r.left,right:r.left+l,bottom:r.top+d};return a&&(a.location=c,a.index=e,a.elem=t),c},contains:function(t,e){return(e[0]||e.left)>=t.left&&(e[0]||e.right)<=t.right&&(e[1]||e.top)>=t.top&&(e[1]||e.bottom)<=t.bottom},modes:{intersect:function(t,e,a){return this.contains(a,[t.pageX,t.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(t,e,a){return Math.max(0,Math.min(a.bottom,e.bottom)-Math.max(a.top,e.top))*Math.max(0,Math.min(a.right,e.right)-Math.max(a.left,e.left))},fit:function(t,e,a){return this.contains(a,e)?1:0},middle:function(t,e,a){return this.contains(a,[e.left+.5*e.width,e.top+.5*e.height])?1:0}},sort:function(t,e){return e.winner-t.winner||t.index-e.index},tolerate:function(t){var e,a,r,d,l,c,s,u,p=0,h=t.interactions.length,m=[o.event.pageX,o.event.pageY],f=o.tolerance||o.modes[o.mode];do{if(u=t.interactions[p]){if(!u)return;u.drop=[],l=[],c=u.droppable.length,f&&(r=o.locate(u.proxy)),e=0;do{if(s=u.droppable[e]){if(!(a=(d=n.data(s,o.datakey)).location))continue;d.winner=f?f.call(o,o.event,r,a):o.contains(a,m)?1:0,l.push(d)}}while(++e<c);l.sort(o.sort),e=0;do{(d=l[e])&&(d.winner&&u.drop.length<o.multi?(d.active[p]||d.anyactive||(!1!==i.drag.hijack(o.event,"dropstart",t,p,d.elem)[0]?(d.active[p]=1,d.anyactive+=1):d.winner=0),d.winner&&u.drop.push(d.elem)):d.active[p]&&1==d.anyactive&&(i.drag.hijack(o.event,"dropend",t,p,d.elem),d.active[p]=0,d.anyactive-=1))}while(++e<c)}}while(++p<h);o.last&&m[0]==o.last.pageX&&m[1]==o.last.pageY?delete o.timer:o.timer=setTimeout((function(){o.tolerate(t)}),o.delay),o.last=o.event}};i.dropinit=i.dropstart=i.dropend=o},
452: function _(t,e,n){var r=t(443),i=t(445);var o={Avg:function(t){this.field_=t,this.init=function(){this.count_=0,this.nonNullCount_=0,this.sum_=0},this.accumulate=function(t){var e=t[this.field_];this.count_++,null==e||""===e||isNaN(e)||(this.nonNullCount_++,this.sum_+=parseFloat(e))},this.storeResult=function(t){t.avg||(t.avg={}),0!=this.nonNullCount_&&(t.avg[this.field_]=this.sum_/this.nonNullCount_)}},Min:function(t){this.field_=t,this.init=function(){this.min_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(null==this.min_||e<this.min_)&&(this.min_=e)},this.storeResult=function(t){t.min||(t.min={}),t.min[this.field_]=this.min_}},Max:function(t){this.field_=t,this.init=function(){this.max_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(null==this.max_||e>this.max_)&&(this.max_=e)},this.storeResult=function(t){t.max||(t.max={}),t.max[this.field_]=this.max_}},Sum:function(t){this.field_=t,this.init=function(){this.sum_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(this.sum_+=parseFloat(e))},this.storeResult=function(t){t.sum||(t.sum={}),t.sum[this.field_]=this.sum_}}};e.exports={DataView:function(t){var e,n,o,a,l,s=this,u="id",g=[],c=[],f={},p=null,h=null,d=null,m=!1,v=!0,_={},w={},$=[],y=[],I={getter:null,formatter:null,comparer:function(t,e){return t.value===e.value?0:t.value>e.value?1:-1},predefinedValues:[],aggregators:[],aggregateEmpty:!1,aggregateCollapsed:!1,aggregateChildGroups:!1,collapsed:!1,displayTotalsRow:!0,lazyTotalsCalculation:!1},C=[],R=[],x=[],b=0,M=0,F=0,A=new i.Event,S=new i.Event,N=new i.Event;function E(t){for(var e,n=t=t||0,r=g.length;n<r;n++){if(void 0===(e=g[n][u]))throw new Error("Each data element must implement a unique 'id' property");f[e]=n}}function T(){var t=b?Math.max(1,Math.ceil(F/b)):1;return{pageSize:b,pageNum:M,totalRows:F,totalPages:t,dataView:s}}function G(t,r){v=r,n=t,e=null,!1===r&&g.reverse(),g.sort(t),!1===r&&g.reverse(),f={},E(),Z()}function D(t,r){v=r,e=t,n=null;var i=Object.prototype.toString;Object.prototype.toString="function"==typeof t?t:function(){return this[t]},!1===r&&g.reverse(),g.sort(),Object.prototype.toString=i,!1===r&&g.reverse(),f={},E(),Z()}function P(e){t.groupItemMetadataProvider||(t.groupItemMetadataProvider=new i.Data.GroupItemMetadataProvider),R=[],x=[],C=(e=e||[])instanceof Array?e:[e];for(var n=0;n<C.length;n++){var o=C[n]=r.extend(!0,{},I,C[n]);o.getterIsAFn="function"==typeof o.getter,o.compiledAccumulators=[];for(var a=o.aggregators.length;a--;)o.compiledAccumulators[a]=W(o.aggregators[a]);x[n]={}}Z()}function j(){if(!p){p={};for(var t=0,e=c.length;t<e;t++)p[c[t][u]]=t}}function z(t){return g[f[t]]}function B(t,e){if(void 0===f[t]||t!==e[u])throw new Error("Invalid or non-matching id");g[f[t]]=e,d||(d={}),d[t]=!0,Z()}function V(t,e){g.splice(t,0,e),E(t),Z()}function O(t){var e=f[t];if(void 0===e)throw new Error("Invalid id");delete f[t],g.splice(e,1),E(e),Z()}function q(t){if(!n)throw new Error("sortedAddItem() requires a sort comparer, use sort()");V(function(t){var e=0,r=g.length;for(;e<r;){var i=e+r>>>1;-1===n(g[i],t)?e=i+1:r=i}return e}(t),t)}function K(t,e){if(null==t)for(var n=0;n<C.length;n++)x[n]={},C[n].collapsed=e;else x[t]={},C[t].collapsed=e;Z()}function U(t,e,n){x[t][e]=C[t].collapsed^n,Z()}function L(t){var e,n=t.group,r=C[n.level],i=n.level==C.length,o=r.aggregators.length;if(!i&&r.aggregateChildGroups)for(var a=n.groups.length;a--;)n.groups[a].totals.initialized||L(n.groups[a].totals);for(;o--;)(e=r.aggregators[o]).init(),!i&&r.aggregateChildGroups?r.compiledAccumulators[o].call(e,n.groups):r.compiledAccumulators[o].call(e,n.rows),e.storeResult(t);t.initialized=!0}function k(t){var e=C[t.level],n=new i.GroupTotals;n.group=t,t.totals=n,e.lazyTotalsCalculation||L(n)}function H(t){var e=t.toString().match(/^function[^(]*\(([^)]*)\)\s*{([\s\S]*)}$/);return{params:e[1].split(","),body:e[2]}}function W(t){var e=H(t.accumulate),n=new Function("_items","for (var "+e.params[0]+", _i=0, _il=_items.length; _i<_il; _i++) {"+e.params[0]+" = _items[_i]; "+e.body+"}");return n.displayName=n.name="compiledAccumulatorLoop",n}function J(t,e){for(var n=[],r=0,i=0,o=t.length;i<o;i++)h(t[i],e)&&(n[r++]=t[i]);return n}function Q(t,e,n){for(var r,i=[],o=0,a=0,l=t.length;a<l;a++)r=t[a],n[a]?i[o++]=r:h(r,e)&&(i[o++]=r,n[a]=!0);return i}function X(e){if(h){var n=t.inlineFilters?a:J,r=t.inlineFilters?l:Q;_.isFilterNarrowing?$=n($,o):_.isFilterExpanding?$=r(e,o,y):_.isFilterUnchanged||($=n(e,o))}else $=b?e:e.concat();var i;return b?($.length<=M*b&&(M=0===$.length?0:Math.floor(($.length-1)/b)),i=$.slice(b*M,b*M+b)):i=$,{totalRows:$.length,rows:i}}function Y(t){p=null,_.isFilterNarrowing==w.isFilterNarrowing&&_.isFilterExpanding==w.isFilterExpanding||(y=[]);var e=X(t);F=e.totalRows;var n=e.rows;R=[],C.length&&(R=function t(e,n){for(var r,o,a,l=[],s={},u=n?n.level+1:0,g=C[u],c=0,f=g.predefinedValues.length;c<f;c++)(r=s[o=g.predefinedValues[c]])||((r=new i.Group).value=o,r.level=u,r.groupingKey=(n?n.groupingKey+":|:":"")+o,l[l.length]=r,s[o]=r);for(c=0,f=e.length;c<f;c++)a=e[c],(r=s[o=g.getterIsAFn?g.getter(a):a[g.getter]])||((r=new i.Group).value=o,r.level=u,r.groupingKey=(n?n.groupingKey+":|:":"")+o,l[l.length]=r,s[o]=r),r.rows[r.count++]=a;if(u<C.length-1)for(c=0;c<l.length;c++)(r=l[c]).groups=t(r.rows,r);return l.sort(C[u].comparer),l}(n)).length&&(!function t(e,n){for(var r,i=C[n=n||0],o=i.collapsed,a=x[n],l=e.length;l--;)(r=e[l]).collapsed&&!i.aggregateCollapsed||(r.groups&&t(r.groups,n+1),i.aggregators.length&&(i.aggregateEmpty||r.rows.length||r.groups&&r.groups.length)&&k(r),r.collapsed=o^a[r.groupingKey],r.title=i.formatter?i.formatter(r):r.value)}(R),n=function t(e,n){for(var r,i,o=C[n=n||0],a=[],l=0,s=0,u=e.length;s<u;s++){if(i=e[s],a[l++]=i,!i.collapsed)for(var g=0,c=(r=i.groups?t(i.groups,n+1):i.rows).length;g<c;g++)a[l++]=r[g];i.totals&&o.displayTotalsRow&&(!i.collapsed||o.aggregateCollapsed)&&(a[l++]=i.totals)}return a}(R));var r=function(t,e){var n,r,i,o=[],a=0,l=e.length;_&&_.ignoreDiffsBefore&&(a=Math.max(0,Math.min(e.length,_.ignoreDiffsBefore))),_&&_.ignoreDiffsAfter&&(l=Math.min(e.length,Math.max(0,_.ignoreDiffsAfter)));for(var s=a,g=t.length;s<l;s++)s>=g?o[o.length]=s:(n=e[s],r=t[s],(C.length&&(i=n.__nonDataRow||r.__nonDataRow)&&n.__group!==r.__group||n.__group&&!n.equals(r)||i&&(n.__groupTotals||r.__groupTotals)||n[u]!=r[u]||d&&d[n[u]])&&(o[o.length]=s));return o}(c,n);return c=n,r}function Z(){if(!m){var t=c.length,e=F,n=Y(g);b&&F<M*b&&(M=Math.max(0,Math.ceil(F/b)-1),n=Y(g)),d=null,w=_,_={},e!==F&&N.notify(T(),null,s),t!==c.length&&A.notify({previous:t,current:c.length,dataView:s},null,s),n.length>0&&S.notify({rows:n,dataView:s},null,s)}}t=r.extend(!0,{},{groupItemMetadataProvider:null,inlineFilters:!1},t),r.extend(this,{beginUpdate:function(){m=!0},endUpdate:function(){m=!1,Z()},setPagingOptions:function(t){null!=t.pageSize&&(b=t.pageSize,M=b?Math.min(M,Math.max(0,Math.ceil(F/b)-1)):0),null!=t.pageNum&&(M=Math.min(t.pageNum,Math.max(0,Math.ceil(F/b)-1))),N.notify(T(),null,s),Z()},getPagingInfo:T,getItems:function(){return g},setItems:function(t,e){void 0!==e&&(u=e),g=$=t,f={},E(),function(){for(var t,e=0,n=g.length;e<n;e++)if(void 0===(t=g[e][u])||f[t]!==e)throw new Error("Each data element must implement a unique 'id' property")}(),Z()},setFilter:function(e){h=e,t.inlineFilters&&(a=function(){var t=H(h),e="{ _retval[_idx++] = $item$; continue _coreloop; }$1",n=t.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,e).replace(/return!0([;}]|\}|$)/gi,e).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ($1) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),r=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","$filter$; ","} ","return _retval; "].join("");r=(r=(r=r.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,t.params[0])).replace(/\$args\$/gi,t.params[1]);var i=new Function("_items,_args",r);return i.displayName=i.name="compiledFilter",i}(),l=function(){var t=H(h),e="{ _cache[_i] = true;_retval[_idx++] = $item$; continue _coreloop; }$1",n=t.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,e).replace(/return!0([;}]|\}|$)/gi,e).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ((_cache[_i] = $1)) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),r=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","if (_cache[_i]) { ","_retval[_idx++] = $item$; ","continue _coreloop; ","} ","$filter$; ","} ","return _retval; "].join("");r=(r=(r=r.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,t.params[0])).replace(/\$args\$/gi,t.params[1]);var i=new Function("_items,_args,_cache",r);return i.displayName=i.name="compiledFilterWithCaching",i}()),Z()},getFilter:function(){return h},getFilteredItems:function(){return $},sort:G,fastSort:D,reSort:function(){n?G(n,v):e&&D(e,v)},setGrouping:P,getGrouping:function(){return C},groupBy:function(t,e,n){P(null!=t?{getter:t,formatter:e,comparer:n}:[])},setAggregators:function(t,e){if(!C.length)throw new Error("At least one grouping must be specified before calling setAggregators().");C[0].aggregators=t,C[0].aggregateCollapsed=e,P(C)},collapseAllGroups:function(t){K(t,!0)},expandAllGroups:function(t){K(t,!1)},collapseGroup:function(t){var e=Array.prototype.slice.call(arguments),n=e[0];1==e.length&&-1!=n.indexOf(":|:")?U(n.split(":|:").length-1,n,!0):U(e.length-1,e.join(":|:"),!0)},expandGroup:function(t){var e=Array.prototype.slice.call(arguments),n=e[0];1==e.length&&-1!=n.indexOf(":|:")?U(n.split(":|:").length-1,n,!1):U(e.length-1,e.join(":|:"),!1)},getGroups:function(){return R},getIdxById:function(t){return f[t]},getRowByItem:function(t){return j(),p[t[u]]},getRowById:function(t){return j(),p[t]},getItemById:z,getItemByIdx:function(t){return g[t]},mapItemsToRows:function(t){var e=[];j();for(var n=0,r=t.length;n<r;n++){var i=p[t[n][u]];null!=i&&(e[e.length]=i)}return e},mapRowsToIds:function(t){for(var e=[],n=0,r=t.length;n<r;n++)t[n]<c.length&&(e[e.length]=c[t[n]][u]);return e},mapIdsToRows:function(t){var e=[];j();for(var n=0,r=t.length;n<r;n++){var i=p[t[n]];null!=i&&(e[e.length]=i)}return e},setRefreshHints:function(t){_=t},setFilterArgs:function(t){o=t},refresh:Z,updateItem:B,insertItem:V,addItem:function(t){g.push(t),E(g.length-1),Z()},deleteItem:O,sortedAddItem:q,sortedUpdateItem:function(t,e){if(void 0===f[t]||t!==e[u])throw new Error("Invalid or non-matching id "+f[t]);if(!n)throw new Error("sortedUpdateItem() requires a sort comparer, use sort()");var r=z(t);0!==n(r,e)?(O(t),q(e)):B(t,e)},syncGridSelection:function(t,e,n){var o,a=this,l=a.mapRowsToIds(t.getSelectedRows()),s=new i.Event;function u(e){l.join(",")!=e.join(",")&&(l=e,s.notify({grid:t,ids:l,dataView:a},new i.EventData,a))}function g(){if(l.length>0){o=!0;var n=a.mapIdsToRows(l);e||u(a.mapRowsToIds(n)),t.setSelectedRows(n),o=!1}}return t.onSelectedRowsChanged.subscribe((function(e,i){if(!o){var s=a.mapRowsToIds(t.getSelectedRows());if(n&&t.getOptions().multiSelect)u(r.grep(l,(function(t){return void 0===a.getRowById(t)})).concat(s));else u(s)}})),this.onRowsChanged.subscribe(g),this.onRowCountChanged.subscribe(g),s},syncGridCellCssStyles:function(t,e){var n,r;function i(t){for(var e in n={},t){var r=c[e][u];n[r]=t[e]}}function o(){if(n){r=!0,j();var i={};for(var o in n){var a=p[o];null!=a&&(i[a]=n[o])}t.setCellCssStyles(e,i),r=!1}}i(t.getCellCssStyles(e)),t.onCellCssStylesChanged.subscribe((function(n,a){r||e==a.key&&(a.hash?i(a.hash):(t.onCellCssStylesChanged.unsubscribe(styleChanged),s.onRowsChanged.unsubscribe(o),s.onRowCountChanged.unsubscribe(o)))})),this.onRowsChanged.subscribe(o),this.onRowCountChanged.subscribe(o)},getLength:function(){return c.length},getItem:function(t){var e=c[t];if(e&&e.__group&&e.totals&&!e.totals.initialized){var n=C[e.level];n.displayTotalsRow||(L(e.totals),e.title=n.formatter?n.formatter(e):e.value)}else e&&e.__groupTotals&&!e.initialized&&L(e);return e},getItemMetadata:function(e){var n=c[e];return void 0===n?null:n.__group?t.groupItemMetadataProvider.getGroupRowMetadata(n):n.__groupTotals?t.groupItemMetadataProvider.getTotalsRowMetadata(n):null},onRowCountChanged:A,onRowsChanged:S,onPagingInfoChanged:N})},Aggregators:o,Data:{Aggregators:o}}},
453: function _(e,t,i){var n=e(443),o=e(445);function l(e){var t,i;function o(){var t=e.column.editorFixedDecimalPlaces;return void 0===t&&(t=l.DefaultDecimalPlaces),t||0===t?t:null}this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field];var l=o();null!==l&&(i||0===i)&&i.toFixed&&(i=i.toFixed(l)),t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){var e=parseFloat(t.val());l.AllowEmptyValue?e||0===e||(e=""):e=e||0;var i=o();return null!==i&&(e||0===e)&&e.toFixed&&(e=parseFloat(e.toFixed(i))),e},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid number"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}function a(e){var t=this.selectionStart,i=this.value.length;(e.keyCode===n.ui.keyCode.LEFT&&t>0||e.keyCode===n.ui.keyCode.RIGHT&&t<i-1)&&e.stopImmediatePropagation()}function s(e){e.keyCode!==n.ui.keyCode.LEFT&&e.keyCode!==n.ui.keyCode.RIGHT||e.stopImmediatePropagation()}l.DefaultDecimalPlaces=null,l.AllowEmptyValue=!1,t.exports={Editors:{Text:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.getValue=function(){return t.val()},this.setValue=function(e){t.val(e)},this.loadValue=function(n){i=n[e.column.field]||"",t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Integer:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid integer"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Float:l,Date:function(e){var t,i,o=!1;this.init=function(){(t=n("<INPUT type=text class='editor-text' />")).appendTo(e.container),t.focus().select(),t.datepicker({showOn:"button",buttonImageOnly:!0,beforeShow:function(){o=!0},onClose:function(){o=!1}}),t.width(t.width()-18)},this.destroy=function(){n.datepicker.dpDiv.stop(!0,!0),t.datepicker("hide"),t.datepicker("destroy"),t.remove()},this.show=function(){o&&n.datepicker.dpDiv.stop(!0,!0).show()},this.hide=function(){o&&n.datepicker.dpDiv.stop(!0,!0).hide()},this.position=function(e){o&&n.datepicker.dpDiv.css("top",e.top+30).css("left",e.left)},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},YesNoSelect:function(e){var t,i;this.init=function(){(t=n("<SELECT tabIndex='0' class='editor-yesno'><OPTION value='yes'>Yes</OPTION><OPTION value='no'>No</OPTION></SELECT>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){t.val((i=n[e.column.field])?"yes":"no"),t.select()},this.serializeValue=function(){return"yes"==t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return t.val()!=i},this.validate=function(){return{valid:!0,msg:null}},this.init()},Checkbox:function(e){var t,i;this.init=function(){(t=n("<INPUT type=checkbox value='true' class='editor-checkbox' hideFocus>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){(i=!!n[e.column.field])?t.prop("checked",!0):t.prop("checked",!1)},this.preClick=function(){t.prop("checked",!t.prop("checked"))},this.serializeValue=function(){return t.prop("checked")},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return this.serializeValue()!==i},this.validate=function(){return{valid:!0,msg:null}},this.init()},PercentComplete:function(e){var t,i,o;this.init=function(){(t=n("<INPUT type=text class='editor-percentcomplete' />")).width(n(e.container).innerWidth()-25),t.appendTo(e.container),(i=n("<div class='editor-percentcomplete-picker' />").appendTo(e.container)).append("<div class='editor-percentcomplete-helper'><div class='editor-percentcomplete-wrapper'><div class='editor-percentcomplete-slider' /><div class='editor-percentcomplete-buttons' /></div></div>"),i.find(".editor-percentcomplete-buttons").append("<button val=0>Not started</button><br/><button val=50>In Progress</button><br/><button val=100>Complete</button>"),t.focus().select(),i.find(".editor-percentcomplete-slider").slider({orientation:"vertical",range:"min",value:o,slide:function(e,i){t.val(i.value)}}),i.find(".editor-percentcomplete-buttons button").on("click",(function(e){t.val(n(this).attr("val")),i.find(".editor-percentcomplete-slider").slider("value",n(this).attr("val"))}))},this.destroy=function(){t.remove(),i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(o=i[e.column.field]),t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==o)&&(parseInt(t.val(),10)||0)!=o},this.validate=function(){return isNaN(parseInt(t.val(),10))?{valid:!1,msg:"Please enter a valid positive number"}:{valid:!0,msg:null}},this.init()},LongText:function(e){var t,i,l,a=this;this.init=function(){var o=n("body");e.grid.getOptions().editorCellNavOnLRKeys;i=n("<DIV style='z-index:10000;position:absolute;background:white;padding:5px;border:3px solid gray; -moz-border-radius:10px; border-radius:10px;'/>").appendTo(o),t=n("<TEXTAREA hidefocus rows=5 style='background:white;width:250px;height:80px;border:0;outline:0'>").appendTo(i),n("<DIV style='text-align:right'><BUTTON>Save</BUTTON><BUTTON>Cancel</BUTTON></DIV>").appendTo(i),i.find("button:first").on("click",this.save),i.find("button:last").on("click",this.cancel),t.on("keydown",this.handleKeyDown),a.position(e.position),t.focus().select()},this.handleKeyDown=function(t){if(t.which==o.keyCode.ENTER&&t.ctrlKey)a.save();else if(t.which==o.keyCode.ESCAPE)t.preventDefault(),a.cancel();else if(t.which==o.keyCode.TAB&&t.shiftKey)t.preventDefault(),e.grid.navigatePrev();else if(t.which==o.keyCode.TAB)t.preventDefault(),e.grid.navigateNext();else if((t.which==n.ui.keyCode.LEFT||t.which==n.ui.keyCode.RIGHT)&&e.grid.getOptions().editorCellNavOnLRKeys){var i=this.selectionStart,l=this.value.length;t.keyCode===n.ui.keyCode.LEFT&&0===i&&e.grid.navigatePrev(),t.keyCode===n.ui.keyCode.RIGHT&&i>=l-1&&e.grid.navigateNext()}},this.save=function(){e.commitChanges()},this.cancel=function(){t.val(l),e.cancelChanges()},this.hide=function(){i.hide()},this.show=function(){i.show()},this.position=function(e){i.css("top",e.top-5).css("left",e.left-5)},this.destroy=function(){i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(l=i[e.column.field]),t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==l)&&t.val()!=l},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}}}},
454: function _(e,n,r){e(445);n.exports={Formatters:{PercentComplete:function(e,n,r,t,c){return null==r||""===r?"-":r<50?"<span style='color:red;font-weight:bold;'>"+r+"%</span>":"<span style='color:green'>"+r+"%</span>"},PercentCompleteBar:function(e,n,r,t,c){return null==r||""===r?"":"<span class='percent-complete-bar' style='background:"+(r<30?"red":r<70?"silver":"green")+";width:"+r+"%'></span>"},YesNo:function(e,n,r,t,c){return r?"Yes":"No"},Checkmark:function(e,n,r,t,c){return r?"<img src='../images/tick.png'>":""},Checkbox:function(e,n,r,t,c){return'<img class="slick-edit-preclick" src="../images/'+(r?"CheckboxY":"CheckboxN")+'.png">'}}}},
455: function _(t,o,r){var e=t(443),n=t(445);o.exports={RemoteModel:function(){var t={length:0},o="",r=null,a=1,l=null,i=null,s=new n.Event,u=new n.Event;function f(){for(var o in t)delete t[o];t.length=0}function c(n,f){if(i){i.abort();for(var c=i.fromPage;c<=i.toPage;c++)t[50*c]=void 0}n<0&&(n=0),t.length>0&&(f=Math.min(f,t.length-1));for(var d=Math.floor(n/50),v=Math.floor(f/50);void 0!==t[50*d]&&d<v;)d++;for(;void 0!==t[50*v]&&d<v;)v--;if(d>v||d==v&&void 0!==t[50*d])u.notify({from:n,to:f});else{var m="http://octopart.com/api/v3/parts/search?apikey=68b25f31&include[]=short_description&show[]=uid&show[]=manufacturer&show[]=mpn&show[]=brand&show[]=octopart_url&show[]=short_description&q="+o+"&start="+50*d+"&limit="+(50*(v-d)+50);null!=r&&(m+="&sortby="+r+(a>0?"+asc":"+desc")),null!=l&&clearTimeout(l),l=setTimeout((function(){for(var o=d;o<=v;o++)t[50*o]=null;s.notify({from:n,to:f}),(i=e.jsonp({url:m,callbackParameter:"callback",cache:!0,success:h,error:function(){!function(t,o){alert("error loading pages "+t+" to "+o)}(d,v)}})).fromPage=d,i.toPage=v}),50)}}function h(o){var r=o.request.start,e=r+o.results.length;t.length=Math.min(parseInt(o.hits),1e3);for(var n=0;n<o.results.length;n++){var a=o.results[n].item;t[r+n]=a,t[r+n].index=r+n}i=null,u.notify({from:r,to:e})}return{data:t,clear:f,isDataLoaded:function(o,r){for(var e=o;e<=r;e++)if(null==t[e]||null==t[e])return!1;return!0},ensureData:c,reloadData:function(o,r){for(var e=o;e<=r;e++)delete t[e];c(o,r)},setSort:function(t,o){r=t,a=o,f()},setSearch:function(t){o=t,f()},onDataLoading:s,onDataLoaded:u}}}},
456: function _(e,s,t){var a=e(443),o=e(445);s.exports={GroupItemMetadataProvider:function(e){var s,t={checkboxSelect:!1,checkboxSelectCssClass:"slick-group-select-checkbox",checkboxSelectPlugin:null,groupCssClass:"slick-group",groupTitleCssClass:"slick-group-title",totalsCssClass:"slick-group-totals",groupFocusable:!0,totalsFocusable:!1,toggleCssClass:"slick-group-toggle",toggleExpandedCssClass:"expanded",toggleCollapsedCssClass:"collapsed",enableExpandCollapse:!0,groupFormatter:function(s,t,a,o,l,c){if(!e.enableExpandCollapse)return l.title;var r=15*l.level+"px";return(e.checkboxSelect?'<span class="'+e.checkboxSelectCssClass+" "+(l.selectChecked?"checked":"unchecked")+'"></span>':"")+"<span class='"+e.toggleCssClass+" "+(l.collapsed?e.toggleCollapsedCssClass:e.toggleExpandedCssClass)+"' style='margin-left:"+r+"'></span><span class='"+e.groupTitleCssClass+"' level='"+l.level+"'>"+l.title+"</span>"},totalsFormatter:function(e,s,t,a,o,l){return a.groupTotalsFormatter&&a.groupTotalsFormatter(o,a,l)||""}};function l(t,l){var c=a(t.target),r=this.getDataItem(l.row);if(r&&r instanceof o.Group&&c.hasClass(e.toggleCssClass)){var n=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:n.top,ignoreDiffsAfter:n.bottom+1}),r.collapsed?this.getData().expandGroup(r.groupingKey):this.getData().collapseGroup(r.groupingKey),t.stopImmediatePropagation(),t.preventDefault()}if(r&&r instanceof o.Group&&c.hasClass(e.checkboxSelectCssClass)){r.selectChecked=!r.selectChecked,c.removeClass(r.selectChecked?"unchecked":"checked"),c.addClass(r.selectChecked?"checked":"unchecked");var i=s.getData().mapItemsToRows(r.rows);(r.selectChecked?e.checkboxSelectPlugin.selectRows:e.checkboxSelectPlugin.deSelectRows)(i)}}function c(t,a){if(e.enableExpandCollapse&&t.which==o.keyCode.SPACE){var l=this.getActiveCell();if(l){var c=this.getDataItem(l.row);if(c&&c instanceof o.Group){var r=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:r.top,ignoreDiffsAfter:r.bottom+1}),c.collapsed?this.getData().expandGroup(c.groupingKey):this.getData().collapseGroup(c.groupingKey),t.stopImmediatePropagation(),t.preventDefault()}}}}return e=a.extend(!0,{},t,e),{init:function(e){(s=e).onClick.subscribe(l),s.onKeyDown.subscribe(c)},destroy:function(){s&&(s.onClick.unsubscribe(l),s.onKeyDown.unsubscribe(c))},getGroupRowMetadata:function(s){return{selectable:!1,focusable:e.groupFocusable,cssClasses:e.groupCssClass,columns:{0:{colspan:"*",formatter:e.groupFormatter,editor:null}}}},getTotalsRowMetadata:function(s){return{selectable:!1,focusable:e.totalsFocusable,cssClasses:e.totalsCssClass,formatter:e.totalsFormatter,editor:null}}}}}},
457: function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),n=e(458),c=e(98),a=s.__importStar(e(18));class o extends n.Widget{constructor(e){super(e)}static init_TableWidget(){this.define({source:[a.Instance],view:[a.Instance,()=>new c.CDSView]})}initialize(){super.initialize(),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())}}t.TableWidget=o,o.__name__="TableWidget",o.init_TableWidget()},
458: function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const o=i(1),n=i(249),r=o.__importStar(i(18));class _ extends n.HTMLBoxView{_width_policy(){return"horizontal"==this.model.orientation?super._width_policy():"fixed"}_height_policy(){return"horizontal"==this.model.orientation?"fixed":super._height_policy()}box_sizing(){const i=super.box_sizing();return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i}}t.WidgetView=_,_.__name__="WidgetView";class s extends n.HTMLBox{constructor(i){super(i)}static init_Widget(){this.define({orientation:[r.Orientation,"horizontal"],default_size:[r.Number,300]}),this.override({margin:[5,5,5,5]})}}t.Widget=s,s.__name__="Widget",s.init_Widget()},
459: function _(e,l,b){Object.defineProperty(b,"__esModule",{value:!0}),b.bk_data_table="bk-data-table",b.bk_cell_index="bk-cell-index",b.bk_header_index="bk-header-index",b.bk_cell_editor="bk-cell-editor",b.bk_cell_select="bk-cell-select"},
460: function _(A,n,o){Object.defineProperty(o,"__esModule",{value:!0});o.default='\n.bk-root {\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /* Menu button */\n  /* Menu */\n  /* Menu items */\n  /* Disabled */\n}\n.bk-root .slick-header.ui-state-default,\n.bk-root .slick-headerrow.ui-state-default,\n.bk-root .slick-footerrow.ui-state-default,\n.bk-root .slick-top-panel-scroller.ui-state-default {\n  width: 100%;\n  overflow: auto;\n  position: relative;\n  border-left: 0px !important;\n}\n.bk-root .slick-header.ui-state-default {\n  overflow: inherit;\n}\n.bk-root .slick-header::-webkit-scrollbar,\n.bk-root .slick-headerrow::-webkit-scrollbar,\n.bk-root .slick-footerrow::-webkit-scrollbar {\n  display: none;\n}\n.bk-root .slick-header-columns,\n.bk-root .slick-headerrow-columns,\n.bk-root .slick-footerrow-columns {\n  position: relative;\n  white-space: nowrap;\n  cursor: default;\n  overflow: hidden;\n}\n.bk-root .slick-header-column.ui-state-default {\n  position: relative;\n  display: inline-block;\n  box-sizing: content-box !important;\n  /* this here only for Firefox! */\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  height: 16px;\n  line-height: 16px;\n  margin: 0;\n  padding: 4px;\n  border-right: 1px solid silver;\n  border-left: 0px !important;\n  border-top: 0px !important;\n  border-bottom: 0px !important;\n  float: left;\n}\n.bk-root .slick-headerrow-column.ui-state-default,\n.bk-root .slick-footerrow-column.ui-state-default {\n  padding: 4px;\n}\n.bk-root .slick-header-column-sorted {\n  font-style: italic;\n}\n.bk-root .slick-sort-indicator {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 6px;\n  float: left;\n}\n.bk-root .slick-sort-indicator-numbered {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 0;\n  line-height: 20px;\n  float: left;\n  font-family: Arial;\n  font-style: normal;\n  font-weight: bold;\n  color: #6190CD;\n}\n.bk-root .slick-sort-indicator-desc {\n  background: url(images/sort-desc.gif);\n}\n.bk-root .slick-sort-indicator-asc {\n  background: url(images/sort-asc.gif);\n}\n.bk-root .slick-resizable-handle {\n  position: absolute;\n  font-size: 0.1px;\n  display: block;\n  cursor: col-resize;\n  width: 9px;\n  right: -5px;\n  top: 0;\n  height: 100%;\n  z-index: 1;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver;\n}\n.bk-root .grid-canvas {\n  position: relative;\n  outline: 0;\n}\n.bk-root .slick-row.ui-widget-content,\n.bk-root .slick-row.ui-state-active {\n  position: absolute;\n  border: 0px;\n  width: 100%;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column,\n.bk-root .slick-footerrow-column {\n  position: absolute;\n  border: 1px solid transparent;\n  border-right: 1px dotted silver;\n  border-bottom-color: silver;\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  vertical-align: middle;\n  z-index: 1;\n  padding: 1px 2px 2px 1px;\n  margin: 0;\n  white-space: nowrap;\n  cursor: default;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column {\n  border-bottom-color: silver;\n}\n.bk-root .slick-footerrow-column {\n  border-top-color: silver;\n}\n.bk-root .slick-group-toggle {\n  display: inline-block;\n}\n.bk-root .slick-cell.highlighted {\n  background: lightskyblue;\n  background: rgba(0, 0, 255, 0.2);\n  -webkit-transition: all 0.5s;\n  -moz-transition: all 0.5s;\n  -o-transition: all 0.5s;\n  transition: all 0.5s;\n}\n.bk-root .slick-cell.flashing {\n  border: 1px solid red !important;\n}\n.bk-root .slick-cell.editable {\n  z-index: 11;\n  overflow: visible;\n  background: white;\n  border-color: black;\n  border-style: solid;\n}\n.bk-root .slick-cell:focus {\n  outline: none;\n}\n.bk-root .slick-reorder-proxy {\n  display: inline-block;\n  background: blue;\n  opacity: 0.15;\n  cursor: move;\n}\n.bk-root .slick-reorder-guide {\n  display: inline-block;\n  height: 2px;\n  background: blue;\n  opacity: 0.7;\n}\n.bk-root .slick-selection {\n  z-index: 10;\n  position: absolute;\n  border: 2px dashed black;\n}\n.bk-root .slick-header-columns {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-bottom: 1px solid silver;\n}\n.bk-root .slick-header-column {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-right: 1px solid silver;\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background: white url(\'images/header-columns-over-bg.gif\') repeat-x center bottom;\n}\n.bk-root .slick-headerrow {\n  background: #fafafa;\n}\n.bk-root .slick-headerrow-column {\n  background: #fafafa;\n  border-bottom: 0;\n  height: 100%;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row {\n  position: absolute;\n  background: white;\n  border: 0px;\n  line-height: 20px;\n}\n.bk-root .slick-row.selected {\n  z-index: 10;\n  background: #DFE8F6;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-group {\n  border-bottom: 2px solid silver;\n}\n.bk-root .slick-group-toggle {\n  width: 9px;\n  height: 9px;\n  margin-right: 5px;\n}\n.bk-root .slick-group-toggle.expanded {\n  background: url(images/collapse.gif) no-repeat center center;\n}\n.bk-root .slick-group-toggle.collapsed {\n  background: url(images/expand.gif) no-repeat center center;\n}\n.bk-root .slick-group-totals {\n  color: gray;\n  background: white;\n}\n.bk-root .slick-group-select-checkbox {\n  width: 13px;\n  height: 13px;\n  margin: 3px 10px 0 0;\n  display: inline-block;\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background: url(images/GrpCheckboxY.png) no-repeat center center;\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background: url(images/GrpCheckboxN.png) no-repeat center center;\n}\n.bk-root .slick-cell.selected {\n  background-color: beige;\n}\n.bk-root .slick-cell.active {\n  border-color: gray;\n  border-style: solid;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver !important;\n}\n.bk-root .slick-row.odd {\n  background: #fafafa;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row.loading {\n  opacity: 0.5;\n}\n.bk-root .slick-cell.invalid {\n  border-color: red;\n  -moz-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  -moz-animation-name: slickgrid-invalid-hilite;\n  -webkit-animation-name: slickgrid-invalid-hilite;\n}\n@-moz-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n@-webkit-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n.bk-root .slick-column-name,\n.bk-root .slick-sort-indicator {\n  /**\n   * This makes all "float:right" elements after it that spill over to the next line\n   * display way below the lower boundary of the column thus hiding them.\n   */\n  display: inline-block;\n  float: left;\n  margin-bottom: 100px;\n}\n.bk-root .slick-header-button {\n  display: inline-block;\n  float: right;\n  vertical-align: top;\n  margin: 1px;\n  /**\n  * This makes all "float:right" elements after it that spill over to the next line\n  * display way below the lower boundary of the column thus hiding them.\n  */\n  margin-bottom: 100px;\n  height: 15px;\n  width: 15px;\n  background-repeat: no-repeat;\n  background-position: center center;\n  cursor: pointer;\n}\n.bk-root .slick-header-button-hidden {\n  width: 0;\n  -webkit-transition: 0.2s width;\n  -ms-transition: 0.2s width;\n  transition: 0.2s width;\n}\n.bk-root .slick-header-column:hover > .slick-header-button {\n  width: 15px;\n}\n.bk-root .slick-header-menubutton {\n  position: absolute;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  width: 14px;\n  background-repeat: no-repeat;\n  background-position: left center;\n  background-image: url(../images/down.gif);\n  cursor: pointer;\n  display: none;\n  border-left: thin ridge silver;\n}\n.bk-root .slick-header-column:hover > .slick-header-menubutton,\n.bk-root .slick-header-column-active .slick-header-menubutton {\n  display: inline-block;\n}\n.bk-root .slick-header-menu {\n  position: absolute;\n  display: inline-block;\n  margin: 0;\n  padding: 2px;\n  cursor: default;\n}\n.bk-root .slick-header-menuitem {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  cursor: pointer;\n}\n.bk-root .slick-header-menuicon {\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  vertical-align: middle;\n  margin-right: 4px;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .slick-header-menucontent {\n  display: inline-block;\n  vertical-align: middle;\n}\n.bk-root .slick-header-menuitem-disabled {\n  color: silver;\n}\n.bk-root .slick-columnpicker {\n  border: 1px solid #718BB7;\n  background: #f0f0f0;\n  padding: 6px;\n  -moz-box-shadow: 2px 2px 2px silver;\n  -webkit-box-shadow: 2px 2px 2px silver;\n  box-shadow: 2px 2px 2px silver;\n  min-width: 150px;\n  cursor: default;\n  position: absolute;\n  z-index: 20;\n  overflow: auto;\n  resize: both;\n}\n.bk-root .slick-columnpicker > .close {\n  float: right;\n}\n.bk-root .slick-columnpicker .title {\n  font-size: 16px;\n  width: 60%;\n  border-bottom: solid 1px #d6d6d6;\n  margin-bottom: 10px;\n}\n.bk-root .slick-columnpicker li {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  background: none;\n}\n.bk-root .slick-columnpicker input {\n  margin: 4px;\n}\n.bk-root .slick-columnpicker li a {\n  display: block;\n  padding: 4px;\n  font-weight: bold;\n}\n.bk-root .slick-columnpicker li a:hover {\n  background: white;\n}\n.bk-root .slick-pager {\n  width: 100%;\n  height: 26px;\n  border: 1px solid gray;\n  border-top: 0;\n  background: url(\'../images/header-columns-bg.gif\') repeat-x center bottom;\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-status {\n  display: inline-block;\n  padding: 6px;\n}\n.bk-root .slick-pager .ui-icon-container {\n  display: inline-block;\n  margin: 2px;\n  border-color: gray;\n}\n.bk-root .slick-pager .slick-pager-nav {\n  display: inline-block;\n  float: left;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings {\n  display: block;\n  float: right;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings * {\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-settings a {\n  padding: 2px;\n  text-decoration: underline;\n  cursor: pointer;\n}\n.bk-root .slick-header-columns {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAWAIcAAKrM9tno++vz/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABYAAAgUAAUIHEiwoIAACBMqXMhwIQAAAQEAOw==");\n}\n.bk-root .slick-group-toggle.expanded {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIMwADCBxIUIDBgwIEChgwwECBAgQUFjBAkaJCABgxGlB4AGHCAAIQiBypEEECkScJqgwQEAA7");\n}\n.bk-root .slick-group-toggle.collapsed {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIOAADCBxIUIDBgwIEChgwAECBAgQUFjAAQIABAwoBaNSIMYCAAwIqGlSIAEHFkiQTIBCgkqDLAAEBADs=");\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAAEcSURBVChTjdI9S8NQFAbg/raQXVwCRRFE7GK7OXTwD+ikk066VF3a0ja0hQTyQdJrwNq0zrYSQRLEXMSWSlCIb8glqRcFD+9yz3nugXwU4n9XQqMoGjj36uBJsTwuaNo3EwBG4Yy7pe7Gv8YcvhJCGFVsjxsjxujj6OTSGlHv+U2WZUZbPWKOv1ZjT5a7pbIoiptbO5b73mwrjHa1B27l8VlTEIS1damlTnEE+EEN9/P8WrfH81qdAIGeXvTTmzltdCy46sEhxpKUINReZR9NnqZbr9puugxV3NjWh/k74WmmEdWhmUNy2jNmWRc6fZTVADCqao52u+DGWTACYNT3fRxwtatPufTNR4yCIGAUn5hS+vJHhWGY/ANx/A3tvdv+1tZmuwAAAABJRU5ErkJggg==");\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAACXSURBVChT1dIxC4MwEAXg/v8/VOhQVDBNakV0KA6pxS4JhWRSIYPEJxwdDi1de7wleR+3JIf486w0hKCKRpSvvOhZcCmvNQBRuKqdah03U7UjNNH81rOaBYDo8SQaPX8JANFEaLaGBeAPaaY61rGksiN6TmR5H1j9CSoAosYYHLA7vTxYMvVEZa0liif23r93xjm3/oEYF8PiDn/I2FHCAAAAAElFTkSuQmCC");\n}\n.bk-root .slick-sort-indicator-desc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgeAAUAGEgQgIAACBEKLHgwYcKFBh1KFNhQosOKEgMCADs=");\n}\n.bk-root .slick-sort-indicator-asc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgbAAMIDABgoEGDABIeRJhQ4cKGEA8KmEiRosGAADs=");\n}\n.bk-root .slick-header-menubutton {\n  background-image: url("data:image/gif;base64,R0lGODlhDgAOAIABADtKYwAAACH5BAEAAAEALAAAAAAOAA4AAAISjI+py+0PHZgUsGobhTn6DxoFADs=");\n}\n.bk-root .slick-pager {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n'},
461: function _(n,e,o){Object.defineProperty(o,"__esModule",{value:!0});o.default='\n.bk-root .bk-data-table {\n  box-sizing: content-box;\n  font-size: 11px;\n}\n.bk-root .bk-data-table input[type="checkbox"] {\n  margin-left: 4px;\n  margin-right: 4px;\n}\n.bk-root .bk-cell-special-defaults {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-select {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-index {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n  text-align: right;\n  color: gray;\n}\n.bk-root .bk-header-index .slick-column-name {\n  float: right;\n}\n.bk-root .slick-row.selected .bk-cell-index {\n  background-color: transparent;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-cell.active {\n  border-style: dashed;\n}\n.bk-root .slick-cell.editable {\n  padding-left: 0;\n  padding-right: 0;\n}\n.bk-root .bk-cell-editor input,\n.bk-root .bk-cell-editor select {\n  width: 100%;\n  height: 100%;\n  border: 0;\n  margin: 0;\n  padding: 0;\n  outline: 0;\n  background: transparent;\n  vertical-align: baseline;\n}\n.bk-root .bk-cell-editor input {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .bk-cell-editor-completion {\n  font-size: 11px;\n}\n'},
462: function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),o=i.__importDefault(t(159)),a=i.__importStar(t(161)),n=t(463),s=i.__importStar(t(18)),c=t(68),l=t(8),m=t(71);class _ extends m.Model{constructor(t){super(t)}doFormat(t,e,r,i,o){return null==r?"":(r+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}}r.CellFormatter=_,_.__name__="CellFormatter";class u extends _{constructor(t){super(t)}static init_StringFormatter(){this.define({font_style:[s.FontStyle,"normal"],text_align:[s.TextAlign,"left"],text_color:[s.Color]})}doFormat(t,e,r,i,o){const{font_style:a,text_align:n,text_color:s}=this,l=c.div({},null==r?"":""+r);switch(a){case"bold":l.style.fontWeight="bold";break;case"italic":l.style.fontStyle="italic"}return null!=n&&(l.style.textAlign=n),null!=s&&(l.style.color=s),l.outerHTML}}r.StringFormatter=u,u.__name__="StringFormatter",u.init_StringFormatter();class F extends u{constructor(t){super(t)}static init_ScientificFormatter(){this.define({precision:[s.Number,10],power_limit_high:[s.Number,5],power_limit_low:[s.Number,-3]})}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}doFormat(t,e,r,i,o){const a=r<=this.scientific_limit_low||r>=this.scientific_limit_high;let n=this.precision;return n<1&&(n=1),r=a?r.toExponential(n):r.toFixed(n).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),super.doFormat(t,e,r,i,o)}}r.ScientificFormatter=F,F.__name__="ScientificFormatter",F.init_ScientificFormatter();class d extends u{constructor(t){super(t)}static init_NumberFormatter(){this.define({format:[s.String,"0,0"],language:[s.String,"en"],rounding:[s.RoundingFunction,"round"]})}doFormat(t,e,r,i,o){const{format:n,language:s}=this,c=(()=>{switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}})();return r=a.format(r,n,s,c),super.doFormat(t,e,r,i,o)}}r.NumberFormatter=d,d.__name__="NumberFormatter",d.init_NumberFormatter();class g extends _{constructor(t){super(t)}static init_BooleanFormatter(){this.define({icon:[s.String,"check"]})}doFormat(t,e,r,i,o){return r?c.i({class:this.icon}).outerHTML:""}}r.BooleanFormatter=g,g.__name__="BooleanFormatter",g.init_BooleanFormatter();class p extends _{constructor(t){super(t)}static init_DateFormatter(){this.define({format:[s.String,"ISO-8601"]})}getFormat(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}}doFormat(t,e,r,i,a){r=l.isString(r)?parseInt(r,10):r;const n=o.default(r,this.getFormat());return super.doFormat(t,e,n,i,a)}}r.DateFormatter=p,p.__name__="DateFormatter",p.init_DateFormatter();class h extends _{constructor(t){super(t)}static init_HTMLTemplateFormatter(){this.define({template:[s.String,"<%= value %>"]})}doFormat(t,e,r,i,o){const{template:a}=this;if(null==r)return"";return n._.template(a)(Object.assign(Object.assign({},o),{value:r}))}}r.HTMLTemplateFormatter=h,h.__name__="HTMLTemplateFormatter",h.init_HTMLTemplateFormatter()},
463: function _(e,n,t){var f=e(464),i=f.template;function o(e,n,t){return i(e,n,t)}o._=f,n.exports=o,"function"==typeof define&&define.amd?define((function(){return o})):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=o)},
464: function _(r,e,n){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var t={},a=Array.prototype,u=Object.prototype,c=a.slice,o=u.toString,l=u.hasOwnProperty,i=a.forEach,f=Object.keys,s=Array.isArray,p=function(){},_=p.each=p.forEach=function(r,e,n){if(null!=r)if(i&&r.forEach===i)r.forEach(e,n);else if(r.length===+r.length){for(var a=0,u=r.length;a<u;a++)if(e.call(n,r[a],a,r)===t)return}else{var c=p.keys(r);for(a=0,u=c.length;a<u;a++)if(e.call(n,r[c[a]],c[a],r)===t)return}};p.keys=f||function(r){if(r!==Object(r))throw new TypeError("Invalid object");var e=[];for(var n in r)p.has(r,n)&&e.push(n);return e},p.defaults=function(r){return _(c.call(arguments,1),(function(e){if(e)for(var n in e)void 0===r[n]&&(r[n]=e[n])})),r},p.isArray=s||function(r){return"[object Array]"===o.call(r)},p.has=function(r,e){if(!p.isArray(e))return null!=r&&l.call(r,e);for(var n=e.length,t=0;t<n;t++){var a=e[t];if(null==r||!l.call(r,a))return!1;r=r[a]}return!!n};var h={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},v={escape:new RegExp("["+p.keys(h.escape).join("")+"]","g")};p.each(["escape"],(function(r){p[r]=function(e){return null==e?"":(""+e).replace(v[r],(function(e){return h[r][e]}))}})),p.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var g=/(.)^/,y={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},j=/\\|'|\r|\n|\t|\u2028|\u2029/g;p.template=function(r,e,n){var t;n=p.defaults({},n,p.templateSettings);var a=new RegExp([(n.escape||g).source,(n.interpolate||g).source,(n.evaluate||g).source].join("|")+"|$","g"),u=0,c="__p+='";r.replace(a,(function(e,n,t,a,o){return c+=r.slice(u,o).replace(j,(function(r){return"\\"+y[r]})),n&&(c+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'"),t&&(c+="'+\n((__t=("+t+"))==null?'':__t)+\n'"),a&&(c+="';\n"+a+"\n__p+='"),u=o+e.length,e})),c+="';\n",n.variable||(c="with(obj||{}){\n"+c+"}\n"),c="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+c+"return __p;\n";try{t=new Function(n.variable||"obj","_",c)}catch(r){throw r.source=c,r}if(e)return t(e,p);var o=function(r){return t.call(this,r,p)};return o.source="function("+(n.variable||"obj")+"){\n"+c+"}",o},e.exports=p},
465: function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const r=t(1),o=t(462),n=t(440),l=r.__importStar(t(18)),a=t(24),d=t(71);class s extends d.Model{constructor(t){super(t)}static init_TableColumn(){this.define({field:[l.String],title:[l.String],width:[l.Number,300],formatter:[l.Instance,()=>new o.StringFormatter],editor:[l.Instance,()=>new n.StringEditor],sortable:[l.Boolean,!0],default_sort:[l.Sort,"ascending"]})}toColumn(){var t;return{id:a.uniqueId(),field:this.field,name:null!==(t=this.title)&&void 0!==t?t:this.field,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}}}i.TableColumn=s,s.__name__="TableColumn",s.init_TableColumn()},
466: function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const r=t(1),a=t(448),{Avg:i,Min:o,Max:g,Sum:n}=a.Data.Aggregators,u=r.__importStar(t(18)),c=t(71);class _ extends c.Model{constructor(t){super(t)}static init_RowAggregator(){this.define({field_:[u.String,""]})}}s.RowAggregator=_,_.__name__="RowAggregator",_.init_RowAggregator();const l=new i;class m extends _{constructor(){super(...arguments),this.key="avg",this.init=l.init,this.accumulate=l.accumulate,this.storeResult=l.storeResult}}s.AvgAggregator=m,m.__name__="AvgAggregator";const h=new o;class A extends _{constructor(){super(...arguments),this.key="min",this.init=h.init,this.accumulate=h.accumulate,this.storeResult=h.storeResult}}s.MinAggregator=A,A.__name__="MinAggregator";const R=new g;class d extends _{constructor(){super(...arguments),this.key="max",this.init=R.init,this.accumulate=R.accumulate,this.storeResult=R.storeResult}}s.MaxAggregator=d,d.__name__="MaxAggregator";const x=new n;class w extends _{constructor(){super(...arguments),this.key="sum",this.init=x.init,this.accumulate=x.accumulate,this.storeResult=x.storeResult}}s.SumAggregator=w,w.__name__="SumAggregator"},
467: function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const o=t(1).__importStar(t(18)),r=t(68),i=t(448),a=t(441),n=t(71);function l(t,e,s,o,i){const{collapsed:a,level:n,title:l}=i,u=r.span({class:"slick-group-toggle "+(a?"collapsed":"expanded"),style:{"margin-left":15*n+"px"}}),g=r.span({class:"slick-group-title",level:n},l);return`${u.outerHTML}${g.outerHTML}`}function u(t,e){const s=this.getDataItem(e.row);s instanceof i.Group&&t.target.classList.contains("slick-group-toggle")&&(s.collapsed?this.getData().expandGroup(s.groupingKey):this.getData().collapseGroup(s.groupingKey),t.stopImmediatePropagation(),t.preventDefault(),this.invalidate(),this.render())}class g extends n.Model{constructor(t){super(t)}static init_GroupingInfo(){this.define({getter:[o.String,""],aggregators:[o.Array,[]],collapsed:[o.Boolean,!1]})}get comparer(){return(t,e)=>t.value===e.value?0:t.value>e.value?1:-1}}s.GroupingInfo=g,g.__name__="GroupingInfo",g.init_GroupingInfo();class c extends a.TableDataProvider{constructor(t,e,s,o){super(t,e),this.columns=s,this.groupingInfos=[],this.groupingDelimiter=":|:",this.target=o}setGrouping(t){this.groupingInfos=t,this.toggledGroupsByLevel=t.map(()=>({})),this.refresh()}extractGroups(t,e){const s=[],o=new Map,r=e?e.level+1:0,{comparer:a,getter:n}=this.groupingInfos[r];return t.forEach(t=>{const a=this.source.data[n][t];let l=o.get(a);if(!l){const t=e?`${e.groupingKey}${this.groupingDelimiter}${a}`:""+a;l=Object.assign(new i.Group,{value:a,level:r,groupingKey:t}),s.push(l),o.set(a,l)}l.rows.push(t)}),r<this.groupingInfos.length-1&&s.forEach(t=>{t.groups=this.extractGroups(t.rows,t)}),s.sort(a),s}calculateTotals(t,e){const s={avg:{},max:{},min:{},sum:{}},{source:{data:o}}=this,r=Object.keys(o),i=t.rows.map(t=>r.reduce((e,s)=>Object.assign(Object.assign({},e),{[s]:o[s][t]}),{}));return e.forEach(t=>{t.init(),i.forEach(e=>t.accumulate(e)),t.storeResult(s)}),s}addTotals(t,e=0){const{aggregators:s,collapsed:o}=this.groupingInfos[e],r=this.toggledGroupsByLevel[e];t.forEach(t=>{t.groups&&this.addTotals(t.groups,e+1),s.length&&t.rows.length&&(t.totals=this.calculateTotals(t,s)),t.collapsed=o!==r[t.groupingKey],t.title=t.value?""+t.value:""})}flattenedGroupedRows(t,e=0){const s=[];return t.forEach(t=>{if(s.push(t),!t.collapsed){const o=t.groups?this.flattenedGroupedRows(t.groups,e+1):t.rows;s.push(...o)}}),s}refresh(){const t=this.extractGroups(this.view.indices),e=this.source.data[this.columns[0].field];t.length&&(this.addTotals(t),this.rows=this.flattenedGroupedRows(t),this.target.data={row_indices:this.rows.map(t=>t instanceof i.Group?t.rows:t),labels:this.rows.map(t=>t instanceof i.Group?t.title:e[t])})}getLength(){return this.rows.length}getItem(t){const e=this.rows[t],{source:{data:s}}=this;return e instanceof i.Group?e:Object.keys(s).reduce((t,o)=>Object.assign(Object.assign({},t),{[o]:s[o][e]}),{[a.DTINDEX_NAME]:e})}getItemMetadata(t){const e=this.rows[t],s=this.columns.slice(1),o=e instanceof i.Group?this.groupingInfos[e.level].aggregators:[];return e instanceof i.Group?{selectable:!1,focusable:!1,cssClasses:"slick-group",columns:[{formatter:l},...s.map((function(t){const{field:e,formatter:s}=t,r=o.find(({field_:t})=>t===e);if(r){const{key:t}=r;return{formatter:(o,r,i,a,n)=>s?s(o,r,n.totals[t][e],a,n):""}}return{}}))]}:{}}collapseGroup(t){const e=t.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[e][t]=!this.groupingInfos[e].collapsed,this.refresh()}expandGroup(t){const e=t.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[e][t]=this.groupingInfos[e].collapsed,this.refresh()}}s.DataCubeProvider=c,c.__name__="DataCubeProvider";class p extends a.DataTableView{render(){const t={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:!1,forceFitColumns:this.model.fit_columns,multiColumnSort:!1,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height},e=this.model.columns.map(t=>t.toColumn());var s,o;e[0].formatter=(s=e[0].formatter,o=this.model.grouping.length,(t,e,i,a,n)=>{const l=r.span({class:"slick-group-toggle",style:{"margin-left":15*(o||0)+"px"}}),u=s?s(t,e,i,a,n):""+i;return`${l.outerHTML}${u&&u.replace(/^<div/,"<span").replace(/div>$/,"span>")}`}),delete e[0].editor,this.data=new c(this.model.source,this.model.view,e,this.model.target),this.data.setGrouping(this.model.grouping),this.el.style.width=this.model.width+"px",this.grid=new i.Grid(this.el,this.data,e,t),this.grid.onClick.subscribe(u)}}s.DataCubeView=p,p.__name__="DataCubeView";class h extends a.DataTable{constructor(t){super(t)}static init_DataCube(){this.prototype.default_view=p,this.define({grouping:[o.Array,[]],target:[o.Instance]})}}s.DataCube=h,h.__name__="DataCube",h.init_DataCube()},
}, 438, {"models/widgets/tables/main":438,"models/widgets/tables/index":439,"models/widgets/tables/cell_editors":440,"models/widgets/tables/data_table":441,"models/widgets/tables/table_widget":457,"models/widgets/widget":458,"styles/widgets/tables":459,"styles/widgets/slickgrid.css":460,"styles/widgets/tables.css":461,"models/widgets/tables/cell_formatters":462,"models/widgets/tables/table_column":465,"models/widgets/tables/row_aggregators":466,"models/widgets/tables/data_cube":467}, {});
})

