# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['logchain', 'logchain.formatters']

package_data = \
{'': ['*']}

install_requires = \
['toml>=0.9,<0.10']

setup_kwargs = {
    'name': 'logchain',
    'version': '0.0.1',
    'description': 'Python Logging based on blockchain',
    'long_description': '# Plogchain\n\n[![Tests Status](https://github.com/gg-math/plogchain/workflows/unittests/badge.svg)](https://github.com/gg-math/plogchain/actions)\n![Dependencies](https://img.shields.io/badge/dependencies-0-blue.svg)\n[![license](https://img.shields.io/badge/license-ISC-blue.svg)](https://github.com/gg-math/plogchain/blob/master/LICENSE)\n\n[![Web page](https://img.shields.io/badge/website-github.io/plogchain-blue.svg)](https://gg-math.github.io/plogchain)\n[![Package](https://img.shields.io/badge/PIP-plogchain-blue.svg)](https://pypi.org/project/plogchain)\n\nPython Logging based on blockchain 📜 ⛓️.\n\n## Logs get chained\nThe current log line contains the signature of the previous line with your secret.\n* detect lines deleted / lost\n* detect logs tampering\n\n## Philosophy\nThe package is intended to be a **lightweight** util for generating **incorruptible** logs.\n\nFor this pupose we rely as much as possible on standard packages: few dependencies, high quality.\n\nThe formatters are easy **extensible** by simply deriving from `Basic`.\n\n\n# Usage\n\n## Install\n``` bash\npip install plogchain\n```\n\n## Choose your log type\n\nMany types of logs are supported out-of-the-box:\n- `Basic` raw text, relying on the standard formatter\n- `Json` structured log lines with static & dynamic fields\n- `CSV` work in progress\n\nYou can write a custom formatter in 20-ish lines.\n\n## Init once in main\n``` python\nfrom plogchain import LogChainer\n\n# Initialize a default chainer.\ntheLogger = LogChainer()\n\n# Register the formatter to the logger.\ntheLogger.initLogging()\n```\n\nHave a look at [the comprehensive guide of constructor parameters](#constructor-parameters).\n\n## Use everywhere with python logging module\n``` python\nimport logging\n\nlogging.debug("My message")\nlogging.info("Some information")\n```\n\n## Check your logs integrity afterwards\n``` python\nfrom plogchain import LogChainer\n\naLogChain = [\n\t"2020-03-30 13:38:00.782|0ec90b9839fdd964|TestChaining.py:20 test_logging_happy_case hello gg",\n\t"2020-03-30 13:38:00.782|2e3f1b4a7b946fb1|TestChaining.py:21 test_logging_happy_case voila1",\n\t"2020-03-30 13:38:00.782|10d1ab606618492a|TestChaining.py:22 test_logging_happy_case voila2",\n\t"2020-03-30 13:38:00.782|805757e144f4e385|TestChaining.py:23 test_logging_happy_case voila5",\n\t"2020-03-30 13:38:00.782|3bda90b5af77d3fe|TestChaining.py:24 test_logging_happy_case voila4"\n]\nresult = LogChainer.verify(aLogChain)\n\nif not result:\n\tprint("Last good line", result.prevLine)\n\tprint("First bad line", result.line)\nelse:\n\tprint("All right")\n```\n\n## Constructor parameters\n\nThey are passed as a dict and/or named arguments.\n``` python\nfrom plogchain import LogChainer\n\ntheLogger = LogChainer(verbosity = 3, secret = "mySignatureKey")\n\nparams = {"verbosity": 3, "secret": "mySignatureKey"}\ntheLogger = LogChainer(params, timestampFmt = "iso")\n```\n\n| Param | Default value | Description |\n| ----- | ------------- | ----------- |\n| formatterCls | formatters.Basic | Type of logging to perform, raw text, json, custom |\n| format | see below | Placeholder string used by raw-text loggers |\n| secret | secrets.token_urlsafe(128) | Signature key to compute the line signature |\n| seed | secrets.token_urlsafe() | Random string to sign into the first log line |\n| timestampFmt | "iso" | iso for 8601 or `strftime` compatible placeholders |\n| timestampPrecision | "milliseconds" | `timespec` element used by [the datetime library](https://docs.python.org/3/library/datetime.html#datetime.datetime.isoformat) |\n| timestampUtc | False | Transform the timestamp to its value in UTC |\n| stream | cout | Where the logs are sent, file/console/custom stream |\n| verbosity | 0 | Number [0..5] mapped to a logging.level |\n\nThe default format is `%(timestamp)s %(levelLetters)s %(fileLine)-15s %(funcName)-15s %(message)-60s |%(signature)s`. It relies on some extra fields like the signature at its end.\n\n\n## Plogchain extra logging fields\nWe enrich the standard logging record with some handy fields:\n\n| Name | Description |\n| ---- | ----------- |\n| fileLine | Widespread `filename:lineno` |\n| levelLetters | 4 first letters of logging level names: short and unambiguous |\n| signature | The digital signature of the previous line. Include it in all your lines to benefit from the chaining |\n| timestamp | Improved version of `asctime`, see below |\n\n\nThe `timestamp` field offers more flexibility than `asctime` in regards to:\n- the precision; can go up to the micro seconds (`msecs` cannot)\n- the decimal separator; you choose, \'.\' by default\n- utc or local timezone\n- customize the format only in one place: `timestampFmt`\n\n## Dynamic logging fields (WIP)\nThe package is suitable for server logging which context changes from one transaction to another.\nHere is an example of setting contextual information throughout the lifecycle of a server:\n\n``` python\n\n\tdef startServer(containerName)\n\t\t# Static formatting at program startup...\n\t\ttheLogger = LogChainer(formatterCls = formatters.Json)\n\t\ttheLogger.initLogging()\n\t\ttheLogger.setField(containerName = containerName)\n\n\tdef handleTransaction(transactionId, userId):\n\t\t# More contextual data later on\n\t\ttheLogger.setField(uId = userId, trxId = transactionId)\n\n```\n\n----\n\n# Contributing\n\n## Install\nSimply clone and submit pull requests.\n\n## Testing\nThe unit tests are located in the [test folder](https://github.com/gg-math/plogchain/tree/master/test)\nwhich contains the `__main__.py` entrypoint.\n\n``` bash\n# Run all\npython test\n\n# Get additional options\npython test --help\n```\n\n## Delivery\nUse to the awesome [Poetry tool](https://python-poetry.org) for this purpose:\n\n``` bash\npoetry build\npoetry publish\n```\n',
    'author': 'Gg Math',
    'author_email': 'code@gmath.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gg-math.github.io/plogchain',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.2,<4.0',
}


setup(**setup_kwargs)
