"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DbInstance = exports.DbInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const graphdatabase_generated_1 = require("./graphdatabase.generated");
Object.defineProperty(exports, "DbInstanceProperty", { enumerable: true, get: function () { return graphdatabase_generated_1.RosDbInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GraphDatabase::DbInstance`, which is used to create a Graph Database (GDB) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDbInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-graphdatabase-dbinstance
 */
class DbInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDbInstance = new graphdatabase_generated_1.RosDbInstance(this, id, {
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            dbInstanceNetworkType: props.dbInstanceNetworkType,
            vSwitchId: props.vSwitchId,
            ecsSecurityGroupRelations: props.ecsSecurityGroupRelations,
            dbInstanceStorageType: props.dbInstanceStorageType,
            dbNodeStorage: props.dbNodeStorage,
            backupSetId: props.backupSetId,
            dbInstanceCategory: props.dbInstanceCategory,
            sourceDbInstanceId: props.sourceDbInstanceId,
            vpcId: props.vpcId,
            dbInstanceIpArray: props.dbInstanceIpArray,
            dbVersion: props.dbVersion,
            createType: props.createType,
            paymentType: props.paymentType === undefined || props.paymentType === null ? 'PayAsYouGo' : props.paymentType,
            dbInstanceDescription: props.dbInstanceDescription,
            restoreType: props.restoreType,
            dbNodeClass: props.dbNodeClass,
            maintainTime: props.maintainTime,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDbInstance;
        this.attrConnectionString = rosDbInstance.attrConnectionString;
        this.attrCreateTime = rosDbInstance.attrCreateTime;
        this.attrCurrentMinorVersion = rosDbInstance.attrCurrentMinorVersion;
        this.attrDbInstanceIpArray = rosDbInstance.attrDbInstanceIpArray;
        this.attrDbInstanceCategory = rosDbInstance.attrDbInstanceCategory;
        this.attrDbInstanceCpu = rosDbInstance.attrDbInstanceCpu;
        this.attrDbInstanceDescription = rosDbInstance.attrDbInstanceDescription;
        this.attrDbInstanceId = rosDbInstance.attrDbInstanceId;
        this.attrDbInstanceMemory = rosDbInstance.attrDbInstanceMemory;
        this.attrDbInstanceNetworkType = rosDbInstance.attrDbInstanceNetworkType;
        this.attrDbInstanceStorageType = rosDbInstance.attrDbInstanceStorageType;
        this.attrDbInstanceType = rosDbInstance.attrDbInstanceType;
        this.attrDbNodeClass = rosDbInstance.attrDbNodeClass;
        this.attrDbNodeCount = rosDbInstance.attrDbNodeCount;
        this.attrDbNodeStorage = rosDbInstance.attrDbNodeStorage;
        this.attrDbVersion = rosDbInstance.attrDbVersion;
        this.attrEcsSecurityGroupRelations = rosDbInstance.attrEcsSecurityGroupRelations;
        this.attrExpireTime = rosDbInstance.attrExpireTime;
        this.attrExpired = rosDbInstance.attrExpired;
        this.attrLatestMinorVersion = rosDbInstance.attrLatestMinorVersion;
        this.attrLockMode = rosDbInstance.attrLockMode;
        this.attrLockReason = rosDbInstance.attrLockReason;
        this.attrMaintainTime = rosDbInstance.attrMaintainTime;
        this.attrPaymentType = rosDbInstance.attrPaymentType;
        this.attrPort = rosDbInstance.attrPort;
        this.attrPublicConnectionString = rosDbInstance.attrPublicConnectionString;
        this.attrPublicPort = rosDbInstance.attrPublicPort;
        this.attrReadOnlyDbInstanceIds = rosDbInstance.attrReadOnlyDbInstanceIds;
        this.attrResourceGroupId = rosDbInstance.attrResourceGroupId;
        this.attrTags = rosDbInstance.attrTags;
        this.attrVSwitchId = rosDbInstance.attrVSwitchId;
        this.attrVpcId = rosDbInstance.attrVpcId;
        this.attrZoneId = rosDbInstance.attrZoneId;
    }
}
exports.DbInstance = DbInstance;
//# sourceMappingURL=data:application/json;base64,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