import { defineComponent, inject, onMounted, onUnmounted, openBlock, createElementBlock, unref, normalizeClass } from "../vue.esm-browser.prod.js";
import { c as commonjsGlobal, g as getDefaultExportFromCjs, v as v4 } from "./index.js";
const version$1 = "2.4.3";
const { PI } = Math;
function angle_norm(angle) {
  if (angle == 0) {
    return 0;
  }
  while (angle <= 0) {
    angle += 2 * PI;
  }
  while (angle > 2 * PI) {
    angle -= 2 * PI;
  }
  return angle;
}
function angle_dist(lhs, rhs) {
  return angle_norm(lhs - rhs);
}
function angle_between(mid, lhs, rhs, anticlock = false) {
  const d = angle_dist(lhs, rhs);
  if (d == 0)
    return false;
  if (d == 2 * PI)
    return true;
  const norm_mid = angle_norm(mid);
  const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
  return !anticlock ? cond : !cond;
}
function random$1() {
  return Math.random();
}
function atan2(start2, end) {
  return Math.atan2(end[1] - start2[1], end[0] - start2[0]);
}
function resolve_angle(angle, units2) {
  return -to_radians_coeff(units2) * angle;
}
function to_radians_coeff(units2) {
  switch (units2) {
    case "deg":
      return PI / 180;
    case "rad":
      return 1;
    case "grad":
      return PI / 200;
    case "turn":
      return 2 * PI;
  }
}
function rnorm(mu, sigma) {
  let r1;
  let r2;
  while (true) {
    r1 = random$1();
    r2 = random$1();
    r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
    if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
      break;
  }
  let rn = r2 / r1;
  rn = mu + sigma * rn;
  return rn;
}
function clamp(val, min2, max2) {
  return val < min2 ? min2 : val > max2 ? max2 : val;
}
function log$1(x2, base = Math.E) {
  return Math.log(x2) / Math.log(base);
}
const float32_epsilon = 11920928955078125e-23;
class AssertionError extends Error {
}
AssertionError.__name__ = "AssertionError";
function assert(condition, message) {
  if (condition === true || condition !== false && condition())
    return;
  throw new AssertionError(message != null ? message : "Assertion failed");
}
function unreachable() {
  throw new Error("unreachable code");
}
function is_empty$1(array) {
  return array.length == 0;
}
function splice(array, start2, k, ...items) {
  const len = array.length;
  if (start2 < 0)
    start2 += len;
  if (start2 < 0)
    start2 = 0;
  else if (start2 > len)
    start2 = len;
  if (k == null || k > len - start2)
    k = len - start2;
  else if (k < 0)
    k = 0;
  const n2 = len - k + items.length;
  const result = new array.constructor(n2);
  let i2 = 0;
  for (; i2 < start2; i2++) {
    result[i2] = array[i2];
  }
  for (const item of items) {
    result[i2++] = item;
  }
  for (let j = start2 + k; j < len; j++) {
    result[i2++] = array[j];
  }
  return result;
}
function head(array, n2) {
  return splice(array, n2, array.length - n2);
}
function indexOf(array, item) {
  for (let i2 = 0, n2 = array.length; i2 < n2; i2++) {
    if (array[i2] === item)
      return i2;
  }
  return -1;
}
function mul(array, coeff, output) {
  const n2 = array.length;
  const result = output != null ? output : new array.constructor(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    result[i2] = array[i2] * coeff;
  }
  return result;
}
function map(array, fn) {
  const n2 = array.length;
  const result = new array.constructor(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    result[i2] = fn(array[i2], i2, array);
  }
  return result;
}
function inplace_map(array, fn, output) {
  const n2 = array.length;
  const result = output != null ? output : array;
  for (let i2 = 0; i2 < n2; i2++) {
    result[i2] = fn(array[i2], i2);
  }
}
function filter(array, pred) {
  const n2 = array.length;
  const result = new array.constructor(n2);
  let k = 0;
  for (let i2 = 0; i2 < n2; i2++) {
    const value = array[i2];
    if (pred(value, i2, array))
      result[k++] = value;
  }
  return head(result, k);
}
function reduce(array, fn, initial) {
  const n2 = array.length;
  if (initial === void 0 && n2 == 0)
    throw new Error("can't reduce an empty array without an initial value");
  let value;
  let i2;
  if (initial === void 0) {
    value = array[0];
    i2 = 1;
  } else {
    value = initial;
    i2 = 0;
  }
  for (; i2 < n2; i2++) {
    value = fn(value, array[i2], i2, array);
  }
  return value;
}
function min$6(array) {
  let value;
  let result = Infinity;
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    value = array[i2];
    if (!isNaN(value) && value < result) {
      result = value;
    }
  }
  return result;
}
function max$8(array) {
  let value;
  let result = -Infinity;
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    value = array[i2];
    if (!isNaN(value) && value > result) {
      result = value;
    }
  }
  return result;
}
function minmax(array) {
  let value;
  let min2 = Infinity;
  let max2 = -Infinity;
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    value = array[i2];
    if (!isNaN(value)) {
      if (value < min2) {
        min2 = value;
      }
      if (value > max2) {
        max2 = value;
      }
    }
  }
  return [min2, max2];
}
function minmax2(arr, brr) {
  let a2;
  let b;
  let a_min = Infinity;
  let a_max = -Infinity;
  let b_min = Infinity;
  let b_max = -Infinity;
  const n2 = Math.min(arr.length, brr.length);
  for (let i2 = 0; i2 < n2; i2++) {
    a2 = arr[i2];
    b = brr[i2];
    if (!isNaN(a2) && !isNaN(b)) {
      if (a2 < a_min)
        a_min = a2;
      if (a2 > a_max)
        a_max = a2;
      if (b < b_min)
        b_min = b;
      if (b > b_max)
        b_max = b;
    }
  }
  return [a_min, a_max, b_min, b_max];
}
function min_by(array, key) {
  if (array.length == 0)
    throw new Error("min_by() called with an empty array");
  let result = array[0];
  let resultComputed = key(result);
  for (let i2 = 1, length = array.length; i2 < length; i2++) {
    const value = array[i2];
    const computed = key(value);
    if (computed < resultComputed) {
      result = value;
      resultComputed = computed;
    }
  }
  return result;
}
function max_by(array, key) {
  if (array.length == 0)
    throw new Error("max_by() called with an empty array");
  let result = array[0];
  let resultComputed = key(result);
  for (let i2 = 1, length = array.length; i2 < length; i2++) {
    const value = array[i2];
    const computed = key(value);
    if (computed > resultComputed) {
      result = value;
      resultComputed = computed;
    }
  }
  return result;
}
function sum$2(array) {
  let result = 0;
  for (let i2 = 0, n2 = array.length; i2 < n2; i2++) {
    result += array[i2];
  }
  return result;
}
function cumsum(array) {
  const result = new array.constructor(array.length);
  reduce(array, (a2, b, i2) => result[i2] = a2 + b, 0);
  return result;
}
function every(array, predicate) {
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    if (!predicate(array[i2]))
      return false;
  }
  return true;
}
function some(array, predicate) {
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    if (predicate(array[i2]))
      return true;
  }
  return false;
}
function index_of(array, value) {
  for (let i2 = 0, length = array.length; i2 < length; i2++) {
    if (array[i2] === value)
      return i2;
  }
  return -1;
}
function _find_index(dir) {
  return function(array, predicate) {
    const length = array.length;
    let index2 = dir > 0 ? 0 : length - 1;
    for (; index2 >= 0 && index2 < length; index2 += dir) {
      if (predicate(array[index2]))
        return index2;
    }
    return -1;
  };
}
const find_index = _find_index(1);
const find_last_index = _find_index(-1);
function find(array, predicate) {
  const index2 = find_index(array, predicate);
  return index2 == -1 ? void 0 : array[index2];
}
function sorted_index(array, value) {
  let low = 0;
  let high = array.length;
  while (low < high) {
    const mid = Math.floor((low + high) / 2);
    if (array[mid] < value)
      low = mid + 1;
    else
      high = mid;
  }
  return low;
}
function bin_counts(data2, bin_edges) {
  const nbins = bin_edges.length - 1;
  const counts = Array(nbins).fill(0);
  for (let i2 = 0; i2 < data2.length; i2++) {
    const sample = data2[i2];
    const index2 = sorted_index(bin_edges, sample);
    const bin = clamp(index2 - 1, 0, nbins - 1);
    counts[bin] += 1;
  }
  return counts;
}
function interpolate(points, x_values, y_values) {
  const n2 = points.length;
  const results = new Array(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    const point = points[i2];
    if (isNaN(point)) {
      results[i2] = point;
      continue;
    }
    const index2 = left_edge_index(point, x_values);
    if (index2 == -1)
      results[i2] = y_values[0];
    else if (index2 == x_values.length)
      results[i2] = y_values[y_values.length - 1];
    else if (index2 == x_values.length - 1 || x_values[index2] == point) {
      results[i2] = y_values[index2];
    } else {
      const x0 = x_values[index2];
      const y0 = y_values[index2];
      const x1 = x_values[index2 + 1];
      const y1 = y_values[index2 + 1];
      results[i2] = lerp(point, x0, y0, x1, y1);
    }
  }
  return results;
}
function lerp(x2, x0, y0, x1, y1) {
  const slope = (y1 - y0) / (x1 - x0);
  let res = slope * (x2 - x0) + y0;
  if (!isFinite(res)) {
    res = slope * (x2 - x1) + y1;
    if (!isFinite(res) && y0 == y1)
      res = y0;
  }
  return res;
}
function left_edge_index(point, intervals) {
  if (point < intervals[0])
    return -1;
  if (point > intervals[intervals.length - 1])
    return intervals.length;
  let leftEdgeIndex = 0;
  let rightEdgeIndex = intervals.length - 1;
  while (rightEdgeIndex - leftEdgeIndex != 1) {
    const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
    if (point >= intervals[indexOfNumberToCompare])
      leftEdgeIndex = indexOfNumberToCompare;
    else
      rightEdgeIndex = indexOfNumberToCompare;
  }
  return leftEdgeIndex;
}
const slice$2 = Array.prototype.slice;
function copy(array) {
  return slice$2.call(array);
}
function concat$1(arrays) {
  return [].concat(...arrays);
}
function includes(array, value) {
  return array.indexOf(value) !== -1;
}
const contains = includes;
function nth(array, index2) {
  return array[index2 >= 0 ? index2 : array.length + index2];
}
function zip(...arrays) {
  if (arrays.length == 0)
    return [];
  const n2 = min$6(arrays.map((a2) => a2.length));
  const k = arrays.length;
  const result = new Array(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    result[i2] = new Array(k);
    for (let j = 0; j < k; j++)
      result[i2][j] = arrays[j][i2];
  }
  return result;
}
function unzip(array) {
  const n2 = array.length;
  const k = min$6(array.map((a2) => a2.length));
  const results = Array(k);
  for (let j = 0; j < k; j++)
    results[j] = new Array(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    for (let j = 0; j < k; j++)
      results[j][i2] = array[i2][j];
  }
  return results;
}
function range(start2, stop, step = 1) {
  assert(step > 0, "'step' must be a positive number");
  if (stop == null) {
    stop = start2;
    start2 = 0;
  }
  const { max: max2, ceil: ceil2, abs: abs2 } = Math;
  const delta = start2 <= stop ? step : -step;
  const length = max2(ceil2(abs2(stop - start2) / step), 0);
  const range2 = new Array(length);
  for (let i2 = 0; i2 < length; i2++, start2 += delta) {
    range2[i2] = start2;
  }
  return range2;
}
function linspace(start2, stop, num2 = 100) {
  const step = (stop - start2) / (num2 - 1);
  const array = new Array(num2);
  for (let i2 = 0; i2 < num2; i2++) {
    array[i2] = start2 + step * i2;
  }
  return array;
}
function argmin(array) {
  return min_by(range(array.length), (i2) => array[i2]);
}
function sort_by(array, key) {
  const tmp = array.map((value, index2) => {
    return { value, index: index2, key: key(value) };
  });
  tmp.sort((left2, right2) => {
    const a2 = left2.key;
    const b = right2.key;
    if (a2 !== b) {
      if (a2 > b || a2 === void 0)
        return 1;
      if (a2 < b || b === void 0)
        return -1;
    }
    return left2.index - right2.index;
  });
  return tmp.map((item) => item.value);
}
function uniq(array) {
  const result = /* @__PURE__ */ new Set();
  for (const value of array) {
    result.add(value);
  }
  return [...result];
}
function union$2(...arrays) {
  const result = /* @__PURE__ */ new Set();
  for (const array of arrays) {
    for (const value of array) {
      result.add(value);
    }
  }
  return [...result];
}
function intersection(array, ...arrays) {
  const result = [];
  top:
    for (const item of array) {
      if (includes(result, item))
        continue;
      for (const other of arrays) {
        if (!includes(other, item))
          continue top;
      }
      result.push(item);
    }
  return result;
}
function difference$1(array, ...arrays) {
  const rest = concat$1(arrays);
  return array.filter((value) => !includes(rest, value));
}
function remove_at(array, i2) {
  const result = copy(array);
  result.splice(i2, 1);
  return result;
}
function remove_by(array, key) {
  for (let i2 = 0; i2 < array.length; ) {
    if (key(array[i2]))
      array.splice(i2, 1);
    else
      i2++;
  }
}
function reversed(array) {
  const n2 = array.length;
  const result = new Array(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    result[n2 - i2 - 1] = array[i2];
  }
  return result;
}
function repeat(value, n2) {
  const result = new Array(n2);
  for (let i2 = 0; i2 < n2; i2++) {
    result[i2] = value;
  }
  return result;
}
const toString$2 = Object.prototype.toString;
function isBoolean(obj) {
  return obj === true || obj === false || toString$2.call(obj) === "[object Boolean]";
}
function isNumber(obj) {
  return toString$2.call(obj) === "[object Number]";
}
function isInteger(obj) {
  return isNumber(obj) && Number.isInteger(obj);
}
function isString(obj) {
  return toString$2.call(obj) === "[object String]";
}
function isSymbol(obj) {
  return typeof obj === "symbol";
}
function isPrimitive(obj) {
  return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj) || isSymbol(obj);
}
function isFunction(obj) {
  return toString$2.call(obj) === "[object Function]";
}
function isArray(obj) {
  return Array.isArray(obj);
}
function isArrayOf(arr, predicate) {
  return every(arr, predicate);
}
function isArrayableOf(arr, predicate) {
  for (let i2 = 0, end = arr.length; i2 < end; i2++) {
    if (!predicate(arr[i2]))
      return false;
  }
  return true;
}
function isTypedArray(obj) {
  return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
}
function isObject(obj) {
  const tp = typeof obj;
  return tp === "function" || tp === "object" && !!obj;
}
function isPlainObject(obj) {
  return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
}
function isIterable(obj) {
  return isObject(obj) && obj[Symbol.iterator] !== void 0;
}
const { hasOwnProperty: hasOwnProperty$5 } = Object.prototype;
const { keys, values, entries, assign: extend$1 } = Object;
function clone$1(obj) {
  return { ...obj };
}
function merge(obj1, obj2) {
  const result = Object.create(Object.prototype);
  const keys2 = concat$1([Object.keys(obj1), Object.keys(obj2)]);
  for (const key of keys2) {
    const arr1 = hasOwnProperty$5.call(obj1, key) ? obj1[key] : [];
    const arr2 = hasOwnProperty$5.call(obj2, key) ? obj2[key] : [];
    result[key] = union$2(arr1, arr2);
  }
  return result;
}
function size$1(obj) {
  return Object.keys(obj).length;
}
function is_empty(obj) {
  return size$1(obj) == 0;
}
const isEmpty = is_empty;
function to_object(map2) {
  const obj = {};
  for (const [key, val] of map2) {
    obj[key] = val;
  }
  return obj;
}
const channel = new MessageChannel();
const tasks = /* @__PURE__ */ new Map();
channel.port1.onmessage = (event2) => {
  const handle = event2.data;
  const fn = tasks.get(handle);
  if (fn != null) {
    try {
      fn();
    } finally {
      tasks.delete(handle);
    }
  }
};
let counter$1 = 1;
function defer() {
  return new Promise((resolve) => {
    const handle = counter$1++;
    tasks.set(handle, resolve);
    channel.port2.postMessage(handle);
  });
}
class Signal {
  constructor(sender, name) {
    this.sender = sender;
    this.name = name;
  }
  connect(slot, context = null) {
    if (!receiversForSender.has(this.sender)) {
      receiversForSender.set(this.sender, []);
    }
    const receivers = receiversForSender.get(this.sender);
    if (find_connection(receivers, this, slot, context) != null) {
      return false;
    }
    const receiver = context != null ? context : slot;
    if (!sendersForReceiver.has(receiver)) {
      sendersForReceiver.set(receiver, []);
    }
    const senders = sendersForReceiver.get(receiver);
    const connection = { signal: this, slot, context };
    receivers.push(connection);
    senders.push(connection);
    return true;
  }
  disconnect(slot, context = null) {
    const receivers = receiversForSender.get(this.sender);
    if (receivers == null || receivers.length === 0) {
      return false;
    }
    const connection = find_connection(receivers, this, slot, context);
    if (connection == null) {
      return false;
    }
    const receiver = context != null ? context : slot;
    const senders = sendersForReceiver.get(receiver);
    connection.signal = null;
    schedule_cleanup(receivers);
    schedule_cleanup(senders);
    return true;
  }
  emit(args) {
    var _a2;
    const receivers = (_a2 = receiversForSender.get(this.sender)) != null ? _a2 : [];
    for (const { signal, slot, context } of receivers) {
      if (signal === this) {
        slot.call(context, args, this.sender);
      }
    }
  }
}
Signal.__name__ = "Signal";
class Signal0 extends Signal {
  emit() {
    super.emit(void 0);
  }
}
Signal0.__name__ = "Signal0";
(function(Signal2) {
  function disconnect_between(sender, receiver) {
    const receivers = receiversForSender.get(sender);
    if (receivers == null || receivers.length === 0)
      return;
    const senders = sendersForReceiver.get(receiver);
    if (senders == null || senders.length === 0)
      return;
    for (const connection of senders) {
      if (connection.signal == null)
        return;
      if (connection.signal.sender === sender)
        connection.signal = null;
    }
    schedule_cleanup(receivers);
    schedule_cleanup(senders);
  }
  Signal2.disconnect_between = disconnect_between;
  function disconnect_sender(sender) {
    var _a2;
    const receivers = receiversForSender.get(sender);
    if (receivers == null || receivers.length === 0)
      return;
    for (const connection of receivers) {
      if (connection.signal == null)
        return;
      const receiver = (_a2 = connection.context) != null ? _a2 : connection.slot;
      connection.signal = null;
      schedule_cleanup(sendersForReceiver.get(receiver));
    }
    schedule_cleanup(receivers);
  }
  Signal2.disconnect_sender = disconnect_sender;
  function disconnect_receiver(receiver, slot, except_senders) {
    const senders = sendersForReceiver.get(receiver);
    if (senders == null || senders.length === 0)
      return;
    for (const connection of senders) {
      if (connection.signal == null)
        return;
      if (slot != null && connection.slot != slot)
        continue;
      const sender = connection.signal.sender;
      if (except_senders != null && except_senders.has(sender))
        continue;
      connection.signal = null;
      schedule_cleanup(receiversForSender.get(sender));
    }
    schedule_cleanup(senders);
  }
  Signal2.disconnect_receiver = disconnect_receiver;
  function disconnect_all(obj) {
    const receivers = receiversForSender.get(obj);
    if (receivers != null && receivers.length !== 0) {
      for (const connection of receivers) {
        connection.signal = null;
      }
      schedule_cleanup(receivers);
    }
    const senders = sendersForReceiver.get(obj);
    if (senders != null && senders.length !== 0) {
      for (const connection of senders) {
        connection.signal = null;
      }
      schedule_cleanup(senders);
    }
  }
  Signal2.disconnect_all = disconnect_all;
  Signal2.disconnectBetween = disconnect_between;
  Signal2.disconnectSender = disconnect_sender;
  Signal2.disconnectReceiver = disconnect_receiver;
  Signal2.disconnectAll = disconnect_all;
})(Signal || (Signal = {}));
function Signalable() {
  return class {
    connect(signal, slot) {
      return signal.connect(slot, this);
    }
    disconnect(signal, slot) {
      return signal.disconnect(slot, this);
    }
  };
}
const receiversForSender = /* @__PURE__ */ new WeakMap();
const sendersForReceiver = /* @__PURE__ */ new WeakMap();
function find_connection(conns, signal, slot, context) {
  return find(conns, (conn) => conn.signal === signal && conn.slot === slot && conn.context === context);
}
const dirty_set = /* @__PURE__ */ new Set();
function schedule_cleanup(connections) {
  if (dirty_set.size === 0) {
    (async () => {
      await defer();
      cleanup_dirty_set();
    })();
  }
  dirty_set.add(connections);
}
function cleanup_dirty_set() {
  for (const connections of dirty_set) {
    remove_by(connections, (connection) => connection.signal == null);
  }
  dirty_set.clear();
}
function is_ref(arg) {
  if (isPlainObject(arg)) {
    const attrs = keys(arg);
    return attrs.length == 1 && attrs[0] == "id";
  }
  return false;
}
const _loggers = {};
class LogLevel {
  constructor(name, level) {
    this.name = name;
    this.level = level;
  }
}
LogLevel.__name__ = "LogLevel";
class Logger {
  constructor(name, level = Logger.INFO) {
    this._name = name;
    this.set_level(level);
  }
  static get levels() {
    return Object.keys(Logger.log_levels);
  }
  static get(name, level = Logger.INFO) {
    if (name.length > 0) {
      let logger2 = _loggers[name];
      if (logger2 == null)
        _loggers[name] = logger2 = new Logger(name, level);
      return logger2;
    } else
      throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
  }
  get level() {
    return this.get_level();
  }
  get_level() {
    return this._log_level;
  }
  set_level(log_level) {
    if (log_level instanceof LogLevel)
      this._log_level = log_level;
    else if (isString(log_level) && Logger.log_levels[log_level] != null)
      this._log_level = Logger.log_levels[log_level];
    else
      throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
    const logger_name = `[${this._name}]`;
    for (const [name, log_level2] of entries(Logger.log_levels)) {
      if (log_level2.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
        this[name] = function() {
        };
      else
        this[name] = _method_factory(name, logger_name);
    }
  }
  trace(..._args) {
  }
  debug(..._args) {
  }
  info(..._args) {
  }
  warn(..._args) {
  }
  error(..._args) {
  }
}
Logger.__name__ = "Logger";
Logger.TRACE = new LogLevel("trace", 0);
Logger.DEBUG = new LogLevel("debug", 1);
Logger.INFO = new LogLevel("info", 2);
Logger.WARN = new LogLevel("warn", 6);
Logger.ERROR = new LogLevel("error", 7);
Logger.FATAL = new LogLevel("fatal", 8);
Logger.OFF = new LogLevel("off", 9);
Logger.log_levels = {
  trace: Logger.TRACE,
  debug: Logger.DEBUG,
  info: Logger.INFO,
  warn: Logger.WARN,
  error: Logger.ERROR,
  fatal: Logger.FATAL,
  off: Logger.OFF
};
function _method_factory(method_name, logger_name) {
  if (console[method_name] != null)
    return console[method_name].bind(console, logger_name);
  else if (console.log != null)
    return console.log.bind(console, logger_name);
  else
    return function() {
    };
}
const logger = Logger.get("bokeh");
const _named_colors = {
  aliceblue: 4042850303,
  antiquewhite: 4209760255,
  aqua: 16777215,
  aquamarine: 2147472639,
  azure: 4043309055,
  beige: 4126530815,
  bisque: 4293182719,
  black: 255,
  blanchedalmond: 4293643775,
  blue: 65535,
  blueviolet: 2318131967,
  brown: 2771004159,
  burlywood: 3736635391,
  cadetblue: 1604231423,
  chartreuse: 2147418367,
  chocolate: 3530104575,
  coral: 4286533887,
  cornflowerblue: 1687547391,
  cornsilk: 4294499583,
  crimson: 3692313855,
  cyan: 16777215,
  darkblue: 35839,
  darkcyan: 9145343,
  darkgoldenrod: 3095792639,
  darkgray: 2846468607,
  darkgreen: 6553855,
  darkgrey: 2846468607,
  darkkhaki: 3182914559,
  darkmagenta: 2332068863,
  darkolivegreen: 1433087999,
  darkorange: 4287365375,
  darkorchid: 2570243327,
  darkred: 2332033279,
  darksalmon: 3918953215,
  darkseagreen: 2411499519,
  darkslateblue: 1211993087,
  darkslategray: 793726975,
  darkslategrey: 793726975,
  darkturquoise: 13554175,
  darkviolet: 2483082239,
  deeppink: 4279538687,
  deepskyblue: 12582911,
  dimgray: 1768516095,
  dimgrey: 1768516095,
  dodgerblue: 512819199,
  firebrick: 2988581631,
  floralwhite: 4294635775,
  forestgreen: 579543807,
  fuchsia: 4278255615,
  gainsboro: 3705462015,
  ghostwhite: 4177068031,
  gold: 4292280575,
  goldenrod: 3668254975,
  gray: 2155905279,
  green: 8388863,
  greenyellow: 2919182335,
  grey: 2155905279,
  honeydew: 4043305215,
  hotpink: 4285117695,
  indianred: 3445382399,
  indigo: 1258324735,
  ivory: 4294963455,
  khaki: 4041641215,
  lavender: 3873897215,
  lavenderblush: 4293981695,
  lawngreen: 2096890111,
  lemonchiffon: 4294626815,
  lightblue: 2916673279,
  lightcoral: 4034953471,
  lightcyan: 3774873599,
  lightgoldenrodyellow: 4210742015,
  lightgray: 3553874943,
  lightgreen: 2431553791,
  lightgrey: 3553874943,
  lightpink: 4290167295,
  lightsalmon: 4288707327,
  lightseagreen: 548580095,
  lightskyblue: 2278488831,
  lightslategray: 2005441023,
  lightslategrey: 2005441023,
  lightsteelblue: 2965692159,
  lightyellow: 4294959359,
  lime: 16711935,
  limegreen: 852308735,
  linen: 4210091775,
  magenta: 4278255615,
  maroon: 2147483903,
  mediumaquamarine: 1724754687,
  mediumblue: 52735,
  mediumorchid: 3126187007,
  mediumpurple: 2473647103,
  mediumseagreen: 1018393087,
  mediumslateblue: 2070474495,
  mediumspringgreen: 16423679,
  mediumturquoise: 1221709055,
  mediumvioletred: 3340076543,
  midnightblue: 421097727,
  mintcream: 4127193855,
  mistyrose: 4293190143,
  moccasin: 4293178879,
  navajowhite: 4292783615,
  navy: 33023,
  oldlace: 4260751103,
  olive: 2155872511,
  olivedrab: 1804477439,
  orange: 4289003775,
  orangered: 4282712319,
  orchid: 3664828159,
  palegoldenrod: 4008225535,
  palegreen: 2566625535,
  paleturquoise: 2951671551,
  palevioletred: 3681588223,
  papayawhip: 4293907967,
  peachpuff: 4292524543,
  peru: 3448061951,
  pink: 4290825215,
  plum: 3718307327,
  powderblue: 2967529215,
  purple: 2147516671,
  rebeccapurple: 1714657791,
  red: 4278190335,
  rosybrown: 3163525119,
  royalblue: 1097458175,
  saddlebrown: 2336560127,
  salmon: 4202722047,
  sandybrown: 4104413439,
  seagreen: 780883967,
  seashell: 4294307583,
  sienna: 2689740287,
  silver: 3233857791,
  skyblue: 2278484991,
  slateblue: 1784335871,
  slategray: 1887473919,
  slategrey: 1887473919,
  snow: 4294638335,
  springgreen: 16744447,
  steelblue: 1182971135,
  tan: 3535047935,
  teal: 8421631,
  thistle: 3636451583,
  tomato: 4284696575,
  turquoise: 1088475391,
  violet: 4001558271,
  wheat: 4125012991,
  white: 4294967295,
  whitesmoke: 4126537215,
  yellow: 4294902015,
  yellowgreen: 2597139199
};
const named_colors = _named_colors;
function is_named_color(color) {
  return color in named_colors;
}
const { round: round$3 } = Math;
function byte(v) {
  return clamp(round$3(v), 0, 255);
}
function transparent() {
  return [0, 0, 0, 0];
}
function encode_rgba([r, g, b, a2]) {
  return r << 24 | g << 16 | b << 8 | a2;
}
function decode_rgba(rgba) {
  const r = rgba >> 24 & 255;
  const g = rgba >> 16 & 255;
  const b = rgba >> 8 & 255;
  const a2 = rgba & 255;
  return [r, g, b, a2];
}
function color2rgba(color, alpha) {
  var _a2;
  let r, g, b, a2;
  if (color == null)
    [r, g, b, a2] = transparent();
  else if (isInteger(color))
    [r, g, b, a2] = decode_rgba(color);
  else if (isString(color))
    [r, g, b, a2] = (_a2 = css4_parse(color)) != null ? _a2 : transparent();
  else {
    [r, g, b, a2 = 1] = color;
    a2 = byte(a2 * 255);
  }
  if (a2 == 255 && alpha != null)
    a2 = byte(alpha * 255);
  return [r, g, b, a2];
}
const _hex_table = {
  0: "0",
  1: "1",
  2: "2",
  3: "3",
  4: "4",
  5: "5",
  6: "6",
  7: "7",
  8: "8",
  9: "9",
  10: "a",
  11: "b",
  12: "c",
  13: "d",
  14: "e",
  15: "f"
};
function hex$1(v) {
  return _hex_table[v >> 4] + _hex_table[v & 15];
}
function color2css(color, alpha) {
  const [r, g, b, a2] = color2rgba(color, alpha);
  return `rgba(${r}, ${g}, ${b}, ${a2 / 255})`;
}
function color2hex(color, alpha) {
  const [r, g, b, a2] = color2rgba(color, alpha);
  const rgb = `#${hex$1(r)}${hex$1(g)}${hex$1(b)}`;
  return a2 == 255 ? rgb : `${rgb}${hex$1(a2)}`;
}
function color2hexrgb(color) {
  const [r, g, b] = color2rgba(color);
  return `#${hex$1(r)}${hex$1(g)}${hex$1(b)}`;
}
const rgb_modern = /^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/;
const rgb_legacy = /^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/;
const css4_normalize = (() => {
  const canvas2 = document.createElement("canvas");
  canvas2.width = 1;
  canvas2.height = 1;
  const ctx = canvas2.getContext("2d");
  const gradient = ctx.createLinearGradient(0, 0, 1, 1);
  return (color) => {
    ctx.fillStyle = gradient;
    ctx.fillStyle = color;
    const style2 = ctx.fillStyle;
    return style2 != gradient ? style2 : null;
  };
})();
function css4_parse(color) {
  var _a2;
  color = color.trim().toLowerCase();
  if (!color)
    return null;
  else if (color == "transparent")
    return transparent();
  else if (is_named_color(color)) {
    return decode_rgba(named_colors[color]);
  } else if (color[0] == "#") {
    const v = Number(`0x${color.substr(1)}`);
    if (isNaN(v))
      return null;
    switch (color.length - 1) {
      case 3: {
        const r = v >> 8 & 15;
        const g = v >> 4 & 15;
        const b = v >> 0 & 15;
        const rr = r << 4 | r;
        const gg = g << 4 | g;
        const bb = b << 4 | b;
        return [rr, gg, bb, 255];
      }
      case 4: {
        const r = v >> 12 & 15;
        const g = v >> 8 & 15;
        const b = v >> 4 & 15;
        const a2 = v >> 0 & 15;
        const rr = r << 4 | r;
        const gg = g << 4 | g;
        const bb = b << 4 | b;
        const aa = a2 << 4 | a2;
        return [rr, gg, bb, aa];
      }
      case 6: {
        const rr = v >> 16 & 255;
        const gg = v >> 8 & 255;
        const bb = v >> 0 & 255;
        return [rr, gg, bb, 255];
      }
      case 8: {
        const rr = v >> 24 & 255;
        const gg = v >> 16 & 255;
        const bb = v >> 8 & 255;
        const aa = v >> 0 & 255;
        return [rr, gg, bb, aa];
      }
    }
  } else if (color.startsWith("rgb")) {
    const result = (_a2 = color.match(rgb_modern)) != null ? _a2 : color.match(rgb_legacy);
    if (result != null) {
      let [, r, g, b, a2 = "1"] = result;
      const rp = r.endsWith("%");
      const gp = g.endsWith("%");
      const bp = b.endsWith("%");
      const ap = a2.endsWith("%");
      if (!(rp && gp && bp || !rp && !gp && !bp))
        return null;
      if (rp)
        r = r.slice(0, -1);
      if (gp)
        g = g.slice(0, -1);
      if (bp)
        b = b.slice(0, -1);
      if (ap)
        a2 = a2.slice(0, -1);
      let R = Number(r);
      let G = Number(g);
      let B = Number(b);
      let A = Number(a2);
      if (isNaN(R + G + B + A))
        return null;
      if (rp)
        R = 255 * (R / 100);
      if (gp)
        G = 255 * (G / 100);
      if (bp)
        B = 255 * (B / 100);
      A = 255 * (ap ? A / 100 : A);
      R = byte(R);
      G = byte(G);
      B = byte(B);
      A = byte(A);
      return [R, G, B, A];
    }
  } else {
    const style2 = css4_normalize(color);
    if (style2 != null)
      return css4_parse(style2);
  }
  return null;
}
function is_Color(value) {
  if (isInteger(value))
    return true;
  if (isString(value) && css4_parse(value) != null)
    return true;
  if (isArray(value) && (value.length == 3 || value.length == 4))
    return true;
  return false;
}
const ESMap = window.Map;
const { hasOwnProperty: hasOwnProperty$4 } = Object.prototype;
class Kind {
}
Kind.__name__ = "Kind";
var Kinds;
(function(Kinds2) {
  class Any2 extends Kind {
    valid(_value) {
      return true;
    }
  }
  Any2.__name__ = "Any";
  Kinds2.Any = Any2;
  class Unknown2 extends Kind {
    valid(_value) {
      return true;
    }
  }
  Unknown2.__name__ = "Unknown";
  Kinds2.Unknown = Unknown2;
  class Boolean2 extends Kind {
    valid(value) {
      return isBoolean(value);
    }
  }
  Boolean2.__name__ = "Boolean";
  Kinds2.Boolean = Boolean2;
  class Ref2 extends Kind {
    constructor(obj_type) {
      super();
      this.obj_type = obj_type;
    }
    valid(_value) {
      return true;
    }
  }
  Ref2.__name__ = "Ref";
  Kinds2.Ref = Ref2;
  class AnyRef2 extends Kind {
    valid(_value) {
      return true;
    }
  }
  AnyRef2.__name__ = "AnyRef";
  Kinds2.AnyRef = AnyRef2;
  class Number2 extends Kind {
    valid(value) {
      return isNumber(value);
    }
  }
  Number2.__name__ = "Number";
  Kinds2.Number = Number2;
  class Int2 extends Number2 {
    valid(value) {
      return super.valid(value) && isInteger(value);
    }
  }
  Int2.__name__ = "Int";
  Kinds2.Int = Int2;
  class Percent2 extends Number2 {
    valid(value) {
      return super.valid(value) && 0 <= value && value <= 1;
    }
  }
  Percent2.__name__ = "Percent";
  Kinds2.Percent = Percent2;
  class Or2 extends Kind {
    constructor(types) {
      super();
      this.types = types;
      this.types = types;
    }
    valid(value) {
      return this.types.some((type) => type.valid(value));
    }
  }
  Or2.__name__ = "Or";
  Kinds2.Or = Or2;
  class Tuple2 extends Kind {
    constructor(types) {
      super();
      this.types = types;
      this.types = types;
    }
    valid(value) {
      if (!isArray(value))
        return false;
      for (let i2 = 0; i2 < this.types.length; i2++) {
        const type = this.types[i2];
        const item = value[i2];
        if (!type.valid(item))
          return false;
      }
      return true;
    }
  }
  Tuple2.__name__ = "Tuple";
  Kinds2.Tuple = Tuple2;
  class Struct2 extends Kind {
    constructor(struct_type) {
      super();
      this.struct_type = struct_type;
    }
    valid(value) {
      if (!isPlainObject(value))
        return false;
      const { struct_type } = this;
      if (size$1(struct_type) != size$1(value))
        return false;
      for (const key in struct_type) {
        if (hasOwnProperty$4.call(struct_type, key)) {
          if (!hasOwnProperty$4.call(value, key))
            return false;
          const item_type = struct_type[key];
          const item = value[key];
          if (!item_type.valid(item))
            return false;
        }
      }
      return true;
    }
  }
  Struct2.__name__ = "Struct";
  Kinds2.Struct = Struct2;
  class Arrayable2 extends Kind {
    valid(value) {
      return isArray(value) || isTypedArray(value);
    }
  }
  Arrayable2.__name__ = "Arrayable";
  Kinds2.Arrayable = Arrayable2;
  class Array2 extends Kind {
    constructor(item_type) {
      super();
      this.item_type = item_type;
    }
    valid(value) {
      return isArray(value) && value.every((item) => this.item_type.valid(item));
    }
  }
  Array2.__name__ = "Array";
  Kinds2.Array = Array2;
  class Null2 extends Kind {
    valid(value) {
      return value === null;
    }
  }
  Null2.__name__ = "Null";
  Kinds2.Null = Null2;
  class Nullable2 extends Kind {
    constructor(base_type) {
      super();
      this.base_type = base_type;
    }
    valid(value) {
      return value === null || this.base_type.valid(value);
    }
  }
  Nullable2.__name__ = "Nullable";
  Kinds2.Nullable = Nullable2;
  class Opt2 extends Kind {
    constructor(base_type) {
      super();
      this.base_type = base_type;
    }
    valid(value) {
      return value === void 0 || this.base_type.valid(value);
    }
  }
  Opt2.__name__ = "Opt";
  Kinds2.Opt = Opt2;
  class String2 extends Kind {
    valid(value) {
      return isString(value);
    }
  }
  String2.__name__ = "String";
  Kinds2.String = String2;
  class Enum2 extends Kind {
    constructor(values2) {
      super();
      this.values = new Set(values2);
    }
    valid(value) {
      return this.values.has(value);
    }
    *[Symbol.iterator]() {
      yield* this.values;
    }
  }
  Enum2.__name__ = "Enum";
  Kinds2.Enum = Enum2;
  class Dict2 extends Kind {
    constructor(item_type) {
      super();
      this.item_type = item_type;
    }
    valid(value) {
      if (!isPlainObject(value))
        return false;
      for (const key in value) {
        if (hasOwnProperty$4.call(value, key)) {
          const item = value[key];
          if (!this.item_type.valid(item))
            return false;
        }
      }
      return true;
    }
  }
  Dict2.__name__ = "Dict";
  Kinds2.Dict = Dict2;
  class Map3 extends Kind {
    constructor(key_type, item_type) {
      super();
      this.key_type = key_type;
      this.item_type = item_type;
    }
    valid(value) {
      if (!(value instanceof ESMap))
        return false;
      for (const [key, item] of value.entries()) {
        if (!(this.key_type.valid(key) && this.item_type.valid(item)))
          return false;
      }
      return true;
    }
  }
  Map3.__name__ = "Map";
  Kinds2.Map = Map3;
  class Color2 extends Kind {
    valid(value) {
      return is_Color(value);
    }
  }
  Color2.__name__ = "Color";
  Kinds2.Color = Color2;
  class Function2 extends Kind {
    valid(value) {
      return isFunction(value);
    }
  }
  Function2.__name__ = "Function";
  Kinds2.Function = Function2;
})(Kinds || (Kinds = {}));
const Any$1 = new Kinds.Any();
const Unknown = new Kinds.Unknown();
const Boolean$2 = new Kinds.Boolean();
const Number$2 = new Kinds.Number();
const Int$1 = new Kinds.Int();
const String$2 = new Kinds.String();
const Null = new Kinds.Null();
const Nullable = (base_type) => new Kinds.Nullable(base_type);
const Opt = (base_type) => new Kinds.Opt(base_type);
const Or = (...types) => new Kinds.Or(types);
const Tuple = (...types) => new Kinds.Tuple(types);
const Struct = (struct_type) => new Kinds.Struct(struct_type);
const Arrayable = new Kinds.Arrayable();
const Array$2 = (item_type) => new Kinds.Array(item_type);
const Dict = (item_type) => new Kinds.Dict(item_type);
const Map$2 = (key_type, item_type) => new Kinds.Map(key_type, item_type);
const Enum = (...values2) => new Kinds.Enum(values2);
const Ref = (obj_type) => new Kinds.Ref(obj_type);
const AnyRef = () => new Kinds.AnyRef();
const Function$1 = () => new Kinds.Function();
const Percent$1 = new Kinds.Percent();
const Alpha = Percent$1;
const Color$1 = new Kinds.Color();
const Auto = Enum("auto");
const FontSize$1 = String$2;
const Font$1 = String$2;
const Angle$1 = Number$2;
var kinds = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Kind,
  get Kinds() {
    return Kinds;
  },
  Any: Any$1,
  Unknown,
  Boolean: Boolean$2,
  Number: Number$2,
  Int: Int$1,
  String: String$2,
  Null,
  Nullable,
  Opt,
  Or,
  Tuple,
  Struct,
  Arrayable,
  Array: Array$2,
  Dict,
  Map: Map$2,
  Enum,
  Ref,
  AnyRef,
  Function: Function$1,
  Percent: Percent$1,
  Alpha,
  Color: Color$1,
  Auto,
  FontSize: FontSize$1,
  Font: Font$1,
  Angle: Angle$1
}, Symbol.toStringTag, { value: "Module" }));
const Align = Enum("start", "center", "end");
const Anchor = Enum("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
const AngleUnits = Enum("deg", "rad", "grad", "turn");
const BoxOrigin = Enum("corner", "center");
const ButtonType = Enum("default", "primary", "success", "warning", "danger", "light");
const CalendarPosition = Enum("auto", "above", "below");
const Dimension = Enum("width", "height");
const Dimensions = Enum("width", "height", "both");
const Direction$1 = Enum("clock", "anticlock");
const Distribution = Enum("uniform", "normal");
const FontStyle = Enum("normal", "italic", "bold", "bold italic");
const HatchPatternType = Enum("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
const HTTPMethod = Enum("POST", "GET");
const HexTileOrientation = Enum("pointytop", "flattop");
const HoverMode = Enum("mouse", "hline", "vline");
const LatLon = Enum("lat", "lon");
const LegendClickPolicy = Enum("none", "hide", "mute");
const LegendLocation = Anchor;
const LineCap = Enum("butt", "round", "square");
const LineJoin = Enum("miter", "round", "bevel");
const LineDash = Enum("solid", "dashed", "dotted", "dotdash", "dashdot");
const LinePolicy = Enum("prev", "next", "nearest", "interp", "none");
const Location = Enum("above", "below", "left", "right");
const Logo = Enum("normal", "grey");
const MarkerType = Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
const MutedPolicy = Enum("show", "ignore");
const Orientation = Enum("vertical", "horizontal");
const OutputBackend = Enum("canvas", "svg", "webgl");
const PaddingUnits = Enum("percent", "absolute");
Enum("above", "below", "left", "right", "center");
const PointPolicy = Enum("snap_to_data", "follow_mouse", "none");
const RadiusDimension = Enum("x", "y", "max", "min");
const RenderLevel = Enum("image", "underlay", "glyph", "guide", "annotation", "overlay");
const RenderMode = Enum("canvas", "css");
const ResetPolicy = Enum("standard", "event_only");
const RoundingFunction = Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup");
const SelectionMode = Enum("replace", "append", "intersect", "subtract");
Enum("above", "below", "left", "right");
const SizingMode = Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
const Sort = Enum("ascending", "descending");
const SpatialUnits = Enum("screen", "data");
const StartEnd = Enum("start", "end");
const StepMode = Enum("after", "before", "center");
const TapBehavior = Enum("select", "inspect");
const TextAlign = Enum("left", "right", "center");
const TextBaseline = Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
const TextureRepetition = Enum("repeat", "repeat_x", "repeat_y", "no_repeat");
const TickLabelOrientation = Enum("vertical", "horizontal", "parallel", "normal");
const TooltipAttachment = Enum("horizontal", "vertical", "left", "right", "above", "below");
const UpdateMode = Enum("replace", "append");
const VerticalAlign = Enum("top", "middle", "bottom");
const { hasOwnProperty: hasOwnProperty$3 } = Object.prototype;
const equals = Symbol("equals");
function is_Equatable(obj) {
  return isObject(obj) && obj[equals] !== void 0;
}
const wildcard = Symbol("wildcard");
const toString$1 = Object.prototype.toString;
class Comparator {
  constructor() {
    this.a_stack = [];
    this.b_stack = [];
  }
  eq(a2, b) {
    if (Object.is(a2, b))
      return true;
    if (a2 === wildcard || b === wildcard)
      return true;
    if (a2 == null || b == null)
      return a2 === b;
    const class_name = toString$1.call(a2);
    if (class_name != toString$1.call(b))
      return false;
    switch (class_name) {
      case "[object Number]":
        return this.numbers(a2, b);
      case "[object RegExp]":
      case "[object String]":
        return `${a2}` == `${b}`;
      case "[object Date]":
      case "[object Boolean]":
        return +a2 === +b;
    }
    const { a_stack, b_stack } = this;
    let length = a_stack.length;
    while (length--) {
      if (a_stack[length] === a2)
        return b_stack[length] === b;
    }
    a_stack.push(a2);
    b_stack.push(b);
    const result = (() => {
      if (is_Equatable(a2) && is_Equatable(b)) {
        return a2[equals](b, this);
      }
      switch (class_name) {
        case "[object Array]":
        case "[object Uint8Array]":
        case "[object Int8Array]":
        case "[object Uint16Array]":
        case "[object Int16Array]":
        case "[object Uint32Array]":
        case "[object Int32Array]":
        case "[object Float32Array]":
        case "[object Float64Array]": {
          return this.arrays(a2, b);
        }
        case "[object Map]":
          return this.maps(a2, b);
        case "[object Set]":
          return this.sets(a2, b);
        case "[object Object]": {
          if (a2.constructor == b.constructor && (a2.constructor == null || a2.constructor === Object)) {
            return this.objects(a2, b);
          }
        }
        case "[object Function]": {
          if (a2.constructor == b.constructor && a2.constructor === Function) {
            return this.eq(`${a2}`, `${b}`);
          }
        }
      }
      if (a2 instanceof Node) {
        return this.nodes(a2, b);
      }
      throw Error(`can't compare objects of type ${class_name}`);
    })();
    a_stack.pop();
    b_stack.pop();
    return result;
  }
  numbers(a2, b) {
    return Object.is(a2, b);
  }
  arrays(a2, b) {
    const { length } = a2;
    if (length != b.length)
      return false;
    for (let i2 = 0; i2 < length; i2++) {
      if (!this.eq(a2[i2], b[i2]))
        return false;
    }
    return true;
  }
  iterables(a2, b) {
    const ai = a2[Symbol.iterator]();
    const bi = b[Symbol.iterator]();
    while (true) {
      const an = ai.next();
      const bn = bi.next();
      if (an.done && bn.done)
        return true;
      if (an.done || bn.done)
        return false;
      if (!this.eq(an.value, bn.value))
        return false;
    }
  }
  maps(a2, b) {
    if (a2.size != b.size)
      return false;
    for (const [key, val] of a2) {
      if (!b.has(key) || !this.eq(val, b.get(key)))
        return false;
    }
    return true;
  }
  sets(a2, b) {
    if (a2.size != b.size)
      return false;
    for (const key of a2) {
      if (!b.has(key))
        return false;
    }
    return true;
  }
  objects(a2, b) {
    const keys2 = Object.keys(a2);
    if (keys2.length != Object.keys(b).length)
      return false;
    for (const key of keys2) {
      if (!hasOwnProperty$3.call(b, key) || !this.eq(a2[key], b[key]))
        return false;
    }
    return true;
  }
  nodes(a2, b) {
    if (a2.nodeType != b.nodeType)
      return false;
    if (a2.textContent != b.textContent)
      return false;
    if (!this.iterables(a2.childNodes, b.childNodes))
      return false;
    return true;
  }
}
Comparator.__name__ = "Comparator";
const { abs: abs$4 } = Math;
class SimilarComparator extends Comparator {
  constructor(tolerance = 1e-4) {
    super();
    this.tolerance = tolerance;
  }
  numbers(a2, b) {
    return super.numbers(a2, b) || abs$4(a2 - b) < this.tolerance;
  }
}
SimilarComparator.__name__ = "SimilarComparator";
function is_equal(a2, b) {
  const comparator = new Comparator();
  return comparator.eq(a2, b);
}
var _a$3W;
class BitSet {
  constructor(size2, init2 = 0) {
    this.size = size2;
    this[_a$3W] = "BitSet";
    this._count = null;
    this._nwords = Math.ceil(size2 / 32);
    if (init2 == 0 || init2 == 1) {
      this._array = new Uint32Array(this._nwords);
      if (init2 == 1) {
        this._array.fill(4294967295);
      }
    } else {
      assert(init2.length == this._nwords, "Initializer size mismatch");
      this._array = init2;
    }
  }
  clone() {
    return new BitSet(this.size, new Uint32Array(this._array));
  }
  [(_a$3W = Symbol.toStringTag, equals)](that, cmp) {
    if (!cmp.eq(this.size, that.size))
      return false;
    const { _nwords } = this;
    const trailing = this.size % _nwords;
    const n2 = trailing == 0 ? _nwords : _nwords - 1;
    for (let i2 = 0; i2 < n2; i2++) {
      if (this._array[i2] != that._array[i2])
        return false;
    }
    if (trailing == 0)
      return true;
    else {
      const msb = 1 << trailing - 1;
      const mask = msb - 1 ^ msb;
      return (this._array[n2] & mask) == (that._array[n2] & mask);
    }
  }
  static all_set(size2) {
    return new BitSet(size2, 1);
  }
  static all_unset(size2) {
    return new BitSet(size2, 0);
  }
  static from_indices(size2, indices) {
    const bits = new BitSet(size2);
    for (const i2 of indices) {
      bits.set(i2);
    }
    return bits;
  }
  static from_booleans(size2, booleans) {
    const bits = new BitSet(size2);
    const n2 = Math.min(size2, booleans.length);
    for (let i2 = 0; i2 < n2; i2++) {
      if (booleans[i2])
        bits.set(i2);
    }
    return bits;
  }
  _check_bounds(k) {
    assert(0 <= k && k < this.size, `Out of bounds: 0 <= ${k} < ${this.size}`);
  }
  get(k) {
    this._check_bounds(k);
    const i2 = k >>> 5;
    const j = k & 31;
    return !!(this._array[i2] >> j & 1);
  }
  set(k, v = true) {
    this._check_bounds(k);
    this._count = null;
    const i2 = k >>> 5;
    const j = k & 31;
    if (v)
      this._array[i2] |= 1 << j;
    else
      this._array[i2] &= ~(1 << j);
  }
  unset(k) {
    this.set(k, false);
  }
  *[Symbol.iterator]() {
    yield* this.ones();
  }
  get count() {
    let count = this._count;
    if (count == null)
      this._count = count = this._get_count();
    return count;
  }
  _get_count() {
    const { _array: _array2, _nwords, size: size2 } = this;
    let c = 0;
    for (let k = 0, i2 = 0; i2 < _nwords; i2++) {
      const word = _array2[i2];
      if (word == 0) {
        k += 32;
      } else {
        for (let j = 0; j < 32 && k < size2; j++, k++) {
          if (word >>> j & 1)
            c += 1;
        }
      }
    }
    return c;
  }
  *ones() {
    const { _array: _array2, _nwords, size: size2 } = this;
    for (let k = 0, i2 = 0; i2 < _nwords; i2++) {
      const word = _array2[i2];
      if (word == 0) {
        k += 32;
        continue;
      }
      for (let j = 0; j < 32 && k < size2; j++, k++) {
        if (word >>> j & 1)
          yield k;
      }
    }
  }
  *zeros() {
    const { _array: _array2, _nwords, size: size2 } = this;
    for (let k = 0, i2 = 0; i2 < _nwords; i2++) {
      const word = _array2[i2];
      if (word == 4294967295) {
        k += 32;
        continue;
      }
      for (let j = 0; j < 32 && k < size2; j++, k++) {
        if (!(word >>> j & 1))
          yield k;
      }
    }
  }
  _check_size(other) {
    assert(this.size == other.size, "Size mismatch");
  }
  add(other) {
    this._check_size(other);
    for (let i2 = 0; i2 < this._nwords; i2++) {
      this._array[i2] |= other._array[i2];
    }
  }
  intersect(other) {
    this._check_size(other);
    for (let i2 = 0; i2 < this._nwords; i2++) {
      this._array[i2] &= other._array[i2];
    }
  }
  subtract(other) {
    this._check_size(other);
    for (let i2 = 0; i2 < this._nwords; i2++) {
      const a2 = this._array[i2];
      const b = other._array[i2];
      this._array[i2] = (a2 ^ b) & a2;
    }
  }
  union(other) {
    this._check_size(other);
    const result = this.clone();
    for (let i2 = 0; i2 < this._nwords; i2++) {
      result._array[i2] |= other._array[i2];
    }
    return result;
  }
  intersection(other) {
    this._check_size(other);
    const result = this.clone();
    for (let i2 = 0; i2 < this._nwords; i2++) {
      result._array[i2] &= other._array[i2];
    }
    return result;
  }
  difference(other) {
    this._check_size(other);
    const result = this.clone();
    for (let i2 = 0; i2 < this._nwords; i2++) {
      const a2 = this._array[i2];
      const b = other._array[i2];
      result._array[i2] = (a2 ^ b) & a2;
    }
    return result;
  }
  select(array) {
    assert(this.size <= array.length, "Size mismatch");
    const n2 = this.count;
    const result = new array.constructor(n2);
    let i2 = 0;
    for (const j of this) {
      result[i2++] = array[j];
    }
    return result;
  }
}
BitSet.__name__ = "BitSet";
const GeneratorFunction = Object.getPrototypeOf(function* () {
}).constructor;
const ColorArray = Uint32Array;
const RGBAArray = Uint8ClampedArray;
function infer_type(a0, a1) {
  if (a0 instanceof Float64Array || a0 instanceof Array)
    return Float64Array;
  if (a1 instanceof Float64Array || a1 instanceof Array)
    return Float64Array;
  return Float32Array;
}
const ScreenArray = Float32Array;
function to_screen(array) {
  if (!(array instanceof Float32Array))
    return Float32Array.from(array);
  else
    return array;
}
(() => {
  return navigator.appVersion.includes("Windows");
})();
const is_ie = (() => {
  const ua = navigator.userAgent;
  return ua.includes("MSIE") || ua.includes("Trident") || ua.includes("Edge");
})();
const is_mobile = (() => {
  return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
})();
const is_little_endian = (() => {
  const buf = new ArrayBuffer(4);
  const buf8 = new Uint8Array(buf);
  const buf32 = new Uint32Array(buf);
  buf32[1] = 168496141;
  let little_endian = true;
  if (buf8[4] == 10 && buf8[5] == 11 && buf8[6] == 12 && buf8[7] == 13) {
    little_endian = false;
  }
  return little_endian;
})();
const BYTE_ORDER = is_little_endian ? "little" : "big";
function to_big_endian(values2) {
  if (is_little_endian) {
    const result = new Uint32Array(values2.length);
    const view = new DataView(result.buffer);
    let j = 0;
    for (const color of values2) {
      view.setUint32(j, color);
      j += 4;
    }
    return result;
  } else
    return values2;
}
class Settings {
  constructor() {
    this._dev = false;
    this._wireframe = false;
    this._force_webgl = false;
  }
  set dev(dev) {
    this._dev = dev;
  }
  get dev() {
    return this._dev;
  }
  set wireframe(wireframe) {
    this._wireframe = wireframe;
  }
  get wireframe() {
    return this._wireframe;
  }
  set force_webgl(force_webgl) {
    this._force_webgl = force_webgl;
  }
  get force_webgl() {
    return this._force_webgl;
  }
}
Settings.__name__ = "Settings";
const settings = new Settings();
const serialize = Symbol("serialize");
function is_Serializable(obj) {
  return isObject(obj) && obj[serialize] !== void 0;
}
class SerializationError extends Error {
}
SerializationError.__name__ = "SerializationError";
class Serializer {
  constructor(options2) {
    var _a2;
    this._references = /* @__PURE__ */ new Map();
    this._definitions = /* @__PURE__ */ new Map();
    this._refmap = /* @__PURE__ */ new Map();
    this.include_defaults = (_a2 = options2 == null ? void 0 : options2.include_defaults) != null ? _a2 : true;
  }
  get_ref(obj) {
    return this._references.get(obj);
  }
  add_ref(obj, ref) {
    assert(!this._references.has(obj));
    this._references.set(obj, ref);
  }
  add_def(obj, def) {
    const ref = this.get_ref(obj);
    assert(ref != null);
    this._definitions.set(obj, def);
    this._refmap.set(ref, def);
  }
  get objects() {
    return new Set(this._references.keys());
  }
  get references() {
    return new Set(this._references.values());
  }
  get definitions() {
    return new Set(this._definitions.values());
  }
  resolve_ref(ref) {
    return this._refmap.get(ref);
  }
  remove_ref(obj) {
    return this._references.delete(obj);
  }
  remove_def(obj) {
    return this._definitions.delete(obj);
  }
  to_serializable(obj) {
    const ref = this.get_ref(obj);
    if (ref != null)
      return ref;
    else if (is_Serializable(obj))
      return obj[serialize](this);
    else if (isArray(obj) || isTypedArray(obj)) {
      const n2 = obj.length;
      const result = new Array(n2);
      for (let i2 = 0; i2 < n2; i2++) {
        const value = obj[i2];
        result[i2] = this.to_serializable(value);
      }
      return result;
    } else if (isPlainObject(obj)) {
      const result = {};
      for (const [key, value] of entries(obj)) {
        result[key] = this.to_serializable(value);
      }
      return result;
    } else if (obj === null || isBoolean(obj) || isNumber(obj) || isString(obj)) {
      return obj;
    } else
      throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
  }
}
Serializer.__name__ = "Serializer";
function buffer_to_base64(buffer) {
  const bytes = new Uint8Array(buffer);
  const chars = Array.from(bytes).map((b) => String.fromCharCode(b));
  return btoa(chars.join(""));
}
function base64_to_buffer(base64) {
  const binary_string = atob(base64);
  const len = binary_string.length;
  const bytes = new Uint8Array(len);
  for (let i2 = 0, end = len; i2 < end; i2++) {
    bytes[i2] = binary_string.charCodeAt(i2);
  }
  return bytes.buffer;
}
function swap16(buffer) {
  const x2 = new Uint8Array(buffer);
  for (let i2 = 0, end = x2.length; i2 < end; i2 += 2) {
    const t = x2[i2];
    x2[i2] = x2[i2 + 1];
    x2[i2 + 1] = t;
  }
}
function swap32(buffer) {
  const x2 = new Uint8Array(buffer);
  for (let i2 = 0, end = x2.length; i2 < end; i2 += 4) {
    let t = x2[i2];
    x2[i2] = x2[i2 + 3];
    x2[i2 + 3] = t;
    t = x2[i2 + 1];
    x2[i2 + 1] = x2[i2 + 2];
    x2[i2 + 2] = t;
  }
}
function swap64(buffer) {
  const x2 = new Uint8Array(buffer);
  for (let i2 = 0, end = x2.length; i2 < end; i2 += 8) {
    let t = x2[i2];
    x2[i2] = x2[i2 + 7];
    x2[i2 + 7] = t;
    t = x2[i2 + 1];
    x2[i2 + 1] = x2[i2 + 6];
    x2[i2 + 6] = t;
    t = x2[i2 + 2];
    x2[i2 + 2] = x2[i2 + 5];
    x2[i2 + 5] = t;
    t = x2[i2 + 3];
    x2[i2 + 3] = x2[i2 + 4];
    x2[i2 + 4] = t;
  }
}
function swap$1(buffer, dtype) {
  switch (dtype) {
    case "uint16":
    case "int16":
      swap16(buffer);
      break;
    case "uint32":
    case "int32":
    case "float32":
      swap32(buffer);
      break;
    case "float64":
      swap64(buffer);
      break;
  }
}
function is_NDArray_ref(v) {
  return isPlainObject(v) && ("__buffer__" in v || "__ndarray__" in v);
}
function decode_NDArray(ref, buffers) {
  const { shape, dtype, order } = ref;
  let bytes;
  if ("__buffer__" in ref) {
    const buffer = buffers.get(ref.__buffer__);
    if (buffer != null)
      bytes = buffer;
    else
      throw new Error(`buffer for ${ref.__buffer__} not found`);
  } else {
    bytes = base64_to_buffer(ref.__ndarray__);
  }
  if (order !== BYTE_ORDER) {
    swap$1(bytes, dtype);
  }
  return { buffer: bytes, dtype, shape };
}
function encode_NDArray(array, buffers) {
  const data2 = {
    order: BYTE_ORDER,
    dtype: array.dtype,
    shape: array.shape
  };
  if (buffers != null) {
    const __buffer__ = `${buffers.size}`;
    buffers.set(__buffer__, array.buffer);
    return { __buffer__, ...data2 };
  } else {
    const __ndarray__2 = {
      toJSON() {
        return buffer_to_base64(array.buffer);
      }
    };
    return { __ndarray__: __ndarray__2, ...data2 };
  }
}
var _a$3V, _b$c, _c$6, _d$4, _e$4, _f$3, _g$2, _h$2;
const __ndarray__ = Symbol("__ndarray__");
class Uint8NDArray extends Uint8Array {
  constructor(seq, shape) {
    super(seq);
    this[_a$3V] = true;
    this.dtype = "uint8";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Uint8NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Uint8NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_a$3V = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Uint8NDArray.__name__ = "Uint8NDArray";
class Int8NDArray extends Int8Array {
  constructor(seq, shape) {
    super(seq);
    this[_b$c] = true;
    this.dtype = "int8";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Int8NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Int8NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_b$c = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Int8NDArray.__name__ = "Int8NDArray";
class Uint16NDArray extends Uint16Array {
  constructor(seq, shape) {
    super(seq);
    this[_c$6] = true;
    this.dtype = "uint16";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Uint16NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Uint16NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_c$6 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Uint16NDArray.__name__ = "Uint16NDArray";
class Int16NDArray extends Int16Array {
  constructor(seq, shape) {
    super(seq);
    this[_d$4] = true;
    this.dtype = "int16";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Int16NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Int16NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_d$4 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Int16NDArray.__name__ = "Int16NDArray";
class Uint32NDArray extends Uint32Array {
  constructor(seq, shape) {
    super(seq);
    this[_e$4] = true;
    this.dtype = "uint32";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Uint32NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Uint32NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_e$4 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Uint32NDArray.__name__ = "Uint32NDArray";
class Int32NDArray extends Int32Array {
  constructor(seq, shape) {
    super(seq);
    this[_f$3] = true;
    this.dtype = "int32";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Int32NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Int32NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_f$3 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Int32NDArray.__name__ = "Int32NDArray";
class Float32NDArray extends Float32Array {
  constructor(seq, shape) {
    super(seq);
    this[_g$2] = true;
    this.dtype = "float32";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Float32NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Float32NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_g$2 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Float32NDArray.__name__ = "Float32NDArray";
class Float64NDArray extends Float64Array {
  constructor(seq, shape) {
    super(seq);
    this[_h$2] = true;
    this.dtype = "float64";
    this.shape = shape != null ? shape : is_NDArray(seq) ? seq.shape : [this.length];
    this.dimension = this.shape.length;
    if (this[equals] == null) {
      this[equals] = (that, cmp) => {
        return Float64NDArray.prototype[equals].call(this, that, cmp);
      };
    }
    if (this[serialize] == null) {
      this[serialize] = (serializer) => {
        return Float64NDArray.prototype[serialize].call(this, serializer);
      };
    }
  }
  [(_h$2 = __ndarray__, equals)](that, cmp) {
    return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
  }
  [serialize](_serializer) {
    return encode_NDArray(this);
  }
}
Float64NDArray.__name__ = "Float64NDArray";
function is_NDArray(v) {
  return isObject(v) && v[__ndarray__] !== void 0;
}
function ndarray(array, options2 = {}) {
  let { dtype } = options2;
  if (dtype == null) {
    if (array instanceof ArrayBuffer || isArray(array)) {
      dtype = "float64";
    } else {
      dtype = (() => {
        switch (true) {
          case array instanceof Uint8Array:
            return "uint8";
          case array instanceof Int8Array:
            return "int8";
          case array instanceof Uint16Array:
            return "uint16";
          case array instanceof Int16Array:
            return "int16";
          case array instanceof Uint32Array:
            return "uint32";
          case array instanceof Int32Array:
            return "int32";
          case array instanceof Float32Array:
            return "float32";
          case array instanceof Float64Array:
            return "float64";
          default:
            unreachable();
        }
      })();
    }
  }
  const { shape } = options2;
  switch (dtype) {
    case "uint8":
      return new Uint8NDArray(array, shape);
    case "int8":
      return new Int8NDArray(array, shape);
    case "uint16":
      return new Uint16NDArray(array, shape);
    case "int16":
      return new Int16NDArray(array, shape);
    case "uint32":
      return new Uint32NDArray(array, shape);
    case "int32":
      return new Int32NDArray(array, shape);
    case "float32":
      return new Float32NDArray(array, shape);
    case "float64":
      return new Float64NDArray(array, shape);
  }
}
class Uniform {
  is_Scalar() {
    return this.is_scalar;
  }
  is_Vector() {
    return !this.is_scalar;
  }
}
Uniform.__name__ = "Uniform";
class UniformScalar extends Uniform {
  constructor(value, length) {
    super();
    this.value = value;
    this.length = length;
    this.is_scalar = true;
  }
  get(_i) {
    return this.value;
  }
  *[Symbol.iterator]() {
    const { length, value } = this;
    for (let i2 = 0; i2 < length; i2++) {
      yield value;
    }
  }
  select(indices) {
    return new UniformScalar(this.value, indices.count);
  }
  [equals](that, cmp) {
    return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
  }
}
UniformScalar.__name__ = "UniformScalar";
class UniformVector extends Uniform {
  constructor(array) {
    super();
    this.array = array;
    this.is_scalar = false;
    this.length = this.array.length;
  }
  get(i2) {
    return this.array[i2];
  }
  *[Symbol.iterator]() {
    yield* this.array;
  }
  select(indices) {
    const array = indices.select(this.array);
    return new this.constructor(array);
  }
  [equals](that, cmp) {
    return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
  }
}
UniformVector.__name__ = "UniformVector";
class ColorUniformVector extends UniformVector {
  constructor(array) {
    super(array);
    this.array = array;
    this._view = new DataView(array.buffer);
  }
  get(i2) {
    return this._view.getUint32(4 * i2);
  }
  *[Symbol.iterator]() {
    const n2 = this.length;
    for (let i2 = 0; i2 < n2; i2++)
      yield this.get(i2);
  }
}
ColorUniformVector.__name__ = "ColorUniformVector";
function valueToString(value) {
  try {
    return JSON.stringify(value);
  } catch {
    return value.toString();
  }
}
function isSpec(obj) {
  return isPlainObject(obj) && (obj.value === void 0 ? 0 : 1) + (obj.field === void 0 ? 0 : 1) + (obj.expr === void 0 ? 0 : 1) == 1;
}
class Property {
  constructor(obj, attr, kind, default_value, initial_value, options2 = {}) {
    var _a2;
    this.obj = obj;
    this.attr = attr;
    this.kind = kind;
    this.default_value = default_value;
    this._dirty = false;
    this.change = new Signal0(this.obj, "change");
    this.internal = (_a2 = options2.internal) != null ? _a2 : false;
    this.convert = options2.convert;
    this.on_update = options2.on_update;
    let attr_value;
    if (initial_value !== void 0) {
      attr_value = initial_value;
      this._dirty = true;
    } else {
      const value = this._default_override();
      if (value !== void 0)
        attr_value = value;
      else if (default_value !== void 0)
        attr_value = default_value(obj);
      else {
        this.spec = { value: null };
        return;
      }
    }
    this._update(attr_value);
  }
  get is_value() {
    return this.spec.value !== void 0;
  }
  get syncable() {
    return !this.internal;
  }
  get_value() {
    return this.spec.value;
  }
  set_value(val) {
    this._update(val);
    this._dirty = true;
  }
  _default_override() {
    return void 0;
  }
  get dirty() {
    return this._dirty;
  }
  _update(attr_value) {
    var _a2;
    this.validate(attr_value);
    if (this.convert != null) {
      const converted = this.convert(attr_value);
      if (converted !== void 0)
        attr_value = converted;
    }
    this.spec = { value: attr_value };
    (_a2 = this.on_update) == null ? void 0 : _a2.call(this, attr_value, this.obj);
  }
  toString() {
    return `Prop(${this.obj}.${this.attr}, spec: ${valueToString(this.spec)})`;
  }
  normalize(values2) {
    return values2;
  }
  validate(value) {
    if (!this.valid(value))
      throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
  }
  valid(value) {
    return this.kind.valid(value);
  }
  _value(do_spec_transform = true) {
    if (!this.is_value)
      throw new Error("attempted to retrieve property value for property without value specification");
    let ret = this.normalize([this.spec.value])[0];
    if (this.spec.transform != null && do_spec_transform)
      ret = this.spec.transform.compute(ret);
    return ret;
  }
}
Property.__name__ = "Property";
class PropertyAlias {
  constructor(attr) {
    this.attr = attr;
  }
}
PropertyAlias.__name__ = "PropertyAlias";
function Alias(attr) {
  return new PropertyAlias(attr);
}
class PrimitiveProperty extends Property {
}
PrimitiveProperty.__name__ = "PrimitiveProperty";
class Any extends Property {
}
Any.__name__ = "Any";
class Array$1 extends Property {
  valid(value) {
    return isArray(value) || isTypedArray(value);
  }
}
Array$1.__name__ = "Array";
class Boolean$1 extends Property {
  valid(value) {
    return isBoolean(value);
  }
}
Boolean$1.__name__ = "Boolean";
class Color extends Property {
  valid(value) {
    return is_Color(value);
  }
}
Color.__name__ = "Color";
class Instance extends Property {
}
Instance.__name__ = "Instance";
class Number$1 extends Property {
  valid(value) {
    return isNumber(value);
  }
}
Number$1.__name__ = "Number";
class Int extends Number$1 {
  valid(value) {
    return isNumber(value) && (value | 0) == value;
  }
}
Int.__name__ = "Int";
class Angle extends Number$1 {
}
Angle.__name__ = "Angle";
class Percent extends Number$1 {
  valid(value) {
    return isNumber(value) && 0 <= value && value <= 1;
  }
}
Percent.__name__ = "Percent";
class String$1 extends Property {
  valid(value) {
    return isString(value);
  }
}
String$1.__name__ = "String";
class NullString extends Property {
  valid(value) {
    return value === null || isString(value);
  }
}
NullString.__name__ = "NullString";
class FontSize extends String$1 {
}
FontSize.__name__ = "FontSize";
class Font extends String$1 {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
Font.__name__ = "Font";
class EnumProperty extends Property {
  valid(value) {
    return isString(value) && includes(this.enum_values, value);
  }
}
EnumProperty.__name__ = "EnumProperty";
class Direction extends EnumProperty {
  get enum_values() {
    return [...Direction$1];
  }
  normalize(values2) {
    const result = new Uint8Array(values2.length);
    for (let i2 = 0; i2 < values2.length; i2++) {
      switch (values2[i2]) {
        case "clock":
          result[i2] = 0;
          break;
        case "anticlock":
          result[i2] = 1;
          break;
      }
    }
    return result;
  }
}
Direction.__name__ = "Direction";
class ScalarSpec extends Property {
  get_value() {
    const { value, expr: expr2, transform: transform2 } = this.spec;
    return expr2 != null || transform2 != null ? this.spec : value;
  }
  _update(attr_value) {
    if (isSpec(attr_value))
      this.spec = attr_value;
    else
      this.spec = { value: attr_value };
    if (this.spec.value != null)
      this.validate(this.spec.value);
  }
  materialize(value) {
    return value;
  }
  scalar(value, n2) {
    return new UniformScalar(value, n2);
  }
  uniform(source) {
    var _a2;
    const { expr: expr2, value, transform: transform2 } = this.spec;
    const n2 = (_a2 = source.get_length()) != null ? _a2 : 1;
    if (expr2 != null) {
      let result = expr2.compute(source);
      if (transform2 != null)
        result = transform2.compute(result);
      result = this.materialize(result);
      return this.scalar(result, n2);
    } else {
      let result = value;
      if (transform2 != null)
        result = transform2.compute(result);
      result = this.materialize(result);
      return this.scalar(result, n2);
    }
  }
}
ScalarSpec.__name__ = "ScalarSpec";
class AnyScalar extends ScalarSpec {
}
AnyScalar.__name__ = "AnyScalar";
class ColorScalar extends ScalarSpec {
}
ColorScalar.__name__ = "ColorScalar";
class NumberScalar extends ScalarSpec {
}
NumberScalar.__name__ = "NumberScalar";
class StringScalar extends ScalarSpec {
}
StringScalar.__name__ = "StringScalar";
class NullStringScalar extends ScalarSpec {
}
NullStringScalar.__name__ = "NullStringScalar";
class ArrayScalar extends ScalarSpec {
}
ArrayScalar.__name__ = "ArrayScalar";
class LineJoinScalar extends ScalarSpec {
}
LineJoinScalar.__name__ = "LineJoinScalar";
class LineCapScalar extends ScalarSpec {
}
LineCapScalar.__name__ = "LineCapScalar";
class LineDashScalar extends ScalarSpec {
}
LineDashScalar.__name__ = "LineDashScalar";
class FontScalar extends ScalarSpec {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
FontScalar.__name__ = "FontScalar";
class FontSizeScalar extends ScalarSpec {
}
FontSizeScalar.__name__ = "FontSizeScalar";
class FontStyleScalar extends ScalarSpec {
}
FontStyleScalar.__name__ = "FontStyleScalar";
class TextAlignScalar extends ScalarSpec {
}
TextAlignScalar.__name__ = "TextAlignScalar";
class TextBaselineScalar extends ScalarSpec {
}
TextBaselineScalar.__name__ = "TextBaselineScalar";
class VectorSpec extends Property {
  get_value() {
    return this.spec.value === null ? null : this.spec;
  }
  _update(attr_value) {
    if (isSpec(attr_value))
      this.spec = attr_value;
    else
      this.spec = { value: attr_value };
    if (this.spec.value != null)
      this.validate(this.spec.value);
  }
  materialize(value) {
    return value;
  }
  v_materialize(values2) {
    return values2;
  }
  scalar(value, n2) {
    return new UniformScalar(value, n2);
  }
  vector(values2) {
    return new UniformVector(values2);
  }
  uniform(source) {
    var _a2;
    const { field, expr: expr2, value, transform: transform2 } = this.spec;
    const n2 = (_a2 = source.get_length()) != null ? _a2 : 1;
    if (field != null) {
      let array = source.get_column(field);
      if (array != null) {
        if (transform2 != null)
          array = transform2.v_compute(array);
        array = this.v_materialize(array);
        return this.vector(array);
      } else {
        logger.warn(`attempted to retrieve property array for nonexistent field '${field}'`);
        return this.scalar(null, n2);
      }
    } else if (expr2 != null) {
      let array = expr2.v_compute(source);
      if (transform2 != null)
        array = transform2.v_compute(array);
      array = this.v_materialize(array);
      return this.vector(array);
    } else {
      let result = value;
      if (transform2 != null)
        result = transform2.compute(result);
      result = this.materialize(result);
      return this.scalar(result, n2);
    }
  }
  array(source) {
    var _a2;
    let array;
    const length = (_a2 = source.get_length()) != null ? _a2 : 1;
    if (this.spec.field != null) {
      const column = source.get_column(this.spec.field);
      if (column != null)
        array = this.normalize(column);
      else {
        logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);
        const missing = new Float64Array(length);
        missing.fill(NaN);
        array = missing;
      }
    } else if (this.spec.expr != null) {
      array = this.normalize(this.spec.expr.v_compute(source));
    } else {
      const value = this._value(false);
      if (isNumber(value)) {
        const values2 = new Float64Array(length);
        values2.fill(value);
        array = values2;
      } else
        array = repeat(value, length);
    }
    if (this.spec.transform != null)
      array = this.spec.transform.v_compute(array);
    return array;
  }
}
VectorSpec.__name__ = "VectorSpec";
class DataSpec extends VectorSpec {
}
DataSpec.__name__ = "DataSpec";
class UnitsSpec extends VectorSpec {
  _update(attr_value) {
    super._update(attr_value);
    const { units: units2 } = this.spec;
    if (units2 != null && !includes(this.valid_units, units2)) {
      throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units2}`);
    }
  }
  get units() {
    var _a2;
    return (_a2 = this.spec.units) != null ? _a2 : this.default_units;
  }
  set units(units2) {
    if (units2 != this.default_units)
      this.spec.units = units2;
    else
      delete this.spec.units;
  }
}
UnitsSpec.__name__ = "UnitsSpec";
class NumberUnitsSpec extends UnitsSpec {
  array(source) {
    return new Float64Array(super.array(source));
  }
}
NumberUnitsSpec.__name__ = "NumberUnitsSpec";
class BaseCoordinateSpec extends DataSpec {
}
BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
class CoordinateSpec extends BaseCoordinateSpec {
}
CoordinateSpec.__name__ = "CoordinateSpec";
class CoordinateSeqSpec extends BaseCoordinateSpec {
}
CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
}
CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
class XCoordinateSpec extends CoordinateSpec {
  constructor() {
    super(...arguments);
    this.dimension = "x";
  }
}
XCoordinateSpec.__name__ = "XCoordinateSpec";
class YCoordinateSpec extends CoordinateSpec {
  constructor() {
    super(...arguments);
    this.dimension = "y";
  }
}
YCoordinateSpec.__name__ = "YCoordinateSpec";
class XCoordinateSeqSpec extends CoordinateSeqSpec {
  constructor() {
    super(...arguments);
    this.dimension = "x";
  }
}
XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
class YCoordinateSeqSpec extends CoordinateSeqSpec {
  constructor() {
    super(...arguments);
    this.dimension = "y";
  }
}
YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
  constructor() {
    super(...arguments);
    this.dimension = "x";
  }
}
XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
  constructor() {
    super(...arguments);
    this.dimension = "y";
  }
}
YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
class AngleSpec extends NumberUnitsSpec {
  get default_units() {
    return "rad";
  }
  get valid_units() {
    return [...AngleUnits];
  }
  materialize(value) {
    const coeff = -to_radians_coeff(this.units);
    return value * coeff;
  }
  v_materialize(values2) {
    const coeff = -to_radians_coeff(this.units);
    const result = new Float32Array(values2.length);
    mul(values2, coeff, result);
    return result;
  }
  array(_source) {
    throw new Error("not supported");
  }
}
AngleSpec.__name__ = "AngleSpec";
class DistanceSpec extends NumberUnitsSpec {
  get default_units() {
    return "data";
  }
  get valid_units() {
    return [...SpatialUnits];
  }
}
DistanceSpec.__name__ = "DistanceSpec";
class NullDistanceSpec extends DistanceSpec {
  materialize(value) {
    return value != null ? value : NaN;
  }
}
NullDistanceSpec.__name__ = "NullDistanceSpec";
class BooleanSpec extends DataSpec {
  v_materialize(values2) {
    return new Uint8Array(values2);
  }
  array(source) {
    return new Uint8Array(super.array(source));
  }
}
BooleanSpec.__name__ = "BooleanSpec";
class IntSpec extends DataSpec {
  v_materialize(values2) {
    return isTypedArray(values2) ? values2 : new Int32Array(values2);
  }
  array(source) {
    return new Int32Array(super.array(source));
  }
}
IntSpec.__name__ = "IntSpec";
class NumberSpec extends DataSpec {
  v_materialize(values2) {
    return isTypedArray(values2) ? values2 : new Float64Array(values2);
  }
  array(source) {
    return new Float64Array(super.array(source));
  }
}
NumberSpec.__name__ = "NumberSpec";
class ScreenSizeSpec extends NumberSpec {
  valid(value) {
    return isNumber(value) && value >= 0;
  }
}
ScreenSizeSpec.__name__ = "ScreenSizeSpec";
class ColorSpec extends DataSpec {
  materialize(color) {
    return encode_rgba(color2rgba(color));
  }
  v_materialize(colors) {
    if (is_NDArray(colors)) {
      if (colors.dtype == "uint32" && colors.dimension == 1) {
        return to_big_endian(colors);
      } else if (colors.dtype == "uint8" && colors.dimension == 1) {
        const [n2] = colors.shape;
        const array = new RGBAArray(4 * n2);
        let j = 0;
        for (const gray of colors) {
          array[j++] = gray;
          array[j++] = gray;
          array[j++] = gray;
          array[j++] = 255;
        }
        return new ColorArray(array.buffer);
      } else if (colors.dtype == "uint8" && colors.dimension == 2) {
        const [n2, d] = colors.shape;
        if (d == 4) {
          return new ColorArray(colors.buffer);
        } else if (d == 3) {
          const array = new RGBAArray(4 * n2);
          for (let i2 = 0, j = 0; i2 < d * n2; ) {
            array[j++] = colors[i2++];
            array[j++] = colors[i2++];
            array[j++] = colors[i2++];
            array[j++] = 255;
          }
          return new ColorArray(array.buffer);
        }
      } else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
        const [n2, d] = colors.shape;
        if (d == 3 || d == 4) {
          const array = new RGBAArray(4 * n2);
          for (let i2 = 0, j = 0; i2 < d * n2; ) {
            array[j++] = colors[i2++] * 255;
            array[j++] = colors[i2++] * 255;
            array[j++] = colors[i2++] * 255;
            array[j++] = (d == 3 ? 1 : colors[i2++]) * 255;
          }
          return new ColorArray(array.buffer);
        }
      }
    } else {
      const n2 = colors.length;
      const array = new RGBAArray(4 * n2);
      let j = 0;
      for (const color of colors) {
        const [r, g, b, a2] = color2rgba(color);
        array[j++] = r;
        array[j++] = g;
        array[j++] = b;
        array[j++] = a2;
      }
      return new ColorArray(array.buffer);
    }
    throw new Error("invalid color array");
  }
  vector(values2) {
    return new ColorUniformVector(values2);
  }
}
ColorSpec.__name__ = "ColorSpec";
class NDArraySpec extends DataSpec {
}
NDArraySpec.__name__ = "NDArraySpec";
class AnySpec extends DataSpec {
}
AnySpec.__name__ = "AnySpec";
class StringSpec extends DataSpec {
}
StringSpec.__name__ = "StringSpec";
class NullStringSpec extends DataSpec {
}
NullStringSpec.__name__ = "NullStringSpec";
class ArraySpec extends DataSpec {
}
ArraySpec.__name__ = "ArraySpec";
class MarkerSpec extends DataSpec {
}
MarkerSpec.__name__ = "MarkerSpec";
class LineJoinSpec extends DataSpec {
}
LineJoinSpec.__name__ = "LineJoinSpec";
class LineCapSpec extends DataSpec {
}
LineCapSpec.__name__ = "LineCapSpec";
class LineDashSpec extends DataSpec {
}
LineDashSpec.__name__ = "LineDashSpec";
class FontSpec extends DataSpec {
  _default_override() {
    return settings.dev ? "Bokeh" : void 0;
  }
}
FontSpec.__name__ = "FontSpec";
class FontSizeSpec extends DataSpec {
}
FontSizeSpec.__name__ = "FontSizeSpec";
class FontStyleSpec extends DataSpec {
}
FontStyleSpec.__name__ = "FontStyleSpec";
class TextAlignSpec extends DataSpec {
}
TextAlignSpec.__name__ = "TextAlignSpec";
class TextBaselineSpec extends DataSpec {
}
TextBaselineSpec.__name__ = "TextBaselineSpec";
function startsWith(str, searchString, position2 = 0) {
  return str.substr(position2, searchString.length) == searchString;
}
function uuid4() {
  const s = new Array(32);
  const hexDigits = "0123456789ABCDEF";
  for (let i2 = 0; i2 < 32; i2++) {
    s[i2] = hexDigits.substr(Math.floor(Math.random() * 16), 1);
  }
  s[12] = "4";
  s[16] = hexDigits.substr(s[16].charCodeAt(0) & 3 | 8, 1);
  return s.join("");
}
let counter = 1e3;
function uniqueId(prefix) {
  const id = settings.dev ? `j${counter++}` : uuid4();
  if (prefix != null)
    return `${prefix}-${id}`;
  else
    return id;
}
function unescape(s) {
  return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_2, entity) => {
    switch (entity) {
      case "amp":
        return "&";
      case "lt":
        return "<";
      case "gt":
        return ">";
      case "quot":
        return '"';
      case "#x27":
        return "'";
      case "#x60":
        return "`";
      default:
        return entity;
    }
  });
}
function use_strict(code) {
  return `'use strict';
${code}`;
}
function to_fixed(val, precision2) {
  return val.toFixed(precision2).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
}
class DocumentEvent {
  constructor(document2) {
    this.document = document2;
  }
}
DocumentEvent.__name__ = "DocumentEvent";
class DocumentEventBatch extends DocumentEvent {
  constructor(document2, events, setter_id) {
    super(document2);
    this.events = events;
    this.setter_id = setter_id;
  }
}
DocumentEventBatch.__name__ = "DocumentEventBatch";
class DocumentChangedEvent extends DocumentEvent {
}
DocumentChangedEvent.__name__ = "DocumentChangedEvent";
class MessageSentEvent extends DocumentChangedEvent {
  constructor(document2, msg_type, msg_data) {
    super(document2);
    this.msg_type = msg_type;
    this.msg_data = msg_data;
  }
  [serialize](serializer) {
    const value = this.msg_data;
    const value_serialized = serializer.to_serializable(value);
    return {
      kind: "MessageSent",
      msg_type: this.msg_type,
      msg_data: value_serialized
    };
  }
}
MessageSentEvent.__name__ = "MessageSentEvent";
class ModelChangedEvent extends DocumentChangedEvent {
  constructor(document2, model, attr, old, new_, setter_id, hint) {
    super(document2);
    this.model = model;
    this.attr = attr;
    this.old = old;
    this.new_ = new_;
    this.setter_id = setter_id;
    this.hint = hint;
  }
  [serialize](serializer) {
    if (this.hint != null)
      return serializer.to_serializable(this.hint);
    const value = this.new_;
    const value_serialized = serializer.to_serializable(value);
    if (this.model != value) {
      serializer.remove_def(this.model);
    }
    return {
      kind: "ModelChanged",
      model: this.model.ref(),
      attr: this.attr,
      new: value_serialized
    };
  }
}
ModelChangedEvent.__name__ = "ModelChangedEvent";
class ColumnsPatchedEvent extends DocumentChangedEvent {
  constructor(document2, column_source, patches) {
    super(document2);
    this.column_source = column_source;
    this.patches = patches;
  }
  [serialize](_serializer) {
    return {
      kind: "ColumnsPatched",
      column_source: this.column_source,
      patches: this.patches
    };
  }
}
ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
class ColumnsStreamedEvent extends DocumentChangedEvent {
  constructor(document2, column_source, data2, rollover) {
    super(document2);
    this.column_source = column_source;
    this.data = data2;
    this.rollover = rollover;
  }
  [serialize](_serializer) {
    return {
      kind: "ColumnsStreamed",
      column_source: this.column_source,
      data: this.data,
      rollover: this.rollover
    };
  }
}
ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
class TitleChangedEvent extends DocumentChangedEvent {
  constructor(document2, title, setter_id) {
    super(document2);
    this.title = title;
    this.setter_id = setter_id;
  }
  [serialize](_serializer) {
    return {
      kind: "TitleChanged",
      title: this.title
    };
  }
}
TitleChangedEvent.__name__ = "TitleChangedEvent";
class RootAddedEvent extends DocumentChangedEvent {
  constructor(document2, model, setter_id) {
    super(document2);
    this.model = model;
    this.setter_id = setter_id;
  }
  [serialize](serializer) {
    return {
      kind: "RootAdded",
      model: serializer.to_serializable(this.model)
    };
  }
}
RootAddedEvent.__name__ = "RootAddedEvent";
class RootRemovedEvent extends DocumentChangedEvent {
  constructor(document2, model, setter_id) {
    super(document2);
    this.model = model;
    this.setter_id = setter_id;
  }
  [serialize](_serializer) {
    return {
      kind: "RootRemoved",
      model: this.model.ref()
    };
  }
}
RootRemovedEvent.__name__ = "RootRemovedEvent";
const pretty = Symbol("pretty");
const clone = Symbol("clone");
function is_Cloneable(obj) {
  return isObject(obj) && obj[clone] !== void 0;
}
class CloningError extends Error {
}
CloningError.__name__ = "CloningError";
class Cloner {
  constructor() {
  }
  clone(obj) {
    if (is_Cloneable(obj))
      return obj[clone](this);
    else if (isArray(obj)) {
      const n2 = obj.length;
      const result = new Array(n2);
      for (let i2 = 0; i2 < n2; i2++) {
        const value = obj[i2];
        result[i2] = this.clone(value);
      }
      return result;
    } else if (isPlainObject(obj)) {
      const result = {};
      for (const [key, value] of entries(obj)) {
        result[key] = this.clone(value);
      }
      return result;
    } else if (obj === null || isBoolean(obj) || isNumber(obj) || isString(obj)) {
      return obj;
    } else
      throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
  }
}
Cloner.__name__ = "Cloner";
var _a$3U;
class HasProps extends Signalable() {
  constructor(attrs = {}) {
    var _a2, _b2;
    super();
    this._subtype = void 0;
    this.document = null;
    this.destroyed = new Signal0(this, "destroyed");
    this.change = new Signal0(this, "change");
    this.transformchange = new Signal0(this, "transformchange");
    this.exprchange = new Signal0(this, "exprchange");
    this.properties = {};
    this._watchers = /* @__PURE__ */ new WeakMap();
    this._pending = false;
    this._changing = false;
    const get2 = attrs instanceof Map ? attrs.get.bind(attrs) : (name) => attrs[name];
    this.id = (_a2 = get2("id")) != null ? _a2 : uniqueId();
    for (const [name, { type, default_value, options: options2 }] of entries(this._props)) {
      let property;
      if (type instanceof PropertyAlias) {
        Object.defineProperty(this.properties, name, {
          get: () => this.properties[type.attr],
          configurable: false,
          enumerable: false
        });
      } else {
        if (type instanceof Kind)
          property = new PrimitiveProperty(this, name, type, default_value, get2(name), options2);
        else
          property = new type(this, name, Any$1, default_value, get2(name), options2);
        this.properties[name] = property;
      }
    }
    if (!((_b2 = get2("__deferred__")) != null ? _b2 : false)) {
      this.finalize();
      this.connect_signals();
    }
  }
  get is_syncable() {
    return true;
  }
  set type(name) {
    console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
    this.constructor.__name__ = name;
  }
  get type() {
    return this.constructor.__qualified__;
  }
  static get __qualified__() {
    const { __module__, __name__ } = this;
    return __module__ != null ? `${__module__}.${__name__}` : __name__;
  }
  static get [Symbol.toStringTag]() {
    return this.__name__;
  }
  static _fix_default(default_value, _attr) {
    if (default_value === void 0 || isFunction(default_value))
      return default_value;
    else if (isPrimitive(default_value))
      return () => default_value;
    else {
      const cloner = new Cloner();
      return () => cloner.clone(default_value);
    }
  }
  static define(obj) {
    for (const [name, prop] of entries(isFunction(obj) ? obj(kinds) : obj)) {
      if (this.prototype._props[name] != null)
        throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
      if (this.prototype[name] != null)
        throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
      Object.defineProperty(this.prototype, name, {
        get() {
          const value = this.properties[name].get_value();
          return value;
        },
        set(value) {
          this.setv({ [name]: value });
          return this;
        },
        configurable: false,
        enumerable: true
      });
      const [type, default_value, options2 = {}] = prop;
      const refined_prop = {
        type,
        default_value: this._fix_default(default_value, name),
        options: options2
      };
      const props = { ...this.prototype._props };
      props[name] = refined_prop;
      this.prototype._props = props;
    }
  }
  static internal(obj) {
    const _object = {};
    for (const [name, prop] of entries(isFunction(obj) ? obj(kinds) : obj)) {
      const [type, default_value, options2 = {}] = prop;
      _object[name] = [type, default_value, { ...options2, internal: true }];
    }
    this.define(_object);
  }
  static mixins(defs2) {
    function rename2(prefix, mixin) {
      const result = {};
      for (const [name, prop] of entries(mixin)) {
        result[prefix + name] = prop;
      }
      return result;
    }
    const mixin_defs = {};
    const mixins = [];
    for (const def of isArray(defs2) ? defs2 : [defs2]) {
      if (isArray(def)) {
        const [prefix, mixin] = def;
        extend$1(mixin_defs, rename2(prefix, mixin));
        mixins.push([prefix, mixin]);
      } else {
        const mixin = def;
        extend$1(mixin_defs, mixin);
        mixins.push(["", mixin]);
      }
    }
    this.define(mixin_defs);
    this.prototype._mixins = [...this.prototype._mixins, ...mixins];
  }
  static override(obj) {
    for (const [name, prop] of entries(obj)) {
      const default_value = this._fix_default(prop, name);
      const value = this.prototype._props[name];
      if (value == null)
        throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
      const props = { ...this.prototype._props };
      props[name] = { ...value, default_value };
      this.prototype._props = props;
    }
  }
  toString() {
    return `${this.type}(${this.id})`;
  }
  property(name) {
    const prop = this.properties[name];
    if (prop != null)
      return prop;
    else
      throw new Error(`unknown property ${this.type}.${name}`);
  }
  get attributes() {
    const attrs = {};
    for (const prop of this) {
      attrs[prop.attr] = prop.get_value();
    }
    return attrs;
  }
  [clone](cloner) {
    const attrs = /* @__PURE__ */ new Map();
    for (const prop of this) {
      if (prop.dirty) {
        attrs.set(prop.attr, cloner.clone(prop.get_value()));
      }
    }
    return new this.constructor(attrs);
  }
  [equals](that, cmp) {
    for (const p0 of this) {
      const p1 = that.property(p0.attr);
      if (!cmp.eq(p0.get_value(), p1.get_value()))
        return false;
    }
    return true;
  }
  [pretty](printer) {
    const T = printer.token;
    const items = [];
    for (const prop of this) {
      if (prop.dirty) {
        const value = prop.get_value();
        items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
      }
    }
    const cls = this.constructor.__qualified__;
    return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
  }
  [serialize](serializer) {
    const ref = this.ref();
    serializer.add_ref(this, ref);
    const struct = this.struct();
    for (const prop of this) {
      if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
        struct.attributes[prop.attr] = serializer.to_serializable(prop.get_value());
      }
    }
    serializer.add_def(this, struct);
    return ref;
  }
  finalize() {
    for (const prop of this) {
      if (!(prop instanceof VectorSpec || prop instanceof ScalarSpec))
        continue;
      const value = prop.get_value();
      if (value != null) {
        const { transform: transform2, expr: expr2 } = value;
        if (transform2 != null)
          this.connect(transform2.change, () => this.transformchange.emit());
        if (expr2 != null)
          this.connect(expr2.change, () => this.exprchange.emit());
      }
    }
    this.initialize();
  }
  initialize() {
  }
  connect_signals() {
  }
  disconnect_signals() {
    Signal.disconnectReceiver(this);
  }
  destroy() {
    this.disconnect_signals();
    this.destroyed.emit();
  }
  clone() {
    const cloner = new Cloner();
    return cloner.clone(this);
  }
  changed_for(obj) {
    const changed = this._watchers.get(obj);
    this._watchers.set(obj, false);
    return changed != null ? changed : true;
  }
  _setv(changes, options2) {
    const check_eq = options2.check_eq;
    const changed = [];
    const changing = this._changing;
    this._changing = true;
    for (const [prop, value] of changes) {
      if (check_eq === false || !is_equal(prop.get_value(), value)) {
        prop.set_value(value);
        changed.push(prop);
      }
    }
    if (changed.length > 0) {
      this._watchers = /* @__PURE__ */ new WeakMap();
      this._pending = true;
    }
    for (const prop of changed) {
      prop.change.emit();
    }
    if (changing)
      return;
    if (!options2.no_change) {
      while (this._pending) {
        this._pending = false;
        this.change.emit();
      }
    }
    this._pending = false;
    this._changing = false;
  }
  setv(changed_attrs, options2 = {}) {
    const changes = entries(changed_attrs);
    if (changes.length == 0)
      return;
    if (options2.silent === true) {
      this._watchers = /* @__PURE__ */ new WeakMap();
      for (const [attr, value] of changes) {
        this.properties[attr].set_value(value);
      }
      return;
    }
    const changed = /* @__PURE__ */ new Map();
    const previous = /* @__PURE__ */ new Map();
    for (const [attr, value] of changes) {
      const prop = this.properties[attr];
      changed.set(prop, value);
      previous.set(prop, prop.get_value());
    }
    this._setv(changed, options2);
    const { document: document2 } = this;
    if (document2 != null) {
      const changed2 = [];
      for (const [prop, value] of previous) {
        changed2.push([prop, value, prop.get_value()]);
      }
      for (const [, old_value, new_value] of changed2) {
        if (this._needs_invalidate(old_value, new_value)) {
          document2._invalidate_all_models();
          break;
        }
      }
      this._push_changes(changed2, options2);
    }
  }
  getv(name) {
    return this.property(name).get_value();
  }
  ref() {
    return { id: this.id };
  }
  struct() {
    const struct = {
      type: this.type,
      id: this.id,
      attributes: {}
    };
    if (this._subtype != null) {
      struct.subtype = this._subtype;
    }
    return struct;
  }
  set_subtype(subtype) {
    this._subtype = subtype;
  }
  *[Symbol.iterator]() {
    yield* values(this.properties);
  }
  *syncable_properties() {
    for (const prop of this) {
      if (prop.syncable)
        yield prop;
    }
  }
  serializable_attributes() {
    const attrs = {};
    for (const prop of this.syncable_properties()) {
      attrs[prop.attr] = prop.get_value();
    }
    return attrs;
  }
  static _json_record_references(doc, v, refs, options2) {
    const { recursive } = options2;
    if (is_ref(v)) {
      const model = doc.get_model_by_id(v.id);
      if (model != null && !refs.has(model)) {
        HasProps._value_record_references(model, refs, { recursive });
      }
    } else if (isArray(v)) {
      for (const elem of v)
        HasProps._json_record_references(doc, elem, refs, { recursive });
    } else if (isPlainObject(v)) {
      for (const elem of values(v)) {
        HasProps._json_record_references(doc, elem, refs, { recursive });
      }
    }
  }
  static _value_record_references(v, refs, options2) {
    const { recursive } = options2;
    if (v instanceof HasProps) {
      if (!refs.has(v)) {
        refs.add(v);
        if (recursive) {
          for (const prop of v.syncable_properties()) {
            const value = prop.get_value();
            HasProps._value_record_references(value, refs, { recursive });
          }
        }
      }
    } else if (isArray(v)) {
      for (const elem of v)
        HasProps._value_record_references(elem, refs, { recursive });
    } else if (isPlainObject(v)) {
      for (const elem of values(v)) {
        HasProps._value_record_references(elem, refs, { recursive });
      }
    }
  }
  references() {
    const refs = /* @__PURE__ */ new Set();
    HasProps._value_record_references(this, refs, { recursive: true });
    return refs;
  }
  _doc_attached() {
  }
  _doc_detached() {
  }
  attach_document(doc) {
    if (this.document != null && this.document != doc)
      throw new Error("models must be owned by only a single document");
    this.document = doc;
    this._doc_attached();
  }
  detach_document() {
    this._doc_detached();
    this.document = null;
  }
  _needs_invalidate(old_value, new_value) {
    const new_refs = /* @__PURE__ */ new Set();
    HasProps._value_record_references(new_value, new_refs, { recursive: false });
    const old_refs = /* @__PURE__ */ new Set();
    HasProps._value_record_references(old_value, old_refs, { recursive: false });
    for (const new_id of new_refs) {
      if (!old_refs.has(new_id))
        return true;
    }
    for (const old_id of old_refs) {
      if (!new_refs.has(old_id))
        return true;
    }
    return false;
  }
  _push_changes(changes, options2 = {}) {
    if (!this.is_syncable)
      return;
    const { document: document2 } = this;
    if (document2 == null)
      return;
    const { setter_id } = options2;
    const events = [];
    for (const [prop, old_value, new_value] of changes) {
      if (prop.syncable)
        events.push(new ModelChangedEvent(document2, this, prop.attr, old_value, new_value, setter_id));
    }
    if (events.length != 0) {
      let event2;
      if (events.length == 1)
        [event2] = events;
      else
        event2 = new DocumentEventBatch(document2, events, setter_id);
      document2._trigger_on_change(event2);
    }
  }
  on_change(properties, fn) {
    for (const property of isArray(properties) ? properties : [properties]) {
      this.connect(property.change, fn);
    }
  }
}
_a$3U = HasProps;
(() => {
  _a$3U.prototype._props = {};
  _a$3U.prototype._mixins = [];
})();
const _createElement = (tag) => {
  return (attrs = {}, ...children2) => {
    const element = document.createElement(tag);
    element.classList.add("bk");
    if (!isPlainObject(attrs)) {
      children2 = [attrs, ...children2];
      attrs = {};
    }
    for (let [attr, value] of entries(attrs)) {
      if (value == null || isBoolean(value) && !value)
        continue;
      if (attr === "class") {
        if (isString(value))
          value = value.split(/\s+/);
        if (isArray(value)) {
          for (const cls of value) {
            if (cls != null)
              element.classList.add(cls);
          }
          continue;
        }
      }
      if (attr === "style" && isPlainObject(value)) {
        for (const [prop, data2] of entries(value)) {
          element.style[prop] = data2;
        }
        continue;
      }
      if (attr === "data" && isPlainObject(value)) {
        for (const [key, data2] of entries(value)) {
          element.dataset[key] = data2;
        }
        continue;
      }
      element.setAttribute(attr, value);
    }
    function append2(child) {
      if (isString(child))
        element.appendChild(document.createTextNode(child));
      else if (child instanceof Node)
        element.appendChild(child);
      else if (child instanceof NodeList || child instanceof HTMLCollection) {
        for (const el of child) {
          element.appendChild(el);
        }
      } else if (child != null && child !== false)
        throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
    }
    for (const child of children2) {
      if (isArray(child)) {
        for (const _child of child)
          append2(_child);
      } else
        append2(child);
    }
    return element;
  };
};
function createElement(tag, attrs, ...children2) {
  return _createElement(tag)(attrs, ...children2);
}
const div = _createElement("div"), span = _createElement("span"), canvas = _createElement("canvas"), style$2 = _createElement("style"), a = _createElement("a"), p = _createElement("p"), i = _createElement("i"), pre = _createElement("pre"), button = _createElement("button"), label = _createElement("label"), input$1 = _createElement("input"), select = _createElement("select"), option = _createElement("option"), optgroup = _createElement("optgroup"), textarea = _createElement("textarea");
function nbsp() {
  return document.createTextNode("\xA0");
}
function append(element, ...children2) {
  for (const child of children2)
    element.appendChild(child);
}
function remove(element) {
  const parent = element.parentNode;
  if (parent != null) {
    parent.removeChild(element);
  }
}
const removeElement = remove;
function replaceWith(element, replacement) {
  const parent = element.parentNode;
  if (parent != null) {
    parent.replaceChild(replacement, element);
  }
}
function prepend(element, ...nodes) {
  const first = element.firstChild;
  for (const node of nodes) {
    element.insertBefore(node, first);
  }
}
function empty$1(node, attrs = false) {
  let child;
  while (child = node.firstChild) {
    node.removeChild(child);
  }
  if (attrs && node instanceof Element) {
    for (const attr of node.attributes) {
      node.removeAttributeNode(attr);
    }
  }
}
function display(element) {
  element.style.display = "";
}
function undisplay(element) {
  element.style.display = "none";
}
function show(element) {
  element.style.visibility = "";
}
function hide(element) {
  element.style.visibility = "hidden";
}
function offset(element) {
  const rect2 = element.getBoundingClientRect();
  return {
    top: rect2.top + window.pageYOffset - document.documentElement.clientTop,
    left: rect2.left + window.pageXOffset - document.documentElement.clientLeft
  };
}
function num(value) {
  return parseFloat(value) || 0;
}
function extents(el) {
  const style2 = getComputedStyle(el);
  return {
    border: {
      top: num(style2.borderTopWidth),
      bottom: num(style2.borderBottomWidth),
      left: num(style2.borderLeftWidth),
      right: num(style2.borderRightWidth)
    },
    margin: {
      top: num(style2.marginTop),
      bottom: num(style2.marginBottom),
      left: num(style2.marginLeft),
      right: num(style2.marginRight)
    },
    padding: {
      top: num(style2.paddingTop),
      bottom: num(style2.paddingBottom),
      left: num(style2.paddingLeft),
      right: num(style2.paddingRight)
    }
  };
}
function size(el) {
  const rect2 = el.getBoundingClientRect();
  return {
    width: Math.ceil(rect2.width),
    height: Math.ceil(rect2.height)
  };
}
function scroll_size(el) {
  return {
    width: Math.ceil(el.scrollWidth),
    height: Math.ceil(el.scrollHeight)
  };
}
function content_size(el) {
  const { left: left2, top } = el.getBoundingClientRect();
  const { padding } = extents(el);
  let width = 0;
  let height = 0;
  for (const child of el.children) {
    const rect2 = child.getBoundingClientRect();
    width = Math.max(width, Math.ceil(rect2.left - left2 - padding.left + rect2.width));
    height = Math.max(height, Math.ceil(rect2.top - top - padding.top + rect2.height));
  }
  return { width, height };
}
function position(el, box, margin) {
  const { style: style2 } = el;
  style2.left = `${box.x}px`;
  style2.top = `${box.y}px`;
  style2.width = `${box.width}px`;
  style2.height = `${box.height}px`;
  if (margin == null)
    style2.margin = "";
  else {
    const { top, right: right2, bottom, left: left2 } = margin;
    style2.margin = `${top}px ${right2}px ${bottom}px ${left2}px`;
  }
}
function children(el) {
  return Array.from(el.children);
}
class ClassList {
  constructor(el) {
    this.el = el;
    this.classList = el.classList;
  }
  get values() {
    const values2 = [];
    for (let i2 = 0; i2 < this.classList.length; i2++) {
      const item = this.classList.item(i2);
      if (item != null)
        values2.push(item);
    }
    return values2;
  }
  has(cls) {
    return this.classList.contains(cls);
  }
  add(...classes2) {
    for (const cls of classes2)
      this.classList.add(cls);
    return this;
  }
  remove(...classes2) {
    for (const cls of classes2)
      this.classList.remove(cls);
    return this;
  }
  clear() {
    for (const cls of this.values) {
      if (cls != "bk")
        this.classList.remove(cls);
    }
    return this;
  }
  toggle(cls, activate) {
    const add2 = activate != null ? activate : !this.has(cls);
    if (add2)
      this.add(cls);
    else
      this.remove(cls);
    return this;
  }
}
ClassList.__name__ = "ClassList";
function classes(el) {
  return new ClassList(el);
}
function toggle_attribute(el, attr, state) {
  if (state == null) {
    state = !el.hasAttribute(attr);
  }
  if (state)
    el.setAttribute(attr, "true");
  else
    el.removeAttribute(attr);
}
var Keys;
(function(Keys2) {
  Keys2[Keys2["Backspace"] = 8] = "Backspace";
  Keys2[Keys2["Tab"] = 9] = "Tab";
  Keys2[Keys2["Enter"] = 13] = "Enter";
  Keys2[Keys2["Esc"] = 27] = "Esc";
  Keys2[Keys2["PageUp"] = 33] = "PageUp";
  Keys2[Keys2["PageDown"] = 34] = "PageDown";
  Keys2[Keys2["Left"] = 37] = "Left";
  Keys2[Keys2["Up"] = 38] = "Up";
  Keys2[Keys2["Right"] = 39] = "Right";
  Keys2[Keys2["Down"] = 40] = "Down";
  Keys2[Keys2["Delete"] = 46] = "Delete";
})(Keys || (Keys = {}));
function undisplayed(el, fn) {
  const { display: display2 } = el.style;
  el.style.display = "none";
  try {
    return fn();
  } finally {
    el.style.display = display2;
  }
}
function unsized(el, fn) {
  return sized(el, {}, fn);
}
function sized(el, size2, fn) {
  const { width, height, position: position2, display: display2 } = el.style;
  el.style.position = "absolute";
  el.style.display = "";
  el.style.width = size2.width != null && size2.width != Infinity ? `${size2.width}px` : "auto";
  el.style.height = size2.height != null && size2.height != Infinity ? `${size2.height}px` : "auto";
  try {
    return fn();
  } finally {
    el.style.position = position2;
    el.style.display = display2;
    el.style.width = width;
    el.style.height = height;
  }
}
class StyleSheet {
  constructor(root2) {
    this.root = root2;
    this.known = /* @__PURE__ */ new Set();
    this.style = style$2({ type: "text/css" });
    prepend(root2, this.style);
  }
  append(css) {
    if (!this.known.has(css)) {
      this.style.appendChild(document.createTextNode(css));
      this.known.add(css);
    }
  }
}
StyleSheet.__name__ = "StyleSheet";
const stylesheet = new StyleSheet(document.head);
const root$3 = "bk-root";
var root_css = `.bk-root{position:relative;width:auto;height:auto;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}`;
class View {
  constructor(options2) {
    this.removed = new Signal0(this, "removed");
    this._ready = Promise.resolve(void 0);
    this._slots = /* @__PURE__ */ new WeakMap();
    this._idle_notified = false;
    const { model, parent } = options2;
    this.model = model;
    this.parent = parent;
    this.root = parent == null ? this : parent.root;
    this.removed.emit();
  }
  get ready() {
    return this._ready;
  }
  connect(signal, slot) {
    let new_slot = this._slots.get(slot);
    if (new_slot == null) {
      new_slot = (args, sender) => {
        const promise = Promise.resolve(slot.call(this, args, sender));
        this._ready = this._ready.then(() => promise);
      };
      this._slots.set(slot, new_slot);
    }
    return signal.connect(new_slot, this);
  }
  disconnect(signal, slot) {
    return signal.disconnect(slot, this);
  }
  initialize() {
    this._has_finished = false;
    if (this.is_root) {
      this._stylesheet = stylesheet;
    }
    for (const style2 of this.styles()) {
      this.stylesheet.append(style2);
    }
  }
  async lazy_initialize() {
  }
  remove() {
    this.disconnect_signals();
    this.removed.emit();
  }
  toString() {
    return `${this.model.type}View(${this.model.id})`;
  }
  serializable_state() {
    return { type: this.model.type };
  }
  get is_root() {
    return this.parent == null;
  }
  has_finished() {
    return this._has_finished;
  }
  get is_idle() {
    return this.has_finished();
  }
  connect_signals() {
  }
  disconnect_signals() {
    Signal.disconnect_receiver(this);
  }
  on_change(properties, fn) {
    for (const property of isArray(properties) ? properties : [properties]) {
      this.connect(property.change, fn);
    }
  }
  cursor(_sx, _sy) {
    return null;
  }
  get stylesheet() {
    if (this.is_root)
      return this._stylesheet;
    else
      return this.root.stylesheet;
  }
  styles() {
    return [root_css];
  }
  notify_finished() {
    if (!this.is_root)
      this.root.notify_finished();
    else {
      if (!this._idle_notified && this.has_finished()) {
        if (this.model.document != null) {
          this._idle_notified = true;
          this.model.document.notify_idle(this.model);
        }
      }
    }
  }
}
View.__name__ = "View";
class VisualProperties {
  constructor(obj, prefix = "") {
    this.obj = obj;
    this.prefix = prefix;
    const self2 = this;
    this._props = [];
    for (const attr of this.attrs) {
      const prop = obj.model.properties[prefix + attr];
      prop.change.connect(() => this.update());
      self2[attr] = prop;
      this._props.push(prop);
    }
  }
  *[Symbol.iterator]() {
    yield* this._props;
  }
  update() {
  }
}
VisualProperties.__name__ = "VisualProperties";
class VisualUniforms {
  constructor(obj, prefix = "") {
    this.obj = obj;
    this.prefix = prefix;
    for (const attr of this.attrs) {
      Object.defineProperty(this, attr, {
        get() {
          return obj[prefix + attr];
        }
      });
    }
  }
  *[Symbol.iterator]() {
    for (const attr of this.attrs) {
      yield this.obj.model.properties[this.prefix + attr];
    }
  }
  update() {
  }
}
VisualUniforms.__name__ = "VisualUniforms";
const Line$2 = {
  line_color: [Nullable(Color$1), "black"],
  line_alpha: [Alpha, 1],
  line_width: [Number$2, 1],
  line_join: [LineJoin, "bevel"],
  line_cap: [LineCap, "butt"],
  line_dash: [Or(LineDash, Array$2(Number$2)), []],
  line_dash_offset: [Number$2, 0]
};
const Fill$1 = {
  fill_color: [Nullable(Color$1), "gray"],
  fill_alpha: [Alpha, 1]
};
const Hatch$1 = {
  hatch_color: [Nullable(Color$1), "black"],
  hatch_alpha: [Alpha, 1],
  hatch_scale: [Number$2, 12],
  hatch_pattern: [Nullable(Or(HatchPatternType, String$2)), null],
  hatch_weight: [Number$2, 1],
  hatch_extra: [Dict(AnyRef()), {}]
};
const Text$3 = {
  text_color: [Nullable(Color$1), "#444444"],
  text_alpha: [Alpha, 1],
  text_font: [Font, "helvetica"],
  text_font_size: [FontSize$1, "16px"],
  text_font_style: [FontStyle, "normal"],
  text_align: [TextAlign, "left"],
  text_baseline: [TextBaseline, "bottom"],
  text_line_height: [Number$2, 1.2]
};
const LineScalar$1 = {
  line_color: [ColorScalar, "black"],
  line_alpha: [NumberScalar, 1],
  line_width: [NumberScalar, 1],
  line_join: [LineJoinScalar, "bevel"],
  line_cap: [LineCapScalar, "butt"],
  line_dash: [LineDashScalar, []],
  line_dash_offset: [NumberScalar, 0]
};
const FillScalar$1 = {
  fill_color: [ColorScalar, "gray"],
  fill_alpha: [NumberScalar, 1]
};
const HatchScalar$1 = {
  hatch_color: [ColorScalar, "black"],
  hatch_alpha: [NumberScalar, 1],
  hatch_scale: [NumberScalar, 12],
  hatch_pattern: [NullStringScalar, null],
  hatch_weight: [NumberScalar, 1],
  hatch_extra: [AnyScalar, {}]
};
const TextScalar$1 = {
  text_color: [ColorScalar, "#444444"],
  text_alpha: [NumberScalar, 1],
  text_font: [FontScalar, "helvetica"],
  text_font_size: [FontSizeScalar, "16px"],
  text_font_style: [FontStyleScalar, "normal"],
  text_align: [TextAlignScalar, "left"],
  text_baseline: [TextBaselineScalar, "bottom"],
  text_line_height: [NumberScalar, 1.2]
};
const LineVector$1 = {
  line_color: [ColorSpec, "black"],
  line_alpha: [NumberSpec, 1],
  line_width: [NumberSpec, 1],
  line_join: [LineJoinSpec, "bevel"],
  line_cap: [LineCapSpec, "butt"],
  line_dash: [LineDashSpec, []],
  line_dash_offset: [NumberSpec, 0]
};
const FillVector$1 = {
  fill_color: [ColorSpec, "gray"],
  fill_alpha: [NumberSpec, 1]
};
const HatchVector$1 = {
  hatch_color: [ColorSpec, "black"],
  hatch_alpha: [NumberSpec, 1],
  hatch_scale: [NumberSpec, 12],
  hatch_pattern: [NullStringSpec, null],
  hatch_weight: [NumberSpec, 1],
  hatch_extra: [AnyScalar, {}]
};
const TextVector$1 = {
  text_color: [ColorSpec, "#444444"],
  text_alpha: [NumberSpec, 1],
  text_font: [FontSpec, "helvetica"],
  text_font_size: [FontSizeSpec, "16px"],
  text_font_style: [FontStyleSpec, "normal"],
  text_align: [TextAlignSpec, "left"],
  text_baseline: [TextBaselineSpec, "bottom"],
  text_line_height: [NumberSpec, 1.2]
};
function attrs_of(model, prefix, mixin, prefixed = false) {
  const attrs = {};
  for (const attr of keys(mixin)) {
    const prefixed_attr = `${prefix}${attr}`;
    const value = model[prefixed_attr];
    attrs[prefixed ? prefixed_attr : attr] = value;
  }
  return attrs;
}
function resolve_line_dash(line_dash) {
  if (isArray(line_dash))
    return line_dash;
  else {
    switch (line_dash) {
      case "solid":
        return [];
      case "dashed":
        return [6];
      case "dotted":
        return [2, 4];
      case "dotdash":
        return [2, 4, 6, 4];
      case "dashdot":
        return [6, 4, 2, 4];
      default:
        return line_dash.split(" ").map(Number).filter(isInteger);
    }
  }
}
class Line$1 extends VisualProperties {
  get doit() {
    const color = this.line_color.get_value();
    const alpha = this.line_alpha.get_value();
    const width = this.line_width.get_value();
    return !(color == null || alpha == 0 || width == 0);
  }
  apply(ctx) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.stroke();
    }
    return doit;
  }
  values() {
    return {
      color: this.line_color.get_value(),
      alpha: this.line_alpha.get_value(),
      width: this.line_width.get_value(),
      join: this.line_join.get_value(),
      cap: this.line_cap.get_value(),
      dash: this.line_dash.get_value(),
      offset: this.line_dash_offset.get_value()
    };
  }
  set_value(ctx) {
    const color = this.line_color.get_value();
    const alpha = this.line_alpha.get_value();
    ctx.strokeStyle = color2css(color, alpha);
    ctx.lineWidth = this.line_width.get_value();
    ctx.lineJoin = this.line_join.get_value();
    ctx.lineCap = this.line_cap.get_value();
    ctx.lineDash = resolve_line_dash(this.line_dash.get_value());
    ctx.lineDashOffset = this.line_dash_offset.get_value();
  }
}
Line$1.__name__ = "Line";
class LineScalar extends VisualUniforms {
  get doit() {
    const color = this.line_color.value;
    const alpha = this.line_alpha.value;
    const width = this.line_width.value;
    return !(color == 0 || alpha == 0 || width == 0);
  }
  apply(ctx) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.stroke();
    }
    return doit;
  }
  values() {
    return {
      color: this.line_color.value,
      alpha: this.line_alpha.value,
      width: this.line_width.value,
      join: this.line_join.value,
      cap: this.line_cap.value,
      dash: this.line_dash.value,
      offset: this.line_dash_offset.value
    };
  }
  set_value(ctx) {
    const color = this.line_color.value;
    const alpha = this.line_alpha.value;
    ctx.strokeStyle = color2css(color, alpha);
    ctx.lineWidth = this.line_width.value;
    ctx.lineJoin = this.line_join.value;
    ctx.lineCap = this.line_cap.value;
    ctx.lineDash = resolve_line_dash(this.line_dash.value);
    ctx.lineDashOffset = this.line_dash_offset.value;
  }
}
LineScalar.__name__ = "LineScalar";
class LineVector extends VisualUniforms {
  get doit() {
    const { line_color } = this;
    if (line_color.is_Scalar() && line_color.value == 0)
      return false;
    const { line_alpha } = this;
    if (line_alpha.is_Scalar() && line_alpha.value == 0)
      return false;
    const { line_width } = this;
    if (line_width.is_Scalar() && line_width.value == 0)
      return false;
    return true;
  }
  apply(ctx, i2) {
    const { doit } = this;
    if (doit) {
      this.set_vectorize(ctx, i2);
      ctx.stroke();
    }
    return doit;
  }
  values(i2) {
    return {
      color: this.line_color.get(i2),
      alpha: this.line_alpha.get(i2),
      width: this.line_width.get(i2),
      join: this.line_join.get(i2),
      cap: this.line_cap.get(i2),
      dash: this.line_dash.get(i2),
      offset: this.line_dash_offset.get(i2)
    };
  }
  set_vectorize(ctx, i2) {
    const color = this.line_color.get(i2);
    const alpha = this.line_alpha.get(i2);
    const width = this.line_width.get(i2);
    const join2 = this.line_join.get(i2);
    const cap = this.line_cap.get(i2);
    const dash2 = this.line_dash.get(i2);
    const offset2 = this.line_dash_offset.get(i2);
    ctx.strokeStyle = color2css(color, alpha);
    ctx.lineWidth = width;
    ctx.lineJoin = join2;
    ctx.lineCap = cap;
    ctx.lineDash = resolve_line_dash(dash2);
    ctx.lineDashOffset = offset2;
  }
}
LineVector.__name__ = "LineVector";
Line$1.prototype.type = "line";
Line$1.prototype.attrs = Object.keys(Line$2);
LineScalar.prototype.type = "line";
LineScalar.prototype.attrs = Object.keys(LineScalar$1);
LineVector.prototype.type = "line";
LineVector.prototype.attrs = Object.keys(LineVector$1);
class Fill extends VisualProperties {
  get doit() {
    const color = this.fill_color.get_value();
    const alpha = this.fill_alpha.get_value();
    return !(color == null || alpha == 0);
  }
  apply(ctx, rule) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.fill(rule);
    }
    return doit;
  }
  values() {
    return {
      color: this.fill_color.get_value(),
      alpha: this.fill_alpha.get_value()
    };
  }
  set_value(ctx) {
    const color = this.fill_color.get_value();
    const alpha = this.fill_alpha.get_value();
    ctx.fillStyle = color2css(color, alpha);
  }
}
Fill.__name__ = "Fill";
class FillScalar extends VisualUniforms {
  get doit() {
    const color = this.fill_color.value;
    const alpha = this.fill_alpha.value;
    return !(color == 0 || alpha == 0);
  }
  apply(ctx, rule) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.fill(rule);
    }
    return doit;
  }
  values() {
    return {
      color: this.fill_color.value,
      alpha: this.fill_alpha.value
    };
  }
  set_value(ctx) {
    const color = this.fill_color.value;
    const alpha = this.fill_alpha.value;
    ctx.fillStyle = color2css(color, alpha);
  }
}
FillScalar.__name__ = "FillScalar";
class FillVector extends VisualUniforms {
  get doit() {
    const { fill_color } = this;
    if (fill_color.is_Scalar() && fill_color.value == 0)
      return false;
    const { fill_alpha } = this;
    if (fill_alpha.is_Scalar() && fill_alpha.value == 0)
      return false;
    return true;
  }
  apply(ctx, i2, rule) {
    const { doit } = this;
    if (doit) {
      this.set_vectorize(ctx, i2);
      ctx.fill(rule);
    }
    return doit;
  }
  values(i2) {
    return {
      color: this.fill_color.get(i2),
      alpha: this.fill_alpha.get(i2)
    };
  }
  set_vectorize(ctx, i2) {
    const color = this.fill_color.get(i2);
    const alpha = this.fill_alpha.get(i2);
    ctx.fillStyle = color2css(color, alpha);
  }
}
FillVector.__name__ = "FillVector";
Fill.prototype.type = "fill";
Fill.prototype.attrs = Object.keys(Fill$1);
FillScalar.prototype.type = "fill";
FillScalar.prototype.attrs = Object.keys(FillScalar$1);
FillVector.prototype.type = "fill";
FillVector.prototype.attrs = Object.keys(FillVector$1);
class Text$2 extends VisualProperties {
  get doit() {
    const color = this.text_color.get_value();
    const alpha = this.text_alpha.get_value();
    return !(color == null || alpha == 0);
  }
  values() {
    return {
      color: this.text_color.get_value(),
      alpha: this.text_alpha.get_value(),
      font: this.text_font.get_value(),
      font_size: this.text_font_size.get_value(),
      font_style: this.text_font_style.get_value(),
      align: this.text_align.get_value(),
      baseline: this.text_baseline.get_value(),
      line_height: this.text_line_height.get_value()
    };
  }
  set_value(ctx) {
    const color = this.text_color.get_value();
    const alpha = this.text_alpha.get_value();
    ctx.fillStyle = color2css(color, alpha);
    ctx.font = this.font_value();
    ctx.textAlign = this.text_align.get_value();
    ctx.textBaseline = this.text_baseline.get_value();
  }
  font_value() {
    const style2 = this.text_font_style.get_value();
    const size2 = this.text_font_size.get_value();
    const face = this.text_font.get_value();
    return `${style2} ${size2} ${face}`;
  }
}
Text$2.__name__ = "Text";
class TextScalar extends VisualUniforms {
  get doit() {
    const color = this.text_color.value;
    const alpha = this.text_alpha.value;
    return !(color == 0 || alpha == 0);
  }
  values() {
    return {
      color: this.text_color.value,
      alpha: this.text_alpha.value,
      font: this.text_font.value,
      font_size: this.text_font_size.value,
      font_style: this.text_font_style.value,
      align: this.text_align.value,
      baseline: this.text_baseline.value,
      line_height: this.text_line_height.value
    };
  }
  set_value(ctx) {
    const color = this.text_color.value;
    const alpha = this.text_alpha.value;
    const font = this.font_value();
    const align = this.text_align.value;
    const baseline = this.text_baseline.value;
    ctx.fillStyle = color2css(color, alpha);
    ctx.font = font;
    ctx.textAlign = align;
    ctx.textBaseline = baseline;
  }
  font_value() {
    const style2 = this.text_font_style.value;
    const size2 = this.text_font_size.value;
    const face = this.text_font.value;
    return `${style2} ${size2} ${face}`;
  }
}
TextScalar.__name__ = "TextScalar";
class TextVector extends VisualUniforms {
  values(i2) {
    return {
      color: this.text_color.get(i2),
      alpha: this.text_alpha.get(i2),
      font: this.text_font.get(i2),
      font_size: this.text_font_size.get(i2),
      font_style: this.text_font_style.get(i2),
      align: this.text_align.get(i2),
      baseline: this.text_baseline.get(i2),
      line_height: this.text_line_height.get(i2)
    };
  }
  get doit() {
    const { text_color } = this;
    if (text_color.is_Scalar() && text_color.value == 0)
      return false;
    const { text_alpha } = this;
    if (text_alpha.is_Scalar() && text_alpha.value == 0)
      return false;
    return true;
  }
  set_vectorize(ctx, i2) {
    const color = this.text_color.get(i2);
    const alpha = this.text_alpha.get(i2);
    const font = this.font_value(i2);
    const align = this.text_align.get(i2);
    const baseline = this.text_baseline.get(i2);
    ctx.fillStyle = color2css(color, alpha);
    ctx.font = font;
    ctx.textAlign = align;
    ctx.textBaseline = baseline;
  }
  font_value(i2) {
    const style2 = this.text_font_style.get(i2);
    const size2 = this.text_font_size.get(i2);
    const face = this.text_font.get(i2);
    return `${style2} ${size2} ${face}`;
  }
}
TextVector.__name__ = "TextVector";
Text$2.prototype.type = "text";
Text$2.prototype.attrs = Object.keys(Text$3);
TextScalar.prototype.type = "text";
TextScalar.prototype.attrs = Object.keys(TextScalar$1);
TextVector.prototype.type = "text";
TextVector.prototype.attrs = Object.keys(TextVector$1);
function _horz(ctx, h2, h22) {
  ctx.moveTo(0, h22 + 0.5);
  ctx.lineTo(h2, h22 + 0.5);
  ctx.stroke();
}
function _vert(ctx, h2, h22) {
  ctx.moveTo(h22 + 0.5, 0);
  ctx.lineTo(h22 + 0.5, h2);
  ctx.stroke();
}
function _x(ctx, h2) {
  ctx.moveTo(0, h2);
  ctx.lineTo(h2, 0);
  ctx.stroke();
  ctx.moveTo(0, 0);
  ctx.lineTo(h2, h2);
  ctx.stroke();
}
const hatch_aliases = {
  " ": "blank",
  ".": "dot",
  o: "ring",
  "-": "horizontal_line",
  "|": "vertical_line",
  "+": "cross",
  '"': "horizontal_dash",
  ":": "vertical_dash",
  "@": "spiral",
  "/": "right_diagonal_line",
  "\\": "left_diagonal_line",
  x: "diagonal_cross",
  ",": "right_diagonal_dash",
  "`": "left_diagonal_dash",
  v: "horizontal_wave",
  ">": "vertical_wave",
  "*": "criss_cross"
};
function get_pattern(layer, pattern, color, alpha, scale, weight) {
  layer.resize(scale, scale);
  layer.prepare();
  create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
  return layer.canvas;
}
function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
  var _a2;
  const h2 = hatch_scale;
  const h22 = h2 / 2;
  const h4 = h22 / 2;
  const color = color2css(hatch_color, hatch_alpha);
  ctx.strokeStyle = color;
  ctx.fillStyle = color;
  ctx.lineCap = "square";
  ctx.lineWidth = hatch_weight;
  switch ((_a2 = hatch_aliases[hatch_pattern]) != null ? _a2 : hatch_pattern) {
    case "blank":
      break;
    case "dot":
      ctx.arc(h22, h22, h22 / 2, 0, 2 * Math.PI, true);
      ctx.fill();
      break;
    case "ring":
      ctx.arc(h22, h22, h22 / 2, 0, 2 * Math.PI, true);
      ctx.stroke();
      break;
    case "horizontal_line":
      _horz(ctx, h2, h22);
      break;
    case "vertical_line":
      _vert(ctx, h2, h22);
      break;
    case "cross":
      _horz(ctx, h2, h22);
      _vert(ctx, h2, h22);
      break;
    case "horizontal_dash":
      _horz(ctx, h22, h22);
      break;
    case "vertical_dash":
      _vert(ctx, h22, h22);
      break;
    case "spiral": {
      const h30 = h2 / 30;
      ctx.moveTo(h22, h22);
      for (let i2 = 0; i2 < 360; i2++) {
        const angle = 0.1 * i2;
        const x2 = h22 + h30 * angle * Math.cos(angle);
        const y2 = h22 + h30 * angle * Math.sin(angle);
        ctx.lineTo(x2, y2);
      }
      ctx.stroke();
      break;
    }
    case "right_diagonal_line":
      ctx.moveTo(-h4 + 0.5, h2);
      ctx.lineTo(h4 + 0.5, 0);
      ctx.stroke();
      ctx.moveTo(h4 + 0.5, h2);
      ctx.lineTo(3 * h4 + 0.5, 0);
      ctx.stroke();
      ctx.moveTo(3 * h4 + 0.5, h2);
      ctx.lineTo(5 * h4 + 0.5, 0);
      ctx.stroke();
      ctx.stroke();
      break;
    case "left_diagonal_line":
      ctx.moveTo(h4 + 0.5, h2);
      ctx.lineTo(-h4 + 0.5, 0);
      ctx.stroke();
      ctx.moveTo(3 * h4 + 0.5, h2);
      ctx.lineTo(h4 + 0.5, 0);
      ctx.stroke();
      ctx.moveTo(5 * h4 + 0.5, h2);
      ctx.lineTo(3 * h4 + 0.5, 0);
      ctx.stroke();
      ctx.stroke();
      break;
    case "diagonal_cross":
      _x(ctx, h2);
      break;
    case "right_diagonal_dash":
      ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
      ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
      ctx.stroke();
      break;
    case "left_diagonal_dash":
      ctx.moveTo(h4 + 0.5, h4 + 0.5);
      ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
      ctx.stroke();
      break;
    case "horizontal_wave":
      ctx.moveTo(0, h4);
      ctx.lineTo(h22, 3 * h4);
      ctx.lineTo(h2, h4);
      ctx.stroke();
      break;
    case "vertical_wave":
      ctx.moveTo(h4, 0);
      ctx.lineTo(3 * h4, h22);
      ctx.lineTo(h4, h2);
      ctx.stroke();
      break;
    case "criss_cross":
      _x(ctx, h2);
      _horz(ctx, h2, h22);
      _vert(ctx, h2, h22);
      break;
  }
}
class Hatch extends VisualProperties {
  constructor() {
    super(...arguments);
    this._update_iteration = 0;
  }
  update() {
    this._update_iteration++;
    this._hatch_image = null;
    if (!this.doit)
      return;
    const color = this.hatch_color.get_value();
    const alpha = this.hatch_alpha.get_value();
    const scale = this.hatch_scale.get_value();
    const pattern = this.hatch_pattern.get_value();
    const weight = this.hatch_weight.get_value();
    const finalize = (image) => {
      this._hatch_image = image;
    };
    const textures = this.hatch_extra.get_value();
    const texture = textures[pattern];
    if (texture != null) {
      const image = texture.get_pattern(color, alpha, scale, weight);
      if (image instanceof Promise) {
        const { _update_iteration } = this;
        image.then((image2) => {
          if (this._update_iteration == _update_iteration) {
            finalize(image2);
            this.obj.request_render();
          }
        });
      } else {
        finalize(image);
      }
    } else {
      const layer = this.obj.canvas.create_layer();
      const image = get_pattern(layer, pattern, color, alpha, scale, weight);
      finalize(image);
    }
  }
  get doit() {
    const color = this.hatch_color.get_value();
    const alpha = this.hatch_alpha.get_value();
    const pattern = this.hatch_pattern.get_value();
    return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
  }
  apply(ctx, rule) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.layer.undo_transform(() => ctx.fill(rule));
    }
    return doit;
  }
  set_value(ctx) {
    const pattern = this.pattern(ctx);
    ctx.fillStyle = pattern != null ? pattern : "transparent";
  }
  pattern(ctx) {
    const image = this._hatch_image;
    if (image == null)
      return null;
    else
      return ctx.createPattern(image, this.repetition());
  }
  repetition() {
    const pattern = this.hatch_pattern.get_value();
    const texture = this.hatch_extra.get_value()[pattern];
    if (texture == null)
      return "repeat";
    else {
      switch (texture.repetition) {
        case "repeat":
          return "repeat";
        case "repeat_x":
          return "repeat-x";
        case "repeat_y":
          return "repeat-y";
        case "no_repeat":
          return "no-repeat";
      }
    }
  }
}
Hatch.__name__ = "Hatch";
class HatchScalar extends VisualUniforms {
  constructor() {
    super(...arguments);
    this._static_doit = false;
    this._update_iteration = 0;
  }
  _compute_static_doit() {
    const color = this.hatch_color.value;
    const alpha = this.hatch_alpha.value;
    const pattern = this.hatch_pattern.value;
    return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
  }
  update() {
    this._update_iteration++;
    const n2 = this.hatch_color.length;
    this._hatch_image = new UniformScalar(null, n2);
    this._static_doit = this._compute_static_doit();
    if (!this._static_doit)
      return;
    const color = this.hatch_color.value;
    const alpha = this.hatch_alpha.value;
    const scale = this.hatch_scale.value;
    const pattern = this.hatch_pattern.value;
    const weight = this.hatch_weight.value;
    const finalize = (image) => {
      this._hatch_image = new UniformScalar(image, n2);
    };
    const textures = this.hatch_extra.value;
    const texture = textures[pattern];
    if (texture != null) {
      const image = texture.get_pattern(color, alpha, scale, weight);
      if (image instanceof Promise) {
        const { _update_iteration } = this;
        image.then((image2) => {
          if (this._update_iteration == _update_iteration) {
            finalize(image2);
            this.obj.request_render();
          }
        });
      } else {
        finalize(image);
      }
    } else {
      const layer = this.obj.canvas.create_layer();
      const image = get_pattern(layer, pattern, color, alpha, scale, weight);
      finalize(image);
    }
  }
  get doit() {
    return this._static_doit;
  }
  apply(ctx, rule) {
    const { doit } = this;
    if (doit) {
      this.set_value(ctx);
      ctx.layer.undo_transform(() => ctx.fill(rule));
    }
    return doit;
  }
  set_value(ctx) {
    var _a2;
    ctx.fillStyle = (_a2 = this.pattern(ctx)) != null ? _a2 : "transparent";
  }
  pattern(ctx) {
    const image = this._hatch_image.value;
    if (image == null)
      return null;
    else
      return ctx.createPattern(image, this.repetition());
  }
  repetition() {
    const pattern = this.hatch_pattern.value;
    const texture = this.hatch_extra.value[pattern];
    if (texture == null)
      return "repeat";
    else {
      switch (texture.repetition) {
        case "repeat":
          return "repeat";
        case "repeat_x":
          return "repeat-x";
        case "repeat_y":
          return "repeat-y";
        case "no_repeat":
          return "no-repeat";
      }
    }
  }
}
HatchScalar.__name__ = "HatchScalar";
class HatchVector extends VisualUniforms {
  constructor() {
    super(...arguments);
    this._static_doit = false;
    this._update_iteration = 0;
  }
  _compute_static_doit() {
    const { hatch_color } = this;
    if (hatch_color.is_Scalar() && hatch_color.value == 0)
      return false;
    const { hatch_alpha } = this;
    if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0)
      return false;
    const { hatch_pattern } = this;
    if (hatch_pattern.is_Scalar()) {
      const pattern = hatch_pattern.value;
      if (pattern == " " || pattern == "blank" || pattern == null)
        return false;
    }
    return true;
  }
  update() {
    this._update_iteration++;
    const n2 = this.hatch_color.length;
    this._hatch_image = new UniformScalar(null, n2);
    this._static_doit = this._compute_static_doit();
    if (!this._static_doit)
      return;
    const resolve_image = (pattern, color, alpha, scale, weight, finalize) => {
      const textures = this.hatch_extra.value;
      const texture = textures[pattern];
      if (texture != null) {
        const image = texture.get_pattern(color, alpha, scale, weight);
        if (image instanceof Promise) {
          const { _update_iteration } = this;
          image.then((image2) => {
            if (this._update_iteration == _update_iteration) {
              finalize(image2);
              this.obj.request_render();
            }
          });
        } else {
          finalize(image);
        }
      } else {
        const layer = this.obj.canvas.create_layer();
        const image = get_pattern(layer, pattern, color, alpha, scale, weight);
        finalize(image);
      }
    };
    if (this.hatch_color.is_Scalar() && this.hatch_alpha.is_Scalar() && this.hatch_scale.is_Scalar() && this.hatch_pattern.is_Scalar() && this.hatch_weight.is_Scalar()) {
      const color = this.hatch_color.value;
      const alpha = this.hatch_alpha.value;
      const scale = this.hatch_scale.value;
      const pattern = this.hatch_pattern.value;
      const weight = this.hatch_weight.value;
      resolve_image(pattern, color, alpha, scale, weight, (image) => {
        this._hatch_image = new UniformScalar(image, n2);
      });
    } else {
      const images = new Array(n2);
      images.fill(null);
      this._hatch_image = new UniformVector(images);
      for (let i2 = 0; i2 < n2; i2++) {
        const color = this.hatch_color.get(i2);
        const alpha = this.hatch_alpha.get(i2);
        const scale = this.hatch_scale.get(i2);
        const pattern = this.hatch_pattern.get(i2);
        const weight = this.hatch_weight.get(i2);
        resolve_image(pattern, color, alpha, scale, weight, (image) => {
          images[i2] = image;
        });
      }
    }
  }
  get doit() {
    return this._static_doit;
  }
  apply(ctx, i2, rule) {
    const { doit } = this;
    if (doit) {
      this.set_vectorize(ctx, i2);
      ctx.layer.undo_transform(() => ctx.fill(rule));
    }
    return doit;
  }
  set_vectorize(ctx, i2) {
    var _a2;
    ctx.fillStyle = (_a2 = this.pattern(ctx, i2)) != null ? _a2 : "transparent";
  }
  pattern(ctx, i2) {
    const image = this._hatch_image.get(i2);
    if (image == null)
      return null;
    else
      return ctx.createPattern(image, this.repetition(i2));
  }
  repetition(i2) {
    const pattern = this.hatch_pattern.get(i2);
    const texture = this.hatch_extra.value[pattern];
    if (texture == null)
      return "repeat";
    else {
      switch (texture.repetition) {
        case "repeat":
          return "repeat";
        case "repeat_x":
          return "repeat-x";
        case "repeat_y":
          return "repeat-y";
        case "no_repeat":
          return "no-repeat";
      }
    }
  }
}
HatchVector.__name__ = "HatchVector";
Hatch.prototype.type = "hatch";
Hatch.prototype.attrs = Object.keys(Hatch$1);
HatchScalar.prototype.type = "hatch";
HatchScalar.prototype.attrs = Object.keys(HatchScalar$1);
HatchVector.prototype.type = "hatch";
HatchVector.prototype.attrs = Object.keys(HatchVector$1);
class Visuals {
  constructor(view) {
    this._visuals = [];
    for (const [prefix, mixin] of view.model._mixins) {
      const visual = (() => {
        switch (mixin) {
          case Line$2:
            return new Line$1(view, prefix);
          case LineScalar$1:
            return new LineScalar(view, prefix);
          case LineVector$1:
            return new LineVector(view, prefix);
          case Fill$1:
            return new Fill(view, prefix);
          case FillScalar$1:
            return new FillScalar(view, prefix);
          case FillVector$1:
            return new FillVector(view, prefix);
          case Text$3:
            return new Text$2(view, prefix);
          case TextScalar$1:
            return new TextScalar(view, prefix);
          case TextVector$1:
            return new TextVector(view, prefix);
          case Hatch$1:
            return new Hatch(view, prefix);
          case HatchScalar$1:
            return new HatchScalar(view, prefix);
          case HatchVector$1:
            return new HatchVector(view, prefix);
          default:
            throw new Error("unknown visual");
        }
      })();
      if (visual instanceof VisualProperties)
        visual.update();
      this._visuals.push(visual);
      Object.defineProperty(this, prefix + visual.type, {
        get() {
          return visual;
        },
        configurable: false,
        enumerable: true
      });
    }
  }
  *[Symbol.iterator]() {
    yield* this._visuals;
  }
}
Visuals.__name__ = "Visuals";
var _a$3T;
class Model extends HasProps {
  constructor(attrs) {
    super(attrs);
  }
  get is_syncable() {
    return this.syncable;
  }
  [equals](that, cmp) {
    return cmp.eq(this.id, that.id) && super[equals](that, cmp);
  }
  initialize() {
    super.initialize();
    this._js_callbacks = /* @__PURE__ */ new Map();
  }
  connect_signals() {
    super.connect_signals();
    this._update_property_callbacks();
    this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
    this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
    this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
  }
  _process_event(event2) {
    var _a2;
    for (const callback of (_a2 = this.js_event_callbacks[event2.event_name]) != null ? _a2 : [])
      callback.execute(event2);
    if (this.document != null && this.subscribed_events.some((m) => m == event2.event_name))
      this.document.event_manager.send_event(event2);
  }
  trigger_event(event2) {
    if (this.document != null) {
      event2.origin = this;
      this.document.event_manager.trigger(event2);
    }
  }
  _update_event_callbacks() {
    if (this.document == null) {
      logger.warn("WARNING: Document not defined for updating event callbacks");
      return;
    }
    this.document.event_manager.subscribed_models.add(this);
  }
  _update_property_callbacks() {
    const signal_for = (event2) => {
      const [evt, attr = null] = event2.split(":");
      return attr != null ? this.properties[attr][evt] : this[evt];
    };
    for (const [event2, callbacks] of this._js_callbacks) {
      const signal = signal_for(event2);
      for (const cb of callbacks)
        this.disconnect(signal, cb);
    }
    this._js_callbacks.clear();
    for (const [event2, callbacks] of entries(this.js_property_callbacks)) {
      const wrappers = callbacks.map((cb) => () => cb.execute(this));
      this._js_callbacks.set(event2, wrappers);
      const signal = signal_for(event2);
      for (const cb of wrappers)
        this.connect(signal, cb);
    }
  }
  _doc_attached() {
    if (!isEmpty(this.js_event_callbacks) || this.subscribed_events.length != 0)
      this._update_event_callbacks();
  }
  _doc_detached() {
    this.document.event_manager.subscribed_models.delete(this);
  }
  select(selector) {
    if (isString(selector))
      return [...this.references()].filter((ref) => ref instanceof Model && ref.name === selector);
    else if (selector.prototype instanceof HasProps)
      return [...this.references()].filter((ref) => ref instanceof selector);
    else
      throw new Error("invalid selector");
  }
  select_one(selector) {
    const result = this.select(selector);
    switch (result.length) {
      case 0:
        return null;
      case 1:
        return result[0];
      default:
        throw new Error("found more than one object matching given selector");
    }
  }
}
_a$3T = Model;
Model.__name__ = "Model";
(() => {
  _a$3T.define(({ Any: Any2, Unknown: Unknown2, Boolean: Boolean2, String: String2, Array: Array2, Dict: Dict2, Nullable: Nullable2 }) => ({
    tags: [Array2(Unknown2), []],
    name: [Nullable2(String2), null],
    js_property_callbacks: [Dict2(Array2(Any2)), {}],
    js_event_callbacks: [Dict2(Array2(Any2)), {}],
    subscribed_events: [Array2(String2), []],
    syncable: [Boolean2, true]
  }));
})();
class Transform extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
Transform.__name__ = "Transform";
var _a$3S;
class Range$1 extends Model {
  constructor(attrs) {
    super(attrs);
    this.have_updated_interactively = false;
  }
  get is_reversed() {
    return this.start > this.end;
  }
  get is_valid() {
    return isFinite(this.min) && isFinite(this.max);
  }
  get span() {
    return Math.abs(this.end - this.start);
  }
}
_a$3S = Range$1;
Range$1.__name__ = "Range";
(() => {
  _a$3S.define(({ Number: Number2, Tuple: Tuple2, Or: Or2, Auto: Auto2, Nullable: Nullable2 }) => ({
    bounds: [Nullable2(Or2(Tuple2(Nullable2(Number2), Nullable2(Number2)), Auto2)), null],
    min_interval: [Nullable2(Number2), null],
    max_interval: [Nullable2(Number2), null]
  }));
  _a$3S.internal(({ Array: Array2, AnyRef: AnyRef2 }) => ({
    plots: [Array2(AnyRef2()), []]
  }));
})();
var _a$3R;
class Range1d extends Range$1 {
  constructor(attrs) {
    super(attrs);
  }
  _set_auto_bounds() {
    if (this.bounds == "auto") {
      const min2 = Math.min(this._reset_start, this._reset_end);
      const max2 = Math.max(this._reset_start, this._reset_end);
      this.setv({ bounds: [min2, max2] }, { silent: true });
    }
  }
  initialize() {
    super.initialize();
    this._set_auto_bounds();
  }
  get min() {
    return Math.min(this.start, this.end);
  }
  get max() {
    return Math.max(this.start, this.end);
  }
  reset() {
    this._set_auto_bounds();
    const { _reset_start, _reset_end } = this;
    if (this.start != _reset_start || this.end != _reset_end)
      this.setv({ start: _reset_start, end: _reset_end });
    else
      this.change.emit();
  }
  map(fn) {
    return new Range1d({ start: fn(this.start), end: fn(this.end) });
  }
  widen(v) {
    let { start: start2, end } = this;
    if (this.is_reversed) {
      start2 += v;
      end -= v;
    } else {
      start2 -= v;
      end += v;
    }
    return new Range1d({ start: start2, end });
  }
}
_a$3R = Range1d;
Range1d.__name__ = "Range1d";
(() => {
  _a$3R.define(({ Number: Number2, Nullable: Nullable2 }) => ({
    start: [Number2, 0],
    end: [Number2, 1],
    reset_start: [Nullable2(Number2), null, {
      on_update(reset_start, self2) {
        self2._reset_start = reset_start != null ? reset_start : self2.start;
      }
    }],
    reset_end: [Nullable2(Number2), null, {
      on_update(reset_end, self2) {
        self2._reset_end = reset_end != null ? reset_end : self2.end;
      }
    }]
  }));
})();
var _a$3Q;
class Scale extends Transform {
  constructor(attrs) {
    super(attrs);
  }
  compute(x2) {
    return this.s_compute(x2);
  }
  v_compute(xs) {
    const result = new ScreenArray(xs.length);
    const { s_compute } = this;
    for (let i2 = 0; i2 < xs.length; i2++) {
      result[i2] = s_compute(xs[i2]);
    }
    return result;
  }
  invert(sx) {
    return this.s_invert(sx);
  }
  v_invert(sxs) {
    const result = new Float64Array(sxs.length);
    const { s_invert } = this;
    for (let i2 = 0; i2 < sxs.length; i2++) {
      result[i2] = s_invert(sxs[i2]);
    }
    return result;
  }
  r_compute(x0, x1) {
    const { s_compute } = this;
    if (this.target_range.is_reversed)
      return [s_compute(x1), s_compute(x0)];
    else
      return [s_compute(x0), s_compute(x1)];
  }
  r_invert(sx0, sx1) {
    const { s_invert } = this;
    if (this.target_range.is_reversed)
      return [s_invert(sx1), s_invert(sx0)];
    else
      return [s_invert(sx0), s_invert(sx1)];
  }
}
_a$3Q = Scale;
Scale.__name__ = "Scale";
(() => {
  _a$3Q.internal(({ Ref: Ref2 }) => ({
    source_range: [Ref2(Range$1)],
    target_range: [Ref2(Range1d)]
  }));
})();
class ContinuousScale extends Scale {
  constructor(attrs) {
    super(attrs);
  }
}
ContinuousScale.__name__ = "ContinuousScale";
class LinearScale extends ContinuousScale {
  constructor(attrs) {
    super(attrs);
  }
  get s_compute() {
    const [factor, offset2] = this._linear_compute_state();
    return (x2) => factor * x2 + offset2;
  }
  get s_invert() {
    const [factor, offset2] = this._linear_compute_state();
    return (sx) => (sx - offset2) / factor;
  }
  _linear_compute_state() {
    const source_start = this.source_range.start;
    const source_end = this.source_range.end;
    const target_start = this.target_range.start;
    const target_end = this.target_range.end;
    const factor = (target_end - target_start) / (source_end - source_start);
    const offset2 = -(factor * source_start) + target_start;
    return [factor, offset2];
  }
}
LinearScale.__name__ = "LinearScale";
class LogScale extends ContinuousScale {
  constructor(attrs) {
    super(attrs);
  }
  get s_compute() {
    const [factor, offset2, inter_factor, inter_offset] = this._compute_state();
    return (x2) => {
      if (inter_factor == 0)
        return 0;
      else {
        const _x2 = (Math.log(x2) - inter_offset) / inter_factor;
        return isFinite(_x2) ? _x2 * factor + offset2 : NaN;
      }
    };
  }
  get s_invert() {
    const [factor, offset2, inter_factor, inter_offset] = this._compute_state();
    return (xprime) => {
      const value = (xprime - offset2) / factor;
      return Math.exp(inter_factor * value + inter_offset);
    };
  }
  _get_safe_factor(orig_start, orig_end) {
    let start2 = orig_start < 0 ? 0 : orig_start;
    let end = orig_end < 0 ? 0 : orig_end;
    if (start2 == end) {
      if (start2 == 0)
        [start2, end] = [1, 10];
      else {
        const log_val = Math.log(start2) / Math.log(10);
        start2 = 10 ** Math.floor(log_val);
        if (Math.ceil(log_val) != Math.floor(log_val))
          end = 10 ** Math.ceil(log_val);
        else
          end = 10 ** (Math.ceil(log_val) + 1);
      }
    }
    return [start2, end];
  }
  _compute_state() {
    const source_start = this.source_range.start;
    const source_end = this.source_range.end;
    const target_start = this.target_range.start;
    const target_end = this.target_range.end;
    const screen_range = target_end - target_start;
    const [start2, end] = this._get_safe_factor(source_start, source_end);
    let inter_factor;
    let inter_offset;
    if (start2 == 0) {
      inter_factor = Math.log(end);
      inter_offset = 0;
    } else {
      inter_factor = Math.log(end) - Math.log(start2);
      inter_offset = Math.log(start2);
    }
    const factor = screen_range;
    const offset2 = target_start;
    return [factor, offset2, inter_factor, inter_offset];
  }
}
LogScale.__name__ = "LogScale";
const { _linear_compute_state } = LinearScale.prototype;
class CategoricalScale extends Scale {
  constructor(attrs) {
    super(attrs);
  }
  get s_compute() {
    const [factor, offset2] = _linear_compute_state.call(this);
    const range2 = this.source_range;
    return (x2) => factor * range2.synthetic(x2) + offset2;
  }
  get s_invert() {
    const [factor, offset2] = _linear_compute_state.call(this);
    return (sx) => (sx - offset2) / factor;
  }
}
CategoricalScale.__name__ = "CategoricalScale";
var _a$3P;
class DataRange extends Range$1 {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3P = DataRange;
DataRange.__name__ = "DataRange";
(() => {
  _a$3P.define(({ String: String2, Array: Array2, AnyRef: AnyRef2 }) => ({
    names: [Array2(String2), []],
    renderers: [Array2(AnyRef2()), []]
  }));
})();
const { min: min$5, max: max$7 } = Math;
function empty() {
  return {
    x0: Infinity,
    y0: Infinity,
    x1: -Infinity,
    y1: -Infinity
  };
}
function positive_x() {
  return {
    x0: Number.MIN_VALUE,
    y0: -Infinity,
    x1: Infinity,
    y1: Infinity
  };
}
function positive_y() {
  return {
    x0: -Infinity,
    y0: Number.MIN_VALUE,
    x1: Infinity,
    y1: Infinity
  };
}
function union$1(a2, b) {
  return {
    x0: min$5(a2.x0, b.x0),
    x1: max$7(a2.x1, b.x1),
    y0: min$5(a2.y0, b.y0),
    y1: max$7(a2.y1, b.y1)
  };
}
class BBox$2 {
  constructor(box) {
    if (box == null) {
      this.x0 = 0;
      this.y0 = 0;
      this.x1 = 0;
      this.y1 = 0;
    } else if ("x0" in box) {
      const { x0, y0, x1, y1 } = box;
      if (!(x0 <= x1 && y0 <= y1))
        throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
      this.x0 = x0;
      this.y0 = y0;
      this.x1 = x1;
      this.y1 = y1;
    } else if ("x" in box) {
      const { x: x2, y: y2, width, height } = box;
      if (!(width >= 0 && height >= 0))
        throw new Error(`invalid bbox {x: ${x2}, y: ${y2}, width: ${width}, height: ${height}}`);
      this.x0 = x2;
      this.y0 = y2;
      this.x1 = x2 + width;
      this.y1 = y2 + height;
    } else {
      let left2, right2;
      let top, bottom;
      if ("width" in box) {
        if ("left" in box) {
          left2 = box.left;
          right2 = left2 + box.width;
        } else if ("right" in box) {
          right2 = box.right;
          left2 = right2 - box.width;
        } else {
          const w2 = box.width / 2;
          left2 = box.hcenter - w2;
          right2 = box.hcenter + w2;
        }
      } else {
        left2 = box.left;
        right2 = box.right;
      }
      if ("height" in box) {
        if ("top" in box) {
          top = box.top;
          bottom = top + box.height;
        } else if ("bottom" in box) {
          bottom = box.bottom;
          top = bottom - box.height;
        } else {
          const h2 = box.height / 2;
          top = box.vcenter - h2;
          bottom = box.vcenter + h2;
        }
      } else {
        top = box.top;
        bottom = box.bottom;
      }
      if (!(left2 <= right2 && top <= bottom))
        throw new Error(`invalid bbox {left: ${left2}, top: ${top}, right: ${right2}, bottom: ${bottom}}`);
      this.x0 = left2;
      this.y0 = top;
      this.x1 = right2;
      this.y1 = bottom;
    }
  }
  static from_rect({ left: left2, right: right2, top, bottom }) {
    return new BBox$2({
      x0: Math.min(left2, right2),
      y0: Math.min(top, bottom),
      x1: Math.max(left2, right2),
      y1: Math.max(top, bottom)
    });
  }
  equals(that) {
    return this.x0 == that.x0 && this.y0 == that.y0 && this.x1 == that.x1 && this.y1 == that.y1;
  }
  [equals](that, cmp) {
    return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) && cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
  }
  toString() {
    return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
  }
  get left() {
    return this.x0;
  }
  get top() {
    return this.y0;
  }
  get right() {
    return this.x1;
  }
  get bottom() {
    return this.y1;
  }
  get p0() {
    return [this.x0, this.y0];
  }
  get p1() {
    return [this.x1, this.y1];
  }
  get x() {
    return this.x0;
  }
  get y() {
    return this.y0;
  }
  get width() {
    return this.x1 - this.x0;
  }
  get height() {
    return this.y1 - this.y0;
  }
  get size() {
    return { width: this.width, height: this.height };
  }
  get rect() {
    const { x0, y0, x1, y1 } = this;
    return {
      p0: { x: x0, y: y0 },
      p1: { x: x1, y: y0 },
      p2: { x: x1, y: y1 },
      p3: { x: x0, y: y1 }
    };
  }
  get box() {
    const { x: x2, y: y2, width, height } = this;
    return { x: x2, y: y2, width, height };
  }
  get h_range() {
    return { start: this.x0, end: this.x1 };
  }
  get v_range() {
    return { start: this.y0, end: this.y1 };
  }
  get ranges() {
    return [this.h_range, this.v_range];
  }
  get aspect() {
    return this.width / this.height;
  }
  get hcenter() {
    return (this.left + this.right) / 2;
  }
  get vcenter() {
    return (this.top + this.bottom) / 2;
  }
  get area() {
    return this.width * this.height;
  }
  relative() {
    const { width, height } = this;
    return new BBox$2({ x: 0, y: 0, width, height });
  }
  translate(tx, ty) {
    const { x: x2, y: y2, width, height } = this;
    return new BBox$2({ x: tx + x2, y: ty + y2, width, height });
  }
  relativize(x2, y2) {
    return [x2 - this.x, y2 - this.y];
  }
  contains(x2, y2) {
    return this.x0 <= x2 && x2 <= this.x1 && this.y0 <= y2 && y2 <= this.y1;
  }
  clip(x2, y2) {
    if (x2 < this.x0)
      x2 = this.x0;
    else if (x2 > this.x1)
      x2 = this.x1;
    if (y2 < this.y0)
      y2 = this.y0;
    else if (y2 > this.y1)
      y2 = this.y1;
    return [x2, y2];
  }
  grow_by(size2) {
    return new BBox$2({
      left: this.left - size2,
      right: this.right + size2,
      top: this.top - size2,
      bottom: this.bottom + size2
    });
  }
  shrink_by(size2) {
    return new BBox$2({
      left: this.left + size2,
      right: this.right - size2,
      top: this.top + size2,
      bottom: this.bottom - size2
    });
  }
  union(that) {
    return new BBox$2({
      x0: min$5(this.x0, that.x0),
      y0: min$5(this.y0, that.y0),
      x1: max$7(this.x1, that.x1),
      y1: max$7(this.y1, that.y1)
    });
  }
  intersection(that) {
    if (!this.intersects(that))
      return null;
    else {
      return new BBox$2({
        x0: max$7(this.x0, that.x0),
        y0: max$7(this.y0, that.y0),
        x1: min$5(this.x1, that.x1),
        y1: min$5(this.y1, that.y1)
      });
    }
  }
  intersects(that) {
    return !(that.x1 < this.x0 || that.x0 > this.x1 || that.y1 < this.y0 || that.y0 > this.y1);
  }
  get xview() {
    return {
      compute: (x2) => {
        return this.left + x2;
      },
      v_compute: (xx) => {
        const _xx = new ScreenArray(xx.length);
        const left2 = this.left;
        for (let i2 = 0; i2 < xx.length; i2++) {
          _xx[i2] = left2 + xx[i2];
        }
        return _xx;
      }
    };
  }
  get yview() {
    return {
      compute: (y2) => {
        return this.bottom - y2;
      },
      v_compute: (yy) => {
        const _yy = new ScreenArray(yy.length);
        const bottom = this.bottom;
        for (let i2 = 0; i2 < yy.length; i2++) {
          _yy[i2] = bottom - yy[i2];
        }
        return _yy;
      }
    };
  }
}
BBox$2.__name__ = "BBox";
function compute_renderers(renderers, all_renderers, names2) {
  if (renderers == null)
    return [];
  let result = renderers == "auto" ? all_renderers : renderers;
  if (names2.length > 0)
    result = result.filter((r) => includes(names2, r.name));
  return result;
}
var _a$3O;
class DataRange1d extends DataRange {
  constructor(attrs) {
    super(attrs);
    this.have_updated_interactively = false;
  }
  initialize() {
    super.initialize();
    this._initial_start = this.start;
    this._initial_end = this.end;
    this._initial_range_padding = this.range_padding;
    this._initial_range_padding_units = this.range_padding_units;
    this._initial_follow = this.follow;
    this._initial_follow_interval = this.follow_interval;
    this._initial_default_span = this.default_span;
    this._plot_bounds = /* @__PURE__ */ new Map();
  }
  get min() {
    return Math.min(this.start, this.end);
  }
  get max() {
    return Math.max(this.start, this.end);
  }
  computed_renderers() {
    const { renderers, names: names2 } = this;
    const all_renderers = concat$1(this.plots.map((plot) => plot.data_renderers));
    return compute_renderers(renderers.length == 0 ? "auto" : renderers, all_renderers, names2);
  }
  _compute_plot_bounds(renderers, bounds) {
    let result = empty();
    for (const r of renderers) {
      const rect2 = bounds.get(r);
      if (rect2 != null && (r.visible || !this.only_visible)) {
        result = union$1(result, rect2);
      }
    }
    return result;
  }
  adjust_bounds_for_aspect(bounds, ratio) {
    const result = empty();
    let width = bounds.x1 - bounds.x0;
    if (width <= 0) {
      width = 1;
    }
    let height = bounds.y1 - bounds.y0;
    if (height <= 0) {
      height = 1;
    }
    const xcenter = 0.5 * (bounds.x1 + bounds.x0);
    const ycenter = 0.5 * (bounds.y1 + bounds.y0);
    if (width < ratio * height) {
      width = ratio * height;
    } else {
      height = width / ratio;
    }
    result.x1 = xcenter + 0.5 * width;
    result.x0 = xcenter - 0.5 * width;
    result.y1 = ycenter + 0.5 * height;
    result.y0 = ycenter - 0.5 * height;
    return result;
  }
  _compute_min_max(plot_bounds, dimension) {
    let overall = empty();
    for (const [plot, rect2] of plot_bounds) {
      if (plot.visible)
        overall = union$1(overall, rect2);
    }
    let min2, max2;
    if (dimension == 0)
      [min2, max2] = [overall.x0, overall.x1];
    else
      [min2, max2] = [overall.y0, overall.y1];
    return [min2, max2];
  }
  _compute_range(min2, max2) {
    const range_padding = this.range_padding;
    let start2, end;
    if (this._initial_start != null)
      min2 = this._initial_start;
    if (this._initial_end != null)
      max2 = this._initial_end;
    if (this.scale_hint == "log") {
      if (isNaN(min2) || !isFinite(min2) || min2 <= 0) {
        if (isNaN(max2) || !isFinite(max2) || max2 <= 0)
          min2 = 0.1;
        else
          min2 = max2 / 100;
        logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${min2}`);
      }
      if (isNaN(max2) || !isFinite(max2) || max2 <= 0) {
        if (isNaN(min2) || !isFinite(min2) || min2 <= 0)
          max2 = 10;
        else
          max2 = min2 * 100;
        logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${max2}`);
      }
      let center, span2;
      if (max2 == min2) {
        span2 = this.default_span + 1e-3;
        center = Math.log(min2) / Math.log(10);
      } else {
        let log_min, log_max;
        if (this.range_padding_units == "percent") {
          log_min = Math.log(min2) / Math.log(10);
          log_max = Math.log(max2) / Math.log(10);
          span2 = (log_max - log_min) * (1 + range_padding);
        } else {
          log_min = Math.log(min2 - range_padding) / Math.log(10);
          log_max = Math.log(max2 + range_padding) / Math.log(10);
          span2 = log_max - log_min;
        }
        center = (log_min + log_max) / 2;
      }
      start2 = 10 ** (center - span2 / 2);
      end = 10 ** (center + span2 / 2);
    } else {
      let span2;
      if (max2 == min2)
        span2 = this.default_span;
      else {
        if (this.range_padding_units == "percent")
          span2 = (max2 - min2) * (1 + range_padding);
        else
          span2 = max2 - min2 + 2 * range_padding;
      }
      const center = (max2 + min2) / 2;
      start2 = center - span2 / 2;
      end = center + span2 / 2;
    }
    let follow_sign = 1;
    if (this.flipped) {
      [start2, end] = [end, start2];
      follow_sign = -1;
    }
    const follow_interval = this.follow_interval;
    if (follow_interval != null && Math.abs(start2 - end) > follow_interval) {
      if (this.follow == "start")
        end = start2 + follow_sign * follow_interval;
      else if (this.follow == "end")
        start2 = end - follow_sign * follow_interval;
    }
    return [start2, end];
  }
  update(bounds, dimension, plot, ratio) {
    if (this.have_updated_interactively)
      return;
    const renderers = this.computed_renderers();
    let total_bounds = this._compute_plot_bounds(renderers, bounds);
    if (ratio != null)
      total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
    this._plot_bounds.set(plot, total_bounds);
    const [min2, max2] = this._compute_min_max(this._plot_bounds.entries(), dimension);
    let [start2, end] = this._compute_range(min2, max2);
    if (this._initial_start != null) {
      if (this.scale_hint == "log") {
        if (this._initial_start > 0)
          start2 = this._initial_start;
      } else
        start2 = this._initial_start;
    }
    if (this._initial_end != null) {
      if (this.scale_hint == "log") {
        if (this._initial_end > 0)
          end = this._initial_end;
      } else
        end = this._initial_end;
    }
    let needs_emit = false;
    if (this.bounds == "auto") {
      this.setv({ bounds: [start2, end] }, { silent: true });
      needs_emit = true;
    }
    const [_start, _end] = [this.start, this.end];
    if (start2 != _start || end != _end) {
      const new_range = {};
      if (start2 != _start)
        new_range.start = start2;
      if (end != _end)
        new_range.end = end;
      this.setv(new_range);
      needs_emit = false;
    }
    if (needs_emit)
      this.change.emit();
  }
  reset() {
    this.have_updated_interactively = false;
    this.setv({
      range_padding: this._initial_range_padding,
      range_padding_units: this._initial_range_padding_units,
      follow: this._initial_follow,
      follow_interval: this._initial_follow_interval,
      default_span: this._initial_default_span
    }, { silent: true });
    this.change.emit();
  }
}
_a$3O = DataRange1d;
DataRange1d.__name__ = "DataRange1d";
(() => {
  _a$3O.define(({ Boolean: Boolean2, Number: Number2, Nullable: Nullable2 }) => ({
    start: [Number2],
    end: [Number2],
    range_padding: [Number2, 0.1],
    range_padding_units: [PaddingUnits, "percent"],
    flipped: [Boolean2, false],
    follow: [Nullable2(StartEnd), null],
    follow_interval: [Nullable2(Number2), null],
    default_span: [Number2, 2],
    only_visible: [Boolean2, false]
  }));
  _a$3O.internal(({ Enum: Enum2 }) => ({
    scale_hint: [Enum2("log", "auto"), "auto"]
  }));
})();
var _a$3N;
Or(String$2, Tuple(String$2, String$2), Tuple(String$2, String$2, String$2));
const FactorSeq = Or(Array$2(String$2), Array$2(Tuple(String$2, String$2)), Array$2(Tuple(String$2, String$2, String$2)));
function map_one_level(factors, padding, offset2 = 0) {
  const mapping = /* @__PURE__ */ new Map();
  for (let i2 = 0; i2 < factors.length; i2++) {
    const factor = factors[i2];
    if (!mapping.has(factor))
      mapping.set(factor, { value: 0.5 + i2 * (1 + padding) + offset2 });
    else
      throw new Error(`duplicate factor or subfactor: ${factor}`);
  }
  return [mapping, (factors.length - 1) * padding];
}
function map_two_levels(factors, outer_pad, factor_pad, offset2 = 0) {
  var _a2;
  const mapping = /* @__PURE__ */ new Map();
  const tops = /* @__PURE__ */ new Map();
  for (const [f0, f1] of factors) {
    const top = (_a2 = tops.get(f0)) != null ? _a2 : [];
    tops.set(f0, [...top, f1]);
  }
  let suboffset = offset2;
  let total_subpad = 0;
  for (const [f0, top] of tops) {
    const n2 = top.length;
    const [submap, subpad] = map_one_level(top, factor_pad, suboffset);
    total_subpad += subpad;
    const subtot = sum$2(top.map((f1) => submap.get(f1).value));
    mapping.set(f0, { value: subtot / n2, mapping: submap });
    suboffset += n2 + outer_pad + subpad;
  }
  return [mapping, (tops.size - 1) * outer_pad + total_subpad];
}
function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset2 = 0) {
  var _a2;
  const mapping = /* @__PURE__ */ new Map();
  const tops = /* @__PURE__ */ new Map();
  for (const [f0, f1, f2] of factors) {
    const top = (_a2 = tops.get(f0)) != null ? _a2 : [];
    tops.set(f0, [...top, [f1, f2]]);
  }
  let suboffset = offset2;
  let total_subpad = 0;
  for (const [f0, top] of tops) {
    const n2 = top.length;
    const [submap, subpad] = map_two_levels(top, inner_pad, factor_pad, suboffset);
    total_subpad += subpad;
    const subtot = sum$2(top.map(([f1]) => submap.get(f1).value));
    mapping.set(f0, { value: subtot / n2, mapping: submap });
    suboffset += n2 + outer_pad + subpad;
  }
  return [mapping, (tops.size - 1) * outer_pad + total_subpad];
}
class FactorRange extends Range$1 {
  constructor(attrs) {
    super(attrs);
  }
  get min() {
    return this.start;
  }
  get max() {
    return this.end;
  }
  initialize() {
    super.initialize();
    this._init(true);
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.properties.factors.change, () => this.reset());
    this.connect(this.properties.factor_padding.change, () => this.reset());
    this.connect(this.properties.group_padding.change, () => this.reset());
    this.connect(this.properties.subgroup_padding.change, () => this.reset());
    this.connect(this.properties.range_padding.change, () => this.reset());
    this.connect(this.properties.range_padding_units.change, () => this.reset());
  }
  reset() {
    this._init(false);
    this.change.emit();
  }
  _lookup(x2) {
    switch (x2.length) {
      case 1: {
        const [f0] = x2;
        const mapping = this._mapping;
        const y0 = mapping.get(f0);
        return y0 != null ? y0.value : NaN;
      }
      case 2: {
        const [f0, f1] = x2;
        const mapping = this._mapping;
        const y0 = mapping.get(f0);
        if (y0 != null) {
          const y1 = y0.mapping.get(f1);
          if (y1 != null)
            return y1.value;
        }
        return NaN;
      }
      case 3: {
        const [f0, f1, f2] = x2;
        const mapping = this._mapping;
        const y0 = mapping.get(f0);
        if (y0 != null) {
          const y1 = y0.mapping.get(f1);
          if (y1 != null) {
            const y2 = y1.mapping.get(f2);
            if (y2 != null)
              return y2.value;
          }
        }
        return NaN;
      }
      default:
        unreachable();
    }
  }
  synthetic(x2) {
    if (isNumber(x2))
      return x2;
    if (isString(x2))
      return this._lookup([x2]);
    let offset2 = 0;
    const off = x2[x2.length - 1];
    if (isNumber(off)) {
      offset2 = off;
      x2 = x2.slice(0, -1);
    }
    return this._lookup(x2) + offset2;
  }
  v_synthetic(xs) {
    const n2 = xs.length;
    const array = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      array[i2] = this.synthetic(xs[i2]);
    }
    return array;
  }
  _init(silent) {
    const { levels, mapping, tops, mids, inside_padding } = (() => {
      if (every(this.factors, isString)) {
        const factors = this.factors;
        const [mapping2, inside_padding2] = map_one_level(factors, this.factor_padding);
        const tops2 = null;
        const mids2 = null;
        return { levels: 1, mapping: mapping2, tops: tops2, mids: mids2, inside_padding: inside_padding2 };
      } else if (every(this.factors, (x2) => isArray(x2) && x2.length == 2 && isString(x2[0]) && isString(x2[1]))) {
        const factors = this.factors;
        const [mapping2, inside_padding2] = map_two_levels(factors, this.group_padding, this.factor_padding);
        const tops2 = [...mapping2.keys()];
        const mids2 = null;
        return { levels: 2, mapping: mapping2, tops: tops2, mids: mids2, inside_padding: inside_padding2 };
      } else if (every(this.factors, (x2) => isArray(x2) && x2.length == 3 && isString(x2[0]) && isString(x2[1]) && isString(x2[2]))) {
        const factors = this.factors;
        const [mapping2, inside_padding2] = map_three_levels(factors, this.group_padding, this.subgroup_padding, this.factor_padding);
        const tops2 = [...mapping2.keys()];
        const mids2 = [];
        for (const [f0, L2] of mapping2) {
          for (const f1 of L2.mapping.keys()) {
            mids2.push([f0, f1]);
          }
        }
        return { levels: 3, mapping: mapping2, tops: tops2, mids: mids2, inside_padding: inside_padding2 };
      } else
        unreachable();
    })();
    this._mapping = mapping;
    this.tops = tops;
    this.mids = mids;
    let start2 = 0;
    let end = this.factors.length + inside_padding;
    if (this.range_padding_units == "percent") {
      const half_span = (end - start2) * this.range_padding / 2;
      start2 -= half_span;
      end += half_span;
    } else {
      start2 -= this.range_padding;
      end += this.range_padding;
    }
    this.setv({ start: start2, end, levels }, { silent });
    if (this.bounds == "auto")
      this.setv({ bounds: [start2, end] }, { silent: true });
  }
}
_a$3N = FactorRange;
FactorRange.__name__ = "FactorRange";
(() => {
  _a$3N.define(({ Number: Number2 }) => ({
    factors: [FactorSeq, []],
    factor_padding: [Number2, 0],
    subgroup_padding: [Number2, 0.8],
    group_padding: [Number2, 1.4],
    range_padding: [Number2, 0],
    range_padding_units: [PaddingUnits, "percent"],
    start: [Number2],
    end: [Number2]
  }));
  _a$3N.internal(({ Number: Number2, String: String2, Array: Array2, Tuple: Tuple2, Nullable: Nullable2 }) => ({
    levels: [Number2],
    mids: [Nullable2(Array2(Tuple2(String2, String2))), null],
    tops: [Nullable2(Array2(String2)), null]
  }));
})();
var _a$3M, _b$b;
class CoordinateTransform$1 {
  constructor(x_scale, y_scale) {
    this.x_scale = x_scale;
    this.y_scale = y_scale;
    this.x_source = this.x_scale.source_range;
    this.y_source = this.y_scale.source_range;
    this.ranges = [this.x_source, this.y_source];
    this.scales = [this.x_scale, this.y_scale];
  }
  map_to_screen(xs, ys) {
    const sxs = this.x_scale.v_compute(xs);
    const sys = this.y_scale.v_compute(ys);
    return [sxs, sys];
  }
  map_from_screen(sxs, sys) {
    const xs = this.x_scale.v_invert(sxs);
    const ys = this.y_scale.v_invert(sys);
    return [xs, ys];
  }
}
CoordinateTransform$1.__name__ = "CoordinateTransform";
class CoordinateMapping extends Model {
  constructor(attrs) {
    super(attrs);
  }
  get x_ranges() {
    return /* @__PURE__ */ new Map([["default", this.x_source]]);
  }
  get y_ranges() {
    return /* @__PURE__ */ new Map([["default", this.y_source]]);
  }
  _get_scale(range2, scale, target) {
    const factor_range = range2 instanceof FactorRange;
    const categorical_scale = scale instanceof CategoricalScale;
    if (factor_range != categorical_scale) {
      throw new Error(`Range ${range2.type} is incompatible is Scale ${scale.type}`);
    }
    if (scale instanceof LogScale && range2 instanceof DataRange1d)
      range2.scale_hint = "log";
    const derived_scale = scale.clone();
    derived_scale.setv({ source_range: range2, target_range: target });
    return derived_scale;
  }
  get_transform(frame) {
    const { x_source, x_scale, x_target } = this;
    const x_source_scale = this._get_scale(x_source, x_scale, x_target);
    const { y_source, y_scale, y_target } = this;
    const y_source_scale = this._get_scale(y_source, y_scale, y_target);
    const xscale = new CompositeScale({
      source_scale: x_source_scale,
      source_range: x_source_scale.source_range,
      target_scale: frame.x_scale,
      target_range: frame.x_target
    });
    const yscale = new CompositeScale({
      source_scale: y_source_scale,
      source_range: y_source_scale.source_range,
      target_scale: frame.y_scale,
      target_range: frame.y_target
    });
    return new CoordinateTransform$1(xscale, yscale);
  }
}
_a$3M = CoordinateMapping;
CoordinateMapping.__name__ = "CoordinateMapping";
(() => {
  _a$3M.define(({ Ref: Ref2 }) => ({
    x_source: [Ref2(Range$1), () => new DataRange1d()],
    y_source: [Ref2(Range$1), () => new DataRange1d()],
    x_scale: [Ref2(Scale), () => new LinearScale()],
    y_scale: [Ref2(Scale), () => new LinearScale()],
    x_target: [Ref2(Range$1)],
    y_target: [Ref2(Range$1)]
  }));
})();
class CompositeScale extends Scale {
  constructor(attrs) {
    super(attrs);
  }
  get s_compute() {
    const source_compute = this.source_scale.s_compute;
    const target_compute = this.target_scale.s_compute;
    return (x2) => target_compute(source_compute(x2));
  }
  get s_invert() {
    const source_invert = this.source_scale.s_invert;
    const target_invert = this.target_scale.s_invert;
    return (sx) => source_invert(target_invert(sx));
  }
  compute(x2) {
    return this.s_compute(x2);
  }
  v_compute(xs) {
    const { s_compute } = this;
    return map(xs, s_compute);
  }
  invert(sx) {
    return this.s_invert(sx);
  }
  v_invert(sxs) {
    const { s_invert } = this;
    return map(sxs, s_invert);
  }
}
_b$b = CompositeScale;
CompositeScale.__name__ = "CompositeScale";
(() => {
  _b$b.internal(({ Ref: Ref2 }) => ({
    source_scale: [Ref2(Scale)],
    target_scale: [Ref2(Scale)]
  }));
})();
var _a$3L, _b$a;
class RendererGroup extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3L = RendererGroup;
RendererGroup.__name__ = "RendererGroup";
(() => {
  _a$3L.define(({ Boolean: Boolean2 }) => ({
    visible: [Boolean2, true]
  }));
})();
class RendererView extends View {
  get coordinates() {
    const { _coordinates } = this;
    if (_coordinates != null)
      return _coordinates;
    else
      return this._coordinates = this._initialize_coordinates();
  }
  initialize() {
    super.initialize();
    this.visuals = new Visuals(this);
    this.needs_webgl_blit = false;
  }
  connect_signals() {
    super.connect_signals();
    const { x_range_name, y_range_name } = this.model.properties;
    this.on_change([x_range_name, y_range_name], () => this._initialize_coordinates());
    const { group } = this.model;
    if (group != null) {
      this.on_change(group.properties.visible, () => {
        this.model.visible = group.visible;
      });
    }
  }
  _initialize_coordinates() {
    const { coordinates } = this.model;
    const { frame } = this.plot_view;
    if (coordinates != null) {
      return coordinates.get_transform(frame);
    } else {
      const { x_range_name, y_range_name } = this.model;
      const x_scale = frame.x_scales.get(x_range_name);
      const y_scale = frame.y_scales.get(y_range_name);
      return new CoordinateTransform$1(x_scale, y_scale);
    }
  }
  get plot_view() {
    return this.parent;
  }
  get plot_model() {
    return this.parent.model;
  }
  get layer() {
    const { overlays, primary } = this.canvas;
    return this.model.level == "overlay" ? overlays : primary;
  }
  get canvas() {
    return this.plot_view.canvas_view;
  }
  request_render() {
    this.request_paint();
  }
  request_paint() {
    this.plot_view.request_paint(this);
  }
  request_layout() {
    this.plot_view.request_layout();
  }
  notify_finished() {
    this.plot_view.notify_finished();
  }
  notify_finished_after_paint() {
    this.plot_view.notify_finished_after_paint();
  }
  get needs_clip() {
    return false;
  }
  get has_webgl() {
    return false;
  }
  render() {
    if (this.model.visible) {
      this._render();
    }
    this._has_finished = true;
  }
  renderer_view(_renderer) {
    return void 0;
  }
}
RendererView.__name__ = "RendererView";
class Renderer extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_b$a = Renderer;
Renderer.__name__ = "Renderer";
(() => {
  _b$a.define(({ Boolean: Boolean2, String: String2, Ref: Ref2, Nullable: Nullable2 }) => ({
    group: [Nullable2(Ref2(RendererGroup)), null],
    level: [RenderLevel, "image"],
    visible: [Boolean2, true],
    x_range_name: [String2, "default"],
    y_range_name: [String2, "default"],
    coordinates: [Nullable2(Ref2(CoordinateMapping)), null]
  }));
})();
var _a$3K;
class AnnotationView extends RendererView {
  get_size() {
    if (this.model.visible) {
      const { width, height } = this._get_size();
      return { width: Math.round(width), height: Math.round(height) };
    } else
      return { width: 0, height: 0 };
  }
  _get_size() {
    throw new Error("not implemented");
  }
  connect_signals() {
    super.connect_signals();
    const p2 = this.model.properties;
    this.on_change(p2.visible, () => {
      if (this.layout != null) {
        this.layout.visible = this.model.visible;
        this.plot_view.request_layout();
      }
    });
  }
  get needs_clip() {
    return this.layout == null;
  }
  serializable_state() {
    const state = super.serializable_state();
    return this.layout == null ? state : { ...state, bbox: this.layout.bbox.box };
  }
}
AnnotationView.__name__ = "AnnotationView";
class Annotation extends Renderer {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3K = Annotation;
Annotation.__name__ = "Annotation";
(() => {
  _a$3K.override({
    level: "annotation"
  });
})();
var _a$3J;
class Selection extends Model {
  constructor(attrs) {
    super(attrs);
  }
  get_view() {
    return this.view;
  }
  get selected_glyph() {
    return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
  }
  add_to_selected_glyphs(glyph) {
    this.selected_glyphs.push(glyph);
  }
  update(selection, _final = true, mode = "replace") {
    switch (mode) {
      case "replace": {
        this.indices = selection.indices;
        this.line_indices = selection.line_indices;
        this.multiline_indices = selection.multiline_indices;
        this.image_indices = selection.image_indices;
        this.view = selection.view;
        this.selected_glyphs = selection.selected_glyphs;
        break;
      }
      case "append": {
        this.update_through_union(selection);
        break;
      }
      case "intersect": {
        this.update_through_intersection(selection);
        break;
      }
      case "subtract": {
        this.update_through_subtraction(selection);
        break;
      }
    }
  }
  clear() {
    this.indices = [];
    this.line_indices = [];
    this.multiline_indices = {};
    this.image_indices = [];
    this.view = null;
    this.selected_glyphs = [];
  }
  map(mapper) {
    return new Selection({
      ...this.attributes,
      indices: this.indices.map(mapper),
      multiline_indices: to_object(entries(this.multiline_indices).map(([index2, line_indices]) => [mapper(Number(index2)), line_indices])),
      image_indices: this.image_indices.map((ndx) => ({ ...ndx, index: mapper(ndx.index) }))
    });
  }
  is_empty() {
    return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
  }
  update_through_union(other) {
    this.indices = union$2(this.indices, other.indices);
    this.selected_glyphs = union$2(other.selected_glyphs, this.selected_glyphs);
    this.line_indices = union$2(other.line_indices, this.line_indices);
    this.view = other.view;
    this.multiline_indices = merge(other.multiline_indices, this.multiline_indices);
  }
  update_through_intersection(other) {
    this.indices = intersection(this.indices, other.indices);
    this.selected_glyphs = union$2(other.selected_glyphs, this.selected_glyphs);
    this.line_indices = union$2(other.line_indices, this.line_indices);
    this.view = other.view;
    this.multiline_indices = merge(other.multiline_indices, this.multiline_indices);
  }
  update_through_subtraction(other) {
    this.indices = difference$1(this.indices, other.indices);
    this.selected_glyphs = union$2(other.selected_glyphs, this.selected_glyphs);
    this.line_indices = union$2(other.line_indices, this.line_indices);
    this.view = other.view;
    this.multiline_indices = merge(other.multiline_indices, this.multiline_indices);
  }
}
_a$3J = Selection;
Selection.__name__ = "Selection";
(() => {
  _a$3J.define(({ Int: Int2, Array: Array2, Dict: Dict2 }) => ({
    indices: [Array2(Int2), []],
    line_indices: [Array2(Int2), []],
    multiline_indices: [Dict2(Array2(Int2)), {}]
  }));
  _a$3J.internal(({ Int: Int2, Array: Array2, AnyRef: AnyRef2, Struct: Struct2, Nullable: Nullable2 }) => ({
    selected_glyphs: [Array2(AnyRef2()), []],
    view: [Nullable2(AnyRef2()), null],
    image_indices: [Array2(Struct2({ index: Int2, dim1: Int2, dim2: Int2, flat_index: Int2 })), []]
  }));
})();
var _a$3I;
class DataSource extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3I = DataSource;
DataSource.__name__ = "DataSource";
(() => {
  _a$3I.define(({ Ref: Ref2 }) => ({
    selected: [Ref2(Selection), () => new Selection()]
  }));
})();
function is_GlyphRendererView(renderer_view) {
  return renderer_view.model.type == "GlyphRenderer";
}
function is_GraphRendererView(renderer_view) {
  return renderer_view.model.type == "GraphRenderer";
}
class SelectionManager {
  constructor(source) {
    this.source = source;
    this.inspectors = /* @__PURE__ */ new Map();
  }
  select(renderer_views, geometry, final, mode = "replace") {
    const glyph_renderer_views = [];
    const graph_renderer_views = [];
    for (const r of renderer_views) {
      if (is_GlyphRendererView(r))
        glyph_renderer_views.push(r);
      else if (is_GraphRendererView(r))
        graph_renderer_views.push(r);
    }
    let did_hit = false;
    for (const r of graph_renderer_views) {
      const hit_test_result = r.model.selection_policy.hit_test(geometry, r);
      did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
    }
    if (glyph_renderer_views.length > 0) {
      const hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
      did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
    }
    return did_hit;
  }
  inspect(renderer_view, geometry) {
    let did_hit = false;
    if (is_GlyphRendererView(renderer_view)) {
      const hit_test_result = renderer_view.hit_test(geometry);
      if (hit_test_result != null) {
        did_hit = !hit_test_result.is_empty();
        const inspection = this.get_or_create_inspector(renderer_view.model);
        inspection.update(hit_test_result, true, "replace");
        this.source.setv({ inspected: inspection }, { silent: true });
        this.source.inspect.emit([renderer_view.model, { geometry }]);
      }
    } else if (is_GraphRendererView(renderer_view)) {
      const hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
      did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
    }
    return did_hit;
  }
  clear(rview) {
    this.source.selected.clear();
    if (rview != null)
      this.get_or_create_inspector(rview.model).clear();
  }
  get_or_create_inspector(renderer) {
    let selection = this.inspectors.get(renderer);
    if (selection == null) {
      selection = new Selection();
      this.inspectors.set(renderer, selection);
    }
    return selection;
  }
}
SelectionManager.__name__ = "SelectionManager";
class SelectionPolicy extends Model {
  do_selection(hit_test_result, source, final, mode) {
    if (hit_test_result == null) {
      return false;
    } else {
      source.selected.update(hit_test_result, final, mode);
      source._select.emit();
      return !source.selected.is_empty();
    }
  }
}
SelectionPolicy.__name__ = "SelectionPolicy";
class IntersectRenderers extends SelectionPolicy {
  hit_test(geometry, renderer_views) {
    const hit_test_result_renderers = [];
    for (const r of renderer_views) {
      const result = r.hit_test(geometry);
      if (result != null)
        hit_test_result_renderers.push(result);
    }
    if (hit_test_result_renderers.length > 0) {
      const hit_test_result = hit_test_result_renderers[0];
      for (const hit_test_result_other of hit_test_result_renderers) {
        hit_test_result.update_through_intersection(hit_test_result_other);
      }
      return hit_test_result;
    } else {
      return null;
    }
  }
}
IntersectRenderers.__name__ = "IntersectRenderers";
class UnionRenderers extends SelectionPolicy {
  hit_test(geometry, renderer_views) {
    const hit_test_result_renderers = [];
    for (const r of renderer_views) {
      const result = r.hit_test(geometry);
      if (result != null)
        hit_test_result_renderers.push(result);
    }
    if (hit_test_result_renderers.length > 0) {
      const hit_test_result = hit_test_result_renderers[0];
      for (const hit_test_result_other of hit_test_result_renderers) {
        hit_test_result.update_through_union(hit_test_result_other);
      }
      return hit_test_result;
    } else {
      return null;
    }
  }
}
UnionRenderers.__name__ = "UnionRenderers";
var _a$3H;
class ColumnarDataSource extends DataSource {
  constructor(attrs) {
    super(attrs);
    this.selection_manager = new SelectionManager(this);
  }
  get_array(key) {
    let column = this.data[key];
    if (column == null)
      this.data[key] = column = [];
    else if (!isArray(column))
      this.data[key] = column = Array.from(column);
    return column;
  }
  initialize() {
    super.initialize();
    this._select = new Signal0(this, "select");
    this.inspect = new Signal(this, "inspect");
    this.streaming = new Signal0(this, "streaming");
    this.patching = new Signal(this, "patching");
  }
  get_column(colname) {
    const column = this.data[colname];
    return column != null ? column : null;
  }
  columns() {
    return keys(this.data);
  }
  get_length(soft = true) {
    const lengths2 = uniq(values(this.data).map((v) => is_NDArray(v) ? v.shape[0] : v.length));
    switch (lengths2.length) {
      case 0: {
        return null;
      }
      case 1: {
        return lengths2[0];
      }
      default: {
        const msg = "data source has columns of inconsistent lengths";
        if (soft) {
          logger.warn(msg);
          return lengths2.sort()[0];
        } else
          throw new Error(msg);
      }
    }
  }
  get length() {
    var _a2;
    return (_a2 = this.get_length()) != null ? _a2 : 0;
  }
  clear() {
    const empty2 = {};
    for (const col of this.columns()) {
      empty2[col] = new this.data[col].constructor(0);
    }
    this.data = empty2;
  }
}
_a$3H = ColumnarDataSource;
ColumnarDataSource.__name__ = "ColumnarDataSource";
(() => {
  _a$3H.define(({ Ref: Ref2 }) => ({
    selection_policy: [Ref2(SelectionPolicy), () => new UnionRenderers()]
  }));
  _a$3H.internal(({ AnyRef: AnyRef2 }) => ({
    inspected: [AnyRef2(), () => new Selection()]
  }));
})();
function concat(array0, ...arrays) {
  let n2 = array0.length;
  for (const array of arrays)
    n2 += array.length;
  const result = new array0.constructor(n2);
  result.set(array0, 0);
  let i2 = array0.length;
  for (const array of arrays) {
    result.set(array, i2);
    i2 += array.length;
  }
  return result;
}
function union(...sets) {
  const result = /* @__PURE__ */ new Set();
  for (const set of sets) {
    for (const item of set) {
      result.add(item);
    }
  }
  return result;
}
function difference(set, ...sets) {
  const result = new Set(set);
  for (const item of union(...sets)) {
    result.delete(item);
  }
  return result;
}
var _a$3G;
function stream_to_column(col, new_col, rollover) {
  if (isArray(col)) {
    const result = col.concat(new_col);
    if (rollover != null && result.length > rollover)
      return result.slice(-rollover);
    else
      return result;
  } else if (isTypedArray(col)) {
    const total_len = col.length + new_col.length;
    if (rollover != null && total_len > rollover) {
      const start2 = total_len - rollover;
      const end = col.length;
      let result;
      if (col.length < rollover) {
        result = new col.constructor(rollover);
        result.set(col, 0);
      } else
        result = col;
      for (let i2 = start2, endi = end; i2 < endi; i2++) {
        result[i2 - start2] = result[i2];
      }
      for (let i2 = 0, endi = new_col.length; i2 < endi; i2++) {
        result[i2 + (end - start2)] = new_col[i2];
      }
      return result;
    } else {
      const tmp = new col.constructor(new_col);
      return concat(col, tmp);
    }
  } else
    throw new Error("unsupported array types");
}
function slice$1(ind, length) {
  let start2, step, stop;
  if (isNumber(ind)) {
    start2 = ind;
    stop = ind + 1;
    step = 1;
  } else {
    start2 = ind.start != null ? ind.start : 0;
    stop = ind.stop != null ? ind.stop : length;
    step = ind.step != null ? ind.step : 1;
  }
  return [start2, stop, step];
}
function patch_to_column(col, patch) {
  const patched = /* @__PURE__ */ new Set();
  let patched_range = false;
  for (const [ind, val] of patch) {
    let shape;
    let item;
    let index2;
    let value;
    if (isArray(ind)) {
      const [i2] = ind;
      patched.add(i2);
      shape = col[i2].shape;
      item = col[i2];
      value = val;
      if (ind.length === 2) {
        shape = [1, shape[0]];
        index2 = [ind[0], 0, ind[1]];
      } else
        index2 = ind;
    } else {
      if (isNumber(ind)) {
        value = [val];
        patched.add(ind);
      } else {
        value = val;
        patched_range = true;
      }
      index2 = [0, 0, ind];
      shape = [1, col.length];
      item = col;
    }
    let flat_index = 0;
    const [istart, istop, istep] = slice$1(index2[1], shape[0]);
    const [jstart, jstop, jstep] = slice$1(index2[2], shape[1]);
    for (let i2 = istart; i2 < istop; i2 += istep) {
      for (let j = jstart; j < jstop; j += jstep) {
        if (patched_range) {
          patched.add(j);
        }
        item[i2 * shape[1] + j] = value[flat_index];
        flat_index++;
      }
    }
  }
  return patched;
}
class ColumnDataSource extends ColumnarDataSource {
  constructor(attrs) {
    super(attrs);
  }
  stream(new_data, rollover, setter_id) {
    const { data: data2 } = this;
    for (const [name, new_column] of entries(new_data)) {
      data2[name] = stream_to_column(data2[name], new_column, rollover);
    }
    this.setv({ data: data2 }, { silent: true });
    this.streaming.emit();
    if (this.document != null) {
      const hint = new ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
      this.document._notify_change(this, "data", null, null, { setter_id, hint });
    }
  }
  patch(patches, setter_id) {
    const { data: data2 } = this;
    let patched = /* @__PURE__ */ new Set();
    for (const [column, patch] of entries(patches)) {
      patched = union(patched, patch_to_column(data2[column], patch));
    }
    this.setv({ data: data2 }, { silent: true });
    this.patching.emit([...patched]);
    if (this.document != null) {
      const hint = new ColumnsPatchedEvent(this.document, this.ref(), patches);
      this.document._notify_change(this, "data", null, null, { setter_id, hint });
    }
  }
}
_a$3G = ColumnDataSource;
ColumnDataSource.__name__ = "ColumnDataSource";
(() => {
  _a$3G.define(({ Dict: Dict2, Any: Any2 }) => ({
    data: [Dict2(Any2), {}]
  }));
})();
function globals(defs2) {
  defs2("EPSG:4326", "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
  defs2("EPSG:4269", "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
  defs2("EPSG:3857", "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
  defs2.WGS84 = defs2["EPSG:4326"];
  defs2["EPSG:3785"] = defs2["EPSG:3857"];
  defs2.GOOGLE = defs2["EPSG:3857"];
  defs2["EPSG:900913"] = defs2["EPSG:3857"];
  defs2["EPSG:102113"] = defs2["EPSG:3857"];
}
var PJD_3PARAM = 1;
var PJD_7PARAM = 2;
var PJD_GRIDSHIFT = 3;
var PJD_WGS84 = 4;
var PJD_NODATUM = 5;
var SRS_WGS84_SEMIMAJOR = 6378137;
var SRS_WGS84_SEMIMINOR = 6356752314e-3;
var SRS_WGS84_ESQUARED = 0.0066943799901413165;
var SEC_TO_RAD = 484813681109536e-20;
var HALF_PI = Math.PI / 2;
var SIXTH = 0.16666666666666666;
var RA4 = 0.04722222222222222;
var RA6 = 0.022156084656084655;
var EPSLN = 1e-10;
var D2R$1 = 0.017453292519943295;
var R2D = 57.29577951308232;
var FORTPI = Math.PI / 4;
var TWO_PI = Math.PI * 2;
var SPI = 3.14159265359;
var exports$2 = {};
exports$2.greenwich = 0;
exports$2.lisbon = -9.131906111111;
exports$2.paris = 2.337229166667;
exports$2.bogota = -74.080916666667;
exports$2.madrid = -3.687938888889;
exports$2.rome = 12.452333333333;
exports$2.bern = 7.439583333333;
exports$2.jakarta = 106.807719444444;
exports$2.ferro = -17.666666666667;
exports$2.brussels = 4.367975;
exports$2.stockholm = 18.058277777778;
exports$2.athens = 23.7163375;
exports$2.oslo = 10.722916666667;
var units = {
  ft: { to_meter: 0.3048 },
  "us-ft": { to_meter: 1200 / 3937 }
};
var ignoredChar = /[\s_\-\/\(\)]/g;
function match(obj, key) {
  if (obj[key]) {
    return obj[key];
  }
  var keys2 = Object.keys(obj);
  var lkey = key.toLowerCase().replace(ignoredChar, "");
  var i2 = -1;
  var testkey, processedKey;
  while (++i2 < keys2.length) {
    testkey = keys2[i2];
    processedKey = testkey.toLowerCase().replace(ignoredChar, "");
    if (processedKey === lkey) {
      return obj[testkey];
    }
  }
}
function projStr(defData) {
  var self2 = {};
  var paramObj = defData.split("+").map(function(v) {
    return v.trim();
  }).filter(function(a2) {
    return a2;
  }).reduce(function(p2, a2) {
    var split2 = a2.split("=");
    split2.push(true);
    p2[split2[0].toLowerCase()] = split2[1];
    return p2;
  }, {});
  var paramName, paramVal, paramOutname;
  var params = {
    proj: "projName",
    datum: "datumCode",
    rf: function(v) {
      self2.rf = parseFloat(v);
    },
    lat_0: function(v) {
      self2.lat0 = v * D2R$1;
    },
    lat_1: function(v) {
      self2.lat1 = v * D2R$1;
    },
    lat_2: function(v) {
      self2.lat2 = v * D2R$1;
    },
    lat_ts: function(v) {
      self2.lat_ts = v * D2R$1;
    },
    lon_0: function(v) {
      self2.long0 = v * D2R$1;
    },
    lon_1: function(v) {
      self2.long1 = v * D2R$1;
    },
    lon_2: function(v) {
      self2.long2 = v * D2R$1;
    },
    alpha: function(v) {
      self2.alpha = parseFloat(v) * D2R$1;
    },
    gamma: function(v) {
      self2.rectified_grid_angle = parseFloat(v);
    },
    lonc: function(v) {
      self2.longc = v * D2R$1;
    },
    x_0: function(v) {
      self2.x0 = parseFloat(v);
    },
    y_0: function(v) {
      self2.y0 = parseFloat(v);
    },
    k_0: function(v) {
      self2.k0 = parseFloat(v);
    },
    k: function(v) {
      self2.k0 = parseFloat(v);
    },
    a: function(v) {
      self2.a = parseFloat(v);
    },
    b: function(v) {
      self2.b = parseFloat(v);
    },
    r_a: function() {
      self2.R_A = true;
    },
    zone: function(v) {
      self2.zone = parseInt(v, 10);
    },
    south: function() {
      self2.utmSouth = true;
    },
    towgs84: function(v) {
      self2.datum_params = v.split(",").map(function(a2) {
        return parseFloat(a2);
      });
    },
    to_meter: function(v) {
      self2.to_meter = parseFloat(v);
    },
    units: function(v) {
      self2.units = v;
      var unit = match(units, v);
      if (unit) {
        self2.to_meter = unit.to_meter;
      }
    },
    from_greenwich: function(v) {
      self2.from_greenwich = v * D2R$1;
    },
    pm: function(v) {
      var pm = match(exports$2, v);
      self2.from_greenwich = (pm ? pm : parseFloat(v)) * D2R$1;
    },
    nadgrids: function(v) {
      if (v === "@null") {
        self2.datumCode = "none";
      } else {
        self2.nadgrids = v;
      }
    },
    axis: function(v) {
      var legalAxis = "ewnsud";
      if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
        self2.axis = v;
      }
    },
    approx: function() {
      self2.approx = true;
    }
  };
  for (paramName in paramObj) {
    paramVal = paramObj[paramName];
    if (paramName in params) {
      paramOutname = params[paramName];
      if (typeof paramOutname === "function") {
        paramOutname(paramVal);
      } else {
        self2[paramOutname] = paramVal;
      }
    } else {
      self2[paramName] = paramVal;
    }
  }
  if (typeof self2.datumCode === "string" && self2.datumCode !== "WGS84") {
    self2.datumCode = self2.datumCode.toLowerCase();
  }
  return self2;
}
var NEUTRAL = 1;
var KEYWORD = 2;
var NUMBER = 3;
var QUOTED = 4;
var AFTERQUOTE = 5;
var ENDED = -1;
var whitespace = /\s/;
var latin = /[A-Za-z]/;
var keyword = /[A-Za-z84_]/;
var endThings = /[,\]]/;
var digets = /[\d\.E\-\+]/;
function Parser(text) {
  if (typeof text !== "string") {
    throw new Error("not a string");
  }
  this.text = text.trim();
  this.level = 0;
  this.place = 0;
  this.root = null;
  this.stack = [];
  this.currentObject = null;
  this.state = NEUTRAL;
}
Parser.prototype.readCharicter = function() {
  var char = this.text[this.place++];
  if (this.state !== QUOTED) {
    while (whitespace.test(char)) {
      if (this.place >= this.text.length) {
        return;
      }
      char = this.text[this.place++];
    }
  }
  switch (this.state) {
    case NEUTRAL:
      return this.neutral(char);
    case KEYWORD:
      return this.keyword(char);
    case QUOTED:
      return this.quoted(char);
    case AFTERQUOTE:
      return this.afterquote(char);
    case NUMBER:
      return this.number(char);
    case ENDED:
      return;
  }
};
Parser.prototype.afterquote = function(char) {
  if (char === '"') {
    this.word += '"';
    this.state = QUOTED;
    return;
  }
  if (endThings.test(char)) {
    this.word = this.word.trim();
    this.afterItem(char);
    return;
  }
  throw new Error(`havn't handled "` + char + '" in afterquote yet, index ' + this.place);
};
Parser.prototype.afterItem = function(char) {
  if (char === ",") {
    if (this.word !== null) {
      this.currentObject.push(this.word);
    }
    this.word = null;
    this.state = NEUTRAL;
    return;
  }
  if (char === "]") {
    this.level--;
    if (this.word !== null) {
      this.currentObject.push(this.word);
      this.word = null;
    }
    this.state = NEUTRAL;
    this.currentObject = this.stack.pop();
    if (!this.currentObject) {
      this.state = ENDED;
    }
    return;
  }
};
Parser.prototype.number = function(char) {
  if (digets.test(char)) {
    this.word += char;
    return;
  }
  if (endThings.test(char)) {
    this.word = parseFloat(this.word);
    this.afterItem(char);
    return;
  }
  throw new Error(`havn't handled "` + char + '" in number yet, index ' + this.place);
};
Parser.prototype.quoted = function(char) {
  if (char === '"') {
    this.state = AFTERQUOTE;
    return;
  }
  this.word += char;
  return;
};
Parser.prototype.keyword = function(char) {
  if (keyword.test(char)) {
    this.word += char;
    return;
  }
  if (char === "[") {
    var newObjects = [];
    newObjects.push(this.word);
    this.level++;
    if (this.root === null) {
      this.root = newObjects;
    } else {
      this.currentObject.push(newObjects);
    }
    this.stack.push(this.currentObject);
    this.currentObject = newObjects;
    this.state = NEUTRAL;
    return;
  }
  if (endThings.test(char)) {
    this.afterItem(char);
    return;
  }
  throw new Error(`havn't handled "` + char + '" in keyword yet, index ' + this.place);
};
Parser.prototype.neutral = function(char) {
  if (latin.test(char)) {
    this.word = char;
    this.state = KEYWORD;
    return;
  }
  if (char === '"') {
    this.word = "";
    this.state = QUOTED;
    return;
  }
  if (digets.test(char)) {
    this.word = char;
    this.state = NUMBER;
    return;
  }
  if (endThings.test(char)) {
    this.afterItem(char);
    return;
  }
  throw new Error(`havn't handled "` + char + '" in neutral yet, index ' + this.place);
};
Parser.prototype.output = function() {
  while (this.place < this.text.length) {
    this.readCharicter();
  }
  if (this.state === ENDED) {
    return this.root;
  }
  throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
};
function parseString(txt) {
  var parser = new Parser(txt);
  return parser.output();
}
function mapit(obj, key, value) {
  if (Array.isArray(key)) {
    value.unshift(key);
    key = null;
  }
  var thing = key ? {} : obj;
  var out = value.reduce(function(newObj, item) {
    sExpr(item, newObj);
    return newObj;
  }, thing);
  if (key) {
    obj[key] = out;
  }
}
function sExpr(v, obj) {
  if (!Array.isArray(v)) {
    obj[v] = true;
    return;
  }
  var key = v.shift();
  if (key === "PARAMETER") {
    key = v.shift();
  }
  if (v.length === 1) {
    if (Array.isArray(v[0])) {
      obj[key] = {};
      sExpr(v[0], obj[key]);
      return;
    }
    obj[key] = v[0];
    return;
  }
  if (!v.length) {
    obj[key] = true;
    return;
  }
  if (key === "TOWGS84") {
    obj[key] = v;
    return;
  }
  if (key === "AXIS") {
    if (!(key in obj)) {
      obj[key] = [];
    }
    obj[key].push(v);
    return;
  }
  if (!Array.isArray(key)) {
    obj[key] = {};
  }
  var i2;
  switch (key) {
    case "UNIT":
    case "PRIMEM":
    case "VERT_DATUM":
      obj[key] = {
        name: v[0].toLowerCase(),
        convert: v[1]
      };
      if (v.length === 3) {
        sExpr(v[2], obj[key]);
      }
      return;
    case "SPHEROID":
    case "ELLIPSOID":
      obj[key] = {
        name: v[0],
        a: v[1],
        rf: v[2]
      };
      if (v.length === 4) {
        sExpr(v[3], obj[key]);
      }
      return;
    case "PROJECTEDCRS":
    case "PROJCRS":
    case "GEOGCS":
    case "GEOCCS":
    case "PROJCS":
    case "LOCAL_CS":
    case "GEODCRS":
    case "GEODETICCRS":
    case "GEODETICDATUM":
    case "EDATUM":
    case "ENGINEERINGDATUM":
    case "VERT_CS":
    case "VERTCRS":
    case "VERTICALCRS":
    case "COMPD_CS":
    case "COMPOUNDCRS":
    case "ENGINEERINGCRS":
    case "ENGCRS":
    case "FITTED_CS":
    case "LOCAL_DATUM":
    case "DATUM":
      v[0] = ["name", v[0]];
      mapit(obj, key, v);
      return;
    default:
      i2 = -1;
      while (++i2 < v.length) {
        if (!Array.isArray(v[i2])) {
          return sExpr(v, obj[key]);
        }
      }
      return mapit(obj, key, v);
  }
}
var D2R = 0.017453292519943295;
function rename(obj, params) {
  var outName = params[0];
  var inName = params[1];
  if (!(outName in obj) && inName in obj) {
    obj[outName] = obj[inName];
    if (params.length === 3) {
      obj[outName] = params[2](obj[outName]);
    }
  }
}
function d2r(input2) {
  return input2 * D2R;
}
function cleanWKT(wkt2) {
  if (wkt2.type === "GEOGCS") {
    wkt2.projName = "longlat";
  } else if (wkt2.type === "LOCAL_CS") {
    wkt2.projName = "identity";
    wkt2.local = true;
  } else {
    if (typeof wkt2.PROJECTION === "object") {
      wkt2.projName = Object.keys(wkt2.PROJECTION)[0];
    } else {
      wkt2.projName = wkt2.PROJECTION;
    }
  }
  if (wkt2.AXIS) {
    var axisOrder = "";
    for (var i2 = 0, ii = wkt2.AXIS.length; i2 < ii; ++i2) {
      var axis = [wkt2.AXIS[i2][0].toLowerCase(), wkt2.AXIS[i2][1].toLowerCase()];
      if (axis[0].indexOf("north") !== -1 || (axis[0] === "y" || axis[0] === "lat") && axis[1] === "north") {
        axisOrder += "n";
      } else if (axis[0].indexOf("south") !== -1 || (axis[0] === "y" || axis[0] === "lat") && axis[1] === "south") {
        axisOrder += "s";
      } else if (axis[0].indexOf("east") !== -1 || (axis[0] === "x" || axis[0] === "lon") && axis[1] === "east") {
        axisOrder += "e";
      } else if (axis[0].indexOf("west") !== -1 || (axis[0] === "x" || axis[0] === "lon") && axis[1] === "west") {
        axisOrder += "w";
      }
    }
    if (axisOrder.length === 2) {
      axisOrder += "u";
    }
    if (axisOrder.length === 3) {
      wkt2.axis = axisOrder;
    }
  }
  if (wkt2.UNIT) {
    wkt2.units = wkt2.UNIT.name.toLowerCase();
    if (wkt2.units === "metre") {
      wkt2.units = "meter";
    }
    if (wkt2.UNIT.convert) {
      if (wkt2.type === "GEOGCS") {
        if (wkt2.DATUM && wkt2.DATUM.SPHEROID) {
          wkt2.to_meter = wkt2.UNIT.convert * wkt2.DATUM.SPHEROID.a;
        }
      } else {
        wkt2.to_meter = wkt2.UNIT.convert;
      }
    }
  }
  var geogcs = wkt2.GEOGCS;
  if (wkt2.type === "GEOGCS") {
    geogcs = wkt2;
  }
  if (geogcs) {
    if (geogcs.DATUM) {
      wkt2.datumCode = geogcs.DATUM.name.toLowerCase();
    } else {
      wkt2.datumCode = geogcs.name.toLowerCase();
    }
    if (wkt2.datumCode.slice(0, 2) === "d_") {
      wkt2.datumCode = wkt2.datumCode.slice(2);
    }
    if (wkt2.datumCode === "new_zealand_geodetic_datum_1949" || wkt2.datumCode === "new_zealand_1949") {
      wkt2.datumCode = "nzgd49";
    }
    if (wkt2.datumCode === "wgs_1984" || wkt2.datumCode === "world_geodetic_system_1984") {
      if (wkt2.PROJECTION === "Mercator_Auxiliary_Sphere") {
        wkt2.sphere = true;
      }
      wkt2.datumCode = "wgs84";
    }
    if (wkt2.datumCode.slice(-6) === "_ferro") {
      wkt2.datumCode = wkt2.datumCode.slice(0, -6);
    }
    if (wkt2.datumCode.slice(-8) === "_jakarta") {
      wkt2.datumCode = wkt2.datumCode.slice(0, -8);
    }
    if (~wkt2.datumCode.indexOf("belge")) {
      wkt2.datumCode = "rnb72";
    }
    if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
      wkt2.ellps = geogcs.DATUM.SPHEROID.name.replace("_19", "").replace(/[Cc]larke\_18/, "clrk");
      if (wkt2.ellps.toLowerCase().slice(0, 13) === "international") {
        wkt2.ellps = "intl";
      }
      wkt2.a = geogcs.DATUM.SPHEROID.a;
      wkt2.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
    }
    if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
      wkt2.datum_params = geogcs.DATUM.TOWGS84;
    }
    if (~wkt2.datumCode.indexOf("osgb_1936")) {
      wkt2.datumCode = "osgb36";
    }
    if (~wkt2.datumCode.indexOf("osni_1952")) {
      wkt2.datumCode = "osni52";
    }
    if (~wkt2.datumCode.indexOf("tm65") || ~wkt2.datumCode.indexOf("geodetic_datum_of_1965")) {
      wkt2.datumCode = "ire65";
    }
    if (wkt2.datumCode === "ch1903+") {
      wkt2.datumCode = "ch1903";
    }
    if (~wkt2.datumCode.indexOf("israel")) {
      wkt2.datumCode = "isr93";
    }
  }
  if (wkt2.b && !isFinite(wkt2.b)) {
    wkt2.b = wkt2.a;
  }
  function toMeter(input2) {
    var ratio = wkt2.to_meter || 1;
    return input2 * ratio;
  }
  var renamer = function(a2) {
    return rename(wkt2, a2);
  };
  var list = [
    ["standard_parallel_1", "Standard_Parallel_1"],
    ["standard_parallel_1", "Latitude of 1st standard parallel"],
    ["standard_parallel_2", "Standard_Parallel_2"],
    ["standard_parallel_2", "Latitude of 2nd standard parallel"],
    ["false_easting", "False_Easting"],
    ["false_easting", "False easting"],
    ["false-easting", "Easting at false origin"],
    ["false_northing", "False_Northing"],
    ["false_northing", "False northing"],
    ["false_northing", "Northing at false origin"],
    ["central_meridian", "Central_Meridian"],
    ["central_meridian", "Longitude of natural origin"],
    ["central_meridian", "Longitude of false origin"],
    ["latitude_of_origin", "Latitude_Of_Origin"],
    ["latitude_of_origin", "Central_Parallel"],
    ["latitude_of_origin", "Latitude of natural origin"],
    ["latitude_of_origin", "Latitude of false origin"],
    ["scale_factor", "Scale_Factor"],
    ["k0", "scale_factor"],
    ["latitude_of_center", "Latitude_Of_Center"],
    ["latitude_of_center", "Latitude_of_center"],
    ["lat0", "latitude_of_center", d2r],
    ["longitude_of_center", "Longitude_Of_Center"],
    ["longitude_of_center", "Longitude_of_center"],
    ["longc", "longitude_of_center", d2r],
    ["x0", "false_easting", toMeter],
    ["y0", "false_northing", toMeter],
    ["long0", "central_meridian", d2r],
    ["lat0", "latitude_of_origin", d2r],
    ["lat0", "standard_parallel_1", d2r],
    ["lat1", "standard_parallel_1", d2r],
    ["lat2", "standard_parallel_2", d2r],
    ["azimuth", "Azimuth"],
    ["alpha", "azimuth", d2r],
    ["srsCode", "name"]
  ];
  list.forEach(renamer);
  if (!wkt2.long0 && wkt2.longc && (wkt2.projName === "Albers_Conic_Equal_Area" || wkt2.projName === "Lambert_Azimuthal_Equal_Area")) {
    wkt2.long0 = wkt2.longc;
  }
  if (!wkt2.lat_ts && wkt2.lat1 && (wkt2.projName === "Stereographic_South_Pole" || wkt2.projName === "Polar Stereographic (variant B)")) {
    wkt2.lat0 = d2r(wkt2.lat1 > 0 ? 90 : -90);
    wkt2.lat_ts = wkt2.lat1;
  }
}
function wkt(wkt2) {
  var lisp = parseString(wkt2);
  var type = lisp.shift();
  var name = lisp.shift();
  lisp.unshift(["name", name]);
  lisp.unshift(["type", type]);
  var obj = {};
  sExpr(lisp, obj);
  cleanWKT(obj);
  return obj;
}
function defs(name) {
  var that = this;
  if (arguments.length === 2) {
    var def = arguments[1];
    if (typeof def === "string") {
      if (def.charAt(0) === "+") {
        defs[name] = projStr(arguments[1]);
      } else {
        defs[name] = wkt(arguments[1]);
      }
    } else {
      defs[name] = def;
    }
  } else if (arguments.length === 1) {
    if (Array.isArray(name)) {
      return name.map(function(v) {
        if (Array.isArray(v)) {
          defs.apply(that, v);
        } else {
          defs(v);
        }
      });
    } else if (typeof name === "string") {
      if (name in defs) {
        return defs[name];
      }
    } else if ("EPSG" in name) {
      defs["EPSG:" + name.EPSG] = name;
    } else if ("ESRI" in name) {
      defs["ESRI:" + name.ESRI] = name;
    } else if ("IAU2000" in name) {
      defs["IAU2000:" + name.IAU2000] = name;
    } else {
      console.log(name);
    }
    return;
  }
}
globals(defs);
function testObj(code) {
  return typeof code === "string";
}
function testDef(code) {
  return code in defs;
}
var codeWords = ["PROJECTEDCRS", "PROJCRS", "GEOGCS", "GEOCCS", "PROJCS", "LOCAL_CS", "GEODCRS", "GEODETICCRS", "GEODETICDATUM", "ENGCRS", "ENGINEERINGCRS"];
function testWKT(code) {
  return codeWords.some(function(word) {
    return code.indexOf(word) > -1;
  });
}
var codes = ["3857", "900913", "3785", "102113"];
function checkMercator(item) {
  var auth = match(item, "authority");
  if (!auth) {
    return;
  }
  var code = match(auth, "epsg");
  return code && codes.indexOf(code) > -1;
}
function checkProjStr(item) {
  var ext = match(item, "extension");
  if (!ext) {
    return;
  }
  return match(ext, "proj4");
}
function testProj(code) {
  return code[0] === "+";
}
function parse(code) {
  if (testObj(code)) {
    if (testDef(code)) {
      return defs[code];
    }
    if (testWKT(code)) {
      var out = wkt(code);
      if (checkMercator(out)) {
        return defs["EPSG:3857"];
      }
      var maybeProjStr = checkProjStr(out);
      if (maybeProjStr) {
        return projStr(maybeProjStr);
      }
      return out;
    }
    if (testProj(code)) {
      return projStr(code);
    }
  } else {
    return code;
  }
}
function extend(destination, source) {
  destination = destination || {};
  var value, property;
  if (!source) {
    return destination;
  }
  for (property in source) {
    value = source[property];
    if (value !== void 0) {
      destination[property] = value;
    }
  }
  return destination;
}
function msfnz(eccent, sinphi, cosphi) {
  var con = eccent * sinphi;
  return cosphi / Math.sqrt(1 - con * con);
}
function sign(x2) {
  return x2 < 0 ? -1 : 1;
}
function adjust_lon(x2) {
  return Math.abs(x2) <= SPI ? x2 : x2 - sign(x2) * TWO_PI;
}
function tsfnz(eccent, phi, sinphi) {
  var con = eccent * sinphi;
  var com = 0.5 * eccent;
  con = Math.pow((1 - con) / (1 + con), com);
  return Math.tan(0.5 * (HALF_PI - phi)) / con;
}
function phi2z(eccent, ts) {
  var eccnth = 0.5 * eccent;
  var con, dphi;
  var phi = HALF_PI - 2 * Math.atan(ts);
  for (var i2 = 0; i2 <= 15; i2++) {
    con = eccent * Math.sin(phi);
    dphi = HALF_PI - 2 * Math.atan(ts * Math.pow((1 - con) / (1 + con), eccnth)) - phi;
    phi += dphi;
    if (Math.abs(dphi) <= 1e-10) {
      return phi;
    }
  }
  return -9999;
}
function init$3() {
  var con = this.b / this.a;
  this.es = 1 - con * con;
  if (!("x0" in this)) {
    this.x0 = 0;
  }
  if (!("y0" in this)) {
    this.y0 = 0;
  }
  this.e = Math.sqrt(this.es);
  if (this.lat_ts) {
    if (this.sphere) {
      this.k0 = Math.cos(this.lat_ts);
    } else {
      this.k0 = msfnz(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
    }
  } else {
    if (!this.k0) {
      if (this.k) {
        this.k0 = this.k;
      } else {
        this.k0 = 1;
      }
    }
  }
}
function forward(p2) {
  var lon = p2.x;
  var lat = p2.y;
  if (lat * R2D > 90 && lat * R2D < -90 && lon * R2D > 180 && lon * R2D < -180) {
    return null;
  }
  var x2, y2;
  if (Math.abs(Math.abs(lat) - HALF_PI) <= EPSLN) {
    return null;
  } else {
    if (this.sphere) {
      x2 = this.x0 + this.a * this.k0 * adjust_lon(lon - this.long0);
      y2 = this.y0 + this.a * this.k0 * Math.log(Math.tan(FORTPI + 0.5 * lat));
    } else {
      var sinphi = Math.sin(lat);
      var ts = tsfnz(this.e, lat, sinphi);
      x2 = this.x0 + this.a * this.k0 * adjust_lon(lon - this.long0);
      y2 = this.y0 - this.a * this.k0 * Math.log(ts);
    }
    p2.x = x2;
    p2.y = y2;
    return p2;
  }
}
function inverse(p2) {
  var x2 = p2.x - this.x0;
  var y2 = p2.y - this.y0;
  var lon, lat;
  if (this.sphere) {
    lat = HALF_PI - 2 * Math.atan(Math.exp(-y2 / (this.a * this.k0)));
  } else {
    var ts = Math.exp(-y2 / (this.a * this.k0));
    lat = phi2z(this.e, ts);
    if (lat === -9999) {
      return null;
    }
  }
  lon = adjust_lon(this.long0 + x2 / (this.a * this.k0));
  p2.x = lon;
  p2.y = lat;
  return p2;
}
var names$2 = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
var merc = {
  init: init$3,
  forward,
  inverse,
  names: names$2
};
function init$2() {
}
function identity(pt) {
  return pt;
}
var names$1 = ["longlat", "identity"];
var longlat = {
  init: init$2,
  forward: identity,
  inverse: identity,
  names: names$1
};
var projs = [merc, longlat];
var names = {};
var projStore = [];
function add(proj, i2) {
  var len = projStore.length;
  if (!proj.names) {
    console.log(i2);
    return true;
  }
  projStore[len] = proj;
  proj.names.forEach(function(n2) {
    names[n2.toLowerCase()] = len;
  });
  return this;
}
function get(name) {
  if (!name) {
    return false;
  }
  var n2 = name.toLowerCase();
  if (typeof names[n2] !== "undefined" && projStore[names[n2]]) {
    return projStore[names[n2]];
  }
}
function start() {
  projs.forEach(add);
}
var projections = {
  start,
  add,
  get
};
var exports$1 = {};
exports$1.MERIT = {
  a: 6378137,
  rf: 298.257,
  ellipseName: "MERIT 1983"
};
exports$1.SGS85 = {
  a: 6378136,
  rf: 298.257,
  ellipseName: "Soviet Geodetic System 85"
};
exports$1.GRS80 = {
  a: 6378137,
  rf: 298.257222101,
  ellipseName: "GRS 1980(IUGG, 1980)"
};
exports$1.IAU76 = {
  a: 6378140,
  rf: 298.257,
  ellipseName: "IAU 1976"
};
exports$1.airy = {
  a: 6377563396e-3,
  b: 635625691e-2,
  ellipseName: "Airy 1830"
};
exports$1.APL4 = {
  a: 6378137,
  rf: 298.25,
  ellipseName: "Appl. Physics. 1965"
};
exports$1.NWL9D = {
  a: 6378145,
  rf: 298.25,
  ellipseName: "Naval Weapons Lab., 1965"
};
exports$1.mod_airy = {
  a: 6377340189e-3,
  b: 6356034446e-3,
  ellipseName: "Modified Airy"
};
exports$1.andrae = {
  a: 637710443e-2,
  rf: 300,
  ellipseName: "Andrae 1876 (Den., Iclnd.)"
};
exports$1.aust_SA = {
  a: 6378160,
  rf: 298.25,
  ellipseName: "Australian Natl & S. Amer. 1969"
};
exports$1.GRS67 = {
  a: 6378160,
  rf: 298.247167427,
  ellipseName: "GRS 67(IUGG 1967)"
};
exports$1.bessel = {
  a: 6377397155e-3,
  rf: 299.1528128,
  ellipseName: "Bessel 1841"
};
exports$1.bess_nam = {
  a: 6377483865e-3,
  rf: 299.1528128,
  ellipseName: "Bessel 1841 (Namibia)"
};
exports$1.clrk66 = {
  a: 63782064e-1,
  b: 63565838e-1,
  ellipseName: "Clarke 1866"
};
exports$1.clrk80 = {
  a: 6378249145e-3,
  rf: 293.4663,
  ellipseName: "Clarke 1880 mod."
};
exports$1.clrk58 = {
  a: 6378293645208759e-9,
  rf: 294.2606763692654,
  ellipseName: "Clarke 1858"
};
exports$1.CPM = {
  a: 63757387e-1,
  rf: 334.29,
  ellipseName: "Comm. des Poids et Mesures 1799"
};
exports$1.delmbr = {
  a: 6376428,
  rf: 311.5,
  ellipseName: "Delambre 1810 (Belgium)"
};
exports$1.engelis = {
  a: 637813605e-2,
  rf: 298.2566,
  ellipseName: "Engelis 1985"
};
exports$1.evrst30 = {
  a: 6377276345e-3,
  rf: 300.8017,
  ellipseName: "Everest 1830"
};
exports$1.evrst48 = {
  a: 6377304063e-3,
  rf: 300.8017,
  ellipseName: "Everest 1948"
};
exports$1.evrst56 = {
  a: 6377301243e-3,
  rf: 300.8017,
  ellipseName: "Everest 1956"
};
exports$1.evrst69 = {
  a: 6377295664e-3,
  rf: 300.8017,
  ellipseName: "Everest 1969"
};
exports$1.evrstSS = {
  a: 6377298556e-3,
  rf: 300.8017,
  ellipseName: "Everest (Sabah & Sarawak)"
};
exports$1.fschr60 = {
  a: 6378166,
  rf: 298.3,
  ellipseName: "Fischer (Mercury Datum) 1960"
};
exports$1.fschr60m = {
  a: 6378155,
  rf: 298.3,
  ellipseName: "Fischer 1960"
};
exports$1.fschr68 = {
  a: 6378150,
  rf: 298.3,
  ellipseName: "Fischer 1968"
};
exports$1.helmert = {
  a: 6378200,
  rf: 298.3,
  ellipseName: "Helmert 1906"
};
exports$1.hough = {
  a: 6378270,
  rf: 297,
  ellipseName: "Hough"
};
exports$1.intl = {
  a: 6378388,
  rf: 297,
  ellipseName: "International 1909 (Hayford)"
};
exports$1.kaula = {
  a: 6378163,
  rf: 298.24,
  ellipseName: "Kaula 1961"
};
exports$1.lerch = {
  a: 6378139,
  rf: 298.257,
  ellipseName: "Lerch 1979"
};
exports$1.mprts = {
  a: 6397300,
  rf: 191,
  ellipseName: "Maupertius 1738"
};
exports$1.new_intl = {
  a: 63781575e-1,
  b: 63567722e-1,
  ellipseName: "New International 1967"
};
exports$1.plessis = {
  a: 6376523,
  rf: 6355863,
  ellipseName: "Plessis 1817 (France)"
};
exports$1.krass = {
  a: 6378245,
  rf: 298.3,
  ellipseName: "Krassovsky, 1942"
};
exports$1.SEasia = {
  a: 6378155,
  b: 63567733205e-4,
  ellipseName: "Southeast Asia"
};
exports$1.walbeck = {
  a: 6376896,
  b: 63558348467e-4,
  ellipseName: "Walbeck"
};
exports$1.WGS60 = {
  a: 6378165,
  rf: 298.3,
  ellipseName: "WGS 60"
};
exports$1.WGS66 = {
  a: 6378145,
  rf: 298.25,
  ellipseName: "WGS 66"
};
exports$1.WGS7 = {
  a: 6378135,
  rf: 298.26,
  ellipseName: "WGS 72"
};
var WGS84 = exports$1.WGS84 = {
  a: 6378137,
  rf: 298.257223563,
  ellipseName: "WGS 84"
};
exports$1.sphere = {
  a: 6370997,
  b: 6370997,
  ellipseName: "Normal Sphere (r=6370997)"
};
function eccentricity(a2, b, rf, R_A) {
  var a22 = a2 * a2;
  var b2 = b * b;
  var es = (a22 - b2) / a22;
  var e = 0;
  if (R_A) {
    a2 *= 1 - es * (SIXTH + es * (RA4 + es * RA6));
    a22 = a2 * a2;
    es = 0;
  } else {
    e = Math.sqrt(es);
  }
  var ep2 = (a22 - b2) / b2;
  return {
    es,
    e,
    ep2
  };
}
function sphere(a2, b, rf, ellps, sphere2) {
  if (!a2) {
    var ellipse = match(exports$1, ellps);
    if (!ellipse) {
      ellipse = WGS84;
    }
    a2 = ellipse.a;
    b = ellipse.b;
    rf = ellipse.rf;
  }
  if (rf && !b) {
    b = (1 - 1 / rf) * a2;
  }
  if (rf === 0 || Math.abs(a2 - b) < EPSLN) {
    sphere2 = true;
    b = a2;
  }
  return {
    a: a2,
    b,
    rf,
    sphere: sphere2
  };
}
var exports = {};
exports.wgs84 = {
  towgs84: "0,0,0",
  ellipse: "WGS84",
  datumName: "WGS84"
};
exports.ch1903 = {
  towgs84: "674.374,15.056,405.346",
  ellipse: "bessel",
  datumName: "swiss"
};
exports.ggrs87 = {
  towgs84: "-199.87,74.79,246.62",
  ellipse: "GRS80",
  datumName: "Greek_Geodetic_Reference_System_1987"
};
exports.nad83 = {
  towgs84: "0,0,0",
  ellipse: "GRS80",
  datumName: "North_American_Datum_1983"
};
exports.nad27 = {
  nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
  ellipse: "clrk66",
  datumName: "North_American_Datum_1927"
};
exports.potsdam = {
  towgs84: "598.1,73.7,418.2,0.202,0.045,-2.455,6.7",
  ellipse: "bessel",
  datumName: "Potsdam Rauenberg 1950 DHDN"
};
exports.carthage = {
  towgs84: "-263.0,6.0,431.0",
  ellipse: "clark80",
  datumName: "Carthage 1934 Tunisia"
};
exports.hermannskogel = {
  towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
  ellipse: "bessel",
  datumName: "Hermannskogel"
};
exports.osni52 = {
  towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
  ellipse: "airy",
  datumName: "Irish National"
};
exports.ire65 = {
  towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
  ellipse: "mod_airy",
  datumName: "Ireland 1965"
};
exports.rassadiran = {
  towgs84: "-133.63,-157.5,-158.62",
  ellipse: "intl",
  datumName: "Rassadiran"
};
exports.nzgd49 = {
  towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
  ellipse: "intl",
  datumName: "New Zealand Geodetic Datum 1949"
};
exports.osgb36 = {
  towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
  ellipse: "airy",
  datumName: "Airy 1830"
};
exports.s_jtsk = {
  towgs84: "589,76,480",
  ellipse: "bessel",
  datumName: "S-JTSK (Ferro)"
};
exports.beduaram = {
  towgs84: "-106,-87,188",
  ellipse: "clrk80",
  datumName: "Beduaram"
};
exports.gunung_segara = {
  towgs84: "-403,684,41",
  ellipse: "bessel",
  datumName: "Gunung Segara Jakarta"
};
exports.rnb72 = {
  towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
  ellipse: "intl",
  datumName: "Reseau National Belge 1972"
};
function datum(datumCode, datum_params, a2, b, es, ep2, nadgrids) {
  var out = {};
  if (datumCode === void 0 || datumCode === "none") {
    out.datum_type = PJD_NODATUM;
  } else {
    out.datum_type = PJD_WGS84;
  }
  if (datum_params) {
    out.datum_params = datum_params.map(parseFloat);
    if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
      out.datum_type = PJD_3PARAM;
    }
    if (out.datum_params.length > 3) {
      if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
        out.datum_type = PJD_7PARAM;
        out.datum_params[3] *= SEC_TO_RAD;
        out.datum_params[4] *= SEC_TO_RAD;
        out.datum_params[5] *= SEC_TO_RAD;
        out.datum_params[6] = out.datum_params[6] / 1e6 + 1;
      }
    }
  }
  if (nadgrids) {
    out.datum_type = PJD_GRIDSHIFT;
    out.grids = nadgrids;
  }
  out.a = a2;
  out.b = b;
  out.es = es;
  out.ep2 = ep2;
  return out;
}
var loadedNadgrids = {};
function getNadgrids(nadgrids) {
  if (nadgrids === void 0) {
    return null;
  }
  var grids = nadgrids.split(",");
  return grids.map(parseNadgridString);
}
function parseNadgridString(value) {
  if (value.length === 0) {
    return null;
  }
  var optional = value[0] === "@";
  if (optional) {
    value = value.slice(1);
  }
  if (value === "null") {
    return { name: "null", mandatory: !optional, grid: null, isNull: true };
  }
  return {
    name: value,
    mandatory: !optional,
    grid: loadedNadgrids[value] || null,
    isNull: false
  };
}
function Projection(srsCode, callback) {
  if (!(this instanceof Projection)) {
    return new Projection(srsCode);
  }
  callback = callback || function(error) {
    if (error) {
      throw error;
    }
  };
  var json = parse(srsCode);
  if (typeof json !== "object") {
    callback(srsCode);
    return;
  }
  var ourProj = Projection.projections.get(json.projName);
  if (!ourProj) {
    callback(srsCode);
    return;
  }
  if (json.datumCode && json.datumCode !== "none") {
    var datumDef = match(exports, json.datumCode);
    if (datumDef) {
      json.datum_params = json.datum_params || (datumDef.towgs84 ? datumDef.towgs84.split(",") : null);
      json.ellps = datumDef.ellipse;
      json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
    }
  }
  json.k0 = json.k0 || 1;
  json.axis = json.axis || "enu";
  json.ellps = json.ellps || "wgs84";
  json.lat1 = json.lat1 || json.lat0;
  var sphere_ = sphere(json.a, json.b, json.rf, json.ellps, json.sphere);
  var ecc = eccentricity(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
  var nadgrids = getNadgrids(json.nadgrids);
  var datumObj = json.datum || datum(
    json.datumCode,
    json.datum_params,
    sphere_.a,
    sphere_.b,
    ecc.es,
    ecc.ep2,
    nadgrids
  );
  extend(this, json);
  extend(this, ourProj);
  this.a = sphere_.a;
  this.b = sphere_.b;
  this.rf = sphere_.rf;
  this.sphere = sphere_.sphere;
  this.es = ecc.es;
  this.e = ecc.e;
  this.ep2 = ecc.ep2;
  this.datum = datumObj;
  this.init();
  callback(null, this);
}
Projection.projections = projections;
Projection.projections.start();
function compareDatums(source, dest) {
  if (source.datum_type !== dest.datum_type) {
    return false;
  } else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 5e-11) {
    return false;
  } else if (source.datum_type === PJD_3PARAM) {
    return source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2];
  } else if (source.datum_type === PJD_7PARAM) {
    return source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6];
  } else {
    return true;
  }
}
function geodeticToGeocentric(p2, es, a2) {
  var Longitude = p2.x;
  var Latitude = p2.y;
  var Height = p2.z ? p2.z : 0;
  var Rn;
  var Sin_Lat;
  var Sin2_Lat;
  var Cos_Lat;
  if (Latitude < -HALF_PI && Latitude > -1.001 * HALF_PI) {
    Latitude = -HALF_PI;
  } else if (Latitude > HALF_PI && Latitude < 1.001 * HALF_PI) {
    Latitude = HALF_PI;
  } else if (Latitude < -HALF_PI) {
    return { x: -Infinity, y: -Infinity, z: p2.z };
  } else if (Latitude > HALF_PI) {
    return { x: Infinity, y: Infinity, z: p2.z };
  }
  if (Longitude > Math.PI) {
    Longitude -= 2 * Math.PI;
  }
  Sin_Lat = Math.sin(Latitude);
  Cos_Lat = Math.cos(Latitude);
  Sin2_Lat = Sin_Lat * Sin_Lat;
  Rn = a2 / Math.sqrt(1 - es * Sin2_Lat);
  return {
    x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
    y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
    z: (Rn * (1 - es) + Height) * Sin_Lat
  };
}
function geocentricToGeodetic(p2, es, a2, b) {
  var genau = 1e-12;
  var genau2 = genau * genau;
  var maxiter = 30;
  var P;
  var RR;
  var CT;
  var ST;
  var RX;
  var RK;
  var RN;
  var CPHI0;
  var SPHI0;
  var CPHI;
  var SPHI;
  var SDPHI;
  var iter;
  var X = p2.x;
  var Y = p2.y;
  var Z = p2.z ? p2.z : 0;
  var Longitude;
  var Latitude;
  var Height;
  P = Math.sqrt(X * X + Y * Y);
  RR = Math.sqrt(X * X + Y * Y + Z * Z);
  if (P / a2 < genau) {
    Longitude = 0;
    if (RR / a2 < genau) {
      Latitude = HALF_PI;
      Height = -b;
      return {
        x: p2.x,
        y: p2.y,
        z: p2.z
      };
    }
  } else {
    Longitude = Math.atan2(Y, X);
  }
  CT = Z / RR;
  ST = P / RR;
  RX = 1 / Math.sqrt(1 - es * (2 - es) * ST * ST);
  CPHI0 = ST * (1 - es) * RX;
  SPHI0 = CT * RX;
  iter = 0;
  do {
    iter++;
    RN = a2 / Math.sqrt(1 - es * SPHI0 * SPHI0);
    Height = P * CPHI0 + Z * SPHI0 - RN * (1 - es * SPHI0 * SPHI0);
    RK = es * RN / (RN + Height);
    RX = 1 / Math.sqrt(1 - RK * (2 - RK) * ST * ST);
    CPHI = ST * (1 - RK) * RX;
    SPHI = CT * RX;
    SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
    CPHI0 = CPHI;
    SPHI0 = SPHI;
  } while (SDPHI * SDPHI > genau2 && iter < maxiter);
  Latitude = Math.atan(SPHI / Math.abs(CPHI));
  return {
    x: Longitude,
    y: Latitude,
    z: Height
  };
}
function geocentricToWgs84(p2, datum_type, datum_params) {
  if (datum_type === PJD_3PARAM) {
    return {
      x: p2.x + datum_params[0],
      y: p2.y + datum_params[1],
      z: p2.z + datum_params[2]
    };
  } else if (datum_type === PJD_7PARAM) {
    var Dx_BF = datum_params[0];
    var Dy_BF = datum_params[1];
    var Dz_BF = datum_params[2];
    var Rx_BF = datum_params[3];
    var Ry_BF = datum_params[4];
    var Rz_BF = datum_params[5];
    var M_BF = datum_params[6];
    return {
      x: M_BF * (p2.x - Rz_BF * p2.y + Ry_BF * p2.z) + Dx_BF,
      y: M_BF * (Rz_BF * p2.x + p2.y - Rx_BF * p2.z) + Dy_BF,
      z: M_BF * (-Ry_BF * p2.x + Rx_BF * p2.y + p2.z) + Dz_BF
    };
  }
}
function geocentricFromWgs84(p2, datum_type, datum_params) {
  if (datum_type === PJD_3PARAM) {
    return {
      x: p2.x - datum_params[0],
      y: p2.y - datum_params[1],
      z: p2.z - datum_params[2]
    };
  } else if (datum_type === PJD_7PARAM) {
    var Dx_BF = datum_params[0];
    var Dy_BF = datum_params[1];
    var Dz_BF = datum_params[2];
    var Rx_BF = datum_params[3];
    var Ry_BF = datum_params[4];
    var Rz_BF = datum_params[5];
    var M_BF = datum_params[6];
    var x_tmp = (p2.x - Dx_BF) / M_BF;
    var y_tmp = (p2.y - Dy_BF) / M_BF;
    var z_tmp = (p2.z - Dz_BF) / M_BF;
    return {
      x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
      y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
      z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
    };
  }
}
function checkParams(type) {
  return type === PJD_3PARAM || type === PJD_7PARAM;
}
function datum_transform(source, dest, point) {
  if (compareDatums(source, dest)) {
    return point;
  }
  if (source.datum_type === PJD_NODATUM || dest.datum_type === PJD_NODATUM) {
    return point;
  }
  var source_a = source.a;
  var source_es = source.es;
  if (source.datum_type === PJD_GRIDSHIFT) {
    var gridShiftCode = applyGridShift(source, false, point);
    if (gridShiftCode !== 0) {
      return void 0;
    }
    source_a = SRS_WGS84_SEMIMAJOR;
    source_es = SRS_WGS84_ESQUARED;
  }
  var dest_a = dest.a;
  var dest_b = dest.b;
  var dest_es = dest.es;
  if (dest.datum_type === PJD_GRIDSHIFT) {
    dest_a = SRS_WGS84_SEMIMAJOR;
    dest_b = SRS_WGS84_SEMIMINOR;
    dest_es = SRS_WGS84_ESQUARED;
  }
  if (source_es === dest_es && source_a === dest_a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
    return point;
  }
  point = geodeticToGeocentric(point, source_es, source_a);
  if (checkParams(source.datum_type)) {
    point = geocentricToWgs84(point, source.datum_type, source.datum_params);
  }
  if (checkParams(dest.datum_type)) {
    point = geocentricFromWgs84(point, dest.datum_type, dest.datum_params);
  }
  point = geocentricToGeodetic(point, dest_es, dest_a, dest_b);
  if (dest.datum_type === PJD_GRIDSHIFT) {
    var destGridShiftResult = applyGridShift(dest, true, point);
    if (destGridShiftResult !== 0) {
      return void 0;
    }
  }
  return point;
}
function applyGridShift(source, inverse2, point) {
  if (source.grids === null || source.grids.length === 0) {
    console.log("Grid shift grids not found");
    return -1;
  }
  var input2 = { x: -point.x, y: point.y };
  var output = { x: Number.NaN, y: Number.NaN };
  var attemptedGrids = [];
  for (var i2 = 0; i2 < source.grids.length; i2++) {
    var grid = source.grids[i2];
    attemptedGrids.push(grid.name);
    if (grid.isNull) {
      output = input2;
      break;
    }
    grid.mandatory;
    if (grid.grid === null) {
      if (grid.mandatory) {
        console.log("Unable to find mandatory grid '" + grid.name + "'");
        return -1;
      }
      continue;
    }
    var subgrid = grid.grid.subgrids[0];
    var epsilon = (Math.abs(subgrid.del[1]) + Math.abs(subgrid.del[0])) / 1e4;
    var minX = subgrid.ll[0] - epsilon;
    var minY = subgrid.ll[1] - epsilon;
    var maxX = subgrid.ll[0] + (subgrid.lim[0] - 1) * subgrid.del[0] + epsilon;
    var maxY = subgrid.ll[1] + (subgrid.lim[1] - 1) * subgrid.del[1] + epsilon;
    if (minY > input2.y || minX > input2.x || maxY < input2.y || maxX < input2.x) {
      continue;
    }
    output = applySubgridShift(input2, inverse2, subgrid);
    if (!isNaN(output.x)) {
      break;
    }
  }
  if (isNaN(output.x)) {
    console.log("Failed to find a grid shift table for location '" + -input2.x * R2D + " " + input2.y * R2D + " tried: '" + attemptedGrids + "'");
    return -1;
  }
  point.x = -output.x;
  point.y = output.y;
  return 0;
}
function applySubgridShift(pin, inverse2, ct) {
  var val = { x: Number.NaN, y: Number.NaN };
  if (isNaN(pin.x)) {
    return val;
  }
  var tb = { x: pin.x, y: pin.y };
  tb.x -= ct.ll[0];
  tb.y -= ct.ll[1];
  tb.x = adjust_lon(tb.x - Math.PI) + Math.PI;
  var t = nadInterpolate(tb, ct);
  if (inverse2) {
    if (isNaN(t.x)) {
      return val;
    }
    t.x = tb.x - t.x;
    t.y = tb.y - t.y;
    var i2 = 9, tol = 1e-12;
    var dif, del;
    do {
      del = nadInterpolate(t, ct);
      if (isNaN(del.x)) {
        console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
        break;
      }
      dif = { x: tb.x - (del.x + t.x), y: tb.y - (del.y + t.y) };
      t.x += dif.x;
      t.y += dif.y;
    } while (i2-- && Math.abs(dif.x) > tol && Math.abs(dif.y) > tol);
    if (i2 < 0) {
      console.log("Inverse grid shift iterator failed to converge.");
      return val;
    }
    val.x = adjust_lon(t.x + ct.ll[0]);
    val.y = t.y + ct.ll[1];
  } else {
    if (!isNaN(t.x)) {
      val.x = pin.x + t.x;
      val.y = pin.y + t.y;
    }
  }
  return val;
}
function nadInterpolate(pin, ct) {
  var t = { x: pin.x / ct.del[0], y: pin.y / ct.del[1] };
  var indx = { x: Math.floor(t.x), y: Math.floor(t.y) };
  var frct = { x: t.x - 1 * indx.x, y: t.y - 1 * indx.y };
  var val = { x: Number.NaN, y: Number.NaN };
  var inx;
  if (indx.x < 0 || indx.x >= ct.lim[0]) {
    return val;
  }
  if (indx.y < 0 || indx.y >= ct.lim[1]) {
    return val;
  }
  inx = indx.y * ct.lim[0] + indx.x;
  var f00 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
  inx++;
  var f10 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
  inx += ct.lim[0];
  var f11 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
  inx--;
  var f01 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
  var m11 = frct.x * frct.y, m10 = frct.x * (1 - frct.y), m00 = (1 - frct.x) * (1 - frct.y), m01 = (1 - frct.x) * frct.y;
  val.x = m00 * f00.x + m10 * f10.x + m01 * f01.x + m11 * f11.x;
  val.y = m00 * f00.y + m10 * f10.y + m01 * f01.y + m11 * f11.y;
  return val;
}
function adjust_axis(crs, denorm, point) {
  var xin = point.x, yin = point.y, zin = point.z || 0;
  var v, t, i2;
  var out = {};
  for (i2 = 0; i2 < 3; i2++) {
    if (denorm && i2 === 2 && point.z === void 0) {
      continue;
    }
    if (i2 === 0) {
      v = xin;
      if ("ew".indexOf(crs.axis[i2]) !== -1) {
        t = "x";
      } else {
        t = "y";
      }
    } else if (i2 === 1) {
      v = yin;
      if ("ns".indexOf(crs.axis[i2]) !== -1) {
        t = "y";
      } else {
        t = "x";
      }
    } else {
      v = zin;
      t = "z";
    }
    switch (crs.axis[i2]) {
      case "e":
        out[t] = v;
        break;
      case "w":
        out[t] = -v;
        break;
      case "n":
        out[t] = v;
        break;
      case "s":
        out[t] = -v;
        break;
      case "u":
        if (point[t] !== void 0) {
          out.z = v;
        }
        break;
      case "d":
        if (point[t] !== void 0) {
          out.z = -v;
        }
        break;
      default:
        return null;
    }
  }
  return out;
}
function toPoint(array) {
  var out = {
    x: array[0],
    y: array[1]
  };
  if (array.length > 2) {
    out.z = array[2];
  }
  if (array.length > 3) {
    out.m = array[3];
  }
  return out;
}
function checkSanity(point) {
  checkCoord(point.x);
  checkCoord(point.y);
}
function checkCoord(num2) {
  if (typeof Number.isFinite === "function") {
    if (Number.isFinite(num2)) {
      return;
    }
    throw new TypeError("coordinates must be finite numbers");
  }
  if (typeof num2 !== "number" || num2 !== num2 || !isFinite(num2)) {
    throw new TypeError("coordinates must be finite numbers");
  }
}
function checkNotWGS(source, dest) {
  return (source.datum.datum_type === PJD_3PARAM || source.datum.datum_type === PJD_7PARAM) && dest.datumCode !== "WGS84" || (dest.datum.datum_type === PJD_3PARAM || dest.datum.datum_type === PJD_7PARAM) && source.datumCode !== "WGS84";
}
function transform(source, dest, point, enforceAxis) {
  var wgs842;
  if (Array.isArray(point)) {
    point = toPoint(point);
  }
  checkSanity(point);
  if (source.datum && dest.datum && checkNotWGS(source, dest)) {
    wgs842 = new Projection("WGS84");
    point = transform(source, wgs842, point, enforceAxis);
    source = wgs842;
  }
  if (enforceAxis && source.axis !== "enu") {
    point = adjust_axis(source, false, point);
  }
  if (source.projName === "longlat") {
    point = {
      x: point.x * D2R$1,
      y: point.y * D2R$1,
      z: point.z || 0
    };
  } else {
    if (source.to_meter) {
      point = {
        x: point.x * source.to_meter,
        y: point.y * source.to_meter,
        z: point.z || 0
      };
    }
    point = source.inverse(point);
    if (!point) {
      return;
    }
  }
  if (source.from_greenwich) {
    point.x += source.from_greenwich;
  }
  point = datum_transform(source.datum, dest.datum, point);
  if (!point) {
    return;
  }
  if (dest.from_greenwich) {
    point = {
      x: point.x - dest.from_greenwich,
      y: point.y,
      z: point.z || 0
    };
  }
  if (dest.projName === "longlat") {
    point = {
      x: point.x * R2D,
      y: point.y * R2D,
      z: point.z || 0
    };
  } else {
    point = dest.forward(point);
    if (dest.to_meter) {
      point = {
        x: point.x / dest.to_meter,
        y: point.y / dest.to_meter,
        z: point.z || 0
      };
    }
  }
  if (enforceAxis && dest.axis !== "enu") {
    return adjust_axis(dest, true, point);
  }
  return point;
}
var wgs84$1 = Projection("WGS84");
function transformer(from, to, coords, enforceAxis) {
  var transformedArray, out, keys2;
  if (Array.isArray(coords)) {
    transformedArray = transform(from, to, coords, enforceAxis) || { x: NaN, y: NaN };
    if (coords.length > 2) {
      if (typeof from.name !== "undefined" && from.name === "geocent" || typeof to.name !== "undefined" && to.name === "geocent") {
        if (typeof transformedArray.z === "number") {
          return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
        } else {
          return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
        }
      } else {
        return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
      }
    } else {
      return [transformedArray.x, transformedArray.y];
    }
  } else {
    out = transform(from, to, coords, enforceAxis);
    keys2 = Object.keys(coords);
    if (keys2.length === 2) {
      return out;
    }
    keys2.forEach(function(key) {
      if (typeof from.name !== "undefined" && from.name === "geocent" || typeof to.name !== "undefined" && to.name === "geocent") {
        if (key === "x" || key === "y" || key === "z") {
          return;
        }
      } else {
        if (key === "x" || key === "y") {
          return;
        }
      }
      out[key] = coords[key];
    });
    return out;
  }
}
function checkProj(item) {
  if (item instanceof Projection) {
    return item;
  }
  if (item.oProj) {
    return item.oProj;
  }
  return Projection(item);
}
function proj4(fromProj, toProj, coord) {
  fromProj = checkProj(fromProj);
  var single = false;
  var obj;
  if (typeof toProj === "undefined") {
    toProj = fromProj;
    fromProj = wgs84$1;
    single = true;
  } else if (typeof toProj.x !== "undefined" || Array.isArray(toProj)) {
    coord = toProj;
    toProj = fromProj;
    fromProj = wgs84$1;
    single = true;
  }
  toProj = checkProj(toProj);
  if (coord) {
    return transformer(fromProj, toProj, coord);
  } else {
    obj = {
      forward: function(coords, enforceAxis) {
        return transformer(fromProj, toProj, coords, enforceAxis);
      },
      inverse: function(coords, enforceAxis) {
        return transformer(toProj, fromProj, coords, enforceAxis);
      }
    };
    if (single) {
      obj.oProj = toProj;
    }
    return obj;
  }
}
const mercator = new Projection("GOOGLE");
const wgs84 = new Projection("WGS84");
const _wgs84_mercator = proj4(wgs84, mercator);
const wgs84_mercator = {
  compute(x2, y2) {
    if (isFinite(x2) && isFinite(y2))
      return _wgs84_mercator.forward([x2, y2]);
    else
      return [NaN, NaN];
  },
  invert(merc_x, merc_y) {
    if (isFinite(merc_x) && isFinite(merc_y))
      return _wgs84_mercator.inverse([merc_x, merc_y]);
    else
      return [NaN, NaN];
  }
};
const mercator_bounds = {
  lon: [-2002637639e-2, 2002637639e-2],
  lat: [-200489661e-1, 200489661e-1]
};
const latlon_bounds = {
  lon: [-180, 180],
  lat: [-85.06, 85.06]
};
const { min: min$4, max: max$6 } = Math;
function clip_mercator(low, high, dimension) {
  const [vmin, vmax] = mercator_bounds[dimension];
  return [max$6(low, vmin), min$4(high, vmax)];
}
function in_bounds(value, dimension) {
  const [min2, max2] = latlon_bounds[dimension];
  return min2 < value && value < max2;
}
var inplace;
(function(inplace2) {
  function project_xy(x2, y2, merc_x, merc_y) {
    const n2 = min$4(x2.length, y2.length);
    merc_x = merc_x != null ? merc_x : x2;
    merc_y = merc_y != null ? merc_y : y2;
    for (let i2 = 0; i2 < n2; i2++) {
      const xi = x2[i2];
      const yi = y2[i2];
      const [merc_xi, merc_yi] = wgs84_mercator.compute(xi, yi);
      merc_x[i2] = merc_xi;
      merc_y[i2] = merc_yi;
    }
  }
  inplace2.project_xy = project_xy;
  function project_xsys(xs, ys, merc_xs, merc_ys) {
    const n2 = min$4(xs.length, ys.length);
    merc_xs = merc_xs != null ? merc_xs : xs;
    merc_ys = merc_ys != null ? merc_ys : ys;
    for (let i2 = 0; i2 < n2; i2++) {
      project_xy(xs[i2], ys[i2], merc_xs[i2], merc_ys[i2]);
    }
  }
  inplace2.project_xsys = project_xsys;
})(inplace || (inplace = {}));
var _a$3F;
class DataAnnotationView extends AnnotationView {
  constructor() {
    super(...arguments);
    this._initial_set_data = false;
  }
  connect_signals() {
    super.connect_signals();
    const update = () => {
      this.set_data(this.model.source);
      this._rerender();
    };
    this.connect(this.model.change, update);
    this.connect(this.model.source.streaming, update);
    this.connect(this.model.source.patching, update);
    this.connect(this.model.source.change, update);
  }
  _rerender() {
    this.request_render();
  }
  set_data(source) {
    const self2 = this;
    for (const prop of this.model) {
      if (!(prop instanceof VectorSpec || prop instanceof ScalarSpec))
        continue;
      if (prop instanceof BaseCoordinateSpec) {
        const array = prop.array(source);
        self2[`_${prop.attr}`] = array;
      } else {
        const uniform = prop.uniform(source);
        self2[`${prop.attr}`] = uniform;
      }
    }
    if (this.plot_model.use_map) {
      if (self2._x != null)
        inplace.project_xy(self2._x, self2._y);
      if (self2._xs != null)
        inplace.project_xsys(self2._xs, self2._ys);
    }
    for (const visual of this.visuals) {
      visual.update();
    }
  }
  _render() {
    if (!this._initial_set_data) {
      this.set_data(this.model.source);
      this._initial_set_data = true;
    }
    this.map_data();
    this.paint(this.layer.ctx);
  }
}
DataAnnotationView.__name__ = "DataAnnotationView";
class DataAnnotation extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3F = DataAnnotation;
DataAnnotation.__name__ = "DataAnnotation";
(() => {
  _a$3F.define(({ Ref: Ref2 }) => ({
    source: [Ref2(ColumnarDataSource), () => new ColumnDataSource()]
  }));
})();
var _a$3E, _b$9, _c$5, _d$3, _e$3;
class ArrowHeadView extends View {
  initialize() {
    super.initialize();
    this.visuals = new Visuals(this);
  }
  request_render() {
    this.parent.request_render();
  }
  get canvas() {
    return this.parent.canvas;
  }
  set_data(source) {
    const self2 = this;
    for (const prop of this.model) {
      if (!(prop instanceof VectorSpec || prop instanceof ScalarSpec))
        continue;
      const uniform = prop.uniform(source);
      self2[`${prop.attr}`] = uniform;
    }
  }
}
ArrowHeadView.__name__ = "ArrowHeadView";
class ArrowHead extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3E = ArrowHead;
ArrowHead.__name__ = "ArrowHead";
(() => {
  _a$3E.define(() => ({
    size: [NumberSpec, 25]
  }));
})();
class OpenHeadView extends ArrowHeadView {
  clip(ctx, i2) {
    this.visuals.line.set_vectorize(ctx, i2);
    const size_i = this.size.get(i2);
    ctx.moveTo(0.5 * size_i, size_i);
    ctx.lineTo(0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, size_i);
    ctx.lineTo(0, 0);
    ctx.lineTo(0.5 * size_i, size_i);
  }
  render(ctx, i2) {
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(ctx, i2);
      const size_i = this.size.get(i2);
      ctx.beginPath();
      ctx.moveTo(0.5 * size_i, size_i);
      ctx.lineTo(0, 0);
      ctx.lineTo(-0.5 * size_i, size_i);
      ctx.stroke();
    }
  }
}
OpenHeadView.__name__ = "OpenHeadView";
class OpenHead extends ArrowHead {
  constructor(attrs) {
    super(attrs);
  }
}
_b$9 = OpenHead;
OpenHead.__name__ = "OpenHead";
(() => {
  _b$9.prototype.default_view = OpenHeadView;
  _b$9.mixins(LineVector$1);
})();
class NormalHeadView extends ArrowHeadView {
  clip(ctx, i2) {
    this.visuals.line.set_vectorize(ctx, i2);
    const size_i = this.size.get(i2);
    ctx.moveTo(0.5 * size_i, size_i);
    ctx.lineTo(0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, size_i);
    ctx.lineTo(0.5 * size_i, size_i);
  }
  render(ctx, i2) {
    if (this.visuals.fill.doit) {
      this.visuals.fill.set_vectorize(ctx, i2);
      this._normal(ctx, i2);
      ctx.fill();
    }
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(ctx, i2);
      this._normal(ctx, i2);
      ctx.stroke();
    }
  }
  _normal(ctx, i2) {
    const size_i = this.size.get(i2);
    ctx.beginPath();
    ctx.moveTo(0.5 * size_i, size_i);
    ctx.lineTo(0, 0);
    ctx.lineTo(-0.5 * size_i, size_i);
    ctx.closePath();
  }
}
NormalHeadView.__name__ = "NormalHeadView";
class NormalHead extends ArrowHead {
  constructor(attrs) {
    super(attrs);
  }
}
_c$5 = NormalHead;
NormalHead.__name__ = "NormalHead";
(() => {
  _c$5.prototype.default_view = NormalHeadView;
  _c$5.mixins([LineVector$1, FillVector$1]);
  _c$5.override({
    fill_color: "black"
  });
})();
class VeeHeadView extends ArrowHeadView {
  clip(ctx, i2) {
    this.visuals.line.set_vectorize(ctx, i2);
    const size_i = this.size.get(i2);
    ctx.moveTo(0.5 * size_i, size_i);
    ctx.lineTo(0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, -2);
    ctx.lineTo(-0.5 * size_i, size_i);
    ctx.lineTo(0, 0.5 * size_i);
    ctx.lineTo(0.5 * size_i, size_i);
  }
  render(ctx, i2) {
    if (this.visuals.fill.doit) {
      this.visuals.fill.set_vectorize(ctx, i2);
      this._vee(ctx, i2);
      ctx.fill();
    }
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(ctx, i2);
      this._vee(ctx, i2);
      ctx.stroke();
    }
  }
  _vee(ctx, i2) {
    const size_i = this.size.get(i2);
    ctx.beginPath();
    ctx.moveTo(0.5 * size_i, size_i);
    ctx.lineTo(0, 0);
    ctx.lineTo(-0.5 * size_i, size_i);
    ctx.lineTo(0, 0.5 * size_i);
    ctx.closePath();
  }
}
VeeHeadView.__name__ = "VeeHeadView";
class VeeHead extends ArrowHead {
  constructor(attrs) {
    super(attrs);
  }
}
_d$3 = VeeHead;
VeeHead.__name__ = "VeeHead";
(() => {
  _d$3.prototype.default_view = VeeHeadView;
  _d$3.mixins([LineVector$1, FillVector$1]);
  _d$3.override({
    fill_color: "black"
  });
})();
class TeeHeadView extends ArrowHeadView {
  render(ctx, i2) {
    if (this.visuals.line.doit) {
      this.visuals.line.set_vectorize(ctx, i2);
      const size_i = this.size.get(i2);
      ctx.beginPath();
      ctx.moveTo(0.5 * size_i, 0);
      ctx.lineTo(-0.5 * size_i, 0);
      ctx.stroke();
    }
  }
  clip(_ctx, _i) {
  }
}
TeeHeadView.__name__ = "TeeHeadView";
class TeeHead extends ArrowHead {
  constructor(attrs) {
    super(attrs);
  }
}
_e$3 = TeeHead;
TeeHead.__name__ = "TeeHead";
(() => {
  _e$3.prototype.default_view = TeeHeadView;
  _e$3.mixins(LineVector$1);
})();
async function _build_view(view_cls, model, options2) {
  const view = new view_cls({ ...options2, model });
  view.initialize();
  await view.lazy_initialize();
  return view;
}
async function build_view(model, options2 = { parent: null }, cls = (model2) => model2.default_view) {
  const view = await _build_view(cls(model), model, options2);
  view.connect_signals();
  return view;
}
async function build_views(view_storage, models, options2 = { parent: null }, cls = (model) => model.default_view) {
  const to_remove = difference$1([...view_storage.keys()], models);
  for (const model of to_remove) {
    view_storage.get(model).remove();
    view_storage.delete(model);
  }
  const created_views = [];
  const new_models = models.filter((model) => !view_storage.has(model));
  for (const model of new_models) {
    const view = await _build_view(cls(model), model, options2);
    view_storage.set(model, view);
    created_views.push(view);
  }
  for (const view of created_views)
    view.connect_signals();
  return created_views;
}
function remove_views(view_storage) {
  for (const [model, view] of view_storage) {
    view.remove();
    view_storage.delete(model);
  }
}
var _a$3D;
class ArrowView extends DataAnnotationView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { start: start2, end } = this.model;
    if (start2 != null)
      this.start = await build_view(start2, { parent: this });
    if (end != null)
      this.end = await build_view(end, { parent: this });
  }
  set_data(source) {
    var _a2, _b2;
    super.set_data(source);
    (_a2 = this.start) == null ? void 0 : _a2.set_data(source);
    (_b2 = this.end) == null ? void 0 : _b2.set_data(source);
  }
  remove() {
    var _a2, _b2;
    (_a2 = this.start) == null ? void 0 : _a2.remove();
    (_b2 = this.end) == null ? void 0 : _b2.remove();
    super.remove();
  }
  map_data() {
    const { frame } = this.plot_view;
    if (this.model.start_units == "data") {
      this._sx_start = this.coordinates.x_scale.v_compute(this._x_start);
      this._sy_start = this.coordinates.y_scale.v_compute(this._y_start);
    } else {
      this._sx_start = frame.bbox.xview.v_compute(this._x_start);
      this._sy_start = frame.bbox.yview.v_compute(this._y_start);
    }
    if (this.model.end_units == "data") {
      this._sx_end = this.coordinates.x_scale.v_compute(this._x_end);
      this._sy_end = this.coordinates.y_scale.v_compute(this._y_end);
    } else {
      this._sx_end = frame.bbox.xview.v_compute(this._x_end);
      this._sy_end = frame.bbox.yview.v_compute(this._y_end);
    }
    const { _sx_start, _sy_start, _sx_end, _sy_end } = this;
    const n2 = _sx_start.length;
    const angles = this._angles = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      angles[i2] = Math.PI / 2 + atan2([_sx_start[i2], _sy_start[i2]], [_sx_end[i2], _sy_end[i2]]);
    }
  }
  paint(ctx) {
    const { start: start2, end } = this;
    const { _sx_start, _sy_start, _sx_end, _sy_end, _angles } = this;
    const { x: x2, y: y2, width, height } = this.plot_view.frame.bbox;
    for (let i2 = 0, n2 = _sx_start.length; i2 < n2; i2++) {
      if (end != null) {
        ctx.save();
        ctx.translate(_sx_end[i2], _sy_end[i2]);
        ctx.rotate(_angles[i2]);
        end.render(ctx, i2);
        ctx.restore();
      }
      if (start2 != null) {
        ctx.save();
        ctx.translate(_sx_start[i2], _sy_start[i2]);
        ctx.rotate(_angles[i2] + Math.PI);
        start2.render(ctx, i2);
        ctx.restore();
      }
      if (this.visuals.line.doit) {
        ctx.save();
        if (start2 != null || end != null) {
          ctx.beginPath();
          ctx.rect(x2, y2, width, height);
          if (end != null) {
            ctx.save();
            ctx.translate(_sx_end[i2], _sy_end[i2]);
            ctx.rotate(_angles[i2]);
            end.clip(ctx, i2);
            ctx.restore();
          }
          if (start2 != null) {
            ctx.save();
            ctx.translate(_sx_start[i2], _sy_start[i2]);
            ctx.rotate(_angles[i2] + Math.PI);
            start2.clip(ctx, i2);
            ctx.restore();
          }
          ctx.closePath();
          ctx.clip();
        }
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.beginPath();
        ctx.moveTo(_sx_start[i2], _sy_start[i2]);
        ctx.lineTo(_sx_end[i2], _sy_end[i2]);
        ctx.stroke();
        ctx.restore();
      }
    }
  }
}
ArrowView.__name__ = "ArrowView";
class Arrow extends DataAnnotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3D = Arrow;
Arrow.__name__ = "Arrow";
(() => {
  _a$3D.prototype.default_view = ArrowView;
  _a$3D.mixins(LineVector$1);
  _a$3D.define(({ Ref: Ref2, Nullable: Nullable2 }) => ({
    x_start: [XCoordinateSpec, { field: "x_start" }],
    y_start: [YCoordinateSpec, { field: "y_start" }],
    start_units: [SpatialUnits, "data"],
    start: [Nullable2(Ref2(ArrowHead)), null],
    x_end: [XCoordinateSpec, { field: "x_end" }],
    y_end: [YCoordinateSpec, { field: "y_end" }],
    end_units: [SpatialUnits, "data"],
    end: [Nullable2(Ref2(ArrowHead)), () => new OpenHead()]
  }));
})();
var _a$3C;
class UpperLowerView extends DataAnnotationView {
  map_data() {
    const { frame } = this.plot_view;
    const dim = this.model.dimension;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    const limit_scale = dim == "height" ? yscale : xscale;
    const base_scale = dim == "height" ? xscale : yscale;
    const limit_view = dim == "height" ? frame.bbox.yview : frame.bbox.xview;
    const base_view = dim == "height" ? frame.bbox.xview : frame.bbox.yview;
    let _lower_sx;
    if (this.model.properties.lower.units == "data")
      _lower_sx = limit_scale.v_compute(this._lower);
    else
      _lower_sx = limit_view.v_compute(this._lower);
    let _upper_sx;
    if (this.model.properties.upper.units == "data")
      _upper_sx = limit_scale.v_compute(this._upper);
    else
      _upper_sx = limit_view.v_compute(this._upper);
    let _base_sx;
    if (this.model.properties.base.units == "data")
      _base_sx = base_scale.v_compute(this._base);
    else
      _base_sx = base_view.v_compute(this._base);
    const [i2, j] = dim == "height" ? [1, 0] : [0, 1];
    const _lower = [_lower_sx, _base_sx];
    const _upper = [_upper_sx, _base_sx];
    this._lower_sx = _lower[i2];
    this._lower_sy = _lower[j];
    this._upper_sx = _upper[i2];
    this._upper_sy = _upper[j];
  }
}
UpperLowerView.__name__ = "UpperLowerView";
class XOrYCoordinateSpec extends CoordinateSpec {
  get dimension() {
    return this.obj.dimension == "width" ? "x" : "y";
  }
  get units() {
    var _a2;
    return (_a2 = this.spec.units) != null ? _a2 : "data";
  }
}
XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
class UpperLower extends DataAnnotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3C = UpperLower;
UpperLower.__name__ = "UpperLower";
(() => {
  _a$3C.define(() => ({
    dimension: [Dimension, "height"],
    lower: [XOrYCoordinateSpec, { field: "lower" }],
    upper: [XOrYCoordinateSpec, { field: "upper" }],
    base: [XOrYCoordinateSpec, { field: "base" }]
  }));
})();
var _a$3B;
class BandView extends UpperLowerView {
  paint(ctx) {
    ctx.beginPath();
    ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
    for (let i2 = 0, end = this._lower_sx.length; i2 < end; i2++) {
      ctx.lineTo(this._lower_sx[i2], this._lower_sy[i2]);
    }
    for (let i2 = this._upper_sx.length - 1; i2 >= 0; i2--) {
      ctx.lineTo(this._upper_sx[i2], this._upper_sy[i2]);
    }
    ctx.closePath();
    this.visuals.fill.apply(ctx);
    ctx.beginPath();
    ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
    for (let i2 = 0, end = this._lower_sx.length; i2 < end; i2++) {
      ctx.lineTo(this._lower_sx[i2], this._lower_sy[i2]);
    }
    this.visuals.line.apply(ctx);
    ctx.beginPath();
    ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
    for (let i2 = 0, end = this._upper_sx.length; i2 < end; i2++) {
      ctx.lineTo(this._upper_sx[i2], this._upper_sy[i2]);
    }
    this.visuals.line.apply(ctx);
  }
}
BandView.__name__ = "BandView";
class Band extends UpperLower {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3B = Band;
Band.__name__ = "Band";
(() => {
  _a$3B.prototype.default_view = BandView;
  _a$3B.mixins([Line$2, Fill$1]);
  _a$3B.override({
    fill_color: "#fff9ba",
    fill_alpha: 0.4,
    line_color: "#cccccc",
    line_alpha: 0.3
  });
})();
var _a$3A;
const EDGE_TOLERANCE = 2.5;
class BoxAnnotationView extends AnnotationView {
  constructor() {
    super(...arguments);
    this.bbox = new BBox$2();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { left: left2, right: right2, top, bottom } = this.model;
    if (left2 == null && right2 == null && top == null && bottom == null)
      return;
    const { frame } = this.plot_view;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    const _calc_dim = (dim, dim_units, scale, view, frame_extrema) => {
      let sdim;
      if (dim != null) {
        if (this.model.screen)
          sdim = dim;
        else {
          if (dim_units == "data")
            sdim = scale.compute(dim);
          else
            sdim = view.compute(dim);
        }
      } else
        sdim = frame_extrema;
      return sdim;
    };
    this.bbox = BBox$2.from_rect({
      left: _calc_dim(left2, this.model.left_units, xscale, frame.bbox.xview, frame.bbox.left),
      right: _calc_dim(right2, this.model.right_units, xscale, frame.bbox.xview, frame.bbox.right),
      top: _calc_dim(top, this.model.top_units, yscale, frame.bbox.yview, frame.bbox.top),
      bottom: _calc_dim(bottom, this.model.bottom_units, yscale, frame.bbox.yview, frame.bbox.bottom)
    });
    this._paint_box();
  }
  _paint_box() {
    const { ctx } = this.layer;
    ctx.save();
    const { left: left2, top, width, height } = this.bbox;
    ctx.beginPath();
    ctx.rect(left2, top, width, height);
    this.visuals.fill.apply(ctx);
    this.visuals.hatch.apply(ctx);
    this.visuals.line.apply(ctx);
    ctx.restore();
  }
  interactive_bbox() {
    const tolerance = this.model.line_width + EDGE_TOLERANCE;
    return this.bbox.grow_by(tolerance);
  }
  interactive_hit(sx, sy) {
    if (this.model.in_cursor == null)
      return false;
    const bbox = this.interactive_bbox();
    return bbox.contains(sx, sy);
  }
  cursor(sx, sy) {
    const tol = 3;
    const { left: left2, right: right2, bottom, top } = this.bbox;
    if (Math.abs(sx - left2) < tol || Math.abs(sx - right2) < tol)
      return this.model.ew_cursor;
    else if (Math.abs(sy - bottom) < tol || Math.abs(sy - top) < tol)
      return this.model.ns_cursor;
    else if (this.bbox.contains(sx, sy))
      return this.model.in_cursor;
    else
      return null;
  }
}
BoxAnnotationView.__name__ = "BoxAnnotationView";
class BoxAnnotation extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
  update({ left: left2, right: right2, top, bottom }) {
    this.setv({ left: left2, right: right2, top, bottom, screen: true });
  }
}
_a$3A = BoxAnnotation;
BoxAnnotation.__name__ = "BoxAnnotation";
(() => {
  _a$3A.prototype.default_view = BoxAnnotationView;
  _a$3A.mixins([Line$2, Fill$1, Hatch$1]);
  _a$3A.define(({ Number: Number2, Nullable: Nullable2 }) => ({
    top: [Nullable2(Number2), null],
    top_units: [SpatialUnits, "data"],
    bottom: [Nullable2(Number2), null],
    bottom_units: [SpatialUnits, "data"],
    left: [Nullable2(Number2), null],
    left_units: [SpatialUnits, "data"],
    right: [Nullable2(Number2), null],
    right_units: [SpatialUnits, "data"],
    render_mode: [RenderMode, "canvas"]
  }));
  _a$3A.internal(({ Boolean: Boolean2, String: String2, Nullable: Nullable2 }) => ({
    screen: [Boolean2, false],
    ew_cursor: [Nullable2(String2), null],
    ns_cursor: [Nullable2(String2), null],
    in_cursor: [Nullable2(String2), null]
  }));
  _a$3A.override({
    fill_color: "#fff9ba",
    fill_alpha: 0.4,
    line_color: "#cccccc",
    line_alpha: 0.3
  });
})();
const has_OffscreenCanvas = (() => {
  try {
    return typeof OffscreenCanvas !== "undefined" && new OffscreenCanvas(0, 0).getContext("2d") != null;
  } catch {
    return false;
  }
})();
const _offscreen_canvas = (() => {
  if (has_OffscreenCanvas)
    return (w, h2) => new OffscreenCanvas(w, h2);
  else {
    return (w, h2) => {
      const canvas2 = document.createElement("canvas");
      canvas2.width = w;
      canvas2.height = h2;
      return canvas2;
    };
  }
})();
const _native_font_metrics = (() => {
  const canvas2 = _offscreen_canvas(0, 0);
  const ctx = canvas2.getContext("2d");
  return (font) => {
    ctx.font = font;
    const cap_metrics = ctx.measureText("M");
    const x_metrics = ctx.measureText("x");
    const metrics = ctx.measureText("\xC5\u015Ag|");
    const font_ascent = metrics.fontBoundingBoxAscent;
    const font_descent = metrics.fontBoundingBoxDescent;
    if (font_ascent != null && font_descent != null) {
      return {
        height: font_ascent + font_descent,
        ascent: font_ascent,
        descent: font_descent,
        cap_height: cap_metrics.actualBoundingBoxAscent,
        x_height: x_metrics.actualBoundingBoxAscent
      };
    }
    const text_ascent = metrics.actualBoundingBoxAscent;
    const text_descent = metrics.actualBoundingBoxDescent;
    if (text_ascent != null && text_descent != null) {
      return {
        height: text_ascent + text_descent,
        ascent: text_ascent,
        descent: text_descent,
        cap_height: cap_metrics.actualBoundingBoxAscent,
        x_height: x_metrics.actualBoundingBoxAscent
      };
    }
    unreachable();
  };
})();
const _native_glyph_metrics = (() => {
  const canvas2 = _offscreen_canvas(0, 0);
  const ctx = canvas2.getContext("2d");
  return (glyph, font) => {
    ctx.font = font;
    const metrics = ctx.measureText(glyph);
    const glyph_ascent = metrics.actualBoundingBoxAscent;
    const glyph_descent = metrics.actualBoundingBoxDescent;
    if (glyph_ascent != null && glyph_descent != null) {
      return {
        width: metrics.width,
        height: glyph_ascent + glyph_descent,
        ascent: glyph_ascent,
        descent: glyph_descent
      };
    }
    unreachable();
  };
})();
const _internal_font_metrics = (() => {
  const canvas2 = document.createElement("canvas");
  const ctx = canvas2.getContext("2d");
  let cwidth = -1;
  let cheight = -1;
  return (font, scale = 1) => {
    ctx.font = font;
    const { width: _em } = ctx.measureText("M");
    const em = _em * scale;
    const width = Math.ceil(em);
    const height = Math.ceil(2 * em);
    const baseline = Math.ceil(1.5 * em);
    if (cwidth < width) {
      cwidth = width;
      canvas2.width = width;
    }
    if (cheight < height) {
      cheight = height;
      canvas2.height = height;
    }
    ctx.save();
    ctx.scale(scale, scale);
    ctx.fillStyle = "#f00";
    ctx.fillRect(0, 0, width, height);
    const measure_ascent = (data3) => {
      let k = 0;
      for (let i2 = 0; i2 <= baseline; i2++) {
        for (let j = 0; j < width; j++, k += 4)
          if (data3[k] != 255)
            return baseline - i2;
      }
      return 0;
    };
    const measure_descent = (data3) => {
      let k = data3.length - 4;
      for (let i2 = height; i2 >= baseline; i2--) {
        for (let j = 0; j < width; j++, k -= 4)
          if (data3[k] != 255)
            return i2 - baseline;
      }
      return 0;
    };
    ctx.font = font;
    ctx.fillStyle = "#000";
    for (const c of "xa") {
      ctx.fillText(c, 0, baseline / scale);
    }
    const { data: data0 } = ctx.getImageData(0, 0, width, height);
    const x_height = measure_ascent(data0) / scale;
    for (const c of "ASQ") {
      ctx.fillText(c, 0, baseline / scale);
    }
    const { data: data1 } = ctx.getImageData(0, 0, width, height);
    const cap_height = measure_ascent(data1) / scale;
    for (const c of "\xC5\u015Agy") {
      ctx.fillText(c, 0, baseline / scale);
    }
    const { data: data2 } = ctx.getImageData(0, 0, width, height);
    const ascent = measure_ascent(data2) / scale;
    const descent = measure_descent(data2) / scale;
    ctx.restore();
    return { height: ascent + descent, ascent, cap_height, x_height, descent };
  };
})();
const _internal_glyph_metrics = (() => {
  const canvas2 = document.createElement("canvas");
  const ctx = canvas2.getContext("2d");
  let cwidth = -1;
  let cheight = -1;
  return (glyph, font, scale = 1) => {
    ctx.font = font;
    const { width: _em } = ctx.measureText("M");
    const em = _em * scale;
    const width = Math.ceil(em);
    const height = Math.ceil(2 * em);
    const baseline = Math.ceil(1.5 * em);
    if (cwidth < width || cheight < height) {
      cwidth = width;
      canvas2.width = width;
      cheight = height;
      canvas2.height = height;
    }
    ctx.save();
    ctx.scale(scale, scale);
    ctx.fillStyle = "#f00";
    ctx.fillRect(0, 0, width, height);
    const measure_ascent = (data3) => {
      let k = 0;
      for (let i2 = 0; i2 <= baseline; i2++) {
        for (let j = 0; j < width; j++, k += 4)
          if (data3[k] != 255)
            return baseline - i2;
      }
      return 0;
    };
    const measure_descent = (data3) => {
      let k = data3.length - 4;
      for (let i2 = height; i2 >= baseline; i2--) {
        for (let j = 0; j < width; j++, k -= 4)
          if (data3[k] != 255)
            return i2 - baseline;
      }
      return 0;
    };
    ctx.font = font;
    ctx.fillStyle = "#000";
    ctx.fillText(glyph, 0, baseline / scale);
    const size2 = ctx.measureText(glyph);
    const { data: data2 } = ctx.getImageData(0, 0, width, height);
    const ascent = measure_ascent(data2) / scale;
    const descent = measure_descent(data2) / scale;
    ctx.restore();
    return { width: size2.width, height: ascent + descent, ascent, descent };
  };
})();
const _font_metrics = (() => {
  try {
    _native_font_metrics("normal 10px sans-serif");
    return _native_font_metrics;
  } catch {
    return _internal_font_metrics;
  }
})();
(() => {
  try {
    _native_glyph_metrics("A", "normal 10px sans-serif");
    return _native_glyph_metrics;
  } catch {
    return _internal_glyph_metrics;
  }
})();
const _metrics_cache = /* @__PURE__ */ new Map();
function font_metrics(font) {
  let metrics = _metrics_cache.get(font);
  if (metrics == null) {
    metrics = { font: _font_metrics(font), glyphs: /* @__PURE__ */ new Map() };
    _metrics_cache.set(font, metrics);
  }
  return metrics.font;
}
function parse_css_font_size(size2) {
  const match2 = size2.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);
  if (match2 != null) {
    const [, value, , unit] = match2;
    const number = Number(value);
    if (isFinite(number))
      return { value: number, unit };
  }
  return null;
}
const { sin, cos } = Math;
class AffineTransform {
  constructor(a2 = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
    this.a = a2;
    this.b = b;
    this.c = c;
    this.d = d;
    this.e = e;
    this.f = f;
  }
  toString() {
    const { a: a2, b, c, d, e, f } = this;
    return `matrix(${a2}, ${b}, ${c}, ${d}, ${e}, ${f})`;
  }
  static from_DOMMatrix(matrix) {
    const { a: a2, b, c, d, e, f } = matrix;
    return new AffineTransform(a2, b, c, d, e, f);
  }
  to_DOMMatrix() {
    const { a: a2, b, c, d, e, f } = this;
    return new DOMMatrix([a2, b, c, d, e, f]);
  }
  clone() {
    const { a: a2, b, c, d, e, f } = this;
    return new AffineTransform(a2, b, c, d, e, f);
  }
  get is_identity() {
    const { a: a2, b, c, d, e, f } = this;
    return a2 == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
  }
  apply_point(p2) {
    const [x2, y2] = this.apply(p2.x, p2.y);
    return { x: x2, y: y2 };
  }
  apply_rect(rect2) {
    const p0 = this.apply_point(rect2.p0);
    const p1 = this.apply_point(rect2.p1);
    const p2 = this.apply_point(rect2.p2);
    const p3 = this.apply_point(rect2.p3);
    return { p0, p1, p2, p3 };
  }
  apply(x2, y2) {
    const { a: a2, b, c, d, e, f } = this;
    return [
      a2 * x2 + c * y2 + e,
      b * x2 + d * y2 + f
    ];
  }
  iv_apply(xs, ys) {
    const { a: a2, b, c, d, e, f } = this;
    const n2 = xs.length;
    for (let i2 = 0; i2 < n2; i2++) {
      const x2 = xs[i2];
      const y2 = ys[i2];
      xs[i2] = a2 * x2 + c * y2 + e;
      ys[i2] = b * x2 + d * y2 + f;
    }
  }
  transform(A, B, C, D, E, F) {
    const { a: a2, b, c, d, e, f } = this;
    this.a = a2 * A + c * B;
    this.c = a2 * C + c * D;
    this.e = a2 * E + c * F + e;
    this.b = b * A + d * B;
    this.d = b * C + d * D;
    this.f = b * E + d * F + f;
    return this;
  }
  translate(tx, ty) {
    return this.transform(1, 0, 0, 1, tx, ty);
  }
  scale(cx, cy) {
    return this.transform(cx, 0, 0, cy, 0, 0);
  }
  skew(sx, sy) {
    return this.transform(1, sy, sx, 1, 0, 0);
  }
  rotate(angle) {
    const s = sin(angle);
    const c = cos(angle);
    return this.transform(c, s, -s, c, 0, 0);
  }
  rotate_ccw(angle) {
    return this.rotate(-angle);
  }
  translate_x(tx) {
    return this.translate(tx, 0);
  }
  translate_y(ty) {
    return this.translate(0, ty);
  }
  flip() {
    return this.scale(-1, -1);
  }
  flip_x() {
    return this.scale(1, -1);
  }
  flip_y() {
    return this.scale(-1, 1);
  }
}
AffineTransform.__name__ = "AffineTransform";
const text_width = (() => {
  const canvas2 = document.createElement("canvas");
  const ctx = canvas2.getContext("2d");
  let current_font = "";
  return (text, font) => {
    if (font != current_font) {
      current_font = font;
      ctx.font = font;
    }
    return ctx.measureText(text).width;
  };
})();
class GraphicsBox {
  constructor() {
    this._position = { sx: 0, sy: 0 };
    this.font_size_scale = 1;
    this.align = "left";
    this._base_font_size = 13;
    this._x_anchor = "left";
    this._y_anchor = "center";
  }
  set base_font_size(v) {
    if (v != null)
      this._base_font_size = v;
  }
  get base_font_size() {
    return this._base_font_size;
  }
  set position(p2) {
    this._position = p2;
  }
  get position() {
    return this._position;
  }
  infer_text_height() {
    return "ascent_descent";
  }
  bbox() {
    const { p0, p1, p2, p3 } = this.rect();
    const left2 = Math.min(p0.x, p1.x, p2.x, p3.x);
    const top = Math.min(p0.y, p1.y, p2.y, p3.y);
    const right2 = Math.max(p0.x, p1.x, p2.x, p3.x);
    const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
    return new BBox$2({ left: left2, right: right2, top, bottom });
  }
  size() {
    const { width, height } = this._size();
    const { angle } = this;
    if (!angle)
      return { width, height };
    else {
      const c = Math.cos(Math.abs(angle));
      const s = Math.sin(Math.abs(angle));
      return {
        width: Math.abs(width * c + height * s),
        height: Math.abs(width * s + height * c)
      };
    }
  }
  rect() {
    const rect2 = this._rect();
    const { angle } = this;
    if (!angle)
      return rect2;
    else {
      const { sx, sy } = this.position;
      const tr = new AffineTransform();
      tr.translate(sx, sy);
      tr.rotate(angle);
      tr.translate(-sx, -sy);
      return tr.apply_rect(rect2);
    }
  }
  paint_rect(ctx) {
    const { p0, p1, p2, p3 } = this.rect();
    ctx.save();
    ctx.strokeStyle = "red";
    ctx.lineWidth = 1;
    ctx.beginPath();
    const { round: round2 } = Math;
    ctx.moveTo(round2(p0.x), round2(p0.y));
    ctx.lineTo(round2(p1.x), round2(p1.y));
    ctx.lineTo(round2(p2.x), round2(p2.y));
    ctx.lineTo(round2(p3.x), round2(p3.y));
    ctx.closePath();
    ctx.stroke();
    ctx.restore();
  }
  paint_bbox(ctx) {
    const { x: x2, y: y2, width, height } = this.bbox();
    ctx.save();
    ctx.strokeStyle = "blue";
    ctx.lineWidth = 1;
    ctx.beginPath();
    const { round: round2 } = Math;
    ctx.moveTo(round2(x2), round2(y2));
    ctx.lineTo(round2(x2), round2(y2 + height));
    ctx.lineTo(round2(x2 + width), round2(y2 + height));
    ctx.lineTo(round2(x2 + width), round2(y2));
    ctx.closePath();
    ctx.stroke();
    ctx.restore();
  }
}
GraphicsBox.__name__ = "GraphicsBox";
class TextBox extends GraphicsBox {
  constructor({ text }) {
    super();
    this.text = text;
  }
  set visuals(v) {
    const color = v.color;
    const alpha = v.alpha;
    const style2 = v.font_style;
    let size2 = v.font_size;
    const face = v.font;
    const { font_size_scale, base_font_size } = this;
    const res = parse_css_font_size(size2);
    if (res != null) {
      let { value, unit } = res;
      value *= font_size_scale;
      if (unit == "em" && base_font_size) {
        value *= base_font_size;
        unit = "px";
      }
      size2 = `${value}${unit}`;
    }
    const font = `${style2} ${size2} ${face}`;
    this.font = font;
    this.color = color2css(color, alpha);
    this.line_height = v.line_height;
    const align = v.align;
    this._x_anchor = align;
    const baseline = v.baseline;
    this._y_anchor = (() => {
      switch (baseline) {
        case "top":
          return "top";
        case "middle":
          return "center";
        case "bottom":
          return "bottom";
        default:
          return "baseline";
      }
    })();
  }
  infer_text_height() {
    if (this.text.includes("\n"))
      return "ascent_descent";
    else {
      let is_math_like = function(text) {
        for (const c of new Set(text)) {
          if ("0" <= c && c <= "9")
            continue;
          switch (c) {
            case ",":
            case ".":
            case "+":
            case "-":
            case "\u2212":
            case "e":
              continue;
            default:
              return false;
          }
        }
        return true;
      };
      if (is_math_like(this.text))
        return "cap";
      else
        return "ascent_descent";
    }
  }
  _text_line(fmetrics) {
    var _a2;
    const metric = (_a2 = this.text_height_metric) != null ? _a2 : this.infer_text_height();
    const ascent = (() => {
      switch (metric) {
        case "x":
        case "x_descent":
          return fmetrics.x_height;
        case "cap":
        case "cap_descent":
          return fmetrics.cap_height;
        case "ascent":
        case "ascent_descent":
          return fmetrics.ascent;
      }
    })();
    const descent = (() => {
      switch (metric) {
        case "x":
        case "cap":
        case "ascent":
          return 0;
        case "x_descent":
        case "cap_descent":
        case "ascent_descent":
          return fmetrics.descent;
      }
    })();
    return { height: ascent + descent, ascent, descent };
  }
  get nlines() {
    const lines = this.text.split("\n");
    return lines.length;
  }
  _size() {
    var _a2, _b2;
    const { font } = this;
    const fmetrics = font_metrics(font);
    const line_spacing = (this.line_height - 1) * fmetrics.height;
    const empty2 = this.text == "";
    const lines = this.text.split("\n");
    const nlines = lines.length;
    const widths = lines.map((line) => text_width(line, font));
    const text_line = this._text_line(fmetrics);
    const text_height = text_line.height * nlines;
    const w_scale = ((_a2 = this.width) == null ? void 0 : _a2.unit) == "%" ? this.width.value : 1;
    const h_scale = ((_b2 = this.height) == null ? void 0 : _b2.unit) == "%" ? this.height.value : 1;
    const width = max$8(widths) * w_scale;
    const height = empty2 ? 0 : (text_height + line_spacing * (nlines - 1)) * h_scale;
    return { width, height, metrics: fmetrics };
  }
  _computed_position(size2, metrics, nlines) {
    const { width, height } = size2;
    const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
    const x2 = sx - (() => {
      if (isNumber(x_anchor))
        return x_anchor * width;
      else {
        switch (x_anchor) {
          case "left":
            return 0;
          case "center":
            return 0.5 * width;
          case "right":
            return width;
        }
      }
    })();
    const y2 = sy - (() => {
      var _a2;
      if (isNumber(y_anchor))
        return y_anchor * height;
      else {
        switch (y_anchor) {
          case "top":
            return 0;
          case "center":
            return 0.5 * height;
          case "bottom":
            return height;
          case "baseline": {
            if (nlines == 1) {
              const metric = (_a2 = this.text_height_metric) != null ? _a2 : this.infer_text_height();
              switch (metric) {
                case "x":
                case "x_descent":
                  return metrics.x_height;
                case "cap":
                case "cap_descent":
                  return metrics.cap_height;
                case "ascent":
                case "ascent_descent":
                  return metrics.ascent;
              }
            } else
              return 0.5 * height;
          }
        }
      }
    })();
    return { x: x2, y: y2 };
  }
  _rect() {
    const { width, height, metrics } = this._size();
    const nlines = this.text.split("\n").length;
    const { x: x2, y: y2 } = this._computed_position({ width, height }, metrics, nlines);
    const bbox = new BBox$2({ x: x2, y: y2, width, height });
    return bbox.rect;
  }
  paint(ctx) {
    var _a2, _b2;
    const { font } = this;
    const fmetrics = font_metrics(font);
    const line_spacing = (this.line_height - 1) * fmetrics.height;
    const lines = this.text.split("\n");
    const nlines = lines.length;
    const widths = lines.map((line) => text_width(line, font));
    const text_line = this._text_line(fmetrics);
    const text_height = text_line.height * nlines;
    const w_scale = ((_a2 = this.width) == null ? void 0 : _a2.unit) == "%" ? this.width.value : 1;
    const h_scale = ((_b2 = this.height) == null ? void 0 : _b2.unit) == "%" ? this.height.value : 1;
    const width = max$8(widths) * w_scale;
    const height = (text_height + line_spacing * (nlines - 1)) * h_scale;
    ctx.save();
    ctx.fillStyle = this.color;
    ctx.font = this.font;
    ctx.textAlign = "left";
    ctx.textBaseline = "alphabetic";
    const { sx, sy } = this.position;
    const { align } = this;
    const { angle } = this;
    if (angle) {
      ctx.translate(sx, sy);
      ctx.rotate(angle);
      ctx.translate(-sx, -sy);
    }
    let { x: x2, y: y2 } = this._computed_position({ width, height }, fmetrics, nlines);
    if (align == "justify") {
      for (let i2 = 0; i2 < nlines; i2++) {
        let xij = x2;
        const line = lines[i2];
        const words = line.split(" ");
        const nwords = words.length;
        const word_widths = words.map((word) => text_width(word, font));
        const word_spacing = (width - sum$2(word_widths)) / (nwords - 1);
        for (let j = 0; j < nwords; j++) {
          ctx.fillText(words[j], xij, y2);
          xij += word_widths[j] + word_spacing;
        }
        y2 += text_line.height + line_spacing;
      }
    } else {
      for (let i2 = 0; i2 < nlines; i2++) {
        const xi = x2 + (() => {
          switch (align) {
            case "left":
              return 0;
            case "center":
              return 0.5 * (width - widths[i2]);
            case "right":
              return width - widths[i2];
          }
        })();
        ctx.fillStyle = this.color;
        ctx.fillText(lines[i2], xi, y2 + text_line.ascent);
        y2 += text_line.height + line_spacing;
      }
    }
    ctx.restore();
  }
}
TextBox.__name__ = "TextBox";
class BaseExpo extends GraphicsBox {
  constructor(base, expo) {
    super();
    this.base = base;
    this.expo = expo;
  }
  get children() {
    return [this.base, this.expo];
  }
  set base_font_size(v) {
    super.base_font_size = v;
    this.base.base_font_size = v;
    this.expo.base_font_size = v;
  }
  set position(p2) {
    this._position = p2;
    const bs = this.base.size();
    const es = this.expo.size();
    const shift = this._shift_scale() * bs.height;
    const height = Math.max(bs.height, shift + es.height);
    this.base.position = {
      sx: 0,
      x_anchor: "left",
      sy: height,
      y_anchor: "bottom"
    };
    this.expo.position = {
      sx: bs.width,
      x_anchor: "left",
      sy: shift,
      y_anchor: "bottom"
    };
  }
  get position() {
    return this._position;
  }
  set visuals(v) {
    this.expo.font_size_scale = 0.7;
    this.base.visuals = v;
    this.expo.visuals = v;
  }
  _shift_scale() {
    if (this.base instanceof TextBox && this.base.nlines == 1) {
      const { x_height, cap_height } = font_metrics(this.base.font);
      return x_height / cap_height;
    } else {
      return 2 / 3;
    }
  }
  infer_text_height() {
    return this.base.infer_text_height();
  }
  _rect() {
    const bb = this.base.bbox();
    const eb = this.expo.bbox();
    const bbox = bb.union(eb);
    const { x: x2, y: y2 } = this._computed_position();
    return bbox.translate(x2, y2).rect;
  }
  _size() {
    const bs = this.base.size();
    const es = this.expo.size();
    return {
      width: bs.width + es.width,
      height: Math.max(bs.height, this._shift_scale() * bs.height + es.height)
    };
  }
  paint(ctx) {
    ctx.save();
    const { angle } = this;
    if (angle) {
      const { sx, sy } = this.position;
      ctx.translate(sx, sy);
      ctx.rotate(angle);
      ctx.translate(-sx, -sy);
    }
    const { x: x2, y: y2 } = this._computed_position();
    ctx.translate(x2, y2);
    this.base.paint(ctx);
    this.expo.paint(ctx);
    ctx.restore();
  }
  paint_bbox(ctx) {
    super.paint_bbox(ctx);
    const { x: x2, y: y2 } = this._computed_position();
    ctx.save();
    ctx.translate(x2, y2);
    for (const child of this.children) {
      child.paint_bbox(ctx);
    }
    ctx.restore();
  }
  _computed_position() {
    const { width, height } = this._size();
    const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
    const x2 = sx - (() => {
      if (isNumber(x_anchor))
        return x_anchor * width;
      else {
        switch (x_anchor) {
          case "left":
            return 0;
          case "center":
            return 0.5 * width;
          case "right":
            return width;
        }
      }
    })();
    const y2 = sy - (() => {
      if (isNumber(y_anchor))
        return y_anchor * height;
      else {
        switch (y_anchor) {
          case "top":
            return 0;
          case "center":
            return 0.5 * height;
          case "bottom":
            return height;
          case "baseline":
            return 0.5 * height;
        }
      }
    })();
    return { x: x2, y: y2 };
  }
}
BaseExpo.__name__ = "BaseExpo";
class GraphicsBoxes {
  constructor(items) {
    this.items = items;
  }
  set base_font_size(v) {
    for (const item of this.items) {
      item.base_font_size = v;
    }
  }
  get length() {
    return this.items.length;
  }
  set visuals(v) {
    for (const item of this.items) {
      item.visuals = v;
    }
    const metric_map = { x: 0, cap: 1, ascent: 2, x_descent: 3, cap_descent: 4, ascent_descent: 5 };
    const common = max_by(this.items.map((item) => item.infer_text_height()), (metric) => metric_map[metric]);
    for (const item of this.items) {
      item.text_height_metric = common;
    }
  }
  set angle(a2) {
    for (const item of this.items) {
      item.angle = a2;
    }
  }
  max_size() {
    let width = 0;
    let height = 0;
    for (const item of this.items) {
      const size2 = item.size();
      width = Math.max(width, size2.width);
      height = Math.max(height, size2.height);
    }
    return { width, height };
  }
}
GraphicsBoxes.__name__ = "GraphicsBoxes";
const { min: min$3, max: max$5 } = Math;
class Sizeable {
  constructor(size2 = {}) {
    this.width = size2.width != null ? size2.width : 0;
    this.height = size2.height != null ? size2.height : 0;
  }
  bounded_to({ width, height }) {
    return new Sizeable({
      width: this.width == Infinity && width != null ? width : this.width,
      height: this.height == Infinity && height != null ? height : this.height
    });
  }
  expanded_to({ width, height }) {
    return new Sizeable({
      width: width != Infinity ? max$5(this.width, width) : this.width,
      height: height != Infinity ? max$5(this.height, height) : this.height
    });
  }
  expand_to({ width, height }) {
    this.width = max$5(this.width, width);
    this.height = max$5(this.height, height);
  }
  narrowed_to({ width, height }) {
    return new Sizeable({
      width: min$3(this.width, width),
      height: min$3(this.height, height)
    });
  }
  narrow_to({ width, height }) {
    this.width = min$3(this.width, width);
    this.height = min$3(this.height, height);
  }
  grow_by({ left: left2, right: right2, top, bottom }) {
    const width = this.width + left2 + right2;
    const height = this.height + top + bottom;
    return new Sizeable({ width, height });
  }
  shrink_by({ left: left2, right: right2, top, bottom }) {
    const width = max$5(this.width - left2 - right2, 0);
    const height = max$5(this.height - top - bottom, 0);
    return new Sizeable({ width, height });
  }
  map(w_fn, h_fn) {
    return new Sizeable({
      width: w_fn(this.width),
      height: (h_fn != null ? h_fn : w_fn)(this.height)
    });
  }
}
Sizeable.__name__ = "Sizeable";
const SizingPolicy = Enum("fixed", "fit", "min", "max");
const { min: min$2, max: max$4, round: round$2 } = Math;
class Layoutable {
  constructor() {
    this.absolute = false;
    this._bbox = new BBox$2();
    this._inner_bbox = new BBox$2();
    this._dirty = false;
    this._handlers = [];
  }
  *[Symbol.iterator]() {
  }
  get bbox() {
    return this._bbox;
  }
  get inner_bbox() {
    return this._inner_bbox;
  }
  get sizing() {
    return this._sizing;
  }
  set visible(visible) {
    this._sizing.visible = visible;
    this._dirty = true;
  }
  set_sizing(sizing) {
    var _a2, _b2, _c2, _d2, _e2;
    const width_policy = (_a2 = sizing.width_policy) != null ? _a2 : "fit";
    const width = sizing.width;
    const min_width = sizing.min_width;
    const max_width = sizing.max_width;
    const height_policy = (_b2 = sizing.height_policy) != null ? _b2 : "fit";
    const height = sizing.height;
    const min_height = sizing.min_height;
    const max_height = sizing.max_height;
    const aspect = sizing.aspect;
    const margin = (_c2 = sizing.margin) != null ? _c2 : { top: 0, right: 0, bottom: 0, left: 0 };
    const visible = sizing.visible !== false;
    const halign = (_d2 = sizing.halign) != null ? _d2 : "start";
    const valign = (_e2 = sizing.valign) != null ? _e2 : "start";
    this._sizing = {
      width_policy,
      min_width,
      width,
      max_width,
      height_policy,
      min_height,
      height,
      max_height,
      aspect,
      margin,
      visible,
      halign,
      valign,
      size: { width, height }
    };
    this._init();
  }
  _init() {
  }
  _set_geometry(outer, inner) {
    this._bbox = outer;
    this._inner_bbox = inner;
  }
  set_geometry(outer, inner) {
    const { fixup_geometry } = this;
    if (fixup_geometry != null) {
      [outer, inner] = fixup_geometry(outer, inner);
    }
    this._set_geometry(outer, inner != null ? inner : outer);
    for (const handler of this._handlers) {
      handler(this._bbox, this._inner_bbox);
    }
  }
  on_resize(handler) {
    this._handlers.push(handler);
  }
  is_width_expanding() {
    return this.sizing.width_policy == "max";
  }
  is_height_expanding() {
    return this.sizing.height_policy == "max";
  }
  apply_aspect(viewport, { width, height }) {
    const { aspect } = this.sizing;
    if (aspect != null) {
      const { width_policy, height_policy } = this.sizing;
      const gt = (width2, height2) => {
        const policies = { max: 4, fit: 3, min: 2, fixed: 1 };
        return policies[width2] > policies[height2];
      };
      if (width_policy != "fixed" && height_policy != "fixed") {
        if (width_policy == height_policy) {
          const w_width = width;
          const w_height = round$2(width / aspect);
          const h_width = round$2(height * aspect);
          const h_height = height;
          const w_diff = Math.abs(viewport.width - w_width) + Math.abs(viewport.height - w_height);
          const h_diff = Math.abs(viewport.width - h_width) + Math.abs(viewport.height - h_height);
          if (w_diff <= h_diff) {
            width = w_width;
            height = w_height;
          } else {
            width = h_width;
            height = h_height;
          }
        } else if (gt(width_policy, height_policy)) {
          height = round$2(width / aspect);
        } else {
          width = round$2(height * aspect);
        }
      } else if (width_policy == "fixed") {
        height = round$2(width / aspect);
      } else if (height_policy == "fixed") {
        width = round$2(height * aspect);
      }
    }
    return { width, height };
  }
  measure(viewport_size) {
    if (!this.sizing.visible)
      return { width: 0, height: 0 };
    const exact_width = (width2) => {
      return this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : width2;
    };
    const exact_height = (height2) => {
      return this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : height2;
    };
    const viewport = new Sizeable(viewport_size).shrink_by(this.sizing.margin).map(exact_width, exact_height);
    const computed = this._measure(viewport);
    const clipped = this.clip_size(computed, viewport);
    const width = exact_width(clipped.width);
    const height = exact_height(clipped.height);
    const size2 = this.apply_aspect(viewport, { width, height });
    return { ...computed, ...size2 };
  }
  compute(viewport = {}) {
    const size_hint = this.measure({
      width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
      height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity
    });
    const { width, height } = size_hint;
    const outer = new BBox$2({ left: 0, top: 0, width, height });
    let inner = void 0;
    if (size_hint.inner != null) {
      const { left: left2, top, right: right2, bottom } = size_hint.inner;
      inner = new BBox$2({ left: left2, top, right: width - right2, bottom: height - bottom });
    }
    this.set_geometry(outer, inner);
  }
  get xview() {
    return this.bbox.xview;
  }
  get yview() {
    return this.bbox.yview;
  }
  clip_size(size2, viewport) {
    function clip(size3, vsize, min_size, max_size) {
      if (min_size == null)
        min_size = 0;
      else if (!isNumber(min_size))
        min_size = Math.round(min_size.percent * vsize);
      if (max_size == null)
        max_size = Infinity;
      else if (!isNumber(max_size))
        max_size = Math.round(max_size.percent * vsize);
      return max$4(min_size, min$2(size3, max_size));
    }
    return {
      width: clip(size2.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
      height: clip(size2.height, viewport.height, this.sizing.min_height, this.sizing.max_height)
    };
  }
  has_size_changed() {
    const { _dirty } = this;
    this._dirty = false;
    return _dirty;
  }
}
Layoutable.__name__ = "Layoutable";
class LayoutItem extends Layoutable {
  _measure(viewport) {
    const { width_policy, height_policy } = this.sizing;
    const width = (() => {
      const { width: width2 } = this.sizing;
      if (viewport.width == Infinity) {
        return width2 != null ? width2 : 0;
      } else {
        switch (width_policy) {
          case "fixed":
            return width2 != null ? width2 : 0;
          case "min":
            return width2 != null ? min$2(viewport.width, width2) : 0;
          case "fit":
            return width2 != null ? min$2(viewport.width, width2) : viewport.width;
          case "max":
            return width2 != null ? max$4(viewport.width, width2) : viewport.width;
        }
      }
    })();
    const height = (() => {
      const { height: height2 } = this.sizing;
      if (viewport.height == Infinity) {
        return height2 != null ? height2 : 0;
      } else {
        switch (height_policy) {
          case "fixed":
            return height2 != null ? height2 : 0;
          case "min":
            return height2 != null ? min$2(viewport.height, height2) : 0;
          case "fit":
            return height2 != null ? min$2(viewport.height, height2) : viewport.height;
          case "max":
            return height2 != null ? max$4(viewport.height, height2) : viewport.height;
        }
      }
    })();
    return { width, height };
  }
}
LayoutItem.__name__ = "LayoutItem";
class ContentLayoutable extends Layoutable {
  _measure(viewport) {
    const content_size2 = this._content_size();
    const bounds = viewport.bounded_to(this.sizing.size).bounded_to(content_size2);
    const width = (() => {
      switch (this.sizing.width_policy) {
        case "fixed":
          return this.sizing.width != null ? this.sizing.width : content_size2.width;
        case "min":
          return content_size2.width;
        case "fit":
          return bounds.width;
        case "max":
          return Math.max(content_size2.width, bounds.width);
      }
    })();
    const height = (() => {
      switch (this.sizing.height_policy) {
        case "fixed":
          return this.sizing.height != null ? this.sizing.height : content_size2.height;
        case "min":
          return content_size2.height;
        case "fit":
          return bounds.height;
        case "max":
          return Math.max(content_size2.height, bounds.height);
      }
    })();
    return { width, height };
  }
}
ContentLayoutable.__name__ = "ContentLayoutable";
const pi2 = Math.PI / 2;
const _angle_lookup = {
  above: {
    parallel: 0,
    normal: -pi2,
    horizontal: 0,
    vertical: -pi2
  },
  below: {
    parallel: 0,
    normal: pi2,
    horizontal: 0,
    vertical: pi2
  },
  left: {
    parallel: -pi2,
    normal: 0,
    horizontal: 0,
    vertical: -pi2
  },
  right: {
    parallel: pi2,
    normal: 0,
    horizontal: 0,
    vertical: pi2
  }
};
const _vertical_align_lookup = {
  above: {
    parallel: "bottom",
    normal: "center",
    horizontal: "bottom",
    vertical: "center"
  },
  below: {
    parallel: "top",
    normal: "center",
    horizontal: "top",
    vertical: "center"
  },
  left: {
    parallel: "bottom",
    normal: "center",
    horizontal: "center",
    vertical: "bottom"
  },
  right: {
    parallel: "bottom",
    normal: "center",
    horizontal: "center",
    vertical: "bottom"
  }
};
const _align_lookup = {
  above: {
    parallel: "center",
    normal: "left",
    horizontal: "center",
    vertical: "left"
  },
  below: {
    parallel: "center",
    normal: "left",
    horizontal: "center",
    vertical: "left"
  },
  left: {
    parallel: "center",
    normal: "right",
    horizontal: "right",
    vertical: "center"
  },
  right: {
    parallel: "center",
    normal: "left",
    horizontal: "left",
    vertical: "center"
  }
};
const _align_lookup_negative = {
  above: "right",
  below: "left",
  left: "right",
  right: "left"
};
const _align_lookup_positive = {
  above: "left",
  below: "right",
  left: "right",
  right: "left"
};
class Panel$1 {
  constructor(side) {
    this.side = side;
  }
  get dimension() {
    return this.side == "above" || this.side == "below" ? 0 : 1;
  }
  get normals() {
    switch (this.side) {
      case "above":
        return [0, -1];
      case "below":
        return [0, 1];
      case "left":
        return [-1, 0];
      case "right":
        return [1, 0];
    }
  }
  get orientation() {
    return this.is_horizontal ? "horizontal" : "vertical";
  }
  get is_horizontal() {
    return this.dimension == 0;
  }
  get is_vertical() {
    return this.dimension == 1;
  }
  get_label_text_heuristics(orient) {
    const { side } = this;
    if (isString(orient)) {
      return {
        vertical_align: _vertical_align_lookup[side][orient],
        align: _align_lookup[side][orient]
      };
    } else {
      return {
        vertical_align: "center",
        align: (orient < 0 ? _align_lookup_negative : _align_lookup_positive)[side]
      };
    }
  }
  get_label_angle_heuristic(orient) {
    if (isString(orient))
      return _angle_lookup[this.side][orient];
    else
      return -orient;
  }
}
Panel$1.__name__ = "Panel";
class SideLayout extends ContentLayoutable {
  constructor(panel, get_size, rotate = false) {
    super();
    this.panel = panel;
    this.get_size = get_size;
    this.rotate = rotate;
    if (this.panel.is_horizontal)
      this.set_sizing({ width_policy: "max", height_policy: "fixed" });
    else
      this.set_sizing({ width_policy: "fixed", height_policy: "max" });
  }
  _content_size() {
    const { width, height } = this.get_size();
    if (!this.rotate || this.panel.is_horizontal)
      return new Sizeable({ width, height });
    else
      return new Sizeable({ width: height, height: width });
  }
  has_size_changed() {
    const { width, height } = this._content_size();
    if (this.panel.is_horizontal)
      return this.bbox.height != height;
    else
      return this.bbox.width != width;
  }
}
SideLayout.__name__ = "SideLayout";
var _a$3z;
class TextAnnotationView extends AnnotationView {
  update_layout() {
    const { panel } = this;
    if (panel != null)
      this.layout = new SideLayout(panel, () => this.get_size(), true);
    else
      this.layout = void 0;
  }
  initialize() {
    super.initialize();
    if (this.model.render_mode == "css") {
      this.el = div();
      this.plot_view.canvas_view.add_overlay(this.el);
    }
  }
  remove() {
    if (this.el != null)
      remove(this.el);
    super.remove();
  }
  connect_signals() {
    super.connect_signals();
    if (this.model.render_mode == "css") {
      this.connect(this.model.change, () => this.render());
    } else {
      this.connect(this.model.change, () => this.request_render());
    }
  }
  render() {
    if (!this.model.visible && this.model.render_mode == "css")
      undisplay(this.el);
    super.render();
  }
  _canvas_text(ctx, text, sx, sy, angle) {
    const graphics = new TextBox({ text });
    graphics.angle = angle;
    graphics.position = { sx, sy };
    graphics.visuals = this.visuals.text.values();
    const { background_fill, border_line } = this.visuals;
    if (background_fill.doit || border_line.doit) {
      const { p0, p1, p2, p3 } = graphics.rect();
      ctx.beginPath();
      ctx.moveTo(p0.x, p0.y);
      ctx.lineTo(p1.x, p1.y);
      ctx.lineTo(p2.x, p2.y);
      ctx.lineTo(p3.x, p3.y);
      ctx.closePath();
      this.visuals.background_fill.apply(ctx);
      this.visuals.border_line.apply(ctx);
    }
    if (this.visuals.text.doit)
      graphics.paint(ctx);
  }
  _css_text(ctx, text, sx, sy, angle) {
    const { el } = this;
    assert(el != null);
    undisplay(el);
    el.textContent = text;
    this.visuals.text.set_value(ctx);
    el.style.position = "absolute";
    el.style.left = `${sx}px`;
    el.style.top = `${sy}px`;
    el.style.color = ctx.fillStyle;
    el.style.font = ctx.font;
    el.style.lineHeight = "normal";
    el.style.whiteSpace = "pre";
    const [x_anchor, x_t] = (() => {
      switch (this.visuals.text.text_align.get_value()) {
        case "left":
          return ["left", "0%"];
        case "center":
          return ["center", "-50%"];
        case "right":
          return ["right", "-100%"];
      }
    })();
    const [y_anchor, y_t] = (() => {
      switch (this.visuals.text.text_baseline.get_value()) {
        case "top":
          return ["top", "0%"];
        case "middle":
          return ["center", "-50%"];
        case "bottom":
          return ["bottom", "-100%"];
        default:
          return ["center", "-50%"];
      }
    })();
    let transform2 = `translate(${x_t}, ${y_t})`;
    if (angle) {
      transform2 += `rotate(${angle}rad)`;
    }
    el.style.transformOrigin = `${x_anchor} ${y_anchor}`;
    el.style.transform = transform2;
    if (this.layout == null)
      ;
    if (this.visuals.background_fill.doit) {
      this.visuals.background_fill.set_value(ctx);
      el.style.backgroundColor = ctx.fillStyle;
    }
    if (this.visuals.border_line.doit) {
      this.visuals.border_line.set_value(ctx);
      el.style.borderStyle = ctx.lineDash.length < 2 ? "solid" : "dashed";
      el.style.borderWidth = `${ctx.lineWidth}px`;
      el.style.borderColor = ctx.strokeStyle;
    }
    display(el);
  }
}
TextAnnotationView.__name__ = "TextAnnotationView";
class TextAnnotation extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3z = TextAnnotation;
TextAnnotation.__name__ = "TextAnnotation";
(() => {
  _a$3z.define(() => ({
    render_mode: [RenderMode, "canvas"]
  }));
})();
var _a$3y;
class TitleView extends TextAnnotationView {
  _get_location() {
    const hmargin = this.model.offset;
    const vmargin = this.model.standoff / 2;
    let sx, sy;
    const { bbox } = this.layout;
    switch (this.panel.side) {
      case "above":
      case "below": {
        switch (this.model.vertical_align) {
          case "top":
            sy = bbox.top + vmargin;
            break;
          case "middle":
            sy = bbox.vcenter;
            break;
          case "bottom":
            sy = bbox.bottom - vmargin;
            break;
        }
        switch (this.model.align) {
          case "left":
            sx = bbox.left + hmargin;
            break;
          case "center":
            sx = bbox.hcenter;
            break;
          case "right":
            sx = bbox.right - hmargin;
            break;
        }
        break;
      }
      case "left": {
        switch (this.model.vertical_align) {
          case "top":
            sx = bbox.left + vmargin;
            break;
          case "middle":
            sx = bbox.hcenter;
            break;
          case "bottom":
            sx = bbox.right - vmargin;
            break;
        }
        switch (this.model.align) {
          case "left":
            sy = bbox.bottom - hmargin;
            break;
          case "center":
            sy = bbox.vcenter;
            break;
          case "right":
            sy = bbox.top + hmargin;
            break;
        }
        break;
      }
      case "right": {
        switch (this.model.vertical_align) {
          case "top":
            sx = bbox.right - vmargin;
            break;
          case "middle":
            sx = bbox.hcenter;
            break;
          case "bottom":
            sx = bbox.left + vmargin;
            break;
        }
        switch (this.model.align) {
          case "left":
            sy = bbox.top + hmargin;
            break;
          case "center":
            sy = bbox.vcenter;
            break;
          case "right":
            sy = bbox.bottom - hmargin;
            break;
        }
        break;
      }
    }
    return [sx, sy];
  }
  _render() {
    const { text } = this.model;
    if (text == null || text.length == 0)
      return;
    this.model.text_baseline = this.model.vertical_align;
    this.model.text_align = this.model.align;
    const [sx, sy] = this._get_location();
    const angle = this.panel.get_label_angle_heuristic("parallel");
    const draw = this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this);
    draw(this.layer.ctx, text, sx, sy, angle);
  }
  _get_size() {
    const { text } = this.model;
    const graphics = new TextBox({ text });
    graphics.visuals = this.visuals.text.values();
    const { width, height } = graphics.size();
    return { width, height: height == 0 ? 0 : 2 + height + this.model.standoff };
  }
}
TitleView.__name__ = "TitleView";
class Title extends TextAnnotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3y = Title;
Title.__name__ = "Title";
(() => {
  _a$3y.prototype.default_view = TitleView;
  _a$3y.mixins([
    Text$3,
    ["border_", Line$2],
    ["background_", Fill$1]
  ]);
  _a$3y.define(({ Number: Number2, String: String2 }) => ({
    text: [String2, ""],
    vertical_align: [VerticalAlign, "bottom"],
    align: [TextAlign, "left"],
    offset: [Number2, 0],
    standoff: [Number2, 10]
  }));
  _a$3y.prototype._props.text_align.options.internal = true;
  _a$3y.prototype._props.text_baseline.options.internal = true;
  _a$3y.override({
    text_font_size: "13px",
    text_font_style: "bold",
    text_line_height: 1,
    background_fill_color: null,
    border_line_color: null
  });
})();
class CartesianFrame {
  constructor(in_x_scale, in_y_scale, x_range, y_range, extra_x_ranges = {}, extra_y_ranges = {}, extra_x_scales = {}, extra_y_scales = {}) {
    this.in_x_scale = in_x_scale;
    this.in_y_scale = in_y_scale;
    this.x_range = x_range;
    this.y_range = y_range;
    this.extra_x_ranges = extra_x_ranges;
    this.extra_y_ranges = extra_y_ranges;
    this.extra_x_scales = extra_x_scales;
    this.extra_y_scales = extra_y_scales;
    this._bbox = new BBox$2();
    assert(in_x_scale.source_range == null && in_x_scale.target_range == null);
    assert(in_y_scale.source_range == null && in_y_scale.target_range == null);
    this._configure_scales();
  }
  get bbox() {
    return this._bbox;
  }
  _get_ranges(range2, extra_ranges) {
    return new Map(entries({ ...extra_ranges, default: range2 }));
  }
  _get_scales(scale, extra_scales, ranges, frame_range) {
    var _a2;
    const in_scales = new Map(entries({ ...extra_scales, default: scale }));
    const scales = /* @__PURE__ */ new Map();
    for (const [name, range2] of ranges) {
      const factor_range = range2 instanceof FactorRange;
      const categorical_scale = scale instanceof CategoricalScale;
      if (factor_range != categorical_scale) {
        throw new Error(`Range ${range2.type} is incompatible is Scale ${scale.type}`);
      }
      if (scale instanceof LogScale && range2 instanceof DataRange1d)
        range2.scale_hint = "log";
      const derived_scale = ((_a2 = in_scales.get(name)) != null ? _a2 : scale).clone();
      derived_scale.setv({ source_range: range2, target_range: frame_range });
      scales.set(name, derived_scale);
    }
    return scales;
  }
  _configure_frame_ranges() {
    const { bbox } = this;
    this._x_target = new Range1d({ start: bbox.left, end: bbox.right });
    this._y_target = new Range1d({ start: bbox.bottom, end: bbox.top });
  }
  _configure_scales() {
    this._configure_frame_ranges();
    this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
    this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
    this._x_scales = this._get_scales(this.in_x_scale, this.extra_x_scales, this._x_ranges, this._x_target);
    this._y_scales = this._get_scales(this.in_y_scale, this.extra_y_scales, this._y_ranges, this._y_target);
  }
  _update_scales() {
    this._configure_frame_ranges();
    for (const [, scale] of this._x_scales) {
      scale.target_range = this._x_target;
    }
    for (const [, scale] of this._y_scales) {
      scale.target_range = this._y_target;
    }
  }
  set_geometry(bbox) {
    this._bbox = bbox;
    this._update_scales();
  }
  get x_target() {
    return this._x_target;
  }
  get y_target() {
    return this._y_target;
  }
  get x_ranges() {
    return this._x_ranges;
  }
  get y_ranges() {
    return this._y_ranges;
  }
  get x_scales() {
    return this._x_scales;
  }
  get y_scales() {
    return this._y_scales;
  }
  get x_scale() {
    return this._x_scales.get("default");
  }
  get y_scale() {
    return this._y_scales.get("default");
  }
  get xscales() {
    return to_object(this.x_scales);
  }
  get yscales() {
    return to_object(this.y_scales);
  }
}
CartesianFrame.__name__ = "CartesianFrame";
var _a$3x;
class GuideRendererView extends RendererView {
}
GuideRendererView.__name__ = "GuideRendererView";
class GuideRenderer extends Renderer {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3x = GuideRenderer;
GuideRenderer.__name__ = "GuideRenderer";
(() => {
  _a$3x.override({
    level: "guide"
  });
})();
class Ticker extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
Ticker.__name__ = "Ticker";
class TickFormatter extends Model {
  constructor(attrs) {
    super(attrs);
  }
  format_graphics(ticks, opts) {
    return this.doFormat(ticks, opts).map((text) => new TextBox({ text }));
  }
  compute(tick, opts) {
    return this.doFormat([tick], opts != null ? opts : { loc: 0 })[0];
  }
  v_compute(tick, opts) {
    return this.doFormat(tick, opts != null ? opts : { loc: 0 });
  }
}
TickFormatter.__name__ = "TickFormatter";
var _a$3w, _b$8;
class LabelingPolicy extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
LabelingPolicy.__name__ = "LabelingPolicy";
class AllLabels extends LabelingPolicy {
  constructor(attrs) {
    super(attrs);
  }
  filter(indices, _bboxes, _distance) {
    return indices;
  }
}
AllLabels.__name__ = "AllLabels";
class NoOverlap extends LabelingPolicy {
  constructor(attrs) {
    super(attrs);
  }
  filter(indices, _bboxes, distance) {
    const { min_distance } = this;
    let k = null;
    for (const i2 of indices) {
      if (k != null && distance(k, i2) < min_distance)
        indices.unset(i2);
      else
        k = i2;
    }
    return indices;
  }
}
_a$3w = NoOverlap;
NoOverlap.__name__ = "NoOverlap";
(() => {
  _a$3w.define(({ Number: Number2 }) => ({
    min_distance: [Number2, 5]
  }));
})();
class CustomLabelingPolicy extends LabelingPolicy {
  constructor(attrs) {
    super(attrs);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const code = use_strict(this.code);
    return new GeneratorFunction("indices", "bboxes", "distance", ...this.names, code);
  }
  filter(indices, bboxes, distance) {
    const obj = /* @__PURE__ */ Object.create(null);
    const generator = this.func.call(obj, indices, bboxes, distance, ...this.values);
    let result = generator.next();
    if (result.done && result.value !== void 0) {
      const { value } = result;
      if (value instanceof BitSet)
        return value;
      else if (value === void 0)
        return indices;
      else if (isIterable(value))
        return BitSet.from_indices(indices.size, value);
      else
        return BitSet.all_unset(indices.size);
    } else {
      const array = [];
      do {
        array.push(result.value);
        result = generator.next();
      } while (!result.done);
      return BitSet.from_indices(indices.size, array);
    }
  }
}
_b$8 = CustomLabelingPolicy;
CustomLabelingPolicy.__name__ = "CustomLabelingPolicy";
(() => {
  _b$8.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    code: [String2, ""]
  }));
})();
var _a$3v;
class BaseTextView extends View {
}
BaseTextView.__name__ = "BaseTextView";
class BaseText extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3v = BaseText;
BaseText.__name__ = "BaseText";
(() => {
  _a$3v.define(({ String: String2 }) => ({
    text: [String2]
  }));
})();
async function load_image(url, options2) {
  return new ImageLoader(url, options2).promise;
}
class ImageLoader {
  constructor(url, config2 = {}) {
    this._image = new Image();
    this._finished = false;
    const { attempts = 1, timeout = 1 } = config2;
    this.promise = new Promise((resolve, _reject) => {
      this._image.crossOrigin = "anonymous";
      let retries = 0;
      this._image.onerror = () => {
        if (++retries == attempts) {
          const message = `unable to load ${url} image after ${attempts} attempts`;
          logger.warn(message);
          if (this._image.crossOrigin != null) {
            logger.warn(`attempting to load ${url} without a cross origin policy`);
            this._image.crossOrigin = null;
            retries = 0;
          } else {
            if (config2.failed != null)
              config2.failed();
            return;
          }
        }
        setTimeout(() => this._image.src = url, timeout);
      };
      this._image.onload = () => {
        this._finished = true;
        if (config2.loaded != null)
          config2.loaded(this._image);
        resolve(this._image);
      };
      this._image.src = url;
    });
  }
  get finished() {
    return this._finished;
  }
  get image() {
    if (this._finished)
      return this._image;
    else
      throw new Error("not loaded yet");
  }
}
ImageLoader.__name__ = "ImageLoader";
function is_ModuleError(error) {
  return error instanceof Error && "code" in error;
}
async function load_module(module) {
  try {
    return await module;
  } catch (e) {
    if (is_ModuleError(e) && e.code === "MODULE_NOT_FOUND")
      return null;
    else
      throw e;
  }
}
class MathJaxProvider {
  constructor() {
    this.ready = new Signal0(this, "ready");
    this.status = "not_started";
  }
}
MathJaxProvider.__name__ = "MathJaxProvider";
class NoProvider extends MathJaxProvider {
  get MathJax() {
    return null;
  }
  async fetch() {
    this.status = "failed";
  }
}
NoProvider.__name__ = "NoProvider";
class CDNProvider extends MathJaxProvider {
  get MathJax() {
    return typeof MathJax !== "undefined" ? MathJax : null;
  }
  async fetch() {
    const script2 = document.createElement("script");
    script2.src = "https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js";
    script2.onload = () => {
      this.status = "loaded";
      this.ready.emit();
    };
    script2.onerror = () => {
      this.status = "failed";
    };
    this.status = "loading";
    document.head.appendChild(script2);
  }
}
CDNProvider.__name__ = "CDNProvider";
class BundleProvider extends MathJaxProvider {
  get MathJax() {
    return this._mathjax;
  }
  async fetch() {
    this.status = "loading";
    try {
      const mathjax2 = await load_module(Promise.resolve().then(function() {
        return index;
      }));
      this._mathjax = mathjax2;
      this.status = "loaded";
      this.ready.emit();
    } catch (error) {
      this.status = "failed";
    }
  }
}
BundleProvider.__name__ = "BundleProvider";
const default_provider = new BundleProvider();
var _a$3u, _b$7, _c$4;
class MathTextView extends BaseTextView {
  constructor() {
    super(...arguments);
    this._position = { sx: 0, sy: 0 };
    this.align = "left";
    this._x_anchor = "left";
    this._y_anchor = "center";
    this._base_font_size = 13;
    this.font_size_scale = 1;
    this.svg_image = null;
  }
  graphics() {
    return this;
  }
  infer_text_height() {
    return "ascent_descent";
  }
  set base_font_size(v) {
    if (v != null)
      this._base_font_size = v;
  }
  get base_font_size() {
    return this._base_font_size;
  }
  get has_image_loaded() {
    return this.svg_image != null;
  }
  _rect() {
    const { width, height } = this._size();
    const { x: x2, y: y2 } = this._computed_position();
    const bbox = new BBox$2({ x: x2, y: y2, width, height });
    return bbox.rect;
  }
  set position(p2) {
    this._position = p2;
  }
  get position() {
    return this._position;
  }
  get text() {
    return this.model.text;
  }
  get provider() {
    return default_provider;
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    if (this.provider.status == "not_started")
      await this.provider.fetch();
    if (this.provider.status == "not_started" || this.provider.status == "loading")
      this.provider.ready.connect(() => this.load_image());
    if (this.provider.status == "loaded")
      await this.load_image();
  }
  connect_signals() {
    super.connect_signals();
    this.on_change(this.model.properties.text, () => this.load_image());
  }
  set visuals(v) {
    const color = v.color;
    const alpha = v.alpha;
    const style2 = v.font_style;
    let size2 = v.font_size;
    const face = v.font;
    const { font_size_scale, _base_font_size } = this;
    const res = parse_css_font_size(size2);
    if (res != null) {
      let { value, unit } = res;
      value *= font_size_scale;
      if (unit == "em" && _base_font_size) {
        value *= _base_font_size;
        unit = "px";
      }
      size2 = `${value}${unit}`;
    }
    const font = `${style2} ${size2} ${face}`;
    this.font = font;
    this.color = color2css(color, alpha);
  }
  _computed_position() {
    const { width, height } = this._size();
    const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
    const x2 = sx - (() => {
      if (isNumber(x_anchor))
        return x_anchor * width;
      else {
        switch (x_anchor) {
          case "left":
            return 0;
          case "center":
            return 0.5 * width;
          case "right":
            return width;
        }
      }
    })();
    const y2 = sy - (() => {
      if (isNumber(y_anchor))
        return y_anchor * height;
      else {
        switch (y_anchor) {
          case "top":
            return 0;
          case "center":
            return 0.5 * height;
          case "bottom":
            return height;
          case "baseline":
            return 0.5 * height;
        }
      }
    })();
    return { x: x2, y: y2 };
  }
  size() {
    const { width, height } = this._size();
    const { angle } = this;
    if (!angle)
      return { width, height };
    else {
      const c = Math.cos(Math.abs(angle));
      const s = Math.sin(Math.abs(angle));
      return {
        width: Math.abs(width * c + height * s),
        height: Math.abs(width * s + height * c)
      };
    }
  }
  get_text_dimensions() {
    return {
      width: text_width(this.model.text, this.font),
      height: font_metrics(this.font).height
    };
  }
  get_image_dimensions() {
    var _a2, _b2, _c2, _d2;
    const heightEx = parseFloat((_b2 = (_a2 = this.svg_element.getAttribute("height")) == null ? void 0 : _a2.replace(/([A-z])/g, "")) != null ? _b2 : "0");
    const widthEx = parseFloat((_d2 = (_c2 = this.svg_element.getAttribute("width")) == null ? void 0 : _c2.replace(/([A-z])/g, "")) != null ? _d2 : "0");
    return {
      width: font_metrics(this.font).x_height * widthEx,
      height: font_metrics(this.font).x_height * heightEx
    };
  }
  _size() {
    return this.has_image_loaded ? this.get_image_dimensions() : this.get_text_dimensions();
  }
  bbox() {
    const { p0, p1, p2, p3 } = this.rect();
    const left2 = Math.min(p0.x, p1.x, p2.x, p3.x);
    const top = Math.min(p0.y, p1.y, p2.y, p3.y);
    const right2 = Math.max(p0.x, p1.x, p2.x, p3.x);
    const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
    return new BBox$2({ left: left2, right: right2, top, bottom });
  }
  rect() {
    const rect2 = this._rect();
    const { angle } = this;
    if (!angle)
      return rect2;
    else {
      const { sx, sy } = this.position;
      const tr = new AffineTransform();
      tr.translate(sx, sy);
      tr.rotate(angle);
      tr.translate(-sx, -sy);
      return tr.apply_rect(rect2);
    }
  }
  paint_rect(ctx) {
    const { p0, p1, p2, p3 } = this.rect();
    ctx.save();
    ctx.strokeStyle = "red";
    ctx.lineWidth = 1;
    ctx.beginPath();
    const { round: round2 } = Math;
    ctx.moveTo(round2(p0.x), round2(p0.y));
    ctx.lineTo(round2(p1.x), round2(p1.y));
    ctx.lineTo(round2(p2.x), round2(p2.y));
    ctx.lineTo(round2(p3.x), round2(p3.y));
    ctx.closePath();
    ctx.stroke();
    ctx.restore();
  }
  paint_bbox(ctx) {
    const { x: x2, y: y2, width, height } = this.bbox();
    ctx.save();
    ctx.strokeStyle = "blue";
    ctx.lineWidth = 1;
    ctx.beginPath();
    const { round: round2 } = Math;
    ctx.moveTo(round2(x2), round2(y2));
    ctx.lineTo(round2(x2), round2(y2 + height));
    ctx.lineTo(round2(x2 + width), round2(y2 + height));
    ctx.lineTo(round2(x2 + width), round2(y2));
    ctx.closePath();
    ctx.stroke();
    ctx.restore();
  }
  async load_image() {
    if (this.provider.MathJax == null)
      return null;
    const mathjax_element = this._process_text(this.model.text);
    if (mathjax_element == null) {
      this._has_finished = true;
      return null;
    }
    const svg_element = mathjax_element.children[0];
    this.svg_element = svg_element;
    svg_element.setAttribute("font", this.font);
    svg_element.setAttribute("stroke", this.color);
    const outer_HTML = svg_element.outerHTML;
    const blob = new Blob([outer_HTML], { type: "image/svg+xml" });
    const url = URL.createObjectURL(blob);
    try {
      this.svg_image = await load_image(url);
    } finally {
      URL.revokeObjectURL(url);
    }
    this.parent.request_layout();
    return this.svg_image;
  }
  paint(ctx) {
    ctx.save();
    const { sx, sy } = this.position;
    if (this.angle) {
      ctx.translate(sx, sy);
      ctx.rotate(this.angle);
      ctx.translate(-sx, -sy);
    }
    const { x: x2, y: y2 } = this._computed_position();
    if (this.svg_image != null) {
      const { width, height } = this.get_image_dimensions();
      ctx.drawImage(this.svg_image, x2, y2, width, height);
    } else {
      ctx.fillStyle = this.color;
      ctx.font = this.font;
      ctx.textAlign = "left";
      ctx.textBaseline = "alphabetic";
      ctx.fillText(this.model.text, x2, y2 + font_metrics(this.font).ascent);
    }
    ctx.restore();
    if (!this._has_finished && (this.provider.status == "failed" || this.has_image_loaded)) {
      this._has_finished = true;
      this.parent.notify_finished_after_paint();
    }
  }
}
MathTextView.__name__ = "MathTextView";
class MathText extends BaseText {
  constructor(attrs) {
    super(attrs);
  }
}
MathText.__name__ = "MathText";
class AsciiView extends MathTextView {
  _process_text(_text) {
    return void 0;
  }
}
AsciiView.__name__ = "AsciiView";
class Ascii extends MathText {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3u = Ascii;
Ascii.__name__ = "Ascii";
(() => {
  _a$3u.prototype.default_view = AsciiView;
})();
class MathMLView extends MathTextView {
  _process_text(text) {
    var _a2;
    return (_a2 = this.provider.MathJax) == null ? void 0 : _a2.mathml2svg(text.trim());
  }
}
MathMLView.__name__ = "MathMLView";
class MathML$1 extends MathText {
  constructor(attrs) {
    super(attrs);
  }
}
_b$7 = MathML$1;
MathML$1.__name__ = "MathML";
(() => {
  _b$7.prototype.default_view = MathMLView;
})();
class TeXView extends MathTextView {
  _process_text(text) {
    var _a2;
    return (_a2 = this.provider.MathJax) == null ? void 0 : _a2.tex2svg(text, void 0, this.model.macros);
  }
}
TeXView.__name__ = "TeXView";
class TeX$1 extends MathText {
  constructor(attrs) {
    super(attrs);
  }
}
_c$4 = TeX$1;
TeX$1.__name__ = "TeX";
(() => {
  _c$4.prototype.default_view = TeXView;
  _c$4.define(({ Boolean: Boolean2, Number: Number2, String: String2, Dict: Dict2, Tuple: Tuple2, Or: Or2 }) => ({
    macros: [Dict2(Or2(String2, Tuple2(String2, Number2))), {}],
    inline: [Boolean2, false]
  }));
})();
var _a$3t;
class PlainTextView extends BaseTextView {
  initialize() {
    super.initialize();
    this._has_finished = true;
  }
  graphics() {
    return new TextBox({ text: this.model.text });
  }
}
PlainTextView.__name__ = "PlainTextView";
class PlainText extends BaseText {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3t = PlainText;
PlainText.__name__ = "PlainText";
(() => {
  _a$3t.prototype.default_view = PlainTextView;
})();
const delimiters$1 = [
  { start: "$$", end: "$$", inline: false },
  { start: "\\[", end: "\\]", inline: false },
  { start: "\\(", end: "\\)", inline: true }
];
function parse_delimited_string(text) {
  for (const delim of delimiters$1) {
    const n0 = text.indexOf(delim.start);
    const m0 = n0 + delim.start.length;
    if (n0 == 0) {
      const n1 = text.indexOf(delim.end, m0);
      const m1 = n1;
      if (n1 == text.length - delim.end.length)
        return new TeX$1({ text: text.slice(m0, m1), inline: delim.inline });
      else
        break;
    }
  }
  return new PlainText({ text });
}
var _a$3s;
const { abs: abs$3 } = Math;
class AxisView extends GuideRendererView {
  constructor() {
    super(...arguments);
    this._axis_label_view = null;
    this._major_label_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    await this._init_axis_label();
    await this._init_major_labels();
  }
  async _init_axis_label() {
    const { axis_label } = this.model;
    if (axis_label != null) {
      const _axis_label = isString(axis_label) ? parse_delimited_string(axis_label) : axis_label;
      this._axis_label_view = await build_view(_axis_label, { parent: this });
    } else
      this._axis_label_view = null;
  }
  async _init_major_labels() {
    const { major_label_overrides } = this.model;
    for (const [label2, label_text] of entries(major_label_overrides)) {
      const _label_text = isString(label_text) ? parse_delimited_string(label_text) : label_text;
      this._major_label_views.set(label2, await build_view(_label_text, { parent: this }));
    }
  }
  update_layout() {
    this.layout = new SideLayout(this.panel, () => this.get_size(), true);
    this.layout.on_resize(() => this._coordinates = void 0);
  }
  get_size() {
    const { visible, fixed_location } = this.model;
    if (visible && fixed_location == null && this.is_renderable) {
      const { extents: extents2 } = this;
      const height = Math.round(extents2.tick + extents2.tick_label + extents2.axis_label);
      return { width: 0, height };
    } else
      return { width: 0, height: 0 };
  }
  get is_renderable() {
    const [range2, cross_range] = this.ranges;
    return range2.is_valid && cross_range.is_valid;
  }
  _render() {
    var _a2;
    if (!this.is_renderable)
      return;
    const { tick_coords, extents: extents2 } = this;
    const ctx = this.layer.ctx;
    ctx.save();
    this._draw_rule(ctx, extents2);
    this._draw_major_ticks(ctx, extents2, tick_coords);
    this._draw_minor_ticks(ctx, extents2, tick_coords);
    this._draw_major_labels(ctx, extents2, tick_coords);
    this._draw_axis_label(ctx, extents2, tick_coords);
    (_a2 = this._paint) == null ? void 0 : _a2.call(this, ctx, extents2, tick_coords);
    ctx.restore();
  }
  connect_signals() {
    super.connect_signals();
    const { axis_label, major_label_overrides } = this.model.properties;
    this.on_change(axis_label, async () => {
      var _a2;
      (_a2 = this._axis_label_view) == null ? void 0 : _a2.remove();
      await this._init_axis_label();
    });
    this.on_change(major_label_overrides, async () => {
      for (const label_view of this._major_label_views.values()) {
        label_view.remove();
      }
      await this._init_major_labels();
    });
    this.connect(this.model.change, () => this.plot_view.request_layout());
  }
  get needs_clip() {
    return this.model.fixed_location != null;
  }
  _draw_rule(ctx, _extents) {
    if (!this.visuals.axis_line.doit)
      return;
    const [xs, ys] = this.rule_coords;
    const [sxs, sys] = this.coordinates.map_to_screen(xs, ys);
    const [nx, ny] = this.normals;
    const [xoff, yoff] = this.offsets;
    this.visuals.axis_line.set_value(ctx);
    ctx.beginPath();
    for (let i2 = 0; i2 < sxs.length; i2++) {
      const sx = Math.round(sxs[i2] + nx * xoff);
      const sy = Math.round(sys[i2] + ny * yoff);
      ctx.lineTo(sx, sy);
    }
    ctx.stroke();
  }
  _draw_major_ticks(ctx, _extents, tick_coords) {
    const tin = this.model.major_tick_in;
    const tout = this.model.major_tick_out;
    const visuals = this.visuals.major_tick_line;
    this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
  }
  _draw_minor_ticks(ctx, _extents, tick_coords) {
    const tin = this.model.minor_tick_in;
    const tout = this.model.minor_tick_out;
    const visuals = this.visuals.minor_tick_line;
    this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
  }
  _draw_major_labels(ctx, extents2, tick_coords) {
    const coords = tick_coords.major;
    const labels = this.compute_labels(coords[this.dimension]);
    const orient = this.model.major_label_orientation;
    const standoff = extents2.tick + this.model.major_label_standoff;
    const visuals = this.visuals.major_label_text;
    this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
  }
  _axis_label_extent() {
    if (this._axis_label_view == null)
      return 0;
    const axis_label_graphics = this._axis_label_view.graphics();
    const padding = 3;
    axis_label_graphics.visuals = this.visuals.axis_label_text.values();
    axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
    if (isNumber(this.plot_view.base_font_size))
      axis_label_graphics.base_font_size = this.plot_view.base_font_size;
    const size2 = axis_label_graphics.size();
    const extent = this.dimension == 0 ? size2.height : size2.width;
    const standoff = this.model.axis_label_standoff;
    return extent > 0 ? standoff + extent + padding : 0;
  }
  _draw_axis_label(ctx, extents2, _tick_coords) {
    if (this._axis_label_view == null || this.model.fixed_location != null)
      return;
    const [sx, sy] = (() => {
      const { bbox } = this.layout;
      switch (this.panel.side) {
        case "above":
          return [bbox.hcenter, bbox.bottom];
        case "below":
          return [bbox.hcenter, bbox.top];
        case "left":
          return [bbox.right, bbox.vcenter];
        case "right":
          return [bbox.left, bbox.vcenter];
      }
    })();
    const [nx, ny] = this.normals;
    const standoff = extents2.tick + extents2.tick_label + this.model.axis_label_standoff;
    const { vertical_align, align } = this.panel.get_label_text_heuristics("parallel");
    const position2 = {
      sx: sx + nx * standoff,
      sy: sy + ny * standoff,
      x_anchor: align,
      y_anchor: vertical_align
    };
    const axis_label_graphics = this._axis_label_view.graphics();
    axis_label_graphics.visuals = this.visuals.axis_label_text.values();
    axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
    if (this.plot_view.base_font_size)
      axis_label_graphics.base_font_size = this.plot_view.base_font_size;
    axis_label_graphics.position = position2;
    axis_label_graphics.align = align;
    axis_label_graphics.paint(ctx);
  }
  _draw_ticks(ctx, coords, tin, tout, visuals) {
    if (!visuals.doit)
      return;
    const [x2, y2] = coords;
    const [sxs, sys] = this.coordinates.map_to_screen(x2, y2);
    const [nx, ny] = this.normals;
    const [xoff, yoff] = this.offsets;
    const [nxin, nyin] = [nx * (xoff - tin), ny * (yoff - tin)];
    const [nxout, nyout] = [nx * (xoff + tout), ny * (yoff + tout)];
    visuals.set_value(ctx);
    ctx.beginPath();
    for (let i2 = 0; i2 < sxs.length; i2++) {
      const sx0 = Math.round(sxs[i2] + nxout);
      const sy0 = Math.round(sys[i2] + nyout);
      const sx1 = Math.round(sxs[i2] + nxin);
      const sy1 = Math.round(sys[i2] + nyin);
      ctx.moveTo(sx0, sy0);
      ctx.lineTo(sx1, sy1);
    }
    ctx.stroke();
  }
  _draw_oriented_labels(ctx, labels, coords, orient, _side, standoff, visuals) {
    if (!visuals.doit || labels.length == 0)
      return;
    const [dxs, dys] = coords;
    const [sxs, sys] = this.coordinates.map_to_screen(dxs, dys);
    const [xoff, yoff] = this.offsets;
    const [nx, ny] = this.normals;
    const nxd = nx * (xoff + standoff);
    const nyd = ny * (yoff + standoff);
    const { vertical_align, align } = this.panel.get_label_text_heuristics(orient);
    const angle = this.panel.get_label_angle_heuristic(orient);
    labels.visuals = visuals.values();
    labels.angle = angle;
    labels.base_font_size = this.plot_view.base_font_size;
    for (let i2 = 0; i2 < labels.length; i2++) {
      const label2 = labels.items[i2];
      label2.position = {
        sx: sxs[i2] + nxd,
        sy: sys[i2] + nyd,
        x_anchor: align,
        y_anchor: vertical_align
      };
      if (label2 instanceof TextBox)
        label2.align = align;
    }
    const n2 = labels.length;
    const indices = BitSet.all_set(n2);
    const { items } = labels;
    const bboxes = items.map((l) => l.bbox());
    const dist = (() => {
      const [range2] = this.ranges;
      if (!range2.is_reversed)
        return this.dimension == 0 ? (i2, j) => bboxes[j].left - bboxes[i2].right : (i2, j) => bboxes[i2].top - bboxes[j].bottom;
      else
        return this.dimension == 0 ? (i2, j) => bboxes[i2].left - bboxes[j].right : (i2, j) => bboxes[j].top - bboxes[i2].bottom;
    })();
    const { major_label_policy } = this.model;
    const selected = major_label_policy.filter(indices, bboxes, dist);
    const ids = [...selected.ones()];
    if (ids.length != 0) {
      const cbox = this.parent.canvas_view.bbox;
      const correct_x = (k) => {
        const bbox = bboxes[k];
        if (bbox.left < 0) {
          const offset2 = -bbox.left;
          const { position: position2 } = items[k];
          items[k].position = { ...position2, sx: position2.sx + offset2 };
        } else if (bbox.right > cbox.width) {
          const offset2 = bbox.right - cbox.width;
          const { position: position2 } = items[k];
          items[k].position = { ...position2, sx: position2.sx - offset2 };
        }
      };
      const correct_y = (k) => {
        const bbox = bboxes[k];
        if (bbox.top < 0) {
          const offset2 = -bbox.top;
          const { position: position2 } = items[k];
          items[k].position = { ...position2, sy: position2.sy + offset2 };
        } else if (bbox.bottom > cbox.height) {
          const offset2 = bbox.bottom - cbox.height;
          const { position: position2 } = items[k];
          items[k].position = { ...position2, sy: position2.sy - offset2 };
        }
      };
      const i2 = ids[0];
      const j = ids[ids.length - 1];
      if (this.dimension == 0) {
        correct_x(i2);
        correct_x(j);
      } else {
        correct_y(i2);
        correct_y(j);
      }
    }
    for (const i2 of selected) {
      const label2 = items[i2];
      label2.paint(ctx);
    }
  }
  _tick_extent() {
    return this.model.major_tick_out;
  }
  _tick_label_extents() {
    const coords = this.tick_coords.major;
    const labels = this.compute_labels(coords[this.dimension]);
    const orient = this.model.major_label_orientation;
    const standoff = this.model.major_label_standoff;
    const visuals = this.visuals.major_label_text;
    return [this._oriented_labels_extent(labels, orient, standoff, visuals)];
  }
  get extents() {
    const tick_labels = this._tick_label_extents();
    return {
      tick: this._tick_extent(),
      tick_labels,
      tick_label: sum$2(tick_labels),
      axis_label: this._axis_label_extent()
    };
  }
  _oriented_labels_extent(labels, orient, standoff, visuals) {
    if (labels.length == 0 || !visuals.doit)
      return 0;
    const angle = this.panel.get_label_angle_heuristic(orient);
    labels.visuals = visuals.values();
    labels.angle = angle;
    labels.base_font_size = this.plot_view.base_font_size;
    const size2 = labels.max_size();
    const extent = this.dimension == 0 ? size2.height : size2.width;
    const padding = 3;
    return extent > 0 ? standoff + extent + padding : 0;
  }
  get normals() {
    return this.panel.normals;
  }
  get dimension() {
    return this.panel.dimension;
  }
  compute_labels(ticks) {
    const labels = this.model.formatter.format_graphics(ticks, this);
    const { _major_label_views } = this;
    const visited = /* @__PURE__ */ new Set();
    for (let i2 = 0; i2 < ticks.length; i2++) {
      const override = _major_label_views.get(ticks[i2].toString());
      if (override != null) {
        visited.add(override);
        labels[i2] = override.graphics();
      }
    }
    for (const label_view of this._major_label_views.values()) {
      if (!visited.has(label_view)) {
        label_view._has_finished = true;
      }
    }
    return new GraphicsBoxes(labels);
  }
  get offsets() {
    if (this.model.fixed_location != null)
      return [0, 0];
    const { frame } = this.plot_view;
    let [xoff, yoff] = [0, 0];
    switch (this.panel.side) {
      case "below":
        yoff = abs$3(this.layout.bbox.top - frame.bbox.bottom);
        break;
      case "above":
        yoff = abs$3(this.layout.bbox.bottom - frame.bbox.top);
        break;
      case "right":
        xoff = abs$3(this.layout.bbox.left - frame.bbox.right);
        break;
      case "left":
        xoff = abs$3(this.layout.bbox.right - frame.bbox.left);
        break;
    }
    return [xoff, yoff];
  }
  get ranges() {
    const i2 = this.dimension;
    const j = (i2 + 1) % 2;
    const { ranges } = this.coordinates;
    return [ranges[i2], ranges[j]];
  }
  get computed_bounds() {
    const [range2] = this.ranges;
    const user_bounds = this.model.bounds;
    const range_bounds = [range2.min, range2.max];
    if (user_bounds == "auto")
      return [range2.min, range2.max];
    else {
      let start2;
      let end;
      const [user_start, user_end] = user_bounds;
      const [range_start, range_end] = range_bounds;
      const { min: min2, max: max2 } = Math;
      if (abs$3(user_start - user_end) > abs$3(range_start - range_end)) {
        start2 = max2(min2(user_start, user_end), range_start);
        end = min2(max2(user_start, user_end), range_end);
      } else {
        start2 = min2(user_start, user_end);
        end = max2(user_start, user_end);
      }
      return [start2, end];
    }
  }
  get rule_coords() {
    const i2 = this.dimension;
    const j = (i2 + 1) % 2;
    const [range2] = this.ranges;
    const [start2, end] = this.computed_bounds;
    const xs = new Array(2);
    const ys = new Array(2);
    const coords = [xs, ys];
    coords[i2][0] = Math.max(start2, range2.min);
    coords[i2][1] = Math.min(end, range2.max);
    if (coords[i2][0] > coords[i2][1])
      coords[i2][0] = coords[i2][1] = NaN;
    coords[j][0] = this.loc;
    coords[j][1] = this.loc;
    return coords;
  }
  get tick_coords() {
    const i2 = this.dimension;
    const j = (i2 + 1) % 2;
    const [range2] = this.ranges;
    const [start2, end] = this.computed_bounds;
    const ticks = this.model.ticker.get_ticks(start2, end, range2, this.loc);
    const majors = ticks.major;
    const minors = ticks.minor;
    const xs = [];
    const ys = [];
    const coords = [xs, ys];
    const minor_xs = [];
    const minor_ys = [];
    const minor_coords = [minor_xs, minor_ys];
    const [range_min, range_max] = [range2.min, range2.max];
    for (let ii = 0; ii < majors.length; ii++) {
      if (majors[ii] < range_min || majors[ii] > range_max)
        continue;
      coords[i2].push(majors[ii]);
      coords[j].push(this.loc);
    }
    for (let ii = 0; ii < minors.length; ii++) {
      if (minors[ii] < range_min || minors[ii] > range_max)
        continue;
      minor_coords[i2].push(minors[ii]);
      minor_coords[j].push(this.loc);
    }
    return {
      major: coords,
      minor: minor_coords
    };
  }
  get loc() {
    const { fixed_location } = this.model;
    if (fixed_location != null) {
      if (isNumber(fixed_location))
        return fixed_location;
      const [, cross_range2] = this.ranges;
      if (cross_range2 instanceof FactorRange)
        return cross_range2.synthetic(fixed_location);
      unreachable();
    }
    const [, cross_range] = this.ranges;
    switch (this.panel.side) {
      case "left":
      case "below":
        return cross_range.start;
      case "right":
      case "above":
        return cross_range.end;
    }
  }
  serializable_state() {
    return {
      ...super.serializable_state(),
      bbox: this.layout.bbox.box
    };
  }
  remove() {
    var _a2;
    (_a2 = this._axis_label_view) == null ? void 0 : _a2.remove();
    for (const label_view of this._major_label_views.values()) {
      label_view.remove();
    }
    super.remove();
  }
  has_finished() {
    if (!super.has_finished())
      return false;
    if (this._axis_label_view != null) {
      if (!this._axis_label_view.has_finished())
        return false;
    }
    for (const label_view of this._major_label_views.values()) {
      if (!label_view.has_finished())
        return false;
    }
    return true;
  }
}
AxisView.__name__ = "AxisView";
class Axis extends GuideRenderer {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3s = Axis;
Axis.__name__ = "Axis";
(() => {
  _a$3s.prototype.default_view = AxisView;
  _a$3s.mixins([
    ["axis_", Line$2],
    ["major_tick_", Line$2],
    ["minor_tick_", Line$2],
    ["major_label_", Text$3],
    ["axis_label_", Text$3]
  ]);
  _a$3s.define(({ Any: Any2, Int: Int2, Number: Number2, String: String2, Ref: Ref2, Dict: Dict2, Tuple: Tuple2, Or: Or2, Nullable: Nullable2, Auto: Auto2 }) => ({
    bounds: [Or2(Tuple2(Number2, Number2), Auto2), "auto"],
    ticker: [Ref2(Ticker)],
    formatter: [Ref2(TickFormatter)],
    axis_label: [Nullable2(Or2(String2, Ref2(BaseText))), null],
    axis_label_standoff: [Int2, 5],
    major_label_standoff: [Int2, 5],
    major_label_orientation: [Or2(TickLabelOrientation, Number2), "horizontal"],
    major_label_overrides: [Dict2(Or2(String2, Ref2(BaseText))), {}],
    major_label_policy: [Ref2(LabelingPolicy), () => new AllLabels()],
    major_tick_in: [Number2, 2],
    major_tick_out: [Number2, 6],
    minor_tick_in: [Number2, 0],
    minor_tick_out: [Number2, 4],
    fixed_location: [Nullable2(Or2(Number2, Any2)), null]
  }));
  _a$3s.override({
    axis_line_color: "black",
    major_tick_line_color: "black",
    minor_tick_line_color: "black",
    major_label_text_font_size: "11px",
    major_label_text_align: "center",
    major_label_text_baseline: "alphabetic",
    axis_label_text_font_size: "13px",
    axis_label_text_font_style: "italic"
  });
})();
class CategoricalTicker extends Ticker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks(start2, end, range2, _cross_loc) {
    var _a2, _b2;
    const majors = this._collect(range2.factors, range2, start2, end);
    const tops = this._collect((_a2 = range2.tops) != null ? _a2 : [], range2, start2, end);
    const mids = this._collect((_b2 = range2.mids) != null ? _b2 : [], range2, start2, end);
    return {
      major: majors,
      minor: [],
      tops,
      mids
    };
  }
  _collect(factors, range2, start2, end) {
    const result = [];
    for (const factor of factors) {
      const coord = range2.synthetic(factor);
      if (coord > start2 && coord < end)
        result.push(factor);
    }
    return result;
  }
}
CategoricalTicker.__name__ = "CategoricalTicker";
class CategoricalTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  doFormat(ticks, _opts) {
    return copy(ticks);
  }
}
CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
var _a$3r;
class CategoricalAxisView extends AxisView {
  _paint(ctx, extents2, tick_coords) {
    this._draw_group_separators(ctx, extents2, tick_coords);
  }
  _draw_group_separators(ctx, _extents, _tick_coords) {
    const [range2] = this.ranges;
    const [start2, end] = this.computed_bounds;
    if (!range2.tops || range2.tops.length < 2 || !this.visuals.separator_line.doit)
      return;
    const dim = this.dimension;
    const alt = (dim + 1) % 2;
    const coords = [[], []];
    let ind = 0;
    for (let i2 = 0; i2 < range2.tops.length - 1; i2++) {
      let first, last;
      for (let j = ind; j < range2.factors.length; j++) {
        if (range2.factors[j][0] == range2.tops[i2 + 1]) {
          [first, last] = [range2.factors[j - 1], range2.factors[j]];
          ind = j;
          break;
        }
      }
      const pt = (range2.synthetic(first) + range2.synthetic(last)) / 2;
      if (pt > start2 && pt < end) {
        coords[dim].push(pt);
        coords[alt].push(this.loc);
      }
    }
    const tex2 = this.extents.tick_label;
    this._draw_ticks(ctx, coords, -3, tex2 - 6, this.visuals.separator_line);
  }
  _draw_major_labels(ctx, extents2, _tick_coords) {
    const info = this._get_factor_info();
    let standoff = extents2.tick + this.model.major_label_standoff;
    for (let i2 = 0; i2 < info.length; i2++) {
      const [labels, coords, orient, visuals] = info[i2];
      this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
      standoff += extents2.tick_labels[i2];
    }
  }
  _tick_label_extents() {
    const info = this._get_factor_info();
    const extents2 = [];
    for (const [labels, , orient, visuals] of info) {
      const extent = this._oriented_labels_extent(labels, orient, this.model.major_label_standoff, visuals);
      extents2.push(extent);
    }
    return extents2;
  }
  _get_factor_info() {
    const [range2] = this.ranges;
    const [start2, end] = this.computed_bounds;
    const loc = this.loc;
    const ticks = this.model.ticker.get_ticks(start2, end, range2, loc);
    const coords = this.tick_coords;
    const info = [];
    const map2 = (labels) => {
      return new GraphicsBoxes(labels.map((label2) => isString(label2) ? new TextBox({ text: label2 }) : label2));
    };
    const format = (ticks2) => {
      return map2(this.model.formatter.doFormat(ticks2, this));
    };
    if (range2.levels == 1) {
      const major = ticks.major;
      const labels = format(major);
      info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
    } else if (range2.levels == 2) {
      const major = ticks.major.map((x2) => x2[1]);
      const labels = format(major);
      info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
      info.push([map2(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
    } else if (range2.levels == 3) {
      const major = ticks.major.map((x2) => x2[2]);
      const labels = format(major);
      const mid_labels = ticks.mids.map((x2) => x2[1]);
      info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
      info.push([map2(mid_labels), coords.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]);
      info.push([map2(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
    }
    return info;
  }
  get tick_coords() {
    const i2 = this.dimension;
    const j = (i2 + 1) % 2;
    const [range2] = this.ranges;
    const [start2, end] = this.computed_bounds;
    const ticks = this.model.ticker.get_ticks(start2, end, range2, this.loc);
    const coords = {
      major: [[], []],
      mids: [[], []],
      tops: [[], []],
      minor: [[], []]
    };
    coords.major[i2] = ticks.major;
    coords.major[j] = ticks.major.map(() => this.loc);
    if (range2.levels == 3) {
      coords.mids[i2] = ticks.mids;
      coords.mids[j] = ticks.mids.map(() => this.loc);
    }
    if (range2.levels > 1) {
      coords.tops[i2] = ticks.tops;
      coords.tops[j] = ticks.tops.map(() => this.loc);
    }
    return coords;
  }
}
CategoricalAxisView.__name__ = "CategoricalAxisView";
class CategoricalAxis extends Axis {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3r = CategoricalAxis;
CategoricalAxis.__name__ = "CategoricalAxis";
(() => {
  _a$3r.prototype.default_view = CategoricalAxisView;
  _a$3r.mixins([
    ["separator_", Line$2],
    ["group_", Text$3],
    ["subgroup_", Text$3]
  ]);
  _a$3r.define(({ Number: Number2, Or: Or2 }) => ({
    group_label_orientation: [Or2(TickLabelOrientation, Number2), "parallel"],
    subgroup_label_orientation: [Or2(TickLabelOrientation, Number2), "parallel"]
  }));
  _a$3r.override({
    ticker: () => new CategoricalTicker(),
    formatter: () => new CategoricalTickFormatter(),
    separator_line_color: "lightgrey",
    separator_line_width: 2,
    group_text_font_style: "bold",
    group_text_font_size: "11px",
    group_text_color: "grey",
    subgroup_text_font_style: "bold",
    subgroup_text_font_size: "11px"
  });
})();
class ContinuousAxisView extends AxisView {
}
ContinuousAxisView.__name__ = "ContinuousAxisView";
class ContinuousAxis extends Axis {
  constructor(attrs) {
    super(attrs);
  }
}
ContinuousAxis.__name__ = "ContinuousAxis";
var _a$3q;
function unicode_replace(input2) {
  let output = "";
  for (const c of input2) {
    if (c == "-")
      output += "\u2212";
    else
      output += c;
  }
  return output;
}
class BasicTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
    this.last_precision = 3;
  }
  get scientific_limit_low() {
    return 10 ** this.power_limit_low;
  }
  get scientific_limit_high() {
    return 10 ** this.power_limit_high;
  }
  _need_sci(ticks) {
    if (!this.use_scientific)
      return false;
    const { scientific_limit_high } = this;
    const { scientific_limit_low } = this;
    const zeroish = ticks.length < 2 ? 0 : Math.abs(ticks[1] - ticks[0]) / 1e4;
    for (const tick of ticks) {
      const tick_abs = Math.abs(tick);
      if (tick_abs <= zeroish)
        continue;
      if (tick_abs >= scientific_limit_high || tick_abs <= scientific_limit_low) {
        return true;
      }
    }
    return false;
  }
  _format_with_precision(ticks, need_sci, precision2) {
    if (need_sci) {
      return ticks.map((tick) => unicode_replace(tick.toExponential(precision2)));
    } else {
      return ticks.map((tick) => unicode_replace(to_fixed(tick, precision2)));
    }
  }
  _auto_precision(ticks, need_sci) {
    const labels = new Array(ticks.length);
    const asc = this.last_precision <= 15;
    outer:
      for (let x2 = this.last_precision; asc ? x2 <= 15 : x2 >= 1; asc ? x2++ : x2--) {
        if (need_sci) {
          labels[0] = ticks[0].toExponential(x2);
          for (let i2 = 1; i2 < ticks.length; i2++) {
            if (labels[i2] == labels[i2 - 1]) {
              continue outer;
            }
          }
          this.last_precision = x2;
          break;
        } else {
          labels[0] = to_fixed(ticks[0], x2);
          for (let i2 = 1; i2 < ticks.length; i2++) {
            labels[i2] = to_fixed(ticks[i2], x2);
            if (labels[i2] == labels[i2 - 1]) {
              continue outer;
            }
          }
          this.last_precision = x2;
          break;
        }
      }
    return this.last_precision;
  }
  doFormat(ticks, _opts) {
    if (ticks.length == 0)
      return [];
    const need_sci = this._need_sci(ticks);
    const precision2 = this.precision == "auto" ? this._auto_precision(ticks, need_sci) : this.precision;
    return this._format_with_precision(ticks, need_sci, precision2);
  }
}
_a$3q = BasicTickFormatter;
BasicTickFormatter.__name__ = "BasicTickFormatter";
(() => {
  _a$3q.define(({ Boolean: Boolean2, Int: Int2, Auto: Auto2, Or: Or2 }) => ({
    precision: [Or2(Int2, Auto2), "auto"],
    use_scientific: [Boolean2, true],
    power_limit_high: [Int2, 5],
    power_limit_low: [Int2, -3]
  }));
})();
var _a$3p;
class ContinuousTicker extends Ticker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks(data_low, data_high, _range, cross_loc) {
    return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
  }
  get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
    const interval = this.get_interval(data_low, data_high, desired_n_ticks);
    const start_factor = Math.floor(data_low / interval);
    const end_factor = Math.ceil(data_high / interval);
    let factors;
    if (!isFinite(start_factor) || !isFinite(end_factor))
      factors = [];
    else
      factors = range(start_factor, end_factor + 1);
    const ticks = factors.map((factor) => factor * interval).filter((tick) => data_low <= tick && tick <= data_high);
    const num_minor_ticks = this.num_minor_ticks;
    const minor_ticks = [];
    if (num_minor_ticks > 0 && ticks.length > 0) {
      const minor_interval = interval / num_minor_ticks;
      const minor_offsets = range(0, num_minor_ticks).map((i2) => i2 * minor_interval);
      for (const x2 of minor_offsets.slice(1)) {
        const mt = ticks[0] - x2;
        if (data_low <= mt && mt <= data_high) {
          minor_ticks.push(mt);
        }
      }
      for (const tick of ticks) {
        for (const x2 of minor_offsets) {
          const mt = tick + x2;
          if (data_low <= mt && mt <= data_high) {
            minor_ticks.push(mt);
          }
        }
      }
    }
    return {
      major: ticks,
      minor: minor_ticks
    };
  }
  get_ideal_interval(data_low, data_high, desired_n_ticks) {
    const data_range = data_high - data_low;
    return data_range / desired_n_ticks;
  }
}
_a$3p = ContinuousTicker;
ContinuousTicker.__name__ = "ContinuousTicker";
(() => {
  _a$3p.define(({ Int: Int2 }) => ({
    num_minor_ticks: [Int2, 5],
    desired_num_ticks: [Int2, 6]
  }));
})();
var _a$3o;
class AdaptiveTicker extends ContinuousTicker {
  constructor(attrs) {
    super(attrs);
  }
  get_min_interval() {
    return this.min_interval;
  }
  get_max_interval() {
    var _a2;
    return (_a2 = this.max_interval) != null ? _a2 : Infinity;
  }
  initialize() {
    super.initialize();
    const prefix_mantissa = nth(this.mantissas, -1) / this.base;
    const suffix_mantissa = nth(this.mantissas, 0) * this.base;
    this.extended_mantissas = [prefix_mantissa, ...this.mantissas, suffix_mantissa];
    this.base_factor = this.get_min_interval() === 0 ? 1 : this.get_min_interval();
  }
  get_interval(data_low, data_high, desired_n_ticks) {
    const data_range = data_high - data_low;
    const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
    const interval_exponent = Math.floor(log$1(ideal_interval / this.base_factor, this.base));
    const ideal_magnitude = this.base ** interval_exponent * this.base_factor;
    const candidate_mantissas = this.extended_mantissas;
    const errors = candidate_mantissas.map((mantissa) => {
      return Math.abs(desired_n_ticks - data_range / (mantissa * ideal_magnitude));
    });
    const best_mantissa = candidate_mantissas[argmin(errors)];
    const interval = best_mantissa * ideal_magnitude;
    return clamp(interval, this.get_min_interval(), this.get_max_interval());
  }
}
_a$3o = AdaptiveTicker;
AdaptiveTicker.__name__ = "AdaptiveTicker";
(() => {
  _a$3o.define(({ Number: Number2, Array: Array2, Nullable: Nullable2 }) => ({
    base: [Number2, 10],
    mantissas: [Array2(Number2), [1, 2, 5]],
    min_interval: [Number2, 0],
    max_interval: [Nullable2(Number2), null]
  }));
})();
class BasicTicker extends AdaptiveTicker {
  constructor(attrs) {
    super(attrs);
  }
}
BasicTicker.__name__ = "BasicTicker";
var _a$3n;
class LinearAxisView extends ContinuousAxisView {
}
LinearAxisView.__name__ = "LinearAxisView";
class LinearAxis extends ContinuousAxis {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3n = LinearAxis;
LinearAxis.__name__ = "LinearAxis";
(() => {
  _a$3n.prototype.default_view = LinearAxisView;
  _a$3n.override({
    ticker: () => new BasicTicker(),
    formatter: () => new BasicTickFormatter()
  });
})();
var timezone = { exports: {} };
(function(module) {
  !function(definition) {
    if (module.exports)
      module.exports = definition();
    else
      this.tz = definition();
  }(function() {
    function actualize(entry, rule, year) {
      var actualized, date = rule.day[1];
      do {
        actualized = new Date(Date.UTC(year, rule.month, Math.abs(date++)));
      } while (rule.day[0] < 7 && actualized.getUTCDay() != rule.day[0]);
      actualized = {
        clock: rule.clock,
        sort: actualized.getTime(),
        rule,
        save: rule.save * 6e4,
        offset: entry.offset
      };
      actualized[actualized.clock] = actualized.sort + rule.time * 6e4;
      if (actualized.posix) {
        actualized.wallclock = actualized[actualized.clock] + (entry.offset + rule.saved);
      } else {
        actualized.posix = actualized[actualized.clock] - (entry.offset + rule.saved);
      }
      return actualized;
    }
    function find2(request, clock, time) {
      var i2, I, entry, found, zone = request[request.zone], actualized = [], abbrev, rules, j, year = new Date(time).getUTCFullYear(), off = 1;
      for (i2 = 1, I = zone.length; i2 < I; i2++)
        if (zone[i2][clock] <= time)
          break;
      entry = zone[i2];
      if (entry.rules) {
        rules = request[entry.rules];
        for (j = year + 1; j >= year - off; --j)
          for (i2 = 0, I = rules.length; i2 < I; i2++)
            if (rules[i2].from <= j && j <= rules[i2].to)
              actualized.push(actualize(entry, rules[i2], j));
            else if (rules[i2].to < j && off == 1)
              off = j - rules[i2].to;
        actualized.sort(function(a2, b) {
          return a2.sort - b.sort;
        });
        for (i2 = 0, I = actualized.length; i2 < I; i2++) {
          if (time >= actualized[i2][clock] && actualized[i2][actualized[i2].clock] > entry[actualized[i2].clock])
            found = actualized[i2];
        }
      }
      if (found) {
        if (abbrev = /^(.*)\/(.*)$/.exec(entry.format)) {
          found.abbrev = abbrev[found.save ? 2 : 1];
        } else {
          found.abbrev = entry.format.replace(/%s/, found.rule.letter);
        }
      }
      return found || entry;
    }
    function convertToWallclock(request, posix) {
      if (request.zone == "UTC")
        return posix;
      request.entry = find2(request, "posix", posix);
      return posix + request.entry.offset + request.entry.save;
    }
    function convertToPOSIX(request, wallclock) {
      if (request.zone == "UTC")
        return wallclock;
      var entry, diff;
      request.entry = entry = find2(request, "wallclock", wallclock);
      diff = wallclock - entry.wallclock;
      return 0 < diff && diff < entry.save ? null : wallclock - entry.offset - entry.save;
    }
    function adjust(request, posix, match2) {
      var increment = +(match2[1] + 1), offset2 = match2[2] * increment, index2 = UNITS.indexOf(match2[3].toLowerCase()), date;
      if (index2 > 9) {
        posix += offset2 * TIME[index2 - 10];
      } else {
        date = new Date(convertToWallclock(request, posix));
        if (index2 < 7) {
          while (offset2) {
            date.setUTCDate(date.getUTCDate() + increment);
            if (date.getUTCDay() == index2)
              offset2 -= increment;
          }
        } else if (index2 == 7) {
          date.setUTCFullYear(date.getUTCFullYear() + offset2);
        } else if (index2 == 8) {
          date.setUTCMonth(date.getUTCMonth() + offset2);
        } else {
          date.setUTCDate(date.getUTCDate() + offset2);
        }
        if ((posix = convertToPOSIX(request, date.getTime())) == null) {
          posix = convertToPOSIX(request, date.getTime() + 864e5 * increment) - 864e5 * increment;
        }
      }
      return posix;
    }
    function convert(vargs) {
      if (!vargs.length)
        return "1.0.23";
      var request = Object.create(this), adjustments = [], i2, I, $2, argument, date;
      for (i2 = 0; i2 < vargs.length; i2++) {
        argument = vargs[i2];
        if (Array.isArray(argument)) {
          if (!i2 && !isNaN(argument[1])) {
            date = argument;
          } else {
            argument.splice.apply(vargs, [i2--, 1].concat(argument));
          }
        } else if (isNaN(argument)) {
          $2 = typeof argument;
          if ($2 == "string") {
            if (~argument.indexOf("%")) {
              request.format = argument;
            } else if (!i2 && argument == "*") {
              date = argument;
            } else if (!i2 && ($2 = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(argument))) {
              date = [];
              date.push.apply(date, $2.slice(1, 8));
              if ($2[9]) {
                date.push($2[10] + 1);
                date.push.apply(date, $2[11].split(/:/));
              } else if ($2[8]) {
                date.push(1);
              }
            } else if (/^\w{2,3}_\w{2}$/.test(argument)) {
              request.locale = argument;
            } else if ($2 = UNIT_RE.exec(argument)) {
              adjustments.push($2);
            } else {
              request.zone = argument;
            }
          } else if ($2 == "function") {
            if ($2 = argument.call(request))
              return $2;
          } else if (/^\w{2,3}_\w{2}$/.test(argument.name)) {
            request[argument.name] = argument;
          } else if (argument.zones) {
            for ($2 in argument.zones)
              request[$2] = argument.zones[$2];
            for ($2 in argument.rules)
              request[$2] = argument.rules[$2];
          }
        } else if (!i2) {
          date = argument;
        }
      }
      if (!request[request.locale])
        delete request.locale;
      if (!request[request.zone])
        delete request.zone;
      if (date != null) {
        if (date == "*") {
          date = request.clock();
        } else if (Array.isArray(date)) {
          $2 = [];
          I = !date[7];
          for (i2 = 0; i2 < 11; i2++)
            $2[i2] = +(date[i2] || 0);
          --$2[1];
          date = Date.UTC.apply(Date.UTC, $2) + -$2[7] * ($2[8] * 36e5 + $2[9] * 6e4 + $2[10] * 1e3);
        } else {
          date = Math.floor(date);
        }
        if (!isNaN(date)) {
          if (I)
            date = convertToPOSIX(request, date);
          if (date == null)
            return date;
          for (i2 = 0, I = adjustments.length; i2 < I; i2++) {
            date = adjust(request, date, adjustments[i2]);
          }
          if (!request.format)
            return date;
          $2 = new Date(convertToWallclock(request, date));
          return request.format.replace(
            /%([-0_^]?)(:{0,3})(\d*)(.)/g,
            function(value, flag, colons, padding, specifier) {
              var f, fill = "0", pad;
              if (f = request[specifier]) {
                value = String(f.call(request, $2, date, flag, colons.length));
                if ((flag || f.style) == "_")
                  fill = " ";
                pad = flag == "-" ? 0 : f.pad || 0;
                while (value.length < pad)
                  value = fill + value;
                pad = flag == "-" ? 0 : padding || f.pad;
                while (value.length < pad)
                  value = fill + value;
                if (specifier == "N" && pad < value.length)
                  value = value.slice(0, pad);
                if (flag == "^")
                  value = value.toUpperCase();
              }
              return value;
            }
          );
        }
      }
      return function() {
        return request.convert(arguments);
      };
    }
    var context = {
      clock: function() {
        return +new Date();
      },
      zone: "UTC",
      entry: { abbrev: "UTC", offset: 0, save: 0 },
      UTC: 1,
      z: function(date, posix, flag, delimiters2) {
        var offset2 = this.entry.offset + this.entry.save, seconds = Math.abs(offset2 / 1e3), parts = [], part = 3600, i2, z;
        for (i2 = 0; i2 < 3; i2++) {
          parts.push(("0" + Math.floor(seconds / part)).slice(-2));
          seconds %= part;
          part /= 60;
        }
        if (flag == "^" && !offset2)
          return "Z";
        if (flag == "^")
          delimiters2 = 3;
        if (delimiters2 == 3) {
          z = parts.join(":");
          z = z.replace(/:00$/, "");
          if (flag != "^")
            z = z.replace(/:00$/, "");
        } else if (delimiters2) {
          z = parts.slice(0, delimiters2 + 1).join(":");
          if (flag == "^")
            z = z.replace(/:00$/, "");
        } else {
          z = parts.slice(0, 2).join("");
        }
        z = (offset2 < 0 ? "-" : "+") + z;
        z = z.replace(/([-+])(0)/, { "_": " $1", "-": "$1" }[flag] || "$1$2");
        return z;
      },
      "%": function(date) {
        return "%";
      },
      n: function(date) {
        return "\n";
      },
      t: function(date) {
        return "	";
      },
      U: function(date) {
        return weekOfYear(date, 0);
      },
      W: function(date) {
        return weekOfYear(date, 1);
      },
      V: function(date) {
        return isoWeek(date)[0];
      },
      G: function(date) {
        return isoWeek(date)[1];
      },
      g: function(date) {
        return isoWeek(date)[1] % 100;
      },
      j: function(date) {
        return Math.floor((date.getTime() - Date.UTC(date.getUTCFullYear(), 0)) / 864e5) + 1;
      },
      s: function(date) {
        return Math.floor(date.getTime() / 1e3);
      },
      C: function(date) {
        return Math.floor(date.getUTCFullYear() / 100);
      },
      N: function(date) {
        return date.getTime() % 1e3 * 1e6;
      },
      m: function(date) {
        return date.getUTCMonth() + 1;
      },
      Y: function(date) {
        return date.getUTCFullYear();
      },
      y: function(date) {
        return date.getUTCFullYear() % 100;
      },
      H: function(date) {
        return date.getUTCHours();
      },
      M: function(date) {
        return date.getUTCMinutes();
      },
      S: function(date) {
        return date.getUTCSeconds();
      },
      e: function(date) {
        return date.getUTCDate();
      },
      d: function(date) {
        return date.getUTCDate();
      },
      u: function(date) {
        return date.getUTCDay() || 7;
      },
      w: function(date) {
        return date.getUTCDay();
      },
      l: function(date) {
        return date.getUTCHours() % 12 || 12;
      },
      I: function(date) {
        return date.getUTCHours() % 12 || 12;
      },
      k: function(date) {
        return date.getUTCHours();
      },
      Z: function(date) {
        return this.entry.abbrev;
      },
      a: function(date) {
        return this[this.locale].day.abbrev[date.getUTCDay()];
      },
      A: function(date) {
        return this[this.locale].day.full[date.getUTCDay()];
      },
      h: function(date) {
        return this[this.locale].month.abbrev[date.getUTCMonth()];
      },
      b: function(date) {
        return this[this.locale].month.abbrev[date.getUTCMonth()];
      },
      B: function(date) {
        return this[this.locale].month.full[date.getUTCMonth()];
      },
      P: function(date) {
        return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)].toLowerCase();
      },
      p: function(date) {
        return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)];
      },
      R: function(date, posix) {
        return this.convert([posix, "%H:%M"]);
      },
      T: function(date, posix) {
        return this.convert([posix, "%H:%M:%S"]);
      },
      D: function(date, posix) {
        return this.convert([posix, "%m/%d/%y"]);
      },
      F: function(date, posix) {
        return this.convert([posix, "%Y-%m-%d"]);
      },
      x: function(date, posix) {
        return this.convert([posix, this[this.locale].date]);
      },
      r: function(date, posix) {
        return this.convert([posix, this[this.locale].time12 || "%I:%M:%S"]);
      },
      X: function(date, posix) {
        return this.convert([posix, this[this.locale].time24]);
      },
      c: function(date, posix) {
        return this.convert([posix, this[this.locale].dateTime]);
      },
      convert,
      locale: "en_US",
      en_US: {
        date: "%m/%d/%Y",
        time24: "%I:%M:%S %p",
        time12: "%I:%M:%S %p",
        dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
        meridiem: ["AM", "PM"],
        month: {
          abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
          full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
        },
        day: {
          abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
          full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
        }
      }
    };
    var UNITS = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond", UNIT_RE = new RegExp("^\\s*([+-])(\\d+)\\s+(" + UNITS + ")s?\\s*$", "i"), TIME = [36e5, 6e4, 1e3, 1];
    UNITS = UNITS.toLowerCase().split("|");
    "delmHMSUWVgCIky".replace(/./g, function(e) {
      context[e].pad = 2;
    });
    context.N.pad = 9;
    context.j.pad = 3;
    context.k.style = "_";
    context.l.style = "_";
    context.e.style = "_";
    function weekOfYear(date, startOfWeek) {
      var diff, nyd, weekStart;
      nyd = new Date(Date.UTC(date.getUTCFullYear(), 0));
      diff = Math.floor((date.getTime() - nyd.getTime()) / 864e5);
      if (nyd.getUTCDay() == startOfWeek) {
        weekStart = 0;
      } else {
        weekStart = 7 - nyd.getUTCDay() + startOfWeek;
        if (weekStart == 8) {
          weekStart = 1;
        }
      }
      return diff >= weekStart ? Math.floor((diff - weekStart) / 7) + 1 : 0;
    }
    function isoWeek(date) {
      var nyd, nyy, week;
      nyy = date.getUTCFullYear();
      nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
      week = weekOfYear(date, 1) + (nyd > 1 && nyd <= 4 ? 1 : 0);
      if (!week) {
        nyy = date.getUTCFullYear() - 1;
        nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
        week = nyd == 4 || nyd == 3 && new Date(nyy, 1, 29).getDate() == 29 ? 53 : 52;
        return [week, date.getUTCFullYear() - 1];
      } else if (week == 53 && !(nyd == 4 || nyd == 3 && new Date(nyy, 1, 29).getDate() == 29)) {
        return [1, date.getUTCFullYear() + 1];
      } else {
        return [week, date.getUTCFullYear()];
      }
    }
    return function() {
      return context.convert(arguments);
    };
  });
})(timezone);
var tz = timezone.exports;
var numbro = { exports: {} };
/*!
 * numbro.js
 * version : 1.6.2
 * author : Företagsplatsen AB
 * license : MIT
 * http://www.foretagsplatsen.se
 */
(function(module) {
  var numbro2, VERSION2 = "1.6.2", cultures = {}, languages = cultures, currentCulture = "en-US", zeroFormat = null, defaultFormat = "0,0";
  module.exports;
  var enUS = {
    delimiters: {
      thousands: ",",
      decimal: "."
    },
    abbreviations: {
      thousand: "k",
      million: "m",
      billion: "b",
      trillion: "t"
    },
    ordinal: function(number) {
      var b = number % 10;
      return ~~(number % 100 / 10) === 1 ? "th" : b === 1 ? "st" : b === 2 ? "nd" : b === 3 ? "rd" : "th";
    },
    currency: {
      symbol: "$",
      position: "prefix"
    },
    defaults: {
      currencyFormat: ",0000 a"
    },
    formats: {
      fourDigits: "0000 a",
      fullWithTwoDecimals: "$ ,0.00",
      fullWithTwoDecimalsNoCurrency: ",0.00"
    }
  };
  function Numbro(number) {
    this._value = number;
  }
  function zeroes(count) {
    var i2, ret = "";
    for (i2 = 0; i2 < count; i2++) {
      ret += "0";
    }
    return ret;
  }
  function toFixedLarge(value, precision2) {
    var mantissa, beforeDec, afterDec, exponent, str;
    str = value.toString();
    mantissa = str.split("e")[0];
    exponent = str.split("e")[1];
    beforeDec = mantissa.split(".")[0];
    afterDec = mantissa.split(".")[1] || "";
    str = beforeDec + afterDec + zeroes(exponent - afterDec.length);
    if (precision2 > 0) {
      str += "." + zeroes(precision2);
    }
    return str;
  }
  function toFixed(value, precision2, roundingFunction, optionals) {
    var power = Math.pow(10, precision2), optionalsRegExp, output;
    if (value.toFixed(0).search("e") > -1) {
      output = toFixedLarge(value, precision2);
    } else {
      output = (roundingFunction(value * power) / power).toFixed(precision2);
    }
    if (optionals) {
      optionalsRegExp = new RegExp("0{1," + optionals + "}$");
      output = output.replace(optionalsRegExp, "");
    }
    return output;
  }
  function formatNumbro(value, format2, roundingFunction) {
    var output;
    if (format2.indexOf("$") > -1) {
      output = formatCurrency(value, format2, roundingFunction);
    } else if (format2.indexOf("%") > -1) {
      output = formatPercentage(value, format2, roundingFunction);
    } else if (format2.indexOf(":") > -1) {
      output = formatTime(value);
    } else {
      output = formatNumber(value, format2, roundingFunction);
    }
    return output;
  }
  function formatCurrency(value, originalFormat, roundingFunction) {
    var format2 = originalFormat, symbolIndex = format2.indexOf("$"), openParenIndex = format2.indexOf("("), plusSignIndex = format2.indexOf("+"), minusSignIndex = format2.indexOf("-"), space = "", decimalSeparator = "", spliceIndex, output;
    if (format2.indexOf("$") === -1) {
      if (cultures[currentCulture].currency.position === "infix") {
        decimalSeparator = cultures[currentCulture].currency.symbol;
        if (cultures[currentCulture].currency.spaceSeparated) {
          decimalSeparator = " " + decimalSeparator + " ";
        }
      } else if (cultures[currentCulture].currency.spaceSeparated) {
        space = " ";
      }
    } else {
      if (format2.indexOf(" $") > -1) {
        space = " ";
        format2 = format2.replace(" $", "");
      } else if (format2.indexOf("$ ") > -1) {
        space = " ";
        format2 = format2.replace("$ ", "");
      } else {
        format2 = format2.replace("$", "");
      }
    }
    output = formatNumber(value, format2, roundingFunction, decimalSeparator);
    if (originalFormat.indexOf("$") === -1) {
      switch (cultures[currentCulture].currency.position) {
        case "postfix":
          if (output.indexOf(")") > -1) {
            output = output.split("");
            output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
            output = output.join("");
          } else {
            output = output + space + cultures[currentCulture].currency.symbol;
          }
          break;
        case "infix":
          break;
        case "prefix":
          if (output.indexOf("(") > -1 || output.indexOf("-") > -1) {
            output = output.split("");
            spliceIndex = Math.max(openParenIndex, minusSignIndex) + 1;
            output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
            output = output.join("");
          } else {
            output = cultures[currentCulture].currency.symbol + space + output;
          }
          break;
        default:
          throw Error('Currency position should be among ["prefix", "infix", "postfix"]');
      }
    } else {
      if (symbolIndex <= 1) {
        if (output.indexOf("(") > -1 || output.indexOf("+") > -1 || output.indexOf("-") > -1) {
          output = output.split("");
          spliceIndex = 1;
          if (symbolIndex < openParenIndex || symbolIndex < plusSignIndex || symbolIndex < minusSignIndex) {
            spliceIndex = 0;
          }
          output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
          output = output.join("");
        } else {
          output = cultures[currentCulture].currency.symbol + space + output;
        }
      } else {
        if (output.indexOf(")") > -1) {
          output = output.split("");
          output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
          output = output.join("");
        } else {
          output = output + space + cultures[currentCulture].currency.symbol;
        }
      }
    }
    return output;
  }
  function formatPercentage(value, format2, roundingFunction) {
    var space = "", output;
    value = value * 100;
    if (format2.indexOf(" %") > -1) {
      space = " ";
      format2 = format2.replace(" %", "");
    } else {
      format2 = format2.replace("%", "");
    }
    output = formatNumber(value, format2, roundingFunction);
    if (output.indexOf(")") > -1) {
      output = output.split("");
      output.splice(-1, 0, space + "%");
      output = output.join("");
    } else {
      output = output + space + "%";
    }
    return output;
  }
  function formatTime(value) {
    var hours = Math.floor(value / 60 / 60), minutes = Math.floor((value - hours * 60 * 60) / 60), seconds = Math.round(value - hours * 60 * 60 - minutes * 60);
    return hours + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds < 10 ? "0" + seconds : seconds);
  }
  function formatNumber(value, format2, roundingFunction, sep) {
    var negP = false, signed = false, optDec = false, abbr = "", i2, abbrK = false, abbrM = false, abbrB = false, abbrT = false, abbrForce = false, bytes = "", ord = "", abs2 = Math.abs(value), binarySuffixes = ["B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"], decimalSuffixes = ["B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"], min2, max2, power, totalLength, length, minimumPrecision, pow, w, intPrecision, precision2, prefix, postfix, thousands, d = "", forcedNeg = false, neg = false, indexOpenP, size2, indexMinus, paren = "", minlen;
    if (value === 0 && zeroFormat !== null) {
      return zeroFormat;
    }
    if (!isFinite(value)) {
      return "" + value;
    }
    if (format2.indexOf("{") === 0) {
      var end = format2.indexOf("}");
      if (end === -1) {
        throw Error('Format should also contain a "}"');
      }
      prefix = format2.slice(1, end);
      format2 = format2.slice(end + 1);
    } else {
      prefix = "";
    }
    if (format2.indexOf("}") === format2.length - 1) {
      var start2 = format2.indexOf("{");
      if (start2 === -1) {
        throw Error('Format should also contain a "{"');
      }
      postfix = format2.slice(start2 + 1, -1);
      format2 = format2.slice(0, start2 + 1);
    } else {
      postfix = "";
    }
    var info;
    if (format2.indexOf(".") === -1) {
      info = format2.match(/([0-9]+).*/);
    } else {
      info = format2.match(/([0-9]+)\..*/);
    }
    minlen = info === null ? -1 : info[1].length;
    if (format2.indexOf("-") !== -1) {
      forcedNeg = true;
    }
    if (format2.indexOf("(") > -1) {
      negP = true;
      format2 = format2.slice(1, -1);
    } else if (format2.indexOf("+") > -1) {
      signed = true;
      format2 = format2.replace(/\+/g, "");
    }
    if (format2.indexOf("a") > -1) {
      intPrecision = format2.split(".")[0].match(/[0-9]+/g) || ["0"];
      intPrecision = parseInt(intPrecision[0], 10);
      abbrK = format2.indexOf("aK") >= 0;
      abbrM = format2.indexOf("aM") >= 0;
      abbrB = format2.indexOf("aB") >= 0;
      abbrT = format2.indexOf("aT") >= 0;
      abbrForce = abbrK || abbrM || abbrB || abbrT;
      if (format2.indexOf(" a") > -1) {
        abbr = " ";
        format2 = format2.replace(" a", "");
      } else {
        format2 = format2.replace("a", "");
      }
      totalLength = Math.floor(Math.log(abs2) / Math.LN10) + 1;
      minimumPrecision = totalLength % 3;
      minimumPrecision = minimumPrecision === 0 ? 3 : minimumPrecision;
      if (intPrecision && abs2 !== 0) {
        length = Math.floor(Math.log(abs2) / Math.LN10) + 1 - intPrecision;
        pow = 3 * ~~((Math.min(intPrecision, totalLength) - minimumPrecision) / 3);
        abs2 = abs2 / Math.pow(10, pow);
        if (format2.indexOf(".") === -1 && intPrecision > 3) {
          format2 += "[.]";
          size2 = length === 0 ? 0 : 3 * ~~(length / 3) - length;
          size2 = size2 < 0 ? size2 + 3 : size2;
          for (i2 = 0; i2 < size2; i2++) {
            format2 += "0";
          }
        }
      }
      if (Math.floor(Math.log(Math.abs(value)) / Math.LN10) + 1 !== intPrecision) {
        if (abs2 >= Math.pow(10, 12) && !abbrForce || abbrT) {
          abbr = abbr + cultures[currentCulture].abbreviations.trillion;
          value = value / Math.pow(10, 12);
        } else if (abs2 < Math.pow(10, 12) && abs2 >= Math.pow(10, 9) && !abbrForce || abbrB) {
          abbr = abbr + cultures[currentCulture].abbreviations.billion;
          value = value / Math.pow(10, 9);
        } else if (abs2 < Math.pow(10, 9) && abs2 >= Math.pow(10, 6) && !abbrForce || abbrM) {
          abbr = abbr + cultures[currentCulture].abbreviations.million;
          value = value / Math.pow(10, 6);
        } else if (abs2 < Math.pow(10, 6) && abs2 >= Math.pow(10, 3) && !abbrForce || abbrK) {
          abbr = abbr + cultures[currentCulture].abbreviations.thousand;
          value = value / Math.pow(10, 3);
        }
      }
    }
    if (format2.indexOf("b") > -1) {
      if (format2.indexOf(" b") > -1) {
        bytes = " ";
        format2 = format2.replace(" b", "");
      } else {
        format2 = format2.replace("b", "");
      }
      for (power = 0; power <= binarySuffixes.length; power++) {
        min2 = Math.pow(1024, power);
        max2 = Math.pow(1024, power + 1);
        if (value >= min2 && value < max2) {
          bytes = bytes + binarySuffixes[power];
          if (min2 > 0) {
            value = value / min2;
          }
          break;
        }
      }
    }
    if (format2.indexOf("d") > -1) {
      if (format2.indexOf(" d") > -1) {
        bytes = " ";
        format2 = format2.replace(" d", "");
      } else {
        format2 = format2.replace("d", "");
      }
      for (power = 0; power <= decimalSuffixes.length; power++) {
        min2 = Math.pow(1e3, power);
        max2 = Math.pow(1e3, power + 1);
        if (value >= min2 && value < max2) {
          bytes = bytes + decimalSuffixes[power];
          if (min2 > 0) {
            value = value / min2;
          }
          break;
        }
      }
    }
    if (format2.indexOf("o") > -1) {
      if (format2.indexOf(" o") > -1) {
        ord = " ";
        format2 = format2.replace(" o", "");
      } else {
        format2 = format2.replace("o", "");
      }
      if (cultures[currentCulture].ordinal) {
        ord = ord + cultures[currentCulture].ordinal(value);
      }
    }
    if (format2.indexOf("[.]") > -1) {
      optDec = true;
      format2 = format2.replace("[.]", ".");
    }
    w = value.toString().split(".")[0];
    precision2 = format2.split(".")[1];
    thousands = format2.indexOf(",");
    if (precision2) {
      if (precision2.indexOf("*") !== -1) {
        d = toFixed(value, value.toString().split(".")[1].length, roundingFunction);
      } else {
        if (precision2.indexOf("[") > -1) {
          precision2 = precision2.replace("]", "");
          precision2 = precision2.split("[");
          d = toFixed(
            value,
            precision2[0].length + precision2[1].length,
            roundingFunction,
            precision2[1].length
          );
        } else {
          d = toFixed(value, precision2.length, roundingFunction);
        }
      }
      w = d.split(".")[0];
      if (d.split(".")[1].length) {
        var p2 = sep ? abbr + sep : cultures[currentCulture].delimiters.decimal;
        d = p2 + d.split(".")[1];
      } else {
        d = "";
      }
      if (optDec && Number(d.slice(1)) === 0) {
        d = "";
      }
    } else {
      w = toFixed(value, null, roundingFunction);
    }
    if (w.indexOf("-") > -1) {
      w = w.slice(1);
      neg = true;
    }
    if (w.length < minlen) {
      w = new Array(minlen - w.length + 1).join("0") + w;
    }
    if (thousands > -1) {
      w = w.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1" + cultures[currentCulture].delimiters.thousands);
    }
    if (format2.indexOf(".") === 0) {
      w = "";
    }
    indexOpenP = format2.indexOf("(");
    indexMinus = format2.indexOf("-");
    if (indexOpenP < indexMinus) {
      paren = (negP && neg ? "(" : "") + (forcedNeg && neg || !negP && neg ? "-" : "");
    } else {
      paren = (forcedNeg && neg || !negP && neg ? "-" : "") + (negP && neg ? "(" : "");
    }
    return prefix + paren + (!neg && signed && value !== 0 ? "+" : "") + w + d + (ord ? ord : "") + (abbr && !sep ? abbr : "") + (bytes ? bytes : "") + (negP && neg ? ")" : "") + postfix;
  }
  numbro2 = function(input2) {
    if (numbro2.isNumbro(input2)) {
      input2 = input2.value();
    } else if (input2 === 0 || typeof input2 === "undefined") {
      input2 = 0;
    } else if (!Number(input2)) {
      input2 = numbro2.fn.unformat(input2);
    }
    return new Numbro(Number(input2));
  };
  numbro2.version = VERSION2;
  numbro2.isNumbro = function(obj) {
    return obj instanceof Numbro;
  };
  numbro2.setLanguage = function(newLanguage, fallbackLanguage) {
    console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");
    var key = newLanguage, prefix = newLanguage.split("-")[0], matchingLanguage = null;
    if (!languages[key]) {
      Object.keys(languages).forEach(function(language) {
        if (!matchingLanguage && language.split("-")[0] === prefix) {
          matchingLanguage = language;
        }
      });
      key = matchingLanguage || fallbackLanguage || "en-US";
    }
    chooseCulture(key);
  };
  numbro2.setCulture = function(newCulture, fallbackCulture) {
    var key = newCulture, suffix = newCulture.split("-")[1], matchingCulture = null;
    if (!cultures[key]) {
      if (suffix) {
        Object.keys(cultures).forEach(function(language) {
          if (!matchingCulture && language.split("-")[1] === suffix) {
            matchingCulture = language;
          }
        });
      }
      key = matchingCulture || fallbackCulture || "en-US";
    }
    chooseCulture(key);
  };
  numbro2.language = function(key, values2) {
    console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead");
    if (!key) {
      return currentCulture;
    }
    if (key && !values2) {
      if (!languages[key]) {
        throw new Error("Unknown language : " + key);
      }
      chooseCulture(key);
    }
    if (values2 || !languages[key]) {
      setCulture(key, values2);
    }
    return numbro2;
  };
  numbro2.culture = function(code, values2) {
    if (!code) {
      return currentCulture;
    }
    if (code && !values2) {
      if (!cultures[code]) {
        throw new Error("Unknown culture : " + code);
      }
      chooseCulture(code);
    }
    if (values2 || !cultures[code]) {
      setCulture(code, values2);
    }
    return numbro2;
  };
  numbro2.languageData = function(key) {
    console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead");
    if (!key) {
      return languages[currentCulture];
    }
    if (!languages[key]) {
      throw new Error("Unknown language : " + key);
    }
    return languages[key];
  };
  numbro2.cultureData = function(code) {
    if (!code) {
      return cultures[currentCulture];
    }
    if (!cultures[code]) {
      throw new Error("Unknown culture : " + code);
    }
    return cultures[code];
  };
  numbro2.culture("en-US", enUS);
  numbro2.languages = function() {
    console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead");
    return languages;
  };
  numbro2.cultures = function() {
    return cultures;
  };
  numbro2.zeroFormat = function(format2) {
    zeroFormat = typeof format2 === "string" ? format2 : null;
  };
  numbro2.defaultFormat = function(format2) {
    defaultFormat = typeof format2 === "string" ? format2 : "0.0";
  };
  numbro2.defaultCurrencyFormat = function(format2) {
  };
  numbro2.validate = function(val, culture) {
    var _decimalSep, _thousandSep, _currSymbol, _valArray, _abbrObj, _thousandRegEx, cultureData, temp;
    if (typeof val !== "string") {
      val += "";
      if (console.warn) {
        console.warn("Numbro.js: Value is not string. It has been co-erced to: ", val);
      }
    }
    val = val.trim();
    if (!!val.match(/^\d+$/)) {
      return true;
    }
    if (val === "") {
      return false;
    }
    try {
      cultureData = numbro2.cultureData(culture);
    } catch (e) {
      cultureData = numbro2.cultureData(numbro2.culture());
    }
    _currSymbol = cultureData.currency.symbol;
    _abbrObj = cultureData.abbreviations;
    _decimalSep = cultureData.delimiters.decimal;
    if (cultureData.delimiters.thousands === ".") {
      _thousandSep = "\\.";
    } else {
      _thousandSep = cultureData.delimiters.thousands;
    }
    temp = val.match(/^[^\d]+/);
    if (temp !== null) {
      val = val.substr(1);
      if (temp[0] !== _currSymbol) {
        return false;
      }
    }
    temp = val.match(/[^\d]+$/);
    if (temp !== null) {
      val = val.slice(0, -1);
      if (temp[0] !== _abbrObj.thousand && temp[0] !== _abbrObj.million && temp[0] !== _abbrObj.billion && temp[0] !== _abbrObj.trillion) {
        return false;
      }
    }
    _thousandRegEx = new RegExp(_thousandSep + "{2}");
    if (!val.match(/[^\d.,]/g)) {
      _valArray = val.split(_decimalSep);
      if (_valArray.length > 2) {
        return false;
      } else {
        if (_valArray.length < 2) {
          return !!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx);
        } else {
          if (_valArray[0].length === 1) {
            return !!_valArray[0].match(/^\d+$/) && !_valArray[0].match(_thousandRegEx) && !!_valArray[1].match(/^\d+$/);
          } else {
            return !!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx) && !!_valArray[1].match(/^\d+$/);
          }
        }
      }
    }
    return false;
  };
  function setCulture(code, values2) {
    cultures[code] = values2;
  }
  function chooseCulture(code) {
    currentCulture = code;
    var defaults2 = cultures[code].defaults;
    if (defaults2 && defaults2.format) {
      numbro2.defaultFormat(defaults2.format);
    }
    if (defaults2 && defaults2.currencyFormat) {
      numbro2.defaultCurrencyFormat(defaults2.currencyFormat);
    }
  }
  function format(input2, formatString, language, roundingFunction) {
    if (language != null && language !== numbro2.culture()) {
      numbro2.setCulture(language);
    }
    return formatNumbro(
      Number(input2),
      formatString != null ? formatString : defaultFormat,
      roundingFunction == null ? Math.round : roundingFunction
    );
  }
  module.exports = { "format": format };
})(numbro);
var sprintf$1 = {};
(function(exports2) {
  !function() {
    var re = {
      not_string: /[^s]/,
      not_bool: /[^t]/,
      not_type: /[^T]/,
      not_primitive: /[^v]/,
      number: /[diefg]/,
      numeric_arg: /[bcdiefguxX]/,
      json: /[j]/,
      not_json: /[^j]/,
      text: /^[^\x25]+/,
      modulo: /^\x25{2}/,
      placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
      key: /^([a-z_][a-z_\d]*)/i,
      key_access: /^\.([a-z_][a-z_\d]*)/i,
      index_access: /^\[(\d+)\]/,
      sign: /^[+-]/
    };
    function sprintf2(key) {
      return sprintf_format(sprintf_parse(key), arguments);
    }
    function vsprintf(fmt, argv) {
      return sprintf2.apply(null, [fmt].concat(argv || []));
    }
    function sprintf_format(parse_tree, argv) {
      var cursor = 1, tree_length = parse_tree.length, arg, output = "", i2, k, ph2, pad, pad_character, pad_length, is_positive, sign2;
      for (i2 = 0; i2 < tree_length; i2++) {
        if (typeof parse_tree[i2] === "string") {
          output += parse_tree[i2];
        } else if (typeof parse_tree[i2] === "object") {
          ph2 = parse_tree[i2];
          if (ph2.keys) {
            arg = argv[cursor];
            for (k = 0; k < ph2.keys.length; k++) {
              if (arg == void 0) {
                throw new Error(sprintf2('[sprintf] Cannot access property "%s" of undefined value "%s"', ph2.keys[k], ph2.keys[k - 1]));
              }
              arg = arg[ph2.keys[k]];
            }
          } else if (ph2.param_no) {
            arg = argv[ph2.param_no];
          } else {
            arg = argv[cursor++];
          }
          if (re.not_type.test(ph2.type) && re.not_primitive.test(ph2.type) && arg instanceof Function) {
            arg = arg();
          }
          if (re.numeric_arg.test(ph2.type) && (typeof arg !== "number" && isNaN(arg))) {
            throw new TypeError(sprintf2("[sprintf] expecting number but found %T", arg));
          }
          if (re.number.test(ph2.type)) {
            is_positive = arg >= 0;
          }
          switch (ph2.type) {
            case "b":
              arg = parseInt(arg, 10).toString(2);
              break;
            case "c":
              arg = String.fromCharCode(parseInt(arg, 10));
              break;
            case "d":
            case "i":
              arg = parseInt(arg, 10);
              break;
            case "j":
              arg = JSON.stringify(arg, null, ph2.width ? parseInt(ph2.width) : 0);
              break;
            case "e":
              arg = ph2.precision ? parseFloat(arg).toExponential(ph2.precision) : parseFloat(arg).toExponential();
              break;
            case "f":
              arg = ph2.precision ? parseFloat(arg).toFixed(ph2.precision) : parseFloat(arg);
              break;
            case "g":
              arg = ph2.precision ? String(Number(arg.toPrecision(ph2.precision))) : parseFloat(arg);
              break;
            case "o":
              arg = (parseInt(arg, 10) >>> 0).toString(8);
              break;
            case "s":
              arg = String(arg);
              arg = ph2.precision ? arg.substring(0, ph2.precision) : arg;
              break;
            case "t":
              arg = String(!!arg);
              arg = ph2.precision ? arg.substring(0, ph2.precision) : arg;
              break;
            case "T":
              arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
              arg = ph2.precision ? arg.substring(0, ph2.precision) : arg;
              break;
            case "u":
              arg = parseInt(arg, 10) >>> 0;
              break;
            case "v":
              arg = arg.valueOf();
              arg = ph2.precision ? arg.substring(0, ph2.precision) : arg;
              break;
            case "x":
              arg = (parseInt(arg, 10) >>> 0).toString(16);
              break;
            case "X":
              arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
              break;
          }
          if (re.json.test(ph2.type)) {
            output += arg;
          } else {
            if (re.number.test(ph2.type) && (!is_positive || ph2.sign)) {
              sign2 = is_positive ? "+" : "-";
              arg = arg.toString().replace(re.sign, "");
            } else {
              sign2 = "";
            }
            pad_character = ph2.pad_char ? ph2.pad_char === "0" ? "0" : ph2.pad_char.charAt(1) : " ";
            pad_length = ph2.width - (sign2 + arg).length;
            pad = ph2.width ? pad_length > 0 ? pad_character.repeat(pad_length) : "" : "";
            output += ph2.align ? sign2 + arg + pad : pad_character === "0" ? sign2 + pad + arg : pad + sign2 + arg;
          }
        }
      }
      return output;
    }
    var sprintf_cache = /* @__PURE__ */ Object.create(null);
    function sprintf_parse(fmt) {
      if (sprintf_cache[fmt]) {
        return sprintf_cache[fmt];
      }
      var _fmt = fmt, match2, parse_tree = [], arg_names = 0;
      while (_fmt) {
        if ((match2 = re.text.exec(_fmt)) !== null) {
          parse_tree.push(match2[0]);
        } else if ((match2 = re.modulo.exec(_fmt)) !== null) {
          parse_tree.push("%");
        } else if ((match2 = re.placeholder.exec(_fmt)) !== null) {
          if (match2[2]) {
            arg_names |= 1;
            var field_list = [], replacement_field = match2[2], field_match = [];
            if ((field_match = re.key.exec(replacement_field)) !== null) {
              field_list.push(field_match[1]);
              while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                } else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                } else {
                  throw new SyntaxError("[sprintf] failed to parse named argument key");
                }
              }
            } else {
              throw new SyntaxError("[sprintf] failed to parse named argument key");
            }
            match2[2] = field_list;
          } else {
            arg_names |= 2;
          }
          if (arg_names === 3) {
            throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");
          }
          parse_tree.push(
            {
              placeholder: match2[0],
              param_no: match2[1],
              keys: match2[2],
              sign: match2[3],
              pad_char: match2[4],
              align: match2[5],
              width: match2[6],
              precision: match2[7],
              type: match2[8]
            }
          );
        } else {
          throw new SyntaxError("[sprintf] unexpected placeholder");
        }
        _fmt = _fmt.substring(match2[0].length);
      }
      return sprintf_cache[fmt] = parse_tree;
    }
    {
      exports2["sprintf"] = sprintf2;
      exports2["vsprintf"] = vsprintf;
    }
    if (typeof window !== "undefined") {
      window["sprintf"] = sprintf2;
      window["vsprintf"] = vsprintf;
    }
  }();
})(sprintf$1);
const FormatterType = Enum("numeral", "printf", "datetime");
const DEFAULT_FORMATTERS = {
  numeral: (value, format, _special_vars) => numbro.exports.format(value, format),
  datetime: (value, format, _special_vars) => tz(value, format),
  printf: (value, format, _special_vars) => sprintf(format, value)
};
function sprintf(format, ...args) {
  return sprintf$1.sprintf(format, ...args);
}
function basic_formatter(value, _format, _special_vars) {
  if (isNumber(value)) {
    const format = (() => {
      switch (false) {
        case Math.floor(value) != value:
          return "%d";
        case (!(Math.abs(value) > 0.1) || !(Math.abs(value) < 1e3)):
          return "%0.3f";
        default:
          return "%0.3e";
      }
    })();
    return sprintf(format, value);
  } else
    return `${value}`;
}
function get_formatter(raw_spec, format, formatters) {
  if (format == null)
    return basic_formatter;
  if (formatters != null && raw_spec in formatters) {
    const formatter = formatters[raw_spec];
    if (isString(formatter)) {
      if (formatter in DEFAULT_FORMATTERS)
        return DEFAULT_FORMATTERS[formatter];
      else
        throw new Error(`Unknown tooltip field formatter type '${formatter}'`);
    }
    return function(value, format2, special_vars) {
      return formatter.format(value, format2, special_vars);
    };
  }
  return DEFAULT_FORMATTERS.numeral;
}
function _get_special_value(name, special_vars) {
  if (name in special_vars)
    return special_vars[name];
  else
    throw new Error(`Unknown special variable '$${name}'`);
}
function _get_column_value(name, data_source, i2) {
  const column = data_source.get_column(name);
  if (column == null)
    return null;
  if (isNumber(i2))
    return column[i2];
  const data2 = column[i2.index];
  if (isTypedArray(data2) || isArray(data2)) {
    if (isArray(data2[0])) {
      const row2 = data2[i2.dim2];
      return row2[i2.dim1];
    } else
      return data2[i2.flat_index];
  } else
    return data2;
}
function get_value(raw_name, data_source, i2, special_vars) {
  if (raw_name[0] == "$") {
    const name = raw_name.substring(1);
    return _get_special_value(name, special_vars);
  } else {
    const name = raw_name.substring(1).replace(/[{}]/g, "");
    return _get_column_value(name, data_source, i2);
  }
}
function replace_placeholders(content, data_source, i2, formatters, special_vars = {}, encode) {
  let str;
  let has_html;
  if (isString(content)) {
    str = content;
    has_html = false;
  } else {
    str = content.html;
    has_html = true;
  }
  str = str.replace(/@\$name/g, (_match) => `@{${special_vars.name}}`);
  str = str.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g, (_match, spec, format) => {
    const value = get_value(spec, data_source, i2, special_vars);
    if (value == null)
      return encode ? encode("???") : "???";
    if (format == "safe") {
      has_html = true;
      return `${value}`;
    }
    const formatter = get_formatter(spec, format, formatters);
    const result = `${formatter(value, format, special_vars)}`;
    return encode ? encode(result) : result;
  });
  if (!has_html)
    return str;
  else {
    const parser = new DOMParser();
    const document2 = parser.parseFromString(str, "text/html");
    return [...document2.body.childNodes];
  }
}
var _a$3m;
function _us(t) {
  return Math.round(t / 1e3 % 1 * 1e6);
}
function _array(t) {
  return tz(t, "%Y %m %d %H %M %S").split(/\s+/).map((e) => parseInt(e, 10));
}
function _strftime(t, format) {
  if (isFunction(format)) {
    return format(t);
  } else {
    const microsecond_replacement_string = sprintf("$1%06d", _us(t));
    format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
    if (format.indexOf("%") == -1) {
      return format;
    }
    return tz(t, format);
  }
}
const format_order = [
  "microseconds",
  "milliseconds",
  "seconds",
  "minsec",
  "minutes",
  "hourmin",
  "hours",
  "days",
  "months",
  "years"
];
class DatetimeTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
    this.strip_leading_zeros = true;
  }
  initialize() {
    super.initialize();
    this._update_width_formats();
  }
  _update_width_formats() {
    const now = +tz(new Date());
    const _widths = function(fmt_strings) {
      const sizes = fmt_strings.map((fmt_string) => _strftime(now, fmt_string).length);
      const sorted = sort_by(zip(sizes, fmt_strings), ([size2]) => size2);
      return unzip(sorted);
    };
    this._width_formats = {
      microseconds: _widths(this.microseconds),
      milliseconds: _widths(this.milliseconds),
      seconds: _widths(this.seconds),
      minsec: _widths(this.minsec),
      minutes: _widths(this.minutes),
      hourmin: _widths(this.hourmin),
      hours: _widths(this.hours),
      days: _widths(this.days),
      months: _widths(this.months),
      years: _widths(this.years)
    };
  }
  _get_resolution_str(resolution_secs, span_secs) {
    const adjusted_secs = resolution_secs * 1.1;
    switch (false) {
      case !(adjusted_secs < 1e-3):
        return "microseconds";
      case !(adjusted_secs < 1):
        return "milliseconds";
      case !(adjusted_secs < 60):
        return span_secs >= 60 ? "minsec" : "seconds";
      case !(adjusted_secs < 3600):
        return span_secs >= 3600 ? "hourmin" : "minutes";
      case !(adjusted_secs < 24 * 3600):
        return "hours";
      case !(adjusted_secs < 31 * 24 * 3600):
        return "days";
      case !(adjusted_secs < 365 * 24 * 3600):
        return "months";
      default:
        return "years";
    }
  }
  doFormat(ticks, _opts) {
    if (ticks.length == 0)
      return [];
    const span2 = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1e3;
    const r = span2 / (ticks.length - 1);
    const resol = this._get_resolution_str(r, span2);
    const [, [format]] = this._width_formats[resol];
    const labels = [];
    const resol_ndx = format_order.indexOf(resol);
    const time_tuple_ndx_for_resol = {};
    for (const fmt of format_order) {
      time_tuple_ndx_for_resol[fmt] = 0;
    }
    time_tuple_ndx_for_resol.seconds = 5;
    time_tuple_ndx_for_resol.minsec = 4;
    time_tuple_ndx_for_resol.minutes = 4;
    time_tuple_ndx_for_resol.hourmin = 3;
    time_tuple_ndx_for_resol.hours = 3;
    for (const t of ticks) {
      let s, tm;
      try {
        tm = _array(t);
        s = _strftime(t, format);
      } catch (error) {
        logger.warn(`unable to format tick for timestamp value ${t}`);
        logger.warn(` - ${error}`);
        labels.push("ERR");
        continue;
      }
      let hybrid_handled = false;
      let next_ndx = resol_ndx;
      while (tm[time_tuple_ndx_for_resol[format_order[next_ndx]]] == 0) {
        let next_format;
        next_ndx += 1;
        if (next_ndx == format_order.length)
          break;
        if ((resol == "minsec" || resol == "hourmin") && !hybrid_handled) {
          if (resol == "minsec" && tm[4] == 0 && tm[5] != 0 || resol == "hourmin" && tm[3] == 0 && tm[4] != 0) {
            next_format = this._width_formats[format_order[resol_ndx - 1]][1][0];
            s = _strftime(t, next_format);
            break;
          } else {
            hybrid_handled = true;
          }
        }
        next_format = this._width_formats[format_order[next_ndx]][1][0];
        s = _strftime(t, next_format);
      }
      if (this.strip_leading_zeros) {
        let ss = s.replace(/^0+/g, "");
        if (ss != s && isNaN(parseInt(ss))) {
          ss = `0${ss}`;
        }
        labels.push(ss);
      } else
        labels.push(s);
    }
    return labels;
  }
}
_a$3m = DatetimeTickFormatter;
DatetimeTickFormatter.__name__ = "DatetimeTickFormatter";
(() => {
  _a$3m.define(({ String: String2, Array: Array2 }) => ({
    microseconds: [Array2(String2), ["%fus"]],
    milliseconds: [Array2(String2), ["%3Nms", "%S.%3Ns"]],
    seconds: [Array2(String2), ["%Ss"]],
    minsec: [Array2(String2), [":%M:%S"]],
    minutes: [Array2(String2), [":%M", "%Mm"]],
    hourmin: [Array2(String2), ["%H:%M"]],
    hours: [Array2(String2), ["%Hh", "%H:%M"]],
    days: [Array2(String2), ["%m/%d", "%a%d"]],
    months: [Array2(String2), ["%m/%Y", "%b %Y"]],
    years: [Array2(String2), ["%Y"]]
  }));
})();
var _a$3l;
class CompositeTicker extends ContinuousTicker {
  constructor(attrs) {
    super(attrs);
  }
  get min_intervals() {
    return this.tickers.map((ticker) => ticker.get_min_interval());
  }
  get max_intervals() {
    return this.tickers.map((ticker) => ticker.get_max_interval());
  }
  get_min_interval() {
    return this.min_intervals[0];
  }
  get_max_interval() {
    return this.max_intervals[0];
  }
  get_best_ticker(data_low, data_high, desired_n_ticks) {
    const data_range = data_high - data_low;
    const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
    const ticker_ndxs = [
      sorted_index(this.min_intervals, ideal_interval) - 1,
      sorted_index(this.max_intervals, ideal_interval)
    ];
    const intervals = [
      this.min_intervals[ticker_ndxs[0]],
      this.max_intervals[ticker_ndxs[1]]
    ];
    const errors = intervals.map((interval) => {
      return Math.abs(desired_n_ticks - data_range / interval);
    });
    let best_ticker;
    if (is_empty$1(errors.filter((e) => !isNaN(e)))) {
      best_ticker = this.tickers[0];
    } else {
      const best_index = argmin(errors);
      const best_ticker_ndx = ticker_ndxs[best_index];
      best_ticker = this.tickers[best_ticker_ndx];
    }
    return best_ticker;
  }
  get_interval(data_low, data_high, desired_n_ticks) {
    const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
    return best_ticker.get_interval(data_low, data_high, desired_n_ticks);
  }
  get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
    const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
    return best_ticker.get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks);
  }
}
_a$3l = CompositeTicker;
CompositeTicker.__name__ = "CompositeTicker";
(() => {
  _a$3l.define(({ Array: Array2, Ref: Ref2 }) => ({
    tickers: [Array2(Ref2(ContinuousTicker)), []]
  }));
})();
var _a$3k;
class SingleIntervalTicker extends ContinuousTicker {
  constructor(attrs) {
    super(attrs);
  }
  get_interval(_data_low, _data_high, _n_desired_ticks) {
    return this.interval;
  }
  get_min_interval() {
    return this.interval;
  }
  get_max_interval() {
    return this.interval;
  }
}
_a$3k = SingleIntervalTicker;
SingleIntervalTicker.__name__ = "SingleIntervalTicker";
(() => {
  _a$3k.define(({ Number: Number2 }) => ({
    interval: [Number2]
  }));
})();
const ONE_MILLI = 1;
const ONE_SECOND = 1e3;
const ONE_MINUTE = 60 * ONE_SECOND;
const ONE_HOUR = 60 * ONE_MINUTE;
const ONE_DAY = 24 * ONE_HOUR;
const ONE_MONTH = 30 * ONE_DAY;
const ONE_YEAR = 365 * ONE_DAY;
function copy_date(date) {
  return new Date(date.getTime());
}
function last_month_no_later_than(date) {
  const new_date = copy_date(date);
  new_date.setUTCDate(1);
  new_date.setUTCHours(0);
  new_date.setUTCMinutes(0);
  new_date.setUTCSeconds(0);
  new_date.setUTCMilliseconds(0);
  return new_date;
}
function last_year_no_later_than(date) {
  const new_date = last_month_no_later_than(date);
  new_date.setUTCMonth(0);
  return new_date;
}
var _a$3j;
function date_range_by_month(start_time, end_time) {
  const start_date = last_month_no_later_than(new Date(start_time));
  const end_date = last_month_no_later_than(new Date(end_time));
  end_date.setUTCMonth(end_date.getUTCMonth() + 1);
  const dates = [];
  const date = start_date;
  while (true) {
    dates.push(copy_date(date));
    date.setUTCMonth(date.getUTCMonth() + 1);
    if (date > end_date)
      break;
  }
  return dates;
}
class DaysTicker extends SingleIntervalTicker {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    const days = this.days;
    if (days.length > 1)
      this.interval = (days[1] - days[0]) * ONE_DAY;
    else
      this.interval = 31 * ONE_DAY;
  }
  get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
    const month_dates = date_range_by_month(data_low, data_high);
    const days = this.days;
    const days_of_month = (month_date, interval2) => {
      const current_month = month_date.getUTCMonth();
      const dates = [];
      for (const day of days) {
        const day_date = copy_date(month_date);
        day_date.setUTCDate(day);
        const future_date = new Date(day_date.getTime() + interval2 / 2);
        if (future_date.getUTCMonth() == current_month)
          dates.push(day_date);
      }
      return dates;
    };
    const interval = this.interval;
    const day_dates = concat$1(month_dates.map((date) => days_of_month(date, interval)));
    const all_ticks = day_dates.map((day_date) => day_date.getTime());
    const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
    return {
      major: ticks_in_range,
      minor: []
    };
  }
}
_a$3j = DaysTicker;
DaysTicker.__name__ = "DaysTicker";
(() => {
  _a$3j.define(({ Int: Int2, Array: Array2 }) => ({
    days: [Array2(Int2), []]
  }));
  _a$3j.override({
    num_minor_ticks: 0
  });
})();
var _a$3i;
function date_range_by_year(start_time, end_time) {
  const start_date = last_year_no_later_than(new Date(start_time));
  const end_date = last_year_no_later_than(new Date(end_time));
  end_date.setUTCFullYear(end_date.getUTCFullYear() + 1);
  const dates = [];
  const date = start_date;
  while (true) {
    dates.push(copy_date(date));
    date.setUTCFullYear(date.getUTCFullYear() + 1);
    if (date > end_date)
      break;
  }
  return dates;
}
class MonthsTicker extends SingleIntervalTicker {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    const months = this.months;
    if (months.length > 1)
      this.interval = (months[1] - months[0]) * ONE_MONTH;
    else
      this.interval = 12 * ONE_MONTH;
  }
  get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
    const year_dates = date_range_by_year(data_low, data_high);
    const months = this.months;
    const months_of_year = (year_date) => {
      return months.map((month) => {
        const month_date = copy_date(year_date);
        month_date.setUTCMonth(month);
        return month_date;
      });
    };
    const month_dates = concat$1(year_dates.map(months_of_year));
    const all_ticks = month_dates.map((month_date) => month_date.getTime());
    const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
    return {
      major: ticks_in_range,
      minor: []
    };
  }
}
_a$3i = MonthsTicker;
MonthsTicker.__name__ = "MonthsTicker";
(() => {
  _a$3i.define(({ Int: Int2, Array: Array2 }) => ({
    months: [Array2(Int2), []]
  }));
})();
class YearsTicker extends SingleIntervalTicker {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this.interval = ONE_YEAR;
    this.basic_ticker = new BasicTicker({ num_minor_ticks: 0 });
  }
  get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
    const start_year = last_year_no_later_than(new Date(data_low)).getUTCFullYear();
    const end_year = last_year_no_later_than(new Date(data_high)).getUTCFullYear();
    const years = this.basic_ticker.get_ticks_no_defaults(start_year, end_year, cross_loc, desired_n_ticks).major;
    const all_ticks = years.map((year) => Date.UTC(year, 0, 1));
    const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
    return {
      major: ticks_in_range,
      minor: []
    };
  }
}
YearsTicker.__name__ = "YearsTicker";
var _a$3h;
class DatetimeTicker extends CompositeTicker {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3h = DatetimeTicker;
DatetimeTicker.__name__ = "DatetimeTicker";
(() => {
  _a$3h.override({
    num_minor_ticks: 0,
    tickers: () => [
      new AdaptiveTicker({
        mantissas: [1, 2, 5],
        base: 10,
        min_interval: 0,
        max_interval: 500 * ONE_MILLI,
        num_minor_ticks: 0
      }),
      new AdaptiveTicker({
        mantissas: [1, 2, 5, 10, 15, 20, 30],
        base: 60,
        min_interval: ONE_SECOND,
        max_interval: 30 * ONE_MINUTE,
        num_minor_ticks: 0
      }),
      new AdaptiveTicker({
        mantissas: [1, 2, 4, 6, 8, 12],
        base: 24,
        min_interval: ONE_HOUR,
        max_interval: 12 * ONE_HOUR,
        num_minor_ticks: 0
      }),
      new DaysTicker({ days: range(1, 32) }),
      new DaysTicker({ days: range(1, 31, 3) }),
      new DaysTicker({ days: [1, 8, 15, 22] }),
      new DaysTicker({ days: [1, 15] }),
      new MonthsTicker({ months: range(0, 12, 1) }),
      new MonthsTicker({ months: range(0, 12, 2) }),
      new MonthsTicker({ months: range(0, 12, 4) }),
      new MonthsTicker({ months: range(0, 12, 6) }),
      new YearsTicker({})
    ]
  });
})();
var _a$3g;
class DatetimeAxisView extends LinearAxisView {
}
DatetimeAxisView.__name__ = "DatetimeAxisView";
class DatetimeAxis extends LinearAxis {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3g = DatetimeAxis;
DatetimeAxis.__name__ = "DatetimeAxis";
(() => {
  _a$3g.prototype.default_view = DatetimeAxisView;
  _a$3g.override({
    ticker: () => new DatetimeTicker(),
    formatter: () => new DatetimeTickFormatter()
  });
})();
var _a$3f;
class LogTicker extends AdaptiveTicker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
    const num_minor_ticks = this.num_minor_ticks;
    const minor_ticks = [];
    const base = this.base;
    const log_low = Math.log(data_low) / Math.log(base);
    const log_high = Math.log(data_high) / Math.log(base);
    const log_interval = log_high - log_low;
    let ticks;
    if (!isFinite(log_interval)) {
      ticks = [];
    } else if (log_interval < 2) {
      const interval = this.get_interval(data_low, data_high, desired_n_ticks);
      const start_factor = Math.floor(data_low / interval);
      const end_factor = Math.ceil(data_high / interval);
      ticks = range(start_factor, end_factor + 1).filter((factor) => factor != 0).map((factor) => factor * interval).filter((tick) => data_low <= tick && tick <= data_high);
      if (num_minor_ticks > 0 && ticks.length > 0) {
        const minor_interval = interval / num_minor_ticks;
        const minor_offsets = range(0, num_minor_ticks).map((i2) => i2 * minor_interval);
        for (const x2 of minor_offsets.slice(1)) {
          minor_ticks.push(ticks[0] - x2);
        }
        for (const tick of ticks) {
          for (const x2 of minor_offsets) {
            minor_ticks.push(tick + x2);
          }
        }
      }
    } else {
      const startlog = Math.ceil(log_low * 0.999999);
      const endlog = Math.floor(log_high * 1.000001);
      const interval = Math.ceil((endlog - startlog) / 9);
      ticks = range(startlog - 1, endlog + 1, interval).map((i2) => base ** i2);
      if (num_minor_ticks > 0 && ticks.length > 0) {
        const minor_interval = base ** interval / num_minor_ticks;
        const minor_offsets = range(1, num_minor_ticks + 1).map((i2) => i2 * minor_interval);
        for (const x2 of minor_offsets) {
          minor_ticks.push(ticks[0] / x2);
        }
        minor_ticks.push(ticks[0]);
        for (const tick of ticks) {
          for (const x2 of minor_offsets) {
            minor_ticks.push(tick * x2);
          }
        }
      }
    }
    return {
      major: ticks.filter((tick) => data_low <= tick && tick <= data_high),
      minor: minor_ticks.filter((tick) => data_low <= tick && tick <= data_high)
    };
  }
}
_a$3f = LogTicker;
LogTicker.__name__ = "LogTicker";
(() => {
  _a$3f.override({
    mantissas: [1, 5]
  });
})();
var _a$3e;
const { abs: abs$2, log, round: round$1 } = Math;
class LogTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this.basic_formatter = new BasicTickFormatter();
  }
  format_graphics(ticks, opts) {
    var _a2, _b2;
    if (ticks.length == 0)
      return [];
    const base = (_b2 = (_a2 = this.ticker) == null ? void 0 : _a2.base) != null ? _b2 : 10;
    const expos = this._exponents(ticks, base);
    if (expos == null)
      return this.basic_formatter.format_graphics(ticks, opts);
    else {
      return expos.map((expo) => {
        if (abs$2(expo) < this.min_exponent) {
          const b = new TextBox({ text: unicode_replace(`${base ** expo}`) });
          const e = new TextBox({ text: "" });
          return new BaseExpo(b, e);
        } else {
          const b = new TextBox({ text: unicode_replace(`${base}`) });
          const e = new TextBox({ text: unicode_replace(`${expo}`) });
          return new BaseExpo(b, e);
        }
      });
    }
  }
  _exponents(ticks, base) {
    let last_exponent = null;
    const exponents = [];
    for (const tick of ticks) {
      const exponent = round$1(log(tick) / log(base));
      if (last_exponent != exponent) {
        last_exponent = exponent;
        exponents.push(exponent);
      } else
        return null;
    }
    return exponents;
  }
  doFormat(ticks, opts) {
    var _a2, _b2;
    if (ticks.length == 0)
      return [];
    const base = (_b2 = (_a2 = this.ticker) == null ? void 0 : _a2.base) != null ? _b2 : 10;
    const expos = this._exponents(ticks, base);
    if (expos == null)
      return this.basic_formatter.doFormat(ticks, opts);
    else
      return expos.map((expo) => {
        if (abs$2(expo) < this.min_exponent)
          return unicode_replace(`${base ** expo}`);
        else
          return unicode_replace(`${base}^${expo}`);
      });
  }
}
_a$3e = LogTickFormatter;
LogTickFormatter.__name__ = "LogTickFormatter";
(() => {
  _a$3e.define(({ Int: Int2, Ref: Ref2, Nullable: Nullable2 }) => ({
    ticker: [Nullable2(Ref2(LogTicker)), null],
    min_exponent: [Int2, 0]
  }));
})();
var _a$3d;
class LogAxisView extends ContinuousAxisView {
}
LogAxisView.__name__ = "LogAxisView";
class LogAxis extends ContinuousAxis {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3d = LogAxis;
LogAxis.__name__ = "LogAxis";
(() => {
  _a$3d.prototype.default_view = LogAxisView;
  _a$3d.override({
    ticker: () => new LogTicker(),
    formatter: () => new LogTickFormatter()
  });
})();
var _a$3c;
class MercatorTickFormatter extends BasicTickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  doFormat(ticks, opts) {
    if (this.dimension == null)
      throw new Error("MercatorTickFormatter.dimension not configured");
    if (ticks.length == 0)
      return [];
    const n2 = ticks.length;
    const proj_ticks = new Array(n2);
    if (this.dimension == "lon") {
      for (let i2 = 0; i2 < n2; i2++) {
        const [lon] = wgs84_mercator.invert(ticks[i2], opts.loc);
        proj_ticks[i2] = lon;
      }
    } else {
      for (let i2 = 0; i2 < n2; i2++) {
        const [, lat] = wgs84_mercator.invert(opts.loc, ticks[i2]);
        proj_ticks[i2] = lat;
      }
    }
    return super.doFormat(proj_ticks, opts);
  }
}
_a$3c = MercatorTickFormatter;
MercatorTickFormatter.__name__ = "MercatorTickFormatter";
(() => {
  _a$3c.define(({ Nullable: Nullable2 }) => ({
    dimension: [Nullable2(LatLon), null]
  }));
})();
var _a$3b;
class MercatorTicker extends BasicTicker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
    if (this.dimension == null) {
      throw new Error(`${this}.dimension wasn't configured`);
    }
    [data_low, data_high] = clip_mercator(data_low, data_high, this.dimension);
    if (this.dimension == "lon")
      return this._get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks);
    else
      return this._get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks);
  }
  _get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks) {
    const [proj_low] = wgs84_mercator.invert(data_low, cross_loc);
    const [proj_high, proj_cross_loc] = wgs84_mercator.invert(data_high, cross_loc);
    const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
    const major = [];
    for (const tick of proj_ticks.major) {
      if (in_bounds(tick, "lon")) {
        const [lon] = wgs84_mercator.compute(tick, proj_cross_loc);
        major.push(lon);
      }
    }
    const minor = [];
    for (const tick of proj_ticks.minor) {
      if (in_bounds(tick, "lon")) {
        const [lon] = wgs84_mercator.compute(tick, proj_cross_loc);
        minor.push(lon);
      }
    }
    return { major, minor };
  }
  _get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks) {
    const [, proj_low] = wgs84_mercator.invert(cross_loc, data_low);
    const [proj_cross_loc, proj_high] = wgs84_mercator.invert(cross_loc, data_high);
    const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
    const major = [];
    for (const tick of proj_ticks.major) {
      if (in_bounds(tick, "lat")) {
        const [, lat] = wgs84_mercator.compute(proj_cross_loc, tick);
        major.push(lat);
      }
    }
    const minor = [];
    for (const tick of proj_ticks.minor) {
      if (in_bounds(tick, "lat")) {
        const [, lat] = wgs84_mercator.compute(proj_cross_loc, tick);
        minor.push(lat);
      }
    }
    return { major, minor };
  }
}
_a$3b = MercatorTicker;
MercatorTicker.__name__ = "MercatorTicker";
(() => {
  _a$3b.define(({ Nullable: Nullable2 }) => ({
    dimension: [Nullable2(LatLon), null]
  }));
})();
var _a$3a;
class MercatorAxisView extends AxisView {
}
MercatorAxisView.__name__ = "MercatorAxisView";
class MercatorAxis extends LinearAxis {
  constructor(attrs) {
    super(attrs);
  }
}
_a$3a = MercatorAxis;
MercatorAxis.__name__ = "MercatorAxis";
(() => {
  _a$3a.prototype.default_view = MercatorAxisView;
  _a$3a.override({
    ticker: () => new MercatorTicker({ dimension: "lat" }),
    formatter: () => new MercatorTickFormatter({ dimension: "lat" })
  });
})();
var _a$39;
class FixedTicker extends ContinuousTicker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks_no_defaults(_data_low, _data_high, _cross_loc, _desired_n_ticks) {
    return {
      major: this.ticks,
      minor: this.minor_ticks
    };
  }
  get_interval(_data_low, _data_high, _desired_n_ticks) {
    return 0;
  }
  get_min_interval() {
    return 0;
  }
  get_max_interval() {
    return 0;
  }
}
_a$39 = FixedTicker;
FixedTicker.__name__ = "FixedTicker";
(() => {
  _a$39.define(({ Number: Number2, Array: Array2 }) => ({
    ticks: [Array2(Number2), []],
    minor_ticks: [Array2(Number2), []]
  }));
})();
class Mapper extends Transform {
  constructor(attrs) {
    super(attrs);
  }
  compute(_x2) {
    throw new Error("mapping single values is not supported");
  }
}
Mapper.__name__ = "Mapper";
var _a$38;
function _convert_color(color) {
  return encode_rgba(color2rgba(color));
}
function _convert_palette(palette) {
  const new_palette = new Uint32Array(palette.length);
  for (let i2 = 0, end = palette.length; i2 < end; i2++)
    new_palette[i2] = _convert_color(palette[i2]);
  return new_palette;
}
class ColorMapper extends Mapper {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this.metrics_change = new Signal0(this, "metrics_change");
  }
  v_compute(xs) {
    const values2 = new Array(xs.length);
    this._v_compute(xs, values2, this.palette, this._colors((c) => c));
    return values2;
  }
  get rgba_mapper() {
    const self2 = this;
    const palette = _convert_palette(this.palette);
    const colors = this._colors(_convert_color);
    return {
      v_compute(xs) {
        const values2 = new ColorArray(xs.length);
        self2._v_compute(xs, values2, palette, colors);
        return new Uint8ClampedArray(to_big_endian(values2).buffer);
      }
    };
  }
  _colors(conv) {
    return { nan_color: conv(this.nan_color) };
  }
}
_a$38 = ColorMapper;
ColorMapper.__name__ = "ColorMapper";
(() => {
  _a$38.define(({ Color: Color2, Array: Array2 }) => ({
    palette: [Array2(Color2)],
    nan_color: [Color2, "gray"]
  }));
})();
var _a$37;
class DataRendererView extends RendererView {
  get xscale() {
    return this.coordinates.x_scale;
  }
  get yscale() {
    return this.coordinates.y_scale;
  }
}
DataRendererView.__name__ = "DataRendererView";
class DataRenderer extends Renderer {
  constructor(attrs) {
    super(attrs);
  }
  get selection_manager() {
    return this.get_selection_manager();
  }
}
_a$37 = DataRenderer;
DataRenderer.__name__ = "DataRenderer";
(() => {
  _a$37.override({
    level: "glyph"
  });
})();
var _a$36;
class RaggedArray {
  constructor(offsets, array) {
    this.offsets = offsets;
    this.array = array;
  }
  [(_a$36 = Symbol.toStringTag, equals)](that, cmp) {
    return cmp.arrays(this.offsets, that.offsets) && cmp.arrays(this.array, that.array);
  }
  get length() {
    return this.offsets.length;
  }
  clone() {
    return new RaggedArray(this.offsets.slice(), this.array.slice());
  }
  static from(items, ctor) {
    const n2 = items.length;
    let offset2 = 0;
    const offsets = (() => {
      const offsets2 = new Uint32Array(n2);
      for (let i2 = 0; i2 < n2; i2++) {
        const length = items[i2].length;
        offsets2[i2] = offset2;
        offset2 += length;
      }
      if (offset2 < 256)
        return new Uint8Array(offsets2);
      else if (offset2 < 65536)
        return new Uint16Array(offsets2);
      else
        return offsets2;
    })();
    const array = new ctor(offset2);
    for (let i2 = 0; i2 < n2; i2++) {
      array.set(items[i2], offsets[i2]);
    }
    return new RaggedArray(offsets, array);
  }
  *[Symbol.iterator]() {
    const { offsets, length } = this;
    for (let i2 = 0; i2 < length; i2++) {
      yield this.array.subarray(offsets[i2], offsets[i2 + 1]);
    }
  }
  _check_bounds(i2) {
    assert(0 <= i2 && i2 < this.length, `Out of bounds: 0 <= ${i2} < ${this.length}`);
  }
  get(i2) {
    this._check_bounds(i2);
    const { offsets } = this;
    return this.array.subarray(offsets[i2], offsets[i2 + 1]);
  }
  set(i2, array) {
    this._check_bounds(i2);
    this.array.set(array, this.offsets[i2]);
  }
}
RaggedArray.__name__ = "RaggedArray";
RaggedArray[_a$36] = "RaggedArray";
class FlatQueue {
  constructor() {
    this.ids = [];
    this.values = [];
    this.length = 0;
  }
  clear() {
    this.length = 0;
  }
  push(id, value) {
    let pos = this.length++;
    this.ids[pos] = id;
    this.values[pos] = value;
    while (pos > 0) {
      const parent = pos - 1 >> 1;
      const parentValue = this.values[parent];
      if (value >= parentValue)
        break;
      this.ids[pos] = this.ids[parent];
      this.values[pos] = parentValue;
      pos = parent;
    }
    this.ids[pos] = id;
    this.values[pos] = value;
  }
  pop() {
    if (this.length === 0)
      return void 0;
    const top = this.ids[0];
    this.length--;
    if (this.length > 0) {
      const id = this.ids[0] = this.ids[this.length];
      const value = this.values[0] = this.values[this.length];
      const halfLength = this.length >> 1;
      let pos = 0;
      while (pos < halfLength) {
        let left2 = (pos << 1) + 1;
        const right2 = left2 + 1;
        let bestIndex = this.ids[left2];
        let bestValue = this.values[left2];
        const rightValue = this.values[right2];
        if (right2 < this.length && rightValue < bestValue) {
          left2 = right2;
          bestIndex = this.ids[right2];
          bestValue = rightValue;
        }
        if (bestValue >= value)
          break;
        this.ids[pos] = bestIndex;
        this.values[pos] = bestValue;
        pos = left2;
      }
      this.ids[pos] = id;
      this.values[pos] = value;
    }
    return top;
  }
  peek() {
    if (this.length === 0)
      return void 0;
    return this.ids[0];
  }
  peekValue() {
    if (this.length === 0)
      return void 0;
    return this.values[0];
  }
}
const ARRAY_TYPES = [
  Int8Array,
  Uint8Array,
  Uint8ClampedArray,
  Int16Array,
  Uint16Array,
  Int32Array,
  Uint32Array,
  Float32Array,
  Float64Array
];
const VERSION = 3;
class Flatbush {
  static from(data2) {
    if (!(data2 instanceof ArrayBuffer)) {
      throw new Error("Data must be an instance of ArrayBuffer.");
    }
    const [magic, versionAndType] = new Uint8Array(data2, 0, 2);
    if (magic !== 251) {
      throw new Error("Data does not appear to be in a Flatbush format.");
    }
    if (versionAndType >> 4 !== VERSION) {
      throw new Error(`Got v${versionAndType >> 4} data when expected v${VERSION}.`);
    }
    const [nodeSize] = new Uint16Array(data2, 2, 1);
    const [numItems] = new Uint32Array(data2, 4, 1);
    return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 15], data2);
  }
  constructor(numItems, nodeSize = 16, ArrayType = Float64Array, data2) {
    if (numItems === void 0)
      throw new Error("Missing required argument: numItems.");
    if (isNaN(numItems) || numItems <= 0)
      throw new Error(`Unpexpected numItems value: ${numItems}.`);
    this.numItems = +numItems;
    this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
    let n2 = numItems;
    let numNodes = n2;
    this._levelBounds = [n2 * 4];
    do {
      n2 = Math.ceil(n2 / this.nodeSize);
      numNodes += n2;
      this._levelBounds.push(numNodes * 4);
    } while (n2 !== 1);
    this.ArrayType = ArrayType || Float64Array;
    this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
    const arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
    const nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
    if (arrayTypeIndex < 0) {
      throw new Error(`Unexpected typed array class: ${ArrayType}.`);
    }
    if (data2 && data2 instanceof ArrayBuffer) {
      this.data = data2;
      this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
      this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
      this._pos = numNodes * 4;
      this.minX = this._boxes[this._pos - 4];
      this.minY = this._boxes[this._pos - 3];
      this.maxX = this._boxes[this._pos - 2];
      this.maxY = this._boxes[this._pos - 1];
    } else {
      this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
      this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
      this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
      this._pos = 0;
      this.minX = Infinity;
      this.minY = Infinity;
      this.maxX = -Infinity;
      this.maxY = -Infinity;
      new Uint8Array(this.data, 0, 2).set([251, (VERSION << 4) + arrayTypeIndex]);
      new Uint16Array(this.data, 2, 1)[0] = nodeSize;
      new Uint32Array(this.data, 4, 1)[0] = numItems;
    }
    this._queue = new FlatQueue();
  }
  add(minX, minY, maxX, maxY) {
    const index2 = this._pos >> 2;
    this._indices[index2] = index2;
    this._boxes[this._pos++] = minX;
    this._boxes[this._pos++] = minY;
    this._boxes[this._pos++] = maxX;
    this._boxes[this._pos++] = maxY;
    if (minX < this.minX)
      this.minX = minX;
    if (minY < this.minY)
      this.minY = minY;
    if (maxX > this.maxX)
      this.maxX = maxX;
    if (maxY > this.maxY)
      this.maxY = maxY;
    return index2;
  }
  finish() {
    if (this._pos >> 2 !== this.numItems) {
      throw new Error(`Added ${this._pos >> 2} items when expected ${this.numItems}.`);
    }
    if (this.numItems <= this.nodeSize) {
      this._boxes[this._pos++] = this.minX;
      this._boxes[this._pos++] = this.minY;
      this._boxes[this._pos++] = this.maxX;
      this._boxes[this._pos++] = this.maxY;
      return;
    }
    const width = this.maxX - this.minX || 1;
    const height = this.maxY - this.minY || 1;
    const hilbertValues = new Uint32Array(this.numItems);
    const hilbertMax = (1 << 16) - 1;
    for (let i2 = 0; i2 < this.numItems; i2++) {
      let pos = 4 * i2;
      const minX = this._boxes[pos++];
      const minY = this._boxes[pos++];
      const maxX = this._boxes[pos++];
      const maxY = this._boxes[pos++];
      const x2 = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
      const y2 = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
      hilbertValues[i2] = hilbert(x2, y2);
    }
    sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
    for (let i2 = 0, pos = 0; i2 < this._levelBounds.length - 1; i2++) {
      const end = this._levelBounds[i2];
      while (pos < end) {
        const nodeIndex = pos;
        let nodeMinX = Infinity;
        let nodeMinY = Infinity;
        let nodeMaxX = -Infinity;
        let nodeMaxY = -Infinity;
        for (let i3 = 0; i3 < this.nodeSize && pos < end; i3++) {
          nodeMinX = Math.min(nodeMinX, this._boxes[pos++]);
          nodeMinY = Math.min(nodeMinY, this._boxes[pos++]);
          nodeMaxX = Math.max(nodeMaxX, this._boxes[pos++]);
          nodeMaxY = Math.max(nodeMaxY, this._boxes[pos++]);
        }
        this._indices[this._pos >> 2] = nodeIndex;
        this._boxes[this._pos++] = nodeMinX;
        this._boxes[this._pos++] = nodeMinY;
        this._boxes[this._pos++] = nodeMaxX;
        this._boxes[this._pos++] = nodeMaxY;
      }
    }
  }
  search(minX, minY, maxX, maxY, filterFn) {
    if (this._pos !== this._boxes.length) {
      throw new Error("Data not yet indexed - call index.finish().");
    }
    let nodeIndex = this._boxes.length - 4;
    const queue = [];
    const results = [];
    while (nodeIndex !== void 0) {
      const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound$1(nodeIndex, this._levelBounds));
      for (let pos = nodeIndex; pos < end; pos += 4) {
        const index2 = this._indices[pos >> 2] | 0;
        if (maxX < this._boxes[pos])
          continue;
        if (maxY < this._boxes[pos + 1])
          continue;
        if (minX > this._boxes[pos + 2])
          continue;
        if (minY > this._boxes[pos + 3])
          continue;
        if (nodeIndex < this.numItems * 4) {
          if (filterFn === void 0 || filterFn(index2)) {
            results.push(index2);
          }
        } else {
          queue.push(index2);
        }
      }
      nodeIndex = queue.pop();
    }
    return results;
  }
  neighbors(x2, y2, maxResults = Infinity, maxDistance = Infinity, filterFn) {
    if (this._pos !== this._boxes.length) {
      throw new Error("Data not yet indexed - call index.finish().");
    }
    let nodeIndex = this._boxes.length - 4;
    const q = this._queue;
    const results = [];
    const maxDistSquared = maxDistance * maxDistance;
    while (nodeIndex !== void 0) {
      const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound$1(nodeIndex, this._levelBounds));
      for (let pos = nodeIndex; pos < end; pos += 4) {
        const index2 = this._indices[pos >> 2] | 0;
        const dx = axisDist(x2, this._boxes[pos], this._boxes[pos + 2]);
        const dy = axisDist(y2, this._boxes[pos + 1], this._boxes[pos + 3]);
        const dist = dx * dx + dy * dy;
        if (nodeIndex < this.numItems * 4) {
          if (filterFn === void 0 || filterFn(index2)) {
            q.push((index2 << 1) + 1, dist);
          }
        } else {
          q.push(index2 << 1, dist);
        }
      }
      while (q.length && q.peek() & 1) {
        const dist = q.peekValue();
        if (dist > maxDistSquared) {
          q.clear();
          return results;
        }
        results.push(q.pop() >> 1);
        if (results.length === maxResults) {
          q.clear();
          return results;
        }
      }
      nodeIndex = q.pop() >> 1;
    }
    q.clear();
    return results;
  }
}
function axisDist(k, min2, max2) {
  return k < min2 ? min2 - k : k <= max2 ? 0 : k - max2;
}
function upperBound$1(value, arr) {
  let i2 = 0;
  let j = arr.length - 1;
  while (i2 < j) {
    const m = i2 + j >> 1;
    if (arr[m] > value) {
      j = m;
    } else {
      i2 = m + 1;
    }
  }
  return arr[i2];
}
function sort(values2, boxes, indices, left2, right2, nodeSize) {
  if (Math.floor(left2 / nodeSize) >= Math.floor(right2 / nodeSize))
    return;
  const pivot = values2[left2 + right2 >> 1];
  let i2 = left2 - 1;
  let j = right2 + 1;
  while (true) {
    do
      i2++;
    while (values2[i2] < pivot);
    do
      j--;
    while (values2[j] > pivot);
    if (i2 >= j)
      break;
    swap(values2, boxes, indices, i2, j);
  }
  sort(values2, boxes, indices, left2, j, nodeSize);
  sort(values2, boxes, indices, j + 1, right2, nodeSize);
}
function swap(values2, boxes, indices, i2, j) {
  const temp = values2[i2];
  values2[i2] = values2[j];
  values2[j] = temp;
  const k = 4 * i2;
  const m = 4 * j;
  const a2 = boxes[k];
  const b = boxes[k + 1];
  const c = boxes[k + 2];
  const d = boxes[k + 3];
  boxes[k] = boxes[m];
  boxes[k + 1] = boxes[m + 1];
  boxes[k + 2] = boxes[m + 2];
  boxes[k + 3] = boxes[m + 3];
  boxes[m] = a2;
  boxes[m + 1] = b;
  boxes[m + 2] = c;
  boxes[m + 3] = d;
  const e = indices[i2];
  indices[i2] = indices[j];
  indices[j] = e;
}
function hilbert(x2, y2) {
  let a2 = x2 ^ y2;
  let b = 65535 ^ a2;
  let c = 65535 ^ (x2 | y2);
  let d = x2 & (y2 ^ 65535);
  let A = a2 | b >> 1;
  let B = a2 >> 1 ^ a2;
  let C = c >> 1 ^ b & d >> 1 ^ c;
  let D = a2 & c >> 1 ^ d >> 1 ^ d;
  a2 = A;
  b = B;
  c = C;
  d = D;
  A = a2 & a2 >> 2 ^ b & b >> 2;
  B = a2 & b >> 2 ^ b & (a2 ^ b) >> 2;
  C ^= a2 & c >> 2 ^ b & d >> 2;
  D ^= b & c >> 2 ^ (a2 ^ b) & d >> 2;
  a2 = A;
  b = B;
  c = C;
  d = D;
  A = a2 & a2 >> 4 ^ b & b >> 4;
  B = a2 & b >> 4 ^ b & (a2 ^ b) >> 4;
  C ^= a2 & c >> 4 ^ b & d >> 4;
  D ^= b & c >> 4 ^ (a2 ^ b) & d >> 4;
  a2 = A;
  b = B;
  c = C;
  d = D;
  C ^= a2 & c >> 8 ^ b & d >> 8;
  D ^= b & c >> 8 ^ (a2 ^ b) & d >> 8;
  a2 = C ^ C >> 1;
  b = D ^ D >> 1;
  let i0 = x2 ^ y2;
  let i1 = b | 65535 ^ (i0 | a2);
  i0 = (i0 | i0 << 8) & 16711935;
  i0 = (i0 | i0 << 4) & 252645135;
  i0 = (i0 | i0 << 2) & 858993459;
  i0 = (i0 | i0 << 1) & 1431655765;
  i1 = (i1 | i1 << 8) & 16711935;
  i1 = (i1 | i1 << 4) & 252645135;
  i1 = (i1 | i1 << 2) & 858993459;
  i1 = (i1 | i1 << 1) & 1431655765;
  return (i1 << 1 | i0) >>> 0;
}
function upperBound(value, arr) {
  let i2 = 0;
  let j = arr.length - 1;
  while (i2 < j) {
    const m = i2 + j >> 1;
    if (arr[m] > value) {
      j = m;
    } else {
      i2 = m + 1;
    }
  }
  return arr[i2];
}
class _FlatBush extends Flatbush {
  get boxes() {
    return this._boxes;
  }
  search_indices(minX, minY, maxX, maxY) {
    if (this._pos !== this._boxes.length) {
      throw new Error("Data not yet indexed - call index.finish().");
    }
    let nodeIndex = this._boxes.length - 4;
    const queue = [];
    const results = new BitSet(this.numItems);
    while (nodeIndex !== void 0) {
      const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
      for (let pos = nodeIndex; pos < end; pos += 4) {
        const index2 = this._indices[pos >> 2] | 0;
        const nodeMinX = this._boxes[pos + 0];
        const nodeMinY = this._boxes[pos + 1];
        const nodeMaxX = this._boxes[pos + 2];
        const nodeMaxY = this._boxes[pos + 3];
        if (maxX < nodeMinX)
          continue;
        if (maxY < nodeMinY)
          continue;
        if (minX > nodeMaxX)
          continue;
        if (minY > nodeMaxY)
          continue;
        if (nodeIndex < this.numItems * 4) {
          results.set(index2);
        } else {
          queue.push(index2);
        }
      }
      nodeIndex = queue.pop();
    }
    return results;
  }
}
_FlatBush.__name__ = "_FlatBush";
class SpatialIndex {
  constructor(size2) {
    this.index = null;
    if (size2 > 0) {
      this.index = new _FlatBush(size2);
    }
  }
  add_rect(x0, y0, x1, y1) {
    var _a2;
    if (!isFinite(x0 + y0 + x1 + y1))
      this.add_empty();
    else
      (_a2 = this.index) == null ? void 0 : _a2.add(x0, y0, x1, y1);
  }
  add_point(x2, y2) {
    var _a2;
    if (!isFinite(x2 + y2))
      this.add_empty();
    else
      (_a2 = this.index) == null ? void 0 : _a2.add(x2, y2, x2, y2);
  }
  add_empty() {
    var _a2;
    (_a2 = this.index) == null ? void 0 : _a2.add(Infinity, Infinity, -Infinity, -Infinity);
  }
  finish() {
    var _a2;
    (_a2 = this.index) == null ? void 0 : _a2.finish();
  }
  _normalize(rect2) {
    let { x0, y0, x1, y1 } = rect2;
    if (x0 > x1)
      [x0, x1] = [x1, x0];
    if (y0 > y1)
      [y0, y1] = [y1, y0];
    return { x0, y0, x1, y1 };
  }
  get bbox() {
    if (this.index == null)
      return empty();
    else {
      const { minX, minY, maxX, maxY } = this.index;
      return { x0: minX, y0: minY, x1: maxX, y1: maxY };
    }
  }
  indices(rect2) {
    if (this.index == null)
      return new BitSet(0);
    else {
      const { x0, y0, x1, y1 } = this._normalize(rect2);
      return this.index.search_indices(x0, y0, x1, y1);
    }
  }
  bounds(rect2) {
    const bounds = empty();
    if (this.index == null)
      return bounds;
    const { boxes } = this.index;
    for (const i2 of this.indices(rect2)) {
      const x0 = boxes[4 * i2 + 0];
      const y0 = boxes[4 * i2 + 1];
      const x1 = boxes[4 * i2 + 2];
      const y1 = boxes[4 * i2 + 3];
      if (x0 >= rect2.x0 && x0 < bounds.x0)
        bounds.x0 = x0;
      if (x1 <= rect2.x1 && x1 > bounds.x1)
        bounds.x1 = x1;
      if (y0 >= rect2.y0 && y0 < bounds.y0)
        bounds.y0 = y0;
      if (y1 <= rect2.y1 && y1 > bounds.y1)
        bounds.y1 = y1;
    }
    return bounds;
  }
}
SpatialIndex.__name__ = "SpatialIndex";
const { abs: abs$1, ceil } = Math;
class GlyphView extends View {
  constructor() {
    super(...arguments);
    this._index = null;
    this._data_size = null;
    this._nohit_warned = /* @__PURE__ */ new Set();
  }
  get renderer() {
    return this.parent;
  }
  get has_webgl() {
    return this.glglyph != null;
  }
  get index() {
    const { _index } = this;
    if (_index != null)
      return _index;
    else
      throw new Error(`${this}.index_data() wasn't called`);
  }
  get data_size() {
    const { _data_size } = this;
    if (_data_size != null)
      return _data_size;
    else
      throw new Error(`${this}.set_data() wasn't called`);
  }
  initialize() {
    super.initialize();
    this.visuals = new Visuals(this);
  }
  request_render() {
    this.parent.request_render();
  }
  get canvas() {
    return this.renderer.parent.canvas_view;
  }
  render(ctx, indices, data2) {
    var _a2;
    if (this.glglyph != null) {
      this.renderer.needs_webgl_blit = this.glglyph.render(ctx, indices, (_a2 = this.base) != null ? _a2 : this);
      if (this.renderer.needs_webgl_blit)
        return;
    }
    this._render(ctx, indices, data2 != null ? data2 : this.base);
  }
  has_finished() {
    return true;
  }
  notify_finished() {
    this.renderer.notify_finished();
  }
  _bounds(bounds) {
    return bounds;
  }
  bounds() {
    return this._bounds(this.index.bbox);
  }
  log_bounds() {
    const { x0, x1 } = this.index.bounds(positive_x());
    const { y0, y1 } = this.index.bounds(positive_y());
    return this._bounds({ x0, y0, x1, y1 });
  }
  get_anchor_point(anchor, i2, [sx, sy]) {
    switch (anchor) {
      case "center":
      case "center_center": {
        const [x2, y2] = this.scenterxy(i2, sx, sy);
        return { x: x2, y: y2 };
      }
      default:
        return null;
    }
  }
  scenterx(i2, sx, sy) {
    return this.scenterxy(i2, sx, sy)[0];
  }
  scentery(i2, sx, sy) {
    return this.scenterxy(i2, sx, sy)[1];
  }
  sdist(scale, pts, spans, pts_location = "edge", dilate = false) {
    const n2 = pts.length;
    const sdist = new ScreenArray(n2);
    const compute = scale.s_compute;
    if (pts_location == "center") {
      for (let i2 = 0; i2 < n2; i2++) {
        const pts_i = pts[i2];
        const halfspan_i = spans.get(i2) / 2;
        const spt0 = compute(pts_i - halfspan_i);
        const spt1 = compute(pts_i + halfspan_i);
        sdist[i2] = abs$1(spt1 - spt0);
      }
    } else {
      for (let i2 = 0; i2 < n2; i2++) {
        const pts_i = pts[i2];
        const spt0 = compute(pts_i);
        const spt1 = compute(pts_i + spans.get(i2));
        sdist[i2] = abs$1(spt1 - spt0);
      }
    }
    if (dilate)
      inplace_map(sdist, (sd) => ceil(sd));
    return sdist;
  }
  draw_legend_for_index(_ctx, _bbox, _index) {
  }
  hit_test(geometry) {
    switch (geometry.type) {
      case "point":
        if (this._hit_point != null)
          return this._hit_point(geometry);
        break;
      case "span":
        if (this._hit_span != null)
          return this._hit_span(geometry);
        break;
      case "rect":
        if (this._hit_rect != null)
          return this._hit_rect(geometry);
        break;
      case "poly":
        if (this._hit_poly != null)
          return this._hit_poly(geometry);
        break;
    }
    if (!this._nohit_warned.has(geometry.type)) {
      logger.debug(`'${geometry.type}' selection not available for ${this.model.type}`);
      this._nohit_warned.add(geometry.type);
    }
    return null;
  }
  _hit_rect_against_index(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const [x0, x1] = this.renderer.coordinates.x_scale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.coordinates.y_scale.r_invert(sy0, sy1);
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  _project_data() {
  }
  *_iter_visuals() {
    for (const visual of this.visuals) {
      for (const prop of visual) {
        if (prop instanceof VectorSpec || prop instanceof ScalarSpec)
          yield prop;
      }
    }
  }
  set_base(base) {
    if (base != this && base instanceof this.constructor)
      this.base = base;
  }
  _configure(prop, descriptor) {
    Object.defineProperty(this, isString(prop) ? prop : prop.attr, {
      configurable: true,
      enumerable: true,
      ...descriptor
    });
  }
  set_visuals(source, indices) {
    var _a2;
    for (const prop of this._iter_visuals()) {
      const { base } = this;
      if (base != null) {
        const base_prop = base.model.properties[prop.attr];
        if (base_prop != null && is_equal(prop.get_value(), base_prop.get_value())) {
          this._configure(prop, {
            get() {
              return base[`${prop.attr}`];
            }
          });
          continue;
        }
      }
      const uniform = prop.uniform(source).select(indices);
      this._configure(prop, { value: uniform });
    }
    for (const visual of this.visuals) {
      visual.update();
    }
    (_a2 = this.glglyph) == null ? void 0 : _a2.set_visuals_changed();
  }
  set_data(source, indices, indices_to_update) {
    var _a2;
    const { x_source, y_source } = this.renderer.coordinates;
    const visual_props = new Set(this._iter_visuals());
    this._data_size = indices.count;
    for (const prop of this.model) {
      if (!(prop instanceof VectorSpec || prop instanceof ScalarSpec))
        continue;
      if (visual_props.has(prop))
        continue;
      if (prop instanceof BaseCoordinateSpec) {
        const base_array = prop.array(source);
        let array = indices.select(base_array);
        const range2 = prop.dimension == "x" ? x_source : y_source;
        if (range2 instanceof FactorRange) {
          if (prop instanceof CoordinateSpec) {
            array = range2.v_synthetic(array);
          } else if (prop instanceof CoordinateSeqSpec) {
            for (let i2 = 0; i2 < array.length; i2++) {
              array[i2] = range2.v_synthetic(array[i2]);
            }
          }
        }
        let final_array;
        if (prop instanceof CoordinateSeqSpec) {
          final_array = RaggedArray.from(array, Float64Array);
        } else
          final_array = array;
        this._configure(`_${prop.attr}`, { value: final_array });
      } else {
        const uniform = prop.uniform(source).select(indices);
        this._configure(prop, { value: uniform });
        if (prop instanceof DistanceSpec) {
          const max_value = uniform.is_Scalar() ? uniform.value : max$8(uniform.array);
          this._configure(`max_${prop.attr}`, { value: max_value });
        }
      }
    }
    if (this.renderer.plot_view.model.use_map) {
      this._project_data();
    }
    this._set_data(indices_to_update != null ? indices_to_update : null);
    (_a2 = this.glglyph) == null ? void 0 : _a2.set_data_changed();
    this.index_data();
  }
  _set_data(_indices) {
  }
  get _index_size() {
    return this.data_size;
  }
  index_data() {
    const index2 = new SpatialIndex(this._index_size);
    this._index_data(index2);
    index2.finish();
    this._index = index2;
  }
  mask_data() {
    if (this._mask_data == null)
      return BitSet.all_set(this.data_size);
    else
      return this._mask_data();
  }
  map_data() {
    var _a2;
    const self2 = this;
    const { x_scale, y_scale } = this.renderer.coordinates;
    for (const prop of this.model) {
      if (prop instanceof BaseCoordinateSpec) {
        const scale = prop.dimension == "x" ? x_scale : y_scale;
        let array = self2[`_${prop.attr}`];
        if (array instanceof RaggedArray) {
          const screen = scale.v_compute(array.array);
          array = new RaggedArray(array.offsets, screen);
        } else {
          array = scale.v_compute(array);
        }
        this[`s${prop.attr}`] = array;
      }
    }
    this._map_data();
    (_a2 = this.glglyph) == null ? void 0 : _a2.set_data_changed();
  }
  _map_data() {
  }
}
GlyphView.__name__ = "GlyphView";
class Glyph extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
Glyph.__name__ = "Glyph";
var _a$35;
class XYGlyphView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x, this._y);
  }
  _index_data(index2) {
    const { _x: _x2, _y, data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x2 = _x2[i2];
      const y2 = _y[i2];
      index2.add_point(x2, y2);
    }
  }
  scenterxy(i2) {
    return [this.sx[i2], this.sy[i2]];
  }
}
XYGlyphView.__name__ = "XYGlyphView";
class XYGlyph extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$35 = XYGlyph;
XYGlyph.__name__ = "XYGlyph";
(() => {
  _a$35.define(({}) => ({
    x: [XCoordinateSpec, { field: "x" }],
    y: [YCoordinateSpec, { field: "y" }]
  }));
})();
function point_in_poly(x2, y2, px, py) {
  let inside = false;
  let x1 = px[px.length - 1];
  let y1 = py[py.length - 1];
  for (let i2 = 0; i2 < px.length; i2++) {
    const x22 = px[i2];
    const y22 = py[i2];
    if (y1 < y2 != y22 < y2) {
      if (x1 + (y2 - y1) / (y22 - y1) * (x22 - x1) < x2)
        inside = !inside;
    }
    x1 = x22;
    y1 = y22;
  }
  return inside;
}
function point_in_ellipse(x2, y2, angle, b, a2, x0, y0) {
  const A = (Math.cos(angle) / a2) ** 2 + (Math.sin(angle) / b) ** 2;
  const B = 2 * Math.cos(angle) * Math.sin(angle) * ((1 / a2) ** 2 - (1 / b) ** 2);
  const C = (Math.cos(angle) / b) ** 2 + (Math.sin(angle) / a2) ** 2;
  const eqn = A * (x2 - x0) ** 2 + B * (x2 - x0) * (y2 - y0) + C * (y2 - y0) ** 2;
  const inside = eqn <= 1;
  return inside;
}
function dist_2_pts(p0, p1) {
  return (p0.x - p1.x) ** 2 + (p0.y - p1.y) ** 2;
}
function dist_to_segment_squared(p2, v, w) {
  const l2 = dist_2_pts(v, w);
  if (l2 == 0)
    return dist_2_pts(p2, v);
  const t = ((p2.x - v.x) * (w.x - v.x) + (p2.y - v.y) * (w.y - v.y)) / l2;
  if (t < 0)
    return dist_2_pts(p2, v);
  if (t > 1)
    return dist_2_pts(p2, w);
  const q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
  return dist_2_pts(p2, q);
}
function dist_to_segment(p2, v, w) {
  return Math.sqrt(dist_to_segment_squared(p2, v, w));
}
function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
  const den = (l1_y1 - l1_y0) * (l0_x1 - l0_x0) - (l1_x1 - l1_x0) * (l0_y1 - l0_y0);
  if (den == 0) {
    return { hit: false, x: null, y: null };
  } else {
    let a2 = l0_y0 - l1_y0;
    let b = l0_x0 - l1_x0;
    const num1 = (l1_x1 - l1_x0) * a2 - (l1_y1 - l1_y0) * b;
    const num2 = (l0_x1 - l0_x0) * a2 - (l0_y1 - l0_y0) * b;
    a2 = num1 / den;
    b = num2 / den;
    const x2 = l0_x0 + a2 * (l0_x1 - l0_x0);
    const y2 = l0_y0 + a2 * (l0_y1 - l0_y0);
    return { hit: a2 > 0 && a2 < 1 && (b > 0 && b < 1), x: x2, y: y2 };
  }
}
function generic_line_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
  ctx.save();
  ctx.beginPath();
  ctx.moveTo(x0, (y0 + y1) / 2);
  ctx.lineTo(x1, (y0 + y1) / 2);
  visuals.line.apply(ctx);
  ctx.restore();
}
function generic_line_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i2) {
  ctx.save();
  ctx.beginPath();
  ctx.moveTo(x0, (y0 + y1) / 2);
  ctx.lineTo(x1, (y0 + y1) / 2);
  visuals.line.apply(ctx, i2);
  ctx.restore();
}
function generic_area_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
  var _a2, _b2;
  const w = Math.abs(x1 - x0);
  const dw = w * 0.1;
  const h2 = Math.abs(y1 - y0);
  const dh = h2 * 0.1;
  const sx0 = x0 + dw;
  const sx1 = x1 - dw;
  const sy0 = y0 + dh;
  const sy1 = y1 - dh;
  ctx.beginPath();
  ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
  visuals.fill.apply(ctx);
  (_a2 = visuals.hatch) == null ? void 0 : _a2.apply(ctx);
  (_b2 = visuals.line) == null ? void 0 : _b2.apply(ctx);
}
function generic_area_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i2) {
  var _a2, _b2;
  const w = Math.abs(x1 - x0);
  const dw = w * 0.1;
  const h2 = Math.abs(y1 - y0);
  const dh = h2 * 0.1;
  const sx0 = x0 + dw;
  const sx1 = x1 - dw;
  const sy0 = y0 + dh;
  const sy1 = y1 - dh;
  ctx.beginPath();
  ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
  visuals.fill.apply(ctx, i2);
  (_a2 = visuals.hatch) == null ? void 0 : _a2.apply(ctx, i2);
  (_b2 = visuals.line) == null ? void 0 : _b2.apply(ctx, i2);
}
function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
  const { sx, sy } = geometry;
  let x0, x1;
  let y0, y1;
  if (geometry.type == "point") {
    [y0, y1] = renderer.yscale.r_invert(sy - 1, sy + 1);
    [x0, x1] = renderer.xscale.r_invert(sx - 1, sx + 1);
  } else {
    if (geometry.direction == "v") {
      [y0, y1] = renderer.yscale.r_invert(sy, sy);
      [x0, x1] = [Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)];
    } else {
      [x0, x1] = renderer.xscale.r_invert(sx, sx);
      [y0, y1] = [Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)];
    }
  }
  const { x: x4, y: y4 } = check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
  return [x4, y4];
}
var _a$34;
class LineView extends XYGlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl == null ? void 0 : webgl.regl_wrapper.has_webgl) {
      const { LineGL: LineGL2 } = await Promise.resolve().then(function() {
        return line_gl;
      });
      this.glglyph = new LineGL2(webgl.regl_wrapper, this);
    }
  }
  _render(ctx, indices, data2) {
    const { sx, sy } = data2 != null ? data2 : this;
    let last_i = null;
    const gap = (i2) => last_i != null && i2 - last_i != 1;
    let move = true;
    ctx.beginPath();
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      if (!isFinite(sx_i + sy_i))
        move = true;
      else {
        if (move || gap(i2)) {
          ctx.moveTo(sx_i, sy_i);
          move = false;
        } else
          ctx.lineTo(sx_i, sy_i);
      }
      last_i = i2;
    }
    this.visuals.line.set_value(ctx);
    ctx.stroke();
  }
  _hit_point(geometry) {
    const result = new Selection();
    const point = { x: geometry.sx, y: geometry.sy };
    let shortest = 9999;
    const threshold = Math.max(2, this.line_width.value / 2);
    for (let i2 = 0, end = this.sx.length - 1; i2 < end; i2++) {
      const p0 = { x: this.sx[i2], y: this.sy[i2] };
      const p1 = { x: this.sx[i2 + 1], y: this.sy[i2 + 1] };
      const dist = dist_to_segment(point, p0, p1);
      if (dist < threshold && dist < shortest) {
        shortest = dist;
        result.add_to_selected_glyphs(this.model);
        result.view = this;
        result.line_indices = [i2];
      }
    }
    return result;
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    const result = new Selection();
    let val;
    let values2;
    if (geometry.direction == "v") {
      val = this.renderer.yscale.invert(sy);
      values2 = this._y;
    } else {
      val = this.renderer.xscale.invert(sx);
      values2 = this._x;
    }
    for (let i2 = 0, end = values2.length - 1; i2 < end; i2++) {
      if (values2[i2] <= val && val <= values2[i2 + 1] || values2[i2 + 1] <= val && val <= values2[i2]) {
        result.add_to_selected_glyphs(this.model);
        result.view = this;
        result.line_indices.push(i2);
      }
    }
    return result;
  }
  get_interpolation_hit(i2, geometry) {
    const [x2, y2, x3, y3] = [this._x[i2], this._y[i2], this._x[i2 + 1], this._y[i2 + 1]];
    return line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
  }
  draw_legend_for_index(ctx, bbox, _index) {
    generic_line_scalar_legend(this.visuals, ctx, bbox);
  }
}
LineView.__name__ = "LineView";
class Line extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$34 = Line;
Line.__name__ = "Line";
(() => {
  _a$34.prototype.default_view = LineView;
  _a$34.mixins(LineScalar$1);
})();
var _a$33;
class PatchView extends XYGlyphView {
  _render(ctx, indices, data2) {
    const { sx, sy } = data2 != null ? data2 : this;
    let move = true;
    ctx.beginPath();
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      if (!isFinite(sx_i + sy_i)) {
        ctx.closePath();
        move = true;
      } else {
        if (move) {
          ctx.moveTo(sx_i, sy_i);
          move = false;
        } else
          ctx.lineTo(sx_i, sy_i);
      }
    }
    ctx.closePath();
    this.visuals.fill.apply(ctx);
    this.visuals.hatch.apply(ctx);
    this.visuals.line.apply(ctx);
  }
  draw_legend_for_index(ctx, bbox, _index) {
    generic_area_scalar_legend(this.visuals, ctx, bbox);
  }
  _hit_point(geometry) {
    const result = new Selection();
    if (point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
      result.add_to_selected_glyphs(this.model);
      result.view = this;
    }
    return result;
  }
}
PatchView.__name__ = "PatchView";
class Patch extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$33 = Patch;
Patch.__name__ = "Patch";
(() => {
  _a$33.prototype.default_view = PatchView;
  _a$33.mixins([LineScalar$1, FillScalar$1, HatchScalar$1]);
})();
var _a$32;
class AreaView extends GlyphView {
  draw_legend_for_index(ctx, bbox, _index) {
    generic_area_scalar_legend(this.visuals, ctx, bbox);
  }
}
AreaView.__name__ = "AreaView";
class Area extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$32 = Area;
Area.__name__ = "Area";
(() => {
  _a$32.mixins([FillScalar$1, HatchScalar$1]);
})();
var _a$31;
class HAreaView extends AreaView {
  _index_data(index2) {
    const { min: min2, max: max2 } = Math;
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x1 = this._x1[i2];
      const x2 = this._x2[i2];
      const y2 = this._y[i2];
      index2.add_rect(min2(x1, x2), y2, max2(x1, x2), y2);
    }
  }
  _render(ctx, _indices, data2) {
    const { sx1, sx2, sy } = data2 != null ? data2 : this;
    ctx.beginPath();
    for (let i2 = 0, end = sx1.length; i2 < end; i2++) {
      ctx.lineTo(sx1[i2], sy[i2]);
    }
    for (let i2 = sx2.length - 1; i2 >= 0; i2--) {
      ctx.lineTo(sx2[i2], sy[i2]);
    }
    ctx.closePath();
    this.visuals.fill.apply(ctx);
    this.visuals.hatch.apply(ctx);
  }
  _hit_point(geometry) {
    const L = this.sy.length;
    const result = new Selection();
    for (let i2 = 0, end = L - 1; i2 < end; i2++) {
      const sx = [this.sx1[i2], this.sx1[i2 + 1], this.sx2[i2 + 1], this.sx2[i2]];
      const sy = [this.sy[i2], this.sy[i2 + 1], this.sy[i2 + 1], this.sy[i2]];
      if (point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
        result.add_to_selected_glyphs(this.model);
        result.view = this;
        result.line_indices = [i2];
        break;
      }
    }
    return result;
  }
  scenterxy(i2) {
    const scx = (this.sx1[i2] + this.sx2[i2]) / 2;
    const scy = this.sy[i2];
    return [scx, scy];
  }
  _map_data() {
    this.sx1 = this.renderer.xscale.v_compute(this._x1);
    this.sx2 = this.renderer.xscale.v_compute(this._x2);
    this.sy = this.renderer.yscale.v_compute(this._y);
  }
}
HAreaView.__name__ = "HAreaView";
class HArea extends Area {
  constructor(attrs) {
    super(attrs);
  }
}
_a$31 = HArea;
HArea.__name__ = "HArea";
(() => {
  _a$31.prototype.default_view = HAreaView;
  _a$31.define(({}) => ({
    x1: [XCoordinateSpec, { field: "x1" }],
    x2: [XCoordinateSpec, { field: "x2" }],
    y: [YCoordinateSpec, { field: "y" }]
  }));
})();
var _a$30;
class VAreaView extends AreaView {
  _index_data(index2) {
    const { min: min2, max: max2 } = Math;
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x2 = this._x[i2];
      const y1 = this._y1[i2];
      const y2 = this._y2[i2];
      index2.add_rect(x2, min2(y1, y2), x2, max2(y1, y2));
    }
  }
  _render(ctx, _indices, data2) {
    const { sx, sy1, sy2 } = data2 != null ? data2 : this;
    ctx.beginPath();
    for (let i2 = 0, end = sy1.length; i2 < end; i2++) {
      ctx.lineTo(sx[i2], sy1[i2]);
    }
    for (let i2 = sy2.length - 1; i2 >= 0; i2--) {
      ctx.lineTo(sx[i2], sy2[i2]);
    }
    ctx.closePath();
    this.visuals.fill.apply(ctx);
    this.visuals.hatch.apply(ctx);
  }
  scenterxy(i2) {
    const scx = this.sx[i2];
    const scy = (this.sy1[i2] + this.sy2[i2]) / 2;
    return [scx, scy];
  }
  _hit_point(geometry) {
    const L = this.sx.length;
    const result = new Selection();
    for (let i2 = 0, end = L - 1; i2 < end; i2++) {
      const sx = [this.sx[i2], this.sx[i2 + 1], this.sx[i2 + 1], this.sx[i2]];
      const sy = [this.sy1[i2], this.sy1[i2 + 1], this.sy2[i2 + 1], this.sy2[i2]];
      if (point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
        result.add_to_selected_glyphs(this.model);
        result.view = this;
        result.line_indices = [i2];
        break;
      }
    }
    return result;
  }
  _map_data() {
    this.sx = this.renderer.xscale.v_compute(this._x);
    this.sy1 = this.renderer.yscale.v_compute(this._y1);
    this.sy2 = this.renderer.yscale.v_compute(this._y2);
  }
}
VAreaView.__name__ = "VAreaView";
class VArea extends Area {
  constructor(attrs) {
    super(attrs);
  }
}
_a$30 = VArea;
VArea.__name__ = "VArea";
(() => {
  _a$30.prototype.default_view = VAreaView;
  _a$30.define(({}) => ({
    x: [XCoordinateSpec, { field: "x" }],
    y1: [YCoordinateSpec, { field: "y1" }],
    y2: [YCoordinateSpec, { field: "y2" }]
  }));
})();
class Filter extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
Filter.__name__ = "Filter";
var _a$2$;
class CDSView extends Model {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this.compute_indices();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.properties.filters.change, () => this.compute_indices());
    const connect_listeners = () => {
      const fn = () => this.compute_indices();
      if (this.source != null) {
        this.connect(this.source.change, fn);
        if (this.source instanceof ColumnarDataSource) {
          this.connect(this.source.streaming, fn);
          this.connect(this.source.patching, fn);
        }
      }
    };
    let initialized2 = this.source != null;
    if (initialized2)
      connect_listeners();
    else {
      this.connect(this.properties.source.change, () => {
        if (!initialized2) {
          connect_listeners();
          initialized2 = true;
        }
      });
    }
  }
  compute_indices() {
    var _a2;
    const { source } = this;
    if (source == null)
      return;
    const size2 = (_a2 = source.get_length()) != null ? _a2 : 1;
    const indices = BitSet.all_set(size2);
    for (const filter2 of this.filters) {
      indices.intersect(filter2.compute_indices(source));
    }
    this.indices = indices;
    this._indices = [...indices];
    this.indices_map_to_subset();
  }
  indices_map_to_subset() {
    this.indices_map = {};
    for (let i2 = 0; i2 < this._indices.length; i2++) {
      this.indices_map[this._indices[i2]] = i2;
    }
  }
  convert_selection_from_subset(selection_subset) {
    return selection_subset.map((i2) => this._indices[i2]);
  }
  convert_selection_to_subset(selection_full) {
    return selection_full.map((i2) => this.indices_map[i2]);
  }
  convert_indices_from_subset(indices) {
    return indices.map((i2) => this._indices[i2]);
  }
}
_a$2$ = CDSView;
CDSView.__name__ = "CDSView";
(() => {
  _a$2$.define(({ Array: Array2, Ref: Ref2 }) => ({
    filters: [Array2(Ref2(Filter)), []],
    source: [Ref2(ColumnarDataSource)]
  }));
  _a$2$.internal(({ Int: Int2, Dict: Dict2, Ref: Ref2, Nullable: Nullable2 }) => ({
    indices: [Ref2(BitSet)],
    indices_map: [Dict2(Int2), {}],
    masked: [Nullable2(Ref2(BitSet)), null]
  }));
})();
var _a$2_;
const selection_defaults = {
  fill: {},
  line: {}
};
const decimated_defaults = {
  fill: { fill_alpha: 0.3, fill_color: "grey" },
  line: { line_alpha: 0.3, line_color: "grey" }
};
const nonselection_defaults = {
  fill: { fill_alpha: 0.2 },
  line: {}
};
const muted_defaults = {
  fill: { fill_alpha: 0.2 },
  line: {}
};
class GlyphRendererView extends DataRendererView {
  get glyph_view() {
    return this.glyph;
  }
  async lazy_initialize() {
    var _a2;
    await super.lazy_initialize();
    const base_glyph = this.model.glyph;
    this.glyph = await this.build_glyph_view(base_glyph);
    const has_fill = "fill" in this.glyph.visuals;
    const has_line = "line" in this.glyph.visuals;
    const glyph_attrs = { ...base_glyph.attributes };
    delete glyph_attrs.id;
    function mk_glyph(defaults2) {
      const attrs = clone$1(glyph_attrs);
      if (has_fill)
        extend$1(attrs, defaults2.fill);
      if (has_line)
        extend$1(attrs, defaults2.line);
      return new base_glyph.constructor(attrs);
    }
    function glyph_from_mode(defaults2, glyph) {
      if (glyph instanceof Glyph) {
        return glyph;
      } else if (glyph == "auto") {
        return mk_glyph(defaults2);
      }
      return mk_glyph({ fill: {}, line: {} });
    }
    let { selection_glyph, nonselection_glyph, hover_glyph, muted_glyph } = this.model;
    selection_glyph = glyph_from_mode(selection_defaults, selection_glyph);
    this.selection_glyph = await this.build_glyph_view(selection_glyph);
    nonselection_glyph = glyph_from_mode(nonselection_defaults, nonselection_glyph);
    this.nonselection_glyph = await this.build_glyph_view(nonselection_glyph);
    if (hover_glyph != null)
      this.hover_glyph = await this.build_glyph_view(hover_glyph);
    muted_glyph = glyph_from_mode(muted_defaults, muted_glyph);
    this.muted_glyph = await this.build_glyph_view(muted_glyph);
    const decimated_glyph = glyph_from_mode(decimated_defaults, "auto");
    this.decimated_glyph = await this.build_glyph_view(decimated_glyph);
    this.selection_glyph.set_base(this.glyph);
    this.nonselection_glyph.set_base(this.glyph);
    (_a2 = this.hover_glyph) == null ? void 0 : _a2.set_base(this.glyph);
    this.muted_glyph.set_base(this.glyph);
    this.decimated_glyph.set_base(this.glyph);
    this.set_data();
  }
  async build_glyph_view(glyph) {
    return build_view(glyph, { parent: this });
  }
  remove() {
    var _a2;
    this.glyph.remove();
    this.selection_glyph.remove();
    this.nonselection_glyph.remove();
    (_a2 = this.hover_glyph) == null ? void 0 : _a2.remove();
    this.muted_glyph.remove();
    this.decimated_glyph.remove();
    super.remove();
  }
  connect_signals() {
    super.connect_signals();
    const render2 = () => this.request_render();
    const update = () => this.update_data();
    this.connect(this.model.change, render2);
    this.connect(this.glyph.model.change, update);
    this.connect(this.selection_glyph.model.change, update);
    this.connect(this.nonselection_glyph.model.change, update);
    if (this.hover_glyph != null)
      this.connect(this.hover_glyph.model.change, update);
    this.connect(this.muted_glyph.model.change, update);
    this.connect(this.decimated_glyph.model.change, update);
    this.connect(this.model.data_source.change, update);
    this.connect(this.model.data_source.streaming, update);
    this.connect(this.model.data_source.patching, (indices) => this.update_data(indices));
    this.connect(this.model.data_source.selected.change, render2);
    this.connect(this.model.data_source._select, render2);
    if (this.hover_glyph != null)
      this.connect(this.model.data_source.inspect, render2);
    this.connect(this.model.properties.view.change, update);
    this.connect(this.model.view.properties.indices.change, update);
    this.connect(this.model.view.properties.masked.change, () => this.set_visuals());
    this.connect(this.model.properties.visible.change, () => this.plot_view.invalidate_dataranges = true);
    const { x_ranges, y_ranges } = this.plot_view.frame;
    for (const [, range2] of x_ranges) {
      if (range2 instanceof FactorRange)
        this.connect(range2.change, update);
    }
    for (const [, range2] of y_ranges) {
      if (range2 instanceof FactorRange)
        this.connect(range2.change, update);
    }
    const { transformchange, exprchange } = this.model.glyph;
    this.connect(transformchange, update);
    this.connect(exprchange, update);
  }
  _update_masked_indices() {
    const masked = this.glyph.mask_data();
    this.model.view.masked = masked;
    return masked;
  }
  update_data(indices) {
    this.set_data(indices);
    this.request_render();
  }
  set_data(indices) {
    const source = this.model.data_source;
    this.all_indices = this.model.view.indices;
    const { all_indices } = this;
    this.glyph.set_data(source, all_indices, indices);
    this.set_visuals();
    this._update_masked_indices();
    const { lod_factor } = this.plot_model;
    const n2 = this.all_indices.count;
    this.decimated = new BitSet(n2);
    for (let i2 = 0; i2 < n2; i2 += lod_factor) {
      this.decimated.set(i2);
    }
    this.plot_view.invalidate_dataranges = true;
  }
  set_visuals() {
    var _a2;
    const source = this.model.data_source;
    const { all_indices } = this;
    this.glyph.set_visuals(source, all_indices);
    this.decimated_glyph.set_visuals(source, all_indices);
    this.selection_glyph.set_visuals(source, all_indices);
    this.nonselection_glyph.set_visuals(source, all_indices);
    (_a2 = this.hover_glyph) == null ? void 0 : _a2.set_visuals(source, all_indices);
    this.muted_glyph.set_visuals(source, all_indices);
  }
  get has_webgl() {
    return this.glyph.has_webgl;
  }
  _render() {
    const glsupport = this.has_webgl;
    this.glyph.map_data();
    const all_indices = [...this.all_indices];
    let indices = [...this._update_masked_indices()];
    const { ctx } = this.layer;
    ctx.save();
    const { selected } = this.model.data_source;
    let selected_full_indices;
    if (!selected || selected.is_empty())
      selected_full_indices = [];
    else {
      if (this.glyph instanceof LineView && selected.selected_glyph === this.glyph.model)
        selected_full_indices = this.model.view.convert_indices_from_subset(indices);
      else
        selected_full_indices = selected.indices;
    }
    const { inspected } = this.model.data_source;
    const inspected_full_indices = new Set((() => {
      if (!inspected || inspected.is_empty())
        return [];
      else {
        if (inspected.selected_glyph)
          return this.model.view.convert_indices_from_subset(indices);
        else if (inspected.indices.length > 0)
          return inspected.indices;
        else {
          return Object.keys(inspected.multiline_indices).map((i2) => parseInt(i2));
        }
      }
    })());
    const inspected_subset_indices = filter(indices, (i2) => inspected_full_indices.has(all_indices[i2]));
    const { lod_threshold } = this.plot_model;
    let glyph;
    let nonselection_glyph;
    let selection_glyph;
    if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false) && !glsupport && lod_threshold != null && all_indices.length > lod_threshold) {
      indices = [...this.decimated];
      glyph = this.decimated_glyph;
      nonselection_glyph = this.decimated_glyph;
      selection_glyph = this.selection_glyph;
    } else {
      glyph = this.model.muted ? this.muted_glyph : this.glyph;
      nonselection_glyph = this.nonselection_glyph;
      selection_glyph = this.selection_glyph;
    }
    if (this.hover_glyph != null && inspected_subset_indices.length) {
      const set = new Set(indices);
      for (const i2 of inspected_subset_indices) {
        set.delete(i2);
      }
      indices = [...set];
    }
    if (!selected_full_indices.length) {
      if (this.glyph instanceof LineView) {
        if (this.hover_glyph && inspected_subset_indices.length)
          this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
        else
          glyph.render(ctx, all_indices);
      } else if (this.glyph instanceof PatchView || this.glyph instanceof HAreaView || this.glyph instanceof VAreaView) {
        if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
          glyph.render(ctx, all_indices);
        } else {
          for (const sglyph of inspected.selected_glyphs) {
            if (sglyph == this.glyph.model)
              this.hover_glyph.render(ctx, all_indices);
          }
        }
      } else {
        glyph.render(ctx, indices);
        if (this.hover_glyph && inspected_subset_indices.length)
          this.hover_glyph.render(ctx, inspected_subset_indices);
      }
    } else {
      const selected_mask = {};
      for (const i2 of selected_full_indices) {
        selected_mask[i2] = true;
      }
      const selected_subset_indices = new Array();
      const nonselected_subset_indices = new Array();
      if (this.glyph instanceof LineView) {
        for (const i2 of all_indices) {
          if (selected_mask[i2] != null)
            selected_subset_indices.push(i2);
          else
            nonselected_subset_indices.push(i2);
        }
      } else {
        for (const i2 of indices) {
          if (selected_mask[all_indices[i2]] != null)
            selected_subset_indices.push(i2);
          else
            nonselected_subset_indices.push(i2);
        }
      }
      nonselection_glyph.render(ctx, nonselected_subset_indices);
      selection_glyph.render(ctx, selected_subset_indices);
      if (this.hover_glyph != null) {
        if (this.glyph instanceof LineView)
          this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
        else
          this.hover_glyph.render(ctx, inspected_subset_indices);
      }
    }
    ctx.restore();
  }
  draw_legend(ctx, x0, x1, y0, y1, field, label2, index2) {
    if (this.glyph.data_size == 0)
      return;
    if (index2 == null)
      index2 = this.model.get_reference_point(field, label2);
    this.glyph.draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index2);
  }
  hit_test(geometry) {
    if (!this.model.visible)
      return null;
    const hit_test_result = this.glyph.hit_test(geometry);
    if (hit_test_result == null)
      return null;
    return this.model.view.convert_selection_from_subset(hit_test_result);
  }
}
GlyphRendererView.__name__ = "GlyphRendererView";
class GlyphRenderer extends DataRenderer {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    if (this.view.source != this.data_source) {
      this.view.source = this.data_source;
      this.view.compute_indices();
    }
  }
  get_reference_point(field, value) {
    if (field != null) {
      const data2 = this.data_source.get_column(field);
      if (data2 != null) {
        for (const [key, index2] of Object.entries(this.view.indices_map)) {
          if (data2[parseInt(key)] == value)
            return index2;
        }
      }
    }
    return 0;
  }
  get_selection_manager() {
    return this.data_source.selection_manager;
  }
}
_a$2_ = GlyphRenderer;
GlyphRenderer.__name__ = "GlyphRenderer";
(() => {
  _a$2_.prototype.default_view = GlyphRendererView;
  _a$2_.define(({ Boolean: Boolean2, Auto: Auto2, Or: Or2, Ref: Ref2, Null: Null2, Nullable: Nullable2 }) => ({
    data_source: [Ref2(ColumnarDataSource)],
    view: [Ref2(CDSView), (self2) => new CDSView({ source: self2.data_source })],
    glyph: [Ref2(Glyph)],
    hover_glyph: [Nullable2(Ref2(Glyph)), null],
    nonselection_glyph: [Or2(Ref2(Glyph), Auto2, Null2), "auto"],
    selection_glyph: [Or2(Ref2(Glyph), Auto2, Null2), "auto"],
    muted_glyph: [Or2(Ref2(Glyph), Auto2, Null2), "auto"],
    muted: [Boolean2, false]
  }));
})();
var _a$2Z;
class ContinuousColorMapper extends ColorMapper {
  constructor(attrs) {
    super(attrs);
    this._scan_data = null;
  }
  connect_signals() {
    super.connect_signals();
    const connect_renderers = () => {
      for (const [renderer] of this.domain) {
        this.connect(renderer.view.change, () => this.update_data());
        this.connect(renderer.data_source.selected.change, () => this.update_data());
      }
    };
    this.connect(this.properties.domain.change, () => connect_renderers());
    connect_renderers();
  }
  update_data() {
    const { domain, palette } = this;
    const all_data = [...this._collect(domain)];
    this._scan_data = this.scan(all_data, palette.length);
    this.metrics_change.emit();
    this.change.emit();
  }
  get metrics() {
    if (this._scan_data == null) {
      this.update_data();
    }
    return this._scan_data;
  }
  *_collect(domain) {
    for (const [renderer, fields] of domain) {
      for (const field of isArray(fields) ? fields : [fields]) {
        let array = renderer.data_source.get_column(field);
        array = renderer.view.indices.select(array);
        const masked = renderer.view.masked;
        const selected = renderer.data_source.selected.indices;
        let subset;
        if (masked != null && selected.length > 0)
          subset = intersection([...masked], selected);
        else if (masked != null)
          subset = [...masked];
        else if (selected.length > 0)
          subset = selected;
        if (subset != null) {
          array = map(subset, (i2) => array[i2]);
        }
        if (array.length > 0 && !isNumber(array[0])) {
          for (const subarray of array) {
            yield* subarray;
          }
        } else {
          yield* array;
        }
      }
    }
  }
  _v_compute(data2, values2, palette, colors) {
    const { nan_color } = colors;
    let { low_color, high_color } = colors;
    if (low_color == null)
      low_color = palette[0];
    if (high_color == null)
      high_color = palette[palette.length - 1];
    const { domain } = this;
    const all_data = !is_empty$1(domain) ? [...this._collect(domain)] : data2;
    this._scan_data = this.scan(all_data, palette.length);
    this.metrics_change.emit();
    for (let i2 = 0, end = data2.length; i2 < end; i2++) {
      const d = data2[i2];
      if (isNaN(d))
        values2[i2] = nan_color;
      else
        values2[i2] = this.cmap(d, palette, low_color, high_color, this._scan_data);
    }
  }
  _colors(conv) {
    return {
      ...super._colors(conv),
      low_color: this.low_color != null ? conv(this.low_color) : void 0,
      high_color: this.high_color != null ? conv(this.high_color) : void 0
    };
  }
}
_a$2Z = ContinuousColorMapper;
ContinuousColorMapper.__name__ = "ContinuousColorMapper";
(() => {
  _a$2Z.define(({ Number: Number2, String: String2, Ref: Ref2, Color: Color2, Or: Or2, Tuple: Tuple2, Array: Array2, Nullable: Nullable2 }) => {
    return {
      high: [Nullable2(Number2), null],
      low: [Nullable2(Number2), null],
      high_color: [Nullable2(Color2), null],
      low_color: [Nullable2(Color2), null],
      domain: [Array2(Tuple2(Ref2(GlyphRenderer), Or2(String2, Array2(String2)))), []]
    };
  });
})();
class ScanningColorMapper extends ContinuousColorMapper {
  constructor(attrs) {
    super(attrs);
  }
  cmap(d, palette, low_color, high_color, edges) {
    if (d < edges.binning[0])
      return low_color;
    if (d > edges.binning[edges.binning.length - 1])
      return high_color;
    const key = left_edge_index(d, edges.binning);
    return palette[key];
  }
}
ScanningColorMapper.__name__ = "ScanningColorMapper";
var _a$2Y;
class BinnedTicker extends Ticker {
  constructor(attrs) {
    super(attrs);
  }
  get_ticks(data_low, data_high, _range, _cross_loc) {
    const { binning } = this.mapper.metrics;
    const k_low = Math.max(0, left_edge_index(data_low, binning));
    const k_high = Math.min(left_edge_index(data_high, binning) + 1, binning.length - 1);
    const _major = [];
    for (let k = k_low; k <= k_high; k++) {
      _major.push(binning[k]);
    }
    const { num_major_ticks } = this;
    const major = [];
    const n2 = num_major_ticks == "auto" ? _major.length : num_major_ticks;
    const step = Math.max(1, Math.floor(_major.length / n2));
    for (let i2 = 0; i2 < _major.length; i2 += step) {
      major.push(_major[i2]);
    }
    return {
      major,
      minor: []
    };
  }
}
_a$2Y = BinnedTicker;
BinnedTicker.__name__ = "BinnedTicker";
(() => {
  _a$2Y.define(({ Number: Number2, Ref: Ref2, Or: Or2, Auto: Auto2 }) => ({
    mapper: [Ref2(ScanningColorMapper)],
    num_major_ticks: [Or2(Number2, Auto2), 8]
  }));
})();
var _a$2X;
class FuncTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  _make_func() {
    const code = use_strict(this.code);
    return new Function("tick", "index", "ticks", ...this.names, code);
  }
  doFormat(ticks, _opts) {
    const cache = {};
    const func = this._make_func().bind(cache);
    return ticks.map((tick, index2, ticks2) => `${func(tick, index2, ticks2, ...this.values)}`);
  }
}
_a$2X = FuncTickFormatter;
FuncTickFormatter.__name__ = "FuncTickFormatter";
(() => {
  _a$2X.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    code: [String2, ""]
  }));
})();
var _a$2W;
class NumeralTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  get _rounding_fn() {
    switch (this.rounding) {
      case "round":
      case "nearest":
        return Math.round;
      case "floor":
      case "rounddown":
        return Math.floor;
      case "ceil":
      case "roundup":
        return Math.ceil;
    }
  }
  doFormat(ticks, _opts) {
    const { format, language, _rounding_fn } = this;
    return ticks.map((tick) => numbro.exports.format(tick, format, language, _rounding_fn));
  }
}
_a$2W = NumeralTickFormatter;
NumeralTickFormatter.__name__ = "NumeralTickFormatter";
(() => {
  _a$2W.define(({ String: String2 }) => ({
    format: [String2, "0,0"],
    language: [String2, "en"],
    rounding: [RoundingFunction, "round"]
  }));
})();
var _a$2V;
class PrintfTickFormatter extends TickFormatter {
  constructor(attrs) {
    super(attrs);
  }
  doFormat(ticks, _opts) {
    return ticks.map((tick) => sprintf(this.format, tick));
  }
}
_a$2V = PrintfTickFormatter;
PrintfTickFormatter.__name__ = "PrintfTickFormatter";
(() => {
  _a$2V.define(({ String: String2 }) => ({
    format: [String2, "%s"]
  }));
})();
function _cat_equals(a2, b) {
  if (a2.length != b.length)
    return false;
  for (let i2 = 0, end = a2.length; i2 < end; i2++) {
    if (a2[i2] !== b[i2])
      return false;
  }
  return true;
}
function cat_v_compute(data2, factors, targets, values2, start2, end, extra_value) {
  const N = data2.length;
  for (let i2 = 0; i2 < N; i2++) {
    let d = data2[i2];
    let key;
    if (isString(d))
      key = index_of(factors, d);
    else {
      if (start2 != null) {
        if (end != null)
          d = d.slice(start2, end);
        else
          d = d.slice(start2);
      } else if (end != null)
        d = d.slice(0, end);
      if (d.length == 1)
        key = index_of(factors, d[0]);
      else
        key = find_index(factors, (x2) => _cat_equals(x2, d));
    }
    let value;
    if (key < 0 || key >= targets.length)
      value = extra_value;
    else
      value = targets[key];
    values2[i2] = value;
  }
}
var _a$2U;
class CategoricalColorMapper extends ColorMapper {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(data2, values2, palette, { nan_color }) {
    cat_v_compute(data2, this.factors, palette, values2, this.start, this.end, nan_color);
  }
}
_a$2U = CategoricalColorMapper;
CategoricalColorMapper.__name__ = "CategoricalColorMapper";
(() => {
  _a$2U.define(({ Number: Number2, Nullable: Nullable2 }) => ({
    factors: [FactorSeq],
    start: [Number2, 0],
    end: [Nullable2(Number2), null]
  }));
})();
var _a$2T;
class CategoricalMarkerMapper extends Mapper {
  constructor(attrs) {
    super(attrs);
  }
  v_compute(xs) {
    const values2 = new Array(xs.length);
    cat_v_compute(xs, this.factors, this.markers, values2, this.start, this.end, this.default_value);
    return values2;
  }
}
_a$2T = CategoricalMarkerMapper;
CategoricalMarkerMapper.__name__ = "CategoricalMarkerMapper";
(() => {
  _a$2T.define(({ Number: Number2, Array: Array2, Nullable: Nullable2 }) => ({
    factors: [FactorSeq],
    markers: [Array2(MarkerType)],
    start: [Number2, 0],
    end: [Nullable2(Number2), null],
    default_value: [MarkerType, "circle"]
  }));
})();
var _a$2S;
class CategoricalPatternMapper extends Mapper {
  constructor(attrs) {
    super(attrs);
  }
  v_compute(xs) {
    const values2 = new Array(xs.length);
    cat_v_compute(xs, this.factors, this.patterns, values2, this.start, this.end, this.default_value);
    return values2;
  }
}
_a$2S = CategoricalPatternMapper;
CategoricalPatternMapper.__name__ = "CategoricalPatternMapper";
(() => {
  _a$2S.define(({ Number: Number2, Array: Array2, Nullable: Nullable2 }) => ({
    factors: [FactorSeq],
    patterns: [Array2(HatchPatternType)],
    start: [Number2, 0],
    end: [Nullable2(Number2), null],
    default_value: [HatchPatternType, " "]
  }));
})();
class LinearColorMapper extends ContinuousColorMapper {
  constructor(attrs) {
    super(attrs);
  }
  scan(data2, n2) {
    const low = this.low != null ? this.low : min$6(data2);
    const high = this.high != null ? this.high : max$8(data2);
    const norm_factor = 1 / (high - low);
    const normed_interval = 1 / n2;
    return { max: high, min: low, norm_factor, normed_interval };
  }
  cmap(d, palette, low_color, high_color, scan_data) {
    const max_key = palette.length - 1;
    if (d == scan_data.max) {
      return palette[max_key];
    }
    const normed_d = (d - scan_data.min) * scan_data.norm_factor;
    const key = Math.floor(normed_d / scan_data.normed_interval);
    if (key < 0)
      return low_color;
    else if (key > max_key)
      return high_color;
    else
      return palette[key];
  }
}
LinearColorMapper.__name__ = "LinearColorMapper";
class LogColorMapper extends ContinuousColorMapper {
  constructor(attrs) {
    super(attrs);
  }
  scan(data2, n2) {
    const low = this.low != null ? this.low : min$6(data2);
    const high = this.high != null ? this.high : max$8(data2);
    const scale = n2 / (Math.log(high) - Math.log(low));
    return { max: high, min: low, scale };
  }
  cmap(d, palette, low_color, high_color, scan_data) {
    const max_key = palette.length - 1;
    if (d > scan_data.max) {
      return high_color;
    }
    if (d == scan_data.max)
      return palette[max_key];
    else if (d < scan_data.min)
      return low_color;
    const log2 = Math.log(d) - Math.log(scan_data.min);
    let key = Math.floor(log2 * scan_data.scale);
    if (key > max_key) {
      key = max_key;
    }
    return palette[key];
  }
}
LogColorMapper.__name__ = "LogColorMapper";
var _a$2R;
class EqHistColorMapper extends ScanningColorMapper {
  constructor(attrs) {
    super(attrs);
  }
  scan(data2, n2) {
    let low = this.low != null ? this.low : min$6(data2);
    const high = this.high != null ? this.high : max$8(data2);
    const nbins = this.bins;
    const eq_bin_edges = linspace(low, high, nbins + 1);
    const full_hist = bin_counts(data2, eq_bin_edges);
    let nhist = 0;
    for (let i2 = 0; i2 < nbins; i2++) {
      if (full_hist[i2] != 0)
        nhist++;
    }
    const hist = new Array(nhist + 1);
    const eq_bin_centers = new Array(nhist + 1);
    for (let i2 = 0, j = 1; i2 < nbins; i2++) {
      if (full_hist[i2] != 0) {
        hist[j] = full_hist[i2];
        eq_bin_centers[j] = (eq_bin_edges[i2] + eq_bin_edges[i2 + 1]) / 2;
        j++;
      }
    }
    hist[0] = 0;
    eq_bin_centers[0] = 2 * eq_bin_centers[1] - eq_bin_centers[nhist];
    const cdf = cumsum(hist);
    const lo = cdf[1];
    const diff = cdf[nhist] - lo;
    for (let i2 = 1; i2 <= nhist; i2++)
      cdf[i2] = (cdf[i2] - lo) / diff;
    cdf[0] = -1;
    let lower_span = 0;
    if (this.rescale_discrete_levels) {
      const discrete_levels = nhist;
      const m = -0.5 / 98;
      const c = 1.5 - 2 * m;
      const multiple = m * discrete_levels + c;
      if (multiple > 1)
        lower_span = 1 - multiple;
    }
    const cdf_bins = linspace(lower_span, 1, n2 + 1);
    const binning = interpolate(cdf_bins, cdf, eq_bin_centers);
    if (this.rescale_discrete_levels)
      low = binning[0];
    else
      binning[0] = low;
    binning[binning.length - 1] = high;
    return { min: low, max: high, binning };
  }
}
_a$2R = EqHistColorMapper;
EqHistColorMapper.__name__ = "EqHistColorMapper";
(() => {
  _a$2R.define(({ Boolean: Boolean2, Int: Int2 }) => ({
    bins: [Int2, 256 * 256],
    rescale_discrete_levels: [Boolean2, false]
  }));
})();
var _a$2Q;
class LinearInterpolationScale extends Scale {
  constructor(attrs) {
    super(attrs);
  }
  connect_signals() {
    super.connect_signals();
    const { source_range, target_range } = this.properties;
    this.on_change([source_range, target_range], () => {
      this.linear_scale = new LinearScale({
        source_range: this.source_range,
        target_range: this.target_range
      });
    });
  }
  get s_compute() {
    throw new Error("not implemented");
  }
  get s_invert() {
    throw new Error("not implemented");
  }
  compute(x2) {
    return x2;
  }
  v_compute(vs) {
    const { binning } = this;
    const { start: start2, end } = this.source_range;
    const min_val = start2;
    const max_val = end;
    const n2 = binning.length;
    const step = (end - start2) / (n2 - 1);
    const mapping = new Float64Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      mapping[i2] = start2 + i2 * step;
    }
    const vvs = map(vs, (v) => {
      if (v < min_val)
        return min_val;
      if (v > max_val)
        return max_val;
      const k = left_edge_index(v, binning);
      if (k == -1)
        return min_val;
      if (k >= n2 - 1)
        return max_val;
      const b0 = binning[k];
      const b1 = binning[k + 1];
      const c = (v - b0) / (b1 - b0);
      const m0 = mapping[k];
      const m1 = mapping[k + 1];
      return m0 + c * (m1 - m0);
    });
    return this.linear_scale.v_compute(vvs);
  }
  invert(xprime) {
    return xprime;
  }
  v_invert(xprimes) {
    return new Float64Array(xprimes);
  }
}
_a$2Q = LinearInterpolationScale;
LinearInterpolationScale.__name__ = "LinearInterpolationScale";
(() => {
  _a$2Q.internal(({ Arrayable: Arrayable2, Ref: Ref2 }) => ({
    binning: [Arrayable2],
    linear_scale: [
      Ref2(LinearScale),
      (self2) => new LinearScale({
        source_range: self2.source_range,
        target_range: self2.target_range
      })
    ]
  }));
})();
class Stack$3 extends Layoutable {
  constructor() {
    super(...arguments);
    this.children = [];
  }
  *[Symbol.iterator]() {
    yield* this.children;
  }
}
Stack$3.__name__ = "Stack";
class HStack extends Stack$3 {
  _measure(_viewport) {
    let width = 0;
    let height = 0;
    for (const child of this.children) {
      const size_hint = child.measure({ width: 0, height: 0 });
      width += size_hint.width;
      height = Math.max(height, size_hint.height);
    }
    return { width, height };
  }
  _set_geometry(outer, inner) {
    super._set_geometry(outer, inner);
    const top = this.absolute ? outer.top : 0;
    let left2 = this.absolute ? outer.left : 0;
    const { height } = outer;
    for (const child of this.children) {
      const { width } = child.measure({ width: 0, height: 0 });
      child.set_geometry(new BBox$2({ left: left2, width, top, height }));
      left2 += width;
    }
  }
}
HStack.__name__ = "HStack";
class VStack extends Stack$3 {
  _measure(_viewport) {
    let width = 0;
    let height = 0;
    for (const child of this.children) {
      const size_hint = child.measure({ width: 0, height: 0 });
      width = Math.max(width, size_hint.width);
      height += size_hint.height;
    }
    return { width, height };
  }
  _set_geometry(outer, inner) {
    super._set_geometry(outer, inner);
    const left2 = this.absolute ? outer.left : 0;
    let top = this.absolute ? outer.top : 0;
    const { width } = outer;
    for (const child of this.children) {
      const { height } = child.measure({ width: 0, height: 0 });
      child.set_geometry(new BBox$2({ top, height, left: left2, width }));
      top += height;
    }
  }
}
VStack.__name__ = "VStack";
class NodeLayout extends Layoutable {
  constructor() {
    super(...arguments);
    this.children = [];
  }
  *[Symbol.iterator]() {
    yield* this.children;
  }
  _measure(viewport) {
    const { width_policy, height_policy } = this.sizing;
    const { min: min2, max: max2 } = Math;
    let max_width = 0;
    let max_height = 0;
    for (const layout of this.children) {
      const { width: width2, height: height2 } = layout.measure(viewport);
      max_width = max2(max_width, width2);
      max_height = max2(max_height, height2);
    }
    const width = (() => {
      const { width: width2 } = this.sizing;
      if (viewport.width == Infinity) {
        return width_policy == "fixed" ? width2 != null ? width2 : max_width : max_width;
      } else {
        switch (width_policy) {
          case "fixed":
            return width2 != null ? width2 : max_width;
          case "min":
            return max_width;
          case "fit":
            return width2 != null ? min2(viewport.width, width2) : viewport.width;
          case "max":
            return width2 != null ? max2(viewport.width, width2) : viewport.width;
        }
      }
    })();
    const height = (() => {
      const { height: height2 } = this.sizing;
      if (viewport.height == Infinity) {
        return height_policy == "fixed" ? height2 != null ? height2 : max_height : max_height;
      } else {
        switch (height_policy) {
          case "fixed":
            return height2 != null ? height2 : max_height;
          case "min":
            return max_height;
          case "fit":
            return height2 != null ? min2(viewport.height, height2) : viewport.height;
          case "max":
            return height2 != null ? max2(viewport.height, height2) : viewport.height;
        }
      }
    })();
    return { width, height };
  }
  _set_geometry(outer, inner) {
    super._set_geometry(outer, inner);
    const bbox = this.absolute ? outer : outer.relative();
    const { left: left2, right: right2, top, bottom } = bbox;
    const vcenter = Math.round(bbox.vcenter);
    const hcenter = Math.round(bbox.hcenter);
    for (const layout of this.children) {
      const { margin, halign, valign } = layout.sizing;
      const { width, height, inner: inner2 } = layout.measure(outer);
      const bbox2 = (() => {
        const anchor = `${valign}_${halign}`;
        switch (anchor) {
          case "start_start":
            return new BBox$2({ left: left2 + margin.left, top: top + margin.top, width, height });
          case "start_center":
            return new BBox$2({ hcenter, top: top + margin.top, width, height });
          case "start_end":
            return new BBox$2({ right: right2 - margin.right, top: top + margin.top, width, height });
          case "center_start":
            return new BBox$2({ left: left2 + margin.left, vcenter, width, height });
          case "center_center":
            return new BBox$2({ hcenter, vcenter, width, height });
          case "center_end":
            return new BBox$2({ right: right2 - margin.right, vcenter, width, height });
          case "end_start":
            return new BBox$2({ left: left2 + margin.left, bottom: bottom - margin.bottom, width, height });
          case "end_center":
            return new BBox$2({ hcenter, bottom: bottom - margin.bottom, width, height });
          case "end_end":
            return new BBox$2({ right: right2 - margin.right, bottom: bottom - margin.bottom, width, height });
        }
      })();
      const inner_bbox = inner2 == null ? bbox2 : new BBox$2({
        left: bbox2.left + inner2.left,
        top: bbox2.top + inner2.top,
        right: bbox2.right - inner2.right,
        bottom: bbox2.bottom - inner2.bottom
      });
      layout.set_geometry(bbox2, inner_bbox);
    }
  }
}
NodeLayout.__name__ = "NodeLayout";
const { max: max$3, round } = Math;
class DefaultMap {
  constructor(def) {
    this.def = def;
    this._map = /* @__PURE__ */ new Map();
  }
  get(key) {
    let value = this._map.get(key);
    if (value === void 0) {
      value = this.def();
      this._map.set(key, value);
    }
    return value;
  }
  apply(key, fn) {
    const value = this.get(key);
    this._map.set(key, fn(value));
  }
}
DefaultMap.__name__ = "DefaultMap";
class Container {
  constructor() {
    this._items = [];
    this._nrows = 0;
    this._ncols = 0;
  }
  get nrows() {
    return this._nrows;
  }
  get ncols() {
    return this._ncols;
  }
  add(span2, data2) {
    const { r1, c1 } = span2;
    this._nrows = max$3(this._nrows, r1 + 1);
    this._ncols = max$3(this._ncols, c1 + 1);
    this._items.push({ span: span2, data: data2 });
  }
  at(r, c) {
    const selected = this._items.filter(({ span: span2 }) => {
      return span2.r0 <= r && r <= span2.r1 && span2.c0 <= c && c <= span2.c1;
    });
    return selected.map(({ data: data2 }) => data2);
  }
  row(r) {
    const selected = this._items.filter(({ span: span2 }) => span2.r0 <= r && r <= span2.r1);
    return selected.map(({ data: data2 }) => data2);
  }
  col(c) {
    const selected = this._items.filter(({ span: span2 }) => span2.c0 <= c && c <= span2.c1);
    return selected.map(({ data: data2 }) => data2);
  }
  foreach(fn) {
    for (const { span: span2, data: data2 } of this._items) {
      fn(span2, data2);
    }
  }
  map(fn) {
    const result = new Container();
    for (const { span: span2, data: data2 } of this._items) {
      result.add(span2, fn(span2, data2));
    }
    return result;
  }
}
Container.__name__ = "Container";
class Grid$1 extends Layoutable {
  constructor(items = []) {
    super();
    this.items = items;
    this.rows = "auto";
    this.cols = "auto";
    this.spacing = 0;
  }
  *[Symbol.iterator]() {
    for (const { layout } of this.items) {
      yield layout;
    }
  }
  is_width_expanding() {
    if (super.is_width_expanding())
      return true;
    if (this.sizing.width_policy == "fixed")
      return false;
    const { cols } = this._state;
    return some(cols, (col) => col.policy == "max");
  }
  is_height_expanding() {
    if (super.is_height_expanding())
      return true;
    if (this.sizing.height_policy == "fixed")
      return false;
    const { rows } = this._state;
    return some(rows, (row2) => row2.policy == "max");
  }
  _init() {
    var _a2, _b2, _c2, _d2;
    super._init();
    const items = new Container();
    for (const { layout, row: row2, col, row_span, col_span } of this.items) {
      if (layout.sizing.visible) {
        const r0 = row2;
        const c0 = col;
        const r1 = row2 + (row_span != null ? row_span : 1) - 1;
        const c1 = col + (col_span != null ? col_span : 1) - 1;
        items.add({ r0, c0, r1, c1 }, layout);
      }
    }
    const { nrows, ncols } = items;
    const rows = new Array(nrows);
    for (let y2 = 0; y2 < nrows; y2++) {
      const row2 = (() => {
        var _a3;
        const sizing = isPlainObject(this.rows) ? (_a3 = this.rows[y2]) != null ? _a3 : this.rows["*"] : this.rows;
        if (sizing == null)
          return { policy: "auto" };
        else if (isNumber(sizing))
          return { policy: "fixed", height: sizing };
        else if (isString(sizing))
          return { policy: sizing };
        else
          return sizing;
      })();
      const align = (_a2 = row2.align) != null ? _a2 : "auto";
      if (row2.policy == "fixed")
        rows[y2] = { policy: "fixed", height: row2.height, align };
      else if (row2.policy == "min")
        rows[y2] = { policy: "min", align };
      else if (row2.policy == "fit" || row2.policy == "max")
        rows[y2] = { policy: row2.policy, flex: (_b2 = row2.flex) != null ? _b2 : 1, align };
      else if (row2.policy == "auto") {
        if (some(items.row(y2), (layout) => layout.is_height_expanding()))
          rows[y2] = { policy: "max", flex: 1, align };
        else
          rows[y2] = { policy: "min", align };
      } else
        throw new Error("unrechable");
    }
    const cols = new Array(ncols);
    for (let x2 = 0; x2 < ncols; x2++) {
      const col = (() => {
        var _a3;
        const sizing = isPlainObject(this.cols) ? (_a3 = this.cols[x2]) != null ? _a3 : this.cols["*"] : this.cols;
        if (sizing == null)
          return { policy: "auto" };
        else if (isNumber(sizing))
          return { policy: "fixed", width: sizing };
        else if (isString(sizing))
          return { policy: sizing };
        else
          return sizing;
      })();
      const align = (_c2 = col.align) != null ? _c2 : "auto";
      if (col.policy == "fixed")
        cols[x2] = { policy: "fixed", width: col.width, align };
      else if (col.policy == "min")
        cols[x2] = { policy: "min", align };
      else if (col.policy == "fit" || col.policy == "max")
        cols[x2] = { policy: col.policy, flex: (_d2 = col.flex) != null ? _d2 : 1, align };
      else if (col.policy == "auto") {
        if (some(items.col(x2), (layout) => layout.is_width_expanding()))
          cols[x2] = { policy: "max", flex: 1, align };
        else
          cols[x2] = { policy: "min", align };
      } else
        throw new Error("unrechable");
    }
    const [rspacing, cspacing] = isNumber(this.spacing) ? [this.spacing, this.spacing] : this.spacing;
    this._state = { items, nrows, ncols, rows, cols, rspacing, cspacing };
  }
  _measure_totals(row_heights, col_widths) {
    const { nrows, ncols, rspacing, cspacing } = this._state;
    return {
      height: sum$2(row_heights) + (nrows - 1) * rspacing,
      width: sum$2(col_widths) + (ncols - 1) * cspacing
    };
  }
  _measure_cells(cell_viewport) {
    const { items, nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
    const row_heights = new Array(nrows);
    for (let r = 0; r < nrows; r++) {
      const row2 = rows[r];
      row_heights[r] = row2.policy == "fixed" ? row2.height : 0;
    }
    const col_widths = new Array(ncols);
    for (let c = 0; c < ncols; c++) {
      const col = cols[c];
      col_widths[c] = col.policy == "fixed" ? col.width : 0;
    }
    const size_hints = new Container();
    items.foreach((span2, layout) => {
      const { r0, c0, r1, c1 } = span2;
      const rspace = (r1 - r0) * rspacing;
      const cspace = (c1 - c0) * cspacing;
      let height = 0;
      for (let r = r0; r <= r1; r++) {
        height += cell_viewport(r, c0).height;
      }
      height += rspace;
      let width = 0;
      for (let c = c0; c <= c1; c++) {
        width += cell_viewport(r0, c).width;
      }
      width += cspace;
      const size_hint = layout.measure({ width, height });
      size_hints.add(span2, { layout, size_hint });
      const size3 = new Sizeable(size_hint).grow_by(layout.sizing.margin);
      size3.height -= rspace;
      size3.width -= cspace;
      const radjustable = [];
      for (let r = r0; r <= r1; r++) {
        const row2 = rows[r];
        if (row2.policy == "fixed")
          size3.height -= row2.height;
        else
          radjustable.push(r);
      }
      if (size3.height > 0) {
        const rheight = round(size3.height / radjustable.length);
        for (const r of radjustable) {
          row_heights[r] = max$3(row_heights[r], rheight);
        }
      }
      const cadjustable = [];
      for (let c = c0; c <= c1; c++) {
        const col = cols[c];
        if (col.policy == "fixed")
          size3.width -= col.width;
        else
          cadjustable.push(c);
      }
      if (size3.width > 0) {
        const cwidth = round(size3.width / cadjustable.length);
        for (const c of cadjustable) {
          col_widths[c] = max$3(col_widths[c], cwidth);
        }
      }
    });
    const size2 = this._measure_totals(row_heights, col_widths);
    return { size: size2, row_heights, col_widths, size_hints };
  }
  _measure_grid(viewport) {
    const { nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
    const preferred = this._measure_cells((y2, x2) => {
      const row2 = rows[y2];
      const col = cols[x2];
      return {
        width: col.policy == "fixed" ? col.width : Infinity,
        height: row2.policy == "fixed" ? row2.height : Infinity
      };
    });
    let available_height;
    if (this.sizing.height_policy == "fixed" && this.sizing.height != null)
      available_height = this.sizing.height;
    else if (viewport.height != Infinity && this.is_height_expanding())
      available_height = viewport.height;
    else
      available_height = preferred.size.height;
    let height_flex = 0;
    for (let y2 = 0; y2 < nrows; y2++) {
      const row2 = rows[y2];
      if (row2.policy == "fit" || row2.policy == "max")
        height_flex += row2.flex;
      else
        available_height -= preferred.row_heights[y2];
    }
    available_height -= (nrows - 1) * rspacing;
    if (height_flex != 0 && available_height > 0) {
      for (let y2 = 0; y2 < nrows; y2++) {
        const row2 = rows[y2];
        if (row2.policy == "fit" || row2.policy == "max") {
          const height = round(available_height * (row2.flex / height_flex));
          available_height -= height;
          preferred.row_heights[y2] = height;
          height_flex -= row2.flex;
        }
      }
    } else if (available_height < 0) {
      let nadjustable = 0;
      for (let y2 = 0; y2 < nrows; y2++) {
        const row2 = rows[y2];
        if (row2.policy != "fixed")
          nadjustable++;
      }
      let overflow_height = -available_height;
      for (let y2 = 0; y2 < nrows; y2++) {
        const row2 = rows[y2];
        if (row2.policy != "fixed") {
          const height = preferred.row_heights[y2];
          const cutoff = round(overflow_height / nadjustable);
          preferred.row_heights[y2] = max$3(height - cutoff, 0);
          overflow_height -= cutoff > height ? height : cutoff;
          nadjustable--;
        }
      }
    }
    let available_width;
    if (this.sizing.width_policy == "fixed" && this.sizing.width != null)
      available_width = this.sizing.width;
    else if (viewport.width != Infinity && this.is_width_expanding())
      available_width = viewport.width;
    else
      available_width = preferred.size.width;
    let width_flex = 0;
    for (let x2 = 0; x2 < ncols; x2++) {
      const col = cols[x2];
      if (col.policy == "fit" || col.policy == "max")
        width_flex += col.flex;
      else
        available_width -= preferred.col_widths[x2];
    }
    available_width -= (ncols - 1) * cspacing;
    if (width_flex != 0 && available_width > 0) {
      for (let x2 = 0; x2 < ncols; x2++) {
        const col = cols[x2];
        if (col.policy == "fit" || col.policy == "max") {
          const width = round(available_width * (col.flex / width_flex));
          available_width -= width;
          preferred.col_widths[x2] = width;
          width_flex -= col.flex;
        }
      }
    } else if (available_width < 0) {
      let nadjustable = 0;
      for (let x2 = 0; x2 < ncols; x2++) {
        const col = cols[x2];
        if (col.policy != "fixed")
          nadjustable++;
      }
      let overflow_width = -available_width;
      for (let x2 = 0; x2 < ncols; x2++) {
        const col = cols[x2];
        if (col.policy != "fixed") {
          const width = preferred.col_widths[x2];
          const cutoff = round(overflow_width / nadjustable);
          preferred.col_widths[x2] = max$3(width - cutoff, 0);
          overflow_width -= cutoff > width ? width : cutoff;
          nadjustable--;
        }
      }
    }
    const { row_heights, col_widths, size_hints } = this._measure_cells((y2, x2) => {
      return {
        width: preferred.col_widths[x2],
        height: preferred.row_heights[y2]
      };
    });
    const size2 = this._measure_totals(row_heights, col_widths);
    return { size: size2, row_heights, col_widths, size_hints };
  }
  _measure(viewport) {
    const { size: size2 } = this._measure_grid(viewport);
    return size2;
  }
  _set_geometry(outer, inner) {
    super._set_geometry(outer, inner);
    const { nrows, ncols, rspacing, cspacing } = this._state;
    const { row_heights, col_widths, size_hints } = this._measure_grid(outer);
    const rows = this._state.rows.map((row2, r) => {
      return { ...row2, top: 0, height: row_heights[r], get bottom() {
        return this.top + this.height;
      } };
    });
    const cols = this._state.cols.map((col, c) => {
      return { ...col, left: 0, width: col_widths[c], get right() {
        return this.left + this.width;
      } };
    });
    const items = size_hints.map((_2, item) => {
      return { ...item, outer: new BBox$2(), inner: new BBox$2() };
    });
    for (let r = 0, top = !this.absolute ? 0 : outer.top; r < nrows; r++) {
      const row2 = rows[r];
      row2.top = top;
      top += row2.height + rspacing;
    }
    for (let c = 0, left2 = !this.absolute ? 0 : outer.left; c < ncols; c++) {
      const col = cols[c];
      col.left = left2;
      left2 += col.width + cspacing;
    }
    function span_width(c0, c1) {
      let width = (c1 - c0) * cspacing;
      for (let c = c0; c <= c1; c++) {
        width += cols[c].width;
      }
      return width;
    }
    function span_height(r0, r1) {
      let height = (r1 - r0) * rspacing;
      for (let r = r0; r <= r1; r++) {
        height += rows[r].height;
      }
      return height;
    }
    items.foreach(({ r0, c0, r1, c1 }, item) => {
      const { layout, size_hint } = item;
      const { sizing } = layout;
      const { width, height } = size_hint;
      const span2 = {
        width: span_width(c0, c1),
        height: span_height(r0, r1)
      };
      const halign = c0 == c1 && cols[c0].align != "auto" ? cols[c0].align : sizing.halign;
      const valign = r0 == r1 && rows[r0].align != "auto" ? rows[r0].align : sizing.valign;
      let left2 = cols[c0].left;
      if (halign == "start")
        left2 += sizing.margin.left;
      else if (halign == "center")
        left2 += round((span2.width - width) / 2);
      else if (halign == "end")
        left2 += span2.width - sizing.margin.right - width;
      let top = rows[r0].top;
      if (valign == "start")
        top += sizing.margin.top;
      else if (valign == "center")
        top += round((span2.height - height) / 2);
      else if (valign == "end")
        top += span2.height - sizing.margin.bottom - height;
      item.outer = new BBox$2({ left: left2, top, width, height });
    });
    const row_aligns = rows.map(() => {
      return {
        start: new DefaultMap(() => 0),
        end: new DefaultMap(() => 0)
      };
    });
    const col_aligns = cols.map(() => {
      return {
        start: new DefaultMap(() => 0),
        end: new DefaultMap(() => 0)
      };
    });
    items.foreach(({ r0, c0, r1, c1 }, { size_hint, outer: outer2 }) => {
      const { inner: inner2 } = size_hint;
      if (inner2 != null) {
        row_aligns[r0].start.apply(outer2.top, (v) => max$3(v, inner2.top));
        row_aligns[r1].end.apply(rows[r1].bottom - outer2.bottom, (v) => max$3(v, inner2.bottom));
        col_aligns[c0].start.apply(outer2.left, (v) => max$3(v, inner2.left));
        col_aligns[c1].end.apply(cols[c1].right - outer2.right, (v) => max$3(v, inner2.right));
      }
    });
    items.foreach(({ r0, c0, r1, c1 }, item) => {
      const { size_hint, outer: outer2 } = item;
      const inner_bbox = (extents2) => {
        const outer_bbox = this.absolute ? outer2 : outer2.relative();
        const left2 = outer_bbox.left + extents2.left;
        const top = outer_bbox.top + extents2.top;
        const right2 = outer_bbox.right - extents2.right;
        const bottom = outer_bbox.bottom - extents2.bottom;
        return new BBox$2({ left: left2, top, right: right2, bottom });
      };
      if (size_hint.inner != null) {
        let inner2 = inner_bbox(size_hint.inner);
        if (size_hint.align !== false) {
          const top = row_aligns[r0].start.get(outer2.top);
          const bottom = row_aligns[r1].end.get(rows[r1].bottom - outer2.bottom);
          const left2 = col_aligns[c0].start.get(outer2.left);
          const right2 = col_aligns[c1].end.get(cols[c1].right - outer2.right);
          try {
            inner2 = inner_bbox({ top, bottom, left: left2, right: right2 });
          } catch {
          }
        }
        item.inner = inner2;
      } else
        item.inner = outer2;
    });
    items.foreach((_2, { layout, outer: outer2, inner: inner2 }) => {
      layout.set_geometry(outer2, inner2);
    });
  }
}
Grid$1.__name__ = "Grid";
class Row$1 extends Grid$1 {
  constructor(items) {
    super();
    this.items = items.map((item, i2) => ({ layout: item, row: 0, col: i2 }));
    this.rows = "fit";
  }
}
Row$1.__name__ = "Row";
class Column$1 extends Grid$1 {
  constructor(items) {
    super();
    this.items = items.map((item, i2) => ({ layout: item, row: i2, col: 0 }));
    this.cols = "fit";
  }
}
Column$1.__name__ = "Column";
class ContentBox extends ContentLayoutable {
  constructor(el) {
    super();
    this.content_size = unsized(el, () => new Sizeable(size(el)));
  }
  _content_size() {
    return this.content_size;
  }
}
ContentBox.__name__ = "ContentBox";
class VariadicBox extends Layoutable {
  constructor(el) {
    super();
    this.el = el;
  }
  _measure(viewport) {
    const bounded = new Sizeable(viewport).bounded_to(this.sizing.size);
    return sized(this.el, bounded, () => {
      const content = new Sizeable(content_size(this.el));
      const { border, padding } = extents(this.el);
      return content.grow_by(border).grow_by(padding).map(Math.ceil);
    });
  }
}
VariadicBox.__name__ = "VariadicBox";
class CachedVariadicBox extends VariadicBox {
  constructor(el) {
    super(el);
    this._cache = /* @__PURE__ */ new Map();
  }
  _measure(viewport) {
    const { width, height } = viewport;
    const key = `${width},${height}`;
    let size_hint = this._cache.get(key);
    if (size_hint == null) {
      size_hint = super._measure(viewport);
      this._cache.set(key, size_hint);
    }
    return size_hint;
  }
  invalidate_cache() {
    this._cache.clear();
  }
}
CachedVariadicBox.__name__ = "CachedVariadicBox";
class BorderLayout extends Layoutable {
  constructor() {
    super(...arguments);
    this.min_border = { left: 0, top: 0, right: 0, bottom: 0 };
    this.padding = { left: 0, top: 0, right: 0, bottom: 0 };
  }
  *[Symbol.iterator]() {
    yield this.top_panel;
    yield this.bottom_panel;
    yield this.left_panel;
    yield this.right_panel;
    yield this.center_panel;
  }
  _measure(viewport) {
    viewport = new Sizeable({
      width: this.sizing.width_policy == "fixed" || viewport.width == Infinity ? this.sizing.width : viewport.width,
      height: this.sizing.height_policy == "fixed" || viewport.height == Infinity ? this.sizing.height : viewport.height
    });
    const left_hint = this.left_panel.measure({ width: 0, height: viewport.height });
    const left2 = Math.max(left_hint.width, this.min_border.left) + this.padding.left;
    const right_hint = this.right_panel.measure({ width: 0, height: viewport.height });
    const right2 = Math.max(right_hint.width, this.min_border.right) + this.padding.right;
    const top_hint = this.top_panel.measure({ width: viewport.width, height: 0 });
    const top = Math.max(top_hint.height, this.min_border.top) + this.padding.top;
    const bottom_hint = this.bottom_panel.measure({ width: viewport.width, height: 0 });
    const bottom = Math.max(bottom_hint.height, this.min_border.bottom) + this.padding.bottom;
    const center_viewport = new Sizeable(viewport).shrink_by({ left: left2, right: right2, top, bottom });
    const center = this.center_panel.measure(center_viewport);
    const width = left2 + center.width + right2;
    const height = top + center.height + bottom;
    const align = (() => {
      const { width_policy, height_policy } = this.center_panel.sizing;
      return width_policy != "fixed" && height_policy != "fixed";
    })();
    return { width, height, inner: { left: left2, right: right2, top, bottom }, align };
  }
  _set_geometry(outer, inner) {
    super._set_geometry(outer, inner);
    this.center_panel.set_geometry(inner);
    const left_hint = this.left_panel.measure({ width: 0, height: outer.height });
    const right_hint = this.right_panel.measure({ width: 0, height: outer.height });
    const top_hint = this.top_panel.measure({ width: outer.width, height: 0 });
    const bottom_hint = this.bottom_panel.measure({ width: outer.width, height: 0 });
    const { left: left2, top, right: right2, bottom } = inner;
    this.top_panel.set_geometry(new BBox$2({ left: left2, right: right2, bottom: top, height: top_hint.height }));
    this.bottom_panel.set_geometry(new BBox$2({ left: left2, right: right2, top: bottom, height: bottom_hint.height }));
    this.left_panel.set_geometry(new BBox$2({ top, bottom, right: left2, width: left_hint.width }));
    this.right_panel.set_geometry(new BBox$2({ top, bottom, left: right2, width: right_hint.width }));
  }
}
BorderLayout.__name__ = "BorderLayout";
var _a$2P;
const MINOR_DIM = 25;
const MAJOR_DIM_MIN_SCALAR = 0.3;
const MAJOR_DIM_MAX_SCALAR = 0.8;
class ColorBarView extends AnnotationView {
  get orientation() {
    return this._orientation;
  }
  initialize() {
    super.initialize();
    const { ticker, formatter, color_mapper } = this.model;
    this._ticker = ticker != "auto" ? ticker : (() => {
      switch (true) {
        case color_mapper instanceof LogColorMapper:
          return new LogTicker();
        case color_mapper instanceof ScanningColorMapper:
          return new BinnedTicker({ mapper: color_mapper });
        case color_mapper instanceof CategoricalColorMapper:
          return new CategoricalTicker();
        default:
          return new BasicTicker();
      }
    })();
    this._formatter = formatter != "auto" ? formatter : (() => {
      switch (true) {
        case this._ticker instanceof LogTicker:
          return new LogTickFormatter();
        case color_mapper instanceof CategoricalColorMapper:
          return new CategoricalTickFormatter();
        default:
          return new BasicTickFormatter();
      }
    })();
    this._major_range = (() => {
      if (color_mapper instanceof CategoricalColorMapper) {
        const { factors } = color_mapper;
        return new FactorRange({ factors });
      } else if (color_mapper instanceof ContinuousColorMapper) {
        const { min: min2, max: max2 } = color_mapper.metrics;
        return new Range1d({ start: min2, end: max2 });
      } else
        unreachable();
    })();
    this._major_scale = (() => {
      if (color_mapper instanceof LinearColorMapper)
        return new LinearScale();
      else if (color_mapper instanceof LogColorMapper)
        return new LogScale();
      else if (color_mapper instanceof ScanningColorMapper) {
        const { binning } = color_mapper.metrics;
        return new LinearInterpolationScale({ binning });
      } else if (color_mapper instanceof CategoricalColorMapper) {
        return new CategoricalScale();
      } else
        unreachable();
    })();
    this._minor_range = new Range1d({ start: 0, end: 1 });
    this._minor_scale = new LinearScale();
    const major_label_text = attrs_of(this.model, "major_label_", Text$3, true);
    const major_tick_line = attrs_of(this.model, "major_tick_", Line$2, true);
    const minor_tick_line = attrs_of(this.model, "minor_tick_", Line$2, true);
    const title_text = attrs_of(this.model, "title_", Text$3);
    const AxisCls = (() => {
      if (color_mapper instanceof CategoricalColorMapper)
        return CategoricalAxis;
      else if (color_mapper instanceof LogColorMapper)
        return LogAxis;
      else
        return LinearAxis;
    })();
    this._axis = new AxisCls({
      ticker: this._ticker,
      formatter: this._formatter,
      major_tick_in: this.model.major_tick_in,
      major_tick_out: this.model.major_tick_out,
      minor_tick_in: this.model.minor_tick_in,
      minor_tick_out: this.model.minor_tick_out,
      major_label_standoff: this.model.label_standoff,
      major_label_overrides: this.model.major_label_overrides,
      major_label_policy: this.model.major_label_policy,
      axis_line_color: null,
      ...major_label_text,
      ...major_tick_line,
      ...minor_tick_line
    });
    const { title } = this.model;
    if (title) {
      this._title = new Title({
        text: title,
        standoff: this.model.title_standoff,
        ...title_text
      });
    }
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    const self2 = this;
    const parent = {
      get parent() {
        return self2.parent;
      },
      get root() {
        return self2.root;
      },
      get frame() {
        return self2._frame;
      },
      get canvas_view() {
        return self2.parent.canvas_view;
      },
      request_layout() {
        self2.parent.request_layout();
      }
    };
    this._axis_view = await build_view(this._axis, { parent });
    if (this._title != null)
      this._title_view = await build_view(this._title, { parent });
  }
  remove() {
    var _a2;
    (_a2 = this._title_view) == null ? void 0 : _a2.remove();
    this._axis_view.remove();
    super.remove();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this._ticker.change, () => this.request_render());
    this.connect(this._formatter.change, () => this.request_render());
    this.connect(this.model.color_mapper.metrics_change, () => {
      const range2 = this._major_range;
      const scale = this._major_scale;
      const { color_mapper } = this.model;
      if (color_mapper instanceof ContinuousColorMapper && range2 instanceof Range1d) {
        const { min: min2, max: max2 } = color_mapper.metrics;
        range2.setv({ start: min2, end: max2 });
      }
      if (color_mapper instanceof ScanningColorMapper && scale instanceof LinearInterpolationScale) {
        const { binning } = color_mapper.metrics;
        scale.binning = binning;
      }
      this._set_canvas_image();
      this.plot_view.request_layout();
    });
  }
  _set_canvas_image() {
    const { orientation } = this;
    const palette = (() => {
      const { palette: palette2 } = this.model.color_mapper;
      if (orientation == "vertical")
        return reversed(palette2);
      else
        return palette2;
    })();
    const [w, h2] = (() => {
      if (orientation == "vertical")
        return [1, palette.length];
      else
        return [palette.length, 1];
    })();
    const canvas2 = this._image = document.createElement("canvas");
    canvas2.width = w;
    canvas2.height = h2;
    const image_ctx = canvas2.getContext("2d");
    const image_data = image_ctx.getImageData(0, 0, w, h2);
    const cmap = new LinearColorMapper({ palette }).rgba_mapper;
    const buf8 = cmap.v_compute(range(0, palette.length));
    image_data.data.set(buf8);
    image_ctx.putImageData(image_data, 0, 0);
  }
  update_layout() {
    const { location, width: w, height: h2, padding, margin } = this.model;
    const [valign, halign] = (() => {
      if (isString(location)) {
        switch (location) {
          case "top_left":
            return ["start", "start"];
          case "top":
          case "top_center":
            return ["start", "center"];
          case "top_right":
            return ["start", "end"];
          case "bottom_left":
            return ["end", "start"];
          case "bottom":
          case "bottom_center":
            return ["end", "center"];
          case "bottom_right":
            return ["end", "end"];
          case "left":
          case "center_left":
            return ["center", "start"];
          case "center":
          case "center_center":
            return ["center", "center"];
          case "right":
          case "center_right":
            return ["center", "end"];
        }
      } else
        return ["end", "start"];
    })();
    const orientation = this._orientation = (() => {
      const { orientation: orientation2 } = this.model;
      if (orientation2 == "auto") {
        if (this.panel != null)
          return this.panel.is_horizontal ? "horizontal" : "vertical";
        else {
          if (halign == "start" || halign == "end" || halign == "center" && valign == "center")
            return "vertical";
          else
            return "horizontal";
        }
      } else
        return orientation2;
    })();
    const center_panel = new NodeLayout();
    const top_panel = new VStack();
    const bottom_panel = new VStack();
    const left_panel = new HStack();
    const right_panel = new HStack();
    center_panel.absolute = true;
    top_panel.absolute = true;
    bottom_panel.absolute = true;
    left_panel.absolute = true;
    right_panel.absolute = true;
    const [x_scale, y_scale, x_range, y_range] = (() => {
      if (orientation == "horizontal")
        return [this._major_scale, this._minor_scale, this._major_range, this._minor_range];
      else
        return [this._minor_scale, this._major_scale, this._minor_range, this._major_range];
    })();
    this._frame = new CartesianFrame(x_scale, y_scale, x_range, y_range);
    center_panel.on_resize((bbox) => this._frame.set_geometry(bbox));
    const layout = new BorderLayout();
    this._inner_layout = layout;
    layout.absolute = true;
    layout.center_panel = center_panel;
    layout.top_panel = top_panel;
    layout.bottom_panel = bottom_panel;
    layout.left_panel = left_panel;
    layout.right_panel = right_panel;
    const padding_box = { left: padding, right: padding, top: padding, bottom: padding };
    const margin_box = (() => {
      if (this.panel == null) {
        if (isString(location))
          return { left: margin, right: margin, top: margin, bottom: margin };
        else {
          const [left2, bottom] = location;
          return { left: left2, right: margin, top: margin, bottom };
        }
      } else {
        if (isString(location)) {
          layout.fixup_geometry = (outer, inner) => {
            const origin = outer;
            if (orientation == "horizontal") {
              const { top, width, height } = outer;
              if (halign == "end") {
                const { right: right2 } = this.layout.bbox;
                outer = new BBox$2({ right: right2, top, width, height });
              } else if (halign == "center") {
                const { hcenter } = this.layout.bbox;
                outer = new BBox$2({ hcenter: Math.round(hcenter), top, width, height });
              }
            } else {
              const { left: left2, width, height } = outer;
              if (valign == "end") {
                const { bottom } = this.layout.bbox;
                outer = new BBox$2({ left: left2, bottom, width, height });
              } else if (valign == "center") {
                const { vcenter } = this.layout.bbox;
                outer = new BBox$2({ left: left2, vcenter: Math.round(vcenter), width, height });
              }
            }
            if (inner != null) {
              const dh = outer.left - origin.left;
              const dv = outer.top - origin.top;
              const { left: left2, top, width, height } = inner;
              inner = new BBox$2({ left: left2 + dh, top: top + dv, width, height });
            }
            return [outer, inner];
          };
          return void 0;
        } else {
          const [left2, bottom] = location;
          layout.fixup_geometry = (outer, inner) => {
            const origin = outer;
            const grid = this.layout.bbox;
            const { width, height } = outer;
            outer = new BBox$2({ left: grid.left + left2, bottom: grid.bottom - bottom, width, height });
            if (inner != null) {
              const dh = outer.left - origin.left;
              const dv = outer.top - origin.top;
              const { left: left3, top, width: width2, height: height2 } = inner;
              inner = new BBox$2({ left: left3 + dh, top: top + dv, width: width2, height: height2 });
            }
            return [outer, inner];
          };
          return { left: left2, right: 0, top: 0, bottom };
        }
      }
    })();
    layout.padding = padding_box;
    let major_policy;
    let major_size;
    let min_major_size;
    let max_major_size;
    if (this.panel != null) {
      major_policy = "max";
      major_size = void 0;
      min_major_size = void 0;
      max_major_size = void 0;
    } else {
      if ((orientation == "horizontal" ? w : h2) == "auto") {
        major_policy = "fixed";
        major_size = this.model.color_mapper.palette.length * MINOR_DIM;
        min_major_size = { percent: MAJOR_DIM_MIN_SCALAR };
        max_major_size = { percent: MAJOR_DIM_MAX_SCALAR };
      } else {
        major_policy = "fit";
        major_size = void 0;
      }
    }
    if (orientation == "horizontal") {
      const width = w == "auto" ? void 0 : w;
      const height = h2 == "auto" ? MINOR_DIM : h2;
      layout.set_sizing({
        width_policy: major_policy,
        height_policy: "min",
        width: major_size,
        min_width: min_major_size,
        max_width: max_major_size,
        halign,
        valign,
        margin: margin_box
      });
      layout.center_panel.set_sizing({ width_policy: w == "auto" ? "fit" : "fixed", height_policy: "fixed", width, height });
    } else {
      const width = w == "auto" ? MINOR_DIM : w;
      const height = h2 == "auto" ? void 0 : h2;
      layout.set_sizing({
        width_policy: "min",
        height_policy: major_policy,
        height: major_size,
        min_height: min_major_size,
        max_height: max_major_size,
        halign,
        valign,
        margin: margin_box
      });
      layout.center_panel.set_sizing({ width_policy: "fixed", height_policy: h2 == "auto" ? "fit" : "fixed", width, height });
    }
    top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
    bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
    left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
    right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
    const { _title_view } = this;
    if (_title_view != null) {
      if (orientation == "horizontal") {
        _title_view.panel = new Panel$1("above");
        _title_view.update_layout();
        top_panel.children.push(_title_view.layout);
      } else {
        _title_view.panel = new Panel$1("left");
        _title_view.update_layout();
        left_panel.children.push(_title_view.layout);
      }
    }
    const { panel } = this;
    const side = (() => {
      if (panel != null && orientation == panel.orientation)
        return panel.side;
      else
        return orientation == "horizontal" ? "below" : "right";
    })();
    const stack = (() => {
      switch (side) {
        case "above":
          return top_panel;
        case "below":
          return bottom_panel;
        case "left":
          return left_panel;
        case "right":
          return right_panel;
      }
    })();
    const { _axis_view } = this;
    _axis_view.panel = new Panel$1(side);
    _axis_view.update_layout();
    stack.children.push(_axis_view.layout);
    if (this.panel != null) {
      const outer = new Grid$1([{ layout, row: 0, col: 0 }]);
      outer.absolute = true;
      if (orientation == "horizontal") {
        outer.set_sizing({ width_policy: "max", height_policy: "min" });
      } else {
        outer.set_sizing({ width_policy: "min", height_policy: "max" });
      }
      this.layout = outer;
    } else {
      this.layout = this._inner_layout;
    }
    const { visible } = this.model;
    this.layout.sizing.visible = visible;
    this._set_canvas_image();
  }
  _render() {
    var _a2;
    const { ctx } = this.layer;
    ctx.save();
    this._paint_bbox(ctx, this._inner_layout.bbox);
    this._paint_image(ctx, this._inner_layout.center_panel.bbox);
    (_a2 = this._title_view) == null ? void 0 : _a2.render();
    this._axis_view.render();
    ctx.restore();
  }
  _paint_bbox(ctx, bbox) {
    const { x: x2, y: y2 } = bbox;
    let { width, height } = bbox;
    if (x2 + width >= this.parent.canvas_view.bbox.width) {
      width -= 1;
    }
    if (y2 + height >= this.parent.canvas_view.bbox.height) {
      height -= 1;
    }
    ctx.save();
    if (this.visuals.background_fill.doit) {
      this.visuals.background_fill.set_value(ctx);
      ctx.fillRect(x2, y2, width, height);
    }
    if (this.visuals.border_line.doit) {
      this.visuals.border_line.set_value(ctx);
      ctx.strokeRect(x2, y2, width, height);
    }
    ctx.restore();
  }
  _paint_image(ctx, bbox) {
    const { x: x2, y: y2, width, height } = bbox;
    ctx.save();
    ctx.setImageSmoothingEnabled(false);
    ctx.globalAlpha = this.model.scale_alpha;
    ctx.drawImage(this._image, x2, y2, width, height);
    if (this.visuals.bar_line.doit) {
      this.visuals.bar_line.set_value(ctx);
      ctx.strokeRect(x2, y2, width, height);
    }
    ctx.restore();
  }
  serializable_state() {
    const { children: children2 = [], ...state } = super.serializable_state();
    if (this._title_view != null)
      children2.push(this._title_view.serializable_state());
    children2.push(this._axis_view.serializable_state());
    return { ...state, children: children2 };
  }
}
ColorBarView.__name__ = "ColorBarView";
class ColorBar extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2P = ColorBar;
ColorBar.__name__ = "ColorBar";
(() => {
  _a$2P.prototype.default_view = ColorBarView;
  _a$2P.mixins([
    ["major_label_", Text$3],
    ["title_", Text$3],
    ["major_tick_", Line$2],
    ["minor_tick_", Line$2],
    ["border_", Line$2],
    ["bar_", Line$2],
    ["background_", Fill$1]
  ]);
  _a$2P.define(({ Alpha: Alpha2, Number: Number2, String: String2, Tuple: Tuple2, Dict: Dict2, Or: Or2, Ref: Ref2, Auto: Auto2, Nullable: Nullable2 }) => ({
    location: [Or2(Anchor, Tuple2(Number2, Number2)), "top_right"],
    orientation: [Or2(Orientation, Auto2), "auto"],
    title: [Nullable2(String2), null],
    title_standoff: [Number2, 2],
    width: [Or2(Number2, Auto2), "auto"],
    height: [Or2(Number2, Auto2), "auto"],
    scale_alpha: [Alpha2, 1],
    ticker: [Or2(Ref2(Ticker), Auto2), "auto"],
    formatter: [Or2(Ref2(TickFormatter), Auto2), "auto"],
    major_label_overrides: [Dict2(Or2(String2, Ref2(BaseText))), {}],
    major_label_policy: [Ref2(LabelingPolicy), () => new NoOverlap()],
    color_mapper: [Ref2(ColorMapper)],
    label_standoff: [Number2, 5],
    margin: [Number2, 30],
    padding: [Number2, 10],
    major_tick_in: [Number2, 5],
    major_tick_out: [Number2, 0],
    minor_tick_in: [Number2, 0],
    minor_tick_out: [Number2, 0]
  }));
  _a$2P.override({
    background_fill_color: "#ffffff",
    background_fill_alpha: 0.95,
    bar_line_color: null,
    border_line_color: null,
    major_label_text_font_size: "11px",
    major_tick_line_color: "#ffffff",
    minor_tick_line_color: null,
    title_text_font_size: "13px",
    title_text_font_style: "italic"
  });
})();
var _a$2O;
class LabelView extends TextAnnotationView {
  update_layout() {
    const { panel } = this;
    if (panel != null)
      this.layout = new SideLayout(panel, () => this.get_size(), false);
    else
      this.layout = void 0;
  }
  _get_size() {
    const { text } = this.model;
    const graphics = new TextBox({ text });
    const { angle, angle_units } = this.model;
    graphics.angle = resolve_angle(angle, angle_units);
    graphics.visuals = this.visuals.text.values();
    const { width, height } = graphics.size();
    return { width, height };
  }
  _render() {
    const { angle, angle_units } = this.model;
    const rotation = resolve_angle(angle, angle_units);
    const panel = this.layout != null ? this.layout : this.plot_view.frame;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    let sx = this.model.x_units == "data" ? xscale.compute(this.model.x) : panel.bbox.xview.compute(this.model.x);
    let sy = this.model.y_units == "data" ? yscale.compute(this.model.y) : panel.bbox.yview.compute(this.model.y);
    sx += this.model.x_offset;
    sy -= this.model.y_offset;
    const draw = this.model.render_mode == "canvas" ? this._canvas_text.bind(this) : this._css_text.bind(this);
    draw(this.layer.ctx, this.model.text, sx, sy, rotation);
  }
}
LabelView.__name__ = "LabelView";
class Label extends TextAnnotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2O = Label;
Label.__name__ = "Label";
(() => {
  _a$2O.prototype.default_view = LabelView;
  _a$2O.mixins([
    Text$3,
    ["border_", Line$2],
    ["background_", Fill$1]
  ]);
  _a$2O.define(({ Number: Number2, String: String2, Angle: Angle2 }) => ({
    x: [Number2],
    x_units: [SpatialUnits, "data"],
    y: [Number2],
    y_units: [SpatialUnits, "data"],
    text: [String2, ""],
    angle: [Angle2, 0],
    angle_units: [AngleUnits, "rad"],
    x_offset: [Number2, 0],
    y_offset: [Number2, 0]
  }));
  _a$2O.override({
    background_fill_color: null,
    border_line_color: null
  });
})();
var _a$2N;
class LabelSetView extends DataAnnotationView {
  set_data(source) {
    var _a2;
    super.set_data(source);
    (_a2 = this.els) == null ? void 0 : _a2.forEach((el) => remove(el));
    if (this.model.render_mode == "css") {
      const els = this.els = [...this.text].map(() => div({ style: { display: "none" } }));
      for (const el of els) {
        this.plot_view.canvas_view.add_overlay(el);
      }
    } else
      delete this.els;
  }
  remove() {
    var _a2;
    (_a2 = this.els) == null ? void 0 : _a2.forEach((el) => remove(el));
    super.remove();
  }
  _rerender() {
    if (this.model.render_mode == "css")
      this.render();
    else
      this.request_render();
  }
  map_data() {
    const { x_scale, y_scale } = this.coordinates;
    const panel = this.layout != null ? this.layout : this.plot_view.frame;
    this.sx = this.model.x_units == "data" ? x_scale.v_compute(this._x) : panel.bbox.xview.v_compute(this._x);
    this.sy = this.model.y_units == "data" ? y_scale.v_compute(this._y) : panel.bbox.yview.v_compute(this._y);
  }
  paint() {
    const draw = this.model.render_mode == "canvas" ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
    const { ctx } = this.layer;
    for (let i2 = 0, end = this.text.length; i2 < end; i2++) {
      const x_offset_i = this.x_offset.get(i2);
      const y_offset_i = this.y_offset.get(i2);
      const sx_i = this.sx[i2] + x_offset_i;
      const sy_i = this.sy[i2] - y_offset_i;
      const angle_i = this.angle.get(i2);
      const text_i = this.text.get(i2);
      draw(ctx, i2, text_i, sx_i, sy_i, angle_i);
    }
  }
  _v_canvas_text(ctx, i2, text, sx, sy, angle) {
    const graphics = new TextBox({ text });
    graphics.angle = angle;
    graphics.position = { sx, sy };
    graphics.visuals = this.visuals.text.values(i2);
    const { background_fill, border_line } = this.visuals;
    if (background_fill.doit || border_line.doit) {
      const { p0, p1, p2, p3 } = graphics.rect();
      ctx.beginPath();
      ctx.moveTo(p0.x, p0.y);
      ctx.lineTo(p1.x, p1.y);
      ctx.lineTo(p2.x, p2.y);
      ctx.lineTo(p3.x, p3.y);
      ctx.closePath();
      this.visuals.background_fill.apply(ctx, i2);
      this.visuals.border_line.apply(ctx, i2);
    }
    if (this.visuals.text.doit)
      graphics.paint(ctx);
  }
  _v_css_text(ctx, i2, text, sx, sy, angle) {
    assert(this.els != null);
    const el = this.els[i2];
    el.textContent = text;
    this.visuals.text.set_vectorize(ctx, i2);
    el.style.position = "absolute";
    el.style.left = `${sx}px`;
    el.style.top = `${sy}px`;
    el.style.color = ctx.fillStyle;
    el.style.font = ctx.font;
    el.style.lineHeight = "normal";
    el.style.whiteSpace = "pre";
    const [x_anchor, x_t] = (() => {
      switch (this.visuals.text.text_align.get(i2)) {
        case "left":
          return ["left", "0%"];
        case "center":
          return ["center", "-50%"];
        case "right":
          return ["right", "-100%"];
      }
    })();
    const [y_anchor, y_t] = (() => {
      switch (this.visuals.text.text_baseline.get(i2)) {
        case "top":
          return ["top", "0%"];
        case "middle":
          return ["center", "-50%"];
        case "bottom":
          return ["bottom", "-100%"];
        default:
          return ["center", "-50%"];
      }
    })();
    let transform2 = `translate(${x_t}, ${y_t})`;
    if (angle) {
      transform2 += `rotate(${angle}rad)`;
    }
    el.style.transformOrigin = `${x_anchor} ${y_anchor}`;
    el.style.transform = transform2;
    if (this.layout == null)
      ;
    if (this.visuals.background_fill.doit) {
      this.visuals.background_fill.set_vectorize(ctx, i2);
      el.style.backgroundColor = ctx.fillStyle;
    }
    if (this.visuals.border_line.doit) {
      this.visuals.border_line.set_vectorize(ctx, i2);
      el.style.borderStyle = ctx.lineDash.length < 2 ? "solid" : "dashed";
      el.style.borderWidth = `${ctx.lineWidth}px`;
      el.style.borderColor = ctx.strokeStyle;
    }
    display(el);
  }
}
LabelSetView.__name__ = "LabelSetView";
class LabelSet extends DataAnnotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2N = LabelSet;
LabelSet.__name__ = "LabelSet";
(() => {
  _a$2N.prototype.default_view = LabelSetView;
  _a$2N.mixins([
    TextVector$1,
    ["border_", LineVector$1],
    ["background_", FillVector$1]
  ]);
  _a$2N.define(() => ({
    x: [XCoordinateSpec, { field: "x" }],
    y: [YCoordinateSpec, { field: "y" }],
    x_units: [SpatialUnits, "data"],
    y_units: [SpatialUnits, "data"],
    text: [StringSpec, { field: "text" }],
    angle: [AngleSpec, 0],
    x_offset: [NumberSpec, { value: 0 }],
    y_offset: [NumberSpec, { value: 0 }],
    render_mode: [RenderMode, "canvas"]
  }));
  _a$2N.override({
    background_fill_color: null,
    border_line_color: null
  });
})();
function isValue(obj) {
  return isPlainObject(obj) && "value" in obj;
}
function isField(obj) {
  return isPlainObject(obj) && "field" in obj;
}
var _a$2M;
class LegendItem extends Model {
  constructor(attrs) {
    super(attrs);
  }
  _check_data_sources_on_renderers() {
    const field = this.get_field_from_label_prop();
    if (field != null) {
      if (this.renderers.length < 1) {
        return false;
      }
      const source = this.renderers[0].data_source;
      if (source != null) {
        for (const r of this.renderers) {
          if (r.data_source != source) {
            return false;
          }
        }
      }
    }
    return true;
  }
  _check_field_label_on_data_source() {
    const field = this.get_field_from_label_prop();
    if (field != null) {
      if (this.renderers.length < 1) {
        return false;
      }
      const source = this.renderers[0].data_source;
      if (source != null && !includes(source.columns(), field)) {
        return false;
      }
    }
    return true;
  }
  initialize() {
    super.initialize();
    this.legend = null;
    this.connect(this.change, () => {
      var _a2;
      return (_a2 = this.legend) == null ? void 0 : _a2.item_change.emit();
    });
    const data_source_validation = this._check_data_sources_on_renderers();
    if (!data_source_validation)
      logger.error("Non matching data sources on legend item renderers");
    const field_validation = this._check_field_label_on_data_source();
    if (!field_validation)
      logger.error(`Bad column name on label: ${this.label}`);
  }
  get_field_from_label_prop() {
    const { label: label2 } = this;
    return isField(label2) ? label2.field : null;
  }
  get_labels_list_from_label_prop() {
    if (!this.visible)
      return [];
    if (isValue(this.label)) {
      const { value } = this.label;
      return value != null ? [value] : [];
    }
    const field = this.get_field_from_label_prop();
    if (field != null) {
      let source;
      if (this.renderers[0] && this.renderers[0].data_source != null)
        source = this.renderers[0].data_source;
      else
        return ["No source found"];
      if (source instanceof ColumnarDataSource) {
        const data2 = source.get_column(field);
        if (data2 != null)
          return uniq(Array.from(data2));
        else
          return ["Invalid field"];
      }
    }
    return [];
  }
}
_a$2M = LegendItem;
LegendItem.__name__ = "LegendItem";
(() => {
  _a$2M.define(({ Boolean: Boolean2, Int: Int2, Array: Array2, Ref: Ref2, Nullable: Nullable2 }) => ({
    label: [NullStringSpec, null],
    renderers: [Array2(Ref2(GlyphRenderer)), []],
    index: [Nullable2(Int2), null],
    visible: [Boolean2, true]
  }));
})();
var _a$2L;
class LegendView extends AnnotationView {
  update_layout() {
    const { panel } = this;
    if (panel != null)
      this.layout = new SideLayout(panel, () => this.get_size());
    else
      this.layout = void 0;
  }
  cursor(_sx, _sy) {
    return this.model.click_policy == "none" ? null : "pointer";
  }
  get legend_padding() {
    return this.model.border_line_color != null ? this.model.padding : 0;
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.request_render());
    this.connect(this.model.item_change, () => this.request_render());
  }
  compute_legend_bbox() {
    const legend_names = this.model.get_legend_names();
    const { glyph_height, glyph_width } = this.model;
    const { label_height, label_width } = this.model;
    this.max_label_height = max$8([font_metrics(this.visuals.label_text.font_value()).height, label_height, glyph_height]);
    const { ctx } = this.layer;
    ctx.save();
    this.visuals.label_text.set_value(ctx);
    this.text_widths = /* @__PURE__ */ new Map();
    for (const name of legend_names) {
      this.text_widths.set(name, max$8([ctx.measureText(name).width, label_width]));
    }
    this.visuals.title_text.set_value(ctx);
    this.title_height = this.model.title ? font_metrics(this.visuals.title_text.font_value()).height + this.model.title_standoff : 0;
    this.title_width = this.model.title ? ctx.measureText(this.model.title).width : 0;
    ctx.restore();
    const max_label_width = Math.max(max$8([...this.text_widths.values()]), 0);
    const legend_margin = this.model.margin;
    const { legend_padding } = this;
    const legend_spacing = this.model.spacing;
    const { label_standoff } = this.model;
    let legend_height, legend_width;
    if (this.model.orientation == "vertical") {
      legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding + this.title_height;
      legend_width = max$8([max_label_width + glyph_width + label_standoff + 2 * legend_padding, this.title_width + 2 * legend_padding]);
    } else {
      let item_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
      for (const [, width] of this.text_widths) {
        item_width += max$8([width, label_width]) + glyph_width + label_standoff;
      }
      legend_width = max$8([this.title_width + 2 * legend_padding, item_width]);
      legend_height = this.max_label_height + this.title_height + 2 * legend_padding;
    }
    const panel = this.layout != null ? this.layout : this.plot_view.frame;
    const [hr, vr] = panel.bbox.ranges;
    const { location } = this.model;
    let sx, sy;
    if (isString(location)) {
      switch (location) {
        case "top_left":
          sx = hr.start + legend_margin;
          sy = vr.start + legend_margin;
          break;
        case "top":
        case "top_center":
          sx = (hr.end + hr.start) / 2 - legend_width / 2;
          sy = vr.start + legend_margin;
          break;
        case "top_right":
          sx = hr.end - legend_margin - legend_width;
          sy = vr.start + legend_margin;
          break;
        case "bottom_right":
          sx = hr.end - legend_margin - legend_width;
          sy = vr.end - legend_margin - legend_height;
          break;
        case "bottom":
        case "bottom_center":
          sx = (hr.end + hr.start) / 2 - legend_width / 2;
          sy = vr.end - legend_margin - legend_height;
          break;
        case "bottom_left":
          sx = hr.start + legend_margin;
          sy = vr.end - legend_margin - legend_height;
          break;
        case "left":
        case "center_left":
          sx = hr.start + legend_margin;
          sy = (vr.end + vr.start) / 2 - legend_height / 2;
          break;
        case "center":
        case "center_center":
          sx = (hr.end + hr.start) / 2 - legend_width / 2;
          sy = (vr.end + vr.start) / 2 - legend_height / 2;
          break;
        case "right":
        case "center_right":
          sx = hr.end - legend_margin - legend_width;
          sy = (vr.end + vr.start) / 2 - legend_height / 2;
          break;
      }
    } else if (isArray(location) && location.length == 2) {
      const [vx, vy] = location;
      sx = panel.bbox.xview.compute(vx);
      sy = panel.bbox.yview.compute(vy) - legend_height;
    } else
      unreachable();
    return new BBox$2({ left: sx, top: sy, width: legend_width, height: legend_height });
  }
  interactive_bbox() {
    return this.compute_legend_bbox();
  }
  interactive_hit(sx, sy) {
    const bbox = this.interactive_bbox();
    return bbox.contains(sx, sy);
  }
  on_hit(sx, sy) {
    let yoffset;
    const { glyph_width } = this.model;
    const { legend_padding } = this;
    const legend_spacing = this.model.spacing;
    const { label_standoff } = this.model;
    let xoffset = yoffset = legend_padding;
    const legend_bbox = this.compute_legend_bbox();
    const vertical2 = this.model.orientation == "vertical";
    for (const item of this.model.items) {
      const labels = item.get_labels_list_from_label_prop();
      for (const label2 of labels) {
        const x1 = legend_bbox.x + xoffset;
        const y1 = legend_bbox.y + yoffset + this.title_height;
        let w, h2;
        if (vertical2)
          [w, h2] = [legend_bbox.width - 2 * legend_padding, this.max_label_height];
        else
          [w, h2] = [this.text_widths.get(label2) + glyph_width + label_standoff, this.max_label_height];
        const bbox = new BBox$2({ left: x1, top: y1, width: w, height: h2 });
        if (bbox.contains(sx, sy)) {
          switch (this.model.click_policy) {
            case "hide": {
              for (const r of item.renderers)
                r.visible = !r.visible;
              break;
            }
            case "mute": {
              for (const r of item.renderers)
                r.muted = !r.muted;
              break;
            }
          }
          return true;
        }
        if (vertical2)
          yoffset += this.max_label_height + legend_spacing;
        else
          xoffset += this.text_widths.get(label2) + glyph_width + label_standoff + legend_spacing;
      }
    }
    return false;
  }
  _render() {
    if (this.model.items.length == 0)
      return;
    if (!some(this.model.items, (item) => item.visible))
      return;
    for (const item of this.model.items) {
      item.legend = this.model;
    }
    const { ctx } = this.layer;
    const bbox = this.compute_legend_bbox();
    ctx.save();
    this._draw_legend_box(ctx, bbox);
    this._draw_legend_items(ctx, bbox);
    this._draw_title(ctx, bbox);
    ctx.restore();
  }
  _draw_legend_box(ctx, bbox) {
    ctx.beginPath();
    ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
    this.visuals.background_fill.apply(ctx);
    this.visuals.border_line.apply(ctx);
  }
  _draw_legend_items(ctx, bbox) {
    const { glyph_width, glyph_height } = this.model;
    const { legend_padding } = this;
    const legend_spacing = this.model.spacing;
    const { label_standoff } = this.model;
    let xoffset = legend_padding;
    let yoffset = legend_padding;
    const vertical2 = this.model.orientation == "vertical";
    for (const item of this.model.items) {
      if (!item.visible)
        continue;
      const labels = item.get_labels_list_from_label_prop();
      const field = item.get_field_from_label_prop();
      if (labels.length == 0)
        continue;
      const active2 = (() => {
        switch (this.model.click_policy) {
          case "none":
            return true;
          case "hide":
            return every(item.renderers, (r) => r.visible);
          case "mute":
            return every(item.renderers, (r) => !r.muted);
        }
      })();
      for (const label2 of labels) {
        const x1 = bbox.x + xoffset;
        const y1 = bbox.y + yoffset + this.title_height;
        const x2 = x1 + glyph_width;
        const y2 = y1 + glyph_height;
        if (vertical2)
          yoffset += this.max_label_height + legend_spacing;
        else
          xoffset += this.text_widths.get(label2) + glyph_width + label_standoff + legend_spacing;
        this.visuals.label_text.set_value(ctx);
        ctx.fillText(label2, x2 + label_standoff, y1 + this.max_label_height / 2);
        for (const r of item.renderers) {
          const view = this.plot_view.renderer_view(r);
          view == null ? void 0 : view.draw_legend(ctx, x1, x2, y1, y2, field, label2, item.index);
        }
        if (!active2) {
          let w, h2;
          if (vertical2)
            [w, h2] = [bbox.width - 2 * legend_padding, this.max_label_height];
          else
            [w, h2] = [this.text_widths.get(label2) + glyph_width + label_standoff, this.max_label_height];
          ctx.beginPath();
          ctx.rect(x1, y1, w, h2);
          this.visuals.inactive_fill.set_value(ctx);
          ctx.fill();
        }
      }
    }
  }
  _draw_title(ctx, bbox) {
    const { title } = this.model;
    if (!title || !this.visuals.title_text.doit)
      return;
    ctx.save();
    ctx.translate(bbox.x0, bbox.y0 + this.title_height);
    this.visuals.title_text.set_value(ctx);
    ctx.fillText(title, this.legend_padding, this.legend_padding - this.model.title_standoff);
    ctx.restore();
  }
  _get_size() {
    const { width, height } = this.compute_legend_bbox();
    return {
      width: width + 2 * this.model.margin,
      height: height + 2 * this.model.margin
    };
  }
}
LegendView.__name__ = "LegendView";
class Legend extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this.item_change = new Signal0(this, "item_change");
  }
  get_legend_names() {
    const legend_names = [];
    for (const item of this.items) {
      const labels = item.get_labels_list_from_label_prop();
      legend_names.push(...labels);
    }
    return legend_names;
  }
}
_a$2L = Legend;
Legend.__name__ = "Legend";
(() => {
  _a$2L.prototype.default_view = LegendView;
  _a$2L.mixins([
    ["label_", Text$3],
    ["title_", Text$3],
    ["inactive_", Fill$1],
    ["border_", Line$2],
    ["background_", Fill$1]
  ]);
  _a$2L.define(({ Number: Number2, String: String2, Array: Array2, Tuple: Tuple2, Or: Or2, Ref: Ref2, Nullable: Nullable2 }) => ({
    orientation: [Orientation, "vertical"],
    location: [Or2(LegendLocation, Tuple2(Number2, Number2)), "top_right"],
    title: [Nullable2(String2), null],
    title_standoff: [Number2, 5],
    label_standoff: [Number2, 5],
    glyph_height: [Number2, 20],
    glyph_width: [Number2, 20],
    label_height: [Number2, 20],
    label_width: [Number2, 20],
    margin: [Number2, 10],
    padding: [Number2, 10],
    spacing: [Number2, 3],
    items: [Array2(Ref2(LegendItem)), []],
    click_policy: [LegendClickPolicy, "none"]
  }));
  _a$2L.override({
    border_line_color: "#e5e5e5",
    border_line_alpha: 0.5,
    border_line_width: 1,
    background_fill_color: "#ffffff",
    background_fill_alpha: 0.95,
    inactive_fill_color: "white",
    inactive_fill_alpha: 0.7,
    label_text_font_size: "13px",
    label_text_baseline: "middle",
    title_text_font_size: "13px",
    title_text_font_style: "italic"
  });
})();
var _a$2K;
class PolyAnnotationView extends AnnotationView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { xs, ys } = this.model;
    if (xs.length != ys.length)
      return;
    const n2 = xs.length;
    if (n2 < 3)
      return;
    const { frame } = this.plot_view;
    const { ctx } = this.layer;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    const { screen } = this.model;
    function _calc_dim(values2, units2, scale, view) {
      if (screen)
        return values2;
      else
        return units2 == "data" ? scale.v_compute(values2) : view.v_compute(values2);
    }
    const sxs = _calc_dim(xs, this.model.xs_units, xscale, frame.bbox.xview);
    const sys = _calc_dim(ys, this.model.ys_units, yscale, frame.bbox.yview);
    ctx.beginPath();
    for (let i2 = 0; i2 < n2; i2++) {
      ctx.lineTo(sxs[i2], sys[i2]);
    }
    ctx.closePath();
    this.visuals.fill.apply(ctx);
    this.visuals.hatch.apply(ctx);
    this.visuals.line.apply(ctx);
  }
}
PolyAnnotationView.__name__ = "PolyAnnotationView";
class PolyAnnotation extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
  update({ xs, ys }) {
    this.setv({ xs, ys, screen: true }, { check_eq: false });
  }
}
_a$2K = PolyAnnotation;
PolyAnnotation.__name__ = "PolyAnnotation";
(() => {
  _a$2K.prototype.default_view = PolyAnnotationView;
  _a$2K.mixins([Line$2, Fill$1, Hatch$1]);
  _a$2K.define(({ Number: Number2, Array: Array2 }) => ({
    xs: [Array2(Number2), []],
    xs_units: [SpatialUnits, "data"],
    ys: [Array2(Number2), []],
    ys_units: [SpatialUnits, "data"]
  }));
  _a$2K.internal(({ Boolean: Boolean2 }) => ({
    screen: [Boolean2, false]
  }));
  _a$2K.override({
    fill_color: "#fff9ba",
    fill_alpha: 0.4,
    line_color: "#cccccc",
    line_alpha: 0.3
  });
})();
var _a$2J;
class SlopeView extends AnnotationView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.request_render());
  }
  _render() {
    const { gradient, y_intercept } = this.model;
    if (gradient == null || y_intercept == null)
      return;
    const { frame } = this.plot_view;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    let sy_start, sy_end, sx_start, sx_end;
    if (gradient == 0) {
      sy_start = yscale.compute(y_intercept);
      sy_end = sy_start;
      sx_start = frame.bbox.left;
      sx_end = sx_start + frame.bbox.width;
    } else {
      sy_start = frame.bbox.top;
      sy_end = sy_start + frame.bbox.height;
      const y_start = yscale.invert(sy_start);
      const y_end = yscale.invert(sy_end);
      const x_start = (y_start - y_intercept) / gradient;
      const x_end = (y_end - y_intercept) / gradient;
      sx_start = xscale.compute(x_start);
      sx_end = xscale.compute(x_end);
    }
    const { ctx } = this.layer;
    ctx.save();
    ctx.beginPath();
    this.visuals.line.set_value(ctx);
    ctx.moveTo(sx_start, sy_start);
    ctx.lineTo(sx_end, sy_end);
    ctx.stroke();
    ctx.restore();
  }
}
SlopeView.__name__ = "SlopeView";
class Slope extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2J = Slope;
Slope.__name__ = "Slope";
(() => {
  _a$2J.prototype.default_view = SlopeView;
  _a$2J.mixins(Line$2);
  _a$2J.define(({ Number: Number2, Nullable: Nullable2 }) => ({
    gradient: [Nullable2(Number2), null],
    y_intercept: [Nullable2(Number2), null]
  }));
  _a$2J.override({
    line_color: "black"
  });
})();
var _a$2I;
class SpanView$1 extends AnnotationView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.plot_view.request_paint(this));
  }
  _render() {
    const { location } = this.model;
    if (location == null) {
      return;
    }
    const { frame } = this.plot_view;
    const xscale = this.coordinates.x_scale;
    const yscale = this.coordinates.y_scale;
    const _calc_dim = (scale, view) => {
      if (this.model.location_units == "data")
        return scale.compute(location);
      else
        return this.model.for_hover ? location : view.compute(location);
    };
    let height, sleft, stop, width;
    if (this.model.dimension == "width") {
      stop = _calc_dim(yscale, frame.bbox.yview);
      sleft = frame.bbox.left;
      width = frame.bbox.width;
      height = this.model.line_width;
    } else {
      stop = frame.bbox.top;
      sleft = _calc_dim(xscale, frame.bbox.xview);
      width = this.model.line_width;
      height = frame.bbox.height;
    }
    const { ctx } = this.layer;
    ctx.save();
    ctx.beginPath();
    this.visuals.line.set_value(ctx);
    ctx.moveTo(sleft, stop);
    if (this.model.dimension == "width") {
      ctx.lineTo(sleft + width, stop);
    } else {
      ctx.lineTo(sleft, stop + height);
    }
    ctx.stroke();
    ctx.restore();
  }
}
SpanView$1.__name__ = "SpanView";
class Span$1 extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2I = Span$1;
Span$1.__name__ = "Span";
(() => {
  _a$2I.prototype.default_view = SpanView$1;
  _a$2I.mixins(Line$2);
  _a$2I.define(({ Number: Number2, Nullable: Nullable2 }) => ({
    render_mode: [RenderMode, "canvas"],
    location: [Nullable2(Number2), null],
    location_units: [SpatialUnits, "data"],
    dimension: [Dimension, "width"]
  }));
  _a$2I.internal(({ Boolean: Boolean2 }) => ({
    for_hover: [Boolean2, false]
  }));
  _a$2I.override({
    line_color: "black"
  });
})();
var _a$2H;
class ToolView extends View {
  get plot_view() {
    return this.parent;
  }
  get plot_model() {
    return this.parent.model;
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.active.change, () => {
      if (this.model.active)
        this.activate();
      else
        this.deactivate();
    });
  }
  activate() {
  }
  deactivate() {
  }
}
ToolView.__name__ = "ToolView";
class Tool extends Model {
  constructor(attrs) {
    super(attrs);
  }
  get synthetic_renderers() {
    return [];
  }
  _get_dim_limits([sx0, sy0], [sx1, sy1], frame, dims) {
    const hr = frame.bbox.h_range;
    let sxlim;
    if (dims == "width" || dims == "both") {
      sxlim = [min$6([sx0, sx1]), max$8([sx0, sx1])];
      sxlim = [max$8([sxlim[0], hr.start]), min$6([sxlim[1], hr.end])];
    } else
      sxlim = [hr.start, hr.end];
    const vr = frame.bbox.v_range;
    let sylim;
    if (dims == "height" || dims == "both") {
      sylim = [min$6([sy0, sy1]), max$8([sy0, sy1])];
      sylim = [max$8([sylim[0], vr.start]), min$6([sylim[1], vr.end])];
    } else
      sylim = [vr.start, vr.end];
    return [sxlim, sylim];
  }
  static register_alias(name, fn) {
    this.prototype._known_aliases.set(name, fn);
  }
  static from_string(name) {
    const fn = this.prototype._known_aliases.get(name);
    if (fn != null)
      return fn();
    else {
      const names2 = [...this.prototype._known_aliases.keys()];
      throw new Error(`unexpected tool name '${name}', possible tools are ${names2.join(", ")}`);
    }
  }
}
_a$2H = Tool;
Tool.__name__ = "Tool";
(() => {
  _a$2H.prototype._known_aliases = /* @__PURE__ */ new Map();
  _a$2H.define(({ String: String2, Nullable: Nullable2 }) => ({
    description: [Nullable2(String2), null]
  }));
  _a$2H.internal(({ Boolean: Boolean2 }) => ({
    active: [Boolean2, false]
  }));
})();
var hammer = { exports: {} };
/*! Hammer.JS - v2.0.7 - 2016-04-22
 * http://hammerjs.github.io/
 *
 * Copyright (c) 2016 Jorik Tangelder;
 * Licensed under the MIT license */
(function(module) {
  (function(window2, document2, exportName, undefined$1) {
    var VENDOR_PREFIXES = ["", "webkit", "Moz", "MS", "ms", "o"];
    var TEST_ELEMENT = document2.createElement("div");
    var TYPE_FUNCTION = "function";
    var round2 = Math.round;
    var abs2 = Math.abs;
    var now = Date.now;
    function setTimeoutContext(fn, timeout, context) {
      return setTimeout(bindFn(fn, context), timeout);
    }
    function invokeArrayArg(arg, fn, context) {
      if (Array.isArray(arg)) {
        each2(arg, context[fn], context);
        return true;
      }
      return false;
    }
    function each2(obj, iterator, context) {
      var i2;
      if (!obj) {
        return;
      }
      if (obj.forEach) {
        obj.forEach(iterator, context);
      } else if (obj.length !== undefined$1) {
        i2 = 0;
        while (i2 < obj.length) {
          iterator.call(context, obj[i2], i2, obj);
          i2++;
        }
      } else {
        for (i2 in obj) {
          obj.hasOwnProperty(i2) && iterator.call(context, obj[i2], i2, obj);
        }
      }
    }
    function deprecate(method, name, message) {
      var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
      return function() {
        var e = new Error("get-stack-trace");
        var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, "").replace(/^\s+at\s+/gm, "").replace(/^Object.<anonymous>\s*\(/gm, "{anonymous}()@") : "Unknown Stack Trace";
        var log2 = window2.console && (window2.console.warn || window2.console.log);
        if (log2) {
          log2.call(window2.console, deprecationMessage, stack);
        }
        return method.apply(this, arguments);
      };
    }
    var assign;
    if (typeof Object.assign !== "function") {
      assign = function assign2(target) {
        if (target === undefined$1 || target === null) {
          throw new TypeError("Cannot convert undefined or null to object");
        }
        var output = Object(target);
        for (var index2 = 1; index2 < arguments.length; index2++) {
          var source = arguments[index2];
          if (source !== undefined$1 && source !== null) {
            for (var nextKey in source) {
              if (source.hasOwnProperty(nextKey)) {
                output[nextKey] = source[nextKey];
              }
            }
          }
        }
        return output;
      };
    } else {
      assign = Object.assign;
    }
    var extend2 = deprecate(function extend3(dest, src, merge3) {
      var keys2 = Object.keys(src);
      var i2 = 0;
      while (i2 < keys2.length) {
        if (!merge3 || merge3 && dest[keys2[i2]] === undefined$1) {
          dest[keys2[i2]] = src[keys2[i2]];
        }
        i2++;
      }
      return dest;
    }, "extend", "Use `assign`.");
    var merge2 = deprecate(function merge3(dest, src) {
      return extend2(dest, src, true);
    }, "merge", "Use `assign`.");
    function inherit(child, base, properties) {
      var baseP = base.prototype, childP;
      childP = child.prototype = Object.create(baseP);
      childP.constructor = child;
      childP._super = baseP;
      if (properties) {
        assign(childP, properties);
      }
    }
    function bindFn(fn, context) {
      return function boundFn() {
        return fn.apply(context, arguments);
      };
    }
    function boolOrFn(val, args) {
      if (typeof val == TYPE_FUNCTION) {
        return val.apply(args ? args[0] || undefined$1 : undefined$1, args);
      }
      return val;
    }
    function ifUndefined(val1, val2) {
      return val1 === undefined$1 ? val2 : val1;
    }
    function addEventListeners(target, types, handler) {
      each2(splitStr(types), function(type) {
        target.addEventListener(type, handler, false);
      });
    }
    function removeEventListeners(target, types, handler) {
      each2(splitStr(types), function(type) {
        target.removeEventListener(type, handler, false);
      });
    }
    function hasParent(node, parent) {
      while (node) {
        if (node == parent) {
          return true;
        }
        node = node.parentNode;
      }
      return false;
    }
    function inStr(str, find2) {
      return str.indexOf(find2) > -1;
    }
    function splitStr(str) {
      return str.trim().split(/\s+/g);
    }
    function inArray(src, find2, findByKey) {
      if (src.indexOf && !findByKey) {
        return src.indexOf(find2);
      } else {
        var i2 = 0;
        while (i2 < src.length) {
          if (findByKey && src[i2][findByKey] == find2 || !findByKey && src[i2] === find2) {
            return i2;
          }
          i2++;
        }
        return -1;
      }
    }
    function toArray(obj) {
      return Array.prototype.slice.call(obj, 0);
    }
    function uniqueArray(src, key, sort2) {
      var results = [];
      var values2 = [];
      var i2 = 0;
      while (i2 < src.length) {
        var val = key ? src[i2][key] : src[i2];
        if (inArray(values2, val) < 0) {
          results.push(src[i2]);
        }
        values2[i2] = val;
        i2++;
      }
      if (sort2) {
        if (!key) {
          results = results.sort();
        } else {
          results = results.sort(function sortUniqueArray(a2, b) {
            return a2[key] > b[key];
          });
        }
      }
      return results;
    }
    function prefixed(obj, property) {
      var prefix, prop;
      var camelProp = property[0].toUpperCase() + property.slice(1);
      var i2 = 0;
      while (i2 < VENDOR_PREFIXES.length) {
        prefix = VENDOR_PREFIXES[i2];
        prop = prefix ? prefix + camelProp : property;
        if (prop in obj) {
          return prop;
        }
        i2++;
      }
      return undefined$1;
    }
    var _uniqueId = 1;
    function uniqueId2() {
      return _uniqueId++;
    }
    function getWindowForElement(element) {
      var doc = element.ownerDocument || element;
      return doc.defaultView || doc.parentWindow || window2;
    }
    var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
    var SUPPORT_TOUCH = "ontouchstart" in window2;
    var SUPPORT_POINTER_EVENTS = prefixed(window2, "PointerEvent") !== undefined$1;
    var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
    var INPUT_TYPE_TOUCH = "touch";
    var INPUT_TYPE_PEN = "pen";
    var INPUT_TYPE_MOUSE = "mouse";
    var INPUT_TYPE_KINECT = "kinect";
    var COMPUTE_INTERVAL = 25;
    var INPUT_START = 1;
    var INPUT_MOVE = 2;
    var INPUT_END = 4;
    var INPUT_CANCEL = 8;
    var DIRECTION_NONE = 1;
    var DIRECTION_LEFT = 2;
    var DIRECTION_RIGHT = 4;
    var DIRECTION_UP = 8;
    var DIRECTION_DOWN = 16;
    var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
    var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
    var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
    var PROPS_XY = ["x", "y"];
    var PROPS_CLIENT_XY = ["clientX", "clientY"];
    function Input(manager, callback) {
      var self2 = this;
      this.manager = manager;
      this.callback = callback;
      this.element = manager.element;
      this.target = manager.options.inputTarget;
      this.domHandler = function(ev) {
        if (boolOrFn(manager.options.enable, [manager])) {
          self2.handler(ev);
        }
      };
      this.init();
    }
    Input.prototype = {
      handler: function() {
      },
      init: function() {
        this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
        this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
        this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
      },
      destroy: function() {
        this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
        this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
        this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
      }
    };
    function createInputInstance(manager) {
      var Type;
      var inputClass = manager.options.inputClass;
      if (inputClass) {
        Type = inputClass;
      } else if (SUPPORT_POINTER_EVENTS) {
        Type = PointerEventInput;
      } else if (SUPPORT_ONLY_TOUCH) {
        Type = TouchInput;
      } else if (!SUPPORT_TOUCH) {
        Type = MouseInput;
      } else {
        Type = TouchMouseInput;
      }
      return new Type(manager, inputHandler);
    }
    function inputHandler(manager, eventType, input2) {
      var pointersLen = input2.pointers.length;
      var changedPointersLen = input2.changedPointers.length;
      var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
      var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
      input2.isFirst = !!isFirst;
      input2.isFinal = !!isFinal;
      if (isFirst) {
        manager.session = {};
      }
      input2.eventType = eventType;
      computeInputData(manager, input2);
      manager.emit("hammer.input", input2);
      manager.recognize(input2);
      manager.session.prevInput = input2;
    }
    function computeInputData(manager, input2) {
      var session = manager.session;
      var pointers = input2.pointers;
      var pointersLength = pointers.length;
      if (!session.firstInput) {
        session.firstInput = simpleCloneInputData(input2);
      }
      if (pointersLength > 1 && !session.firstMultiple) {
        session.firstMultiple = simpleCloneInputData(input2);
      } else if (pointersLength === 1) {
        session.firstMultiple = false;
      }
      var firstInput = session.firstInput;
      var firstMultiple = session.firstMultiple;
      var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
      var center = input2.center = getCenter(pointers);
      input2.timeStamp = now();
      input2.deltaTime = input2.timeStamp - firstInput.timeStamp;
      input2.angle = getAngle(offsetCenter, center);
      input2.distance = getDistance(offsetCenter, center);
      computeDeltaXY(session, input2);
      input2.offsetDirection = getDirection(input2.deltaX, input2.deltaY);
      var overallVelocity = getVelocity(input2.deltaTime, input2.deltaX, input2.deltaY);
      input2.overallVelocityX = overallVelocity.x;
      input2.overallVelocityY = overallVelocity.y;
      input2.overallVelocity = abs2(overallVelocity.x) > abs2(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
      input2.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
      input2.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
      input2.maxPointers = !session.prevInput ? input2.pointers.length : input2.pointers.length > session.prevInput.maxPointers ? input2.pointers.length : session.prevInput.maxPointers;
      computeIntervalInputData(session, input2);
      var target = manager.element;
      if (hasParent(input2.srcEvent.target, target)) {
        target = input2.srcEvent.target;
      }
      input2.target = target;
    }
    function computeDeltaXY(session, input2) {
      var center = input2.center;
      var offset2 = session.offsetDelta || {};
      var prevDelta = session.prevDelta || {};
      var prevInput = session.prevInput || {};
      if (input2.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
        prevDelta = session.prevDelta = {
          x: prevInput.deltaX || 0,
          y: prevInput.deltaY || 0
        };
        offset2 = session.offsetDelta = {
          x: center.x,
          y: center.y
        };
      }
      input2.deltaX = prevDelta.x + (center.x - offset2.x);
      input2.deltaY = prevDelta.y + (center.y - offset2.y);
    }
    function computeIntervalInputData(session, input2) {
      var last = session.lastInterval || input2, deltaTime = input2.timeStamp - last.timeStamp, velocity, velocityX, velocityY, direction;
      if (input2.eventType != INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined$1)) {
        var deltaX = input2.deltaX - last.deltaX;
        var deltaY = input2.deltaY - last.deltaY;
        var v = getVelocity(deltaTime, deltaX, deltaY);
        velocityX = v.x;
        velocityY = v.y;
        velocity = abs2(v.x) > abs2(v.y) ? v.x : v.y;
        direction = getDirection(deltaX, deltaY);
        session.lastInterval = input2;
      } else {
        velocity = last.velocity;
        velocityX = last.velocityX;
        velocityY = last.velocityY;
        direction = last.direction;
      }
      input2.velocity = velocity;
      input2.velocityX = velocityX;
      input2.velocityY = velocityY;
      input2.direction = direction;
    }
    function simpleCloneInputData(input2) {
      var pointers = [];
      var i2 = 0;
      while (i2 < input2.pointers.length) {
        pointers[i2] = {
          clientX: round2(input2.pointers[i2].clientX),
          clientY: round2(input2.pointers[i2].clientY)
        };
        i2++;
      }
      return {
        timeStamp: now(),
        pointers,
        center: getCenter(pointers),
        deltaX: input2.deltaX,
        deltaY: input2.deltaY
      };
    }
    function getCenter(pointers) {
      var pointersLength = pointers.length;
      if (pointersLength === 1) {
        return {
          x: round2(pointers[0].clientX),
          y: round2(pointers[0].clientY)
        };
      }
      var x2 = 0, y2 = 0, i2 = 0;
      while (i2 < pointersLength) {
        x2 += pointers[i2].clientX;
        y2 += pointers[i2].clientY;
        i2++;
      }
      return {
        x: round2(x2 / pointersLength),
        y: round2(y2 / pointersLength)
      };
    }
    function getVelocity(deltaTime, x2, y2) {
      return {
        x: x2 / deltaTime || 0,
        y: y2 / deltaTime || 0
      };
    }
    function getDirection(x2, y2) {
      if (x2 === y2) {
        return DIRECTION_NONE;
      }
      if (abs2(x2) >= abs2(y2)) {
        return x2 < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
      }
      return y2 < 0 ? DIRECTION_UP : DIRECTION_DOWN;
    }
    function getDistance(p1, p2, props) {
      if (!props) {
        props = PROPS_XY;
      }
      var x2 = p2[props[0]] - p1[props[0]], y2 = p2[props[1]] - p1[props[1]];
      return Math.sqrt(x2 * x2 + y2 * y2);
    }
    function getAngle(p1, p2, props) {
      if (!props) {
        props = PROPS_XY;
      }
      var x2 = p2[props[0]] - p1[props[0]], y2 = p2[props[1]] - p1[props[1]];
      return Math.atan2(y2, x2) * 180 / Math.PI;
    }
    function getRotation(start2, end) {
      return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start2[1], start2[0], PROPS_CLIENT_XY);
    }
    function getScale(start2, end) {
      return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start2[0], start2[1], PROPS_CLIENT_XY);
    }
    var MOUSE_INPUT_MAP = {
      mousedown: INPUT_START,
      mousemove: INPUT_MOVE,
      mouseup: INPUT_END
    };
    var MOUSE_ELEMENT_EVENTS = "mousedown";
    var MOUSE_WINDOW_EVENTS = "mousemove mouseup";
    function MouseInput() {
      this.evEl = MOUSE_ELEMENT_EVENTS;
      this.evWin = MOUSE_WINDOW_EVENTS;
      this.pressed = false;
      Input.apply(this, arguments);
    }
    inherit(MouseInput, Input, {
      handler: function MEhandler(ev) {
        var eventType = MOUSE_INPUT_MAP[ev.type];
        if (eventType & INPUT_START && ev.button === 0) {
          this.pressed = true;
        }
        if (eventType & INPUT_MOVE && ev.which !== 1) {
          eventType = INPUT_END;
        }
        if (!this.pressed) {
          return;
        }
        if (eventType & INPUT_END) {
          this.pressed = false;
        }
        this.callback(this.manager, eventType, {
          pointers: [ev],
          changedPointers: [ev],
          pointerType: INPUT_TYPE_MOUSE,
          srcEvent: ev
        });
      }
    });
    var POINTER_INPUT_MAP = {
      pointerdown: INPUT_START,
      pointermove: INPUT_MOVE,
      pointerup: INPUT_END,
      pointercancel: INPUT_CANCEL,
      pointerout: INPUT_CANCEL
    };
    var IE10_POINTER_TYPE_ENUM = {
      2: INPUT_TYPE_TOUCH,
      3: INPUT_TYPE_PEN,
      4: INPUT_TYPE_MOUSE,
      5: INPUT_TYPE_KINECT
    };
    var POINTER_ELEMENT_EVENTS = "pointerdown";
    var POINTER_WINDOW_EVENTS = "pointermove pointerup pointercancel";
    if (window2.MSPointerEvent && !window2.PointerEvent) {
      POINTER_ELEMENT_EVENTS = "MSPointerDown";
      POINTER_WINDOW_EVENTS = "MSPointerMove MSPointerUp MSPointerCancel";
    }
    function PointerEventInput() {
      this.evEl = POINTER_ELEMENT_EVENTS;
      this.evWin = POINTER_WINDOW_EVENTS;
      Input.apply(this, arguments);
      this.store = this.manager.session.pointerEvents = [];
    }
    inherit(PointerEventInput, Input, {
      handler: function PEhandler(ev) {
        var store = this.store;
        var removePointer = false;
        var eventTypeNormalized = ev.type.toLowerCase().replace("ms", "");
        var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
        var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
        var isTouch = pointerType == INPUT_TYPE_TOUCH;
        var storeIndex = inArray(store, ev.pointerId, "pointerId");
        if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
          if (storeIndex < 0) {
            store.push(ev);
            storeIndex = store.length - 1;
          }
        } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
          removePointer = true;
        }
        if (storeIndex < 0) {
          return;
        }
        store[storeIndex] = ev;
        this.callback(this.manager, eventType, {
          pointers: store,
          changedPointers: [ev],
          pointerType,
          srcEvent: ev
        });
        if (removePointer) {
          store.splice(storeIndex, 1);
        }
      }
    });
    var SINGLE_TOUCH_INPUT_MAP = {
      touchstart: INPUT_START,
      touchmove: INPUT_MOVE,
      touchend: INPUT_END,
      touchcancel: INPUT_CANCEL
    };
    var SINGLE_TOUCH_TARGET_EVENTS = "touchstart";
    var SINGLE_TOUCH_WINDOW_EVENTS = "touchstart touchmove touchend touchcancel";
    function SingleTouchInput() {
      this.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
      this.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
      this.started = false;
      Input.apply(this, arguments);
    }
    inherit(SingleTouchInput, Input, {
      handler: function TEhandler(ev) {
        var type = SINGLE_TOUCH_INPUT_MAP[ev.type];
        if (type === INPUT_START) {
          this.started = true;
        }
        if (!this.started) {
          return;
        }
        var touches = normalizeSingleTouches.call(this, ev, type);
        if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
          this.started = false;
        }
        this.callback(this.manager, type, {
          pointers: touches[0],
          changedPointers: touches[1],
          pointerType: INPUT_TYPE_TOUCH,
          srcEvent: ev
        });
      }
    });
    function normalizeSingleTouches(ev, type) {
      var all = toArray(ev.touches);
      var changed = toArray(ev.changedTouches);
      if (type & (INPUT_END | INPUT_CANCEL)) {
        all = uniqueArray(all.concat(changed), "identifier", true);
      }
      return [all, changed];
    }
    var TOUCH_INPUT_MAP = {
      touchstart: INPUT_START,
      touchmove: INPUT_MOVE,
      touchend: INPUT_END,
      touchcancel: INPUT_CANCEL
    };
    var TOUCH_TARGET_EVENTS = "touchstart touchmove touchend touchcancel";
    function TouchInput() {
      this.evTarget = TOUCH_TARGET_EVENTS;
      this.targetIds = {};
      Input.apply(this, arguments);
    }
    inherit(TouchInput, Input, {
      handler: function MTEhandler(ev) {
        var type = TOUCH_INPUT_MAP[ev.type];
        var touches = getTouches.call(this, ev, type);
        if (!touches) {
          return;
        }
        this.callback(this.manager, type, {
          pointers: touches[0],
          changedPointers: touches[1],
          pointerType: INPUT_TYPE_TOUCH,
          srcEvent: ev
        });
      }
    });
    function getTouches(ev, type) {
      var allTouches = toArray(ev.touches);
      var targetIds = this.targetIds;
      if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
        targetIds[allTouches[0].identifier] = true;
        return [allTouches, allTouches];
      }
      var i2, targetTouches, changedTouches = toArray(ev.changedTouches), changedTargetTouches = [], target = this.target;
      targetTouches = allTouches.filter(function(touch) {
        return hasParent(touch.target, target);
      });
      if (type === INPUT_START) {
        i2 = 0;
        while (i2 < targetTouches.length) {
          targetIds[targetTouches[i2].identifier] = true;
          i2++;
        }
      }
      i2 = 0;
      while (i2 < changedTouches.length) {
        if (targetIds[changedTouches[i2].identifier]) {
          changedTargetTouches.push(changedTouches[i2]);
        }
        if (type & (INPUT_END | INPUT_CANCEL)) {
          delete targetIds[changedTouches[i2].identifier];
        }
        i2++;
      }
      if (!changedTargetTouches.length) {
        return;
      }
      return [
        uniqueArray(targetTouches.concat(changedTargetTouches), "identifier", true),
        changedTargetTouches
      ];
    }
    var DEDUP_TIMEOUT = 2500;
    var DEDUP_DISTANCE = 25;
    function TouchMouseInput() {
      Input.apply(this, arguments);
      var handler = bindFn(this.handler, this);
      this.touch = new TouchInput(this.manager, handler);
      this.mouse = new MouseInput(this.manager, handler);
      this.primaryTouch = null;
      this.lastTouches = [];
    }
    inherit(TouchMouseInput, Input, {
      handler: function TMEhandler(manager, inputEvent, inputData) {
        var isTouch = inputData.pointerType == INPUT_TYPE_TOUCH, isMouse = inputData.pointerType == INPUT_TYPE_MOUSE;
        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
          return;
        }
        if (isTouch) {
          recordTouches.call(this, inputEvent, inputData);
        } else if (isMouse && isSyntheticEvent.call(this, inputData)) {
          return;
        }
        this.callback(manager, inputEvent, inputData);
      },
      destroy: function destroy2() {
        this.touch.destroy();
        this.mouse.destroy();
      }
    });
    function recordTouches(eventType, eventData) {
      if (eventType & INPUT_START) {
        this.primaryTouch = eventData.changedPointers[0].identifier;
        setLastTouch.call(this, eventData);
      } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
        setLastTouch.call(this, eventData);
      }
    }
    function setLastTouch(eventData) {
      var touch = eventData.changedPointers[0];
      if (touch.identifier === this.primaryTouch) {
        var lastTouch = { x: touch.clientX, y: touch.clientY };
        this.lastTouches.push(lastTouch);
        var lts = this.lastTouches;
        var removeLastTouch = function() {
          var i2 = lts.indexOf(lastTouch);
          if (i2 > -1) {
            lts.splice(i2, 1);
          }
        };
        setTimeout(removeLastTouch, DEDUP_TIMEOUT);
      }
    }
    function isSyntheticEvent(eventData) {
      var x2 = eventData.srcEvent.clientX, y2 = eventData.srcEvent.clientY;
      for (var i2 = 0; i2 < this.lastTouches.length; i2++) {
        var t = this.lastTouches[i2];
        var dx = Math.abs(x2 - t.x), dy = Math.abs(y2 - t.y);
        if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
          return true;
        }
      }
      return false;
    }
    var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, "touchAction");
    var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined$1;
    var TOUCH_ACTION_COMPUTE = "compute";
    var TOUCH_ACTION_AUTO = "auto";
    var TOUCH_ACTION_MANIPULATION = "manipulation";
    var TOUCH_ACTION_NONE = "none";
    var TOUCH_ACTION_PAN_X = "pan-x";
    var TOUCH_ACTION_PAN_Y = "pan-y";
    var TOUCH_ACTION_MAP = getTouchActionProps();
    function TouchAction(manager, value) {
      this.manager = manager;
      this.set(value);
    }
    TouchAction.prototype = {
      set: function(value) {
        if (value == TOUCH_ACTION_COMPUTE) {
          value = this.compute();
        }
        if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
          this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
        }
        this.actions = value.toLowerCase().trim();
      },
      update: function() {
        this.set(this.manager.options.touchAction);
      },
      compute: function() {
        var actions = [];
        each2(this.manager.recognizers, function(recognizer) {
          if (boolOrFn(recognizer.options.enable, [recognizer])) {
            actions = actions.concat(recognizer.getTouchAction());
          }
        });
        return cleanTouchActions(actions.join(" "));
      },
      preventDefaults: function(input2) {
        var srcEvent = input2.srcEvent;
        var direction = input2.offsetDirection;
        if (this.manager.session.prevented) {
          srcEvent.preventDefault();
          return;
        }
        var actions = this.actions;
        var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
        var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
        var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];
        if (hasNone) {
          var isTapPointer = input2.pointers.length === 1;
          var isTapMovement = input2.distance < 2;
          var isTapTouchTime = input2.deltaTime < 250;
          if (isTapPointer && isTapMovement && isTapTouchTime) {
            return;
          }
        }
        if (hasPanX && hasPanY) {
          return;
        }
        if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
          return this.preventSrc(srcEvent);
        }
      },
      preventSrc: function(srcEvent) {
        this.manager.session.prevented = true;
        srcEvent.preventDefault();
      }
    };
    function cleanTouchActions(actions) {
      if (inStr(actions, TOUCH_ACTION_NONE)) {
        return TOUCH_ACTION_NONE;
      }
      var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
      var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y);
      if (hasPanX && hasPanY) {
        return TOUCH_ACTION_NONE;
      }
      if (hasPanX || hasPanY) {
        return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
      }
      if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
        return TOUCH_ACTION_MANIPULATION;
      }
      return TOUCH_ACTION_AUTO;
    }
    function getTouchActionProps() {
      if (!NATIVE_TOUCH_ACTION) {
        return false;
      }
      var touchMap = {};
      var cssSupports = window2.CSS && window2.CSS.supports;
      ["auto", "manipulation", "pan-y", "pan-x", "pan-x pan-y", "none"].forEach(function(val) {
        touchMap[val] = cssSupports ? window2.CSS.supports("touch-action", val) : true;
      });
      return touchMap;
    }
    var STATE_POSSIBLE = 1;
    var STATE_BEGAN = 2;
    var STATE_CHANGED = 4;
    var STATE_ENDED = 8;
    var STATE_RECOGNIZED = STATE_ENDED;
    var STATE_CANCELLED = 16;
    var STATE_FAILED = 32;
    function Recognizer(options2) {
      this.options = assign({}, this.defaults, options2 || {});
      this.id = uniqueId2();
      this.manager = null;
      this.options.enable = ifUndefined(this.options.enable, true);
      this.state = STATE_POSSIBLE;
      this.simultaneous = {};
      this.requireFail = [];
    }
    Recognizer.prototype = {
      defaults: {},
      set: function(options2) {
        assign(this.options, options2);
        this.manager && this.manager.touchAction.update();
        return this;
      },
      recognizeWith: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, "recognizeWith", this)) {
          return this;
        }
        var simultaneous = this.simultaneous;
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        if (!simultaneous[otherRecognizer.id]) {
          simultaneous[otherRecognizer.id] = otherRecognizer;
          otherRecognizer.recognizeWith(this);
        }
        return this;
      },
      dropRecognizeWith: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, "dropRecognizeWith", this)) {
          return this;
        }
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        delete this.simultaneous[otherRecognizer.id];
        return this;
      },
      requireFailure: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, "requireFailure", this)) {
          return this;
        }
        var requireFail = this.requireFail;
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        if (inArray(requireFail, otherRecognizer) === -1) {
          requireFail.push(otherRecognizer);
          otherRecognizer.requireFailure(this);
        }
        return this;
      },
      dropRequireFailure: function(otherRecognizer) {
        if (invokeArrayArg(otherRecognizer, "dropRequireFailure", this)) {
          return this;
        }
        otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
        var index2 = inArray(this.requireFail, otherRecognizer);
        if (index2 > -1) {
          this.requireFail.splice(index2, 1);
        }
        return this;
      },
      hasRequireFailures: function() {
        return this.requireFail.length > 0;
      },
      canRecognizeWith: function(otherRecognizer) {
        return !!this.simultaneous[otherRecognizer.id];
      },
      emit: function(input2) {
        var self2 = this;
        var state = this.state;
        function emit(event2) {
          self2.manager.emit(event2, input2);
        }
        if (state < STATE_ENDED) {
          emit(self2.options.event + stateStr(state));
        }
        emit(self2.options.event);
        if (input2.additionalEvent) {
          emit(input2.additionalEvent);
        }
        if (state >= STATE_ENDED) {
          emit(self2.options.event + stateStr(state));
        }
      },
      tryEmit: function(input2) {
        if (this.canEmit()) {
          return this.emit(input2);
        }
        this.state = STATE_FAILED;
      },
      canEmit: function() {
        var i2 = 0;
        while (i2 < this.requireFail.length) {
          if (!(this.requireFail[i2].state & (STATE_FAILED | STATE_POSSIBLE))) {
            return false;
          }
          i2++;
        }
        return true;
      },
      recognize: function(inputData) {
        var inputDataClone = assign({}, inputData);
        if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
          this.reset();
          this.state = STATE_FAILED;
          return;
        }
        if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
          this.state = STATE_POSSIBLE;
        }
        this.state = this.process(inputDataClone);
        if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
          this.tryEmit(inputDataClone);
        }
      },
      process: function(inputData) {
      },
      getTouchAction: function() {
      },
      reset: function() {
      }
    };
    function stateStr(state) {
      if (state & STATE_CANCELLED) {
        return "cancel";
      } else if (state & STATE_ENDED) {
        return "end";
      } else if (state & STATE_CHANGED) {
        return "move";
      } else if (state & STATE_BEGAN) {
        return "start";
      }
      return "";
    }
    function directionStr(direction) {
      if (direction == DIRECTION_DOWN) {
        return "down";
      } else if (direction == DIRECTION_UP) {
        return "up";
      } else if (direction == DIRECTION_LEFT) {
        return "left";
      } else if (direction == DIRECTION_RIGHT) {
        return "right";
      }
      return "";
    }
    function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
      var manager = recognizer.manager;
      if (manager) {
        return manager.get(otherRecognizer);
      }
      return otherRecognizer;
    }
    function AttrRecognizer() {
      Recognizer.apply(this, arguments);
    }
    inherit(AttrRecognizer, Recognizer, {
      defaults: {
        pointers: 1
      },
      attrTest: function(input2) {
        var optionPointers = this.options.pointers;
        return optionPointers === 0 || input2.pointers.length === optionPointers;
      },
      process: function(input2) {
        var state = this.state;
        var eventType = input2.eventType;
        var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
        var isValid = this.attrTest(input2);
        if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
          return state | STATE_CANCELLED;
        } else if (isRecognized || isValid) {
          if (eventType & INPUT_END) {
            return state | STATE_ENDED;
          } else if (!(state & STATE_BEGAN)) {
            return STATE_BEGAN;
          }
          return state | STATE_CHANGED;
        }
        return STATE_FAILED;
      }
    });
    function PanRecognizer() {
      AttrRecognizer.apply(this, arguments);
      this.pX = null;
      this.pY = null;
    }
    inherit(PanRecognizer, AttrRecognizer, {
      defaults: {
        event: "pan",
        threshold: 10,
        pointers: 1,
        direction: DIRECTION_ALL
      },
      getTouchAction: function() {
        var direction = this.options.direction;
        var actions = [];
        if (direction & DIRECTION_HORIZONTAL) {
          actions.push(TOUCH_ACTION_PAN_Y);
        }
        if (direction & DIRECTION_VERTICAL) {
          actions.push(TOUCH_ACTION_PAN_X);
        }
        return actions;
      },
      directionTest: function(input2) {
        var options2 = this.options;
        var hasMoved = true;
        var distance = input2.distance;
        var direction = input2.direction;
        var x2 = input2.deltaX;
        var y2 = input2.deltaY;
        if (!(direction & options2.direction)) {
          if (options2.direction & DIRECTION_HORIZONTAL) {
            direction = x2 === 0 ? DIRECTION_NONE : x2 < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
            hasMoved = x2 != this.pX;
            distance = Math.abs(input2.deltaX);
          } else {
            direction = y2 === 0 ? DIRECTION_NONE : y2 < 0 ? DIRECTION_UP : DIRECTION_DOWN;
            hasMoved = y2 != this.pY;
            distance = Math.abs(input2.deltaY);
          }
        }
        input2.direction = direction;
        return hasMoved && distance > options2.threshold && direction & options2.direction;
      },
      attrTest: function(input2) {
        return AttrRecognizer.prototype.attrTest.call(this, input2) && (this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input2));
      },
      emit: function(input2) {
        this.pX = input2.deltaX;
        this.pY = input2.deltaY;
        var direction = directionStr(input2.direction);
        if (direction) {
          input2.additionalEvent = this.options.event + direction;
        }
        this._super.emit.call(this, input2);
      }
    });
    function PinchRecognizer() {
      AttrRecognizer.apply(this, arguments);
    }
    inherit(PinchRecognizer, AttrRecognizer, {
      defaults: {
        event: "pinch",
        threshold: 0,
        pointers: 2
      },
      getTouchAction: function() {
        return [TOUCH_ACTION_NONE];
      },
      attrTest: function(input2) {
        return this._super.attrTest.call(this, input2) && (Math.abs(input2.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
      },
      emit: function(input2) {
        if (input2.scale !== 1) {
          var inOut = input2.scale < 1 ? "in" : "out";
          input2.additionalEvent = this.options.event + inOut;
        }
        this._super.emit.call(this, input2);
      }
    });
    function PressRecognizer() {
      Recognizer.apply(this, arguments);
      this._timer = null;
      this._input = null;
    }
    inherit(PressRecognizer, Recognizer, {
      defaults: {
        event: "press",
        pointers: 1,
        time: 251,
        threshold: 9
      },
      getTouchAction: function() {
        return [TOUCH_ACTION_AUTO];
      },
      process: function(input2) {
        var options2 = this.options;
        var validPointers = input2.pointers.length === options2.pointers;
        var validMovement = input2.distance < options2.threshold;
        var validTime = input2.deltaTime > options2.time;
        this._input = input2;
        if (!validMovement || !validPointers || input2.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
          this.reset();
        } else if (input2.eventType & INPUT_START) {
          this.reset();
          this._timer = setTimeoutContext(function() {
            this.state = STATE_RECOGNIZED;
            this.tryEmit();
          }, options2.time, this);
        } else if (input2.eventType & INPUT_END) {
          return STATE_RECOGNIZED;
        }
        return STATE_FAILED;
      },
      reset: function() {
        clearTimeout(this._timer);
      },
      emit: function(input2) {
        if (this.state !== STATE_RECOGNIZED) {
          return;
        }
        if (input2 && input2.eventType & INPUT_END) {
          this.manager.emit(this.options.event + "up", input2);
        } else {
          this._input.timeStamp = now();
          this.manager.emit(this.options.event, this._input);
        }
      }
    });
    function RotateRecognizer() {
      AttrRecognizer.apply(this, arguments);
    }
    inherit(RotateRecognizer, AttrRecognizer, {
      defaults: {
        event: "rotate",
        threshold: 0,
        pointers: 2
      },
      getTouchAction: function() {
        return [TOUCH_ACTION_NONE];
      },
      attrTest: function(input2) {
        return this._super.attrTest.call(this, input2) && (Math.abs(input2.rotation) > this.options.threshold || this.state & STATE_BEGAN);
      }
    });
    function SwipeRecognizer() {
      AttrRecognizer.apply(this, arguments);
    }
    inherit(SwipeRecognizer, AttrRecognizer, {
      defaults: {
        event: "swipe",
        threshold: 10,
        velocity: 0.3,
        direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
        pointers: 1
      },
      getTouchAction: function() {
        return PanRecognizer.prototype.getTouchAction.call(this);
      },
      attrTest: function(input2) {
        var direction = this.options.direction;
        var velocity;
        if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
          velocity = input2.overallVelocity;
        } else if (direction & DIRECTION_HORIZONTAL) {
          velocity = input2.overallVelocityX;
        } else if (direction & DIRECTION_VERTICAL) {
          velocity = input2.overallVelocityY;
        }
        return this._super.attrTest.call(this, input2) && direction & input2.offsetDirection && input2.distance > this.options.threshold && input2.maxPointers == this.options.pointers && abs2(velocity) > this.options.velocity && input2.eventType & INPUT_END;
      },
      emit: function(input2) {
        var direction = directionStr(input2.offsetDirection);
        if (direction) {
          this.manager.emit(this.options.event + direction, input2);
        }
        this.manager.emit(this.options.event, input2);
      }
    });
    function TapRecognizer() {
      Recognizer.apply(this, arguments);
      this.pTime = false;
      this.pCenter = false;
      this._timer = null;
      this._input = null;
      this.count = 0;
    }
    inherit(TapRecognizer, Recognizer, {
      defaults: {
        event: "tap",
        pointers: 1,
        taps: 1,
        interval: 300,
        time: 250,
        threshold: 9,
        posThreshold: 10
      },
      getTouchAction: function() {
        return [TOUCH_ACTION_MANIPULATION];
      },
      process: function(input2) {
        var options2 = this.options;
        var validPointers = input2.pointers.length === options2.pointers;
        var validMovement = input2.distance < options2.threshold;
        var validTouchTime = input2.deltaTime < options2.time;
        this.reset();
        if (input2.eventType & INPUT_START && this.count === 0) {
          return this.failTimeout();
        }
        if (validMovement && validTouchTime && validPointers) {
          if (input2.eventType != INPUT_END) {
            return this.failTimeout();
          }
          var validInterval = this.pTime ? input2.timeStamp - this.pTime < options2.interval : true;
          var validMultiTap = !this.pCenter || getDistance(this.pCenter, input2.center) < options2.posThreshold;
          this.pTime = input2.timeStamp;
          this.pCenter = input2.center;
          if (!validMultiTap || !validInterval) {
            this.count = 1;
          } else {
            this.count += 1;
          }
          this._input = input2;
          var tapCount = this.count % options2.taps;
          if (tapCount === 0) {
            if (!this.hasRequireFailures()) {
              return STATE_RECOGNIZED;
            } else {
              this._timer = setTimeoutContext(function() {
                this.state = STATE_RECOGNIZED;
                this.tryEmit();
              }, options2.interval, this);
              return STATE_BEGAN;
            }
          }
        }
        return STATE_FAILED;
      },
      failTimeout: function() {
        this._timer = setTimeoutContext(function() {
          this.state = STATE_FAILED;
        }, this.options.interval, this);
        return STATE_FAILED;
      },
      reset: function() {
        clearTimeout(this._timer);
      },
      emit: function() {
        if (this.state == STATE_RECOGNIZED) {
          this._input.tapCount = this.count;
          this.manager.emit(this.options.event, this._input);
        }
      }
    });
    function Hammer2(element, options2) {
      options2 = options2 || {};
      options2.recognizers = ifUndefined(options2.recognizers, Hammer2.defaults.preset);
      return new Manager(element, options2);
    }
    Hammer2.VERSION = "2.0.7";
    Hammer2.defaults = {
      domEvents: false,
      touchAction: TOUCH_ACTION_COMPUTE,
      enable: true,
      inputTarget: null,
      inputClass: null,
      preset: [
        [RotateRecognizer, { enable: false }],
        [PinchRecognizer, { enable: false }, ["rotate"]],
        [SwipeRecognizer, { direction: DIRECTION_HORIZONTAL }],
        [PanRecognizer, { direction: DIRECTION_HORIZONTAL }, ["swipe"]],
        [TapRecognizer],
        [TapRecognizer, { event: "doubletap", taps: 2 }, ["tap"]],
        [PressRecognizer]
      ],
      cssProps: {
        userSelect: "none",
        touchSelect: "none",
        touchCallout: "none",
        contentZooming: "none",
        userDrag: "none",
        tapHighlightColor: "rgba(0,0,0,0)"
      }
    };
    var STOP = 1;
    var FORCED_STOP = 2;
    function Manager(element, options2) {
      this.options = assign({}, Hammer2.defaults, options2 || {});
      this.options.inputTarget = this.options.inputTarget || element;
      this.handlers = {};
      this.session = {};
      this.recognizers = [];
      this.oldCssProps = {};
      this.element = element;
      this.input = createInputInstance(this);
      this.touchAction = new TouchAction(this, this.options.touchAction);
      toggleCssProps(this, true);
      each2(this.options.recognizers, function(item) {
        var recognizer = this.add(new item[0](item[1]));
        item[2] && recognizer.recognizeWith(item[2]);
        item[3] && recognizer.requireFailure(item[3]);
      }, this);
    }
    Manager.prototype = {
      set: function(options2) {
        assign(this.options, options2);
        if (options2.touchAction) {
          this.touchAction.update();
        }
        if (options2.inputTarget) {
          this.input.destroy();
          this.input.target = options2.inputTarget;
          this.input.init();
        }
        return this;
      },
      stop: function(force) {
        this.session.stopped = force ? FORCED_STOP : STOP;
      },
      recognize: function(inputData) {
        var session = this.session;
        if (session.stopped) {
          return;
        }
        this.touchAction.preventDefaults(inputData);
        var recognizer;
        var recognizers = this.recognizers;
        var curRecognizer = session.curRecognizer;
        if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
          curRecognizer = session.curRecognizer = null;
        }
        var i2 = 0;
        while (i2 < recognizers.length) {
          recognizer = recognizers[i2];
          if (session.stopped !== FORCED_STOP && (!curRecognizer || recognizer == curRecognizer || recognizer.canRecognizeWith(curRecognizer))) {
            recognizer.recognize(inputData);
          } else {
            recognizer.reset();
          }
          if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
            curRecognizer = session.curRecognizer = recognizer;
          }
          i2++;
        }
      },
      get: function(recognizer) {
        if (recognizer instanceof Recognizer) {
          return recognizer;
        }
        var recognizers = this.recognizers;
        for (var i2 = 0; i2 < recognizers.length; i2++) {
          if (recognizers[i2].options.event == recognizer) {
            return recognizers[i2];
          }
        }
        return null;
      },
      add: function(recognizer) {
        if (invokeArrayArg(recognizer, "add", this)) {
          return this;
        }
        var existing = this.get(recognizer.options.event);
        if (existing) {
          this.remove(existing);
        }
        this.recognizers.push(recognizer);
        recognizer.manager = this;
        this.touchAction.update();
        return recognizer;
      },
      remove: function(recognizer) {
        if (invokeArrayArg(recognizer, "remove", this)) {
          return this;
        }
        recognizer = this.get(recognizer);
        if (recognizer) {
          var recognizers = this.recognizers;
          var index2 = inArray(recognizers, recognizer);
          if (index2 !== -1) {
            recognizers.splice(index2, 1);
            this.touchAction.update();
          }
        }
        return this;
      },
      on: function(events, handler) {
        if (events === undefined$1) {
          return;
        }
        if (handler === undefined$1) {
          return;
        }
        var handlers = this.handlers;
        each2(splitStr(events), function(event2) {
          handlers[event2] = handlers[event2] || [];
          handlers[event2].push(handler);
        });
        return this;
      },
      off: function(events, handler) {
        if (events === undefined$1) {
          return;
        }
        var handlers = this.handlers;
        each2(splitStr(events), function(event2) {
          if (!handler) {
            delete handlers[event2];
          } else {
            handlers[event2] && handlers[event2].splice(inArray(handlers[event2], handler), 1);
          }
        });
        return this;
      },
      emit: function(event2, data2) {
        if (this.options.domEvents) {
          triggerDomEvent(event2, data2);
        }
        var handlers = this.handlers[event2] && this.handlers[event2].slice();
        if (!handlers || !handlers.length) {
          return;
        }
        data2.type = event2;
        data2.preventDefault = function() {
          data2.srcEvent.preventDefault();
        };
        var i2 = 0;
        while (i2 < handlers.length) {
          handlers[i2](data2);
          i2++;
        }
      },
      destroy: function() {
        this.element && toggleCssProps(this, false);
        this.handlers = {};
        this.session = {};
        this.input.destroy();
        this.element = null;
      }
    };
    function toggleCssProps(manager, add2) {
      var element = manager.element;
      if (!element.style) {
        return;
      }
      var prop;
      each2(manager.options.cssProps, function(value, name) {
        prop = prefixed(element.style, name);
        if (add2) {
          manager.oldCssProps[prop] = element.style[prop];
          element.style[prop] = value;
        } else {
          element.style[prop] = manager.oldCssProps[prop] || "";
        }
      });
      if (!add2) {
        manager.oldCssProps = {};
      }
    }
    function triggerDomEvent(event2, data2) {
      var gestureEvent = document2.createEvent("Event");
      gestureEvent.initEvent(event2, true, true);
      gestureEvent.gesture = data2;
      data2.target.dispatchEvent(gestureEvent);
    }
    assign(Hammer2, {
      INPUT_START,
      INPUT_MOVE,
      INPUT_END,
      INPUT_CANCEL,
      STATE_POSSIBLE,
      STATE_BEGAN,
      STATE_CHANGED,
      STATE_ENDED,
      STATE_RECOGNIZED,
      STATE_CANCELLED,
      STATE_FAILED,
      DIRECTION_NONE,
      DIRECTION_LEFT,
      DIRECTION_RIGHT,
      DIRECTION_UP,
      DIRECTION_DOWN,
      DIRECTION_HORIZONTAL,
      DIRECTION_VERTICAL,
      DIRECTION_ALL,
      Manager,
      Input,
      TouchAction,
      TouchInput,
      MouseInput,
      PointerEventInput,
      TouchMouseInput,
      SingleTouchInput,
      Recognizer,
      AttrRecognizer,
      Tap: TapRecognizer,
      Pan: PanRecognizer,
      Swipe: SwipeRecognizer,
      Pinch: PinchRecognizer,
      Rotate: RotateRecognizer,
      Press: PressRecognizer,
      on: addEventListeners,
      off: removeEventListeners,
      each: each2,
      merge: merge2,
      extend: extend2,
      assign,
      inherit,
      bindFn,
      prefixed
    });
    var freeGlobal = typeof window2 !== "undefined" ? window2 : typeof self !== "undefined" ? self : {};
    freeGlobal.Hammer = Hammer2;
    if (typeof undefined$1 === "function" && undefined$1.amd) {
      undefined$1(function() {
        return Hammer2;
      });
    } else if (module.exports) {
      module.exports = Hammer2;
    } else {
      window2[exportName] = Hammer2;
    }
  })(window, document, "Hammer");
})(hammer);
var Hammer = hammer.exports;
class DOMView extends View {
  initialize() {
    super.initialize();
    this.el = this._createElement();
  }
  remove() {
    remove(this.el);
    super.remove();
  }
  css_classes() {
    return [];
  }
  render() {
  }
  renderTo(element) {
    element.appendChild(this.el);
    this.render();
    this._has_finished = true;
    this.notify_finished();
  }
  _createElement() {
    return createElement(this.constructor.tag_name, { class: this.css_classes() });
  }
}
DOMView.__name__ = "DOMView";
DOMView.tag_name = "div";
const root$2 = "bk-root";
const toolbar_hidden = "bk-toolbar-hidden";
const toolbar = "bk-toolbar";
const logo$1 = "bk-logo";
const above$2 = "bk-above";
const below$3 = "bk-below";
const left$2 = "bk-left";
const right$2 = "bk-right";
const toolbar_button = "bk-toolbar-button";
const tool_overflow = "bk-tool-overflow";
const active$3 = "bk-active";
const divider$1 = "bk-divider";
const horizontal$1 = "bk-horizontal";
const vertical$1 = "bk-vertical";
var toolbars_css = `.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toolbar-button:hover,.bk-root .bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toolbar-button:focus,.bk-root .bk-tool-overflow:focus,.bk-root .bk-toolbar-button:focus-visible,.bk-root .bk-tool-overflow:focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-toolbar-button::-moz-focus-inner,.bk-root .bk-tool-overflow::-moz-focus-inner{border:0;}.bk-root .bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-divider{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-above .bk-divider,.bk-root .bk-below .bk-divider{height:10px;width:1px;}.bk-root .bk-left .bk-divider,.bk-root .bk-right .bk-divider{height:1px;width:10px;}.bk-root .bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-root .bk-above .bk-tool-overflow,.bk-root .bk-below .bk-tool-overflow,.bk-root .bk-horizontal .bk-tool-overflow{width:15px;height:30px;flex-direction:row;}.bk-root .bk-left .bk-tool-overflow,.bk-root .bk-right .bk-tool-overflow,.bk-root .bk-vertical .bk-tool-overflow{width:30px;height:15px;flex-direction:column;}`;
var toolbars = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root: root$2,
  toolbar_hidden,
  toolbar,
  logo: logo$1,
  above: above$2,
  below: below$3,
  left: left$2,
  right: right$2,
  toolbar_button,
  tool_overflow,
  active: active$3,
  divider: divider$1,
  horizontal: horizontal$1,
  vertical: vertical$1,
  "default": toolbars_css
}, Symbol.toStringTag, { value: "Module" }));
const tool_icon_box_select = "bk-tool-icon-box-select";
const tool_icon_box_zoom = "bk-tool-icon-box-zoom";
const tool_icon_zoom_in = "bk-tool-icon-zoom-in";
const tool_icon_zoom_out = "bk-tool-icon-zoom-out";
const tool_icon_help = "bk-tool-icon-help";
const tool_icon_hover = "bk-tool-icon-hover";
const tool_icon_crosshair = "bk-tool-icon-crosshair";
const tool_icon_lasso_select = "bk-tool-icon-lasso-select";
const tool_icon_pan = "bk-tool-icon-pan";
const tool_icon_xpan = "bk-tool-icon-xpan";
const tool_icon_ypan = "bk-tool-icon-ypan";
const tool_icon_range = "bk-tool-icon-range";
const tool_icon_polygon_select = "bk-tool-icon-polygon-select";
const tool_icon_redo = "bk-tool-icon-redo";
const tool_icon_reset = "bk-tool-icon-reset";
const tool_icon_save = "bk-tool-icon-save";
const tool_icon_tap_select = "bk-tool-icon-tap-select";
const tool_icon_undo = "bk-tool-icon-undo";
const tool_icon_wheel_pan = "bk-tool-icon-wheel-pan";
const tool_icon_wheel_zoom = "bk-tool-icon-wheel-zoom";
const tool_icon_box_edit = "bk-tool-icon-box-edit";
const tool_icon_freehand_draw = "bk-tool-icon-freehand-draw";
const tool_icon_poly_draw = "bk-tool-icon-poly-draw";
const tool_icon_point_draw = "bk-tool-icon-point-draw";
const tool_icon_poly_edit = "bk-tool-icon-poly-edit";
const tool_icon_line_edit = "bk-tool-icon-line-edit";
var icons_css = `.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}`;
const divider = "bk-divider";
const active$2 = "bk-active";
const menu = "bk-menu";
const below$2 = "bk-below";
const caret = "bk-caret";
const down = "bk-down";
var menus_css = `.bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu > :not(.bk-divider):focus,.bk-root .bk-context-menu > :not(.bk-divider):focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-context-menu > :not(.bk-divider)::-moz-focus-inner{border:0;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}`;
class ContextMenu {
  constructor(items, options2 = {}) {
    var _a2, _b2;
    this.items = items;
    this.el = div();
    this._open = false;
    this._item_click = (entry) => {
      var _a3;
      (_a3 = entry.handler) == null ? void 0 : _a3.call(entry);
      this.hide();
    };
    this._on_mousedown = (event2) => {
      var _a3;
      const { target } = event2;
      if (target instanceof Node && this.el.contains(target))
        return;
      if ((_a3 = this.prevent_hide) == null ? void 0 : _a3.call(this, event2))
        return;
      this.hide();
    };
    this._on_keydown = (event2) => {
      if (event2.keyCode == Keys.Esc)
        this.hide();
    };
    this._on_blur = () => {
      this.hide();
    };
    this.orientation = (_a2 = options2.orientation) != null ? _a2 : "vertical";
    this.reversed = (_b2 = options2.reversed) != null ? _b2 : false;
    this.prevent_hide = options2.prevent_hide;
    undisplay(this.el);
  }
  get is_open() {
    return this._open;
  }
  get can_open() {
    return this.items.length != 0;
  }
  remove() {
    remove(this.el);
    this._unlisten();
  }
  _listen() {
    document.addEventListener("mousedown", this._on_mousedown);
    document.addEventListener("keydown", this._on_keydown);
    window.addEventListener("blur", this._on_blur);
  }
  _unlisten() {
    document.removeEventListener("mousedown", this._on_mousedown);
    document.removeEventListener("keydown", this._on_keydown);
    window.removeEventListener("blur", this._on_blur);
  }
  _position(at) {
    const parent_el = this.el.parentElement;
    if (parent_el != null) {
      const pos = (() => {
        if ("left_of" in at) {
          const { left: left2, top } = at.left_of.getBoundingClientRect();
          return { right: left2, top };
        }
        if ("right_of" in at) {
          const { top, right: right2 } = at.right_of.getBoundingClientRect();
          return { left: right2, top };
        }
        if ("below" in at) {
          const { left: left2, bottom } = at.below.getBoundingClientRect();
          return { left: left2, top: bottom };
        }
        if ("above" in at) {
          const { left: left2, top } = at.above.getBoundingClientRect();
          return { left: left2, bottom: top };
        }
        return at;
      })();
      const parent = parent_el.getBoundingClientRect();
      this.el.style.left = pos.left != null ? `${pos.left - parent.left}px` : "";
      this.el.style.top = pos.top != null ? `${pos.top - parent.top}px` : "";
      this.el.style.right = pos.right != null ? `${parent.right - pos.right}px` : "";
      this.el.style.bottom = pos.bottom != null ? `${parent.bottom - pos.bottom}px` : "";
    }
  }
  render() {
    var _a2;
    empty$1(this.el, true);
    classes(this.el).add("bk-context-menu", `bk-${this.orientation}`);
    const items = this.reversed ? reversed(this.items) : this.items;
    for (const item of items) {
      let el;
      if (item == null) {
        el = div({ class: divider });
      } else if (item.if != null && !item.if()) {
        continue;
      } else if (item.content != null) {
        el = item.content;
      } else {
        const icon = item.icon != null ? div({ class: ["bk-menu-icon", item.icon] }) : null;
        const classes2 = [((_a2 = item.active) == null ? void 0 : _a2.call(item)) ? "bk-active" : null, item.class];
        el = div({ class: classes2, title: item.tooltip, tabIndex: 0 }, icon, item.label, item.content);
        el.addEventListener("click", () => {
          this._item_click(item);
        });
        el.addEventListener("keydown", (event2) => {
          if (event2.keyCode == Keys.Enter) {
            this._item_click(item);
          }
        });
      }
      this.el.appendChild(el);
    }
  }
  show(at) {
    if (this.items.length == 0)
      return;
    if (!this._open) {
      this.render();
      if (this.el.children.length == 0)
        return;
      this._position(at != null ? at : { left: 0, top: 0 });
      display(this.el);
      this._listen();
      this._open = true;
    }
  }
  hide() {
    if (this._open) {
      this._open = false;
      this._unlisten();
      undisplay(this.el);
    }
  }
  toggle(at) {
    this._open ? this.hide() : this.show(at);
  }
}
ContextMenu.__name__ = "ContextMenu";
var _a$2G;
class ButtonToolButtonView extends DOMView {
  initialize() {
    super.initialize();
    const items = this.model.menu;
    if (items != null) {
      const location = this.parent.model.toolbar_location;
      const reverse = location == "left" || location == "above";
      const orientation = this.parent.model.horizontal ? "vertical" : "horizontal";
      this._menu = new ContextMenu(!reverse ? items : reversed(items), {
        orientation,
        prevent_hide: (event2) => event2.target == this.el
      });
    }
    this._hammer = new Hammer(this.el, {
      touchAction: "auto",
      inputClass: Hammer.TouchMouseInput
    });
    this.connect(this.model.change, () => this.render());
    this._hammer.on("tap", (e) => {
      var _a2;
      if ((_a2 = this._menu) == null ? void 0 : _a2.is_open) {
        this._menu.hide();
        return;
      }
      if (e.target == this.el) {
        this._clicked();
      }
    });
    this._hammer.on("press", () => this._pressed());
    this.el.addEventListener("keydown", (event2) => {
      if (event2.keyCode == Keys.Enter) {
        this._clicked();
      }
    });
  }
  remove() {
    var _a2;
    this._hammer.destroy();
    (_a2 = this._menu) == null ? void 0 : _a2.remove();
    super.remove();
  }
  styles() {
    return [...super.styles(), toolbars_css, icons_css, menus_css];
  }
  css_classes() {
    return super.css_classes().concat(toolbar_button);
  }
  render() {
    empty$1(this.el);
    const icon = this.model.computed_icon;
    if (isString(icon)) {
      if (startsWith(icon, "data:image"))
        this.el.style.backgroundImage = `url("${icon}")`;
      else
        this.el.classList.add(icon);
    }
    this.el.title = this.model.tooltip;
    this.el.tabIndex = 0;
    if (this._menu != null) {
      this.root.el.appendChild(this._menu.el);
    }
  }
  _pressed() {
    var _a2;
    const at = (() => {
      switch (this.parent.model.toolbar_location) {
        case "right":
          return { left_of: this.el };
        case "left":
          return { right_of: this.el };
        case "above":
          return { below: this.el };
        case "below":
          return { above: this.el };
      }
    })();
    (_a2 = this._menu) == null ? void 0 : _a2.toggle(at);
  }
}
ButtonToolButtonView.__name__ = "ButtonToolButtonView";
class ButtonToolView extends ToolView {
}
ButtonToolView.__name__ = "ButtonToolView";
class ButtonTool extends Tool {
  constructor(attrs) {
    super(attrs);
  }
  _get_dim_tooltip(dims) {
    const { description, tool_name } = this;
    if (description != null)
      return description;
    else if (dims == "both")
      return tool_name;
    else
      return `${tool_name} (${dims == "width" ? "x" : "y"}-axis)`;
  }
  get tooltip() {
    var _a2;
    return (_a2 = this.description) != null ? _a2 : this.tool_name;
  }
  get computed_icon() {
    return this.icon;
  }
  get menu() {
    return null;
  }
}
_a$2G = ButtonTool;
ButtonTool.__name__ = "ButtonTool";
(() => {
  _a$2G.internal(({ Boolean: Boolean2 }) => ({
    disabled: [Boolean2, false]
  }));
})();
class OnOffButtonView extends ButtonToolButtonView {
  render() {
    super.render();
    classes(this.el).toggle(active$3, this.model.active);
  }
  _clicked() {
    const { active: active2 } = this.model;
    this.model.active = !active2;
  }
}
OnOffButtonView.__name__ = "OnOffButtonView";
class GestureToolView extends ButtonToolView {
}
GestureToolView.__name__ = "GestureToolView";
class GestureTool extends ButtonTool {
  constructor(attrs) {
    super(attrs);
    this.button_view = OnOffButtonView;
  }
}
GestureTool.__name__ = "GestureTool";
var _a$2F;
class InspectToolView extends ButtonToolView {
}
InspectToolView.__name__ = "InspectToolView";
class InspectTool extends ButtonTool {
  constructor(attrs) {
    super(attrs);
    this.event_type = "move";
  }
}
_a$2F = InspectTool;
InspectTool.__name__ = "InspectTool";
(() => {
  _a$2F.prototype.button_view = OnOffButtonView;
  _a$2F.define(({ Boolean: Boolean2 }) => ({
    toggleable: [Boolean2, true]
  }));
  _a$2F.override({
    active: true
  });
})();
function* enumerate(seq) {
  let i2 = 0;
  for (const item of seq) {
    yield [item, i2++];
  }
}
function* join(seq, separator) {
  let first = true;
  for (const entry of seq) {
    if (first)
      first = false;
    else if (separator != null)
      yield separator();
    yield* entry;
  }
}
const MAX_INT32 = 2147483647;
class Random {
  constructor(seed) {
    this.seed = seed % MAX_INT32;
    if (this.seed <= 0)
      this.seed += MAX_INT32 - 1;
  }
  integer() {
    this.seed = 48271 * this.seed % MAX_INT32;
    return this.seed;
  }
  float() {
    return (this.integer() - 1) / (MAX_INT32 - 1);
  }
  floats(n2, a2 = 0, b = 1) {
    const result = new Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      result[i2] = a2 + this.float() * (b - a2);
    }
    return result;
  }
  choices(n2, items) {
    const k = items.length;
    const result = new Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      result[i2] = items[this.integer() % k];
    }
    return result;
  }
}
Random.__name__ = "Random";
const random = new Random(Date.now());
function createNamedToNumberedLookup(input2, radix) {
  const lookup = /* @__PURE__ */ new Map();
  const items = input2.split(",");
  radix = radix != null ? radix : 10;
  for (let i2 = 0; i2 < items.length; i2 += 2) {
    const entity = `&${items[i2 + 1]};`;
    const base10 = parseInt(items[i2], radix);
    lookup.set(entity, `&#${base10};`);
  }
  lookup.set("\\xa0", "&#160;");
  return lookup;
}
function getTextAnchor(textAlign) {
  var _a2;
  const mapping = { left: "start", right: "end", center: "middle", start: "start", end: "end" };
  return (_a2 = mapping[textAlign]) != null ? _a2 : mapping.start;
}
function getDominantBaseline(textBaseline) {
  var _a2;
  const mapping = { alphabetic: "alphabetic", hanging: "hanging", top: "text-before-edge", bottom: "text-after-edge", middle: "central" };
  return (_a2 = mapping[textBaseline]) != null ? _a2 : mapping.alphabetic;
}
const namedEntities = createNamedToNumberedLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro", 32);
const STYLES = {
  strokeStyle: {
    svgAttr: "stroke",
    canvas: "#000000",
    svg: "none",
    apply: "stroke"
  },
  fillStyle: {
    svgAttr: "fill",
    canvas: "#000000",
    svg: null,
    apply: "fill"
  },
  lineCap: {
    svgAttr: "stroke-linecap",
    canvas: "butt",
    svg: "butt",
    apply: "stroke"
  },
  lineJoin: {
    svgAttr: "stroke-linejoin",
    canvas: "miter",
    svg: "miter",
    apply: "stroke"
  },
  miterLimit: {
    svgAttr: "stroke-miterlimit",
    canvas: 10,
    svg: 4,
    apply: "stroke"
  },
  lineWidth: {
    svgAttr: "stroke-width",
    canvas: 1,
    svg: 1,
    apply: "stroke"
  },
  globalAlpha: {
    svgAttr: "opacity",
    canvas: 1,
    svg: 1,
    apply: "fill stroke"
  },
  font: {
    canvas: "10px sans-serif"
  },
  shadowColor: {
    canvas: "#000000"
  },
  shadowOffsetX: {
    canvas: 0
  },
  shadowOffsetY: {
    canvas: 0
  },
  shadowBlur: {
    canvas: 0
  },
  textAlign: {
    canvas: "start"
  },
  textBaseline: {
    canvas: "alphabetic"
  },
  lineDash: {
    svgAttr: "stroke-dasharray",
    canvas: [],
    svg: null,
    apply: "stroke"
  },
  lineDashOffset: {
    svgAttr: "stroke-dashoffset",
    canvas: 0,
    svg: 0,
    apply: "stroke"
  }
};
class CanvasGradient {
  constructor(gradientNode, ctx) {
    this.__root = gradientNode;
    this.__ctx = ctx;
  }
  addColorStop(offset2, color) {
    if (this.__root.nodeName === "linearGradient" && this.__root.getAttribute("x1") === this.__root.getAttribute("x2") && this.__root.getAttribute("y1") === this.__root.getAttribute("y2"))
      return;
    if (this.__root.nodeName === "radialGradient" && this.__root.getAttribute("cx") === this.__root.getAttribute("fx") && this.__root.getAttribute("cy") === this.__root.getAttribute("fy") && this.__root.getAttribute("r") === this.__root.getAttribute("r0"))
      return;
    const stop = this.__ctx.__createElement("stop");
    stop.setAttribute("offset", `${offset2}`);
    if (color.indexOf("rgba") !== -1) {
      const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
      const matches = regex.exec(color);
      const [, r, g, b, a2] = matches;
      stop.setAttribute("stop-color", `rgb(${r},${g},${b})`);
      stop.setAttribute("stop-opacity", a2);
    } else {
      stop.setAttribute("stop-color", color);
    }
    this.__root.appendChild(stop);
  }
}
CanvasGradient.__name__ = "CanvasGradient";
class CanvasPattern {
  constructor(pattern, ctx) {
    this.__root = pattern;
    this.__ctx = ctx;
  }
  setTransform(_transform) {
    throw new Error("not implemented");
  }
}
CanvasPattern.__name__ = "CanvasPattern";
class SVGRenderingContext2D {
  constructor(options2) {
    var _a2, _b2, _c2;
    this.__currentPosition = null;
    this._transform = new AffineTransform();
    this._clip_path = null;
    this.__document = (_a2 = options2 == null ? void 0 : options2.document) != null ? _a2 : document;
    if (options2 == null ? void 0 : options2.ctx) {
      this.__ctx = options2.ctx;
    } else {
      this.__canvas = this.__document.createElement("canvas");
      this.__ctx = this.__canvas.getContext("2d");
    }
    this.__setDefaultStyles();
    this.__stack = [];
    this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg");
    this.__root.setAttribute("version", "1.1");
    this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
    this.width = (_b2 = options2 == null ? void 0 : options2.width) != null ? _b2 : 500;
    this.height = (_c2 = options2 == null ? void 0 : options2.height) != null ? _c2 : 500;
    this.__ids = /* @__PURE__ */ new Set();
    this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs");
    this.__root.appendChild(this.__defs);
  }
  get canvas() {
    return this;
  }
  get width() {
    return this._width;
  }
  set width(width) {
    this._width = width;
    this.__root.setAttribute("width", `${width}`);
  }
  get height() {
    return this._height;
  }
  set height(height) {
    this._height = height;
    this.__root.setAttribute("height", `${height}`);
  }
  _random_string() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
    let str;
    do {
      str = SVGRenderingContext2D.__random.choices(12, chars).join("");
    } while (this.__ids.has(str));
    return str;
  }
  __createElement(elementName, properties = {}, resetFill = false) {
    const element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);
    if (resetFill) {
      element.setAttribute("fill", "none");
      element.setAttribute("stroke", "none");
    }
    const keys2 = Object.keys(properties);
    for (const key of keys2) {
      element.setAttribute(key, `${properties[key]}`);
    }
    return element;
  }
  __setDefaultStyles() {
    const keys2 = Object.keys(STYLES);
    const self2 = this;
    for (let i2 = 0; i2 < keys2.length; i2++) {
      const key = keys2[i2];
      self2[key] = STYLES[key].canvas;
    }
  }
  __applyStyleState(styleState) {
    const keys2 = Object.keys(styleState);
    const self2 = this;
    for (let i2 = 0; i2 < keys2.length; i2++) {
      const key = keys2[i2];
      self2[key] = styleState[key];
    }
  }
  __getStyleState() {
    const keys2 = Object.keys(STYLES);
    const styleState = {};
    for (let i2 = 0; i2 < keys2.length; i2++) {
      const key = keys2[i2];
      styleState[key] = this[key];
    }
    return styleState;
  }
  __applyStyleToCurrentElement(type) {
    var _a2;
    const currentElement = this.__currentElement;
    const keys2 = Object.keys(STYLES);
    for (let i2 = 0; i2 < keys2.length; i2++) {
      const style2 = STYLES[keys2[i2]];
      const value = this[keys2[i2]];
      if ((_a2 = style2.apply) == null ? void 0 : _a2.includes(type)) {
        if (value instanceof CanvasPattern) {
          for (const def of [...value.__ctx.__defs.childNodes]) {
            if (def instanceof Element) {
              const id2 = def.getAttribute("id");
              this.__ids.add(id2);
              this.__defs.appendChild(def);
            }
          }
          const id = value.__root.getAttribute("id");
          currentElement.setAttribute(style2.apply, `url(#${id})`);
        } else if (value instanceof CanvasGradient) {
          const id = value.__root.getAttribute("id");
          currentElement.setAttribute(style2.apply, `url(#${id})`);
        } else if (style2.svg !== value) {
          if ((style2.svgAttr === "stroke" || style2.svgAttr === "fill") && isString(value) && value.indexOf("rgba") !== -1) {
            const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
            const matches = regex.exec(value);
            const [, r, g, b, a2] = matches;
            currentElement.setAttribute(style2.svgAttr, `rgb(${r},${g},${b})`);
            let opacity = parseFloat(a2);
            const globalAlpha = this.globalAlpha;
            if (globalAlpha != null) {
              opacity *= globalAlpha;
            }
            currentElement.setAttribute(`${style2.svgAttr}-opacity`, `${opacity}`);
          } else {
            let attr = style2.svgAttr;
            if (keys2[i2] === "globalAlpha") {
              attr = `${type}-${style2.svgAttr}`;
              if (currentElement.getAttribute(attr)) {
                continue;
              }
            }
            currentElement.setAttribute(attr, `${value}`);
          }
        }
      }
    }
  }
  get_serialized_svg(fixNamedEntities = false) {
    let serialized = new XMLSerializer().serializeToString(this.__root);
    if (fixNamedEntities) {
      for (const [key, value] of namedEntities) {
        const regexp = new RegExp(key, "gi");
        if (regexp.test(serialized)) {
          serialized = serialized.replace(regexp, value);
        }
      }
    }
    return serialized;
  }
  get_svg() {
    return this.__root;
  }
  save() {
    this.__stack.push({
      transform: this._transform,
      clip_path: this._clip_path,
      attributes: this.__getStyleState()
    });
    this._transform = this._transform.clone();
  }
  restore() {
    if (this.__stack.length == 0)
      return;
    const { transform: transform2, clip_path, attributes } = this.__stack.pop();
    this._transform = transform2;
    this._clip_path = clip_path;
    this.__applyStyleState(attributes);
  }
  _apply_transform(element, transform2 = this._transform) {
    if (!transform2.is_identity) {
      element.setAttribute("transform", transform2.toString());
    }
  }
  scale(x2, y2) {
    if (!isFinite(x2) || y2 != null && !isFinite(y2))
      return;
    this._transform.scale(x2, y2 != null ? y2 : x2);
  }
  rotate(angle) {
    if (!isFinite(angle))
      return;
    this._transform.rotate(angle);
  }
  translate(x2, y2) {
    if (!isFinite(x2 + y2))
      return;
    this._transform.translate(x2, y2);
  }
  transform(a2, b, c, d, e, f) {
    if (!isFinite(a2 + b + c + d + e + f))
      return;
    this._transform.transform(a2, b, c, d, e, f);
  }
  beginPath() {
    this.__currentDefaultPath = "";
    this.__currentPosition = null;
    this.__init_element();
  }
  __init_element() {
    const path = this.__createElement("path", {}, true);
    this.__root.appendChild(path);
    this.__currentElement = path;
  }
  __applyCurrentDefaultPath() {
    const currentElement = this.__currentElement;
    if (currentElement.nodeName === "path") {
      currentElement.setAttribute("d", this.__currentDefaultPath);
    } else {
      console.error("Attempted to apply path command to node", currentElement.nodeName);
    }
  }
  __addPathCommand(x2, y2, path) {
    const separator = !this.__currentDefaultPath ? "" : " ";
    this.__currentDefaultPath += separator + path;
    this.__currentPosition = { x: x2, y: y2 };
  }
  get _hasCurrentDefaultPath() {
    return !!this.__currentDefaultPath;
  }
  moveTo(x2, y2) {
    if (!isFinite(x2 + y2))
      return;
    const el = this.__currentElement;
    if (!el || el.nodeName !== "path") {
      this.beginPath();
    }
    const [tx, ty] = this._transform.apply(x2, y2);
    this.__addPathCommand(tx, ty, `M ${tx} ${ty}`);
  }
  closePath() {
    if (this._hasCurrentDefaultPath) {
      this.__addPathCommand(NaN, NaN, "Z");
    }
  }
  lineTo(x2, y2) {
    if (!isFinite(x2 + y2))
      return;
    if (!this._hasCurrentDefaultPath)
      this.moveTo(x2, y2);
    else {
      const [tx, ty] = this._transform.apply(x2, y2);
      this.__addPathCommand(tx, ty, `L ${tx} ${ty}`);
    }
  }
  bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x2, y2) {
    if (!isFinite(cp1x + cp1y + cp2x + cp2y + x2 + y2))
      return;
    const [tx, ty] = this._transform.apply(x2, y2);
    const [tcp1x, tcp1y] = this._transform.apply(cp1x, cp1y);
    const [tcp2x, tcp2y] = this._transform.apply(cp2x, cp2y);
    this.__addPathCommand(tx, ty, `C ${tcp1x} ${tcp1y} ${tcp2x} ${tcp2y} ${tx} ${ty}`);
  }
  quadraticCurveTo(cpx, cpy, x2, y2) {
    if (!isFinite(cpx + cpy + x2 + y2))
      return;
    const [tx, ty] = this._transform.apply(x2, y2);
    const [tcpx, tcpy] = this._transform.apply(cpx, cpy);
    this.__addPathCommand(tx, ty, `Q ${tcpx} ${tcpy} ${tx} ${ty}`);
  }
  arcTo(x1, y1, x2, y2, radius) {
    if (!isFinite(x1 + y1 + x2 + y2 + radius))
      return;
    if (this.__currentPosition == null)
      return;
    const x0 = this.__currentPosition.x;
    const y0 = this.__currentPosition.y;
    if (radius < 0) {
      throw new Error(`IndexSizeError: The radius provided (${radius}) is negative.`);
    }
    if (x0 === x1 && y0 === y1 || x1 === x2 && y1 === y2 || radius === 0) {
      this.lineTo(x1, y1);
      return;
    }
    function normalize([x4, y4]) {
      const len = Math.sqrt(x4 ** 2 + y4 ** 2);
      return [x4 / len, y4 / len];
    }
    const unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
    const unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);
    if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
      this.lineTo(x1, y1);
      return;
    }
    const cos2 = unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1];
    const theta = Math.acos(Math.abs(cos2));
    const unit_vec_p1_origin = normalize([
      unit_vec_p1_p0[0] + unit_vec_p1_p2[0],
      unit_vec_p1_p0[1] + unit_vec_p1_p2[1]
    ]);
    const len_p1_origin = radius / Math.sin(theta / 2);
    const x3 = x1 + len_p1_origin * unit_vec_p1_origin[0];
    const y3 = y1 + len_p1_origin * unit_vec_p1_origin[1];
    const unit_vec_origin_start_tangent = [
      -unit_vec_p1_p0[1],
      unit_vec_p1_p0[0]
    ];
    const unit_vec_origin_end_tangent = [
      unit_vec_p1_p2[1],
      -unit_vec_p1_p2[0]
    ];
    function getAngle(vector) {
      const x4 = vector[0];
      const y4 = vector[1];
      if (y4 >= 0) {
        return Math.acos(x4);
      } else {
        return -Math.acos(x4);
      }
    }
    const startAngle = getAngle(unit_vec_origin_start_tangent);
    const endAngle = getAngle(unit_vec_origin_end_tangent);
    this.lineTo(x3 + unit_vec_origin_start_tangent[0] * radius, y3 + unit_vec_origin_start_tangent[1] * radius);
    this.arc(x3, y3, radius, startAngle, endAngle);
  }
  stroke() {
    if (this.__currentElement.nodeName === "path") {
      this.__currentElement.setAttribute("paint-order", "fill");
    }
    this.__applyCurrentDefaultPath();
    this.__applyStyleToCurrentElement("stroke");
    if (this._clip_path != null) {
      this.__currentElement.setAttribute("clip-path", this._clip_path);
    }
  }
  fill(path_or_fill_rule, fill_rule) {
    let path = null;
    if (path_or_fill_rule instanceof Path2D)
      path = path_or_fill_rule;
    else if ((path_or_fill_rule == "evenodd" || path_or_fill_rule == "nonzero" || path_or_fill_rule == null) && fill_rule == null)
      fill_rule = path_or_fill_rule;
    else
      throw new Error("invalid arguments");
    if (path != null)
      throw new Error("not implemented");
    if (this.__currentElement.getAttribute("fill") != "none") {
      this.__init_element();
    }
    if (this.__currentElement.nodeName === "path") {
      this.__currentElement.setAttribute("paint-order", "stroke");
    }
    this.__applyCurrentDefaultPath();
    this.__applyStyleToCurrentElement("fill");
    if (fill_rule != null) {
      this.__currentElement.setAttribute("fill-rule", fill_rule);
    }
    if (this._clip_path != null) {
      this.__currentElement.setAttribute("clip-path", this._clip_path);
    }
  }
  rect(x2, y2, width, height) {
    if (!isFinite(x2 + y2 + width + height))
      return;
    this.moveTo(x2, y2);
    this.lineTo(x2 + width, y2);
    this.lineTo(x2 + width, y2 + height);
    this.lineTo(x2, y2 + height);
    this.lineTo(x2, y2);
  }
  fillRect(x2, y2, width, height) {
    if (!isFinite(x2 + y2 + width + height))
      return;
    this.beginPath();
    this.rect(x2, y2, width, height);
    this.fill();
  }
  strokeRect(x2, y2, width, height) {
    if (!isFinite(x2 + y2 + width + height))
      return;
    this.beginPath();
    this.rect(x2, y2, width, height);
    this.stroke();
  }
  __clearCanvas() {
    empty$1(this.__defs);
    empty$1(this.__root);
    this.__root.appendChild(this.__defs);
    this.__currentElement = this.__root;
  }
  clearRect(x2, y2, width, height) {
    if (!isFinite(x2 + y2 + width + height))
      return;
    if (x2 === 0 && y2 === 0 && width === this.width && height === this.height) {
      this.__clearCanvas();
      return;
    }
    const rect2 = this.__createElement("rect", { x: x2, y: y2, width, height, fill: "#FFFFFF" }, true);
    this._apply_transform(rect2);
    this.__root.appendChild(rect2);
  }
  createLinearGradient(x1, y1, x2, y2) {
    if (!isFinite(x1 + y1 + x2 + y2))
      throw new Error("The provided double value is non-finite");
    const [tx1, ty1] = this._transform.apply(x1, y1);
    const [tx2, ty2] = this._transform.apply(x2, y2);
    const grad = this.__createElement("linearGradient", {
      id: this._random_string(),
      x1: `${tx1}px`,
      x2: `${tx2}px`,
      y1: `${ty1}px`,
      y2: `${ty2}px`,
      gradientUnits: "userSpaceOnUse"
    }, false);
    this.__defs.appendChild(grad);
    return new CanvasGradient(grad, this);
  }
  createRadialGradient(x0, y0, r0, x1, y1, r1) {
    if (!isFinite(x0 + y0 + r0 + x1 + y1 + r1))
      throw new Error("The provided double value is non-finite");
    const [tx0, ty0] = this._transform.apply(x0, y0);
    const [tx1, ty1] = this._transform.apply(x1, y1);
    const grad = this.__createElement("radialGradient", {
      id: this._random_string(),
      cx: `${tx1}px`,
      cy: `${ty1}px`,
      r: `${r1}px`,
      r0: `${r0}px`,
      fx: `${tx0}px`,
      fy: `${ty0}px`,
      gradientUnits: "userSpaceOnUse"
    }, false);
    this.__defs.appendChild(grad);
    return new CanvasGradient(grad, this);
  }
  __parseFont() {
    var _a2, _b2, _c2, _d2, _e2;
    const regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
    const fontPart = regex.exec(this.font);
    const data2 = {
      style: (_a2 = fontPart[1]) != null ? _a2 : "normal",
      size: (_b2 = fontPart[4]) != null ? _b2 : "10px",
      family: (_c2 = fontPart[6]) != null ? _c2 : "sans-serif",
      weight: (_d2 = fontPart[3]) != null ? _d2 : "normal",
      decoration: (_e2 = fontPart[2]) != null ? _e2 : "normal"
    };
    return data2;
  }
  __applyText(text, x2, y2, action) {
    const font = this.__parseFont();
    const text_el = this.__createElement("text", {
      "font-family": font.family,
      "font-size": font.size,
      "font-style": font.style,
      "font-weight": font.weight,
      "text-decoration": font.decoration,
      x: x2,
      y: y2,
      "text-anchor": getTextAnchor(this.textAlign),
      "dominant-baseline": getDominantBaseline(this.textBaseline)
    }, true);
    text_el.appendChild(this.__document.createTextNode(text));
    this._apply_transform(text_el);
    this.__currentElement = text_el;
    this.__applyStyleToCurrentElement(action);
    const el = (() => {
      if (this._clip_path != null) {
        const g = this.__createElement("g");
        g.setAttribute("clip-path", this._clip_path);
        g.appendChild(text_el);
        return g;
      } else
        return text_el;
    })();
    this.__root.appendChild(el);
  }
  fillText(text, x2, y2) {
    if (text == null || !isFinite(x2 + y2))
      return;
    this.__applyText(text, x2, y2, "fill");
  }
  strokeText(text, x2, y2) {
    if (text == null || !isFinite(x2 + y2))
      return;
    this.__applyText(text, x2, y2, "stroke");
  }
  measureText(text) {
    this.__ctx.font = this.font;
    return this.__ctx.measureText(text);
  }
  arc(x2, y2, radius, start_angle, end_angle, counterclockwise = false) {
    this.ellipse(x2, y2, radius, radius, 0, start_angle, end_angle, counterclockwise);
  }
  ellipse(x2, y2, radius_x, radius_y, rotation, start_angle, end_angle, counterclockwise = false) {
    if (!isFinite(x2 + y2 + radius_x + radius_y + rotation + start_angle + end_angle))
      return;
    if (radius_x < 0 || radius_y < 0)
      throw new DOMException("IndexSizeError, radius can't be negative");
    const initial_diff = counterclockwise ? end_angle - start_angle : start_angle - end_angle;
    start_angle = start_angle % (2 * Math.PI);
    end_angle = end_angle % (2 * Math.PI);
    const start_x = x2 + radius_x * Math.cos(start_angle);
    const start_y = y2 + radius_y * Math.sin(start_angle);
    this.lineTo(start_x, start_y);
    const rotation_in_degrees = rotation * 180 / Math.PI;
    const sweep_flag = counterclockwise ? 0 : 1;
    if (Math.abs(start_angle - end_angle) < 2 * float32_epsilon && !(Math.abs(initial_diff) < 2 * float32_epsilon && initial_diff < 0)) {
      const mid_x = x2 + radius_x * Math.cos(start_angle + Math.PI);
      const mid_y = y2 + radius_y * Math.sin(start_angle + Math.PI);
      const [tstart_x, tstart_y] = this._transform.apply(start_x, start_y);
      const [tmid_x, tmid_y] = this._transform.apply(mid_x, mid_y);
      this.__addPathCommand(tstart_x, tstart_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tmid_x} ${tmid_y} A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tstart_x} ${tstart_y}`);
    } else {
      const end_x = x2 + radius_x * Math.cos(end_angle);
      const end_y = y2 + radius_y * Math.sin(end_angle);
      let diff = end_angle - start_angle;
      if (diff < 0) {
        diff += 2 * Math.PI;
      }
      const large_arc_flag = counterclockwise !== diff > Math.PI ? 1 : 0;
      const [tend_x, tend_y] = this._transform.apply(end_x, end_y);
      this.__addPathCommand(tend_x, tend_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} ${large_arc_flag} ${sweep_flag} ${tend_x} ${tend_y}`);
    }
  }
  clip() {
    const clip_path = this.__createElement("clipPath");
    const id = this._random_string();
    this.__applyCurrentDefaultPath();
    clip_path.setAttribute("id", id);
    clip_path.appendChild(this.__currentElement);
    this.__defs.appendChild(clip_path);
    this._clip_path = `url(#${id})`;
  }
  drawImage(image, ...args) {
    let dx, dy;
    let dw, dh;
    let sx, sy;
    let sw, sh;
    if (args.length == 2) {
      [dx, dy] = args;
      if (!isFinite(dx + dy))
        return;
      sx = 0;
      sy = 0;
      sw = image.width;
      sh = image.height;
      dw = sw;
      dh = sh;
    } else if (args.length == 4) {
      [dx, dy, dw, dh] = args;
      if (!isFinite(dx + dy + dw + dh))
        return;
      sx = 0;
      sy = 0;
      sw = image.width;
      sh = image.height;
    } else if (args.length === 8) {
      [sx, sy, sw, sh, dx, dy, dw, dh] = args;
      if (!isFinite(sx + sy + sw + sh + dx + dy + dw + dh))
        return;
    } else {
      throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);
    }
    const parent = this.__root;
    const transform2 = this._transform.clone().translate(dx, dy);
    if (image instanceof SVGRenderingContext2D || image instanceof SVGSVGElement) {
      const svg_node = image instanceof SVGSVGElement ? image : image.get_svg();
      const svg2 = svg_node.cloneNode(true);
      let scope;
      if (transform2.is_identity && this.globalAlpha == 1 && this._clip_path == null)
        scope = parent;
      else {
        scope = this.__createElement("g");
        if (!transform2.is_identity)
          this._apply_transform(scope, transform2);
        if (this.globalAlpha != 1)
          scope.setAttribute("opacity", `${this.globalAlpha}`);
        if (this._clip_path != null)
          scope.setAttribute("clip-path", this._clip_path);
        parent.appendChild(scope);
      }
      for (const child of [...svg2.childNodes]) {
        if (child instanceof SVGDefsElement) {
          for (const def of [...child.childNodes]) {
            if (def instanceof Element) {
              const id = def.getAttribute("id");
              this.__ids.add(id);
              this.__defs.appendChild(def.cloneNode(true));
            }
          }
        } else {
          scope.appendChild(child.cloneNode(true));
        }
      }
    } else if (image instanceof HTMLImageElement || image instanceof SVGImageElement) {
      const svgImage = this.__createElement("image");
      svgImage.setAttribute("width", `${dw}`);
      svgImage.setAttribute("height", `${dh}`);
      svgImage.setAttribute("preserveAspectRatio", "none");
      if (this.globalAlpha != 1)
        svgImage.setAttribute("opacity", `${this.globalAlpha}`);
      if (sx || sy || sw !== image.width || sh !== image.height) {
        const canvas2 = this.__document.createElement("canvas");
        canvas2.width = dw;
        canvas2.height = dh;
        const context = canvas2.getContext("2d");
        context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
        image = canvas2;
      }
      this._apply_transform(svgImage, transform2);
      const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
      svgImage.setAttribute("href", url);
      if (this._clip_path != null) {
        const scope = this.__createElement("g");
        scope.setAttribute("clip-path", this._clip_path);
        scope.appendChild(svgImage);
        parent.appendChild(scope);
      } else
        parent.appendChild(svgImage);
    } else if (image instanceof HTMLCanvasElement) {
      const svgImage = this.__createElement("image");
      svgImage.setAttribute("width", `${dw}`);
      svgImage.setAttribute("height", `${dh}`);
      svgImage.setAttribute("preserveAspectRatio", "none");
      if (this.globalAlpha != 1)
        svgImage.setAttribute("opacity", `${this.globalAlpha}`);
      const canvas2 = this.__document.createElement("canvas");
      canvas2.width = dw;
      canvas2.height = dh;
      const context = canvas2.getContext("2d");
      context.imageSmoothingEnabled = false;
      context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
      image = canvas2;
      this._apply_transform(svgImage, transform2);
      svgImage.setAttribute("href", image.toDataURL());
      if (this._clip_path != null) {
        const scope = this.__createElement("g");
        scope.setAttribute("clip-path", this._clip_path);
        scope.appendChild(svgImage);
        parent.appendChild(scope);
      } else
        parent.appendChild(svgImage);
    }
  }
  createPattern(image, _repetition) {
    const pattern = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern");
    const id = this._random_string();
    pattern.setAttribute("id", id);
    pattern.setAttribute("width", `${this._to_number(image.width)}`);
    pattern.setAttribute("height", `${this._to_number(image.height)}`);
    pattern.setAttribute("patternUnits", "userSpaceOnUse");
    if (image instanceof HTMLCanvasElement || image instanceof HTMLImageElement || image instanceof SVGImageElement) {
      const img = this.__document.createElementNS("http://www.w3.org/2000/svg", "image");
      const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
      img.setAttribute("href", url);
      pattern.appendChild(img);
      this.__defs.appendChild(pattern);
    } else if (image instanceof SVGRenderingContext2D) {
      for (const child of [...image.__root.childNodes]) {
        if (!(child instanceof SVGDefsElement)) {
          pattern.appendChild(child.cloneNode(true));
        }
      }
      this.__defs.appendChild(pattern);
    } else if (image instanceof SVGSVGElement) {
      for (const child of [...image.childNodes]) {
        if (!(child instanceof SVGDefsElement)) {
          pattern.appendChild(child.cloneNode(true));
        }
      }
      this.__defs.appendChild(pattern);
    } else {
      throw new Error("unsupported");
    }
    return new CanvasPattern(pattern, this);
  }
  getLineDash() {
    const { lineDash } = this;
    if (isString(lineDash))
      return lineDash.split(",").map((v) => parseInt(v));
    else if (lineDash == null)
      return [];
    else
      return lineDash;
  }
  setLineDash(segments) {
    if (segments && segments.length > 0)
      this.lineDash = segments.join(",");
    else
      this.lineDash = null;
  }
  _to_number(val) {
    return isNumber(val) ? val : val.baseVal.value;
  }
  getTransform() {
    return this._transform.to_DOMMatrix();
  }
  setTransform(...args) {
    let matrix;
    if (isNumber(args[0]))
      matrix = new DOMMatrix(args);
    else if (args[0] instanceof DOMMatrix)
      matrix = args[0];
    else
      matrix = new DOMMatrix(Object.values(!args[0]));
    this._transform = AffineTransform.from_DOMMatrix(matrix);
  }
  resetTransform() {
    this._transform = new AffineTransform();
  }
  isPointInPath(..._args) {
    throw new Error("not implemented");
  }
  isPointInStroke(..._args) {
    throw new Error("not implemented");
  }
  createImageData(..._args) {
    throw new Error("not implemented");
  }
  getImageData(_sx, _sy, _sw, _sh) {
    throw new Error("not implemented");
  }
  putImageData(..._args) {
    throw new Error("not implemented");
  }
  drawFocusIfNeeded(..._args) {
    throw new Error("not implemented");
  }
  scrollPathIntoView(..._args) {
    throw new Error("not implemented");
  }
}
SVGRenderingContext2D.__name__ = "SVGRenderingContext2D";
SVGRenderingContext2D.__random = random;
function fixup_line_dash(ctx) {
  if (typeof ctx.lineDash === "undefined") {
    Object.defineProperty(ctx, "lineDash", {
      get: () => ctx.getLineDash(),
      set: (segments) => ctx.setLineDash(segments)
    });
  }
}
function fixup_image_smoothing(ctx) {
  ctx.setImageSmoothingEnabled = (value) => {
    ctx.imageSmoothingEnabled = value;
    ctx.mozImageSmoothingEnabled = value;
    ctx.oImageSmoothingEnabled = value;
    ctx.webkitImageSmoothingEnabled = value;
    ctx.msImageSmoothingEnabled = value;
  };
  ctx.getImageSmoothingEnabled = () => {
    const val = ctx.imageSmoothingEnabled;
    return val != null ? val : true;
  };
}
function fixup_ellipse(ctx) {
  function ellipse_bezier(x2, y2, radiusX, radiusY, rotation, _startAngle, _endAngle, anticlockwise = false) {
    const c = 0.551784;
    ctx.translate(x2, y2);
    ctx.rotate(rotation);
    let rx = radiusX;
    let ry = radiusY;
    if (anticlockwise) {
      rx = -radiusX;
      ry = -radiusY;
    }
    ctx.moveTo(-rx, 0);
    ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
    ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
    ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
    ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
    ctx.rotate(-rotation);
    ctx.translate(-x2, -y2);
  }
  if (!ctx.ellipse)
    ctx.ellipse = ellipse_bezier;
}
function fixup_ctx(ctx) {
  fixup_line_dash(ctx);
  fixup_image_smoothing(ctx);
  fixup_ellipse(ctx);
}
const style$1 = {
  position: "absolute",
  top: "0",
  left: "0",
  width: "100%",
  height: "100%"
};
class CanvasLayer {
  constructor(backend, hidpi) {
    this.backend = backend;
    this.hidpi = hidpi;
    this.pixel_ratio = 1;
    this.bbox = new BBox$2();
    switch (backend) {
      case "webgl":
      case "canvas": {
        this._el = this._canvas = canvas({ style: style$1 });
        const ctx = this.canvas.getContext("2d");
        if (ctx == null)
          throw new Error("unable to obtain 2D rendering context");
        this._ctx = ctx;
        if (hidpi) {
          this.pixel_ratio = devicePixelRatio;
        }
        break;
      }
      case "svg": {
        const ctx = new SVGRenderingContext2D();
        this._ctx = ctx;
        this._canvas = ctx.get_svg();
        this._el = div({ style: style$1 }, this._canvas);
        break;
      }
    }
    this._ctx.layer = this;
    fixup_ctx(this._ctx);
  }
  get canvas() {
    return this._canvas;
  }
  get ctx() {
    return this._ctx;
  }
  get el() {
    return this._el;
  }
  resize(width, height) {
    this.bbox = new BBox$2({ left: 0, top: 0, width, height });
    const target = this._ctx instanceof SVGRenderingContext2D ? this._ctx : this.canvas;
    target.width = width * this.pixel_ratio;
    target.height = height * this.pixel_ratio;
  }
  undo_transform(fn) {
    const { ctx } = this;
    if (typeof ctx.getTransform === "undefined") {
      fn(ctx);
    } else {
      const current_transform = ctx.getTransform();
      ctx.setTransform(this._base_transform);
      try {
        fn(ctx);
      } finally {
        ctx.setTransform(current_transform);
      }
    }
  }
  prepare() {
    const { ctx, hidpi, pixel_ratio } = this;
    ctx.save();
    if (hidpi) {
      ctx.scale(pixel_ratio, pixel_ratio);
      ctx.translate(0.5, 0.5);
    }
    if (typeof ctx.getTransform !== "undefined") {
      this._base_transform = ctx.getTransform();
    }
    this.clear();
  }
  clear() {
    const { x: x2, y: y2, width, height } = this.bbox;
    this.ctx.clearRect(x2, y2, width, height);
  }
  finish() {
    this.ctx.restore();
  }
  to_blob() {
    const { _canvas } = this;
    if (_canvas instanceof HTMLCanvasElement) {
      if (_canvas.msToBlob != null) {
        return Promise.resolve(_canvas.msToBlob());
      } else {
        return new Promise((resolve, reject) => {
          _canvas.toBlob((blob) => blob != null ? resolve(blob) : reject(), "image/png");
        });
      }
    } else {
      const ctx = this._ctx;
      const svg2 = ctx.get_serialized_svg(true);
      const blob = new Blob([svg2], { type: "image/svg+xml" });
      return Promise.resolve(blob);
    }
  }
}
CanvasLayer.__name__ = "CanvasLayer";
class ActionToolButtonView extends ButtonToolButtonView {
  _clicked() {
    this.model.do.emit(void 0);
  }
}
ActionToolButtonView.__name__ = "ActionToolButtonView";
class ActionToolView extends ButtonToolView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.do, (arg) => this.doit(arg));
  }
}
ActionToolView.__name__ = "ActionToolView";
class ActionTool extends ButtonTool {
  constructor(attrs) {
    super(attrs);
    this.button_view = ActionToolButtonView;
    this.do = new Signal(this, "do");
  }
}
ActionTool.__name__ = "ActionTool";
var _a$2E;
class HelpToolView extends ActionToolView {
  doit() {
    window.open(this.model.redirect);
  }
}
HelpToolView.__name__ = "HelpToolView";
class HelpTool extends ActionTool {
  constructor(attrs) {
    super(attrs);
    this.tool_name = "Help";
    this.icon = tool_icon_help;
  }
}
_a$2E = HelpTool;
HelpTool.__name__ = "HelpTool";
(() => {
  _a$2E.prototype.default_view = HelpToolView;
  _a$2E.define(({ String: String2 }) => ({
    redirect: [String2, "https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]
  }));
  _a$2E.override({
    description: "Click the question mark to learn more about Bokeh plot tools."
  });
  _a$2E.register_alias("help", () => new HelpTool());
})();
const logo = "bk-logo";
const grey = "bk-grey";
const logo_small = "bk-logo-small";
var logo_css = `.bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}`;
var _a$2D, _b$6;
class ToolbarViewModel extends Model {
  constructor(attrs) {
    super(attrs);
  }
  get visible() {
    var _a2;
    return !this.autohide || ((_a2 = this._visible) != null ? _a2 : false);
  }
}
_a$2D = ToolbarViewModel;
ToolbarViewModel.__name__ = "ToolbarViewModel";
(() => {
  _a$2D.define(({ Boolean: Boolean2 }) => ({
    autohide: [Boolean2, false]
  }));
  _a$2D.internal(({ Boolean: Boolean2, Nullable: Nullable2 }) => ({
    _visible: [Nullable2(Boolean2), null]
  }));
})();
class ToolbarBaseView extends DOMView {
  constructor() {
    super(...arguments);
    this.layout = { bbox: new BBox$2() };
  }
  initialize() {
    super.initialize();
    this._tool_button_views = /* @__PURE__ */ new Map();
    this._toolbar_view_model = new ToolbarViewModel({ autohide: this.model.autohide });
    const { toolbar_location } = this.model;
    const reversed2 = toolbar_location == "left" || toolbar_location == "above";
    const orientation = this.model.horizontal ? "vertical" : "horizontal";
    this._overflow_menu = new ContextMenu([], {
      orientation,
      reversed: reversed2
    });
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    await this._build_tool_button_views();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.tools.change, async () => {
      await this._build_tool_button_views();
      this.render();
    });
    this.connect(this.model.properties.autohide.change, () => {
      this._toolbar_view_model.autohide = this.model.autohide;
      this._on_visible_change();
    });
    this.connect(this._toolbar_view_model.properties._visible.change, () => this._on_visible_change());
  }
  styles() {
    return [...super.styles(), toolbars_css, logo_css];
  }
  remove() {
    remove_views(this._tool_button_views);
    super.remove();
  }
  async _build_tool_button_views() {
    const tools = this.model._proxied_tools != null ? this.model._proxied_tools : this.model.tools;
    await build_views(this._tool_button_views, tools, { parent: this }, (tool) => tool.button_view);
  }
  set_visibility(visible) {
    if (visible != this._toolbar_view_model._visible) {
      this._toolbar_view_model._visible = visible;
    }
  }
  _on_visible_change() {
    const { visible } = this._toolbar_view_model;
    classes(this.el).toggle(toolbar_hidden, !visible);
  }
  render() {
    empty$1(this.el);
    this.el.classList.add(toolbar);
    this.el.classList.add(toolbars[this.model.toolbar_location]);
    this._toolbar_view_model.autohide = this.model.autohide;
    this._on_visible_change();
    const { horizontal: horizontal2 } = this.model;
    let size2 = 0;
    if (this.model.logo != null) {
      const gray = this.model.logo === "grey" ? grey : null;
      const logo_el = a({ href: "https://bokeh.org/", target: "_blank", class: [logo, logo_small, gray] });
      this.el.appendChild(logo_el);
      const { width, height } = logo_el.getBoundingClientRect();
      size2 += horizontal2 ? width : height;
    }
    for (const [, button_view] of this._tool_button_views) {
      button_view.render();
    }
    const bars = [];
    const el = (tool) => {
      return this._tool_button_views.get(tool).el;
    };
    const { gestures } = this.model;
    for (const gesture of values(gestures)) {
      bars.push(gesture.tools.map(el));
    }
    bars.push(this.model.actions.map(el));
    bars.push(this.model.inspectors.filter((tool) => tool.toggleable).map(el));
    const non_empty = bars.filter((bar) => bar.length != 0);
    const divider2 = () => div({ class: divider$1 });
    const { bbox } = this.layout;
    let overflowed = false;
    const overflow_size = 15;
    this.root.el.appendChild(this._overflow_menu.el);
    const overflow_button = div({ class: tool_overflow, tabIndex: 0 }, horizontal2 ? "\u22EE" : "\u22EF");
    const toggle_menu = () => {
      const at = (() => {
        switch (this.model.toolbar_location) {
          case "right":
            return { left_of: overflow_button };
          case "left":
            return { right_of: overflow_button };
          case "above":
            return { below: overflow_button };
          case "below":
            return { above: overflow_button };
        }
      })();
      this._overflow_menu.toggle(at);
    };
    overflow_button.addEventListener("click", () => {
      toggle_menu();
    });
    overflow_button.addEventListener("keydown", (event2) => {
      if (event2.keyCode == Keys.Enter) {
        toggle_menu();
      }
    });
    for (const el2 of join(non_empty, divider2)) {
      if (overflowed) {
        this._overflow_menu.items.push({ content: el2, class: horizontal2 ? right$2 : above$2 });
      } else {
        this.el.appendChild(el2);
        const { width, height } = el2.getBoundingClientRect();
        size2 += horizontal2 ? width : height;
        overflowed = horizontal2 ? size2 > bbox.width - overflow_size : size2 > bbox.height - overflow_size;
        if (overflowed) {
          this.el.removeChild(el2);
          this.el.appendChild(overflow_button);
          const { items } = this._overflow_menu;
          items.splice(0, items.length);
          items.push({ content: el2 });
        }
      }
    }
  }
  update_layout() {
  }
  update_position() {
  }
  after_layout() {
    this._has_finished = true;
  }
  export(type, hidpi = true) {
    const output_backend = type == "png" ? "canvas" : "svg";
    const canvas2 = new CanvasLayer(output_backend, hidpi);
    canvas2.resize(0, 0);
    return canvas2;
  }
}
ToolbarBaseView.__name__ = "ToolbarBaseView";
function create_gesture_map() {
  return {
    pan: { tools: [], active: null },
    scroll: { tools: [], active: null },
    pinch: { tools: [], active: null },
    tap: { tools: [], active: null },
    doubletap: { tools: [], active: null },
    press: { tools: [], active: null },
    pressup: { tools: [], active: null },
    rotate: { tools: [], active: null },
    move: { tools: [], active: null },
    multi: { tools: [], active: null }
  };
}
class ToolbarBase extends Model {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this._init_tools();
  }
  _init_tools() {
    const tools_changed = function(old_tools, new_tools) {
      if (old_tools.length != new_tools.length) {
        return true;
      }
      const new_ids = new Set(new_tools.map((t) => t.id));
      return some(old_tools, (t) => !new_ids.has(t.id));
    };
    const new_inspectors = this.tools.filter((t) => t instanceof InspectTool);
    if (tools_changed(this.inspectors, new_inspectors)) {
      this.inspectors = new_inspectors;
    }
    const new_help = this.tools.filter((t) => t instanceof HelpTool);
    if (tools_changed(this.help, new_help)) {
      this.help = new_help;
    }
    const new_actions = this.tools.filter((t) => t instanceof ActionTool);
    if (tools_changed(this.actions, new_actions)) {
      this.actions = new_actions;
    }
    const check_event_type = (et, tool) => {
      if (!(et in this.gestures)) {
        logger.warn(`Toolbar: unknown event type '${et}' for tool: ${tool}`);
      }
    };
    const new_gestures = create_gesture_map();
    for (const tool of this.tools) {
      if (tool instanceof GestureTool && tool.event_type) {
        if (isString(tool.event_type)) {
          new_gestures[tool.event_type].tools.push(tool);
          check_event_type(tool.event_type, tool);
        } else {
          new_gestures.multi.tools.push(tool);
          for (const et of tool.event_type) {
            check_event_type(et, tool);
          }
        }
      }
    }
    for (const et of Object.keys(new_gestures)) {
      const gm = this.gestures[et];
      if (tools_changed(gm.tools, new_gestures[et].tools)) {
        gm.tools = new_gestures[et].tools;
      }
      if (gm.active && every(gm.tools, (t) => t.id != gm.active.id)) {
        gm.active = null;
      }
    }
  }
  get horizontal() {
    return this.toolbar_location === "above" || this.toolbar_location === "below";
  }
  get vertical() {
    return this.toolbar_location === "left" || this.toolbar_location === "right";
  }
  _active_change(tool) {
    const { event_type } = tool;
    if (event_type == null)
      return;
    const event_types = isString(event_type) ? [event_type] : event_type;
    for (const et of event_types) {
      if (tool.active) {
        const currently_active_tool = this.gestures[et].active;
        if (currently_active_tool != null && tool != currently_active_tool) {
          logger.debug(`Toolbar: deactivating tool: ${currently_active_tool} for event type '${et}'`);
          currently_active_tool.active = false;
        }
        this.gestures[et].active = tool;
        logger.debug(`Toolbar: activating tool: ${tool} for event type '${et}'`);
      } else
        this.gestures[et].active = null;
    }
  }
}
_b$6 = ToolbarBase;
ToolbarBase.__name__ = "ToolbarBase";
(() => {
  _b$6.prototype.default_view = ToolbarBaseView;
  _b$6.define(({ Boolean: Boolean2, Array: Array2, Ref: Ref2, Nullable: Nullable2 }) => ({
    tools: [Array2(Ref2(Tool)), []],
    logo: [Nullable2(Logo), "normal"],
    autohide: [Boolean2, false]
  }));
  _b$6.internal(({ Array: Array2, Struct: Struct2, Ref: Ref2, Nullable: Nullable2 }) => {
    const GestureEntry = Struct2({
      tools: Array2(Ref2(GestureTool)),
      active: Nullable2(Ref2(Tool))
    });
    const GestureMap = Struct2({
      pan: GestureEntry,
      scroll: GestureEntry,
      pinch: GestureEntry,
      tap: GestureEntry,
      doubletap: GestureEntry,
      press: GestureEntry,
      pressup: GestureEntry,
      rotate: GestureEntry,
      move: GestureEntry,
      multi: GestureEntry
    });
    return {
      gestures: [GestureMap, create_gesture_map],
      actions: [Array2(Ref2(ActionTool)), []],
      inspectors: [Array2(Ref2(InspectTool)), []],
      help: [Array2(Ref2(HelpTool)), []],
      toolbar_location: [Location, "right"]
    };
  });
})();
var _a$2C;
const Drag = Tool;
const Inspection = Tool;
const Scroll = Tool;
const Tap$1 = Tool;
function _get_active_attr(et) {
  switch (et) {
    case "tap":
      return "active_tap";
    case "pan":
      return "active_drag";
    case "pinch":
    case "scroll":
      return "active_scroll";
    case "multi":
      return "active_multi";
  }
  return null;
}
function _supports_auto(et) {
  return et == "tap" || et == "pan";
}
class Toolbar extends ToolbarBase {
  constructor(attrs) {
    super(attrs);
  }
  connect_signals() {
    super.connect_signals();
    const { tools, active_drag, active_inspect, active_scroll, active_tap, active_multi } = this.properties;
    this.on_change([tools, active_drag, active_inspect, active_scroll, active_tap, active_multi], () => this._init_tools());
  }
  _init_tools() {
    super._init_tools();
    if (this.active_inspect == "auto")
      ;
    else if (this.active_inspect instanceof InspectTool) {
      let found = false;
      for (const inspector of this.inspectors) {
        if (inspector != this.active_inspect)
          inspector.active = false;
        else
          found = true;
      }
      if (!found) {
        this.active_inspect = null;
      }
    } else if (isArray(this.active_inspect)) {
      const active_inspect = intersection(this.active_inspect, this.inspectors);
      if (active_inspect.length != this.active_inspect.length) {
        this.active_inspect = active_inspect;
      }
      for (const inspector of this.inspectors) {
        if (!includes(this.active_inspect, inspector))
          inspector.active = false;
      }
    } else if (this.active_inspect == null) {
      for (const inspector of this.inspectors)
        inspector.active = false;
    }
    const _activate_gesture = (tool) => {
      if (tool.active) {
        this._active_change(tool);
      } else
        tool.active = true;
    };
    for (const gesture of values(this.gestures)) {
      gesture.tools = sort_by(gesture.tools, (tool) => tool.default_order);
      for (const tool of gesture.tools) {
        this.connect(tool.properties.active.change, () => this._active_change(tool));
      }
    }
    for (const [et, gesture] of entries(this.gestures)) {
      const active_attr = _get_active_attr(et);
      if (active_attr) {
        const active_tool = this[active_attr];
        if (active_tool == "auto") {
          if (gesture.tools.length != 0 && _supports_auto(et)) {
            _activate_gesture(gesture.tools[0]);
          }
        } else if (active_tool != null) {
          if (includes(this.tools, active_tool)) {
            _activate_gesture(active_tool);
          } else {
            this[active_attr] = null;
          }
        }
      }
    }
  }
}
_a$2C = Toolbar;
Toolbar.__name__ = "Toolbar";
(() => {
  _a$2C.prototype.default_view = ToolbarBaseView;
  _a$2C.define(({ Or: Or2, Ref: Ref2, Auto: Auto2, Null: Null2 }) => ({
    active_drag: [Or2(Ref2(Drag), Auto2, Null2), "auto"],
    active_inspect: [Or2(Ref2(Inspection), Auto2, Null2), "auto"],
    active_scroll: [Or2(Ref2(Scroll), Auto2, Null2), "auto"],
    active_tap: [Or2(Ref2(Tap$1), Auto2, Null2), "auto"],
    active_multi: [Or2(Ref2(GestureTool), Auto2, Null2), "auto"]
  }));
})();
var _a$2B;
class ToolbarPanelView extends AnnotationView {
  constructor() {
    super(...arguments);
    this._invalidate_toolbar = true;
    this._previous_bbox = new BBox$2();
  }
  update_layout() {
    this.layout = new SideLayout(this.panel, () => this.get_size(), true);
  }
  initialize() {
    super.initialize();
    this.el = div();
    this.plot_view.canvas_view.add_event(this.el);
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    this._toolbar_view = await build_view(this.model.toolbar, { parent: this });
    this.plot_view.visibility_callbacks.push((visible) => this._toolbar_view.set_visibility(visible));
  }
  remove() {
    this._toolbar_view.remove();
    remove(this.el);
    super.remove();
  }
  render() {
    if (!this.model.visible)
      undisplay(this.el);
    super.render();
  }
  _render() {
    const { bbox } = this.layout;
    if (!this._previous_bbox.equals(bbox)) {
      position(this.el, bbox);
      this._previous_bbox = bbox;
      this._invalidate_toolbar = true;
    }
    if (this._invalidate_toolbar) {
      this.el.style.position = "absolute";
      this.el.style.overflow = "hidden";
      empty$1(this.el);
      this.el.appendChild(this._toolbar_view.el);
      this._toolbar_view.layout.bbox = bbox;
      this._toolbar_view.render();
      this._invalidate_toolbar = false;
    }
    display(this.el);
  }
  _get_size() {
    const { tools, logo: logo2 } = this.model.toolbar;
    return {
      width: tools.length * 30 + (logo2 != null ? 25 : 0) + 15,
      height: 30
    };
  }
}
ToolbarPanelView.__name__ = "ToolbarPanelView";
class ToolbarPanel extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2B = ToolbarPanel;
ToolbarPanel.__name__ = "ToolbarPanel";
(() => {
  _a$2B.prototype.default_view = ToolbarPanelView;
  _a$2B.define(({ Ref: Ref2 }) => ({
    toolbar: [Ref2(Toolbar)]
  }));
})();
const tooltip = "bk-tooltip";
const left$1 = "bk-left";
const tooltip_arrow = "bk-tooltip-arrow";
const right$1 = "bk-right";
const above$1 = "bk-above";
const below$1 = "bk-below";
const tooltip_row_label = "bk-tooltip-row-label";
const tooltip_row_value = "bk-tooltip-row-value";
const tooltip_color_block = "bk-tooltip-color-block";
var tooltips_css = `.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}`;
var _a$2A;
const arrow_size = 10;
class TooltipView extends AnnotationView {
  initialize() {
    super.initialize();
    this.el = div({ class: tooltip });
    undisplay(this.el);
    this.plot_view.canvas_view.add_overlay(this.el);
  }
  remove() {
    remove(this.el);
    super.remove();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.content.change, () => this.render());
    this.connect(this.model.properties.position.change, () => this._reposition());
  }
  styles() {
    return [...super.styles(), tooltips_css];
  }
  render() {
    if (!this.model.visible)
      undisplay(this.el);
    super.render();
  }
  _render() {
    const { content } = this.model;
    if (content == null) {
      undisplay(this.el);
      return;
    }
    empty$1(this.el);
    classes(this.el).toggle("bk-tooltip-custom", this.model.custom);
    this.el.appendChild(content);
    if (this.model.show_arrow)
      this.el.classList.add(tooltip_arrow);
  }
  _reposition() {
    const { position: position2 } = this.model;
    if (position2 == null) {
      undisplay(this.el);
      return;
    }
    const [sx, sy] = position2;
    const side = (() => {
      const area = this.parent.layout.bbox.relative();
      const { attachment } = this.model;
      switch (attachment) {
        case "horizontal":
          return sx < area.hcenter ? "right" : "left";
        case "vertical":
          return sy < area.vcenter ? "below" : "above";
        default:
          return attachment;
      }
    })();
    this.el.classList.remove(right$1);
    this.el.classList.remove(left$1);
    this.el.classList.remove(above$1);
    this.el.classList.remove(below$1);
    display(this.el);
    let top;
    let left2 = null;
    let right2 = null;
    switch (side) {
      case "right":
        this.el.classList.add(left$1);
        left2 = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
        top = sy - this.el.offsetHeight / 2;
        break;
      case "left":
        this.el.classList.add(right$1);
        right2 = this.plot_view.layout.bbox.width - sx + arrow_size;
        top = sy - this.el.offsetHeight / 2;
        break;
      case "below":
        this.el.classList.add(above$1);
        top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
        left2 = Math.round(sx - this.el.offsetWidth / 2);
        break;
      case "above":
        this.el.classList.add(below$1);
        top = sy - this.el.offsetHeight - arrow_size;
        left2 = Math.round(sx - this.el.offsetWidth / 2);
        break;
    }
    this.el.style.top = `${top}px`;
    this.el.style.left = left2 != null ? `${left2}px` : "auto";
    this.el.style.right = right2 != null ? `${right2}px` : "auto";
  }
}
TooltipView.__name__ = "TooltipView";
class Tooltip extends Annotation {
  constructor(attrs) {
    super(attrs);
  }
  clear() {
    this.position = null;
  }
}
_a$2A = Tooltip;
Tooltip.__name__ = "Tooltip";
(() => {
  _a$2A.prototype.default_view = TooltipView;
  _a$2A.define(({ Boolean: Boolean2 }) => ({
    attachment: [TooltipAttachment, "horizontal"],
    inner_only: [Boolean2, true],
    show_arrow: [Boolean2, true]
  }));
  _a$2A.internal(({ Boolean: Boolean2, Number: Number2, Tuple: Tuple2, Ref: Ref2, Nullable: Nullable2 }) => ({
    position: [Nullable2(Tuple2(Number2, Number2)), null],
    content: [Ref2(HTMLElement), () => div()],
    custom: [Boolean2]
  }));
  _a$2A.override({
    level: "overlay"
  });
})();
var _a$2z;
class WhiskerView extends UpperLowerView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { lower_head, upper_head } = this.model;
    if (lower_head != null)
      this.lower_head = await build_view(lower_head, { parent: this });
    if (upper_head != null)
      this.upper_head = await build_view(upper_head, { parent: this });
  }
  set_data(source) {
    var _a2, _b2;
    super.set_data(source);
    (_a2 = this.lower_head) == null ? void 0 : _a2.set_data(source);
    (_b2 = this.upper_head) == null ? void 0 : _b2.set_data(source);
  }
  paint(ctx) {
    if (this.visuals.line.doit) {
      for (let i2 = 0, end = this._lower_sx.length; i2 < end; i2++) {
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.beginPath();
        ctx.moveTo(this._lower_sx[i2], this._lower_sy[i2]);
        ctx.lineTo(this._upper_sx[i2], this._upper_sy[i2]);
        ctx.stroke();
      }
    }
    const angle = this.model.dimension == "height" ? 0 : Math.PI / 2;
    if (this.lower_head != null) {
      for (let i2 = 0, end = this._lower_sx.length; i2 < end; i2++) {
        ctx.save();
        ctx.translate(this._lower_sx[i2], this._lower_sy[i2]);
        ctx.rotate(angle + Math.PI);
        this.lower_head.render(ctx, i2);
        ctx.restore();
      }
    }
    if (this.upper_head != null) {
      for (let i2 = 0, end = this._upper_sx.length; i2 < end; i2++) {
        ctx.save();
        ctx.translate(this._upper_sx[i2], this._upper_sy[i2]);
        ctx.rotate(angle);
        this.upper_head.render(ctx, i2);
        ctx.restore();
      }
    }
  }
}
WhiskerView.__name__ = "WhiskerView";
class Whisker extends UpperLower {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2z = Whisker;
Whisker.__name__ = "Whisker";
(() => {
  _a$2z.prototype.default_view = WhiskerView;
  _a$2z.mixins(LineVector$1);
  _a$2z.define(({ Ref: Ref2, Nullable: Nullable2 }) => ({
    lower_head: [Nullable2(Ref2(ArrowHead)), () => new TeeHead({ size: 10 })],
    upper_head: [Nullable2(Ref2(ArrowHead)), () => new TeeHead({ size: 10 })]
  }));
  _a$2z.override({
    level: "underlay"
  });
})();
class Callback extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
Callback.__name__ = "Callback";
var _a$2y;
class CustomJS extends Callback {
  constructor(attrs) {
    super(attrs);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const code = use_strict(this.code);
    return new Function(...this.names, "cb_obj", "cb_data", code);
  }
  execute(cb_obj, cb_data = {}) {
    return this.func.apply(cb_obj, this.values.concat(cb_obj, cb_data));
  }
}
_a$2y = CustomJS;
CustomJS.__name__ = "CustomJS";
(() => {
  _a$2y.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    code: [String2, ""]
  }));
})();
var _a$2x;
class OpenURL extends Callback {
  constructor(attrs) {
    super(attrs);
  }
  navigate(url) {
    if (this.same_tab)
      window.location.href = url;
    else
      window.open(url);
  }
  execute(_cb_obj, { source }) {
    const open_url = (i2) => {
      const url = replace_placeholders(this.url, source, i2, void 0, void 0, encodeURI);
      if (!isString(url))
        throw new Error("HTML output is not supported in this context");
      this.navigate(url);
    };
    const { selected } = source;
    for (const i2 of selected.indices)
      open_url(i2);
    for (const i2 of selected.line_indices)
      open_url(i2);
  }
}
_a$2x = OpenURL;
OpenURL.__name__ = "OpenURL";
(() => {
  _a$2x.define(({ Boolean: Boolean2, String: String2 }) => ({
    url: [String2, "http://"],
    same_tab: [Boolean2, false]
  }));
})();
var __decorate = globalThis && globalThis.__decorate || function(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
    r = Reflect.decorate(decorators, target, key, desc);
  else
    for (var i2 = decorators.length - 1; i2 >= 0; i2--)
      if (d = decorators[i2])
        r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};
function event(event_name) {
  return function(cls) {
    cls.prototype.event_name = event_name;
  };
}
class BokehEvent {
  to_json() {
    const { event_name } = this;
    return { event_name, event_values: this._to_json() };
  }
}
BokehEvent.__name__ = "BokehEvent";
class ModelEvent extends BokehEvent {
  constructor() {
    super(...arguments);
    this.origin = null;
  }
  _to_json() {
    return { model: this.origin };
  }
}
ModelEvent.__name__ = "ModelEvent";
let DocumentReady = class DocumentReady2 extends BokehEvent {
  _to_json() {
    return {};
  }
};
DocumentReady.__name__ = "DocumentReady";
DocumentReady = __decorate([
  event("document_ready")
], DocumentReady);
let ButtonClick = class ButtonClick2 extends ModelEvent {
};
ButtonClick.__name__ = "ButtonClick";
ButtonClick = __decorate([
  event("button_click")
], ButtonClick);
let MenuItemClick = class MenuItemClick2 extends ModelEvent {
  constructor(item) {
    super();
    this.item = item;
  }
  _to_json() {
    const { item } = this;
    return { ...super._to_json(), item };
  }
};
MenuItemClick.__name__ = "MenuItemClick";
MenuItemClick = __decorate([
  event("menu_item_click")
], MenuItemClick);
class UIEvent extends ModelEvent {
}
UIEvent.__name__ = "UIEvent";
let LODStart = class LODStart2 extends UIEvent {
};
LODStart.__name__ = "LODStart";
LODStart = __decorate([
  event("lodstart")
], LODStart);
let LODEnd = class LODEnd2 extends UIEvent {
};
LODEnd.__name__ = "LODEnd";
LODEnd = __decorate([
  event("lodend")
], LODEnd);
let RangesUpdate = class RangesUpdate2 extends UIEvent {
  constructor(x0, x1, y0, y1) {
    super();
    this.x0 = x0;
    this.x1 = x1;
    this.y0 = y0;
    this.y1 = y1;
  }
  _to_json() {
    const { x0, x1, y0, y1 } = this;
    return { ...super._to_json(), x0, x1, y0, y1 };
  }
};
RangesUpdate.__name__ = "RangesUpdate";
RangesUpdate = __decorate([
  event("rangesupdate")
], RangesUpdate);
let SelectionGeometry = class SelectionGeometry2 extends UIEvent {
  constructor(geometry, final) {
    super();
    this.geometry = geometry;
    this.final = final;
  }
  _to_json() {
    const { geometry, final } = this;
    return { ...super._to_json(), geometry, final };
  }
};
SelectionGeometry.__name__ = "SelectionGeometry";
SelectionGeometry = __decorate([
  event("selectiongeometry")
], SelectionGeometry);
let Reset = class Reset2 extends UIEvent {
};
Reset.__name__ = "Reset";
Reset = __decorate([
  event("reset")
], Reset);
class PointEvent extends UIEvent {
  constructor(sx, sy, x2, y2) {
    super();
    this.sx = sx;
    this.sy = sy;
    this.x = x2;
    this.y = y2;
  }
  _to_json() {
    const { sx, sy, x: x2, y: y2 } = this;
    return { ...super._to_json(), sx, sy, x: x2, y: y2 };
  }
}
PointEvent.__name__ = "PointEvent";
let Pan = class Pan2 extends PointEvent {
  constructor(sx, sy, x2, y2, delta_x, delta_y) {
    super(sx, sy, x2, y2);
    this.delta_x = delta_x;
    this.delta_y = delta_y;
  }
  _to_json() {
    const { delta_x, delta_y } = this;
    return { ...super._to_json(), delta_x, delta_y };
  }
};
Pan.__name__ = "Pan";
Pan = __decorate([
  event("pan")
], Pan);
let Pinch = class Pinch2 extends PointEvent {
  constructor(sx, sy, x2, y2, scale) {
    super(sx, sy, x2, y2);
    this.scale = scale;
  }
  _to_json() {
    const { scale } = this;
    return { ...super._to_json(), scale };
  }
};
Pinch.__name__ = "Pinch";
Pinch = __decorate([
  event("pinch")
], Pinch);
let Rotate = class Rotate2 extends PointEvent {
  constructor(sx, sy, x2, y2, rotation) {
    super(sx, sy, x2, y2);
    this.rotation = rotation;
  }
  _to_json() {
    const { rotation } = this;
    return { ...super._to_json(), rotation };
  }
};
Rotate.__name__ = "Rotate";
Rotate = __decorate([
  event("rotate")
], Rotate);
let MouseWheel = class MouseWheel2 extends PointEvent {
  constructor(sx, sy, x2, y2, delta) {
    super(sx, sy, x2, y2);
    this.delta = delta;
  }
  _to_json() {
    const { delta } = this;
    return { ...super._to_json(), delta };
  }
};
MouseWheel.__name__ = "MouseWheel";
MouseWheel = __decorate([
  event("wheel")
], MouseWheel);
let MouseMove = class MouseMove2 extends PointEvent {
};
MouseMove.__name__ = "MouseMove";
MouseMove = __decorate([
  event("mousemove")
], MouseMove);
let MouseEnter = class MouseEnter2 extends PointEvent {
};
MouseEnter.__name__ = "MouseEnter";
MouseEnter = __decorate([
  event("mouseenter")
], MouseEnter);
let MouseLeave = class MouseLeave2 extends PointEvent {
};
MouseLeave.__name__ = "MouseLeave";
MouseLeave = __decorate([
  event("mouseleave")
], MouseLeave);
let Tap = class Tap2 extends PointEvent {
};
Tap.__name__ = "Tap";
Tap = __decorate([
  event("tap")
], Tap);
let DoubleTap = class DoubleTap2 extends PointEvent {
};
DoubleTap.__name__ = "DoubleTap";
DoubleTap = __decorate([
  event("doubletap")
], DoubleTap);
let Press = class Press2 extends PointEvent {
};
Press.__name__ = "Press";
Press = __decorate([
  event("press")
], Press);
let PressUp = class PressUp2 extends PointEvent {
};
PressUp.__name__ = "PressUp";
PressUp = __decorate([
  event("pressup")
], PressUp);
let PanStart = class PanStart2 extends PointEvent {
};
PanStart.__name__ = "PanStart";
PanStart = __decorate([
  event("panstart")
], PanStart);
let PanEnd = class PanEnd2 extends PointEvent {
};
PanEnd.__name__ = "PanEnd";
PanEnd = __decorate([
  event("panend")
], PanEnd);
let PinchStart = class PinchStart2 extends PointEvent {
};
PinchStart.__name__ = "PinchStart";
PinchStart = __decorate([
  event("pinchstart")
], PinchStart);
let PinchEnd = class PinchEnd2 extends PointEvent {
};
PinchEnd.__name__ = "PinchEnd";
PinchEnd = __decorate([
  event("pinchend")
], PinchEnd);
let RotateStart = class RotateStart2 extends PointEvent {
};
RotateStart.__name__ = "RotateStart";
RotateStart = __decorate([
  event("rotatestart")
], RotateStart);
let RotateEnd = class RotateEnd2 extends PointEvent {
};
RotateEnd.__name__ = "RotateEnd";
RotateEnd = __decorate([
  event("rotateend")
], RotateEnd);
/*!
 * window.jQuery Mousewheel 3.1.13
 *
 * Copyright window.jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 */
function fontSize(element) {
  const value = getComputedStyle(element).fontSize;
  if (value != null)
    return parseInt(value, 10);
  return null;
}
function lineHeight(element) {
  var _a2, _b2, _c2;
  const parent = (_a2 = element.offsetParent) != null ? _a2 : document.body;
  return (_c2 = (_b2 = fontSize(parent)) != null ? _b2 : fontSize(element)) != null ? _c2 : 16;
}
function pageHeight(element) {
  return element.clientHeight;
}
function getDeltaY(event2) {
  let deltaY = -event2.deltaY;
  if (event2.target instanceof HTMLElement) {
    switch (event2.deltaMode) {
      case event2.DOM_DELTA_LINE:
        deltaY *= lineHeight(event2.target);
        break;
      case event2.DOM_DELTA_PAGE:
        deltaY *= pageHeight(event2.target);
        break;
    }
  }
  return deltaY;
}
function is_touch(event2) {
  return typeof TouchEvent !== "undefined" && event2 instanceof TouchEvent;
}
class UIEventBus {
  constructor(canvas_view) {
    this.canvas_view = canvas_view;
    this.pan_start = new Signal(this, "pan:start");
    this.pan = new Signal(this, "pan");
    this.pan_end = new Signal(this, "pan:end");
    this.pinch_start = new Signal(this, "pinch:start");
    this.pinch = new Signal(this, "pinch");
    this.pinch_end = new Signal(this, "pinch:end");
    this.rotate_start = new Signal(this, "rotate:start");
    this.rotate = new Signal(this, "rotate");
    this.rotate_end = new Signal(this, "rotate:end");
    this.tap = new Signal(this, "tap");
    this.doubletap = new Signal(this, "doubletap");
    this.press = new Signal(this, "press");
    this.pressup = new Signal(this, "pressup");
    this.move_enter = new Signal(this, "move:enter");
    this.move = new Signal(this, "move");
    this.move_exit = new Signal(this, "move:exit");
    this.scroll = new Signal(this, "scroll");
    this.keydown = new Signal(this, "keydown");
    this.keyup = new Signal(this, "keyup");
    this.hammer = new Hammer(this.hit_area, {
      touchAction: "auto",
      inputClass: Hammer.TouchMouseInput
    });
    this._prev_move = null;
    this._curr_pan = null;
    this._curr_pinch = null;
    this._curr_rotate = null;
    this._configure_hammerjs();
    this.hit_area.addEventListener("mousemove", (e) => this._mouse_move(e));
    this.hit_area.addEventListener("mouseenter", (e) => this._mouse_enter(e));
    this.hit_area.addEventListener("mouseleave", (e) => this._mouse_exit(e));
    this.hit_area.addEventListener("contextmenu", (e) => this._context_menu(e));
    this.hit_area.addEventListener("wheel", (e) => this._mouse_wheel(e));
    document.addEventListener("keydown", this);
    document.addEventListener("keyup", this);
    this.menu = new ContextMenu([], {
      prevent_hide: (event2) => event2.button == 2 && event2.target == this.hit_area
    });
    this.hit_area.appendChild(this.menu.el);
  }
  get hit_area() {
    return this.canvas_view.events_el;
  }
  destroy() {
    this.menu.remove();
    this.hammer.destroy();
    document.removeEventListener("keydown", this);
    document.removeEventListener("keyup", this);
  }
  handleEvent(e) {
    if (e.type == "keydown")
      this._key_down(e);
    else if (e.type == "keyup")
      this._key_up(e);
  }
  _configure_hammerjs() {
    this.hammer.get("doubletap").recognizeWith("tap");
    this.hammer.get("tap").requireFailure("doubletap");
    this.hammer.get("doubletap").dropRequireFailure("tap");
    this.hammer.on("doubletap", (e) => this._doubletap(e));
    this.hammer.on("tap", (e) => this._tap(e));
    this.hammer.on("press", (e) => this._press(e));
    this.hammer.on("pressup", (e) => this._pressup(e));
    this.hammer.get("pan").set({ direction: Hammer.DIRECTION_ALL });
    this.hammer.on("panstart", (e) => this._pan_start(e));
    this.hammer.on("pan", (e) => this._pan(e));
    this.hammer.on("panend", (e) => this._pan_end(e));
    this.hammer.get("pinch").set({ enable: true });
    this.hammer.on("pinchstart", (e) => this._pinch_start(e));
    this.hammer.on("pinch", (e) => this._pinch(e));
    this.hammer.on("pinchend", (e) => this._pinch_end(e));
    this.hammer.get("rotate").set({ enable: true });
    this.hammer.on("rotatestart", (e) => this._rotate_start(e));
    this.hammer.on("rotate", (e) => this._rotate(e));
    this.hammer.on("rotateend", (e) => this._rotate_end(e));
  }
  register_tool(tool_view) {
    const et = tool_view.model.event_type;
    if (et != null) {
      if (isString(et))
        this._register_tool(tool_view, et);
      else {
        et.forEach((e, index2) => this._register_tool(tool_view, e, index2 < 1));
      }
    }
  }
  _register_tool(tool_view, et, shared = true) {
    const v = tool_view;
    const { id } = v.model;
    const conditionally = (fn) => (arg) => {
      if (arg.id == id)
        fn(arg.e);
    };
    const unconditionally = (fn) => (arg) => {
      fn(arg.e);
    };
    switch (et) {
      case "pan": {
        if (v._pan_start != null)
          v.connect(this.pan_start, conditionally(v._pan_start.bind(v)));
        if (v._pan != null)
          v.connect(this.pan, conditionally(v._pan.bind(v)));
        if (v._pan_end != null)
          v.connect(this.pan_end, conditionally(v._pan_end.bind(v)));
        break;
      }
      case "pinch": {
        if (v._pinch_start != null)
          v.connect(this.pinch_start, conditionally(v._pinch_start.bind(v)));
        if (v._pinch != null)
          v.connect(this.pinch, conditionally(v._pinch.bind(v)));
        if (v._pinch_end != null)
          v.connect(this.pinch_end, conditionally(v._pinch_end.bind(v)));
        break;
      }
      case "rotate": {
        if (v._rotate_start != null)
          v.connect(this.rotate_start, conditionally(v._rotate_start.bind(v)));
        if (v._rotate != null)
          v.connect(this.rotate, conditionally(v._rotate.bind(v)));
        if (v._rotate_end != null)
          v.connect(this.rotate_end, conditionally(v._rotate_end.bind(v)));
        break;
      }
      case "move": {
        if (v._move_enter != null)
          v.connect(this.move_enter, conditionally(v._move_enter.bind(v)));
        if (v._move != null)
          v.connect(this.move, conditionally(v._move.bind(v)));
        if (v._move_exit != null)
          v.connect(this.move_exit, conditionally(v._move_exit.bind(v)));
        break;
      }
      case "tap": {
        if (v._tap != null)
          v.connect(this.tap, conditionally(v._tap.bind(v)));
        if (v._doubletap != null)
          v.connect(this.doubletap, conditionally(v._doubletap.bind(v)));
        break;
      }
      case "press": {
        if (v._press != null)
          v.connect(this.press, conditionally(v._press.bind(v)));
        if (v._pressup != null)
          v.connect(this.pressup, conditionally(v._pressup.bind(v)));
        break;
      }
      case "scroll": {
        if (v._scroll != null)
          v.connect(this.scroll, conditionally(v._scroll.bind(v)));
        break;
      }
      default:
        throw new Error(`unsupported event_type: ${et}`);
    }
    if (!shared)
      return;
    if (v._keydown != null)
      v.connect(this.keydown, unconditionally(v._keydown.bind(v)));
    if (v._keyup != null)
      v.connect(this.keyup, unconditionally(v._keyup.bind(v)));
    if (is_mobile && v._scroll != null && et == "pinch") {
      logger.debug("Registering scroll on touch screen");
      v.connect(this.scroll, conditionally(v._scroll.bind(v)));
    }
  }
  _hit_test_renderers(plot_view, sx, sy) {
    var _a2;
    const views = plot_view.get_renderer_views();
    for (const view of reversed(views)) {
      if ((_a2 = view.interactive_hit) == null ? void 0 : _a2.call(view, sx, sy))
        return view;
    }
    return null;
  }
  set_cursor(cursor = "default") {
    this.hit_area.style.cursor = cursor;
  }
  _hit_test_frame(plot_view, sx, sy) {
    return plot_view.frame.bbox.contains(sx, sy);
  }
  _hit_test_canvas(plot_view, sx, sy) {
    return plot_view.layout.bbox.contains(sx, sy);
  }
  _hit_test_plot(sx, sy) {
    for (const plot_view of this.canvas_view.plot_views) {
      if (plot_view.layout.bbox.relative().contains(sx, sy))
        return plot_view;
    }
    return null;
  }
  _trigger(signal, e, srcEvent) {
    var _a2;
    const { sx, sy } = e;
    const plot_view = this._hit_test_plot(sx, sy);
    const curr_view = plot_view;
    const relativize_event = (_plot_view) => {
      const [rel_sx, rel_sy] = [sx, sy];
      return { ...e, sx: rel_sx, sy: rel_sy };
    };
    if (e.type == "panstart" || e.type == "pan" || e.type == "panend") {
      let pan_view;
      if (e.type == "panstart" && curr_view != null) {
        this._curr_pan = { plot_view: curr_view };
        pan_view = curr_view;
      } else if (e.type == "pan" && this._curr_pan != null) {
        pan_view = this._curr_pan.plot_view;
      } else if (e.type == "panend" && this._curr_pan != null) {
        pan_view = this._curr_pan.plot_view;
        this._curr_pan = null;
      } else {
        pan_view = null;
      }
      if (pan_view != null) {
        const event2 = relativize_event();
        this.__trigger(pan_view, signal, event2, srcEvent);
      }
    } else if (e.type == "pinchstart" || e.type == "pinch" || e.type == "pinchend") {
      let pinch_view;
      if (e.type == "pinchstart" && curr_view != null) {
        this._curr_pinch = { plot_view: curr_view };
        pinch_view = curr_view;
      } else if (e.type == "pinch" && this._curr_pinch != null) {
        pinch_view = this._curr_pinch.plot_view;
      } else if (e.type == "pinchend" && this._curr_pinch != null) {
        pinch_view = this._curr_pinch.plot_view;
        this._curr_pinch = null;
      } else {
        pinch_view = null;
      }
      if (pinch_view != null) {
        const event2 = relativize_event();
        this.__trigger(pinch_view, signal, event2, srcEvent);
      }
    } else if (e.type == "rotatestart" || e.type == "rotate" || e.type == "rotateend") {
      let rotate_view;
      if (e.type == "rotatestart" && curr_view != null) {
        this._curr_rotate = { plot_view: curr_view };
        rotate_view = curr_view;
      } else if (e.type == "rotate" && this._curr_rotate != null) {
        rotate_view = this._curr_rotate.plot_view;
      } else if (e.type == "rotateend" && this._curr_rotate != null) {
        rotate_view = this._curr_rotate.plot_view;
        this._curr_rotate = null;
      } else {
        rotate_view = null;
      }
      if (rotate_view != null) {
        const event2 = relativize_event();
        this.__trigger(rotate_view, signal, event2, srcEvent);
      }
    } else if (e.type == "mouseenter" || e.type == "mousemove" || e.type == "mouseleave") {
      const prev_view = (_a2 = this._prev_move) == null ? void 0 : _a2.plot_view;
      if (prev_view != null && (e.type == "mouseleave" || prev_view != curr_view)) {
        const { sx: sx2, sy: sy2 } = relativize_event();
        this.__trigger(prev_view, this.move_exit, { type: "mouseleave", sx: sx2, sy: sy2, shiftKey: false, ctrlKey: false }, srcEvent);
      }
      if (curr_view != null && (e.type == "mouseenter" || prev_view != curr_view)) {
        const { sx: sx2, sy: sy2 } = relativize_event();
        this.__trigger(curr_view, this.move_enter, { type: "mouseenter", sx: sx2, sy: sy2, shiftKey: false, ctrlKey: false }, srcEvent);
      }
      if (curr_view != null && e.type == "mousemove") {
        const event2 = relativize_event();
        this.__trigger(curr_view, signal, event2, srcEvent);
      }
      this._prev_move = { sx, sy, plot_view: curr_view };
    } else {
      if (curr_view != null) {
        const event2 = relativize_event();
        this.__trigger(curr_view, signal, event2, srcEvent);
      }
    }
  }
  __trigger(plot_view, signal, e, srcEvent) {
    var _a2, _b2, _c2;
    const gestures = plot_view.model.toolbar.gestures;
    const event_type = signal.name;
    const base_type = event_type.split(":")[0];
    const view = this._hit_test_renderers(plot_view, e.sx, e.sy);
    const on_canvas = this._hit_test_canvas(plot_view, e.sx, e.sy);
    switch (base_type) {
      case "move": {
        const active_gesture = gestures.move.active;
        if (active_gesture != null)
          this.trigger(signal, e, active_gesture.id);
        const active_inspectors = plot_view.model.toolbar.inspectors.filter((t) => t.active);
        let cursor = "default";
        if (view != null) {
          cursor = (_a2 = view.cursor(e.sx, e.sy)) != null ? _a2 : cursor;
          if (!is_empty$1(active_inspectors)) {
            signal = this.move_exit;
          }
        } else if (this._hit_test_frame(plot_view, e.sx, e.sy)) {
          if (!is_empty$1(active_inspectors)) {
            cursor = "crosshair";
          }
        }
        this.set_cursor(cursor);
        plot_view.set_toolbar_visibility(on_canvas);
        active_inspectors.map((inspector) => this.trigger(signal, e, inspector.id));
        break;
      }
      case "tap": {
        const { target } = srcEvent;
        if (target != null && target != this.hit_area)
          return;
        (_b2 = view == null ? void 0 : view.on_hit) == null ? void 0 : _b2.call(view, e.sx, e.sy);
        if (this._hit_test_frame(plot_view, e.sx, e.sy)) {
          const active_gesture = gestures.tap.active;
          if (active_gesture != null)
            this.trigger(signal, e, active_gesture.id);
        }
        break;
      }
      case "doubletap": {
        if (this._hit_test_frame(plot_view, e.sx, e.sy)) {
          const active_gesture = (_c2 = gestures.doubletap.active) != null ? _c2 : gestures.tap.active;
          if (active_gesture != null)
            this.trigger(signal, e, active_gesture.id);
        }
        break;
      }
      case "scroll": {
        const base = is_mobile ? "pinch" : "scroll";
        const active_gesture = gestures[base].active;
        if (active_gesture != null) {
          srcEvent.preventDefault();
          srcEvent.stopPropagation();
          this.trigger(signal, e, active_gesture.id);
        }
        break;
      }
      case "pan": {
        const active_gesture = gestures.pan.active;
        if (active_gesture != null) {
          srcEvent.preventDefault();
          this.trigger(signal, e, active_gesture.id);
        }
        break;
      }
      default: {
        const active_gesture = gestures[base_type].active;
        if (active_gesture != null)
          this.trigger(signal, e, active_gesture.id);
      }
    }
    this._trigger_bokeh_event(plot_view, e);
  }
  trigger(signal, e, id = null) {
    signal.emit({ id, e });
  }
  _trigger_bokeh_event(plot_view, e) {
    const ev = (() => {
      const { sx, sy } = e;
      const x2 = plot_view.frame.x_scale.invert(sx);
      const y2 = plot_view.frame.y_scale.invert(sy);
      switch (e.type) {
        case "wheel":
          return new MouseWheel(sx, sy, x2, y2, e.delta);
        case "mousemove":
          return new MouseMove(sx, sy, x2, y2);
        case "mouseenter":
          return new MouseEnter(sx, sy, x2, y2);
        case "mouseleave":
          return new MouseLeave(sx, sy, x2, y2);
        case "tap":
          return new Tap(sx, sy, x2, y2);
        case "doubletap":
          return new DoubleTap(sx, sy, x2, y2);
        case "press":
          return new Press(sx, sy, x2, y2);
        case "pressup":
          return new PressUp(sx, sy, x2, y2);
        case "pan":
          return new Pan(sx, sy, x2, y2, e.deltaX, e.deltaY);
        case "panstart":
          return new PanStart(sx, sy, x2, y2);
        case "panend":
          return new PanEnd(sx, sy, x2, y2);
        case "pinch":
          return new Pinch(sx, sy, x2, y2, e.scale);
        case "pinchstart":
          return new PinchStart(sx, sy, x2, y2);
        case "pinchend":
          return new PinchEnd(sx, sy, x2, y2);
        case "rotate":
          return new Rotate(sx, sy, x2, y2, e.rotation);
        case "rotatestart":
          return new RotateStart(sx, sy, x2, y2);
        case "rotateend":
          return new RotateEnd(sx, sy, x2, y2);
        default:
          return void 0;
      }
    })();
    if (ev != null)
      plot_view.model.trigger_event(ev);
  }
  _get_sxy(event2) {
    const { pageX, pageY } = is_touch(event2) ? (event2.touches.length != 0 ? event2.touches : event2.changedTouches)[0] : event2;
    const { left: left2, top } = offset(this.hit_area);
    return {
      sx: pageX - left2,
      sy: pageY - top
    };
  }
  _pan_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      deltaX: e.deltaX,
      deltaY: e.deltaY,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _pinch_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      scale: e.scale,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _rotate_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      rotation: e.rotation,
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _tap_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e.srcEvent),
      shiftKey: e.srcEvent.shiftKey,
      ctrlKey: e.srcEvent.ctrlKey
    };
  }
  _move_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e),
      shiftKey: e.shiftKey,
      ctrlKey: e.ctrlKey
    };
  }
  _scroll_event(e) {
    return {
      type: e.type,
      ...this._get_sxy(e),
      delta: getDeltaY(e),
      shiftKey: e.shiftKey,
      ctrlKey: e.ctrlKey
    };
  }
  _key_event(e) {
    return {
      type: e.type,
      keyCode: e.keyCode
    };
  }
  _pan_start(e) {
    const ev = this._pan_event(e);
    ev.sx -= e.deltaX;
    ev.sy -= e.deltaY;
    this._trigger(this.pan_start, ev, e.srcEvent);
  }
  _pan(e) {
    this._trigger(this.pan, this._pan_event(e), e.srcEvent);
  }
  _pan_end(e) {
    this._trigger(this.pan_end, this._pan_event(e), e.srcEvent);
  }
  _pinch_start(e) {
    this._trigger(this.pinch_start, this._pinch_event(e), e.srcEvent);
  }
  _pinch(e) {
    this._trigger(this.pinch, this._pinch_event(e), e.srcEvent);
  }
  _pinch_end(e) {
    this._trigger(this.pinch_end, this._pinch_event(e), e.srcEvent);
  }
  _rotate_start(e) {
    this._trigger(this.rotate_start, this._rotate_event(e), e.srcEvent);
  }
  _rotate(e) {
    this._trigger(this.rotate, this._rotate_event(e), e.srcEvent);
  }
  _rotate_end(e) {
    this._trigger(this.rotate_end, this._rotate_event(e), e.srcEvent);
  }
  _tap(e) {
    this._trigger(this.tap, this._tap_event(e), e.srcEvent);
  }
  _doubletap(e) {
    this._trigger(this.doubletap, this._tap_event(e), e.srcEvent);
  }
  _press(e) {
    this._trigger(this.press, this._tap_event(e), e.srcEvent);
  }
  _pressup(e) {
    this._trigger(this.pressup, this._tap_event(e), e.srcEvent);
  }
  _mouse_enter(e) {
    this._trigger(this.move_enter, this._move_event(e), e);
  }
  _mouse_move(e) {
    this._trigger(this.move, this._move_event(e), e);
  }
  _mouse_exit(e) {
    this._trigger(this.move_exit, this._move_event(e), e);
  }
  _mouse_wheel(e) {
    this._trigger(this.scroll, this._scroll_event(e), e);
  }
  _context_menu(e) {
    if (!this.menu.is_open && this.menu.can_open) {
      e.preventDefault();
    }
    const { sx, sy } = this._get_sxy(e);
    this.menu.toggle({ left: sx, top: sy });
  }
  _key_down(e) {
    this.trigger(this.keydown, this._key_event(e));
  }
  _key_up(e) {
    this.trigger(this.keyup, this._key_event(e));
  }
}
UIEventBus.__name__ = "UIEventBus";
var _a$2w;
async function init_webgl() {
  const canvas2 = document.createElement("canvas");
  const gl = canvas2.getContext("webgl", { premultipliedAlpha: true });
  if (gl != null) {
    const webgl = await load_module(import("./index2.js"));
    if (webgl != null) {
      const regl_wrapper2 = webgl.get_regl(gl);
      if (regl_wrapper2.has_webgl) {
        return { canvas: canvas2, regl_wrapper: regl_wrapper2 };
      } else {
        logger.trace("WebGL is supported, but not the required extensions");
      }
    } else {
      logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available");
    }
  } else {
    logger.trace("WebGL is not supported");
  }
  return null;
}
const global_webgl = (() => {
  let _global_webgl;
  return async () => {
    if (_global_webgl !== void 0)
      return _global_webgl;
    else
      return _global_webgl = await init_webgl();
  };
})();
const style = {
  position: "absolute",
  top: "0",
  left: "0",
  width: "100%",
  height: "100%"
};
class CanvasView extends DOMView {
  constructor() {
    super(...arguments);
    this.bbox = new BBox$2();
    this.webgl = null;
  }
  initialize() {
    super.initialize();
    this.underlays_el = div({ style });
    this.primary = this.create_layer();
    this.overlays = this.create_layer();
    this.overlays_el = div({ style });
    this.events_el = div({ class: "bk-canvas-events", style });
    const elements = [
      this.underlays_el,
      this.primary.el,
      this.overlays.el,
      this.overlays_el,
      this.events_el
    ];
    extend$1(this.el.style, style);
    append(this.el, ...elements);
    this.ui_event_bus = new UIEventBus(this);
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    if (this.model.output_backend == "webgl") {
      this.webgl = await global_webgl();
      if (settings.force_webgl && this.webgl == null)
        throw new Error("webgl is not available");
    }
  }
  remove() {
    this.ui_event_bus.destroy();
    super.remove();
  }
  add_underlay(el) {
    this.underlays_el.appendChild(el);
  }
  add_overlay(el) {
    this.overlays_el.appendChild(el);
  }
  add_event(el) {
    this.events_el.appendChild(el);
  }
  get pixel_ratio() {
    return this.primary.pixel_ratio;
  }
  resize(width, height) {
    this.bbox = new BBox$2({ left: 0, top: 0, width, height });
    this.primary.resize(width, height);
    this.overlays.resize(width, height);
  }
  prepare_webgl(frame_box) {
    const { webgl } = this;
    if (webgl != null) {
      const { width, height } = this.bbox;
      webgl.canvas.width = this.pixel_ratio * width;
      webgl.canvas.height = this.pixel_ratio * height;
      const [sx, sy, w, h2] = frame_box;
      const { xview, yview } = this.bbox;
      const vx = xview.compute(sx);
      const vy = yview.compute(sy + h2);
      const ratio = this.pixel_ratio;
      webgl.regl_wrapper.set_scissor(ratio * vx, ratio * vy, ratio * w, ratio * h2);
      this._clear_webgl();
    }
  }
  blit_webgl(ctx) {
    const { webgl } = this;
    if (webgl != null) {
      logger.debug("Blitting WebGL canvas");
      ctx.restore();
      ctx.drawImage(webgl.canvas, 0, 0);
      ctx.save();
      if (this.model.hidpi) {
        const ratio = this.pixel_ratio;
        ctx.scale(ratio, ratio);
        ctx.translate(0.5, 0.5);
      }
      this._clear_webgl();
    }
  }
  _clear_webgl() {
    const { webgl } = this;
    if (webgl != null) {
      const { regl_wrapper: regl_wrapper2, canvas: canvas2 } = webgl;
      regl_wrapper2.clear(canvas2.width, canvas2.height);
    }
  }
  compose() {
    const composite = this.create_layer();
    const { width, height } = this.bbox;
    composite.resize(width, height);
    composite.ctx.drawImage(this.primary.canvas, 0, 0);
    composite.ctx.drawImage(this.overlays.canvas, 0, 0);
    return composite;
  }
  create_layer() {
    const { output_backend, hidpi } = this.model;
    return new CanvasLayer(output_backend, hidpi);
  }
  to_blob() {
    return this.compose().to_blob();
  }
}
CanvasView.__name__ = "CanvasView";
class Canvas extends HasProps {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2w = Canvas;
Canvas.__name__ = "Canvas";
(() => {
  _a$2w.prototype.default_view = CanvasView;
  _a$2w.internal(({ Boolean: Boolean2 }) => ({
    hidpi: [Boolean2, true],
    output_backend: [OutputBackend, "canvas"]
  }));
})();
class Expression extends Model {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this._result = /* @__PURE__ */ new Map();
  }
  v_compute(source) {
    let result = this._result.get(source);
    if (result === void 0 || source.changed_for(this)) {
      result = this._v_compute(source);
      this._result.set(source, result);
    }
    return result;
  }
}
Expression.__name__ = "Expression";
class ScalarExpression extends Model {
  constructor(attrs) {
    super(attrs);
  }
  initialize() {
    super.initialize();
    this._result = /* @__PURE__ */ new Map();
  }
  compute(source) {
    let result = this._result.get(source);
    if (result === void 0 || source.changed_for(this)) {
      result = this._compute(source);
      this._result.set(source, result);
    }
    return result;
  }
}
ScalarExpression.__name__ = "ScalarExpression";
var _a$2v;
class CustomJSExpr extends Expression {
  constructor(attrs) {
    super(attrs);
  }
  connect_signals() {
    super.connect_signals();
    for (const value of values(this.args)) {
      if (value instanceof HasProps) {
        value.change.connect(() => {
          this._result.clear();
          this.change.emit();
        });
      }
    }
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const code = use_strict(this.code);
    return new GeneratorFunction(...this.names, code);
  }
  _v_compute(source) {
    const generator = this.func.apply(source, this.values);
    let result = generator.next();
    if (result.done && result.value !== void 0) {
      const { value } = result;
      if (isArray(value) || isTypedArray(value))
        return value;
      else if (isIterable(value))
        return [...value];
      else
        return repeat(value, source.length);
    } else {
      const array = [];
      do {
        array.push(result.value);
        result = generator.next();
      } while (!result.done);
      return array;
    }
  }
}
_a$2v = CustomJSExpr;
CustomJSExpr.__name__ = "CustomJSExpr";
(() => {
  _a$2v.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    code: [String2, ""]
  }));
})();
var _a$2u;
class Stack$2 extends Expression {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    var _a2;
    const n2 = (_a2 = source.get_length()) != null ? _a2 : 0;
    const result = new Float64Array(n2);
    for (const f of this.fields) {
      const column = source.data[f];
      if (column != null) {
        const k = Math.min(n2, column.length);
        for (let i2 = 0; i2 < k; i2++) {
          result[i2] += column[i2];
        }
      }
    }
    return result;
  }
}
_a$2u = Stack$2;
Stack$2.__name__ = "Stack";
(() => {
  _a$2u.define(({ String: String2, Array: Array2 }) => ({
    fields: [Array2(String2), []]
  }));
})();
var _a$2t;
class CumSum extends Expression {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    var _a2;
    const result = new Float64Array((_a2 = source.get_length()) != null ? _a2 : 0);
    const col = source.data[this.field];
    const offset2 = this.include_zero ? 1 : 0;
    result[0] = this.include_zero ? 0 : col[0];
    for (let i2 = 1; i2 < result.length; i2++) {
      result[i2] = result[i2 - 1] + col[i2 - offset2];
    }
    return result;
  }
}
_a$2t = CumSum;
CumSum.__name__ = "CumSum";
(() => {
  _a$2t.define(({ Boolean: Boolean2, String: String2 }) => ({
    field: [String2],
    include_zero: [Boolean2, false]
  }));
})();
var _a$2s;
class Minimum extends ScalarExpression {
  constructor(attrs) {
    super(attrs);
  }
  _compute(source) {
    var _a2, _b2;
    const column = (_a2 = source.data[this.field]) != null ? _a2 : [];
    return Math.min((_b2 = this.initial) != null ? _b2 : Infinity, min$6(column));
  }
}
_a$2s = Minimum;
Minimum.__name__ = "Minimum";
(() => {
  _a$2s.define(({ Number: Number2, String: String2, Nullable: Nullable2 }) => ({
    field: [String2],
    initial: [Nullable2(Number2), null]
  }));
})();
var _a$2r;
class Maximum extends ScalarExpression {
  constructor(attrs) {
    super(attrs);
  }
  _compute(source) {
    var _a2, _b2;
    const column = (_a2 = source.data[this.field]) != null ? _a2 : [];
    return Math.max((_b2 = this.initial) != null ? _b2 : -Infinity, max$8(column));
  }
}
_a$2r = Maximum;
Maximum.__name__ = "Maximum";
(() => {
  _a$2r.define(({ Number: Number2, String: String2, Nullable: Nullable2 }) => ({
    field: [String2],
    initial: [Nullable2(Number2), null]
  }));
})();
var _a$2q;
class CoordinateTransform extends Expression {
  constructor(attrs) {
    super(attrs);
  }
  get x() {
    return new XComponent({ transform: this });
  }
  get y() {
    return new YComponent({ transform: this });
  }
}
CoordinateTransform.__name__ = "CoordinateTransform";
class XYComponent extends Expression {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2q = XYComponent;
XYComponent.__name__ = "XYComponent";
(() => {
  _a$2q.define(({ Ref: Ref2 }) => ({
    transform: [Ref2(CoordinateTransform)]
  }));
})();
class XComponent extends XYComponent {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    return this.transform.v_compute(source).x;
  }
}
XComponent.__name__ = "XComponent";
class YComponent extends XYComponent {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    return this.transform.v_compute(source).y;
  }
}
YComponent.__name__ = "YComponent";
var _a$2p;
class PolarTransform extends CoordinateTransform {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    const radius = this.properties.radius.uniform(source);
    const angle = this.properties.angle.uniform(source);
    const coeff = this.direction == "anticlock" ? -1 : 1;
    const n2 = Math.min(radius.length, angle.length);
    const x2 = new Float64Array(n2);
    const y2 = new Float64Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      const radius_i = radius.get(i2);
      const angle_i = angle.get(i2) * coeff;
      x2[i2] = radius_i * Math.cos(angle_i);
      y2[i2] = radius_i * Math.sin(angle_i);
    }
    return { x: x2, y: y2 };
  }
}
_a$2p = PolarTransform;
PolarTransform.__name__ = "PolarTransform";
(() => {
  _a$2p.define(({}) => ({
    radius: [DistanceSpec, { field: "radius" }],
    angle: [AngleSpec, { field: "angle" }],
    direction: [Direction$1, "anticlock"]
  }));
})();
var _a$2o;
class BooleanFilter extends Filter {
  constructor(attrs) {
    super(attrs);
  }
  compute_indices(source) {
    const size2 = source.length;
    const { booleans } = this;
    if (booleans == null) {
      return BitSet.all_set(size2);
    } else {
      return BitSet.from_booleans(size2, booleans);
    }
  }
}
_a$2o = BooleanFilter;
BooleanFilter.__name__ = "BooleanFilter";
(() => {
  _a$2o.define(({ Boolean: Boolean2, Array: Array2, Nullable: Nullable2 }) => ({
    booleans: [Nullable2(Array2(Boolean2)), null]
  }));
})();
var _a$2n;
class CustomJSFilter extends Filter {
  constructor(attrs) {
    super(attrs);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  get func() {
    const code = use_strict(this.code);
    return new Function(...this.names, "source", code);
  }
  compute_indices(source) {
    const size2 = source.length;
    const filter2 = this.func(...this.values, source);
    if (filter2 == null)
      return BitSet.all_set(size2);
    else if (isArrayOf(filter2, isInteger))
      return BitSet.from_indices(size2, filter2);
    else if (isArrayOf(filter2, isBoolean))
      return BitSet.from_booleans(size2, filter2);
    else
      throw new Error(`expect an array of integers or booleans, or null, got ${filter2}`);
  }
}
_a$2n = CustomJSFilter;
CustomJSFilter.__name__ = "CustomJSFilter";
(() => {
  _a$2n.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    code: [String2, ""]
  }));
})();
var _a$2m;
class GroupFilter extends Filter {
  constructor(attrs) {
    super(attrs);
  }
  compute_indices(source) {
    const column = source.get_column(this.column_name);
    if (column == null) {
      logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`);
      return new BitSet(source.length, 1);
    } else {
      const indices = new BitSet(source.length);
      for (let i2 = 0; i2 < indices.size; i2++) {
        if (column[i2] === this.group)
          indices.set(i2);
      }
      return indices;
    }
  }
}
_a$2m = GroupFilter;
GroupFilter.__name__ = "GroupFilter";
(() => {
  _a$2m.define(({ String: String2 }) => ({
    column_name: [String2],
    group: [String2]
  }));
})();
var _a$2l;
class IndexFilter extends Filter {
  constructor(attrs) {
    super(attrs);
  }
  compute_indices(source) {
    const size2 = source.length;
    const { indices } = this;
    if (indices == null) {
      return BitSet.all_set(size2);
    } else {
      return BitSet.from_indices(size2, indices);
    }
  }
}
_a$2l = IndexFilter;
IndexFilter.__name__ = "IndexFilter";
(() => {
  _a$2l.define(({ Int: Int2, Array: Array2, Nullable: Nullable2 }) => ({
    indices: [Nullable2(Array2(Int2)), null]
  }));
})();
var _a$2k;
class AnnularWedgeView extends XYGlyphView {
  _map_data() {
    if (this.model.properties.inner_radius.units == "data")
      this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this.inner_radius);
    else
      this.sinner_radius = to_screen(this.inner_radius);
    if (this.model.properties.outer_radius.units == "data")
      this.souter_radius = this.sdist(this.renderer.xscale, this._x, this.outer_radius);
    else
      this.souter_radius = to_screen(this.outer_radius);
    this.max_souter_radius = max$8(this.souter_radius);
  }
  _render(ctx, indices, data2) {
    const { sx, sy, start_angle, end_angle, sinner_radius, souter_radius } = data2 != null ? data2 : this;
    const anticlock = this.model.direction == "anticlock";
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sinner_radius_i = sinner_radius[i2];
      const souter_radius_i = souter_radius[i2];
      const start_angle_i = start_angle.get(i2);
      const end_angle_i = end_angle.get(i2);
      if (!isFinite(sx_i + sy_i + sinner_radius_i + souter_radius_i + start_angle_i + end_angle_i))
        continue;
      const angle_i = end_angle_i - start_angle_i;
      ctx.translate(sx_i, sy_i);
      ctx.rotate(start_angle_i);
      ctx.beginPath();
      ctx.moveTo(souter_radius_i, 0);
      ctx.arc(0, 0, souter_radius_i, 0, angle_i, anticlock);
      ctx.rotate(angle_i);
      ctx.lineTo(sinner_radius_i, 0);
      ctx.arc(0, 0, sinner_radius_i, 0, -angle_i, !anticlock);
      ctx.closePath();
      ctx.rotate(-angle_i - start_angle_i);
      ctx.translate(-sx_i, -sy_i);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const sx0 = sx - this.max_souter_radius;
    const sx1 = sx + this.max_souter_radius;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const sy0 = sy - this.max_souter_radius;
    const sy1 = sy + this.max_souter_radius;
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const candidates = [];
    for (const i2 of this.index.indices({ x0, x1, y0, y1 })) {
      const or2 = this.souter_radius[i2] ** 2;
      const ir2 = this.sinner_radius[i2] ** 2;
      const [sx02, sx12] = this.renderer.xscale.r_compute(x2, this._x[i2]);
      const [sy02, sy12] = this.renderer.yscale.r_compute(y2, this._y[i2]);
      const dist = (sx02 - sx12) ** 2 + (sy02 - sy12) ** 2;
      if (dist <= or2 && dist >= ir2)
        candidates.push(i2);
    }
    const anticlock = this.model.direction == "anticlock";
    const indices = [];
    for (const i2 of candidates) {
      const angle = Math.atan2(sy - this.sy[i2], sx - this.sx[i2]);
      if (angle_between(-angle, -this.start_angle.get(i2), -this.end_angle.get(i2), anticlock)) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
  scenterxy(i2) {
    const r = (this.sinner_radius[i2] + this.souter_radius[i2]) / 2;
    const a2 = (this.start_angle.get(i2) + this.end_angle.get(i2)) / 2;
    const scx = this.sx[i2] + r * Math.cos(a2);
    const scy = this.sy[i2] + r * Math.sin(a2);
    return [scx, scy];
  }
}
AnnularWedgeView.__name__ = "AnnularWedgeView";
class AnnularWedge extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2k = AnnularWedge;
AnnularWedge.__name__ = "AnnularWedge";
(() => {
  _a$2k.prototype.default_view = AnnularWedgeView;
  _a$2k.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$2k.define(({}) => ({
    direction: [Direction$1, "anticlock"],
    inner_radius: [DistanceSpec, { field: "inner_radius" }],
    outer_radius: [DistanceSpec, { field: "outer_radius" }],
    start_angle: [AngleSpec, { field: "start_angle" }],
    end_angle: [AngleSpec, { field: "end_angle" }]
  }));
})();
var _a$2j;
class AnnulusView extends XYGlyphView {
  _map_data() {
    if (this.model.properties.inner_radius.units == "data")
      this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this.inner_radius);
    else
      this.sinner_radius = to_screen(this.inner_radius);
    if (this.model.properties.outer_radius.units == "data")
      this.souter_radius = this.sdist(this.renderer.xscale, this._x, this.outer_radius);
    else
      this.souter_radius = to_screen(this.outer_radius);
  }
  _render(ctx, indices, data2) {
    const { sx, sy, sinner_radius, souter_radius } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sinner_radius_i = sinner_radius[i2];
      const souter_radius_i = souter_radius[i2];
      if (!isFinite(sx_i + sy_i + sinner_radius_i + souter_radius_i))
        continue;
      ctx.beginPath();
      if (is_ie) {
        for (const clockwise of [false, true]) {
          ctx.moveTo(sx_i, sy_i);
          ctx.arc(sx_i, sy_i, sinner_radius_i, 0, Math.PI, clockwise);
          ctx.moveTo(sx_i + souter_radius_i, sy_i);
          ctx.arc(sx_i, sy_i, souter_radius_i, Math.PI, 0, !clockwise);
        }
      } else {
        ctx.arc(sx_i, sy_i, sinner_radius_i, 0, 2 * Math.PI, true);
        ctx.moveTo(sx_i + souter_radius_i, sy_i);
        ctx.arc(sx_i, sy_i, souter_radius_i, 2 * Math.PI, 0, false);
      }
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    let x0, y0;
    let x1, y1;
    if (this.model.properties.outer_radius.units == "data") {
      x0 = x2 - this.max_outer_radius;
      x1 = x2 + this.max_outer_radius;
      y0 = y2 - this.max_outer_radius;
      y1 = y2 + this.max_outer_radius;
    } else {
      const sx0 = sx - this.max_outer_radius;
      const sx1 = sx + this.max_outer_radius;
      [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
      const sy0 = sy - this.max_outer_radius;
      const sy1 = sy + this.max_outer_radius;
      [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    }
    const indices = [];
    for (const i2 of this.index.indices({ x0, x1, y0, y1 })) {
      const or2 = this.souter_radius[i2] ** 2;
      const ir2 = this.sinner_radius[i2] ** 2;
      const [sx0, sx1] = this.renderer.xscale.r_compute(x2, this._x[i2]);
      const [sy0, sy1] = this.renderer.yscale.r_compute(y2, this._y[i2]);
      const dist = (sx0 - sx1) ** 2 + (sy0 - sy1) ** 2;
      if (dist <= or2 && dist >= ir2)
        indices.push(i2);
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, { x0, y0, x1, y1 }, index2) {
    const len = index2 + 1;
    const sx = new Array(len);
    sx[index2] = (x0 + x1) / 2;
    const sy = new Array(len);
    sy[index2] = (y0 + y1) / 2;
    const r = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.5;
    const sinner_radius = new Array(len);
    sinner_radius[index2] = r * 0.4;
    const souter_radius = new Array(len);
    souter_radius[index2] = r * 0.8;
    this._render(ctx, [index2], { sx, sy, sinner_radius, souter_radius });
  }
}
AnnulusView.__name__ = "AnnulusView";
class Annulus extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2j = Annulus;
Annulus.__name__ = "Annulus";
(() => {
  _a$2j.prototype.default_view = AnnulusView;
  _a$2j.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$2j.define(({}) => ({
    inner_radius: [DistanceSpec, { field: "inner_radius" }],
    outer_radius: [DistanceSpec, { field: "outer_radius" }]
  }));
})();
var _a$2i;
class ArcView extends XYGlyphView {
  _map_data() {
    if (this.model.properties.radius.units == "data")
      this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius);
    else
      this.sradius = to_screen(this.radius);
  }
  _render(ctx, indices, data2) {
    if (this.visuals.line.doit) {
      const { sx, sy, sradius, start_angle, end_angle } = data2 != null ? data2 : this;
      const anticlock = this.model.direction == "anticlock";
      for (const i2 of indices) {
        const sx_i = sx[i2];
        const sy_i = sy[i2];
        const sradius_i = sradius[i2];
        const start_angle_i = start_angle.get(i2);
        const end_angle_i = end_angle.get(i2);
        if (!isFinite(sx_i + sy_i + sradius_i + start_angle_i + end_angle_i))
          continue;
        ctx.beginPath();
        ctx.arc(sx_i, sy_i, sradius_i, start_angle_i, end_angle_i, anticlock);
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.stroke();
      }
    }
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
ArcView.__name__ = "ArcView";
class Arc extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2i = Arc;
Arc.__name__ = "Arc";
(() => {
  _a$2i.prototype.default_view = ArcView;
  _a$2i.mixins(LineVector$1);
  _a$2i.define(({}) => ({
    direction: [Direction$1, "anticlock"],
    radius: [DistanceSpec, { field: "radius" }],
    start_angle: [AngleSpec, { field: "start_angle" }],
    end_angle: [AngleSpec, { field: "end_angle" }]
  }));
})();
var _a$2h;
function _cbb(x0, y0, x1, y1, x2, y2, x3, y3) {
  const tvalues = [];
  const bounds = [[], []];
  for (let i2 = 0; i2 <= 2; i2++) {
    let a2, b, c;
    if (i2 === 0) {
      b = 6 * x0 - 12 * x1 + 6 * x2;
      a2 = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
      c = 3 * x1 - 3 * x0;
    } else {
      b = 6 * y0 - 12 * y1 + 6 * y2;
      a2 = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
      c = 3 * y1 - 3 * y0;
    }
    if (Math.abs(a2) < 1e-12) {
      if (Math.abs(b) < 1e-12)
        continue;
      const t = -c / b;
      if (0 < t && t < 1)
        tvalues.push(t);
      continue;
    }
    const b2ac = b * b - 4 * c * a2;
    const sqrtb2ac = Math.sqrt(b2ac);
    if (b2ac < 0)
      continue;
    const t1 = (-b + sqrtb2ac) / (2 * a2);
    if (0 < t1 && t1 < 1)
      tvalues.push(t1);
    const t2 = (-b - sqrtb2ac) / (2 * a2);
    if (0 < t2 && t2 < 1)
      tvalues.push(t2);
  }
  let j = tvalues.length;
  const jlen = j;
  while (j--) {
    const t = tvalues[j];
    const mt = 1 - t;
    const x4 = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
    bounds[0][j] = x4;
    const y4 = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
    bounds[1][j] = y4;
  }
  bounds[0][jlen] = x0;
  bounds[1][jlen] = y0;
  bounds[0][jlen + 1] = x3;
  bounds[1][jlen + 1] = y3;
  return [
    Math.min(...bounds[0]),
    Math.max(...bounds[1]),
    Math.max(...bounds[0]),
    Math.min(...bounds[1])
  ];
}
class BezierView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0);
    inplace.project_xy(this._x1, this._y1);
  }
  _index_data(index2) {
    const { data_size, _x0, _y0, _x1, _y1, _cx0, _cy0, _cx1, _cy1 } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x0_i = _x0[i2];
      const y0_i = _y0[i2];
      const x1_i = _x1[i2];
      const y1_i = _y1[i2];
      const cx0_i = _cx0[i2];
      const cy0_i = _cy0[i2];
      const cx1_i = _cx1[i2];
      const cy1_i = _cy1[i2];
      if (!isFinite(x0_i + x1_i + y0_i + y1_i + cx0_i + cy0_i + cx1_i + cy1_i))
        index2.add_empty();
      else {
        const [x0, y0, x1, y1] = _cbb(x0_i, y0_i, x1_i, y1_i, cx0_i, cy0_i, cx1_i, cy1_i);
        index2.add_rect(x0, y0, x1, y1);
      }
    }
  }
  _render(ctx, indices, data2) {
    if (this.visuals.line.doit) {
      const { sx0, sy0, sx1, sy1, scx0, scy0, scx1, scy1 } = data2 != null ? data2 : this;
      for (const i2 of indices) {
        const sx0_i = sx0[i2];
        const sy0_i = sy0[i2];
        const sx1_i = sx1[i2];
        const sy1_i = sy1[i2];
        const scx0_i = scx0[i2];
        const scy0_i = scy0[i2];
        const scx1_i = scx1[i2];
        const scy1_i = scy1[i2];
        if (!isFinite(sx0_i + sy0_i + sx1_i + sy1_i + scx0_i + scy0_i + scx1_i + scy1_i))
          continue;
        ctx.beginPath();
        ctx.moveTo(sx0_i, sy0_i);
        ctx.bezierCurveTo(scx0_i, scy0_i, scx1_i, scy1_i, sx1_i, sy1_i);
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.stroke();
      }
    }
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
BezierView.__name__ = "BezierView";
class Bezier extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2h = Bezier;
Bezier.__name__ = "Bezier";
(() => {
  _a$2h.prototype.default_view = BezierView;
  _a$2h.define(({}) => ({
    x0: [XCoordinateSpec, { field: "x0" }],
    y0: [YCoordinateSpec, { field: "y0" }],
    x1: [XCoordinateSpec, { field: "x1" }],
    y1: [YCoordinateSpec, { field: "y1" }],
    cx0: [XCoordinateSpec, { field: "cx0" }],
    cy0: [YCoordinateSpec, { field: "cy0" }],
    cx1: [XCoordinateSpec, { field: "cx1" }],
    cy1: [YCoordinateSpec, { field: "cy1" }]
  }));
  _a$2h.mixins(LineVector$1);
})();
var _a$2g;
class CircleView extends XYGlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { CircleGL: CircleGL2 } = await Promise.resolve().then(function() {
        return circle;
      });
      this.glglyph = new CircleGL2(webgl.regl_wrapper, this);
    }
  }
  get use_radius() {
    return !(this.radius.is_Scalar() && isNaN(this.radius.value));
  }
  _set_data(indices) {
    super._set_data(indices);
    const max_size = (() => {
      if (this.use_radius)
        return 2 * this.max_radius;
      else {
        const { size: size2 } = this;
        return size2.is_Scalar() ? size2.value : max$8(size2.array);
      }
    })();
    this._configure("max_size", { value: max_size });
  }
  _map_data() {
    if (this.use_radius) {
      if (this.model.properties.radius.units == "data") {
        switch (this.model.radius_dimension) {
          case "x": {
            this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius);
            break;
          }
          case "y": {
            this.sradius = this.sdist(this.renderer.yscale, this._y, this.radius);
            break;
          }
          case "max": {
            const sradius_x = this.sdist(this.renderer.xscale, this._x, this.radius);
            const sradius_y = this.sdist(this.renderer.yscale, this._y, this.radius);
            this.sradius = map(sradius_x, (s, i2) => Math.max(s, sradius_y[i2]));
            break;
          }
          case "min": {
            const sradius_x = this.sdist(this.renderer.xscale, this._x, this.radius);
            const sradius_y = this.sdist(this.renderer.yscale, this._y, this.radius);
            this.sradius = map(sradius_x, (s, i2) => Math.min(s, sradius_y[i2]));
            break;
          }
        }
      } else
        this.sradius = to_screen(this.radius);
    } else {
      const ssize = ScreenArray.from(this.size);
      this.sradius = map(ssize, (s) => s / 2);
    }
  }
  _mask_data() {
    const { frame } = this.renderer.plot_view;
    const shr = frame.x_target;
    const svr = frame.y_target;
    let hr;
    let vr;
    if (this.use_radius && this.model.properties.radius.units == "data") {
      hr = shr.map((x2) => this.renderer.xscale.invert(x2)).widen(this.max_radius);
      vr = svr.map((y2) => this.renderer.yscale.invert(y2)).widen(this.max_radius);
    } else {
      hr = shr.widen(this.max_size).map((x2) => this.renderer.xscale.invert(x2));
      vr = svr.widen(this.max_size).map((y2) => this.renderer.yscale.invert(y2));
    }
    return this.index.indices({
      x0: hr.start,
      x1: hr.end,
      y0: vr.start,
      y1: vr.end
    });
  }
  _render(ctx, indices, data2) {
    const { sx, sy, sradius } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sradius_i = sradius[i2];
      if (!isFinite(sx_i + sy_i + sradius_i))
        continue;
      ctx.beginPath();
      ctx.arc(sx_i, sy_i, sradius_i, 0, 2 * Math.PI, false);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const { hit_dilation } = this.model;
    let x0, x1, y0, y1;
    if (this.use_radius && this.model.properties.radius.units == "data") {
      x0 = x2 - this.max_radius * hit_dilation;
      x1 = x2 + this.max_radius * hit_dilation;
      y0 = y2 - this.max_radius * hit_dilation;
      y1 = y2 + this.max_radius * hit_dilation;
    } else {
      const sx0 = sx - this.max_size * hit_dilation;
      const sx1 = sx + this.max_size * hit_dilation;
      [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
      const sy0 = sy - this.max_size * hit_dilation;
      const sy1 = sy + this.max_size * hit_dilation;
      [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    }
    const candidates = this.index.indices({ x0, x1, y0, y1 });
    const indices = [];
    if (this.use_radius && this.model.properties.radius.units == "data") {
      for (const i2 of candidates) {
        const r2 = (this.sradius[i2] * hit_dilation) ** 2;
        const [sx0, sx1] = this.renderer.xscale.r_compute(x2, this._x[i2]);
        const [sy0, sy1] = this.renderer.yscale.r_compute(y2, this._y[i2]);
        const dist = (sx0 - sx1) ** 2 + (sy0 - sy1) ** 2;
        if (dist <= r2) {
          indices.push(i2);
        }
      }
    } else {
      for (const i2 of candidates) {
        const r2 = (this.sradius[i2] * hit_dilation) ** 2;
        const dist = (this.sx[i2] - sx) ** 2 + (this.sy[i2] - sy) ** 2;
        if (dist <= r2) {
          indices.push(i2);
        }
      }
    }
    return new Selection({ indices });
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    const bounds = this.bounds();
    let x0, x1, y0, y1;
    if (geometry.direction == "h") {
      let sx0, sx1;
      y0 = bounds.y0;
      y1 = bounds.y1;
      if (this.use_radius && this.model.properties.radius.units == "data") {
        sx0 = sx - this.max_radius;
        sx1 = sx + this.max_radius;
        [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
      } else {
        const ms2 = this.max_size / 2;
        sx0 = sx - ms2;
        sx1 = sx + ms2;
        [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
      }
    } else {
      let sy0, sy1;
      x0 = bounds.x0;
      x1 = bounds.x1;
      if (this.use_radius && this.model.properties.radius.units == "data") {
        sy0 = sy - this.max_radius;
        sy1 = sy + this.max_radius;
        [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
      } else {
        const ms2 = this.max_size / 2;
        sy0 = sy - ms2;
        sy1 = sy + ms2;
        [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
      }
    }
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  _hit_rect(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  _hit_poly(geometry) {
    const { sx, sy } = geometry;
    const candidates = range(0, this.sx.length);
    const indices = [];
    for (let i2 = 0, end = candidates.length; i2 < end; i2++) {
      const index2 = candidates[i2];
      if (point_in_poly(this.sx[i2], this.sy[i2], sx, sy)) {
        indices.push(index2);
      }
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, { x0, y0, x1, y1 }, index2) {
    const len = index2 + 1;
    const sx = new Array(len);
    sx[index2] = (x0 + x1) / 2;
    const sy = new Array(len);
    sy[index2] = (y0 + y1) / 2;
    const sradius = new Array(len);
    sradius[index2] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.2;
    this._render(ctx, [index2], { sx, sy, sradius });
  }
}
CircleView.__name__ = "CircleView";
class Circle extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2g = Circle;
Circle.__name__ = "Circle";
(() => {
  _a$2g.prototype.default_view = CircleView;
  _a$2g.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$2g.define(({ Number: Number2 }) => ({
    angle: [AngleSpec, 0],
    size: [ScreenSizeSpec, { value: 4 }],
    radius: [NullDistanceSpec, null],
    radius_dimension: [RadiusDimension, "x"],
    hit_dilation: [Number2, 1]
  }));
})();
var _a$2f;
class CenterRotatableView extends XYGlyphView {
  get max_w2() {
    return this.model.properties.width.units == "data" ? this.max_width / 2 : 0;
  }
  get max_h2() {
    return this.model.properties.height.units == "data" ? this.max_height / 2 : 0;
  }
  _bounds({ x0, x1, y0, y1 }) {
    const { max_w2, max_h2 } = this;
    return {
      x0: x0 - max_w2,
      x1: x1 + max_w2,
      y0: y0 - max_h2,
      y1: y1 + max_h2
    };
  }
}
CenterRotatableView.__name__ = "CenterRotatableView";
class CenterRotatable extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2f = CenterRotatable;
CenterRotatable.__name__ = "CenterRotatable";
(() => {
  _a$2f.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$2f.define(({}) => ({
    angle: [AngleSpec, 0],
    width: [DistanceSpec, { field: "width" }],
    height: [DistanceSpec, { field: "height" }]
  }));
})();
class EllipseOvalView extends CenterRotatableView {
  _map_data() {
    if (this.model.properties.width.units == "data")
      this.sw = this.sdist(this.renderer.xscale, this._x, this.width, "center");
    else
      this.sw = to_screen(this.width);
    if (this.model.properties.height.units == "data")
      this.sh = this.sdist(this.renderer.yscale, this._y, this.height, "center");
    else
      this.sh = to_screen(this.height);
  }
  _render(ctx, indices, data2) {
    const { sx, sy, sw, sh, angle } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sw_i = sw[i2];
      const sh_i = sh[i2];
      const angle_i = angle.get(i2);
      if (!isFinite(sx_i + sy_i + sw_i + sh_i + angle_i))
        continue;
      ctx.beginPath();
      ctx.ellipse(sx_i, sy_i, sw_i / 2, sh_i / 2, angle_i, 0, 2 * Math.PI);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    let x0, x1, y0, y1, cond, sx0, sx1, sy0, sy1;
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    if (this.model.properties.width.units == "data") {
      x0 = x2 - this.max_width;
      x1 = x2 + this.max_width;
    } else {
      sx0 = sx - this.max_width;
      sx1 = sx + this.max_width;
      [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    }
    if (this.model.properties.height.units == "data") {
      y0 = y2 - this.max_height;
      y1 = y2 + this.max_height;
    } else {
      sy0 = sy - this.max_height;
      sy1 = sy + this.max_height;
      [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    }
    const candidates = this.index.indices({ x0, x1, y0, y1 });
    const indices = [];
    for (const i2 of candidates) {
      cond = point_in_ellipse(sx, sy, this.angle.get(i2), this.sh[i2] / 2, this.sw[i2] / 2, this.sx[i2], this.sy[i2]);
      if (cond) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, { x0, y0, x1, y1 }, index2) {
    const n2 = index2 + 1;
    const sx = new Array(n2);
    sx[index2] = (x0 + x1) / 2;
    const sy = new Array(n2);
    sy[index2] = (y0 + y1) / 2;
    const scale = this.sw[index2] / this.sh[index2];
    const d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
    const sw = new Array(n2);
    const sh = new Array(n2);
    if (scale > 1) {
      sw[index2] = d;
      sh[index2] = d / scale;
    } else {
      sw[index2] = d * scale;
      sh[index2] = d;
    }
    const angle = new UniformScalar(0, n2);
    this._render(ctx, [index2], { sx, sy, sw, sh, angle });
  }
}
EllipseOvalView.__name__ = "EllipseOvalView";
class EllipseOval extends CenterRotatable {
  constructor(attrs) {
    super(attrs);
  }
}
EllipseOval.__name__ = "EllipseOval";
var _a$2e;
class EllipseView extends EllipseOvalView {
}
EllipseView.__name__ = "EllipseView";
class Ellipse extends EllipseOval {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2e = Ellipse;
Ellipse.__name__ = "Ellipse";
(() => {
  _a$2e.prototype.default_view = EllipseView;
})();
var _a$2d;
class BoxView$1 extends GlyphView {
  get_anchor_point(anchor, i2, _spt) {
    const left2 = Math.min(this.sleft[i2], this.sright[i2]);
    const right2 = Math.max(this.sright[i2], this.sleft[i2]);
    const top = Math.min(this.stop[i2], this.sbottom[i2]);
    const bottom = Math.max(this.sbottom[i2], this.stop[i2]);
    switch (anchor) {
      case "top_left":
        return { x: left2, y: top };
      case "top":
      case "top_center":
        return { x: (left2 + right2) / 2, y: top };
      case "top_right":
        return { x: right2, y: top };
      case "bottom_left":
        return { x: left2, y: bottom };
      case "bottom":
      case "bottom_center":
        return { x: (left2 + right2) / 2, y: bottom };
      case "bottom_right":
        return { x: right2, y: bottom };
      case "left":
      case "center_left":
        return { x: left2, y: (top + bottom) / 2 };
      case "center":
      case "center_center":
        return { x: (left2 + right2) / 2, y: (top + bottom) / 2 };
      case "right":
      case "center_right":
        return { x: right2, y: (top + bottom) / 2 };
    }
  }
  _index_data(index2) {
    const { min: min2, max: max2 } = Math;
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const [l, r, t, b] = this._lrtb(i2);
      index2.add_rect(min2(l, r), min2(t, b), max2(r, l), max2(t, b));
    }
  }
  _render(ctx, indices, data2) {
    const { sleft, sright, stop, sbottom } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sleft_i = sleft[i2];
      const stop_i = stop[i2];
      const sright_i = sright[i2];
      const sbottom_i = sbottom[i2];
      if (!isFinite(sleft_i + stop_i + sright_i + sbottom_i))
        continue;
      ctx.beginPath();
      ctx.rect(sleft_i, stop_i, sright_i - sleft_i, sbottom_i - stop_i);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _clamp_viewport() {
    const hr = this.renderer.plot_view.frame.bbox.h_range;
    const vr = this.renderer.plot_view.frame.bbox.v_range;
    const n2 = this.stop.length;
    for (let i2 = 0; i2 < n2; i2++) {
      this.stop[i2] = Math.max(this.stop[i2], vr.start);
      this.sbottom[i2] = Math.min(this.sbottom[i2], vr.end);
      this.sleft[i2] = Math.max(this.sleft[i2], hr.start);
      this.sright[i2] = Math.min(this.sright[i2], hr.end);
    }
  }
  _hit_rect(geometry) {
    return this._hit_rect_against_index(geometry);
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const indices = [...this.index.indices({ x0: x2, y0: y2, x1: x2, y1: y2 })];
    return new Selection({ indices });
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    let indices;
    if (geometry.direction == "v") {
      const y2 = this.renderer.yscale.invert(sy);
      const hr = this.renderer.plot_view.frame.bbox.h_range;
      const [x0, x1] = this.renderer.xscale.r_invert(hr.start, hr.end);
      indices = [...this.index.indices({ x0, y0: y2, x1, y1: y2 })];
    } else {
      const x2 = this.renderer.xscale.invert(sx);
      const vr = this.renderer.plot_view.frame.bbox.v_range;
      const [y0, y1] = this.renderer.yscale.r_invert(vr.start, vr.end);
      indices = [...this.index.indices({ x0: x2, y0, x1: x2, y1 })];
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
BoxView$1.__name__ = "BoxView";
class Box$1 extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2d = Box$1;
Box$1.__name__ = "Box";
(() => {
  _a$2d.mixins([LineVector$1, FillVector$1, HatchVector$1]);
})();
var _a$2c;
class HBarView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { LRTBGL: LRTBGL2 } = await Promise.resolve().then(function() {
        return lrtb;
      });
      this.glglyph = new LRTBGL2(webgl.regl_wrapper, this);
    }
  }
  scenterxy(i2) {
    const scx = (this.sleft[i2] + this.sright[i2]) / 2;
    const scy = this.sy[i2];
    return [scx, scy];
  }
  _lrtb(i2) {
    const left_i = this._left[i2];
    const right_i = this._right[i2];
    const y_i = this._y[i2];
    const half_height_i = this.height.get(i2) / 2;
    const l = Math.min(left_i, right_i);
    const r = Math.max(left_i, right_i);
    const t = y_i + half_height_i;
    const b = y_i - half_height_i;
    return [l, r, t, b];
  }
  _map_data() {
    this.sy = this.renderer.yscale.v_compute(this._y);
    this.sh = this.sdist(this.renderer.yscale, this._y, this.height, "center");
    this.sleft = this.renderer.xscale.v_compute(this._left);
    this.sright = this.renderer.xscale.v_compute(this._right);
    const n2 = this.sy.length;
    this.stop = new ScreenArray(n2);
    this.sbottom = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      this.stop[i2] = this.sy[i2] - this.sh[i2] / 2;
      this.sbottom[i2] = this.sy[i2] + this.sh[i2] / 2;
    }
    this._clamp_viewport();
  }
}
HBarView.__name__ = "HBarView";
class HBar extends Box$1 {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2c = HBar;
HBar.__name__ = "HBar";
(() => {
  _a$2c.prototype.default_view = HBarView;
  _a$2c.define(({}) => ({
    left: [XCoordinateSpec, { value: 0 }],
    y: [YCoordinateSpec, { field: "y" }],
    height: [NumberSpec, { value: 1 }],
    right: [XCoordinateSpec, { field: "right" }]
  }));
})();
var _a$2b;
class HexTileView extends GlyphView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { HexTileGL: HexTileGL2 } = await Promise.resolve().then(function() {
        return hex_tile;
      });
      this.glglyph = new HexTileGL2(webgl.regl_wrapper, this);
    }
  }
  scenterxy(i2) {
    const scx = this.sx[i2];
    const scy = this.sy[i2];
    return [scx, scy];
  }
  _set_data() {
    const { orientation, size: size2, aspect_scale } = this.model;
    const { q, r } = this;
    const n2 = this.q.length;
    this._x = new Float64Array(n2);
    this._y = new Float64Array(n2);
    const { _x: _x2, _y } = this;
    const sqrt3 = Math.sqrt(3);
    if (orientation == "pointytop") {
      for (let i2 = 0; i2 < n2; i2++) {
        const q_i = q.get(i2);
        const r2_i = r.get(i2) / 2;
        _x2[i2] = size2 * sqrt3 * (q_i + r2_i) / aspect_scale;
        _y[i2] = -3 * size2 * r2_i;
      }
    } else {
      for (let i2 = 0; i2 < n2; i2++) {
        const q2_i = q.get(i2) / 2;
        const r_i = r.get(i2);
        _x2[i2] = 3 * size2 * q2_i;
        _y[i2] = -size2 * sqrt3 * (r_i + q2_i) * aspect_scale;
      }
    }
  }
  _project_data() {
    inplace.project_xy(this._x, this._y);
  }
  _index_data(index2) {
    let ysize = this.model.size;
    let xsize = Math.sqrt(3) * ysize / 2;
    if (this.model.orientation == "flattop") {
      [xsize, ysize] = [ysize, xsize];
      ysize *= this.model.aspect_scale;
    } else
      xsize /= this.model.aspect_scale;
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x2 = this._x[i2];
      const y2 = this._y[i2];
      index2.add_rect(x2 - xsize, y2 - ysize, x2 + xsize, y2 + ysize);
    }
  }
  map_data() {
    var _a2;
    [this.sx, this.sy] = this.renderer.coordinates.map_to_screen(this._x, this._y);
    [this.svx, this.svy] = this._get_unscaled_vertices();
    (_a2 = this.glglyph) == null ? void 0 : _a2.set_data_changed();
  }
  _get_unscaled_vertices() {
    const size2 = this.model.size;
    const aspect_scale = this.model.aspect_scale;
    if (this.model.orientation == "pointytop") {
      const rscale = this.renderer.yscale;
      const hscale = this.renderer.xscale;
      const r = Math.abs(rscale.compute(0) - rscale.compute(size2));
      const h2 = Math.sqrt(3) / 2 * Math.abs(hscale.compute(0) - hscale.compute(size2)) / aspect_scale;
      const r2 = r / 2;
      const svx = [0, -h2, -h2, 0, h2, h2];
      const svy = [r, r2, -r2, -r, -r2, r2];
      return [svx, svy];
    } else {
      const rscale = this.renderer.xscale;
      const hscale = this.renderer.yscale;
      const r = Math.abs(rscale.compute(0) - rscale.compute(size2));
      const h2 = Math.sqrt(3) / 2 * Math.abs(hscale.compute(0) - hscale.compute(size2)) * aspect_scale;
      const r2 = r / 2;
      const svx = [r, r2, -r2, -r, -r2, r2];
      const svy = [0, -h2, -h2, 0, h2, h2];
      return [svx, svy];
    }
  }
  _render(ctx, indices, data2) {
    const { sx, sy, svx, svy, scale } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const scale_i = scale.get(i2);
      if (!isFinite(sx_i + sy_i + scale_i))
        continue;
      ctx.translate(sx_i, sy_i);
      ctx.beginPath();
      for (let j = 0; j < 6; j++) {
        ctx.lineTo(svx[j] * scale_i, svy[j] * scale_i);
      }
      ctx.closePath();
      ctx.translate(-sx_i, -sy_i);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const candidates = this.index.indices({ x0: x2, y0: y2, x1: x2, y1: y2 });
    const indices = [];
    for (const i2 of candidates) {
      if (point_in_poly(sx - this.sx[i2], sy - this.sy[i2], this.svx, this.svy)) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    let indices;
    if (geometry.direction == "v") {
      const y2 = this.renderer.yscale.invert(sy);
      const hr = this.renderer.plot_view.frame.bbox.h_range;
      const [x0, x1] = this.renderer.xscale.r_invert(hr.start, hr.end);
      indices = [...this.index.indices({ x0, y0: y2, x1, y1: y2 })];
    } else {
      const x2 = this.renderer.xscale.invert(sx);
      const vr = this.renderer.plot_view.frame.bbox.v_range;
      const [y0, y1] = this.renderer.yscale.r_invert(vr.start, vr.end);
      indices = [...this.index.indices({ x0: x2, y0, x1: x2, y1 })];
    }
    return new Selection({ indices });
  }
  _hit_rect(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
HexTileView.__name__ = "HexTileView";
class HexTile extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2b = HexTile;
HexTile.__name__ = "HexTile";
(() => {
  _a$2b.prototype.default_view = HexTileView;
  _a$2b.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$2b.define(({ Number: Number2 }) => ({
    r: [NumberSpec, { field: "r" }],
    q: [NumberSpec, { field: "q" }],
    scale: [NumberSpec, 1],
    size: [Number2, 1],
    aspect_scale: [Number2, 1],
    orientation: [HexTileOrientation, "pointytop"]
  }));
  _a$2b.override({ line_color: null });
})();
var _a$2a;
class ImageBaseView extends XYGlyphView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.global_alpha.change, () => this.renderer.request_render());
  }
  _render(ctx, indices, data2) {
    const { image_data, sx, sy, sw, sh, global_alpha } = data2 != null ? data2 : this;
    const old_smoothing = ctx.getImageSmoothingEnabled();
    ctx.setImageSmoothingEnabled(false);
    const scalar_alpha = global_alpha.is_Scalar();
    if (scalar_alpha)
      ctx.globalAlpha = global_alpha.value;
    for (const i2 of indices) {
      const image_data_i = image_data[i2];
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sw_i = sw[i2];
      const sh_i = sh[i2];
      const alpha_i = this.global_alpha.get(i2);
      if (image_data_i == null || !isFinite(sx_i + sy_i + sw_i + sh_i + alpha_i))
        continue;
      if (!scalar_alpha)
        ctx.globalAlpha = alpha_i;
      const y_offset = sy_i;
      ctx.translate(0, y_offset);
      ctx.scale(1, -1);
      ctx.translate(0, -y_offset);
      ctx.drawImage(image_data_i, sx_i | 0, sy_i | 0, sw_i, sh_i);
      ctx.translate(0, y_offset);
      ctx.scale(1, -1);
      ctx.translate(0, -y_offset);
    }
    ctx.setImageSmoothingEnabled(old_smoothing);
  }
  _set_data(indices) {
    this._set_width_heigh_data();
    for (let i2 = 0, end = this.image.length; i2 < end; i2++) {
      if (indices != null && indices.indexOf(i2) < 0)
        continue;
      const img = this.image.get(i2);
      let flat_img;
      if (is_NDArray(img)) {
        assert(img.dimension == 2, "expected a 2D array");
        flat_img = img;
        this._height[i2] = img.shape[0];
        this._width[i2] = img.shape[1];
      } else {
        flat_img = concat$1(img);
        this._height[i2] = img.length;
        this._width[i2] = img[0].length;
      }
      const buf8 = this._flat_img_to_buf8(flat_img);
      this._set_image_data_from_buffer(i2, buf8);
    }
  }
  _index_data(index2) {
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const [l, r, t, b] = this._lrtb(i2);
      index2.add_rect(l, b, r, t);
    }
  }
  _lrtb(i2) {
    const dw_i = this.dw.get(i2);
    const dh_i = this.dh.get(i2);
    const xr = this.renderer.xscale.source_range;
    const x1 = this._x[i2];
    const x2 = xr.is_reversed ? x1 - dw_i : x1 + dw_i;
    const yr = this.renderer.yscale.source_range;
    const y1 = this._y[i2];
    const y2 = yr.is_reversed ? y1 - dh_i : y1 + dh_i;
    const [l, r] = x1 < x2 ? [x1, x2] : [x2, x1];
    const [b, t] = y1 < y2 ? [y1, y2] : [y2, y1];
    return [l, r, t, b];
  }
  _set_width_heigh_data() {
    if (this.image_data == null || this.image_data.length != this.image.length)
      this.image_data = new Array(this.image.length);
    if (this._width == null || this._width.length != this.image.length)
      this._width = new Uint32Array(this.image.length);
    if (this._height == null || this._height.length != this.image.length)
      this._height = new Uint32Array(this.image.length);
  }
  _get_or_create_canvas(i2) {
    const _image_data = this.image_data[i2];
    if (_image_data != null && _image_data.width == this._width[i2] && _image_data.height == this._height[i2])
      return _image_data;
    else {
      const canvas2 = document.createElement("canvas");
      canvas2.width = this._width[i2];
      canvas2.height = this._height[i2];
      return canvas2;
    }
  }
  _set_image_data_from_buffer(i2, buf8) {
    const canvas2 = this._get_or_create_canvas(i2);
    const ctx = canvas2.getContext("2d");
    const image_data = ctx.getImageData(0, 0, this._width[i2], this._height[i2]);
    image_data.data.set(buf8);
    ctx.putImageData(image_data, 0, 0);
    this.image_data[i2] = canvas2;
  }
  _map_data() {
    if (this.model.properties.dw.units == "data")
      this.sw = this.sdist(this.renderer.xscale, this._x, this.dw, "edge", this.model.dilate);
    else
      this.sw = to_screen(this.dw);
    if (this.model.properties.dh.units == "data")
      this.sh = this.sdist(this.renderer.yscale, this._y, this.dh, "edge", this.model.dilate);
    else
      this.sh = to_screen(this.dh);
  }
  _image_index(index2, x2, y2) {
    const [l, r, t, b] = this._lrtb(index2);
    const width = this._width[index2];
    const height = this._height[index2];
    const dx = (r - l) / width;
    const dy = (t - b) / height;
    let dim1 = Math.floor((x2 - l) / dx);
    let dim2 = Math.floor((y2 - b) / dy);
    if (this.renderer.xscale.source_range.is_reversed)
      dim1 = width - dim1 - 1;
    if (this.renderer.yscale.source_range.is_reversed)
      dim2 = height - dim2 - 1;
    return { index: index2, dim1, dim2, flat_index: dim2 * width + dim1 };
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const candidates = this.index.indices({ x0: x2, x1: x2, y0: y2, y1: y2 });
    const result = new Selection();
    for (const index2 of candidates) {
      if (sx != Infinity && sy != Infinity) {
        result.image_indices.push(this._image_index(index2, x2, y2));
      }
    }
    return result;
  }
}
ImageBaseView.__name__ = "ImageBaseView";
class ImageBase extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$2a = ImageBase;
ImageBase.__name__ = "ImageBase";
(() => {
  _a$2a.define(({ Boolean: Boolean2 }) => ({
    image: [NDArraySpec, { field: "image" }],
    dw: [DistanceSpec, { field: "dw" }],
    dh: [DistanceSpec, { field: "dh" }],
    global_alpha: [NumberSpec, { value: 1 }],
    dilate: [Boolean2, false]
  }));
})();
var _a$29;
class ImageView extends ImageBaseView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.color_mapper.change, () => this._update_image());
  }
  _update_image() {
    if (this.image_data != null) {
      this._set_data(null);
      this.renderer.request_render();
    }
  }
  _flat_img_to_buf8(img) {
    const cmap = this.model.color_mapper.rgba_mapper;
    return cmap.v_compute(img);
  }
}
ImageView.__name__ = "ImageView";
const Greys9 = () => ["#000000", "#252525", "#525252", "#737373", "#969696", "#bdbdbd", "#d9d9d9", "#f0f0f0", "#ffffff"];
class Image$1 extends ImageBase {
  constructor(attrs) {
    super(attrs);
  }
}
_a$29 = Image$1;
Image$1.__name__ = "Image";
(() => {
  _a$29.prototype.default_view = ImageView;
  _a$29.define(({ Ref: Ref2 }) => ({
    color_mapper: [Ref2(ColorMapper), () => new LinearColorMapper({ palette: Greys9() })]
  }));
})();
var _a$28;
class ImageRGBAView extends ImageBaseView {
  _flat_img_to_buf8(img) {
    let array;
    if (isArray(img)) {
      array = new Uint32Array(img);
    } else {
      array = img;
    }
    return new Uint8ClampedArray(array.buffer);
  }
}
ImageRGBAView.__name__ = "ImageRGBAView";
class ImageRGBA extends ImageBase {
  constructor(attrs) {
    super(attrs);
  }
}
_a$28 = ImageRGBA;
ImageRGBA.__name__ = "ImageRGBA";
(() => {
  _a$28.prototype.default_view = ImageRGBAView;
})();
var _a$27;
class ImageURLView extends XYGlyphView {
  constructor() {
    super(...arguments);
    this._images_rendered = false;
    this._set_data_iteration = 0;
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.global_alpha.change, () => this.renderer.request_render());
  }
  _index_data(index2) {
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      index2.add_empty();
    }
  }
  _set_data() {
    this._set_data_iteration++;
    const n_urls = this.url.length;
    this.image = new Array(n_urls);
    const { retry_attempts, retry_timeout } = this.model;
    const { _set_data_iteration } = this;
    for (let i2 = 0; i2 < n_urls; i2++) {
      const url = this.url.get(i2);
      if (!url)
        continue;
      new ImageLoader(url, {
        loaded: (image) => {
          if (this._set_data_iteration == _set_data_iteration) {
            this.image[i2] = image;
            this.renderer.request_render();
          }
        },
        attempts: retry_attempts + 1,
        timeout: retry_timeout
      });
    }
    const w_data = this.model.properties.w.units == "data";
    const h_data = this.model.properties.h.units == "data";
    const n2 = this._x.length;
    const xs = new ScreenArray(w_data ? 2 * n2 : n2);
    const ys = new ScreenArray(h_data ? 2 * n2 : n2);
    const { anchor } = this.model;
    function x0x1(x2, w) {
      switch (anchor) {
        case "top_left":
        case "bottom_left":
        case "left":
        case "center_left":
          return [x2, x2 + w];
        case "top":
        case "top_center":
        case "bottom":
        case "bottom_center":
        case "center":
        case "center_center":
          return [x2 - w / 2, x2 + w / 2];
        case "top_right":
        case "bottom_right":
        case "right":
        case "center_right":
          return [x2 - w, x2];
      }
    }
    function y0y1(y2, h2) {
      switch (anchor) {
        case "top_left":
        case "top":
        case "top_center":
        case "top_right":
          return [y2, y2 - h2];
        case "bottom_left":
        case "bottom":
        case "bottom_center":
        case "bottom_right":
          return [y2 + h2, y2];
        case "left":
        case "center_left":
        case "center":
        case "center_center":
        case "right":
        case "center_right":
          return [y2 + h2 / 2, y2 - h2 / 2];
      }
    }
    if (w_data) {
      for (let i2 = 0; i2 < n2; i2++) {
        [xs[i2], xs[n2 + i2]] = x0x1(this._x[i2], this.w.get(i2));
      }
    } else
      xs.set(this._x, 0);
    if (h_data) {
      for (let i2 = 0; i2 < n2; i2++) {
        [ys[i2], ys[n2 + i2]] = y0y1(this._y[i2], this.h.get(i2));
      }
    } else
      ys.set(this._y, 0);
    const [x0, x1] = minmax(xs);
    const [y0, y1] = minmax(ys);
    this._bounds_rect = { x0, x1, y0, y1 };
  }
  has_finished() {
    return super.has_finished() && this._images_rendered == true;
  }
  _map_data() {
    if (this.model.properties.w.units == "data")
      this.sw = this.sdist(this.renderer.xscale, this._x, this.w, "edge", this.model.dilate);
    else
      this.sw = to_screen(this.w);
    if (this.model.properties.h.units == "data")
      this.sh = this.sdist(this.renderer.yscale, this._y, this.h, "edge", this.model.dilate);
    else
      this.sh = to_screen(this.h);
  }
  _render(ctx, indices, data2) {
    const { image, sx, sy, sw, sh, angle, global_alpha } = data2 != null ? data2 : this;
    const { frame } = this.renderer.plot_view;
    ctx.beginPath();
    ctx.rect(frame.bbox.left + 1, frame.bbox.top + 1, frame.bbox.width - 2, frame.bbox.height - 2);
    ctx.clip();
    let finished = true;
    for (const i2 of indices) {
      if (!isFinite(sx[i2] + sy[i2] + angle.get(i2) + global_alpha.get(i2)))
        continue;
      const img = image[i2];
      if (img == null) {
        finished = false;
        continue;
      }
      this._render_image(ctx, i2, img, sx, sy, sw, sh, angle, global_alpha);
    }
    if (finished && !this._images_rendered) {
      this._images_rendered = true;
      this.notify_finished();
    }
  }
  _final_sx_sy(anchor, sx, sy, sw, sh) {
    switch (anchor) {
      case "top_left":
        return [sx, sy];
      case "top":
      case "top_center":
        return [sx - sw / 2, sy];
      case "top_right":
        return [sx - sw, sy];
      case "right":
      case "center_right":
        return [sx - sw, sy - sh / 2];
      case "bottom_right":
        return [sx - sw, sy - sh];
      case "bottom":
      case "bottom_center":
        return [sx - sw / 2, sy - sh];
      case "bottom_left":
        return [sx, sy - sh];
      case "left":
      case "center_left":
        return [sx, sy - sh / 2];
      case "center":
      case "center_center":
        return [sx - sw / 2, sy - sh / 2];
    }
  }
  _render_image(ctx, i2, image, sx, sy, sw, sh, angle, alpha) {
    if (!isFinite(sw[i2]))
      sw[i2] = image.width;
    if (!isFinite(sh[i2]))
      sh[i2] = image.height;
    const sw_i = sw[i2];
    const sh_i = sh[i2];
    const { anchor } = this.model;
    const [sx_i, sy_i] = this._final_sx_sy(anchor, sx[i2], sy[i2], sw_i, sh_i);
    const angle_i = angle.get(i2);
    const alpha_i = alpha.get(i2);
    ctx.save();
    ctx.globalAlpha = alpha_i;
    const sw2 = sw_i / 2;
    const sh2 = sh_i / 2;
    if (angle_i) {
      ctx.translate(sx_i, sy_i);
      ctx.translate(sw2, sh2);
      ctx.rotate(angle_i);
      ctx.translate(-sw2, -sh2);
      ctx.drawImage(image, 0, 0, sw_i, sh_i);
      ctx.translate(sw2, sh2);
      ctx.rotate(-angle_i);
      ctx.translate(-sw2, -sh2);
      ctx.translate(-sx_i, -sy_i);
    } else
      ctx.drawImage(image, sx_i, sy_i, sw_i, sh_i);
    ctx.restore();
  }
  bounds() {
    return this._bounds_rect;
  }
}
ImageURLView.__name__ = "ImageURLView";
class ImageURL extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$27 = ImageURL;
ImageURL.__name__ = "ImageURL";
(() => {
  _a$27.prototype.default_view = ImageURLView;
  _a$27.define(({ Boolean: Boolean2, Int: Int2 }) => ({
    url: [StringSpec, { field: "url" }],
    anchor: [Anchor, "top_left"],
    global_alpha: [NumberSpec, { value: 1 }],
    angle: [AngleSpec, 0],
    w: [NullDistanceSpec, null],
    h: [NullDistanceSpec, null],
    dilate: [Boolean2, false],
    retry_attempts: [Int2, 0],
    retry_timeout: [Int2, 0]
  }));
})();
var _a$26;
class MultiLineView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._xs.array, this._ys.array);
  }
  _index_data(index2) {
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const xsi = this._xs.get(i2);
      const ysi = this._ys.get(i2);
      const [x0, x1, y0, y1] = minmax2(xsi, ysi);
      index2.add_rect(x0, y0, x1, y1);
    }
  }
  _render(ctx, indices, data2) {
    const { sxs, sys } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx = sxs.get(i2);
      const sy = sys.get(i2);
      const n2 = Math.min(sx.length, sy.length);
      let move = true;
      ctx.beginPath();
      for (let j = 0; j < n2; j++) {
        const sx_j = sx[j];
        const sy_j = sy[j];
        if (!isFinite(sx_j + sy_j))
          move = true;
        else {
          if (move) {
            ctx.moveTo(sx_j, sy_j);
            move = false;
          } else
            ctx.lineTo(sx_j, sy_j);
        }
      }
      this.visuals.line.set_vectorize(ctx, i2);
      ctx.stroke();
    }
  }
  _hit_point(geometry) {
    const point = { x: geometry.sx, y: geometry.sy };
    let shortest = 9999;
    const hits = /* @__PURE__ */ new Map();
    for (let i2 = 0, end = this.sxs.length; i2 < end; i2++) {
      const threshold = Math.max(2, this.line_width.get(i2) / 2);
      const sxsi = this.sxs.get(i2);
      const sysi = this.sys.get(i2);
      let points = null;
      for (let j = 0, endj = sxsi.length - 1; j < endj; j++) {
        const p0 = { x: sxsi[j], y: sysi[j] };
        const p1 = { x: sxsi[j + 1], y: sysi[j + 1] };
        const dist = dist_to_segment(point, p0, p1);
        if (dist < threshold && dist < shortest) {
          shortest = dist;
          points = [j];
        }
      }
      if (points != null) {
        hits.set(i2, points);
      }
    }
    return new Selection({
      indices: [...hits.keys()],
      multiline_indices: to_object(hits)
    });
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    let val;
    let vs;
    if (geometry.direction == "v") {
      val = this.renderer.yscale.invert(sy);
      vs = this._ys;
    } else {
      val = this.renderer.xscale.invert(sx);
      vs = this._xs;
    }
    const hits = /* @__PURE__ */ new Map();
    for (let i2 = 0, end = vs.length; i2 < end; i2++) {
      const vsi = vs.get(i2);
      const points = [];
      for (let j = 0, endj = vsi.length - 1; j < endj; j++) {
        if (vsi[j] <= val && val <= vsi[j + 1])
          points.push(j);
      }
      if (points.length > 0) {
        hits.set(i2, points);
      }
    }
    return new Selection({
      indices: [...hits.keys()],
      multiline_indices: to_object(hits)
    });
  }
  get_interpolation_hit(i2, point_i, geometry) {
    const xsi = this._xs.get(i2);
    const ysi = this._ys.get(i2);
    const x2 = xsi[point_i];
    const y2 = ysi[point_i];
    const x3 = xsi[point_i + 1];
    const y3 = ysi[point_i + 1];
    return line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
MultiLineView.__name__ = "MultiLineView";
class MultiLine extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$26 = MultiLine;
MultiLine.__name__ = "MultiLine";
(() => {
  _a$26.prototype.default_view = MultiLineView;
  _a$26.define(({}) => ({
    xs: [XCoordinateSeqSpec, { field: "xs" }],
    ys: [YCoordinateSeqSpec, { field: "ys" }]
  }));
  _a$26.mixins(LineVector$1);
})();
var _a$25;
class MultiPolygonsView extends GlyphView {
  _project_data() {
  }
  _index_data(index2) {
    const { min: min2, max: max2 } = Math;
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const xsi = this._xs[i2];
      const ysi = this._ys[i2];
      if (xsi.length == 0 || ysi.length == 0) {
        index2.add_empty();
        continue;
      }
      let xi0 = Infinity;
      let xi1 = -Infinity;
      let yi0 = Infinity;
      let yi1 = -Infinity;
      for (let j = 0, endj = xsi.length; j < endj; j++) {
        const xsij = xsi[j][0];
        const ysij = ysi[j][0];
        if (xsij.length != 0 && ysij.length != 0) {
          const [xij0, xij1] = minmax(xsij);
          const [yij0, yij1] = minmax(ysij);
          xi0 = min2(xi0, xij0);
          xi1 = max2(xi1, xij1);
          yi0 = min2(yi0, yij0);
          yi1 = max2(yi1, yij1);
        }
      }
      index2.add_rect(xi0, yi0, xi1, yi1);
    }
    this._hole_index = this._index_hole_data();
  }
  _index_hole_data() {
    const { min: min2, max: max2 } = Math;
    const { data_size } = this;
    const index2 = new SpatialIndex(data_size);
    for (let i2 = 0; i2 < data_size; i2++) {
      const xsi = this._xs[i2];
      const ysi = this._ys[i2];
      if (xsi.length == 0 || ysi.length == 0) {
        index2.add_empty();
        continue;
      }
      let xi0 = Infinity;
      let xi1 = -Infinity;
      let yi0 = Infinity;
      let yi1 = -Infinity;
      for (let j = 0, endj = xsi.length; j < endj; j++) {
        const xsij = xsi[j];
        const ysij = ysi[j];
        if (xsij.length > 1 && ysij.length > 1) {
          for (let k = 1, endk = xsij.length; k < endk; k++) {
            const [xij0, xij1] = minmax(xsij[k]);
            const [yij0, yij1] = minmax(ysij[k]);
            xi0 = min2(xi0, xij0);
            xi1 = max2(xi1, xij1);
            yi0 = min2(yi0, yij0);
            yi1 = max2(yi1, yij1);
          }
        }
      }
      index2.add_rect(xi0, yi0, xi1, yi1);
    }
    index2.finish();
    return index2;
  }
  _mask_data() {
    const { x_range, y_range } = this.renderer.plot_view.frame;
    return this.index.indices({
      x0: x_range.min,
      x1: x_range.max,
      y0: y_range.min,
      y1: y_range.max
    });
  }
  _render(ctx, indices, data2) {
    if (this.visuals.fill.doit || this.visuals.line.doit) {
      const { sxs, sys } = data2 != null ? data2 : this;
      for (const i2 of indices) {
        ctx.beginPath();
        const sx_i = sxs[i2];
        const sy_i = sys[i2];
        const nj = Math.min(sx_i.length, sy_i.length);
        for (let j = 0; j < nj; j++) {
          const sx_ij = sx_i[j];
          const sy_ij = sy_i[j];
          const nk = Math.min(sx_ij.length, sy_ij.length);
          for (let k = 0; k < nk; k++) {
            const sx_ijk = sx_ij[k];
            const sy_ijk = sy_ij[k];
            const nl = Math.min(sx_ijk.length, sy_ijk.length);
            for (let l = 0; l < nl; l++) {
              const sx_ijkl = sx_ijk[l];
              const sy_ijkl = sy_ijk[l];
              if (l == 0)
                ctx.moveTo(sx_ijkl, sy_ijkl);
              else
                ctx.lineTo(sx_ijkl, sy_ijkl);
            }
            ctx.closePath();
          }
        }
        this.visuals.fill.apply(ctx, i2, "evenodd");
        this.visuals.hatch.apply(ctx, i2, "evenodd");
        this.visuals.line.apply(ctx, i2);
      }
    }
  }
  _hit_rect(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const xs = [sx0, sx1, sx1, sx0];
    const ys = [sy0, sy0, sy1, sy1];
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const candidates = this.index.indices({ x0, x1, y0, y1 });
    const indices = [];
    for (const index2 of candidates) {
      const sxss = this.sxs[index2];
      const syss = this.sys[index2];
      let hit = true;
      for (let j = 0, endj = sxss.length; j < endj; j++) {
        for (let k = 0, endk = sxss[j][0].length; k < endk; k++) {
          const sx = sxss[j][0][k];
          const sy = syss[j][0][k];
          if (!point_in_poly(sx, sy, xs, ys)) {
            hit = false;
            break;
          }
        }
        if (!hit)
          break;
      }
      if (hit) {
        indices.push(index2);
      }
    }
    return new Selection({ indices });
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const candidates = this.index.indices({ x0: x2, y0: y2, x1: x2, y1: y2 });
    const hole_candidates = this._hole_index.indices({ x0: x2, y0: y2, x1: x2, y1: y2 });
    const indices = [];
    for (const index2 of candidates) {
      const sxs = this.sxs[index2];
      const sys = this.sys[index2];
      for (let j = 0, endj = sxs.length; j < endj; j++) {
        const nk = sxs[j].length;
        if (point_in_poly(sx, sy, sxs[j][0], sys[j][0])) {
          if (nk == 1) {
            indices.push(index2);
          } else if (!hole_candidates.get(index2)) {
            indices.push(index2);
          } else if (nk > 1) {
            let in_a_hole = false;
            for (let k = 1; k < nk; k++) {
              const sxs_k = sxs[j][k];
              const sys_k = sys[j][k];
              if (point_in_poly(sx, sy, sxs_k, sys_k)) {
                in_a_hole = true;
                break;
              } else {
                continue;
              }
            }
            if (!in_a_hole) {
              indices.push(index2);
            }
          }
        }
      }
    }
    return new Selection({ indices });
  }
  _get_snap_coord(array) {
    return sum$2(array) / array.length;
  }
  scenterxy(i2, sx, sy) {
    if (this.sxs[i2].length == 1) {
      const scx = this._get_snap_coord(this.sxs[i2][0][0]);
      const scy = this._get_snap_coord(this.sys[i2][0][0]);
      return [scx, scy];
    } else {
      const sxs = this.sxs[i2];
      const sys = this.sys[i2];
      for (let j = 0, end = sxs.length; j < end; j++) {
        if (point_in_poly(sx, sy, sxs[j][0], sys[j][0])) {
          const scx = this._get_snap_coord(sxs[j][0]);
          const scy = this._get_snap_coord(sys[j][0]);
          return [scx, scy];
        }
      }
    }
    unreachable();
  }
  map_data() {
    const n_i = this._xs.length;
    this.sxs = new Array(n_i);
    this.sys = new Array(n_i);
    for (let i2 = 0; i2 < n_i; i2++) {
      const n_j = this._xs[i2].length;
      this.sxs[i2] = new Array(n_j);
      this.sys[i2] = new Array(n_j);
      for (let j = 0; j < n_j; j++) {
        const n_k = this._xs[i2][j].length;
        this.sxs[i2][j] = new Array(n_k);
        this.sys[i2][j] = new Array(n_k);
        for (let k = 0; k < n_k; k++) {
          const [sx, sy] = this.renderer.coordinates.map_to_screen(this._xs[i2][j][k], this._ys[i2][j][k]);
          this.sxs[i2][j][k] = sx;
          this.sys[i2][j][k] = sy;
        }
      }
    }
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
MultiPolygonsView.__name__ = "MultiPolygonsView";
class MultiPolygons extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$25 = MultiPolygons;
MultiPolygons.__name__ = "MultiPolygons";
(() => {
  _a$25.prototype.default_view = MultiPolygonsView;
  _a$25.define(({}) => ({
    xs: [XCoordinateSeqSeqSeqSpec, { field: "xs" }],
    ys: [YCoordinateSeqSeqSeqSpec, { field: "ys" }]
  }));
  _a$25.mixins([LineVector$1, FillVector$1, HatchVector$1]);
})();
var _a$24;
class OvalView extends EllipseOvalView {
  _map_data() {
    super._map_data();
    mul(this.sw, 0.75);
  }
}
OvalView.__name__ = "OvalView";
class Oval extends EllipseOval {
  constructor(attrs) {
    super(attrs);
  }
}
_a$24 = Oval;
Oval.__name__ = "Oval";
(() => {
  _a$24.prototype.default_view = OvalView;
})();
var _a$23;
class PatchesView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._xs.array, this._ys.array);
  }
  _index_data(index2) {
    const { data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const xsi = this._xs.get(i2);
      const ysi = this._ys.get(i2);
      const [x0, x1, y0, y1] = minmax2(xsi, ysi);
      index2.add_rect(x0, y0, x1, y1);
    }
  }
  _mask_data() {
    const { x_range, y_range } = this.renderer.plot_view.frame;
    return this.index.indices({
      x0: x_range.min,
      x1: x_range.max,
      y0: y_range.min,
      y1: y_range.max
    });
  }
  _render(ctx, indices, data2) {
    const { sxs, sys } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sxs.get(i2);
      const sy_i = sys.get(i2);
      let move = true;
      ctx.beginPath();
      const n2 = Math.min(sx_i.length, sy_i.length);
      for (let j = 0; j < n2; j++) {
        const sx_j = sx_i[j];
        const sy_j = sy_i[j];
        if (!isFinite(sx_j + sy_j)) {
          ctx.closePath();
          move = true;
        } else {
          if (move) {
            ctx.moveTo(sx_j, sy_j);
            move = false;
          } else
            ctx.lineTo(sx_j, sy_j);
        }
      }
      ctx.closePath();
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_rect(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const xs = [sx0, sx1, sx1, sx0];
    const ys = [sy0, sy0, sy1, sy1];
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const candidates = this.index.indices({ x0, x1, y0, y1 });
    const indices = [];
    for (const index2 of candidates) {
      const sxss = this.sxs.get(index2);
      const syss = this.sys.get(index2);
      let hit = true;
      for (let j = 0, endj = sxss.length; j < endj; j++) {
        const sx = sxss[j];
        const sy = syss[j];
        if (!point_in_poly(sx, sy, xs, ys)) {
          hit = false;
          break;
        }
      }
      if (hit) {
        indices.push(index2);
      }
    }
    return new Selection({ indices });
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const candidates = this.index.indices({ x0: x2, y0: y2, x1: x2, y1: y2 });
    const indices = [];
    for (const index2 of candidates) {
      const sxsi = this.sxs.get(index2);
      const sysi = this.sys.get(index2);
      const n2 = sxsi.length;
      for (let k = 0, j = 0; ; j++) {
        if (isNaN(sxsi[j]) || j == n2) {
          const sxsi_kj = sxsi.subarray(k, j);
          const sysi_kj = sysi.subarray(k, j);
          if (point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
            indices.push(index2);
            break;
          }
          k = j + 1;
        }
        if (j == n2)
          break;
      }
    }
    return new Selection({ indices });
  }
  _get_snap_coord(array) {
    return sum$2(array) / array.length;
  }
  scenterxy(i2, sx, sy) {
    const sxsi = this.sxs.get(i2);
    const sysi = this.sys.get(i2);
    const n2 = sxsi.length;
    let has_nan = false;
    for (let k = 0, j = 0; ; j++) {
      const this_nan = isNaN(sxsi[j]);
      has_nan = has_nan || this_nan;
      if (j == n2 && !has_nan) {
        const scx = this._get_snap_coord(sxsi);
        const scy = this._get_snap_coord(sysi);
        return [scx, scy];
      }
      if (this_nan || j == n2) {
        const sxsi_kj = sxsi.subarray(k, j);
        const sysi_kj = sysi.subarray(k, j);
        if (point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
          const scx = this._get_snap_coord(sxsi_kj);
          const scy = this._get_snap_coord(sysi_kj);
          return [scx, scy];
        }
        k = j + 1;
      }
      if (j == n2)
        break;
    }
    unreachable();
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
PatchesView.__name__ = "PatchesView";
class Patches extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$23 = Patches;
Patches.__name__ = "Patches";
(() => {
  _a$23.prototype.default_view = PatchesView;
  _a$23.define(({}) => ({
    xs: [XCoordinateSeqSpec, { field: "xs" }],
    ys: [YCoordinateSeqSpec, { field: "ys" }]
  }));
  _a$23.mixins([LineVector$1, FillVector$1, HatchVector$1]);
})();
var _a$22;
class QuadView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { LRTBGL: LRTBGL2 } = await Promise.resolve().then(function() {
        return lrtb;
      });
      this.glglyph = new LRTBGL2(webgl.regl_wrapper, this);
    }
  }
  scenterxy(i2) {
    const scx = this.sleft[i2] / 2 + this.sright[i2] / 2;
    const scy = this.stop[i2] / 2 + this.sbottom[i2] / 2;
    return [scx, scy];
  }
  _lrtb(i2) {
    const l = this._left[i2];
    const r = this._right[i2];
    const t = this._top[i2];
    const b = this._bottom[i2];
    return [l, r, t, b];
  }
}
QuadView.__name__ = "QuadView";
class Quad extends Box$1 {
  constructor(attrs) {
    super(attrs);
  }
}
_a$22 = Quad;
Quad.__name__ = "Quad";
(() => {
  _a$22.prototype.default_view = QuadView;
  _a$22.define(({}) => ({
    right: [XCoordinateSpec, { field: "right" }],
    bottom: [YCoordinateSpec, { field: "bottom" }],
    left: [XCoordinateSpec, { field: "left" }],
    top: [YCoordinateSpec, { field: "top" }]
  }));
})();
var _a$21;
function _qbb(u, v, w) {
  if (v == (u + w) / 2)
    return [u, w];
  else {
    const t = (u - v) / (u - 2 * v + w);
    const bd = u * (1 - t) ** 2 + 2 * v * (1 - t) * t + w * t ** 2;
    return [Math.min(u, w, bd), Math.max(u, w, bd)];
  }
}
class QuadraticView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0);
    inplace.project_xy(this._x1, this._y1);
  }
  _index_data(index2) {
    const { _x0, _x1, _y0, _y1, _cx, _cy, data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x0_i = _x0[i2];
      const x1_i = _x1[i2];
      const y0_i = _y0[i2];
      const y1_i = _y1[i2];
      const cx_i = _cx[i2];
      const cy_i = _cy[i2];
      if (!isFinite(x0_i + x1_i + y0_i + y1_i + cx_i + cy_i))
        index2.add_empty();
      else {
        const [x0, x1] = _qbb(x0_i, cx_i, x1_i);
        const [y0, y1] = _qbb(y0_i, cy_i, y1_i);
        index2.add_rect(x0, y0, x1, y1);
      }
    }
  }
  _render(ctx, indices, data2) {
    if (this.visuals.line.doit) {
      const { sx0, sy0, sx1, sy1, scx, scy } = data2 != null ? data2 : this;
      for (const i2 of indices) {
        const sx0_i = sx0[i2];
        const sy0_i = sy0[i2];
        const sx1_i = sx1[i2];
        const sy1_i = sy1[i2];
        const scx_i = scx[i2];
        const scy_i = scy[i2];
        if (!isFinite(sx0_i + sy0_i + sx1_i + sy1_i + scx_i + scy_i))
          continue;
        ctx.beginPath();
        ctx.moveTo(sx0_i, sy0_i);
        ctx.quadraticCurveTo(scx_i, scy_i, sx1_i, sy1_i);
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.stroke();
      }
    }
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
  scenterxy() {
    throw new Error(`${this}.scenterxy() is not implemented`);
  }
}
QuadraticView.__name__ = "QuadraticView";
class Quadratic extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$21 = Quadratic;
Quadratic.__name__ = "Quadratic";
(() => {
  _a$21.prototype.default_view = QuadraticView;
  _a$21.define(({}) => ({
    x0: [XCoordinateSpec, { field: "x0" }],
    y0: [YCoordinateSpec, { field: "y0" }],
    x1: [XCoordinateSpec, { field: "x1" }],
    y1: [YCoordinateSpec, { field: "y1" }],
    cx: [XCoordinateSpec, { field: "cx" }],
    cy: [YCoordinateSpec, { field: "cy" }]
  }));
  _a$21.mixins(LineVector$1);
})();
var _a$20;
class RayView extends XYGlyphView {
  _map_data() {
    if (this.model.properties.length.units == "data")
      this.slength = this.sdist(this.renderer.xscale, this._x, this.length);
    else
      this.slength = to_screen(this.length);
    const { width, height } = this.renderer.plot_view.frame.bbox;
    const inf_len = 2 * (width + height);
    const { slength } = this;
    for (let i2 = 0, end = slength.length; i2 < end; i2++) {
      if (slength[i2] == 0)
        slength[i2] = inf_len;
    }
  }
  _render(ctx, indices, data2) {
    const { sx, sy, slength, angle } = data2 != null ? data2 : this;
    if (this.visuals.line.doit) {
      for (const i2 of indices) {
        const sx_i = sx[i2];
        const sy_i = sy[i2];
        const angle_i = angle.get(i2);
        const slength_i = slength[i2];
        if (!isFinite(sx_i + sy_i + angle_i + slength_i))
          continue;
        ctx.translate(sx_i, sy_i);
        ctx.rotate(angle_i);
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(slength_i, 0);
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.stroke();
        ctx.rotate(-angle_i);
        ctx.translate(-sx_i, -sy_i);
      }
    }
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
RayView.__name__ = "RayView";
class Ray extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$20 = Ray;
Ray.__name__ = "Ray";
(() => {
  _a$20.prototype.default_view = RayView;
  _a$20.mixins(LineVector$1);
  _a$20.define(({}) => ({
    length: [DistanceSpec, 0],
    angle: [AngleSpec, 0]
  }));
})();
var _a$1$;
class RectView extends CenterRotatableView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl == null ? void 0 : webgl.regl_wrapper.has_webgl) {
      const { RectGL: RectGL2 } = await Promise.resolve().then(function() {
        return rect;
      });
      this.glglyph = new RectGL2(webgl.regl_wrapper, this);
    }
  }
  _map_data() {
    if (this.model.properties.width.units == "data")
      [this.sw, this.sx0] = this._map_dist_corner_for_data_side_length(this._x, this.width, this.renderer.xscale);
    else {
      this.sw = to_screen(this.width);
      const n3 = this.sx.length;
      this.sx0 = new ScreenArray(n3);
      for (let i2 = 0; i2 < n3; i2++)
        this.sx0[i2] = this.sx[i2] - this.sw[i2] / 2;
    }
    if (this.model.properties.height.units == "data")
      [this.sh, this.sy1] = this._map_dist_corner_for_data_side_length(this._y, this.height, this.renderer.yscale);
    else {
      this.sh = to_screen(this.height);
      const n3 = this.sy.length;
      this.sy1 = new ScreenArray(n3);
      for (let i2 = 0; i2 < n3; i2++)
        this.sy1[i2] = this.sy[i2] - this.sh[i2] / 2;
    }
    const n2 = this.sw.length;
    this.ssemi_diag = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++)
      this.ssemi_diag[i2] = Math.sqrt(this.sw[i2] / 2 * this.sw[i2] / 2 + this.sh[i2] / 2 * this.sh[i2] / 2);
  }
  _render(ctx, indices, data2) {
    const { sx, sy, sx0, sy1, sw, sh, angle } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sx0_i = sx0[i2];
      const sy1_i = sy1[i2];
      const sw_i = sw[i2];
      const sh_i = sh[i2];
      const angle_i = angle.get(i2);
      if (!isFinite(sx_i + sy_i + sx0_i + sy1_i + sw_i + sh_i + angle_i))
        continue;
      if (sw_i == 0 || sh_i == 0)
        continue;
      ctx.beginPath();
      if (angle_i) {
        ctx.translate(sx_i, sy_i);
        ctx.rotate(angle_i);
        ctx.rect(-sw_i / 2, -sh_i / 2, sw_i, sh_i);
        ctx.rotate(-angle_i);
        ctx.translate(-sx_i, -sy_i);
      } else
        ctx.rect(sx0_i, sy1_i, sw_i, sh_i);
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_rect(geometry) {
    return this._hit_rect_against_index(geometry);
  }
  _hit_point(geometry) {
    let { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    const n2 = this.sx0.length;
    const scenter_x = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      scenter_x[i2] = this.sx0[i2] + this.sw[i2] / 2;
    }
    const scenter_y = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      scenter_y[i2] = this.sy1[i2] + this.sh[i2] / 2;
    }
    const max_x2_ddist = max$8(this._ddist(0, scenter_x, this.ssemi_diag));
    const max_y2_ddist = max$8(this._ddist(1, scenter_y, this.ssemi_diag));
    const x0 = x2 - max_x2_ddist;
    const x1 = x2 + max_x2_ddist;
    const y0 = y2 - max_y2_ddist;
    const y1 = y2 + max_y2_ddist;
    let width_in;
    let height_in;
    const indices = [];
    for (const i2 of this.index.indices({ x0, x1, y0, y1 })) {
      const angle_i = this.angle.get(i2);
      if (angle_i) {
        const s = Math.sin(-angle_i);
        const c = Math.cos(-angle_i);
        const px = c * (sx - this.sx[i2]) - s * (sy - this.sy[i2]) + this.sx[i2];
        const py = s * (sx - this.sx[i2]) + c * (sy - this.sy[i2]) + this.sy[i2];
        sx = px;
        sy = py;
        width_in = Math.abs(this.sx[i2] - sx) <= this.sw[i2] / 2;
        height_in = Math.abs(this.sy[i2] - sy) <= this.sh[i2] / 2;
      } else {
        const dx = sx - this.sx0[i2];
        const dy = sy - this.sy1[i2];
        width_in = 0 <= dx && dx <= this.sw[i2];
        height_in = 0 <= dy && dy <= this.sh[i2];
      }
      if (width_in && height_in) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  _map_dist_corner_for_data_side_length(coord, side_length, scale) {
    const n2 = coord.length;
    const pt0 = new Float64Array(n2);
    const pt1 = new Float64Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      const coord_i = coord[i2];
      const half_side_length_i = side_length.get(i2) / 2;
      pt0[i2] = coord_i - half_side_length_i;
      pt1[i2] = coord_i + half_side_length_i;
    }
    const spt0 = scale.v_compute(pt0);
    const spt1 = scale.v_compute(pt1);
    const sside_length = this.sdist(scale, pt0, side_length, "edge", this.model.dilate);
    let spt_corner = spt0;
    for (let i2 = 0; i2 < n2; i2++) {
      const spt0i = spt0[i2];
      const spt1i = spt1[i2];
      if (!isNaN(spt0i + spt1i) && spt0i != spt1i) {
        spt_corner = spt0i < spt1i ? spt0 : spt1;
        break;
      }
    }
    return [sside_length, spt_corner];
  }
  _ddist(dim, spts, spans) {
    const ArrayType = infer_type(spts, spans);
    const scale = dim == 0 ? this.renderer.xscale : this.renderer.yscale;
    const spt0 = spts;
    const m = spt0.length;
    const spt1 = new ArrayType(m);
    for (let i2 = 0; i2 < m; i2++)
      spt1[i2] = spt0[i2] + spans[i2];
    const pt0 = scale.v_invert(spt0);
    const pt1 = scale.v_invert(spt1);
    const n2 = pt0.length;
    const ddist = new ArrayType(n2);
    for (let i2 = 0; i2 < n2; i2++)
      ddist[i2] = Math.abs(pt1[i2] - pt0[i2]);
    return ddist;
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
RectView.__name__ = "RectView";
class Rect extends CenterRotatable {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1$ = Rect;
Rect.__name__ = "Rect";
(() => {
  _a$1$.prototype.default_view = RectView;
  _a$1$.define(({ Boolean: Boolean2 }) => ({
    dilate: [Boolean2, false]
  }));
})();
var _a$1_;
class MarkerView extends XYGlyphView {
  _render(ctx, indices, data2) {
    const { sx, sy, size: size2, angle } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const size_i = size2.get(i2);
      const angle_i = angle.get(i2);
      if (!isFinite(sx_i + sy_i + size_i + angle_i))
        continue;
      const r = size_i / 2;
      ctx.beginPath();
      ctx.translate(sx_i, sy_i);
      if (angle_i)
        ctx.rotate(angle_i);
      this._render_one(ctx, i2, r, this.visuals);
      if (angle_i)
        ctx.rotate(-angle_i);
      ctx.translate(-sx_i, -sy_i);
    }
  }
  _mask_data() {
    const { x_target, y_target } = this.renderer.plot_view.frame;
    const hr = x_target.widen(this.max_size).map((x2) => this.renderer.xscale.invert(x2));
    const vr = y_target.widen(this.max_size).map((y2) => this.renderer.yscale.invert(y2));
    return this.index.indices({
      x0: hr.start,
      x1: hr.end,
      y0: vr.start,
      y1: vr.end
    });
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const { max_size } = this;
    const { hit_dilation } = this.model;
    const sx0 = sx - max_size * hit_dilation;
    const sx1 = sx + max_size * hit_dilation;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const sy0 = sy - max_size * hit_dilation;
    const sy1 = sy + max_size * hit_dilation;
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const candidates = this.index.indices({ x0, x1, y0, y1 });
    const indices = [];
    for (const i2 of candidates) {
      const s2 = this.size.get(i2) / 2 * hit_dilation;
      if (Math.abs(this.sx[i2] - sx) <= s2 && Math.abs(this.sy[i2] - sy) <= s2) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  _hit_span(geometry) {
    const { sx, sy } = geometry;
    const bounds = this.bounds();
    const ms2 = this.max_size / 2;
    let x0, x1, y0, y1;
    if (geometry.direction == "h") {
      y0 = bounds.y0;
      y1 = bounds.y1;
      const sx0 = sx - ms2;
      const sx1 = sx + ms2;
      [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    } else {
      x0 = bounds.x0;
      x1 = bounds.x1;
      const sy0 = sy - ms2;
      const sy1 = sy + ms2;
      [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    }
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  _hit_rect(geometry) {
    const { sx0, sx1, sy0, sy1 } = geometry;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const indices = [...this.index.indices({ x0, x1, y0, y1 })];
    return new Selection({ indices });
  }
  _hit_poly(geometry) {
    const { sx, sy } = geometry;
    const candidates = range(0, this.sx.length);
    const indices = [];
    for (let i2 = 0, end = candidates.length; i2 < end; i2++) {
      const index2 = candidates[i2];
      if (point_in_poly(this.sx[i2], this.sy[i2], sx, sy)) {
        indices.push(index2);
      }
    }
    return new Selection({ indices });
  }
  _get_legend_args({ x0, x1, y0, y1 }, index2) {
    const n2 = index2 + 1;
    const sx = new Array(n2);
    const sy = new Array(n2);
    sx[index2] = (x0 + x1) / 2;
    sy[index2] = (y0 + y1) / 2;
    const vsize = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.4;
    const size2 = new UniformScalar(vsize, n2);
    const angle = new UniformScalar(0, n2);
    return { sx, sy, size: size2, angle };
  }
  draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index2) {
    const args = this._get_legend_args({ x0, x1, y0, y1 }, index2);
    this._render(ctx, [index2], args);
  }
}
MarkerView.__name__ = "MarkerView";
class Marker extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1_ = Marker;
Marker.__name__ = "Marker";
(() => {
  _a$1_.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$1_.define(({ Number: Number2 }) => ({
    size: [ScreenSizeSpec, { value: 4 }],
    angle: [AngleSpec, 0],
    hit_dilation: [Number2, 1]
  }));
})();
const SQ3 = Math.sqrt(3);
const SQ5 = Math.sqrt(5);
const c36 = (SQ5 + 1) / 4;
const s36 = Math.sqrt((5 - SQ5) / 8);
const c72 = (SQ5 - 1) / 4;
const s72 = Math.sqrt((5 + SQ5) / 8);
function _one_line(ctx, r) {
  ctx.moveTo(-r, 0);
  ctx.lineTo(r, 0);
}
function _one_x(ctx, r) {
  ctx.rotate(Math.PI / 4);
  _one_cross(ctx, r);
  ctx.rotate(-Math.PI / 4);
}
function _one_y(ctx, r) {
  const h2 = r * SQ3;
  const a2 = h2 / 3;
  ctx.moveTo(-h2 / 2, -a2);
  ctx.lineTo(0, 0);
  ctx.lineTo(h2 / 2, -a2);
  ctx.lineTo(0, 0);
  ctx.lineTo(0, r);
}
function _one_cross(ctx, r) {
  ctx.moveTo(0, r);
  ctx.lineTo(0, -r);
  ctx.moveTo(-r, 0);
  ctx.lineTo(r, 0);
}
function _one_dot(ctx, r) {
  ctx.beginPath();
  ctx.arc(0, 0, r / 4, 0, 2 * Math.PI, false);
  ctx.closePath();
}
function _one_diamond(ctx, r) {
  ctx.moveTo(0, r);
  ctx.lineTo(r / 1.5, 0);
  ctx.lineTo(0, -r);
  ctx.lineTo(-r / 1.5, 0);
  ctx.closePath();
}
function _one_hex(ctx, r) {
  const r2 = r / 2;
  const h2 = SQ3 * r2;
  ctx.moveTo(r, 0);
  ctx.lineTo(r2, -h2);
  ctx.lineTo(-r2, -h2);
  ctx.lineTo(-r, 0);
  ctx.lineTo(-r2, h2);
  ctx.lineTo(r2, h2);
  ctx.closePath();
}
function _one_star(ctx, r) {
  const a2 = Math.sqrt(5 - 2 * SQ5) * r;
  ctx.moveTo(0, -r);
  ctx.lineTo(a2 * c72, -r + a2 * s72);
  ctx.lineTo(a2 * (1 + c72), -r + a2 * s72);
  ctx.lineTo(a2 * (1 + c72 - c36), -r + a2 * (s72 + s36));
  ctx.lineTo(a2 * (1 + 2 * c72 - c36), -r + a2 * (2 * s72 + s36));
  ctx.lineTo(0, -r + a2 * 2 * s72);
  ctx.lineTo(-a2 * (1 + 2 * c72 - c36), -r + a2 * (2 * s72 + s36));
  ctx.lineTo(-a2 * (1 + c72 - c36), -r + a2 * (s72 + s36));
  ctx.lineTo(-a2 * (1 + c72), -r + a2 * s72);
  ctx.lineTo(-a2 * c72, -r + a2 * s72);
  ctx.closePath();
}
function _one_tri(ctx, r) {
  const h2 = r * SQ3;
  const a2 = h2 / 3;
  ctx.moveTo(-r, a2);
  ctx.lineTo(r, a2);
  ctx.lineTo(0, a2 - h2);
  ctx.closePath();
}
function asterisk(ctx, i2, r, visuals) {
  _one_cross(ctx, r);
  _one_x(ctx, r);
  visuals.line.apply(ctx, i2);
}
function circle$1(ctx, i2, r, visuals) {
  ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function circle_cross(ctx, i2, r, visuals) {
  ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    _one_cross(ctx, r);
    ctx.stroke();
  }
}
function circle_dot(ctx, i2, r, visuals) {
  circle$1(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function circle_y(ctx, i2, r, visuals) {
  ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    _one_y(ctx, r);
    ctx.stroke();
  }
}
function circle_x(ctx, i2, r, visuals) {
  ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    _one_x(ctx, r);
    ctx.stroke();
  }
}
function cross(ctx, i2, r, visuals) {
  _one_cross(ctx, r);
  visuals.line.apply(ctx, i2);
}
function diamond(ctx, i2, r, visuals) {
  _one_diamond(ctx, r);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function diamond_cross(ctx, i2, r, visuals) {
  _one_diamond(ctx, r);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    ctx.moveTo(0, r);
    ctx.lineTo(0, -r);
    ctx.moveTo(-r / 1.5, 0);
    ctx.lineTo(r / 1.5, 0);
    ctx.stroke();
  }
}
function diamond_dot(ctx, i2, r, visuals) {
  diamond(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function dot(ctx, i2, r, visuals) {
  _one_dot(ctx, r);
  visuals.line.set_vectorize(ctx, i2);
  ctx.fillStyle = ctx.strokeStyle;
  ctx.fill();
}
function hex(ctx, i2, r, visuals) {
  _one_hex(ctx, r);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function hex_dot(ctx, i2, r, visuals) {
  hex(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function inverted_triangle(ctx, i2, r, visuals) {
  ctx.rotate(Math.PI);
  _one_tri(ctx, r);
  ctx.rotate(-Math.PI);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function plus(ctx, i2, r, visuals) {
  const a2 = 3 * r / 8;
  const b = r;
  const xs = [a2, a2, b, b, a2, a2, -a2, -a2, -b, -b, -a2, -a2];
  const ys = [b, a2, a2, -a2, -a2, -b, -b, -a2, -a2, a2, a2, b];
  ctx.beginPath();
  for (let j = 0; j < 12; j++) {
    ctx.lineTo(xs[j], ys[j]);
  }
  ctx.closePath();
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function square(ctx, i2, r, visuals) {
  const size2 = 2 * r;
  ctx.rect(-r, -r, size2, size2);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function square_pin(ctx, i2, r, visuals) {
  const a2 = 3 * r / 8;
  ctx.moveTo(-r, -r);
  ctx.quadraticCurveTo(0, -a2, r, -r);
  ctx.quadraticCurveTo(a2, 0, r, r);
  ctx.quadraticCurveTo(0, a2, -r, r);
  ctx.quadraticCurveTo(-a2, 0, -r, -r);
  ctx.closePath();
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function square_cross(ctx, i2, r, visuals) {
  const size2 = 2 * r;
  ctx.rect(-r, -r, size2, size2);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    _one_cross(ctx, r);
    ctx.stroke();
  }
}
function square_dot(ctx, i2, r, visuals) {
  square(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function square_x(ctx, i2, r, visuals) {
  const size2 = 2 * r;
  ctx.rect(-r, -r, size2, size2);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  if (visuals.line.doit) {
    visuals.line.set_vectorize(ctx, i2);
    ctx.moveTo(-r, r);
    ctx.lineTo(r, -r);
    ctx.moveTo(-r, -r);
    ctx.lineTo(r, r);
    ctx.stroke();
  }
}
function star(ctx, i2, r, visuals) {
  _one_star(ctx, r);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function star_dot(ctx, i2, r, visuals) {
  star(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function triangle(ctx, i2, r, visuals) {
  _one_tri(ctx, r);
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function triangle_dot(ctx, i2, r, visuals) {
  triangle(ctx, i2, r, visuals);
  dot(ctx, i2, r, visuals);
}
function triangle_pin(ctx, i2, r, visuals) {
  const h2 = r * SQ3;
  const a2 = h2 / 3;
  const b = 3 * a2 / 8;
  ctx.moveTo(-r, a2);
  ctx.quadraticCurveTo(0, b, r, a2);
  ctx.quadraticCurveTo(SQ3 * b / 2, b / 2, 0, a2 - h2);
  ctx.quadraticCurveTo(-SQ3 * b / 2, b / 2, -r, a2);
  ctx.closePath();
  visuals.fill.apply(ctx, i2);
  visuals.hatch.apply(ctx, i2);
  visuals.line.apply(ctx, i2);
}
function dash(ctx, i2, r, visuals) {
  _one_line(ctx, r);
  visuals.line.apply(ctx, i2);
}
function x(ctx, i2, r, visuals) {
  _one_x(ctx, r);
  visuals.line.apply(ctx, i2);
}
function y(ctx, i2, r, visuals) {
  _one_y(ctx, r);
  visuals.line.apply(ctx, i2);
}
const marker_funcs = {
  asterisk,
  circle: circle$1,
  circle_cross,
  circle_dot,
  circle_y,
  circle_x,
  cross,
  diamond,
  diamond_dot,
  diamond_cross,
  dot,
  hex,
  hex_dot,
  inverted_triangle,
  plus,
  square,
  square_cross,
  square_dot,
  square_pin,
  square_x,
  star,
  star_dot,
  triangle,
  triangle_dot,
  triangle_pin,
  dash,
  x,
  y
};
var _a$1Z;
class ScatterView extends MarkerView {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { MultiMarkerGL: MultiMarkerGL2 } = await Promise.resolve().then(function() {
        return multi_marker;
      });
      this.glglyph = new MultiMarkerGL2(webgl.regl_wrapper, this);
    }
  }
  _render(ctx, indices, data2) {
    const { sx, sy, size: size2, angle, marker } = data2 != null ? data2 : this;
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const size_i = size2.get(i2);
      const angle_i = angle.get(i2);
      const marker_i = marker.get(i2);
      if (!isFinite(sx_i + sy_i + size_i + angle_i) || marker_i == null)
        continue;
      const r = size_i / 2;
      ctx.beginPath();
      ctx.translate(sx_i, sy_i);
      if (angle_i)
        ctx.rotate(angle_i);
      marker_funcs[marker_i](ctx, i2, r, this.visuals);
      if (angle_i)
        ctx.rotate(-angle_i);
      ctx.translate(-sx_i, -sy_i);
    }
  }
  draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index2) {
    const n2 = index2 + 1;
    const marker = this.marker.get(index2);
    const args = {
      ...this._get_legend_args({ x0, x1, y0, y1 }, index2),
      marker: new UniformScalar(marker, n2)
    };
    this._render(ctx, [index2], args);
  }
}
ScatterView.__name__ = "ScatterView";
class Scatter extends Marker {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1Z = Scatter;
Scatter.__name__ = "Scatter";
(() => {
  _a$1Z.prototype.default_view = ScatterView;
  _a$1Z.define(() => ({
    marker: [MarkerSpec, { value: "circle" }]
  }));
})();
var _a$1Y;
class SegmentView extends GlyphView {
  _project_data() {
    inplace.project_xy(this._x0, this._y0);
    inplace.project_xy(this._x1, this._y1);
  }
  _index_data(index2) {
    const { min: min2, max: max2 } = Math;
    const { _x0, _x1, _y0, _y1, data_size } = this;
    for (let i2 = 0; i2 < data_size; i2++) {
      const x0 = _x0[i2];
      const x1 = _x1[i2];
      const y0 = _y0[i2];
      const y1 = _y1[i2];
      index2.add_rect(min2(x0, x1), min2(y0, y1), max2(x0, x1), max2(y0, y1));
    }
  }
  _render(ctx, indices, data2) {
    if (this.visuals.line.doit) {
      const { sx0, sy0, sx1, sy1 } = data2 != null ? data2 : this;
      for (const i2 of indices) {
        const sx0_i = sx0[i2];
        const sy0_i = sy0[i2];
        const sx1_i = sx1[i2];
        const sy1_i = sy1[i2];
        if (!isFinite(sx0_i + sy0_i + sx1_i + sy1_i))
          continue;
        ctx.beginPath();
        ctx.moveTo(sx0_i, sy0_i);
        ctx.lineTo(sx1_i, sy1_i);
        this.visuals.line.set_vectorize(ctx, i2);
        ctx.stroke();
      }
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const point = { x: sx, y: sy };
    const lw_voffset = 2;
    const [x0, x1] = this.renderer.xscale.r_invert(sx - lw_voffset, sx + lw_voffset);
    const [y0, y1] = this.renderer.yscale.r_invert(sy - lw_voffset, sy + lw_voffset);
    const candidates = this.index.indices({ x0, y0, x1, y1 });
    const indices = [];
    for (const i2 of candidates) {
      const threshold2 = Math.max(2, this.line_width.get(i2) / 2) ** 2;
      const p0 = { x: this.sx0[i2], y: this.sy0[i2] };
      const p1 = { x: this.sx1[i2], y: this.sy1[i2] };
      const dist2 = dist_to_segment_squared(point, p0, p1);
      if (dist2 < threshold2) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  _hit_span(geometry) {
    const [hr, vr] = this.renderer.plot_view.frame.bbox.ranges;
    const { sx, sy } = geometry;
    let v0;
    let v1;
    let val;
    if (geometry.direction == "v") {
      val = this.renderer.yscale.invert(sy);
      [v0, v1] = [this._y0, this._y1];
    } else {
      val = this.renderer.xscale.invert(sx);
      [v0, v1] = [this._x0, this._x1];
    }
    const indices = [];
    const [x0, x1] = this.renderer.xscale.r_invert(hr.start, hr.end);
    const [y0, y1] = this.renderer.yscale.r_invert(vr.start, vr.end);
    const candidates = this.index.indices({ x0, y0, x1, y1 });
    for (const i2 of candidates) {
      if (v0[i2] <= val && val <= v1[i2] || v1[i2] <= val && val <= v0[i2])
        indices.push(i2);
      const threshold = 1.5 + this.line_width.get(i2) / 2;
      if (v0[i2] == v1[i2]) {
        if (geometry.direction == "h") {
          if (Math.abs(this.sx0[i2] - sx) <= threshold) {
            indices.push(i2);
          }
        } else {
          if (Math.abs(this.sy0[i2] - sy) <= threshold) {
            indices.push(i2);
          }
        }
      }
    }
    return new Selection({ indices });
  }
  scenterxy(i2) {
    const scx = this.sx0[i2] / 2 + this.sx1[i2] / 2;
    const scy = this.sy0[i2] / 2 + this.sy1[i2] / 2;
    return [scx, scy];
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_line_vector_legend(this.visuals, ctx, bbox, index2);
  }
}
SegmentView.__name__ = "SegmentView";
class Segment extends Glyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1Y = Segment;
Segment.__name__ = "Segment";
(() => {
  _a$1Y.prototype.default_view = SegmentView;
  _a$1Y.define(({}) => ({
    x0: [XCoordinateSpec, { field: "x0" }],
    y0: [YCoordinateSpec, { field: "y0" }],
    x1: [XCoordinateSpec, { field: "x1" }],
    y1: [YCoordinateSpec, { field: "y1" }]
  }));
  _a$1Y.mixins(LineVector$1);
})();
function catmullrom_spline(x2, y2, T = 10, tension = 0.5, closed = false) {
  assert(x2.length == y2.length);
  const n2 = x2.length;
  const N = closed ? n2 + 1 : n2;
  const ArrayType = infer_type(x2, y2);
  const xx = new ArrayType(N + 2);
  const yy = new ArrayType(N + 2);
  xx.set(x2, 1);
  yy.set(y2, 1);
  if (closed) {
    xx[0] = x2[n2 - 1];
    yy[0] = y2[n2 - 1];
    xx[N] = x2[0];
    yy[N] = y2[0];
    xx[N + 1] = x2[1];
    yy[N + 1] = y2[1];
  } else {
    xx[0] = x2[0];
    yy[0] = y2[0];
    xx[N + 1] = x2[n2 - 1];
    yy[N + 1] = y2[n2 - 1];
  }
  const basis = new ArrayType(4 * (T + 1));
  for (let j = 0, k = 0; j <= T; j++) {
    const t = j / T;
    const t_2 = t ** 2;
    const t_3 = t * t_2;
    basis[k++] = 2 * t_3 - 3 * t_2 + 1;
    basis[k++] = -2 * t_3 + 3 * t_2;
    basis[k++] = t_3 - 2 * t_2 + t;
    basis[k++] = t_3 - t_2;
  }
  const xt = new ArrayType((N - 1) * (T + 1));
  const yt = new ArrayType((N - 1) * (T + 1));
  for (let i2 = 1, k = 0; i2 < N; i2++) {
    const t0x = (xx[i2 + 1] - xx[i2 - 1]) * tension;
    const t0y = (yy[i2 + 1] - yy[i2 - 1]) * tension;
    const t1x = (xx[i2 + 2] - xx[i2]) * tension;
    const t1y = (yy[i2 + 2] - yy[i2]) * tension;
    for (let j = 0; j <= 4 * T; k++) {
      const h00 = basis[j++];
      const h01 = basis[j++];
      const h10 = basis[j++];
      const h11 = basis[j++];
      xt[k] = h00 * xx[i2] + h01 * xx[i2 + 1] + h10 * t0x + h11 * t1x;
      yt[k] = h00 * yy[i2] + h01 * yy[i2 + 1] + h10 * t0y + h11 * t1y;
    }
  }
  return [xt, yt];
}
var _a$1X;
class SplineView extends XYGlyphView {
  _set_data() {
    const { tension, closed } = this.model;
    [this._xt, this._yt] = catmullrom_spline(this._x, this._y, 20, tension, closed);
  }
  _map_data() {
    const { x_scale, y_scale } = this.renderer.coordinates;
    this.sxt = x_scale.v_compute(this._xt);
    this.syt = y_scale.v_compute(this._yt);
  }
  _render(ctx, _indices, data2) {
    const { sxt: sx, syt: sy } = data2 != null ? data2 : this;
    let move = true;
    ctx.beginPath();
    const n2 = sx.length;
    for (let j = 0; j < n2; j++) {
      const sx_i = sx[j];
      const sy_i = sy[j];
      if (!isFinite(sx_i + sy_i))
        move = true;
      else {
        if (move) {
          ctx.moveTo(sx_i, sy_i);
          move = false;
        } else
          ctx.lineTo(sx_i, sy_i);
      }
    }
    this.visuals.line.set_value(ctx);
    ctx.stroke();
  }
}
SplineView.__name__ = "SplineView";
class Spline extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1X = Spline;
Spline.__name__ = "Spline";
(() => {
  _a$1X.prototype.default_view = SplineView;
  _a$1X.mixins(LineScalar$1);
  _a$1X.define(({ Boolean: Boolean2, Number: Number2 }) => ({
    tension: [Number2, 0.5],
    closed: [Boolean2, false]
  }));
})();
var _a$1W;
class StepView extends XYGlyphView {
  _render(ctx, indices, data2) {
    const { sx, sy } = data2 != null ? data2 : this;
    let drawing = false;
    let last_index = null;
    this.visuals.line.set_value(ctx);
    const L = indices.length;
    if (L < 2)
      return;
    ctx.beginPath();
    ctx.moveTo(sx[0], sy[0]);
    for (const i2 of indices) {
      let x1, x2;
      let y1, y2;
      switch (this.model.mode) {
        case "before": {
          [x1, y1] = [sx[i2 - 1], sy[i2]];
          [x2, y2] = [sx[i2], sy[i2]];
          break;
        }
        case "after": {
          [x1, y1] = [sx[i2], sy[i2 - 1]];
          [x2, y2] = [sx[i2], sy[i2]];
          break;
        }
        case "center": {
          const xm = (sx[i2 - 1] + sx[i2]) / 2;
          [x1, y1] = [xm, sy[i2 - 1]];
          [x2, y2] = [xm, sy[i2]];
          break;
        }
        default:
          unreachable();
      }
      if (drawing) {
        if (!isFinite(sx[i2] + sy[i2])) {
          ctx.stroke();
          ctx.beginPath();
          drawing = false;
          last_index = i2;
          continue;
        }
        if (last_index != null && i2 - last_index > 1) {
          ctx.stroke();
          drawing = false;
        }
      }
      if (drawing) {
        ctx.lineTo(x1, y1);
        ctx.lineTo(x2, y2);
      } else {
        ctx.beginPath();
        ctx.moveTo(sx[i2], sy[i2]);
        drawing = true;
      }
      last_index = i2;
    }
    ctx.lineTo(sx[L - 1], sy[L - 1]);
    ctx.stroke();
  }
  draw_legend_for_index(ctx, bbox, _index) {
    generic_line_scalar_legend(this.visuals, ctx, bbox);
  }
}
StepView.__name__ = "StepView";
class Step extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1W = Step;
Step.__name__ = "Step";
(() => {
  _a$1W.prototype.default_view = StepView;
  _a$1W.mixins(LineScalar$1);
  _a$1W.define(() => ({
    mode: [StepMode, "before"]
  }));
})();
var _a$1V;
class TextView$1 extends XYGlyphView {
  _rotate_point(x2, y2, xoff, yoff, angle) {
    const sxr = (x2 - xoff) * Math.cos(angle) - (y2 - yoff) * Math.sin(angle) + xoff;
    const syr = (x2 - xoff) * Math.sin(angle) + (y2 - yoff) * Math.cos(angle) + yoff;
    return [sxr, syr];
  }
  _text_bounds(x0, y0, width, height) {
    const xvals = [x0, x0 + width, x0 + width, x0, x0];
    const yvals = [y0, y0, y0 - height, y0 - height, y0];
    return [xvals, yvals];
  }
  _render(ctx, indices, data2) {
    const { sx, sy, x_offset, y_offset, angle, text } = data2 != null ? data2 : this;
    this._sys = [];
    this._sxs = [];
    for (const i2 of indices) {
      const sxs_i = this._sxs[i2] = [];
      const sys_i = this._sys[i2] = [];
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const x_offset_i = x_offset.get(i2);
      const y_offset_i = y_offset.get(i2);
      const angle_i = angle.get(i2);
      const text_i = text.get(i2);
      if (!isFinite(sx_i + sy_i + x_offset_i + y_offset_i + angle_i) || text_i == null)
        continue;
      if (this.visuals.text.doit) {
        const text2 = `${text_i}`;
        ctx.save();
        ctx.translate(sx_i + x_offset_i, sy_i + y_offset_i);
        ctx.rotate(angle_i);
        this.visuals.text.set_vectorize(ctx, i2);
        const font = this.visuals.text.font_value(i2);
        const { height } = font_metrics(font);
        const line_height = this.text_line_height.get(i2) * height;
        if (text2.indexOf("\n") == -1) {
          ctx.fillText(text2, 0, 0);
          const x0 = sx_i + x_offset_i;
          const y0 = sy_i + y_offset_i;
          const width = ctx.measureText(text2).width;
          const [xvalues, yvalues] = this._text_bounds(x0, y0, width, line_height);
          sxs_i.push(xvalues);
          sys_i.push(yvalues);
        } else {
          const lines = text2.split("\n");
          const block_height = line_height * lines.length;
          const baseline = this.text_baseline.get(i2);
          let y2;
          switch (baseline) {
            case "top": {
              y2 = 0;
              break;
            }
            case "middle": {
              y2 = -block_height / 2 + line_height / 2;
              break;
            }
            case "bottom": {
              y2 = -block_height + line_height;
              break;
            }
            default: {
              y2 = 0;
              console.warn(`'${baseline}' baseline not supported with multi line text`);
            }
          }
          for (const line of lines) {
            ctx.fillText(line, 0, y2);
            const x0 = sx_i + x_offset_i;
            const y0 = y2 + sy_i + y_offset_i;
            const width = ctx.measureText(line).width;
            const [xvalues, yvalues] = this._text_bounds(x0, y0, width, line_height);
            sxs_i.push(xvalues);
            sys_i.push(yvalues);
            y2 += line_height;
          }
        }
        ctx.restore();
      }
    }
  }
  _hit_point(geometry) {
    const { sx, sy } = geometry;
    const indices = [];
    for (let i2 = 0; i2 < this._sxs.length; i2++) {
      const sxs = this._sxs[i2];
      const sys = this._sys[i2];
      const n2 = sxs.length;
      for (let j = 0, endj = n2; j < endj; j++) {
        const [sxr, syr] = this._rotate_point(sx, sy, sxs[n2 - 1][0], sys[n2 - 1][0], -this.angle.get(i2));
        if (point_in_poly(sxr, syr, sxs[j], sys[j])) {
          indices.push(i2);
        }
      }
    }
    return new Selection({ indices });
  }
  scenterxy(i2) {
    const sxs = this._sxs[i2];
    const sys = this._sys[i2];
    assert(sxs.length != 0 && sys.length != 0);
    const sx0 = sxs[0][0];
    const sy0 = sys[0][0];
    const sxc = (sxs[0][2] + sx0) / 2;
    const syc = (sys[0][2] + sy0) / 2;
    const [sxcr, sycr] = this._rotate_point(sxc, syc, sx0, sy0, this.angle.get(i2));
    return [sxcr, sycr];
  }
}
TextView$1.__name__ = "TextView";
class Text$1 extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1V = Text$1;
Text$1.__name__ = "Text";
(() => {
  _a$1V.prototype.default_view = TextView$1;
  _a$1V.mixins(TextVector$1);
  _a$1V.define(({}) => ({
    text: [NullStringSpec, { field: "text" }],
    angle: [AngleSpec, 0],
    x_offset: [NumberSpec, 0],
    y_offset: [NumberSpec, 0]
  }));
})();
var _a$1U;
class VBarView extends BoxView$1 {
  async lazy_initialize() {
    await super.lazy_initialize();
    const { webgl } = this.renderer.plot_view.canvas_view;
    if (webgl != null && webgl.regl_wrapper.has_webgl) {
      const { LRTBGL: LRTBGL2 } = await Promise.resolve().then(function() {
        return lrtb;
      });
      this.glglyph = new LRTBGL2(webgl.regl_wrapper, this);
    }
  }
  scenterxy(i2) {
    const scx = this.sx[i2];
    const scy = (this.stop[i2] + this.sbottom[i2]) / 2;
    return [scx, scy];
  }
  _lrtb(i2) {
    const half_width_i = this.width.get(i2) / 2;
    const x_i = this._x[i2];
    const top_i = this._top[i2];
    const bottom_i = this._bottom[i2];
    const l = x_i - half_width_i;
    const r = x_i + half_width_i;
    const t = Math.max(top_i, bottom_i);
    const b = Math.min(top_i, bottom_i);
    return [l, r, t, b];
  }
  _map_data() {
    this.sx = this.renderer.xscale.v_compute(this._x);
    this.sw = this.sdist(this.renderer.xscale, this._x, this.width, "center");
    this.stop = this.renderer.yscale.v_compute(this._top);
    this.sbottom = this.renderer.yscale.v_compute(this._bottom);
    const n2 = this.sx.length;
    this.sleft = new ScreenArray(n2);
    this.sright = new ScreenArray(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      this.sleft[i2] = this.sx[i2] - this.sw[i2] / 2;
      this.sright[i2] = this.sx[i2] + this.sw[i2] / 2;
    }
    this._clamp_viewport();
  }
}
VBarView.__name__ = "VBarView";
class VBar extends Box$1 {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1U = VBar;
VBar.__name__ = "VBar";
(() => {
  _a$1U.prototype.default_view = VBarView;
  _a$1U.define(({}) => ({
    x: [XCoordinateSpec, { field: "x" }],
    bottom: [YCoordinateSpec, { value: 0 }],
    width: [NumberSpec, { value: 1 }],
    top: [YCoordinateSpec, { field: "top" }]
  }));
})();
var _a$1T;
class WedgeView extends XYGlyphView {
  _map_data() {
    if (this.model.properties.radius.units == "data")
      this.sradius = this.sdist(this.renderer.xscale, this._x, this.radius);
    else
      this.sradius = to_screen(this.radius);
    this.max_sradius = max$8(this.sradius);
  }
  _render(ctx, indices, data2) {
    const { sx, sy, sradius, start_angle, end_angle } = data2 != null ? data2 : this;
    const anticlock = this.model.direction == "anticlock";
    for (const i2 of indices) {
      const sx_i = sx[i2];
      const sy_i = sy[i2];
      const sradius_i = sradius[i2];
      const start_angle_i = start_angle.get(i2);
      const end_angle_i = end_angle.get(i2);
      if (!isFinite(sx_i + sy_i + sradius_i + start_angle_i + end_angle_i))
        continue;
      ctx.beginPath();
      ctx.arc(sx_i, sy_i, sradius_i, start_angle_i, end_angle_i, anticlock);
      ctx.lineTo(sx_i, sy_i);
      ctx.closePath();
      this.visuals.fill.apply(ctx, i2);
      this.visuals.hatch.apply(ctx, i2);
      this.visuals.line.apply(ctx, i2);
    }
  }
  _hit_point(geometry) {
    let dist, sx0, sx1, sy0, sy1;
    const { sx, sy } = geometry;
    const x2 = this.renderer.xscale.invert(sx);
    const y2 = this.renderer.yscale.invert(sy);
    sx0 = sx - this.max_sradius;
    sx1 = sx + this.max_sradius;
    const [x0, x1] = this.renderer.xscale.r_invert(sx0, sx1);
    sy0 = sy - this.max_sradius;
    sy1 = sy + this.max_sradius;
    const [y0, y1] = this.renderer.yscale.r_invert(sy0, sy1);
    const candidates = [];
    for (const i2 of this.index.indices({ x0, x1, y0, y1 })) {
      const r2 = this.sradius[i2] ** 2;
      [sx0, sx1] = this.renderer.xscale.r_compute(x2, this._x[i2]);
      [sy0, sy1] = this.renderer.yscale.r_compute(y2, this._y[i2]);
      dist = (sx0 - sx1) ** 2 + (sy0 - sy1) ** 2;
      if (dist <= r2) {
        candidates.push(i2);
      }
    }
    const anticlock = this.model.direction == "anticlock";
    const indices = [];
    for (const i2 of candidates) {
      const angle = Math.atan2(sy - this.sy[i2], sx - this.sx[i2]);
      if (angle_between(-angle, -this.start_angle.get(i2), -this.end_angle.get(i2), anticlock)) {
        indices.push(i2);
      }
    }
    return new Selection({ indices });
  }
  draw_legend_for_index(ctx, bbox, index2) {
    generic_area_vector_legend(this.visuals, ctx, bbox, index2);
  }
  scenterxy(i2) {
    const r = this.sradius[i2] / 2;
    const a2 = (this.start_angle.get(i2) + this.end_angle.get(i2)) / 2;
    const scx = this.sx[i2] + r * Math.cos(a2);
    const scy = this.sy[i2] + r * Math.sin(a2);
    return [scx, scy];
  }
}
WedgeView.__name__ = "WedgeView";
class Wedge extends XYGlyph {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1T = Wedge;
Wedge.__name__ = "Wedge";
(() => {
  _a$1T.prototype.default_view = WedgeView;
  _a$1T.mixins([LineVector$1, FillVector$1, HatchVector$1]);
  _a$1T.define(({}) => ({
    direction: [Direction$1, "anticlock"],
    radius: [DistanceSpec, { field: "radius" }],
    start_angle: [AngleSpec, { field: "start_angle" }],
    end_angle: [AngleSpec, { field: "end_angle" }]
  }));
})();
class GraphHitTestPolicy extends Model {
  constructor(attrs) {
    super(attrs);
  }
  _hit_test(geometry, graph_view, renderer_view) {
    if (!graph_view.model.visible)
      return null;
    const hit_test_result = renderer_view.glyph.hit_test(geometry);
    if (hit_test_result == null)
      return null;
    else
      return renderer_view.model.view.convert_selection_from_subset(hit_test_result);
  }
}
GraphHitTestPolicy.__name__ = "GraphHitTestPolicy";
class EdgesOnly extends GraphHitTestPolicy {
  constructor(attrs) {
    super(attrs);
  }
  hit_test(geometry, graph_view) {
    return this._hit_test(geometry, graph_view, graph_view.edge_view);
  }
  do_selection(hit_test_result, graph, final, mode) {
    if (hit_test_result == null)
      return false;
    const edge_selection = graph.edge_renderer.data_source.selected;
    edge_selection.update(hit_test_result, final, mode);
    graph.edge_renderer.data_source._select.emit();
    return !edge_selection.is_empty();
  }
  do_inspection(hit_test_result, geometry, graph_view, final, mode) {
    if (hit_test_result == null)
      return false;
    const { edge_renderer } = graph_view.model;
    const edge_inspection = edge_renderer.get_selection_manager().get_or_create_inspector(graph_view.edge_view.model);
    edge_inspection.update(hit_test_result, final, mode);
    graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
    graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view.model, { geometry }]);
    return !edge_inspection.is_empty();
  }
}
EdgesOnly.__name__ = "EdgesOnly";
class NodesOnly extends GraphHitTestPolicy {
  constructor(attrs) {
    super(attrs);
  }
  hit_test(geometry, graph_view) {
    return this._hit_test(geometry, graph_view, graph_view.node_view);
  }
  do_selection(hit_test_result, graph, final, mode) {
    if (hit_test_result == null)
      return false;
    const node_selection = graph.node_renderer.data_source.selected;
    node_selection.update(hit_test_result, final, mode);
    graph.node_renderer.data_source._select.emit();
    return !node_selection.is_empty();
  }
  do_inspection(hit_test_result, geometry, graph_view, final, mode) {
    if (hit_test_result == null)
      return false;
    const { node_renderer } = graph_view.model;
    const node_inspection = node_renderer.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
    node_inspection.update(hit_test_result, final, mode);
    graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
    graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry }]);
    return !node_inspection.is_empty();
  }
}
NodesOnly.__name__ = "NodesOnly";
class NodesAndLinkedEdges extends GraphHitTestPolicy {
  constructor(attrs) {
    super(attrs);
  }
  hit_test(geometry, graph_view) {
    return this._hit_test(geometry, graph_view, graph_view.node_view);
  }
  get_linked_edges(node_source, edge_source, mode) {
    let node_indices = [];
    if (mode == "selection") {
      node_indices = node_source.selected.indices.map((i2) => node_source.data.index[i2]);
    } else if (mode == "inspection") {
      node_indices = node_source.inspected.indices.map((i2) => node_source.data.index[i2]);
    }
    const edge_indices = [];
    for (let i2 = 0; i2 < edge_source.data.start.length; i2++) {
      if (contains(node_indices, edge_source.data.start[i2]) || contains(node_indices, edge_source.data.end[i2]))
        edge_indices.push(i2);
    }
    const linked_edges = new Selection();
    for (const i2 of edge_indices) {
      linked_edges.multiline_indices[i2] = [0];
    }
    linked_edges.indices = edge_indices;
    return linked_edges;
  }
  do_selection(hit_test_result, graph, final, mode) {
    if (hit_test_result == null)
      return false;
    const node_selection = graph.node_renderer.data_source.selected;
    node_selection.update(hit_test_result, final, mode);
    const edge_selection = graph.edge_renderer.data_source.selected;
    const linked_edges_selection = this.get_linked_edges(graph.node_renderer.data_source, graph.edge_renderer.data_source, "selection");
    edge_selection.update(linked_edges_selection, final, mode);
    graph.node_renderer.data_source._select.emit();
    return !node_selection.is_empty();
  }
  do_inspection(hit_test_result, geometry, graph_view, final, mode) {
    if (hit_test_result == null)
      return false;
    const node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
    node_inspection.update(hit_test_result, final, mode);
    graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
    const edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
    const linked_edges = this.get_linked_edges(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, "inspection");
    edge_inspection.update(linked_edges, final, mode);
    graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
    graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry }]);
    return !node_inspection.is_empty();
  }
}
NodesAndLinkedEdges.__name__ = "NodesAndLinkedEdges";
class EdgesAndLinkedNodes extends GraphHitTestPolicy {
  constructor(attrs) {
    super(attrs);
  }
  hit_test(geometry, graph_view) {
    return this._hit_test(geometry, graph_view, graph_view.edge_view);
  }
  get_linked_nodes(node_source, edge_source, mode) {
    let edge_indices = [];
    if (mode == "selection")
      edge_indices = edge_source.selected.indices;
    else if (mode == "inspection")
      edge_indices = edge_source.inspected.indices;
    const nodes = [];
    for (const i2 of edge_indices) {
      nodes.push(edge_source.data.start[i2]);
      nodes.push(edge_source.data.end[i2]);
    }
    const node_indices = uniq(nodes).map((i2) => indexOf(node_source.data.index, i2));
    return new Selection({ indices: node_indices });
  }
  do_selection(hit_test_result, graph, final, mode) {
    if (hit_test_result == null)
      return false;
    const edge_selection = graph.edge_renderer.data_source.selected;
    edge_selection.update(hit_test_result, final, mode);
    const node_selection = graph.node_renderer.data_source.selected;
    const linked_nodes = this.get_linked_nodes(graph.node_renderer.data_source, graph.edge_renderer.data_source, "selection");
    node_selection.update(linked_nodes, final, mode);
    graph.edge_renderer.data_source._select.emit();
    return !edge_selection.is_empty();
  }
  do_inspection(hit_test_result, geometry, graph_view, final, mode) {
    if (hit_test_result == null)
      return false;
    const edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
    edge_inspection.update(hit_test_result, final, mode);
    graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
    const node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
    const linked_nodes = this.get_linked_nodes(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, "inspection");
    node_inspection.update(linked_nodes, final, mode);
    graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
    graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view.model, { geometry }]);
    return !edge_inspection.is_empty();
  }
}
EdgesAndLinkedNodes.__name__ = "EdgesAndLinkedNodes";
var _a$1S;
class LayoutProvider extends Model {
  constructor(attrs) {
    super(attrs);
  }
  get node_coordinates() {
    return new NodeCoordinates({ layout: this });
  }
  get edge_coordinates() {
    return new EdgeCoordinates({ layout: this });
  }
}
LayoutProvider.__name__ = "LayoutProvider";
class GraphCoordinates extends CoordinateTransform {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1S = GraphCoordinates;
GraphCoordinates.__name__ = "GraphCoordinates";
(() => {
  _a$1S.define(({ Ref: Ref2 }) => ({
    layout: [Ref2(LayoutProvider)]
  }));
})();
class NodeCoordinates extends GraphCoordinates {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    const [x2, y2] = this.layout.get_node_coordinates(source);
    return { x: x2, y: y2 };
  }
}
NodeCoordinates.__name__ = "NodeCoordinates";
class EdgeCoordinates extends GraphCoordinates {
  constructor(attrs) {
    super(attrs);
  }
  _v_compute(source) {
    const [x2, y2] = this.layout.get_edge_coordinates(source);
    return { x: x2, y: y2 };
  }
}
EdgeCoordinates.__name__ = "EdgeCoordinates";
var _a$1R;
class StaticLayoutProvider extends LayoutProvider {
  constructor(attrs) {
    super(attrs);
  }
  get_node_coordinates(node_source) {
    var _a2;
    const index2 = (_a2 = node_source.data.index) != null ? _a2 : [];
    const n2 = index2.length;
    const xs = new Float64Array(n2);
    const ys = new Float64Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      const point = this.graph_layout[index2[i2]];
      const [x2, y2] = point != null ? point : [NaN, NaN];
      xs[i2] = x2;
      ys[i2] = y2;
    }
    return [xs, ys];
  }
  get_edge_coordinates(edge_source) {
    var _a2, _b2;
    const starts = (_a2 = edge_source.data.start) != null ? _a2 : [];
    const ends = (_b2 = edge_source.data.end) != null ? _b2 : [];
    const n2 = Math.min(starts.length, ends.length);
    const xs = [];
    const ys = [];
    const has_paths = edge_source.data.xs != null && edge_source.data.ys != null;
    for (let i2 = 0; i2 < n2; i2++) {
      const in_layout = this.graph_layout[starts[i2]] != null && this.graph_layout[ends[i2]] != null;
      if (has_paths && in_layout) {
        xs.push(edge_source.data.xs[i2]);
        ys.push(edge_source.data.ys[i2]);
      } else {
        let start2, end;
        if (in_layout) {
          start2 = this.graph_layout[starts[i2]];
          end = this.graph_layout[ends[i2]];
        } else {
          start2 = [NaN, NaN];
          end = [NaN, NaN];
        }
        xs.push([start2[0], end[0]]);
        ys.push([start2[1], end[1]]);
      }
    }
    return [xs, ys];
  }
}
_a$1R = StaticLayoutProvider;
StaticLayoutProvider.__name__ = "StaticLayoutProvider";
(() => {
  _a$1R.define(({ Number: Number2, Tuple: Tuple2, Dict: Dict2 }) => ({
    graph_layout: [Dict2(Tuple2(Number2, Number2)), {}]
  }));
})();
var _a$1Q;
class GridView extends GuideRendererView {
  _render() {
    const ctx = this.layer.ctx;
    ctx.save();
    this._draw_regions(ctx);
    this._draw_minor_grids(ctx);
    this._draw_grids(ctx);
    ctx.restore();
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.change, () => this.request_render());
  }
  _draw_regions(ctx) {
    if (!this.visuals.band_fill.doit && !this.visuals.band_hatch.doit)
      return;
    const [xs, ys] = this.grid_coords("major", false);
    for (let i2 = 0; i2 < xs.length - 1; i2++) {
      if (i2 % 2 != 1)
        continue;
      const [sx0, sy0] = this.coordinates.map_to_screen(xs[i2], ys[i2]);
      const [sx1, sy1] = this.coordinates.map_to_screen(xs[i2 + 1], ys[i2 + 1]);
      ctx.beginPath();
      ctx.rect(sx0[0], sy0[0], sx1[1] - sx0[0], sy1[1] - sy0[0]);
      this.visuals.band_fill.apply(ctx);
      this.visuals.band_hatch.apply(ctx);
    }
  }
  _draw_grids(ctx) {
    if (!this.visuals.grid_line.doit)
      return;
    const [xs, ys] = this.grid_coords("major");
    this._draw_grid_helper(ctx, this.visuals.grid_line, xs, ys);
  }
  _draw_minor_grids(ctx) {
    if (!this.visuals.minor_grid_line.doit)
      return;
    const [xs, ys] = this.grid_coords("minor");
    this._draw_grid_helper(ctx, this.visuals.minor_grid_line, xs, ys);
  }
  _draw_grid_helper(ctx, visuals, xs, ys) {
    visuals.set_value(ctx);
    ctx.beginPath();
    for (let i2 = 0; i2 < xs.length; i2++) {
      const [sx, sy] = this.coordinates.map_to_screen(xs[i2], ys[i2]);
      ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
      for (let i3 = 1; i3 < sx.length; i3++) {
        ctx.lineTo(Math.round(sx[i3]), Math.round(sy[i3]));
      }
    }
    ctx.stroke();
  }
  ranges() {
    const i2 = this.model.dimension;
    const j = (i2 + 1) % 2;
    const { ranges } = this.coordinates;
    return [ranges[i2], ranges[j]];
  }
  computed_bounds() {
    const [range2] = this.ranges();
    const user_bounds = this.model.bounds;
    const range_bounds = [range2.min, range2.max];
    let start2;
    let end;
    if (isArray(user_bounds)) {
      start2 = Math.min(user_bounds[0], user_bounds[1]);
      end = Math.max(user_bounds[0], user_bounds[1]);
      if (start2 < range_bounds[0])
        start2 = range_bounds[0];
      if (end > range_bounds[1])
        end = range_bounds[1];
    } else {
      [start2, end] = range_bounds;
      for (const axis_view of this.plot_view.axis_views) {
        if (axis_view.dimension == this.model.dimension && axis_view.model.x_range_name == this.model.x_range_name && axis_view.model.y_range_name == this.model.y_range_name) {
          [start2, end] = axis_view.computed_bounds;
        }
      }
    }
    return [start2, end];
  }
  grid_coords(location, exclude_ends = true) {
    const i2 = this.model.dimension;
    const j = (i2 + 1) % 2;
    const [range2, cross_range] = this.ranges();
    let [start2, end] = this.computed_bounds();
    [start2, end] = [Math.min(start2, end), Math.max(start2, end)];
    const coords = [[], []];
    const ticker = this.model.get_ticker();
    if (ticker == null) {
      return coords;
    }
    const ticks = ticker.get_ticks(start2, end, range2, cross_range.min)[location];
    const min2 = range2.min;
    const max2 = range2.max;
    const cmin = cross_range.min;
    const cmax = cross_range.max;
    if (!exclude_ends) {
      if (ticks[0] != min2)
        ticks.splice(0, 0, min2);
      if (ticks[ticks.length - 1] != max2)
        ticks.push(max2);
    }
    for (let ii = 0; ii < ticks.length; ii++) {
      if ((ticks[ii] == min2 || ticks[ii] == max2) && exclude_ends)
        continue;
      const dim_i = [];
      const dim_j = [];
      const N = 2;
      for (let n2 = 0; n2 < N; n2++) {
        const loc = cmin + (cmax - cmin) / (N - 1) * n2;
        dim_i.push(ticks[ii]);
        dim_j.push(loc);
      }
      coords[i2].push(dim_i);
      coords[j].push(dim_j);
    }
    return coords;
  }
}
GridView.__name__ = "GridView";
class Grid extends GuideRenderer {
  constructor(attrs) {
    super(attrs);
  }
  get_ticker() {
    if (this.ticker != null) {
      return this.ticker;
    }
    if (this.axis != null) {
      return this.axis.ticker;
    }
    return null;
  }
}
_a$1Q = Grid;
Grid.__name__ = "Grid";
(() => {
  _a$1Q.prototype.default_view = GridView;
  _a$1Q.mixins([
    ["grid_", Line$2],
    ["minor_grid_", Line$2],
    ["band_", Fill$1],
    ["band_", Hatch$1]
  ]);
  _a$1Q.define(({ Number: Number2, Auto: Auto2, Enum: Enum2, Ref: Ref2, Tuple: Tuple2, Or: Or2, Nullable: Nullable2 }) => ({
    bounds: [Or2(Tuple2(Number2, Number2), Auto2), "auto"],
    dimension: [Enum2(0, 1), 0],
    axis: [Nullable2(Ref2(Axis)), null],
    ticker: [Nullable2(Ref2(Ticker)), null]
  }));
  _a$1Q.override({
    level: "underlay",
    band_fill_color: null,
    band_fill_alpha: 0,
    grid_line_color: "#e5e5e5",
    minor_grid_line_color: null
  });
})();
var _a$1P;
class LayoutDOMView extends DOMView {
  constructor() {
    super(...arguments);
    this._offset_parent = null;
    this._viewport = {};
  }
  get is_layout_root() {
    return this.is_root || !(this.parent instanceof LayoutDOMView);
  }
  get base_font_size() {
    const font_size = getComputedStyle(this.el).fontSize;
    const result = parse_css_font_size(font_size);
    if (result != null) {
      const { value, unit } = result;
      if (unit == "px")
        return value;
    }
    return null;
  }
  initialize() {
    super.initialize();
    this.el.style.position = this.is_layout_root ? "relative" : "absolute";
    this._child_views = /* @__PURE__ */ new Map();
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    await this.build_child_views();
  }
  remove() {
    for (const child_view of this.child_views)
      child_view.remove();
    this._child_views.clear();
    super.remove();
  }
  connect_signals() {
    super.connect_signals();
    if (this.is_layout_root) {
      this._on_resize = () => this.resize_layout();
      window.addEventListener("resize", this._on_resize);
      this._parent_observer = setInterval(() => {
        const offset_parent = this.el.offsetParent;
        if (this._offset_parent != offset_parent) {
          this._offset_parent = offset_parent;
          if (offset_parent != null) {
            this.compute_viewport();
            this.invalidate_layout();
          }
        }
      }, 250);
    }
    const p2 = this.model.properties;
    this.on_change([
      p2.width,
      p2.height,
      p2.min_width,
      p2.min_height,
      p2.max_width,
      p2.max_height,
      p2.margin,
      p2.width_policy,
      p2.height_policy,
      p2.sizing_mode,
      p2.aspect_ratio,
      p2.visible
    ], () => this.invalidate_layout());
    this.on_change([
      p2.background,
      p2.css_classes
    ], () => this.invalidate_render());
  }
  disconnect_signals() {
    if (this._parent_observer != null)
      clearTimeout(this._parent_observer);
    if (this._on_resize != null)
      window.removeEventListener("resize", this._on_resize);
    super.disconnect_signals();
  }
  css_classes() {
    return super.css_classes().concat(this.model.css_classes);
  }
  get child_views() {
    return this.child_models.map((child) => this._child_views.get(child));
  }
  async build_child_views() {
    await build_views(this._child_views, this.child_models, { parent: this });
  }
  render() {
    super.render();
    empty$1(this.el);
    const { background } = this.model;
    this.el.style.backgroundColor = background != null ? color2css(background) : "";
    classes(this.el).clear().add(...this.css_classes());
    for (const child_view of this.child_views) {
      this.el.appendChild(child_view.el);
      child_view.render();
    }
  }
  update_layout() {
    for (const child_view of this.child_views)
      child_view.update_layout();
    this._update_layout();
  }
  update_position() {
    this.el.style.display = this.model.visible ? "block" : "none";
    const margin = this.is_layout_root ? this.layout.sizing.margin : void 0;
    position(this.el, this.layout.bbox, margin);
    for (const child_view of this.child_views)
      child_view.update_position();
  }
  after_layout() {
    for (const child_view of this.child_views)
      child_view.after_layout();
    this._has_finished = true;
  }
  compute_viewport() {
    this._viewport = this._viewport_size();
  }
  renderTo(element) {
    element.appendChild(this.el);
    this._offset_parent = this.el.offsetParent;
    this.compute_viewport();
    this.build();
    this.notify_finished();
  }
  build() {
    if (!this.is_layout_root)
      throw new Error(`${this.toString()} is not a root layout`);
    this.render();
    this.update_layout();
    this.compute_layout();
    return this;
  }
  async rebuild() {
    await this.build_child_views();
    this.invalidate_render();
  }
  compute_layout() {
    const start2 = Date.now();
    this.layout.compute(this._viewport);
    this.update_position();
    this.after_layout();
    logger.debug(`layout computed in ${Date.now() - start2} ms`);
  }
  resize_layout() {
    this.root.compute_viewport();
    this.root.compute_layout();
  }
  invalidate_layout() {
    this.root.update_layout();
    this.root.compute_layout();
  }
  invalidate_render() {
    this.render();
    this.invalidate_layout();
  }
  has_finished() {
    if (!super.has_finished())
      return false;
    for (const child_view of this.child_views) {
      if (!child_view.has_finished())
        return false;
    }
    return true;
  }
  _width_policy() {
    return this.model.width != null ? "fixed" : "fit";
  }
  _height_policy() {
    return this.model.height != null ? "fixed" : "fit";
  }
  box_sizing() {
    let { width_policy, height_policy, aspect_ratio } = this.model;
    if (width_policy == "auto")
      width_policy = this._width_policy();
    if (height_policy == "auto")
      height_policy = this._height_policy();
    const { sizing_mode } = this.model;
    if (sizing_mode != null) {
      if (sizing_mode == "fixed")
        width_policy = height_policy = "fixed";
      else if (sizing_mode == "stretch_both")
        width_policy = height_policy = "max";
      else if (sizing_mode == "stretch_width")
        width_policy = "max";
      else if (sizing_mode == "stretch_height")
        height_policy = "max";
      else {
        if (aspect_ratio == null)
          aspect_ratio = "auto";
        switch (sizing_mode) {
          case "scale_width":
            width_policy = "max";
            height_policy = "min";
            break;
          case "scale_height":
            width_policy = "min";
            height_policy = "max";
            break;
          case "scale_both":
            width_policy = "max";
            height_policy = "max";
            break;
        }
      }
    }
    const sizing = { width_policy, height_policy };
    const { min_width, min_height } = this.model;
    if (min_width != null)
      sizing.min_width = min_width;
    if (min_height != null)
      sizing.min_height = min_height;
    const { width, height } = this.model;
    if (width != null)
      sizing.width = width;
    if (height != null)
      sizing.height = height;
    const { max_width, max_height } = this.model;
    if (max_width != null)
      sizing.max_width = max_width;
    if (max_height != null)
      sizing.max_height = max_height;
    if (aspect_ratio == "auto" && width != null && height != null)
      sizing.aspect = width / height;
    else if (isNumber(aspect_ratio))
      sizing.aspect = aspect_ratio;
    const { margin } = this.model;
    if (margin != null) {
      if (isNumber(margin))
        sizing.margin = { top: margin, right: margin, bottom: margin, left: margin };
      else if (margin.length == 2) {
        const [vertical2, horizontal2] = margin;
        sizing.margin = { top: vertical2, right: horizontal2, bottom: vertical2, left: horizontal2 };
      } else {
        const [top, right2, bottom, left2] = margin;
        sizing.margin = { top, right: right2, bottom, left: left2 };
      }
    }
    sizing.visible = this.model.visible;
    const { align } = this.model;
    if (isArray(align))
      [sizing.halign, sizing.valign] = align;
    else
      sizing.halign = sizing.valign = align;
    return sizing;
  }
  _viewport_size() {
    return undisplayed(this.el, () => {
      let measuring = this.el;
      while (measuring = measuring.parentElement) {
        if (measuring.classList.contains(root$3))
          continue;
        if (measuring == document.body) {
          const { margin: { left: left3, right: right3, top: top2, bottom: bottom2 } } = extents(document.body);
          const width2 = Math.ceil(document.documentElement.clientWidth - left3 - right3);
          const height2 = Math.ceil(document.documentElement.clientHeight - top2 - bottom2);
          return { width: width2, height: height2 };
        }
        const { padding: { left: left2, right: right2, top, bottom } } = extents(measuring);
        const { width, height } = measuring.getBoundingClientRect();
        const inner_width = Math.ceil(width - left2 - right2);
        const inner_height = Math.ceil(height - top - bottom);
        if (inner_width > 0 || inner_height > 0)
          return {
            width: inner_width > 0 ? inner_width : void 0,
            height: inner_height > 0 ? inner_height : void 0
          };
      }
      return {};
    });
  }
  export(type, hidpi = true) {
    const output_backend = type == "png" ? "canvas" : "svg";
    const composite = new CanvasLayer(output_backend, hidpi);
    const { width, height } = this.layout.bbox;
    composite.resize(width, height);
    for (const view of this.child_views) {
      const region = view.export(type, hidpi);
      const { x: x2, y: y2 } = view.layout.bbox;
      composite.ctx.drawImage(region.canvas, x2, y2);
    }
    return composite;
  }
  serializable_state() {
    return {
      ...super.serializable_state(),
      bbox: this.layout.bbox.box,
      children: this.child_views.map((child) => child.serializable_state())
    };
  }
}
LayoutDOMView.__name__ = "LayoutDOMView";
class LayoutDOM extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1P = LayoutDOM;
LayoutDOM.__name__ = "LayoutDOM";
(() => {
  _a$1P.define((types) => {
    const { Boolean: Boolean2, Number: Number2, String: String2, Auto: Auto2, Color: Color2, Array: Array2, Tuple: Tuple2, Or: Or2, Null: Null2, Nullable: Nullable2 } = types;
    const Number22 = Tuple2(Number2, Number2);
    const Number4 = Tuple2(Number2, Number2, Number2, Number2);
    return {
      width: [Nullable2(Number2), null],
      height: [Nullable2(Number2), null],
      min_width: [Nullable2(Number2), null],
      min_height: [Nullable2(Number2), null],
      max_width: [Nullable2(Number2), null],
      max_height: [Nullable2(Number2), null],
      margin: [Nullable2(Or2(Number2, Number22, Number4)), [0, 0, 0, 0]],
      width_policy: [Or2(SizingPolicy, Auto2), "auto"],
      height_policy: [Or2(SizingPolicy, Auto2), "auto"],
      aspect_ratio: [Or2(Number2, Auto2, Null2), null],
      sizing_mode: [Nullable2(SizingMode), null],
      visible: [Boolean2, true],
      disabled: [Boolean2, false],
      align: [Or2(Align, Tuple2(Align, Align)), "start"],
      background: [Nullable2(Color2), null],
      css_classes: [Array2(String2), []]
    };
  });
})();
var _a$1O;
class BoxView extends LayoutDOMView {
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.children.change, () => this.rebuild());
  }
  get child_models() {
    return this.model.children;
  }
}
BoxView.__name__ = "BoxView";
class Box extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1O = Box;
Box.__name__ = "Box";
(() => {
  _a$1O.define(({ Number: Number2, Array: Array2, Ref: Ref2 }) => ({
    children: [Array2(Ref2(LayoutDOM)), []],
    spacing: [Number2, 0]
  }));
})();
var _a$1N;
class ColumnView extends BoxView {
  _update_layout() {
    const items = this.child_views.map((child) => child.layout);
    this.layout = new Column$1(items);
    this.layout.rows = this.model.rows;
    this.layout.spacing = [this.model.spacing, 0];
    this.layout.set_sizing(this.box_sizing());
  }
}
ColumnView.__name__ = "ColumnView";
class Column extends Box {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1N = Column;
Column.__name__ = "Column";
(() => {
  _a$1N.prototype.default_view = ColumnView;
  _a$1N.define(({ Any: Any2 }) => ({
    rows: [Any2, "auto"]
  }));
})();
var _a$1M;
class GridBoxView extends LayoutDOMView {
  connect_signals() {
    super.connect_signals();
    const { children: children2, rows, cols, spacing } = this.model.properties;
    this.on_change([children2, rows, cols, spacing], () => this.rebuild());
  }
  get child_models() {
    return this.model.children.map(([child]) => child);
  }
  _update_layout() {
    this.layout = new Grid$1();
    this.layout.rows = this.model.rows;
    this.layout.cols = this.model.cols;
    this.layout.spacing = this.model.spacing;
    for (const [child, row2, col, row_span, col_span] of this.model.children) {
      const child_view = this._child_views.get(child);
      this.layout.items.push({ layout: child_view.layout, row: row2, col, row_span, col_span });
    }
    this.layout.set_sizing(this.box_sizing());
  }
}
GridBoxView.__name__ = "GridBoxView";
class GridBox extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1M = GridBox;
GridBox.__name__ = "GridBox";
(() => {
  _a$1M.prototype.default_view = GridBoxView;
  _a$1M.define(({ Any: Any2, Int: Int2, Number: Number2, Tuple: Tuple2, Array: Array2, Ref: Ref2, Or: Or2, Opt: Opt2 }) => ({
    children: [Array2(Tuple2(Ref2(LayoutDOM), Int2, Int2, Opt2(Int2), Opt2(Int2))), []],
    rows: [Any2, "auto"],
    cols: [Any2, "auto"],
    spacing: [Or2(Number2, Tuple2(Number2, Number2)), 0]
  }));
})();
class HTMLBoxView extends LayoutDOMView {
  get child_models() {
    return [];
  }
  _update_layout() {
    this.layout = new ContentBox(this.el);
    this.layout.set_sizing(this.box_sizing());
  }
}
HTMLBoxView.__name__ = "HTMLBoxView";
class HTMLBox extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
  }
}
HTMLBox.__name__ = "HTMLBox";
var _a$1L;
class Panel extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1L = Panel;
Panel.__name__ = "Panel";
(() => {
  _a$1L.define(({ Boolean: Boolean2, String: String2, Ref: Ref2 }) => ({
    title: [String2, ""],
    child: [Ref2(LayoutDOM)],
    closable: [Boolean2, false],
    disabled: [Boolean2, false]
  }));
})();
var _a$1K;
class RowView extends BoxView {
  _update_layout() {
    const items = this.child_views.map((child) => child.layout);
    this.layout = new Row$1(items);
    this.layout.cols = this.model.cols;
    this.layout.spacing = [0, this.model.spacing];
    this.layout.set_sizing(this.box_sizing());
  }
}
RowView.__name__ = "RowView";
class Row extends Box {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1K = Row;
Row.__name__ = "Row";
(() => {
  _a$1K.prototype.default_view = RowView;
  _a$1K.define(({ Any: Any2 }) => ({
    cols: [Any2, "auto"]
  }));
})();
var _a$1J;
class SpacerView extends LayoutDOMView {
  get child_models() {
    return [];
  }
  _update_layout() {
    this.layout = new LayoutItem();
    this.layout.set_sizing(this.box_sizing());
  }
}
SpacerView.__name__ = "SpacerView";
class Spacer extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1J = Spacer;
Spacer.__name__ = "Spacer";
(() => {
  _a$1J.prototype.default_view = SpacerView;
})();
const root$1 = "bk-root";
const tabs_header = "bk-tabs-header";
const btn_group$1 = "bk-btn-group";
const btn$1 = "bk-btn";
const headers_wrapper = "bk-headers-wrapper";
const above = "bk-above";
const right = "bk-right";
const below = "bk-below";
const left = "bk-left";
const headers = "bk-headers";
const tab = "bk-tab";
const active$1 = "bk-active";
const close = "bk-close";
const disabled = "bk-disabled";
var tabs_css = `.bk-root .bk-tabs-header{display:flex;flex-wrap:nowrap;align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header .bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url('data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>');}.bk-root .bk-close:hover{background-image:url('data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>');}`;
var tabs = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root: root$1,
  tabs_header,
  btn_group: btn_group$1,
  btn: btn$1,
  headers_wrapper,
  above,
  right,
  below,
  left,
  headers,
  tab,
  active: active$1,
  close,
  disabled,
  "default": tabs_css
}, Symbol.toStringTag, { value: "Module" }));
const root = "bk-root";
const btn = "bk-btn";
const active = "bk-active";
const btn_default = "bk-btn-default";
const btn_primary = "bk-btn-primary";
const btn_success = "bk-btn-success";
const btn_warning = "bk-btn-warning";
const btn_danger = "bk-btn-danger";
const btn_light = "bk-btn-light";
const btn_group = "bk-btn-group";
const vertical = "bk-vertical";
const horizontal = "bk-horizontal";
const dropdown_toggle = "bk-dropdown-toggle";
var buttons_css = `.bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-btn-group:not(.bk-vertical),.bk-root .bk-btn-group.bk-horizontal{flex-direction:row;}.bk-root .bk-btn-group.bk-vertical{flex-direction:column;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:6px 6px;}`;
var buttons = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  root,
  btn,
  active,
  btn_default,
  btn_primary,
  btn_success,
  btn_warning,
  btn_danger,
  btn_light,
  btn_group,
  vertical,
  horizontal,
  dropdown_toggle,
  "default": buttons_css
}, Symbol.toStringTag, { value: "Module" }));
var _a$1I;
class TabsView extends LayoutDOMView {
  constructor() {
    super(...arguments);
    this._scroll_index = 0;
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.properties.tabs.change, () => this.rebuild());
    this.connect(this.model.properties.active.change, () => this.on_active_change());
  }
  styles() {
    return [...super.styles(), buttons_css, menus_css, tabs_css];
  }
  get child_models() {
    return this.model.tabs.map((tab2) => tab2.child);
  }
  _update_layout() {
    const loc = this.model.tabs_location;
    const vertical2 = loc == "above" || loc == "below";
    const { scroll_el, headers_el } = this;
    this.header = new class extends ContentBox {
      _measure(viewport) {
        const min_headers = 3;
        const scroll = size(scroll_el);
        const headers2 = children(headers_el).slice(0, min_headers).map((el) => size(el));
        const { width, height } = super._measure(viewport);
        if (vertical2) {
          const min_width = scroll.width + sum$2(headers2.map((size2) => size2.width));
          return { width: viewport.width != Infinity ? viewport.width : min_width, height };
        } else {
          const min_height = scroll.height + sum$2(headers2.map((size2) => size2.height));
          return { width, height: viewport.height != Infinity ? viewport.height : min_height };
        }
      }
    }(this.header_el);
    if (vertical2)
      this.header.set_sizing({ width_policy: "fit", height_policy: "fixed" });
    else
      this.header.set_sizing({ width_policy: "fixed", height_policy: "fit" });
    let row2 = 1;
    let col = 1;
    switch (loc) {
      case "above":
        row2 -= 1;
        break;
      case "below":
        row2 += 1;
        break;
      case "left":
        col -= 1;
        break;
      case "right":
        col += 1;
        break;
    }
    const header = { layout: this.header, row: row2, col };
    const panels = this.child_views.map((child_view) => {
      return { layout: child_view.layout, row: 1, col: 1 };
    });
    this.layout = new Grid$1([header, ...panels]);
    this.layout.set_sizing(this.box_sizing());
  }
  update_position() {
    super.update_position();
    this.header_el.style.position = "absolute";
    position(this.header_el, this.header.bbox);
    const loc = this.model.tabs_location;
    const vertical2 = loc == "above" || loc == "below";
    const scroll_el_size = size(this.scroll_el);
    const headers_el_size = scroll_size(this.headers_el);
    if (vertical2) {
      const { width } = this.header.bbox;
      if (headers_el_size.width > width) {
        this.wrapper_el.style.maxWidth = `${width - scroll_el_size.width}px`;
        display(this.scroll_el);
        this.do_scroll(this.model.active);
      } else {
        this.wrapper_el.style.maxWidth = "";
        undisplay(this.scroll_el);
      }
    } else {
      const { height } = this.header.bbox;
      if (headers_el_size.height > height) {
        this.wrapper_el.style.maxHeight = `${height - scroll_el_size.height}px`;
        display(this.scroll_el);
        this.do_scroll(this.model.active);
      } else {
        this.wrapper_el.style.maxHeight = "";
        undisplay(this.scroll_el);
      }
    }
    const { child_views } = this;
    for (const child_view of child_views)
      hide(child_view.el);
    const tab2 = child_views[this.model.active];
    if (tab2 != null)
      show(tab2.el);
  }
  render() {
    super.render();
    const { active: active2 } = this.model;
    const headers$1 = this.model.tabs.map((tab$1, i2) => {
      const el = div({ class: [tab, i2 == active2 ? active$1 : null] }, tab$1.title);
      el.addEventListener("click", (event2) => {
        if (this.model.disabled)
          return;
        if (event2.target == event2.currentTarget)
          this.change_active(i2);
      });
      if (tab$1.closable) {
        const close_el = div({ class: close });
        close_el.addEventListener("click", (event2) => {
          if (event2.target == event2.currentTarget) {
            this.model.tabs = remove_at(this.model.tabs, i2);
            const ntabs = this.model.tabs.length;
            if (this.model.active > ntabs - 1)
              this.model.active = ntabs - 1;
          }
        });
        el.appendChild(close_el);
      }
      if (this.model.disabled || tab$1.disabled) {
        el.classList.add(disabled);
      }
      return el;
    });
    this.headers_el = div({ class: [headers] }, headers$1);
    this.wrapper_el = div({ class: headers_wrapper }, this.headers_el);
    this.left_el = div({ class: [btn, btn_default], disabled: "" }, div({ class: [caret, left] }));
    this.right_el = div({ class: [btn, btn_default] }, div({ class: [caret, right] }));
    this.left_el.addEventListener("click", () => this.do_scroll("left"));
    this.right_el.addEventListener("click", () => this.do_scroll("right"));
    this.scroll_el = div({ class: btn_group }, this.left_el, this.right_el);
    const loc = this.model.tabs_location;
    this.header_el = div({ class: [tabs_header, tabs[loc]] }, this.scroll_el, this.wrapper_el);
    this.el.appendChild(this.header_el);
  }
  do_scroll(target) {
    const ntabs = this.model.tabs.length;
    if (target == "left")
      this._scroll_index -= 1;
    else if (target == "right")
      this._scroll_index += 1;
    else
      this._scroll_index = target;
    this._scroll_index = clamp(this._scroll_index, 0, ntabs - 1);
    if (this._scroll_index == 0)
      this.left_el.setAttribute("disabled", "");
    else
      this.left_el.removeAttribute("disabled");
    if (this._scroll_index == ntabs - 1)
      this.right_el.setAttribute("disabled", "");
    else
      this.right_el.removeAttribute("disabled");
    const sizes = children(this.headers_el).slice(0, this._scroll_index).map((el) => el.getBoundingClientRect());
    const loc = this.model.tabs_location;
    const vertical2 = loc == "above" || loc == "below";
    if (vertical2) {
      const left2 = -sum$2(sizes.map((size2) => size2.width));
      this.headers_el.style.left = `${left2}px`;
    } else {
      const top = -sum$2(sizes.map((size2) => size2.height));
      this.headers_el.style.top = `${top}px`;
    }
  }
  change_active(i2) {
    if (i2 != this.model.active) {
      this.model.active = i2;
    }
  }
  on_active_change() {
    const i2 = this.model.active;
    const headers2 = children(this.headers_el);
    for (const el of headers2)
      el.classList.remove(active$1);
    headers2[i2].classList.add(active$1);
    const { child_views } = this;
    for (const child_view of child_views)
      hide(child_view.el);
    show(child_views[i2].el);
  }
}
TabsView.__name__ = "TabsView";
class Tabs extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1I = Tabs;
Tabs.__name__ = "Tabs";
(() => {
  _a$1I.prototype.default_view = TabsView;
  _a$1I.define(({ Int: Int2, Array: Array2, Ref: Ref2 }) => ({
    tabs: [Array2(Ref2(Panel)), []],
    tabs_location: [Location, "above"],
    active: [Int2, 0]
  }));
})();
var _a$1H;
class WidgetBoxView extends ColumnView {
}
WidgetBoxView.__name__ = "WidgetBoxView";
class WidgetBox extends Column {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1H = WidgetBox;
WidgetBox.__name__ = "WidgetBox";
(() => {
  _a$1H.prototype.default_view = WidgetBoxView;
})();
var _a$1G;
class CustomJSTransform extends Transform {
  constructor(attrs) {
    super(attrs);
  }
  get names() {
    return keys(this.args);
  }
  get values() {
    return values(this.args);
  }
  _make_transform(name, func) {
    return new Function(...this.names, name, use_strict(func));
  }
  get scalar_transform() {
    return this._make_transform("x", this.func);
  }
  get vector_transform() {
    return this._make_transform("xs", this.v_func);
  }
  compute(x2) {
    return this.scalar_transform(...this.values, x2);
  }
  v_compute(xs) {
    return this.vector_transform(...this.values, xs);
  }
}
_a$1G = CustomJSTransform;
CustomJSTransform.__name__ = "CustomJSTransform";
(() => {
  _a$1G.define(({ Unknown: Unknown2, String: String2, Dict: Dict2 }) => ({
    args: [Dict2(Unknown2), {}],
    func: [String2, ""],
    v_func: [String2, ""]
  }));
})();
var _a$1F;
class RangeTransform extends Transform {
  constructor(attrs) {
    super(attrs);
  }
  v_compute(xs0) {
    let xs;
    if (this.range instanceof FactorRange)
      xs = this.range.v_synthetic(xs0);
    else if (isArrayableOf(xs0, isNumber))
      xs = xs0;
    else
      unreachable();
    const result = new (infer_type(xs))(xs.length);
    for (let i2 = 0; i2 < xs.length; i2++) {
      const x2 = xs[i2];
      result[i2] = this._compute(x2);
    }
    return result;
  }
  compute(x2) {
    if (this.range instanceof FactorRange)
      return this._compute(this.range.synthetic(x2));
    else if (isNumber(x2))
      return this._compute(x2);
    else
      unreachable();
  }
}
_a$1F = RangeTransform;
RangeTransform.__name__ = "RangeTransform";
(() => {
  _a$1F.define(({ Ref: Ref2, Nullable: Nullable2 }) => ({
    range: [Nullable2(Ref2(Range$1)), null]
  }));
})();
var _a$1E;
class Dodge extends RangeTransform {
  constructor(attrs) {
    super(attrs);
  }
  _compute(x2) {
    return x2 + this.value;
  }
}
_a$1E = Dodge;
Dodge.__name__ = "Dodge";
(() => {
  _a$1E.define(({ Number: Number2 }) => ({
    value: [Number2, 0]
  }));
})();
var _a$1D;
class Interpolator extends Transform {
  constructor(attrs) {
    super(attrs);
    this._sorted_dirty = true;
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.change, () => this._sorted_dirty = true);
  }
  v_compute(xs) {
    const ArrayType = infer_type(xs);
    const result = new ArrayType(xs.length);
    for (let i2 = 0; i2 < xs.length; i2++) {
      const x2 = xs[i2];
      result[i2] = this.compute(x2);
    }
    return result;
  }
  sort(descending = false) {
    if (!this._sorted_dirty)
      return;
    let tsx;
    let tsy;
    if (isString(this.x) && isString(this.y) && this.data != null) {
      const column_names = this.data.columns();
      if (!includes(column_names, this.x))
        throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");
      if (!includes(column_names, this.y))
        throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");
      tsx = this.data.get_column(this.x);
      tsy = this.data.get_column(this.y);
    } else if (isArray(this.x) && isArray(this.y)) {
      tsx = this.x;
      tsy = this.y;
    } else {
      throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");
    }
    if (tsx.length !== tsy.length)
      throw new Error("The length for x and y do not match");
    if (tsx.length < 2)
      throw new Error("x and y must have at least two elements to support interpolation");
    const n2 = tsx.length;
    const index2 = new Uint32Array(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      index2[i2] = i2;
    }
    const sign2 = descending ? -1 : 1;
    index2.sort((i2, j) => sign2 * (tsx[i2] - tsx[j]));
    this._x_sorted = new (infer_type(tsx))(n2);
    this._y_sorted = new (infer_type(tsy))(n2);
    for (let i2 = 0; i2 < n2; i2++) {
      this._x_sorted[i2] = tsx[index2[i2]];
      this._y_sorted[i2] = tsy[index2[i2]];
    }
    this._sorted_dirty = false;
  }
}
_a$1D = Interpolator;
Interpolator.__name__ = "Interpolator";
(() => {
  _a$1D.define(({ Boolean: Boolean2, Number: Number2, String: String2, Ref: Ref2, Array: Array2, Or: Or2, Nullable: Nullable2 }) => ({
    x: [Or2(String2, Array2(Number2))],
    y: [Or2(String2, Array2(Number2))],
    data: [Nullable2(Ref2(ColumnarDataSource)), null],
    clip: [Boolean2, true]
  }));
})();
var _a$1C;
class Jitter extends RangeTransform {
  constructor(attrs) {
    super(attrs);
  }
  v_compute(xs0) {
    var _a2;
    let xs;
    if (this.range instanceof FactorRange)
      xs = this.range.v_synthetic(xs0);
    else if (isArrayableOf(xs0, isNumber))
      xs = xs0;
    else
      unreachable();
    const xs_length = xs.length;
    if (((_a2 = this.previous_offsets) == null ? void 0 : _a2.length) != xs_length) {
      this.previous_offsets = new Array(xs_length);
      this.previous_offsets = map(this.previous_offsets, () => this._compute());
    }
    const offsets = this.previous_offsets;
    return map(xs, (xs2, i2) => offsets[i2] + xs2);
  }
  _compute() {
    switch (this.distribution) {
      case "uniform":
        return this.mean + (random$1() - 0.5) * this.width;
      case "normal":
        return rnorm(this.mean, this.width);
    }
  }
}
_a$1C = Jitter;
Jitter.__name__ = "Jitter";
(() => {
  _a$1C.define(({ Number: Number2 }) => ({
    mean: [Number2, 0],
    width: [Number2, 1],
    distribution: [Distribution, "uniform"]
  }));
})();
class LinearInterpolator extends Interpolator {
  constructor(attrs) {
    super(attrs);
  }
  compute(x2) {
    this.sort(false);
    if (this.clip) {
      if (x2 < this._x_sorted[0] || x2 > this._x_sorted[this._x_sorted.length - 1])
        return NaN;
    } else {
      if (x2 < this._x_sorted[0])
        return this._y_sorted[0];
      if (x2 > this._x_sorted[this._x_sorted.length - 1])
        return this._y_sorted[this._y_sorted.length - 1];
    }
    if (x2 == this._x_sorted[0])
      return this._y_sorted[0];
    const ind = find_last_index(this._x_sorted, (num2) => num2 < x2);
    const x1 = this._x_sorted[ind];
    const x22 = this._x_sorted[ind + 1];
    const y1 = this._y_sorted[ind];
    const y2 = this._y_sorted[ind + 1];
    return y1 + (x2 - x1) / (x22 - x1) * (y2 - y1);
  }
}
LinearInterpolator.__name__ = "LinearInterpolator";
var _a$1B;
class StepInterpolator extends Interpolator {
  constructor(attrs) {
    super(attrs);
  }
  compute(x2) {
    this.sort(false);
    if (this.clip) {
      if (x2 < this._x_sorted[0] || x2 > this._x_sorted[this._x_sorted.length - 1])
        return NaN;
    } else {
      if (x2 < this._x_sorted[0])
        return this._y_sorted[0];
      if (x2 > this._x_sorted[this._x_sorted.length - 1])
        return this._y_sorted[this._y_sorted.length - 1];
    }
    let ind;
    switch (this.mode) {
      case "after": {
        ind = find_last_index(this._x_sorted, (num2) => x2 >= num2);
        break;
      }
      case "before": {
        ind = find_index(this._x_sorted, (num2) => x2 <= num2);
        break;
      }
      case "center": {
        const diffs = map(this._x_sorted, (tx) => Math.abs(tx - x2));
        const mdiff = min$6(diffs);
        ind = find_index(diffs, (num2) => mdiff === num2);
        break;
      }
      default:
        throw new Error(`unknown mode: ${this.mode}`);
    }
    return ind != -1 ? this._y_sorted[ind] : NaN;
  }
}
_a$1B = StepInterpolator;
StepInterpolator.__name__ = "StepInterpolator";
(() => {
  _a$1B.define(() => ({
    mode: [StepMode, "after"]
  }));
})();
function throttle(func, wait) {
  let timeout = null;
  let previous = 0;
  let pending = false;
  return function() {
    return new Promise((resolve, reject) => {
      const later = function() {
        previous = Date.now();
        timeout = null;
        pending = false;
        try {
          func();
          resolve();
        } catch (error) {
          reject(error);
        }
      };
      const now = Date.now();
      const remaining = wait - (now - previous);
      if (remaining <= 0 && !pending) {
        if (timeout != null) {
          clearTimeout(timeout);
        }
        pending = true;
        requestAnimationFrame(later);
      } else if (!timeout && !pending) {
        timeout = setTimeout(() => requestAnimationFrame(later), remaining);
      } else {
        resolve();
      }
    });
  };
}
class RangeManager {
  constructor(parent) {
    this.parent = parent;
    this.invalidate_dataranges = true;
  }
  get frame() {
    return this.parent.frame;
  }
  update(range_info, options2) {
    const { x_ranges, y_ranges } = this.frame;
    if (range_info == null) {
      for (const [, range2] of x_ranges) {
        range2.reset();
      }
      for (const [, range2] of y_ranges) {
        range2.reset();
      }
      this.update_dataranges();
    } else {
      const range_info_iter = [];
      for (const [name, range2] of x_ranges) {
        range_info_iter.push([range2, range_info.xrs.get(name)]);
      }
      for (const [name, range2] of y_ranges) {
        range_info_iter.push([range2, range_info.yrs.get(name)]);
      }
      if (options2 == null ? void 0 : options2.scrolling) {
        this._update_ranges_together(range_info_iter);
      }
      this._update_ranges_individually(range_info_iter, options2);
    }
  }
  reset() {
    this.update(null);
  }
  _update_dataranges(frame) {
    const bounds = /* @__PURE__ */ new Map();
    const log_bounds = /* @__PURE__ */ new Map();
    let calculate_log_bounds = false;
    for (const [, xr] of frame.x_ranges) {
      if (xr instanceof DataRange1d && xr.scale_hint == "log")
        calculate_log_bounds = true;
    }
    for (const [, yr] of frame.y_ranges) {
      if (yr instanceof DataRange1d && yr.scale_hint == "log")
        calculate_log_bounds = true;
    }
    for (const renderer of this.parent.model.data_renderers) {
      const renderer_view = this.parent.renderer_view(renderer);
      if (renderer_view == null)
        continue;
      const bds = renderer_view.glyph_view.bounds();
      if (bds != null)
        bounds.set(renderer, bds);
      if (calculate_log_bounds) {
        const log_bds = renderer_view.glyph_view.log_bounds();
        if (log_bds != null)
          log_bounds.set(renderer, log_bds);
      }
    }
    let follow_enabled = false;
    let has_bounds = false;
    const width = frame.x_target.span;
    const height = frame.y_target.span;
    let r;
    if (this.parent.model.match_aspect !== false && width != 0 && height != 0)
      r = 1 / this.parent.model.aspect_scale * (width / height);
    for (const [, xr] of frame.x_ranges) {
      if (xr instanceof DataRange1d) {
        const bounds_to_use = xr.scale_hint == "log" ? log_bounds : bounds;
        xr.update(bounds_to_use, 0, this.parent.model, r);
        if (xr.follow) {
          follow_enabled = true;
        }
      }
      if (xr.bounds != null)
        has_bounds = true;
    }
    for (const [, yr] of frame.y_ranges) {
      if (yr instanceof DataRange1d) {
        const bounds_to_use = yr.scale_hint == "log" ? log_bounds : bounds;
        yr.update(bounds_to_use, 1, this.parent.model, r);
        if (yr.follow) {
          follow_enabled = true;
        }
      }
      if (yr.bounds != null)
        has_bounds = true;
    }
    if (follow_enabled && has_bounds) {
      logger.warn("Follow enabled so bounds are unset.");
      for (const [, xr] of frame.x_ranges) {
        xr.bounds = null;
      }
      for (const [, yr] of frame.y_ranges) {
        yr.bounds = null;
      }
    }
  }
  update_dataranges() {
    this._update_dataranges(this.frame);
    for (const renderer of this.parent.model.renderers) {
      const { coordinates } = renderer;
      if (coordinates != null)
        this._update_dataranges(coordinates);
    }
    if (this.compute_initial() != null)
      this.invalidate_dataranges = false;
  }
  compute_initial() {
    let good_vals = true;
    const { x_ranges, y_ranges } = this.frame;
    const xrs = /* @__PURE__ */ new Map();
    const yrs = /* @__PURE__ */ new Map();
    for (const [name, range2] of x_ranges) {
      const { start: start2, end } = range2;
      if (start2 == null || end == null || isNaN(start2 + end)) {
        good_vals = false;
        break;
      }
      xrs.set(name, { start: start2, end });
    }
    if (good_vals) {
      for (const [name, range2] of y_ranges) {
        const { start: start2, end } = range2;
        if (start2 == null || end == null || isNaN(start2 + end)) {
          good_vals = false;
          break;
        }
        yrs.set(name, { start: start2, end });
      }
    }
    if (good_vals)
      return { xrs, yrs };
    else {
      logger.warn("could not set initial ranges");
      return null;
    }
  }
  _update_ranges_together(range_info_iter) {
    let weight = 1;
    for (const [rng, range_info] of range_info_iter) {
      weight = Math.min(weight, this._get_weight_to_constrain_interval(rng, range_info));
    }
    if (weight < 1) {
      for (const [rng, range_info] of range_info_iter) {
        range_info.start = weight * range_info.start + (1 - weight) * rng.start;
        range_info.end = weight * range_info.end + (1 - weight) * rng.end;
      }
    }
  }
  _update_ranges_individually(range_info_iter, options2) {
    const panning = !!(options2 == null ? void 0 : options2.panning);
    const scrolling = !!(options2 == null ? void 0 : options2.scrolling);
    let hit_bound = false;
    for (const [rng, range_info] of range_info_iter) {
      if (!scrolling) {
        const weight = this._get_weight_to_constrain_interval(rng, range_info);
        if (weight < 1) {
          range_info.start = weight * range_info.start + (1 - weight) * rng.start;
          range_info.end = weight * range_info.end + (1 - weight) * rng.end;
        }
      }
      if (rng.bounds != null && rng.bounds != "auto") {
        const [min2, max2] = rng.bounds;
        const new_interval = Math.abs(range_info.end - range_info.start);
        if (rng.is_reversed) {
          if (min2 != null) {
            if (min2 > range_info.end) {
              hit_bound = true;
              range_info.end = min2;
              if (panning || scrolling) {
                range_info.start = min2 + new_interval;
              }
            }
          }
          if (max2 != null) {
            if (max2 < range_info.start) {
              hit_bound = true;
              range_info.start = max2;
              if (panning || scrolling) {
                range_info.end = max2 - new_interval;
              }
            }
          }
        } else {
          if (min2 != null) {
            if (min2 > range_info.start) {
              hit_bound = true;
              range_info.start = min2;
              if (panning || scrolling) {
                range_info.end = min2 + new_interval;
              }
            }
          }
          if (max2 != null) {
            if (max2 < range_info.end) {
              hit_bound = true;
              range_info.end = max2;
              if (panning || scrolling) {
                range_info.start = max2 - new_interval;
              }
            }
          }
        }
      }
    }
    if (scrolling && hit_bound && (options2 == null ? void 0 : options2.maintain_focus))
      return;
    for (const [rng, range_info] of range_info_iter) {
      rng.have_updated_interactively = true;
      if (rng.start != range_info.start || rng.end != range_info.end)
        rng.setv(range_info);
    }
  }
  _get_weight_to_constrain_interval(rng, range_info) {
    const { min_interval } = rng;
    let { max_interval } = rng;
    if (rng.bounds != null && rng.bounds != "auto") {
      const [min2, max2] = rng.bounds;
      if (min2 != null && max2 != null) {
        const max_interval2 = Math.abs(max2 - min2);
        max_interval = max_interval != null ? Math.min(max_interval, max_interval2) : max_interval2;
      }
    }
    let weight = 1;
    if (min_interval != null || max_interval != null) {
      const old_interval = Math.abs(rng.end - rng.start);
      const new_interval = Math.abs(range_info.end - range_info.start);
      if (min_interval != null && min_interval > 0 && new_interval < min_interval) {
        weight = (old_interval - min_interval) / (old_interval - new_interval);
      }
      if (max_interval != null && max_interval > 0 && new_interval > max_interval) {
        weight = (max_interval - old_interval) / (new_interval - old_interval);
      }
      weight = Math.max(0, Math.min(1, weight));
    }
    return weight;
  }
}
RangeManager.__name__ = "RangeManager";
class StateManager {
  constructor(parent, initial_state) {
    this.parent = parent;
    this.initial_state = initial_state;
    this.changed = new Signal0(this.parent, "state_changed");
    this.history = [];
    this.index = -1;
  }
  _do_state_change(index2) {
    const state = this.history[index2] != null ? this.history[index2].state : this.initial_state;
    if (state.range != null)
      this.parent.update_range(state.range);
    if (state.selection != null)
      this.parent.update_selection(state.selection);
    return state;
  }
  push(type, new_state) {
    const { history, index: index2 } = this;
    const prev_state = history[index2] != null ? history[index2].state : {};
    const state = { ...this.initial_state, ...prev_state, ...new_state };
    this.history = this.history.slice(0, this.index + 1);
    this.history.push({ type, state });
    this.index = this.history.length - 1;
    this.changed.emit();
  }
  clear() {
    this.history = [];
    this.index = -1;
    this.changed.emit();
  }
  undo() {
    if (this.can_undo) {
      this.index -= 1;
      const state = this._do_state_change(this.index);
      this.changed.emit();
      return state;
    }
    return null;
  }
  redo() {
    if (this.can_redo) {
      this.index += 1;
      const state = this._do_state_change(this.index);
      this.changed.emit();
      return state;
    }
    return null;
  }
  get can_undo() {
    return this.index >= 0;
  }
  get can_redo() {
    return this.index < this.history.length - 1;
  }
}
StateManager.__name__ = "StateManager";
class PlotView extends LayoutDOMView {
  constructor() {
    super(...arguments);
    this._outer_bbox = new BBox$2();
    this._inner_bbox = new BBox$2();
    this._needs_paint = true;
    this._needs_layout = false;
    this._invalidated_painters = /* @__PURE__ */ new Set();
    this._invalidate_all = true;
    this._needs_notify = false;
  }
  get canvas() {
    return this.canvas_view;
  }
  get state() {
    return this._state_manager;
  }
  set invalidate_dataranges(value) {
    this._range_manager.invalidate_dataranges = value;
  }
  renderer_view(renderer) {
    const view = this.renderer_views.get(renderer);
    if (view == null) {
      for (const [, renderer_view] of this.renderer_views) {
        const view2 = renderer_view.renderer_view(renderer);
        if (view2 != null)
          return view2;
      }
    }
    return view;
  }
  get is_paused() {
    return this._is_paused != null && this._is_paused !== 0;
  }
  get child_models() {
    return [];
  }
  pause() {
    if (this._is_paused == null)
      this._is_paused = 1;
    else
      this._is_paused += 1;
  }
  unpause(no_render = false) {
    if (this._is_paused == null)
      throw new Error("wasn't paused");
    this._is_paused -= 1;
    if (this._is_paused == 0 && !no_render)
      this.request_paint("everything");
  }
  notify_finished_after_paint() {
    this._needs_notify = true;
  }
  request_render() {
    this.request_paint("everything");
  }
  request_paint(to_invalidate) {
    this.invalidate_painters(to_invalidate);
    this.schedule_paint();
  }
  invalidate_painters(to_invalidate) {
    if (to_invalidate == "everything")
      this._invalidate_all = true;
    else if (isArray(to_invalidate)) {
      for (const renderer_view of to_invalidate)
        this._invalidated_painters.add(renderer_view);
    } else
      this._invalidated_painters.add(to_invalidate);
  }
  schedule_paint() {
    if (!this.is_paused) {
      const promise = this.throttled_paint();
      this._ready = this._ready.then(() => promise);
    }
  }
  request_layout() {
    this._needs_layout = true;
    this.request_paint("everything");
  }
  reset() {
    if (this.model.reset_policy == "standard") {
      this.state.clear();
      this.reset_range();
      this.reset_selection();
    }
    this.model.trigger_event(new Reset());
  }
  remove() {
    remove_views(this.renderer_views);
    remove_views(this.tool_views);
    this.canvas_view.remove();
    super.remove();
  }
  render() {
    super.render();
    this.el.appendChild(this.canvas_view.el);
    this.canvas_view.render();
  }
  initialize() {
    this.pause();
    super.initialize();
    this.lod_started = false;
    this.visuals = new Visuals(this);
    this._initial_state = {
      selection: /* @__PURE__ */ new Map(),
      dimensions: { width: 0, height: 0 }
    };
    this.visibility_callbacks = [];
    this.renderer_views = /* @__PURE__ */ new Map();
    this.tool_views = /* @__PURE__ */ new Map();
    this.frame = new CartesianFrame(this.model.x_scale, this.model.y_scale, this.model.x_range, this.model.y_range, this.model.extra_x_ranges, this.model.extra_y_ranges, this.model.extra_x_scales, this.model.extra_y_scales);
    this._range_manager = new RangeManager(this);
    this._state_manager = new StateManager(this, this._initial_state);
    this.throttled_paint = throttle(() => this.repaint(), 1e3 / 60);
    const { title_location, title } = this.model;
    if (title_location != null && title != null) {
      this._title = title instanceof Title ? title : new Title({ text: title });
    }
    const { toolbar_location, toolbar: toolbar2 } = this.model;
    if (toolbar_location != null && toolbar2 != null) {
      this._toolbar = new ToolbarPanel({ toolbar: toolbar2 });
      toolbar2.toolbar_location = toolbar_location;
    }
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    const { hidpi, output_backend } = this.model;
    const canvas2 = new Canvas({ hidpi, output_backend });
    this.canvas_view = await build_view(canvas2, { parent: this });
    this.canvas_view.plot_views = [this];
    await this.build_renderer_views();
    await this.build_tool_views();
    this._range_manager.update_dataranges();
    this.unpause(true);
    logger.debug("PlotView initialized");
  }
  _width_policy() {
    return this.model.frame_width == null ? super._width_policy() : "min";
  }
  _height_policy() {
    return this.model.frame_height == null ? super._height_policy() : "min";
  }
  _update_layout() {
    var _a2, _b2, _c2, _d2, _e2;
    this.layout = new BorderLayout();
    this.layout.set_sizing(this.box_sizing());
    const above2 = copy(this.model.above);
    const below2 = copy(this.model.below);
    const left2 = copy(this.model.left);
    const right2 = copy(this.model.right);
    const get_side = (side) => {
      switch (side) {
        case "above":
          return above2;
        case "below":
          return below2;
        case "left":
          return left2;
        case "right":
          return right2;
      }
    };
    const { title_location, title } = this.model;
    if (title_location != null && title != null) {
      get_side(title_location).push(this._title);
    }
    const { toolbar_location, toolbar: toolbar2 } = this.model;
    if (toolbar_location != null && toolbar2 != null) {
      const panels = get_side(toolbar_location);
      let push_toolbar = true;
      if (this.model.toolbar_sticky) {
        for (let i2 = 0; i2 < panels.length; i2++) {
          const panel = panels[i2];
          if (panel instanceof Title) {
            if (toolbar_location == "above" || toolbar_location == "below")
              panels[i2] = [panel, this._toolbar];
            else
              panels[i2] = [this._toolbar, panel];
            push_toolbar = false;
            break;
          }
        }
      }
      if (push_toolbar)
        panels.push(this._toolbar);
    }
    const set_layout = (side, model) => {
      var _a3;
      const view = this.renderer_view(model);
      view.panel = new Panel$1(side);
      (_a3 = view.update_layout) == null ? void 0 : _a3.call(view);
      return view.layout;
    };
    const set_layouts = (side, panels) => {
      const horizontal2 = side == "above" || side == "below";
      const layouts = [];
      for (const panel of panels) {
        if (isArray(panel)) {
          const items = panel.map((subpanel) => {
            const item = set_layout(side, subpanel);
            if (subpanel instanceof ToolbarPanel) {
              const dim = horizontal2 ? "width_policy" : "height_policy";
              item.set_sizing({ ...item.sizing, [dim]: "min" });
            }
            return item;
          });
          let layout;
          if (horizontal2) {
            layout = new Row$1(items);
            layout.set_sizing({ width_policy: "max", height_policy: "min" });
          } else {
            layout = new Column$1(items);
            layout.set_sizing({ width_policy: "min", height_policy: "max" });
          }
          layout.absolute = true;
          layouts.push(layout);
        } else
          layouts.push(set_layout(side, panel));
      }
      return layouts;
    };
    const min_border = (_a2 = this.model.min_border) != null ? _a2 : 0;
    this.layout.min_border = {
      left: (_b2 = this.model.min_border_left) != null ? _b2 : min_border,
      top: (_c2 = this.model.min_border_top) != null ? _c2 : min_border,
      right: (_d2 = this.model.min_border_right) != null ? _d2 : min_border,
      bottom: (_e2 = this.model.min_border_bottom) != null ? _e2 : min_border
    };
    const center_panel = new NodeLayout();
    const top_panel = new VStack();
    const bottom_panel = new VStack();
    const left_panel = new HStack();
    const right_panel = new HStack();
    center_panel.absolute = true;
    top_panel.absolute = true;
    bottom_panel.absolute = true;
    left_panel.absolute = true;
    right_panel.absolute = true;
    center_panel.children = this.model.center.filter((obj) => {
      return obj instanceof Annotation;
    }).map((model) => {
      var _a3;
      const view = this.renderer_view(model);
      (_a3 = view.update_layout) == null ? void 0 : _a3.call(view);
      return view.layout;
    }).filter((layout) => {
      return layout != null;
    });
    const { frame_width, frame_height } = this.model;
    center_panel.set_sizing({
      ...frame_width != null ? { width_policy: "fixed", width: frame_width } : { width_policy: "fit" },
      ...frame_height != null ? { height_policy: "fixed", height: frame_height } : { height_policy: "fit" }
    });
    center_panel.on_resize((bbox) => this.frame.set_geometry(bbox));
    top_panel.children = reversed(set_layouts("above", above2));
    bottom_panel.children = set_layouts("below", below2);
    left_panel.children = reversed(set_layouts("left", left2));
    right_panel.children = set_layouts("right", right2);
    top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
    bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
    left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
    right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
    this.layout.center_panel = center_panel;
    this.layout.top_panel = top_panel;
    this.layout.bottom_panel = bottom_panel;
    this.layout.left_panel = left_panel;
    this.layout.right_panel = right_panel;
  }
  get axis_views() {
    const views = [];
    for (const [, renderer_view] of this.renderer_views) {
      if (renderer_view instanceof AxisView)
        views.push(renderer_view);
    }
    return views;
  }
  set_toolbar_visibility(visible) {
    for (const callback of this.visibility_callbacks)
      callback(visible);
  }
  update_range(range_info, options2) {
    this.pause();
    this._range_manager.update(range_info, options2);
    this.unpause();
  }
  reset_range() {
    this.update_range(null);
    this.trigger_ranges_update_event();
  }
  trigger_ranges_update_event() {
    const { x_range, y_range } = this.model;
    this.model.trigger_event(new RangesUpdate(x_range.start, x_range.end, y_range.start, y_range.end));
  }
  get_selection() {
    const selection = /* @__PURE__ */ new Map();
    for (const renderer of this.model.data_renderers) {
      const { selected } = renderer.selection_manager.source;
      selection.set(renderer, selected);
    }
    return selection;
  }
  update_selection(selections) {
    for (const renderer of this.model.data_renderers) {
      const ds = renderer.selection_manager.source;
      if (selections != null) {
        const selection = selections.get(renderer);
        if (selection != null) {
          ds.selected.update(selection, true);
        }
      } else
        ds.selection_manager.clear();
    }
  }
  reset_selection() {
    this.update_selection(null);
  }
  _invalidate_layout() {
    const needs_layout = () => {
      var _a2;
      for (const panel of this.model.side_panels) {
        const view = this.renderer_views.get(panel);
        if ((_a2 = view.layout) == null ? void 0 : _a2.has_size_changed()) {
          this.invalidate_painters(view);
          return true;
        }
      }
      return false;
    };
    if (needs_layout())
      this.root.compute_layout();
  }
  get_renderer_views() {
    return this.computed_renderers.map((r) => this.renderer_views.get(r));
  }
  *_compute_renderers() {
    const { above: above2, below: below2, left: left2, right: right2, center, renderers } = this.model;
    yield* renderers;
    yield* above2;
    yield* below2;
    yield* left2;
    yield* right2;
    yield* center;
    if (this._title != null)
      yield this._title;
    if (this._toolbar != null)
      yield this._toolbar;
    for (const tool of this.model.toolbar.tools) {
      if (tool.overlay != null)
        yield tool.overlay;
      yield* tool.synthetic_renderers;
    }
  }
  async build_renderer_views() {
    this.computed_renderers = [...this._compute_renderers()];
    await build_views(this.renderer_views, this.computed_renderers, { parent: this });
  }
  async build_tool_views() {
    const tool_models = this.model.toolbar.tools;
    const new_tool_views = await build_views(this.tool_views, tool_models, { parent: this });
    new_tool_views.map((tool_view) => this.canvas_view.ui_event_bus.register_tool(tool_view));
  }
  connect_signals() {
    super.connect_signals();
    const { x_ranges, y_ranges } = this.frame;
    for (const [, range2] of x_ranges) {
      this.connect(range2.change, () => {
        this._needs_layout = true;
        this.request_paint("everything");
      });
    }
    for (const [, range2] of y_ranges) {
      this.connect(range2.change, () => {
        this._needs_layout = true;
        this.request_paint("everything");
      });
    }
    const { above: above2, below: below2, left: left2, right: right2, center, renderers } = this.model.properties;
    this.on_change([above2, below2, left2, right2, center, renderers], async () => await this.build_renderer_views());
    this.connect(this.model.toolbar.properties.tools.change, async () => {
      await this.build_renderer_views();
      await this.build_tool_views();
    });
    this.connect(this.model.change, () => this.request_paint("everything"));
    this.connect(this.model.reset, () => this.reset());
  }
  has_finished() {
    if (!super.has_finished())
      return false;
    if (this.model.visible) {
      for (const [, renderer_view] of this.renderer_views) {
        if (!renderer_view.has_finished())
          return false;
      }
    }
    return true;
  }
  after_layout() {
    var _a2;
    super.after_layout();
    for (const [, child_view] of this.renderer_views) {
      if (child_view instanceof AnnotationView)
        (_a2 = child_view.after_layout) == null ? void 0 : _a2.call(child_view);
    }
    this._needs_layout = false;
    this.model.setv({
      inner_width: Math.round(this.frame.bbox.width),
      inner_height: Math.round(this.frame.bbox.height),
      outer_width: Math.round(this.layout.bbox.width),
      outer_height: Math.round(this.layout.bbox.height)
    }, { no_change: true });
    if (this.model.match_aspect !== false) {
      this.pause();
      this._range_manager.update_dataranges();
      this.unpause(true);
    }
    if (!this._outer_bbox.equals(this.layout.bbox)) {
      const { width, height } = this.layout.bbox;
      this.canvas_view.resize(width, height);
      this._outer_bbox = this.layout.bbox;
      this._invalidate_all = true;
      this._needs_paint = true;
    }
    const { inner_bbox } = this.layout;
    if (!this._inner_bbox.equals(inner_bbox)) {
      this._inner_bbox = inner_bbox;
      this._needs_paint = true;
    }
    if (this._needs_paint) {
      this.paint();
    }
  }
  repaint() {
    if (this._needs_layout)
      this._invalidate_layout();
    this.paint();
  }
  paint() {
    if (this.is_paused)
      return;
    if (this.model.visible) {
      logger.trace(`${this.toString()}.paint()`);
      this._actual_paint();
    }
    if (this._needs_notify) {
      this._needs_notify = false;
      this.notify_finished();
    }
  }
  _actual_paint() {
    var _a2;
    const { document: document2 } = this.model;
    if (document2 != null) {
      const interactive_duration = document2.interactive_duration();
      if (interactive_duration >= 0 && interactive_duration < this.model.lod_interval) {
        setTimeout(() => {
          if (document2.interactive_duration() > this.model.lod_timeout) {
            document2.interactive_stop();
          }
          this.request_paint("everything");
        }, this.model.lod_timeout);
      } else
        document2.interactive_stop();
    }
    if (this._range_manager.invalidate_dataranges) {
      this._range_manager.update_dataranges();
      this._invalidate_layout();
    }
    let do_primary = false;
    let do_overlays = false;
    if (this._invalidate_all) {
      do_primary = true;
      do_overlays = true;
    } else {
      for (const painter of this._invalidated_painters) {
        const { level } = painter.model;
        if (level != "overlay")
          do_primary = true;
        else
          do_overlays = true;
        if (do_primary && do_overlays)
          break;
      }
    }
    this._invalidated_painters.clear();
    this._invalidate_all = false;
    const frame_box = [
      this.frame.bbox.left,
      this.frame.bbox.top,
      this.frame.bbox.width,
      this.frame.bbox.height
    ];
    const { primary, overlays } = this.canvas_view;
    if (do_primary) {
      primary.prepare();
      this.canvas_view.prepare_webgl(frame_box);
      this._map_hook(primary.ctx, frame_box);
      this._paint_empty(primary.ctx, frame_box);
      this._paint_outline(primary.ctx, frame_box);
      this._paint_levels(primary.ctx, "image", frame_box, true);
      this._paint_levels(primary.ctx, "underlay", frame_box, true);
      this._paint_levels(primary.ctx, "glyph", frame_box, true);
      this._paint_levels(primary.ctx, "guide", frame_box, false);
      this._paint_levels(primary.ctx, "annotation", frame_box, false);
      primary.finish();
    }
    if (do_overlays || settings.wireframe) {
      overlays.prepare();
      this._paint_levels(overlays.ctx, "overlay", frame_box, false);
      if (settings.wireframe)
        this._paint_layout(overlays.ctx, this.layout);
      overlays.finish();
    }
    if (this._initial_state.range == null) {
      this._initial_state.range = (_a2 = this._range_manager.compute_initial()) != null ? _a2 : void 0;
    }
    this._needs_paint = false;
  }
  _paint_levels(ctx, level, clip_region, global_clip) {
    for (const renderer of this.computed_renderers) {
      if (renderer.level != level)
        continue;
      const renderer_view = this.renderer_views.get(renderer);
      ctx.save();
      if (global_clip || renderer_view.needs_clip) {
        ctx.beginPath();
        ctx.rect(...clip_region);
        ctx.clip();
      }
      renderer_view.render();
      ctx.restore();
      if (renderer_view.has_webgl && renderer_view.needs_webgl_blit) {
        this.canvas_view.blit_webgl(ctx);
      }
    }
  }
  _paint_layout(ctx, layout) {
    const { x: x2, y: y2, width, height } = layout.bbox;
    ctx.strokeStyle = "blue";
    ctx.strokeRect(x2, y2, width, height);
    for (const child of layout) {
      ctx.save();
      if (!layout.absolute)
        ctx.translate(x2, y2);
      this._paint_layout(ctx, child);
      ctx.restore();
    }
  }
  _map_hook(_ctx, _frame_box) {
  }
  _paint_empty(ctx, frame_box) {
    const [cx, cy, cw, ch] = [0, 0, this.layout.bbox.width, this.layout.bbox.height];
    const [fx, fy, fw, fh] = frame_box;
    if (this.visuals.border_fill.doit) {
      this.visuals.border_fill.set_value(ctx);
      ctx.fillRect(cx, cy, cw, ch);
      ctx.clearRect(fx, fy, fw, fh);
    }
    if (this.visuals.background_fill.doit) {
      this.visuals.background_fill.set_value(ctx);
      ctx.fillRect(fx, fy, fw, fh);
    }
  }
  _paint_outline(ctx, frame_box) {
    if (this.visuals.outline_line.doit) {
      ctx.save();
      this.visuals.outline_line.set_value(ctx);
      let [x0, y0, w, h2] = frame_box;
      if (x0 + w == this.layout.bbox.width) {
        w -= 1;
      }
      if (y0 + h2 == this.layout.bbox.height) {
        h2 -= 1;
      }
      ctx.strokeRect(x0, y0, w, h2);
      ctx.restore();
    }
  }
  to_blob() {
    return this.canvas_view.to_blob();
  }
  export(type, hidpi = true) {
    const output_backend = type == "png" ? "canvas" : "svg";
    const composite = new CanvasLayer(output_backend, hidpi);
    const { width, height } = this.layout.bbox;
    composite.resize(width, height);
    const { canvas: canvas2 } = this.canvas_view.compose();
    composite.ctx.drawImage(canvas2, 0, 0);
    return composite;
  }
  serializable_state() {
    const { children: children2, ...state } = super.serializable_state();
    const renderers = this.get_renderer_views().map((view) => view.serializable_state()).filter((item) => item.bbox != null);
    return { ...state, children: [...children2 != null ? children2 : [], ...renderers] };
  }
}
PlotView.__name__ = "PlotView";
var _a$1A;
class Plot extends LayoutDOM {
  constructor(attrs) {
    super(attrs);
    this.use_map = false;
  }
  _doc_attached() {
    super._doc_attached();
    this._push_changes([
      [this.properties.inner_height, null, this.inner_height],
      [this.properties.inner_width, null, this.inner_width]
    ]);
  }
  initialize() {
    super.initialize();
    this.reset = new Signal0(this, "reset");
    for (const xr of values(this.extra_x_ranges).concat(this.x_range)) {
      let plots = xr.plots;
      if (isArray(plots)) {
        plots = plots.concat(this);
        xr.setv({ plots }, { silent: true });
      }
    }
    for (const yr of values(this.extra_y_ranges).concat(this.y_range)) {
      let plots = yr.plots;
      if (isArray(plots)) {
        plots = plots.concat(this);
        yr.setv({ plots }, { silent: true });
      }
    }
  }
  add_layout(renderer, side = "center") {
    const renderers = this.properties[side].get_value();
    this.setv({ [side]: [...renderers, renderer] });
  }
  remove_layout(renderer) {
    const del = (items) => {
      remove_by(items, (item) => item == renderer);
    };
    del(this.left);
    del(this.right);
    del(this.above);
    del(this.below);
    del(this.center);
  }
  get data_renderers() {
    return this.renderers.filter((r) => r instanceof DataRenderer);
  }
  add_renderers(...renderers) {
    this.renderers = this.renderers.concat(renderers);
  }
  add_glyph(glyph, source = new ColumnDataSource(), attrs = {}) {
    const renderer = new GlyphRenderer({ ...attrs, data_source: source, glyph });
    this.add_renderers(renderer);
    return renderer;
  }
  add_tools(...tools) {
    this.toolbar.tools = this.toolbar.tools.concat(tools);
  }
  get panels() {
    return [...this.side_panels, ...this.center];
  }
  get side_panels() {
    const { above: above2, below: below2, left: left2, right: right2 } = this;
    return concat$1([above2, below2, left2, right2]);
  }
}
_a$1A = Plot;
Plot.__name__ = "Plot";
(() => {
  _a$1A.prototype.default_view = PlotView;
  _a$1A.mixins([
    ["outline_", Line$2],
    ["background_", Fill$1],
    ["border_", Fill$1]
  ]);
  _a$1A.define(({ Boolean: Boolean2, Number: Number2, String: String2, Array: Array2, Dict: Dict2, Or: Or2, Ref: Ref2, Null: Null2, Nullable: Nullable2 }) => ({
    toolbar: [Ref2(Toolbar), () => new Toolbar()],
    toolbar_location: [Nullable2(Location), "right"],
    toolbar_sticky: [Boolean2, true],
    plot_width: [Alias("width")],
    plot_height: [Alias("height")],
    frame_width: [Nullable2(Number2), null],
    frame_height: [Nullable2(Number2), null],
    title: [Or2(Ref2(Title), String2, Null2), "", {
      convert: (title) => isString(title) ? new Title({ text: title }) : title
    }],
    title_location: [Nullable2(Location), "above"],
    above: [Array2(Or2(Ref2(Annotation), Ref2(Axis))), []],
    below: [Array2(Or2(Ref2(Annotation), Ref2(Axis))), []],
    left: [Array2(Or2(Ref2(Annotation), Ref2(Axis))), []],
    right: [Array2(Or2(Ref2(Annotation), Ref2(Axis))), []],
    center: [Array2(Or2(Ref2(Annotation), Ref2(Grid))), []],
    renderers: [Array2(Ref2(Renderer)), []],
    x_range: [Ref2(Range$1), () => new DataRange1d()],
    y_range: [Ref2(Range$1), () => new DataRange1d()],
    x_scale: [Ref2(Scale), () => new LinearScale()],
    y_scale: [Ref2(Scale), () => new LinearScale()],
    extra_x_ranges: [Dict2(Ref2(Range$1)), {}],
    extra_y_ranges: [Dict2(Ref2(Range$1)), {}],
    extra_x_scales: [Dict2(Ref2(Scale)), {}],
    extra_y_scales: [Dict2(Ref2(Scale)), {}],
    lod_factor: [Number2, 10],
    lod_interval: [Number2, 300],
    lod_threshold: [Nullable2(Number2), 2e3],
    lod_timeout: [Number2, 500],
    hidpi: [Boolean2, true],
    output_backend: [OutputBackend, "canvas"],
    min_border: [Nullable2(Number2), 5],
    min_border_top: [Nullable2(Number2), null],
    min_border_left: [Nullable2(Number2), null],
    min_border_bottom: [Nullable2(Number2), null],
    min_border_right: [Nullable2(Number2), null],
    inner_width: [Number2, 0],
    inner_height: [Number2, 0],
    outer_width: [Number2, 0],
    outer_height: [Number2, 0],
    match_aspect: [Boolean2, false],
    aspect_scale: [Number2, 1],
    reset_policy: [ResetPolicy, "standard"]
  }));
  _a$1A.override({
    width: 600,
    height: 600,
    outline_line_color: "#e5e5e5",
    border_fill_color: "#ffffff",
    background_fill_color: "#ffffff"
  });
})();
const gmaps_ready = new Signal0({}, "gmaps_ready");
const load_google_api = function(api_key, api_version) {
  window._bokeh_gmaps_callback = () => gmaps_ready.emit();
  const enc = encodeURIComponent;
  const script2 = document.createElement("script");
  script2.type = "text/javascript";
  script2.src = `https://maps.googleapis.com/maps/api/js?v=${enc(api_version)}&key=${enc(api_key)}&callback=_bokeh_gmaps_callback`;
  document.body.appendChild(script2);
};
class GMapPlotView extends PlotView {
  initialize() {
    this.pause();
    super.initialize();
    this._tiles_loaded = false;
    this.zoom_count = 0;
    const { zoom, lat, lng } = this.model.map_options;
    this.initial_zoom = zoom;
    this.initial_lat = lat;
    this.initial_lng = lng;
    if (!this.model.api_key) {
      const url = "https://developers.google.com/maps/documentation/javascript/get-api-key";
      logger.error(`api_key is required. See ${url} for more information on how to obtain your own.`);
    }
    if (typeof google === "undefined" || google.maps == null) {
      if (typeof window._bokeh_gmaps_callback === "undefined") {
        const { api_key, api_version } = this.model;
        load_google_api(api_key, api_version);
      }
      gmaps_ready.connect(() => this.request_paint("everything"));
    }
    this.unpause();
  }
  remove() {
    remove(this.map_el);
    super.remove();
  }
  update_range(range_info, options2) {
    var _a2, _b2;
    if (range_info == null) {
      this.map.setCenter({ lat: this.initial_lat, lng: this.initial_lng });
      this.map.setOptions({ zoom: this.initial_zoom });
      super.update_range(null, options2);
    } else if (range_info.sdx != null || range_info.sdy != null) {
      this.map.panBy((_a2 = range_info.sdx) != null ? _a2 : 0, (_b2 = range_info.sdy) != null ? _b2 : 0);
      super.update_range(range_info, options2);
    } else if (range_info.factor != null) {
      if (this.zoom_count !== 10) {
        this.zoom_count += 1;
        return;
      }
      this.zoom_count = 0;
      this.pause();
      super.update_range(range_info, options2);
      const zoom_change = range_info.factor < 0 ? -1 : 1;
      const old_map_zoom = this.map.getZoom();
      if (old_map_zoom != null) {
        const new_map_zoom = old_map_zoom + zoom_change;
        if (new_map_zoom >= 2) {
          this.map.setZoom(new_map_zoom);
          const [proj_xstart, proj_xend] = this._get_projected_bounds();
          if (proj_xend - proj_xstart < 0) {
            this.map.setZoom(old_map_zoom);
          }
        }
      }
      this.unpause();
    }
    this._set_bokeh_ranges();
  }
  _build_map() {
    const { maps } = google;
    this.map_types = {
      satellite: maps.MapTypeId.SATELLITE,
      terrain: maps.MapTypeId.TERRAIN,
      roadmap: maps.MapTypeId.ROADMAP,
      hybrid: maps.MapTypeId.HYBRID
    };
    const mo2 = this.model.map_options;
    const map_options = {
      center: new maps.LatLng(mo2.lat, mo2.lng),
      zoom: mo2.zoom,
      disableDefaultUI: true,
      mapTypeId: this.map_types[mo2.map_type],
      scaleControl: mo2.scale_control,
      tilt: mo2.tilt
    };
    if (mo2.styles != null)
      map_options.styles = JSON.parse(mo2.styles);
    this.map_el = div({ style: { position: "absolute" } });
    this.canvas_view.add_underlay(this.map_el);
    this.map = new maps.Map(this.map_el, map_options);
    maps.event.addListener(this.map, "idle", () => this._set_bokeh_ranges());
    maps.event.addListener(this.map, "bounds_changed", () => this._set_bokeh_ranges());
    maps.event.addListenerOnce(this.map, "tilesloaded", () => this._render_finished());
    this.connect(this.model.properties.map_options.change, () => this._update_options());
    this.connect(this.model.map_options.properties.styles.change, () => this._update_styles());
    this.connect(this.model.map_options.properties.lat.change, () => this._update_center("lat"));
    this.connect(this.model.map_options.properties.lng.change, () => this._update_center("lng"));
    this.connect(this.model.map_options.properties.zoom.change, () => this._update_zoom());
    this.connect(this.model.map_options.properties.map_type.change, () => this._update_map_type());
    this.connect(this.model.map_options.properties.scale_control.change, () => this._update_scale_control());
    this.connect(this.model.map_options.properties.tilt.change, () => this._update_tilt());
  }
  _render_finished() {
    this._tiles_loaded = true;
    this.notify_finished();
  }
  has_finished() {
    return super.has_finished() && this._tiles_loaded === true;
  }
  _get_latlon_bounds() {
    const bounds = this.map.getBounds();
    const top_right = bounds.getNorthEast();
    const bottom_left = bounds.getSouthWest();
    const xstart = bottom_left.lng();
    const xend = top_right.lng();
    const ystart = bottom_left.lat();
    const yend = top_right.lat();
    return [xstart, xend, ystart, yend];
  }
  _get_projected_bounds() {
    const [xstart, xend, ystart, yend] = this._get_latlon_bounds();
    const [proj_xstart, proj_ystart] = wgs84_mercator.compute(xstart, ystart);
    const [proj_xend, proj_yend] = wgs84_mercator.compute(xend, yend);
    return [proj_xstart, proj_xend, proj_ystart, proj_yend];
  }
  _set_bokeh_ranges() {
    const [proj_xstart, proj_xend, proj_ystart, proj_yend] = this._get_projected_bounds();
    this.frame.x_range.setv({ start: proj_xstart, end: proj_xend });
    this.frame.y_range.setv({ start: proj_ystart, end: proj_yend });
  }
  _update_center(fld) {
    var _a2;
    const center = (_a2 = this.map.getCenter()) == null ? void 0 : _a2.toJSON();
    if (center != null) {
      center[fld] = this.model.map_options[fld];
      this.map.setCenter(center);
      this._set_bokeh_ranges();
    }
  }
  _update_map_type() {
    this.map.setOptions({ mapTypeId: this.map_types[this.model.map_options.map_type] });
  }
  _update_scale_control() {
    this.map.setOptions({ scaleControl: this.model.map_options.scale_control });
  }
  _update_tilt() {
    this.map.setOptions({ tilt: this.model.map_options.tilt });
  }
  _update_options() {
    this._update_styles();
    this._update_center("lat");
    this._update_center("lng");
    this._update_zoom();
    this._update_map_type();
  }
  _update_styles() {
    this.map.setOptions({ styles: JSON.parse(this.model.map_options.styles) });
  }
  _update_zoom() {
    this.map.setOptions({ zoom: this.model.map_options.zoom });
    this._set_bokeh_ranges();
  }
  _map_hook(_ctx, frame_box) {
    if (this.map == null && typeof google !== "undefined" && google.maps != null)
      this._build_map();
    if (this.map_el != null) {
      const [left2, top, width, height] = frame_box;
      this.map_el.style.top = `${top}px`;
      this.map_el.style.left = `${left2}px`;
      this.map_el.style.width = `${width}px`;
      this.map_el.style.height = `${height}px`;
    }
  }
  _paint_empty(ctx, frame_box) {
    const ow = this.layout.bbox.width;
    const oh = this.layout.bbox.height;
    const [left2, top, iw, ih] = frame_box;
    ctx.clearRect(0, 0, ow, oh);
    ctx.beginPath();
    ctx.moveTo(0, 0);
    ctx.lineTo(0, oh);
    ctx.lineTo(ow, oh);
    ctx.lineTo(ow, 0);
    ctx.lineTo(0, 0);
    ctx.moveTo(left2, top);
    ctx.lineTo(left2 + iw, top);
    ctx.lineTo(left2 + iw, top + ih);
    ctx.lineTo(left2, top + ih);
    ctx.lineTo(left2, top);
    ctx.closePath();
    if (this.model.border_fill_color != null) {
      ctx.fillStyle = color2css(this.model.border_fill_color);
      ctx.fill();
    }
  }
}
GMapPlotView.__name__ = "GMapPlotView";
var _a$1z, _b$5, _c$3;
class MapOptions extends Model {
  constructor(attrs) {
    super(attrs);
  }
}
_a$1z = MapOptions;
MapOptions.__name__ = "MapOptions";
(() => {
  _a$1z.define(({ Int: Int2, Number: Number2 }) => ({
    lat: [Number2],
    lng: [Number2],
    zoom: [Int2, 12]
  }));
})();
class GMapOptions extends MapOptions {
  constructor(attrs) {
    super(attrs);
  }
}
_b$5 = GMapOptions;
GMapOptions.__name__ = "GMapOptions";
(() => {
  _b$5.define(({ Boolean: Boolean2, Int: Int2, String: String2 }) => ({
    map_type: [String2, "roadmap"],
    scale_control: [Boolean2, false],
    styles: [String2],
    tilt: [Int2, 45]
  }));
})();
class GMapPlot extends Plot {
  constructor(attrs) {
    super(attrs);
    this.use_map = true;
  }
}
_c$3 = GMapPlot;
GMapPlot.__name__ = "GMapPlot";
(() => {
  _c$3.prototype.default_view = GMapPlotView;
  _c$3.define(({ String: String2, Ref: Ref2 }) => ({
    map_options: [Ref2(GMapOptions)],
    api_key: [String2],
    api_version: [String2, "weekly"]
  }));
  _c$3.override({
    x_range: () => new Range1d(),
    y_range: () => new Range1d()
  });
})();
var _a$1y;
class GraphRendererView extends DataRendererView {
  get glyph_view() {
    return this.node_view.glyph;
  }
  async lazy_initialize() {
    await super.lazy_initialize();
    this.apply_coordinates();
    const { parent } = this;
    const { edge_renderer, node_renderer } = this.model;
    this.edge_view = await build_view(edge_renderer, { parent });
    this.node_view = await build_view(node_renderer, { parent });
  }
  connect_signals() {
    super.connect_signals();
    this.connect(this.model.layout_provider.change, () => {
      this.apply_coordinates();
      this.edge_view.set_data();
      this.node_view.set_data();
      this.request_render();
    });
  }
  apply_coordinates() {
    const { edge_renderer, node_renderer } = this.model;
    if (!(edge_renderer.glyph instanceof MultiLine || edge_renderer.glyph instanceof Patches)) {
      throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);
    }
    if (!(node_renderer.glyph instanceof XYGlyph)) {
      throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);
    }
    const edge_coords = this.model.layout_provider.edge_coordinates;
    const node_coords = this.model.layout_provider.node_coordinates;
    edge_renderer.glyph.properties.xs.internal = true;
    edge_renderer.glyph.properties.ys.internal = true;
    node_renderer.glyph.properties.x.internal = true;
    node_renderer.glyph.properties.y.internal = true;
    edge_renderer.glyph.xs = { expr: edge_coords.x };
    edge_renderer.glyph.ys = { expr: edge_coords.y };
    node_renderer.glyph.x = { expr: node_coords.x };
    node_renderer.glyph.y = { expr: node_coords.y };
  }
  remove() {
    this.edge_view.remove();
    this.node_view.remove();
    super.remove();
  }
  _render() {
    this.edge_view.render();
    this.node_view.render();
  }
  renderer_view(renderer) {
    if (renderer instanceof GlyphRenderer) {
      if (renderer == this.edge_view.model)
        return this.edge_view;
      if (renderer == this.node_view.model)
        return this.node_view;
    }
    return super.renderer_view(renderer);
  }
}
GraphRendererView.__name__ = "GraphRendererView";
class GraphRenderer extends DataRenderer {
  constructor(attrs) {
    super(attrs);
  }
  get_selection_manager() {
    return this.node_renderer.data_source.selection_manager;
  }
}
_a$1y = GraphRenderer;
GraphRenderer.__name__ = "GraphRenderer";
(() => {
  _a$1y.prototype.default_view = GraphRendererView;
  _a$1y.define(({ Ref: Ref2 }) => ({
    layout_provider: [Ref2(LayoutProvider)],
    node_renderer: [Ref2(GlyphRen