(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_pug_pug_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/pug/pug.js":
/*!**********************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/pug/pug.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/pug/pug.ts
var conf = {
  comments: {
    lineComment: "//"
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: '"', close: '"', notIn: ["string", "comment"] },
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: "{", close: "}", notIn: ["string", "comment"] },
    { open: "[", close: "]", notIn: ["string", "comment"] },
    { open: "(", close: ")", notIn: ["string", "comment"] }
  ],
  folding: {
    offSide: true
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".pug",
  ignoreCase: true,
  brackets: [
    { token: "delimiter.curly", open: "{", close: "}" },
    { token: "delimiter.array", open: "[", close: "]" },
    { token: "delimiter.parenthesis", open: "(", close: ")" }
  ],
  keywords: [
    "append",
    "block",
    "case",
    "default",
    "doctype",
    "each",
    "else",
    "extends",
    "for",
    "if",
    "in",
    "include",
    "mixin",
    "typeof",
    "unless",
    "var",
    "when"
  ],
  tags: [
    "a",
    "abbr",
    "acronym",
    "address",
    "area",
    "article",
    "aside",
    "audio",
    "b",
    "base",
    "basefont",
    "bdi",
    "bdo",
    "blockquote",
    "body",
    "br",
    "button",
    "canvas",
    "caption",
    "center",
    "cite",
    "code",
    "col",
    "colgroup",
    "command",
    "datalist",
    "dd",
    "del",
    "details",
    "dfn",
    "div",
    "dl",
    "dt",
    "em",
    "embed",
    "fieldset",
    "figcaption",
    "figure",
    "font",
    "footer",
    "form",
    "frame",
    "frameset",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hgroup",
    "hr",
    "html",
    "i",
    "iframe",
    "img",
    "input",
    "ins",
    "keygen",
    "kbd",
    "label",
    "li",
    "link",
    "map",
    "mark",
    "menu",
    "meta",
    "meter",
    "nav",
    "noframes",
    "noscript",
    "object",
    "ol",
    "optgroup",
    "option",
    "output",
    "p",
    "param",
    "pre",
    "progress",
    "q",
    "rp",
    "rt",
    "ruby",
    "s",
    "samp",
    "script",
    "section",
    "select",
    "small",
    "source",
    "span",
    "strike",
    "strong",
    "style",
    "sub",
    "summary",
    "sup",
    "table",
    "tbody",
    "td",
    "textarea",
    "tfoot",
    "th",
    "thead",
    "time",
    "title",
    "tr",
    "tracks",
    "tt",
    "u",
    "ul",
    "video",
    "wbr"
  ],
  symbols: /[\+\-\*\%\&\|\!\=\/\.\,\:]+/,
  escapes: /\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,
  tokenizer: {
    root: [
      [
        /^(\s*)([a-zA-Z_-][\w-]*)/,
        {
          cases: {
            "$2@tags": {
              cases: {
                "@eos": ["", "tag"],
                "@default": ["", { token: "tag", next: "@tag.$1" }]
              }
            },
            "$2@keywords": ["", { token: "keyword.$2" }],
            "@default": ["", ""]
          }
        }
      ],
      [
        /^(\s*)(#[a-zA-Z_-][\w-]*)/,
        {
          cases: {
            "@eos": ["", "tag.id"],
            "@default": ["", { token: "tag.id", next: "@tag.$1" }]
          }
        }
      ],
      [
        /^(\s*)(\.[a-zA-Z_-][\w-]*)/,
        {
          cases: {
            "@eos": ["", "tag.class"],
            "@default": ["", { token: "tag.class", next: "@tag.$1" }]
          }
        }
      ],
      [/^(\s*)(\|.*)$/, ""],
      { include: "@whitespace" },
      [
        /[a-zA-Z_$][\w$]*/,
        {
          cases: {
            "@keywords": { token: "keyword.$0" },
            "@default": ""
          }
        }
      ],
      [/[{}()\[\]]/, "@brackets"],
      [/@symbols/, "delimiter"],
      [/\d+\.\d+([eE][\-+]?\d+)?/, "number.float"],
      [/\d+/, "number"],
      [/"/, "string", '@string."'],
      [/'/, "string", "@string.'"]
    ],
    tag: [
      [/(\.)(\s*$)/, [{ token: "delimiter", next: "@blockText.$S2." }, ""]],
      [/\s+/, { token: "", next: "@simpleText" }],
      [
        /#[a-zA-Z_-][\w-]*/,
        {
          cases: {
            "@eos": { token: "tag.id", next: "@pop" },
            "@default": "tag.id"
          }
        }
      ],
      [
        /\.[a-zA-Z_-][\w-]*/,
        {
          cases: {
            "@eos": { token: "tag.class", next: "@pop" },
            "@default": "tag.class"
          }
        }
      ],
      [/\(/, { token: "delimiter.parenthesis", next: "@attributeList" }]
    ],
    simpleText: [
      [/[^#]+$/, { token: "", next: "@popall" }],
      [/[^#]+/, { token: "" }],
      [
        /(#{)([^}]*)(})/,
        {
          cases: {
            "@eos": [
              "interpolation.delimiter",
              "interpolation",
              {
                token: "interpolation.delimiter",
                next: "@popall"
              }
            ],
            "@default": ["interpolation.delimiter", "interpolation", "interpolation.delimiter"]
          }
        }
      ],
      [/#$/, { token: "", next: "@popall" }],
      [/#/, ""]
    ],
    attributeList: [
      [/\s+/, ""],
      [
        /(\w+)(\s*=\s*)("|')/,
        ["attribute.name", "delimiter", { token: "attribute.value", next: "@value.$3" }]
      ],
      [/\w+/, "attribute.name"],
      [
        /,/,
        {
          cases: {
            "@eos": {
              token: "attribute.delimiter",
              next: "@popall"
            },
            "@default": "attribute.delimiter"
          }
        }
      ],
      [/\)$/, { token: "delimiter.parenthesis", next: "@popall" }],
      [/\)/, { token: "delimiter.parenthesis", next: "@pop" }]
    ],
    whitespace: [
      [/^(\s*)(\/\/.*)$/, { token: "comment", next: "@blockText.$1.comment" }],
      [/[ \t\r\n]+/, ""],
      [/<!--/, { token: "comment", next: "@comment" }]
    ],
    blockText: [
      [
        /^\s+.*$/,
        {
          cases: {
            "($S2\\s+.*$)": { token: "$S3" },
            "@default": { token: "@rematch", next: "@popall" }
          }
        }
      ],
      [/./, { token: "@rematch", next: "@popall" }]
    ],
    comment: [
      [/[^<\-]+/, "comment.content"],
      [/-->/, { token: "comment", next: "@pop" }],
      [/<!--/, "comment.content.invalid"],
      [/[<\-]/, "comment.content"]
    ],
    string: [
      [
        /[^\\"'#]+/,
        {
          cases: {
            "@eos": { token: "string", next: "@popall" },
            "@default": "string"
          }
        }
      ],
      [
        /@escapes/,
        {
          cases: {
            "@eos": { token: "string.escape", next: "@popall" },
            "@default": "string.escape"
          }
        }
      ],
      [
        /\\./,
        {
          cases: {
            "@eos": {
              token: "string.escape.invalid",
              next: "@popall"
            },
            "@default": "string.escape.invalid"
          }
        }
      ],
      [/(#{)([^}]*)(})/, ["interpolation.delimiter", "interpolation", "interpolation.delimiter"]],
      [/#/, "string"],
      [
        /["']/,
        {
          cases: {
            "$#==$S2": { token: "string", next: "@pop" },
            "@default": { token: "string" }
          }
        }
      ]
    ],
    value: [
      [
        /[^\\"']+/,
        {
          cases: {
            "@eos": { token: "attribute.value", next: "@popall" },
            "@default": "attribute.value"
          }
        }
      ],
      [
        /\\./,
        {
          cases: {
            "@eos": { token: "attribute.value", next: "@popall" },
            "@default": "attribute.value"
          }
        }
      ],
      [
        /["']/,
        {
          cases: {
            "$#==$S2": { token: "attribute.value", next: "@pop" },
            "@default": { token: "attribute.value" }
          }
        }
      ]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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