import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Glue::Classifier`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export interface CfnClassifierProps {
    /**
     * `AWS::Glue::Classifier.CsvClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier
     */
    readonly csvClassifier?: CfnClassifier.CsvClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.GrokClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier
     */
    readonly grokClassifier?: CfnClassifier.GrokClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.JsonClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier
     */
    readonly jsonClassifier?: CfnClassifier.JsonClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.XMLClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier
     */
    readonly xmlClassifier?: CfnClassifier.XMLClassifierProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare class CfnClassifier extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Classifier";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClassifier;
    /**
     * `AWS::Glue::Classifier.CsvClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier
     */
    csvClassifier: CfnClassifier.CsvClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.GrokClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier
     */
    grokClassifier: CfnClassifier.GrokClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.JsonClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier
     */
    jsonClassifier: CfnClassifier.JsonClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.XMLClassifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier
     */
    xmlClassifier: CfnClassifier.XMLClassifierProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Glue::Classifier`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnClassifierProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare namespace CfnClassifier {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html
     */
    interface CsvClassifierProperty {
        /**
         * `CfnClassifier.CsvClassifierProperty.AllowSingleColumn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-allowsinglecolumn
         */
        readonly allowSingleColumn?: boolean | cdk.IResolvable;
        /**
         * `CfnClassifier.CsvClassifierProperty.ContainsHeader`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containsheader
         */
        readonly containsHeader?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.Delimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-delimiter
         */
        readonly delimiter?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.DisableValueTrimming`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-disablevaluetrimming
         */
        readonly disableValueTrimming?: boolean | cdk.IResolvable;
        /**
         * `CfnClassifier.CsvClassifierProperty.Header`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-header
         */
        readonly header?: string[];
        /**
         * `CfnClassifier.CsvClassifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-name
         */
        readonly name?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.QuoteSymbol`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-quotesymbol
         */
        readonly quoteSymbol?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare namespace CfnClassifier {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html
     */
    interface GrokClassifierProperty {
        /**
         * `CfnClassifier.GrokClassifierProperty.Classification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-classification
         */
        readonly classification: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.CustomPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-custompatterns
         */
        readonly customPatterns?: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.GrokPattern`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-grokpattern
         */
        readonly grokPattern: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare namespace CfnClassifier {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html
     */
    interface JsonClassifierProperty {
        /**
         * `CfnClassifier.JsonClassifierProperty.JsonPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-jsonpath
         */
        readonly jsonPath: string;
        /**
         * `CfnClassifier.JsonClassifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 */
export declare namespace CfnClassifier {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html
     */
    interface XMLClassifierProperty {
        /**
         * `CfnClassifier.XMLClassifierProperty.Classification`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-classification
         */
        readonly classification: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-name
         */
        readonly name?: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.RowTag`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-rowtag
         */
        readonly rowTag: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Connection`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export interface CfnConnectionProps {
    /**
     * `AWS::Glue::Connection.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Connection.ConnectionInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput
     */
    readonly connectionInput: CfnConnection.ConnectionInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Connection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export declare class CfnConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Connection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnection;
    /**
     * `AWS::Glue::Connection.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid
     */
    catalogId: string;
    /**
     * `AWS::Glue::Connection.ConnectionInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput
     */
    connectionInput: CfnConnection.ConnectionInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Connection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Connection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export declare namespace CfnConnection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html
     */
    interface ConnectionInputProperty {
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectionproperties
         */
        readonly connectionProperties?: any | cdk.IResolvable;
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype
         */
        readonly connectionType: string;
        /**
         * `CfnConnection.ConnectionInputProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-description
         */
        readonly description?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.MatchCriteria`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-matchcriteria
         */
        readonly matchCriteria?: string[];
        /**
         * `CfnConnection.ConnectionInputProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name
         */
        readonly name?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.PhysicalConnectionRequirements`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-physicalconnectionrequirements
         */
        readonly physicalConnectionRequirements?: CfnConnection.PhysicalConnectionRequirementsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Connection
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 */
export declare namespace CfnConnection {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html
     */
    interface PhysicalConnectionRequirementsProperty {
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.AvailabilityZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SecurityGroupIdList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-securitygroupidlist
         */
        readonly securityGroupIdList?: string[];
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-subnetid
         */
        readonly subnetId?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Crawler`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export interface CfnCrawlerProps {
    /**
     * `AWS::Glue::Crawler.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role
     */
    readonly role: string;
    /**
     * `AWS::Glue::Crawler.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets
     */
    readonly targets: CfnCrawler.TargetsProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.Classifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers
     */
    readonly classifiers?: string[];
    /**
     * `AWS::Glue::Crawler.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration
     */
    readonly configuration?: string;
    /**
     * `AWS::Glue::Crawler.CrawlerSecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration
     */
    readonly crawlerSecurityConfiguration?: string;
    /**
     * `AWS::Glue::Crawler.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename
     */
    readonly databaseName?: string;
    /**
     * `AWS::Glue::Crawler.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Crawler.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Crawler.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule
     */
    readonly schedule?: CfnCrawler.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.SchemaChangePolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy
     */
    readonly schemaChangePolicy?: CfnCrawler.SchemaChangePolicyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.TablePrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix
     */
    readonly tablePrefix?: string;
    /**
     * `AWS::Glue::Crawler.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare class CfnCrawler extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Crawler";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCrawler;
    /**
     * `AWS::Glue::Crawler.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role
     */
    role: string;
    /**
     * `AWS::Glue::Crawler.Targets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets
     */
    targets: CfnCrawler.TargetsProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.Classifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers
     */
    classifiers: string[] | undefined;
    /**
     * `AWS::Glue::Crawler.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration
     */
    configuration: string | undefined;
    /**
     * `AWS::Glue::Crawler.CrawlerSecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration
     */
    crawlerSecurityConfiguration: string | undefined;
    /**
     * `AWS::Glue::Crawler.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename
     */
    databaseName: string | undefined;
    /**
     * `AWS::Glue::Crawler.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Crawler.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Crawler.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule
     */
    schedule: CfnCrawler.ScheduleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Crawler.SchemaChangePolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy
     */
    schemaChangePolicy: CfnCrawler.SchemaChangePolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Crawler.TablePrefix`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix
     */
    tablePrefix: string | undefined;
    /**
     * `AWS::Glue::Crawler.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Crawler`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCrawlerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html
     */
    interface CatalogTargetProperty {
        /**
         * `CfnCrawler.CatalogTargetProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnCrawler.CatalogTargetProperty.Tables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-tables
         */
        readonly tables?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html
     */
    interface DynamoDBTargetProperty {
        /**
         * `CfnCrawler.DynamoDBTargetProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html#cfn-glue-crawler-dynamodbtarget-path
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html
     */
    interface JdbcTargetProperty {
        /**
         * `CfnCrawler.JdbcTargetProperty.ConnectionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-connectionname
         */
        readonly connectionName?: string;
        /**
         * `CfnCrawler.JdbcTargetProperty.Exclusions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-exclusions
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.JdbcTargetProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-path
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html
     */
    interface S3TargetProperty {
        /**
         * `CfnCrawler.S3TargetProperty.ConnectionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-connectionname
         */
        readonly connectionName?: string;
        /**
         * `CfnCrawler.S3TargetProperty.Exclusions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-exclusions
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.S3TargetProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-path
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCrawler.ScheduleProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html#cfn-glue-crawler-schedule-scheduleexpression
         */
        readonly scheduleExpression?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html
     */
    interface SchemaChangePolicyProperty {
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.DeleteBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior
         */
        readonly deleteBehavior?: string;
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.UpdateBehavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior
         */
        readonly updateBehavior?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 */
export declare namespace CfnCrawler {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html
     */
    interface TargetsProperty {
        /**
         * `CfnCrawler.TargetsProperty.CatalogTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-catalogtargets
         */
        readonly catalogTargets?: Array<CfnCrawler.CatalogTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.DynamoDBTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-dynamodbtargets
         */
        readonly dynamoDbTargets?: Array<CfnCrawler.DynamoDBTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.JdbcTargets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-jdbctargets
         */
        readonly jdbcTargets?: Array<CfnCrawler.JdbcTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.S3Targets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-s3targets
         */
        readonly s3Targets?: Array<CfnCrawler.S3TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 */
export interface CfnDataCatalogEncryptionSettingsProps {
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.DataCatalogEncryptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings
     */
    readonly dataCatalogEncryptionSettings: CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 */
export declare class CfnDataCatalogEncryptionSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::DataCatalogEncryptionSettings";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataCatalogEncryptionSettings;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid
     */
    catalogId: string;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.DataCatalogEncryptionSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings
     */
    dataCatalogEncryptionSettings: CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::DataCatalogEncryptionSettings`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataCatalogEncryptionSettingsProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html
     */
    interface ConnectionPasswordEncryptionProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html#cfn-glue-datacatalogencryptionsettings-connectionpasswordencryption-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty.ReturnConnectionPasswordEncrypted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html#cfn-glue-datacatalogencryptionsettings-connectionpasswordencryption-returnconnectionpasswordencrypted
         */
        readonly returnConnectionPasswordEncrypted?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html
     */
    interface DataCatalogEncryptionSettingsProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty.ConnectionPasswordEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings-connectionpasswordencryption
         */
        readonly connectionPasswordEncryption?: CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty.EncryptionAtRest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings-encryptionatrest
         */
        readonly encryptionAtRest?: CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html
     */
    interface EncryptionAtRestProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty.CatalogEncryptionMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html#cfn-glue-datacatalogencryptionsettings-encryptionatrest-catalogencryptionmode
         */
        readonly catalogEncryptionMode?: string;
        /**
         * `CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty.SseAwsKmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html#cfn-glue-datacatalogencryptionsettings-encryptionatrest-sseawskmskeyid
         */
        readonly sseAwsKmsKeyId?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Database`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export interface CfnDatabaseProps {
    /**
     * `AWS::Glue::Database.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Database.DatabaseInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput
     */
    readonly databaseInput: CfnDatabase.DatabaseInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Database`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Database
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export declare class CfnDatabase extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Database";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDatabase;
    /**
     * `AWS::Glue::Database.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid
     */
    catalogId: string;
    /**
     * `AWS::Glue::Database.DatabaseInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput
     */
    databaseInput: CfnDatabase.DatabaseInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Database`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDatabaseProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Database`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Database
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export declare namespace CfnDatabase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html
     */
    interface DatabaseIdentifierProperty {
        /**
         * `CfnDatabase.DatabaseIdentifierProperty.CatalogId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-catalogid
         */
        readonly catalogId?: string;
        /**
         * `CfnDatabase.DatabaseIdentifierProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseidentifier.html#cfn-glue-database-databaseidentifier-databasename
         */
        readonly databaseName?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Database`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Database
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 */
export declare namespace CfnDatabase {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html
     */
    interface DatabaseInputProperty {
        /**
         * `CfnDatabase.DatabaseInputProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-description
         */
        readonly description?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.LocationUri`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-locationuri
         */
        readonly locationUri?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-name
         */
        readonly name?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnDatabase.DatabaseInputProperty.TargetDatabase`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-targetdatabase
         */
        readonly targetDatabase?: CfnDatabase.DatabaseIdentifierProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::DevEndpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 */
export interface CfnDevEndpointProps {
    /**
     * `AWS::Glue::DevEndpoint.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::Glue::DevEndpoint.Arguments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments
     */
    readonly arguments?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::DevEndpoint.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraJarsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path
     */
    readonly extraJarsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraPythonLibsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path
     */
    readonly extraPythonLibsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfNodes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes
     */
    readonly numberOfNodes?: number;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::DevEndpoint.PublicKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey
     */
    readonly publicKey?: string;
    /**
     * `AWS::Glue::DevEndpoint.PublicKeys`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys
     */
    readonly publicKeys?: string[];
    /**
     * `AWS::Glue::DevEndpoint.SecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration
     */
    readonly securityConfiguration?: string;
    /**
     * `AWS::Glue::DevEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::Glue::DevEndpoint.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::Glue::DevEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::DevEndpoint.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::DevEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::Glue::DevEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 */
export declare class CfnDevEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::DevEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDevEndpoint;
    /**
     * `AWS::Glue::DevEndpoint.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn
     */
    roleArn: string;
    /**
     * `AWS::Glue::DevEndpoint.Arguments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments
     */
    arguments: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::DevEndpoint.EndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.ExtraJarsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path
     */
    extraJarsS3Path: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.ExtraPythonLibsS3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path
     */
    extraPythonLibsS3Path: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfNodes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes
     */
    numberOfNodes: number | undefined;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::DevEndpoint.PublicKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey
     */
    publicKey: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.PublicKeys`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys
     */
    publicKeys: string[] | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration
     */
    securityConfiguration: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SubnetId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::DevEndpoint.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::DevEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDevEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Glue::Job`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export interface CfnJobProps {
    /**
     * `AWS::Glue::Job.Command`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command
     */
    readonly command: CfnJob.JobCommandProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role
     */
    readonly role: string;
    /**
     * `AWS::Glue::Job.AllocatedCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity
     */
    readonly allocatedCapacity?: number;
    /**
     * `AWS::Glue::Job.Connections`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections
     */
    readonly connections?: CfnJob.ConnectionsListProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.DefaultArguments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments
     */
    readonly defaultArguments?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Job.ExecutionProperty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty
     */
    readonly executionProperty?: CfnJob.ExecutionPropertyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::Job.LogUri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri
     */
    readonly logUri?: string;
    /**
     * `AWS::Glue::Job.MaxCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity
     */
    readonly maxCapacity?: number;
    /**
     * `AWS::Glue::Job.MaxRetries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries
     */
    readonly maxRetries?: number;
    /**
     * `AWS::Glue::Job.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Job.NotificationProperty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty
     */
    readonly notificationProperty?: CfnJob.NotificationPropertyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::Job.SecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration
     */
    readonly securityConfiguration?: string;
    /**
     * `AWS::Glue::Job.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::Job.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout
     */
    readonly timeout?: number;
    /**
     * `AWS::Glue::Job.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Job
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare class CfnJob extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Job";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJob;
    /**
     * `AWS::Glue::Job.Command`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command
     */
    command: CfnJob.JobCommandProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role
     */
    role: string;
    /**
     * `AWS::Glue::Job.AllocatedCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity
     */
    allocatedCapacity: number | undefined;
    /**
     * `AWS::Glue::Job.Connections`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections
     */
    connections: CfnJob.ConnectionsListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.DefaultArguments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments
     */
    defaultArguments: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Job.ExecutionProperty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty
     */
    executionProperty: CfnJob.ExecutionPropertyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::Job.LogUri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri
     */
    logUri: string | undefined;
    /**
     * `AWS::Glue::Job.MaxCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity
     */
    maxCapacity: number | undefined;
    /**
     * `AWS::Glue::Job.MaxRetries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries
     */
    maxRetries: number | undefined;
    /**
     * `AWS::Glue::Job.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Job.NotificationProperty`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty
     */
    notificationProperty: CfnJob.NotificationPropertyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::Job.SecurityConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration
     */
    securityConfiguration: string | undefined;
    /**
     * `AWS::Glue::Job.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::Job.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout
     */
    timeout: number | undefined;
    /**
     * `AWS::Glue::Job.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::Job`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Job
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare namespace CfnJob {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html
     */
    interface ConnectionsListProperty {
        /**
         * `CfnJob.ConnectionsListProperty.Connections`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html#cfn-glue-job-connectionslist-connections
         */
        readonly connections?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Job
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare namespace CfnJob {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html
     */
    interface ExecutionPropertyProperty {
        /**
         * `CfnJob.ExecutionPropertyProperty.MaxConcurrentRuns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html#cfn-glue-job-executionproperty-maxconcurrentruns
         */
        readonly maxConcurrentRuns?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Job
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare namespace CfnJob {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html
     */
    interface JobCommandProperty {
        /**
         * `CfnJob.JobCommandProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-name
         */
        readonly name?: string;
        /**
         * `CfnJob.JobCommandProperty.PythonVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-pythonversion
         */
        readonly pythonVersion?: string;
        /**
         * `CfnJob.JobCommandProperty.ScriptLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-scriptlocation
         */
        readonly scriptLocation?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Job
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 */
export declare namespace CfnJob {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-notificationproperty.html
     */
    interface NotificationPropertyProperty {
        /**
         * `CfnJob.NotificationPropertyProperty.NotifyDelayAfter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-notificationproperty.html#cfn-glue-job-notificationproperty-notifydelayafter
         */
        readonly notifyDelayAfter?: number;
    }
}
/**
 * Properties for defining a `AWS::Glue::MLTransform`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export interface CfnMLTransformProps {
    /**
     * `AWS::Glue::MLTransform.InputRecordTables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables
     */
    readonly inputRecordTables: CfnMLTransform.InputRecordTablesProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role
     */
    readonly role: string;
    /**
     * `AWS::Glue::MLTransform.TransformParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters
     */
    readonly transformParameters: CfnMLTransform.TransformParametersProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::MLTransform.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::MLTransform.MaxCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity
     */
    readonly maxCapacity?: number;
    /**
     * `AWS::Glue::MLTransform.MaxRetries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries
     */
    readonly maxRetries?: number;
    /**
     * `AWS::Glue::MLTransform.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::MLTransform.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::MLTransform.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::MLTransform.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout
     */
    readonly timeout?: number;
    /**
     * `AWS::Glue::MLTransform.TransformEncryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformencryption
     */
    readonly transformEncryption?: CfnMLTransform.TransformEncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare class CfnMLTransform extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::MLTransform";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMLTransform;
    /**
     * `AWS::Glue::MLTransform.InputRecordTables`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables
     */
    inputRecordTables: CfnMLTransform.InputRecordTablesProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Role`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role
     */
    role: string;
    /**
     * `AWS::Glue::MLTransform.TransformParameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters
     */
    transformParameters: CfnMLTransform.TransformParametersProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::MLTransform.GlueVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::MLTransform.MaxCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity
     */
    maxCapacity: number | undefined;
    /**
     * `AWS::Glue::MLTransform.MaxRetries`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries
     */
    maxRetries: number | undefined;
    /**
     * `AWS::Glue::MLTransform.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name
     */
    name: string | undefined;
    /**
     * `AWS::Glue::MLTransform.NumberOfWorkers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::MLTransform.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::MLTransform.Timeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout
     */
    timeout: number | undefined;
    /**
     * `AWS::Glue::MLTransform.TransformEncryption`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformencryption
     */
    transformEncryption: CfnMLTransform.TransformEncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::MLTransform.WorkerType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::MLTransform`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMLTransformProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html
     */
    interface FindMatchesParametersProperty {
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.AccuracyCostTradeoff`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-accuracycosttradeoff
         */
        readonly accuracyCostTradeoff?: number;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.EnforceProvidedLabels`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-enforceprovidedlabels
         */
        readonly enforceProvidedLabels?: boolean | cdk.IResolvable;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.PrecisionRecallTradeoff`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-precisionrecalltradeoff
         */
        readonly precisionRecallTradeoff?: number;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.PrimaryKeyColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-primarykeycolumnname
         */
        readonly primaryKeyColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html
     */
    interface GlueTablesProperty {
        /**
         * `CfnMLTransform.GlueTablesProperty.CatalogId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-catalogid
         */
        readonly catalogId?: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.ConnectionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-connectionname
         */
        readonly connectionName?: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-databasename
         */
        readonly databaseName: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables.html
     */
    interface InputRecordTablesProperty {
        /**
         * `CfnMLTransform.InputRecordTablesProperty.GlueTables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables.html#cfn-glue-mltransform-inputrecordtables-gluetables
         */
        readonly glueTables?: Array<CfnMLTransform.GlueTablesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption-mluserdataencryption.html
     */
    interface MLUserDataEncryptionProperty {
        /**
         * `CfnMLTransform.MLUserDataEncryptionProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption-mluserdataencryption.html#cfn-glue-mltransform-transformencryption-mluserdataencryption-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnMLTransform.MLUserDataEncryptionProperty.MLUserDataEncryptionMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption-mluserdataencryption.html#cfn-glue-mltransform-transformencryption-mluserdataencryption-mluserdataencryptionmode
         */
        readonly mlUserDataEncryptionMode: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption.html
     */
    interface TransformEncryptionProperty {
        /**
         * `CfnMLTransform.TransformEncryptionProperty.MLUserDataEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption.html#cfn-glue-mltransform-transformencryption-mluserdataencryption
         */
        readonly mlUserDataEncryption?: CfnMLTransform.MLUserDataEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnMLTransform.TransformEncryptionProperty.TaskRunSecurityConfigurationName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformencryption.html#cfn-glue-mltransform-transformencryption-taskrunsecurityconfigurationname
         */
        readonly taskRunSecurityConfigurationName?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 */
export declare namespace CfnMLTransform {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html
     */
    interface TransformParametersProperty {
        /**
         * `CfnMLTransform.TransformParametersProperty.FindMatchesParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters
         */
        readonly findMatchesParameters?: CfnMLTransform.FindMatchesParametersProperty | cdk.IResolvable;
        /**
         * `CfnMLTransform.TransformParametersProperty.TransformType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html#cfn-glue-mltransform-transformparameters-transformtype
         */
        readonly transformType: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Partition`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export interface CfnPartitionProps {
    /**
     * `AWS::Glue::Partition.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Partition.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Partition.PartitionInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput
     */
    readonly partitionInput: CfnPartition.PartitionInputProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Partition.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename
     */
    readonly tableName: string;
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare class CfnPartition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Partition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPartition;
    /**
     * `AWS::Glue::Partition.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid
     */
    catalogId: string;
    /**
     * `AWS::Glue::Partition.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename
     */
    databaseName: string;
    /**
     * `AWS::Glue::Partition.PartitionInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput
     */
    partitionInput: CfnPartition.PartitionInputProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Partition.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename
     */
    tableName: string;
    /**
     * Create a new `AWS::Glue::Partition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPartitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnPartition.ColumnProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-comment
         */
        readonly comment?: string;
        /**
         * `CfnPartition.ColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-name
         */
        readonly name: string;
        /**
         * `CfnPartition.ColumnProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html
     */
    interface OrderProperty {
        /**
         * `CfnPartition.OrderProperty.Column`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-column
         */
        readonly column: string;
        /**
         * `CfnPartition.OrderProperty.SortOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-sortorder
         */
        readonly sortOrder?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html
     */
    interface PartitionInputProperty {
        /**
         * `CfnPartition.PartitionInputProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.PartitionInputProperty.StorageDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-storagedescriptor
         */
        readonly storageDescriptor?: CfnPartition.StorageDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnPartition.PartitionInputProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-values
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemaid.html
     */
    interface SchemaIdProperty {
        /**
         * `CfnPartition.SchemaIdProperty.RegistryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemaid.html#cfn-glue-partition-schemaid-registryname
         */
        readonly registryName?: string;
        /**
         * `CfnPartition.SchemaIdProperty.SchemaArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemaid.html#cfn-glue-partition-schemaid-schemaarn
         */
        readonly schemaArn?: string;
        /**
         * `CfnPartition.SchemaIdProperty.SchemaName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemaid.html#cfn-glue-partition-schemaid-schemaname
         */
        readonly schemaName?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemareference.html
     */
    interface SchemaReferenceProperty {
        /**
         * `CfnPartition.SchemaReferenceProperty.SchameVersionId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemareference.html#cfn-glue-partition-schemareference-schameversionid
         */
        readonly schameVersionId?: string;
        /**
         * `CfnPartition.SchemaReferenceProperty.SchemaId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemareference.html#cfn-glue-partition-schemareference-schemaid
         */
        readonly schemaId?: CfnPartition.SchemaIdProperty | cdk.IResolvable;
        /**
         * `CfnPartition.SchemaReferenceProperty.SchemaVersionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-schemareference.html#cfn-glue-partition-schemareference-schemaversionnumber
         */
        readonly schemaVersionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html
     */
    interface SerdeInfoProperty {
        /**
         * `CfnPartition.SerdeInfoProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-name
         */
        readonly name?: string;
        /**
         * `CfnPartition.SerdeInfoProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.SerdeInfoProperty.SerializationLibrary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-serializationlibrary
         */
        readonly serializationLibrary?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html
     */
    interface SkewedInfoProperty {
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnnames
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValueLocationMaps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvaluelocationmaps
         */
        readonly skewedColumnValueLocationMaps?: any | cdk.IResolvable;
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValues`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvalues
         */
        readonly skewedColumnValues?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Partition
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 */
export declare namespace CfnPartition {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnPartition.StorageDescriptorProperty.BucketColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-bucketcolumns
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnPartition.StorageDescriptorProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-columns
         */
        readonly columns?: Array<CfnPartition.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.Compressed`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-compressed
         */
        readonly compressed?: boolean | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.InputFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-inputformat
         */
        readonly inputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Location`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-location
         */
        readonly location?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.NumberOfBuckets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-numberofbuckets
         */
        readonly numberOfBuckets?: number;
        /**
         * `CfnPartition.StorageDescriptorProperty.OutputFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-outputformat
         */
        readonly outputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SchemaReference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-schemareference
         */
        readonly schemaReference?: CfnPartition.SchemaReferenceProperty | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SerdeInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-serdeinfo
         */
        readonly serdeInfo?: CfnPartition.SerdeInfoProperty | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SkewedInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-skewedinfo
         */
        readonly skewedInfo?: CfnPartition.SkewedInfoProperty | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SortColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-sortcolumns
         */
        readonly sortColumns?: Array<CfnPartition.OrderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.StoredAsSubDirectories`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-storedassubdirectories
         */
        readonly storedAsSubDirectories?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::Registry`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html
 */
export interface CfnRegistryProps {
    /**
     * `AWS::Glue::Registry.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-name
     */
    readonly name: string;
    /**
     * `AWS::Glue::Registry.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Registry.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Glue::Registry`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Registry
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html
 */
export declare class CfnRegistry extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Registry";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRegistry;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Glue::Registry.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-name
     */
    name: string;
    /**
     * `AWS::Glue::Registry.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Registry.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-registry.html#cfn-glue-registry-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Registry`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRegistryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Glue::Schema`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html
 */
export interface CfnSchemaProps {
    /**
     * `AWS::Glue::Schema.Compatibility`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-compatibility
     */
    readonly compatibility: string;
    /**
     * `AWS::Glue::Schema.DataFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-dataformat
     */
    readonly dataFormat: string;
    /**
     * `AWS::Glue::Schema.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-name
     */
    readonly name: string;
    /**
     * `AWS::Glue::Schema.SchemaDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-schemadefinition
     */
    readonly schemaDefinition: string;
    /**
     * `AWS::Glue::Schema.CheckpointVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-checkpointversion
     */
    readonly checkpointVersion?: CfnSchema.SchemaVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Schema.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Schema.Registry`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-registry
     */
    readonly registry?: CfnSchema.RegistryProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Schema.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Glue::Schema`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Schema
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html
 */
export declare class CfnSchema extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Schema";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSchema;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute InitialSchemaVersionId
     */
    readonly attrInitialSchemaVersionId: string;
    /**
     * `AWS::Glue::Schema.Compatibility`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-compatibility
     */
    compatibility: string;
    /**
     * `AWS::Glue::Schema.DataFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-dataformat
     */
    dataFormat: string;
    /**
     * `AWS::Glue::Schema.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-name
     */
    name: string;
    /**
     * `AWS::Glue::Schema.SchemaDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-schemadefinition
     */
    schemaDefinition: string;
    /**
     * `AWS::Glue::Schema.CheckpointVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-checkpointversion
     */
    checkpointVersion: CfnSchema.SchemaVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Schema.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Schema.Registry`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-registry
     */
    registry: CfnSchema.RegistryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Schema.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html#cfn-glue-schema-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Schema`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSchemaProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Schema`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Schema
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html
 */
export declare namespace CfnSchema {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-registry.html
     */
    interface RegistryProperty {
        /**
         * `CfnSchema.RegistryProperty.Arn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-registry.html#cfn-glue-schema-registry-arn
         */
        readonly arn?: string;
        /**
         * `CfnSchema.RegistryProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-registry.html#cfn-glue-schema-registry-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Schema`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Schema
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schema.html
 */
export declare namespace CfnSchema {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-schemaversion.html
     */
    interface SchemaVersionProperty {
        /**
         * `CfnSchema.SchemaVersionProperty.IsLatest`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-schemaversion.html#cfn-glue-schema-schemaversion-islatest
         */
        readonly isLatest?: boolean | cdk.IResolvable;
        /**
         * `CfnSchema.SchemaVersionProperty.VersionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schema-schemaversion.html#cfn-glue-schema-schemaversion-versionnumber
         */
        readonly versionNumber?: number;
    }
}
/**
 * Properties for defining a `AWS::Glue::SchemaVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html
 */
export interface CfnSchemaVersionProps {
    /**
     * `AWS::Glue::SchemaVersion.Schema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema
     */
    readonly schema: CfnSchemaVersion.SchemaProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SchemaVersion.SchemaDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schemadefinition
     */
    readonly schemaDefinition: string;
}
/**
 * A CloudFormation `AWS::Glue::SchemaVersion`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SchemaVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html
 */
export declare class CfnSchemaVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::SchemaVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSchemaVersion;
    /**
     * @external
     * @cloudformationAttribute VersionId
     */
    readonly attrVersionId: string;
    /**
     * `AWS::Glue::SchemaVersion.Schema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema
     */
    schema: CfnSchemaVersion.SchemaProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SchemaVersion.SchemaDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schemadefinition
     */
    schemaDefinition: string;
    /**
     * Create a new `AWS::Glue::SchemaVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSchemaVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::SchemaVersion`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SchemaVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html
 */
export declare namespace CfnSchemaVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html
     */
    interface SchemaProperty {
        /**
         * `CfnSchemaVersion.SchemaProperty.RegistryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-registryname
         */
        readonly registryName?: string;
        /**
         * `CfnSchemaVersion.SchemaProperty.SchemaArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaarn
         */
        readonly schemaArn?: string;
        /**
         * `CfnSchemaVersion.SchemaProperty.SchemaName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaname
         */
        readonly schemaName?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::SchemaVersionMetadata`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html
 */
export interface CfnSchemaVersionMetadataProps {
    /**
     * `AWS::Glue::SchemaVersionMetadata.Key`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-key
     */
    readonly key: string;
    /**
     * `AWS::Glue::SchemaVersionMetadata.SchemaVersionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-schemaversionid
     */
    readonly schemaVersionId: string;
    /**
     * `AWS::Glue::SchemaVersionMetadata.Value`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-value
     */
    readonly value: string;
}
/**
 * A CloudFormation `AWS::Glue::SchemaVersionMetadata`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SchemaVersionMetadata
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html
 */
export declare class CfnSchemaVersionMetadata extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::SchemaVersionMetadata";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSchemaVersionMetadata;
    /**
     * `AWS::Glue::SchemaVersionMetadata.Key`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-key
     */
    key: string;
    /**
     * `AWS::Glue::SchemaVersionMetadata.SchemaVersionId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-schemaversionid
     */
    schemaVersionId: string;
    /**
     * `AWS::Glue::SchemaVersionMetadata.Value`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversionmetadata.html#cfn-glue-schemaversionmetadata-value
     */
    value: string;
    /**
     * Create a new `AWS::Glue::SchemaVersionMetadata`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSchemaVersionMetadataProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export interface CfnSecurityConfigurationProps {
    /**
     * `AWS::Glue::SecurityConfiguration.EncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration
     */
    readonly encryptionConfiguration: CfnSecurityConfiguration.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SecurityConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-name
     */
    readonly name: string;
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export declare class CfnSecurityConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::SecurityConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityConfiguration;
    /**
     * `AWS::Glue::SecurityConfiguration.EncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration
     */
    encryptionConfiguration: CfnSecurityConfiguration.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SecurityConfiguration.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-name
     */
    name: string;
    /**
     * Create a new `AWS::Glue::SecurityConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html
     */
    interface CloudWatchEncryptionProperty {
        /**
         * `CfnSecurityConfiguration.CloudWatchEncryptionProperty.CloudWatchEncryptionMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html#cfn-glue-securityconfiguration-cloudwatchencryption-cloudwatchencryptionmode
         */
        readonly cloudWatchEncryptionMode?: string;
        /**
         * `CfnSecurityConfiguration.CloudWatchEncryptionProperty.KmsKeyArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html#cfn-glue-securityconfiguration-cloudwatchencryption-kmskeyarn
         */
        readonly kmsKeyArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.CloudWatchEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-cloudwatchencryption
         */
        readonly cloudWatchEncryption?: CfnSecurityConfiguration.CloudWatchEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.JobBookmarksEncryption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-jobbookmarksencryption
         */
        readonly jobBookmarksEncryption?: CfnSecurityConfiguration.JobBookmarksEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.S3Encryptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-s3encryptions
         */
        readonly s3Encryptions?: Array<CfnSecurityConfiguration.S3EncryptionProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html
     */
    interface JobBookmarksEncryptionProperty {
        /**
         * `CfnSecurityConfiguration.JobBookmarksEncryptionProperty.JobBookmarksEncryptionMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html#cfn-glue-securityconfiguration-jobbookmarksencryption-jobbookmarksencryptionmode
         */
        readonly jobBookmarksEncryptionMode?: string;
        /**
         * `CfnSecurityConfiguration.JobBookmarksEncryptionProperty.KmsKeyArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html#cfn-glue-securityconfiguration-jobbookmarksencryption-kmskeyarn
         */
        readonly kmsKeyArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html
     */
    interface S3EncryptionProperty {
        /**
         * `CfnSecurityConfiguration.S3EncryptionProperty.KmsKeyArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html#cfn-glue-securityconfiguration-s3encryption-kmskeyarn
         */
        readonly kmsKeyArn?: string;
        /**
         * `CfnSecurityConfiguration.S3EncryptionProperty.S3EncryptionMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html#cfn-glue-securityconfiguration-s3encryption-s3encryptionmode
         */
        readonly s3EncryptionMode?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Table`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export interface CfnTableProps {
    /**
     * `AWS::Glue::Table.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Table.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Table.TableInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput
     */
    readonly tableInput: CfnTable.TableInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Table";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTable;
    /**
     * `AWS::Glue::Table.CatalogId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid
     */
    catalogId: string;
    /**
     * `AWS::Glue::Table.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename
     */
    databaseName: string;
    /**
     * `AWS::Glue::Table.TableInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput
     */
    tableInput: CfnTable.TableInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Table`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnTable.ColumnProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-comment
         */
        readonly comment?: string;
        /**
         * `CfnTable.ColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-name
         */
        readonly name: string;
        /**
         * `CfnTable.ColumnProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html
     */
    interface OrderProperty {
        /**
         * `CfnTable.OrderProperty.Column`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-column
         */
        readonly column: string;
        /**
         * `CfnTable.OrderProperty.SortOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-sortorder
         */
        readonly sortOrder: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html
     */
    interface SchemaIdProperty {
        /**
         * `CfnTable.SchemaIdProperty.RegistryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-registryname
         */
        readonly registryName?: string;
        /**
         * `CfnTable.SchemaIdProperty.SchemaArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaarn
         */
        readonly schemaArn?: string;
        /**
         * `CfnTable.SchemaIdProperty.SchemaName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaname
         */
        readonly schemaName?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html
     */
    interface SchemaReferenceProperty {
        /**
         * `CfnTable.SchemaReferenceProperty.SchameVersionId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schameversionid
         */
        readonly schameVersionId?: string;
        /**
         * `CfnTable.SchemaReferenceProperty.SchemaId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaid
         */
        readonly schemaId?: CfnTable.SchemaIdProperty | cdk.IResolvable;
        /**
         * `CfnTable.SchemaReferenceProperty.SchemaVersionNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaversionnumber
         */
        readonly schemaVersionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html
     */
    interface SerdeInfoProperty {
        /**
         * `CfnTable.SerdeInfoProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-name
         */
        readonly name?: string;
        /**
         * `CfnTable.SerdeInfoProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.SerdeInfoProperty.SerializationLibrary`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-serializationlibrary
         */
        readonly serializationLibrary?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html
     */
    interface SkewedInfoProperty {
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnnames
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValueLocationMaps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvaluelocationmaps
         */
        readonly skewedColumnValueLocationMaps?: any | cdk.IResolvable;
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValues`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvalues
         */
        readonly skewedColumnValues?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnTable.StorageDescriptorProperty.BucketColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-bucketcolumns
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnTable.StorageDescriptorProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-columns
         */
        readonly columns?: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.Compressed`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-compressed
         */
        readonly compressed?: boolean | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.InputFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-inputformat
         */
        readonly inputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Location`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-location
         */
        readonly location?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.NumberOfBuckets`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-numberofbuckets
         */
        readonly numberOfBuckets?: number;
        /**
         * `CfnTable.StorageDescriptorProperty.OutputFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-outputformat
         */
        readonly outputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SchemaReference`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-schemareference
         */
        readonly schemaReference?: CfnTable.SchemaReferenceProperty | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SerdeInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-serdeinfo
         */
        readonly serdeInfo?: CfnTable.SerdeInfoProperty | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SkewedInfo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-skewedinfo
         */
        readonly skewedInfo?: CfnTable.SkewedInfoProperty | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SortColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-sortcolumns
         */
        readonly sortColumns?: Array<CfnTable.OrderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.StoredAsSubDirectories`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-storedassubdirectories
         */
        readonly storedAsSubDirectories?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html
     */
    interface TableIdentifierProperty {
        /**
         * `CfnTable.TableIdentifierProperty.CatalogId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-catalogid
         */
        readonly catalogId?: string;
        /**
         * `CfnTable.TableIdentifierProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnTable.TableIdentifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html
     */
    interface TableInputProperty {
        /**
         * `CfnTable.TableInputProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-description
         */
        readonly description?: string;
        /**
         * `CfnTable.TableInputProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-name
         */
        readonly name?: string;
        /**
         * `CfnTable.TableInputProperty.Owner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-owner
         */
        readonly owner?: string;
        /**
         * `CfnTable.TableInputProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.PartitionKeys`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-partitionkeys
         */
        readonly partitionKeys?: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.Retention`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-retention
         */
        readonly retention?: number;
        /**
         * `CfnTable.TableInputProperty.StorageDescriptor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-storagedescriptor
         */
        readonly storageDescriptor?: CfnTable.StorageDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.TableType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-tabletype
         */
        readonly tableType?: string;
        /**
         * `CfnTable.TableInputProperty.TargetTable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-targettable
         */
        readonly targetTable?: CfnTable.TableIdentifierProperty | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.ViewExpandedText`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-viewexpandedtext
         */
        readonly viewExpandedText?: string;
        /**
         * `CfnTable.TableInputProperty.ViewOriginalText`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-vieworiginaltext
         */
        readonly viewOriginalText?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Trigger`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export interface CfnTriggerProps {
    /**
     * `AWS::Glue::Trigger.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-actions
     */
    readonly actions: Array<CfnTrigger.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-type
     */
    readonly type: string;
    /**
     * `AWS::Glue::Trigger.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Trigger.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Trigger.Predicate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-predicate
     */
    readonly predicate?: CfnTrigger.PredicateProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-schedule
     */
    readonly schedule?: string;
    /**
     * `AWS::Glue::Trigger.StartOnCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-startoncreation
     */
    readonly startOnCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::Trigger.WorkflowName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-workflowname
     */
    readonly workflowName?: string;
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare class CfnTrigger extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Trigger";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrigger;
    /**
     * `AWS::Glue::Trigger.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-actions
     */
    actions: Array<CfnTrigger.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-type
     */
    type: string;
    /**
     * `AWS::Glue::Trigger.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Trigger.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-name
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Trigger.Predicate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-predicate
     */
    predicate: CfnTrigger.PredicateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Trigger.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-schedule
     */
    schedule: string | undefined;
    /**
     * `AWS::Glue::Trigger.StartOnCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-startoncreation
     */
    startOnCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Trigger.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::Trigger.WorkflowName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-workflowname
     */
    workflowName: string | undefined;
    /**
     * Create a new `AWS::Glue::Trigger`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTriggerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare namespace CfnTrigger {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html
     */
    interface ActionProperty {
        /**
         * `CfnTrigger.ActionProperty.Arguments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-arguments
         */
        readonly arguments?: any | cdk.IResolvable;
        /**
         * `CfnTrigger.ActionProperty.CrawlerName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-crawlername
         */
        readonly crawlerName?: string;
        /**
         * `CfnTrigger.ActionProperty.JobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-jobname
         */
        readonly jobName?: string;
        /**
         * `CfnTrigger.ActionProperty.NotificationProperty`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-notificationproperty
         */
        readonly notificationProperty?: CfnTrigger.NotificationPropertyProperty | cdk.IResolvable;
        /**
         * `CfnTrigger.ActionProperty.SecurityConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-securityconfiguration
         */
        readonly securityConfiguration?: string;
        /**
         * `CfnTrigger.ActionProperty.Timeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-timeout
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare namespace CfnTrigger {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html
     */
    interface ConditionProperty {
        /**
         * `CfnTrigger.ConditionProperty.CrawlState`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-crawlstate
         */
        readonly crawlState?: string;
        /**
         * `CfnTrigger.ConditionProperty.CrawlerName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-crawlername
         */
        readonly crawlerName?: string;
        /**
         * `CfnTrigger.ConditionProperty.JobName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-jobname
         */
        readonly jobName?: string;
        /**
         * `CfnTrigger.ConditionProperty.LogicalOperator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-logicaloperator
         */
        readonly logicalOperator?: string;
        /**
         * `CfnTrigger.ConditionProperty.State`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-state
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare namespace CfnTrigger {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-notificationproperty.html
     */
    interface NotificationPropertyProperty {
        /**
         * `CfnTrigger.NotificationPropertyProperty.NotifyDelayAfter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-notificationproperty.html#cfn-glue-trigger-notificationproperty-notifydelayafter
         */
        readonly notifyDelayAfter?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 */
export declare namespace CfnTrigger {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html
     */
    interface PredicateProperty {
        /**
         * `CfnTrigger.PredicateProperty.Conditions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-conditions
         */
        readonly conditions?: Array<CfnTrigger.ConditionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTrigger.PredicateProperty.Logical`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-logical
         */
        readonly logical?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Workflow`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html
 */
export interface CfnWorkflowProps {
    /**
     * `AWS::Glue::Workflow.DefaultRunProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-defaultrunproperties
     */
    readonly defaultRunProperties?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::Workflow.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-description
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Workflow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-name
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Workflow.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Glue::Workflow`.
 *
 * @external
 * @cloudformationResource AWS::Glue::Workflow
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html
 */
export declare class CfnWorkflow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Workflow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkflow;
    /**
     * `AWS::Glue::Workflow.DefaultRunProperties`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-defaultrunproperties
     */
    defaultRunProperties: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Workflow.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-description
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Workflow.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-name
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Workflow.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Workflow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkflowProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
