# pyetta

[![Documentation Status](https://readthedocs.org/projects/pyetta/badge/?version=latest)](https://pyetta.readthedocs.io/en/latest/)
[![Discord](https://img.shields.io/discord/1005420113194930309?color=C5F0A4)](https://discord.gg/4cmv4vrmYC)
[![codecov](https://codecov.io/gh/kenkaijie/pyetta/branch/master/graph/badge.svg?token=7PFFKAUR25)](https://codecov.io/gh/kenkaijie/pyetta)
[![Build, Test, and Coverage](https://github.com/kenkaijie/pyetta/actions/workflows/python-tests.yml/badge.svg)](https://github.com/kenkaijie/pyetta)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pyetta)](https://pypi.org/project/pyetta/)

`pyetta` is a multi-tool made to simplify device on target testing workflows by
providing some helpers which modularise the process of on target testing. It
provides both a CLI for simple use cases, and a library of components that can
simplify creation of test scripts.

The tool can be installed from pip by running the following command.

```shell
$ pip install pyetta
```

## Assistance

Detailed information including usage and development goals can be found in the 
[official documentation](https://pyetta.readthedocs.io/en/latest/).

# What does it do?

`pyetta` tries to bridge the gap between embedded systems development 
(targeting microcontrollers) and CI/CD practises and the concept of 
continual testing.

It does this in 2 approaches:

- A shipped CLI tool, which enables systems with commonly used frameworks to 
  avoid having to rewrite testing parsers and converters to get the test 
  results from the embedded board to their CI/CD pipeline.
- A library of common tools used within the CLI tool that can assist and 
  simplify the process of writing integration tests against the system.

See the example below, if this sounds like something you have encountered or 
are encountering, then `pyetta` may be able to help!

## Sample Use Case

A firmware developer develops an application targeting an STM32 
microcontroller. This board performs various actions, including interfacing 
with an SPI-based NAND flash storage device. The developer either writes this 
driver themselves or they use an existing implementation provided by an external 
party. Both of these scenarios needs to be tested. 

Using `pyetta`, the developer may simplify their testing of the interaction 
between the microcontroller and the flash chip. Depending on the testing 
approach, the functionality can be testing either on-target (with the 
microcontroller running the tests) or off-target, with a PC running the test on 
the microcontroller.

For on-target testing, `pyetta` CLI tool can assist the process of loading 
firmware onto the board, executing the tests, collecting the data for these 
tests, and parsing it into a supported and consumable format for the CI/CD 
pipeline such as JUnit XML.

For off-target testing, `pyetta`'s library of components can assist with 
developing fixtures via the off-target unit test library (pytest for example).

# Project Structure

The project is structured as follows.

```text
root
|---.github: Github specific CI/CD actions
|---docs: Documentation for this project
|---examples: Examples relating to plugin development.
|---pyetta: Project sources
|---test: Test directory for project. 
```

# Project Environment

The project python dependencies can be obtained by using pip to install them.
Ensure the `[dev]` extras is installed in order to perform common developer
actions such as testing or building docs or running tests.

## Dependencies

The command below will install all the dependencies and the project itself into
the standard python locations for your platform.

```shell
$ pip install .[dev]
```

If only the dependencies are needed, you can subsequently call `pip uninstall` 
to remove the top level pyetta package.

```shell
$ pip uninstall --yes pyetta
```

## Linting, Tests and Coverage

Tests for this project use `tox` to orchestrate all testing items and is used 
for preparing a branch for submission. As such, it is the recommended way to do 
preliminary testing on the development machine as well. 

The command below runs tox on the developer's python version, as well as 
building the documentation. You can specify the standard 
[tox environments](https://tox.wiki/en/latest/config.html#tox-environments) 
for testing specific python versions.

```shell
$ tox -p
```

Coverage can be generated by first combining all the coverage files, then 
creating the relevant reports.

```shell
$ coverage combine
$ coverage html
```

If you do not wish to use `tox`, the individual actions supported from `tox.
ini` can be inspected and run manually. Some common manual steps are shown 
below for reference.

## Linting and Analysis

Linting and static analysis is done using `flake8`. The command below can be
used to run the linter.

```shell
$ flake8 --show-source
```

## Documentation

Documentation for this project is located in the `docs` folder and is built by
`sphinx`. 

```shell
$ sphinx-build docs dist/docs
```

Running the command above will generate the documentation for this project and
save it to a folder `dist/docs`.

## Packaging

Packing is done using python's build command. The command below will build the
package for deployment to a python package repository.

```shell
$ python -m build
```

## Debugging

A note on debugging pyetta built-in plugins. The built-in plugins can be 
auto-loaded if  the pyetta package is installed and the entrypoint metadata is 
available to the system. To circumvent this, builtin commands can be injected in
via the `--extras` flag if they are needed during development.
