# Generated by Django 2.2.5 on 2019-12-16 10:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Identity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_key_blob', models.TextField()),
                ('private_key_blob', models.TextField()),
                ('secret_blob', models.TextField(blank=True, null=True)),
                ('hash_info', models.CharField(blank=True, max_length=256, null=True)),
                ('encrypters', models.ManyToManyField(help_text='The user doing the impersonating.', related_name='_identity_encrypters_+', to='django_pgpy.Identity')),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='pgp_identity', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='RequestKeyRecovery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('secret_blob', models.TextField(blank=True, null=True)),
                ('hash_info', models.CharField(blank=True, max_length=32, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('finished_at', models.DateTimeField(blank=True, null=True)),
                ('reset_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='password_reset_requests', to='django_pgpy.Identity')),
                ('uid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reset_requests', to='django_pgpy.Identity')),
            ],
        ),
    ]
