#!/bin/sh

set -eux

GXX_COMMAND=${CXX_COMPILER:-"g++"}

SCALUQ_USE_OMP=${SCALUQ_USE_OMP:-"ON"}
SCALUQ_USE_CUDA=${SCALUQ_USE_CUDA:-"OFF"}
SCALUQ_USE_TEST=${SCALUQ_USE_TEST:-"ON"}
SCALUQ_USE_EXE=${SCALUQ_USE_EXE:-"ON"}

CMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE:-"Release"}

CMAKE_OPS="-D CMAKE_CXX_COMPILER=${GXX_COMMAND} \
  -D CMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE} \
  -D SCALUQ_USE_OMP=${SCALUQ_USE_OMP} \
  -D SCALUQ_USE_CUDA=${SCALUQ_USE_CUDA} \
  -D SCALUQ_USE_TEST=${SCALUQ_USE_TEST}"

if [ -n "${SCALUQ_CUDA_ARCH:-""}" ]; then
  CMAKE_OPS="${CMAKE_OPS} -D SCALUQ_CUDA_ARCH=${SCALUQ_CUDA_ARCH}"
fi

mkdir -p ./build
cmake -B build -G Ninja ${CMAKE_OPS}
ninja -C build -j $(nproc)
