# OVERVIEW

该工程是 Python 版本的 request-lifecycle，用于收集请求过程中的日志


# USAGE

在 Flask 中在请求生命周期的两段嵌入如下代码。在嵌入 before_request 后，可以通过 g.trace_id 获取请求的 ID。

```Python
from flask import Flask
from request_lifecycle import RequestLifecycleMiddleware


app = Flask(__name__)


@app.before_request
def before_request():
    """在这里放入一个配置好 log-server 的前置中间件
    """
    RequestLifecycleMiddleware.before_request(host='127.0.0.1', port='3000', app_name='whatever',
                                              additional_req_fields=[])


@app.after_request
def after_request(response: Flask.response_class):
    """在这里放入一个捕捉 response 的中间件
    """
    RequestLifecycleMiddleware.after_request(response=response)
    return response
```
