"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const lambda = require("@aws-cdk/aws-lambda");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const index_1 = require("../index");
class ExampleStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // user's lambda function
        const hello = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_10_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "hello.handler",
        });
        // set up rest api and log group
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: hello,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const hello1 = new lambda.Function(this, "HelloHandler1", {
            runtime: lambda.Runtime.NODEJS_10_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "hello.handler",
        });
        const restLogGroup1 = new aws_logs_1.LogGroup(this, "restLogGroup1");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test1", {
            handler: hello1,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup1),
            },
        });
        const hello2 = new lambda.Function(this, "HelloHandler2", {
            runtime: lambda.Runtime.PYTHON_3_7,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "hello_py.handler",
            tracing: lambda.Tracing.ACTIVE,
        });
        const restLogGroup2 = new aws_logs_1.LogGroup(this, "restLogGroup2");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test2", {
            handler: hello2,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup2),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 39,
            pythonLayerVersion: 24,
            forwarderArn: "<forwarder_ARN>",
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([hello, hello1, hello2]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup, restLogGroup1, restLogGroup2]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new cdk.App();
const env = { account: "<AWS_ACCOUNT>", region: "sa-east-1" };
const stack = new ExampleStack(app, "ExampleDatadogStack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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