"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnvVariables = exports.defaultEnvVar = exports.injectLogContextEnvVar = exports.enableDDTracingEnvVar = void 0;
const loglevel_1 = require("loglevel");
exports.enableDDTracingEnvVar = "DD_TRACE_ENABLED";
exports.injectLogContextEnvVar = "DD_LOGS_INJECTION";
exports.defaultEnvVar = {
    addLayers: true,
    enableDatadogTracing: true,
    injectLogContext: true,
};
function applyEnvVariables(lambdas, enableDatadogTracing, injectLogContext) {
    loglevel_1.default.debug(`Setting tracing environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.enableDDTracingEnvVar, enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.injectLogContextEnvVar, injectLogContext.toString().toLowerCase());
    });
}
exports.applyEnvVariables = applyEnvVariables;
//# sourceMappingURL=data:application/json;base64,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