"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const index_1 = require("./index");
const transport_1 = require("./transport");
const versionJson = require("../version.json");
var TagKeys;
(function (TagKeys) {
    TagKeys["Cdk"] = "dd_cdk_construct";
})(TagKeys || (TagKeys = {}));
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        if (process.env.DD_CONSTRUCT_DEBUG_LOGS == "true")
            loglevel_1.default.setLevel("debug");
        super(scope, id);
        this.scope = scope;
        this.props = props;
        validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        let addLayers = this.props.addLayers;
        let enableDatadogTracing = this.props.enableDatadogTracing;
        let injectLogContext = this.props.injectLogContext;
        if (addLayers === undefined) {
            loglevel_1.default.debug(`No value provided for addLayers, defaulting to ${index_1.defaultEnvVar.addLayers}`);
            addLayers = index_1.defaultEnvVar.addLayers;
        }
        if (enableDatadogTracing === undefined) {
            loglevel_1.default.debug(`No value provided for enableDatadogTracing, defaulting to ${index_1.defaultEnvVar.enableDatadogTracing}`);
            enableDatadogTracing = index_1.defaultEnvVar.enableDatadogTracing;
        }
        if (injectLogContext === undefined) {
            loglevel_1.default.debug(`No value provided for injectLogContext, defaulting to ${index_1.defaultEnvVar.injectLogContext}`);
            injectLogContext = index_1.defaultEnvVar.injectLogContext;
        }
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            index_1.redirectHandlers(lambdaFunctions, addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, enableDatadogTracing, injectLogContext);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.2.5" };
/**
 * Tags the function(s) with DD Cdk version
 */
function addCdkTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Version ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(TagKeys.Cdk, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkTag = addCdkTag;
function validateProps(props) {
    loglevel_1.default.debug("Validating props...");
    const siteList = ["datadoghq.com", "datadoghq.eu", "us3.datadoghq.com", "ddog-gov.com"];
    if (props.apiKey !== undefined && props.apiKmsKey !== undefined) {
        throw new Error("Both `apiKey` and `apiKmsKey` cannot be set.");
    }
    if (props.site !== undefined && !siteList.includes(props.site.toLowerCase())) {
        throw new Error("Warning: Invalid site URL. Must be either datadoghq.com, datadoghq.eu, us3.datadoghq.com, or ddog-gov.com.");
    }
    if (props.apiKey === undefined && props.apiKmsKey === undefined && props.flushMetricsToLogs === false) {
        throw new Error("When `flushMetricsToLogs` is false, `apiKey` or `apiKmsKey` must also be set.");
    }
    if (props.extensionLayerVersion !== undefined) {
        if (props.apiKey === undefined && props.apiKmsKey === undefined) {
            throw new Error("When `extensionLayer` is set, `apiKey` or `apiKmsKey` must also be set.");
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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