/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.Credential;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.PasswordCredential;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class CredentialsException
extends LoginException {
    private static final long serialVersionUID = 8213976686585544272L;
    private boolean _passwordCredential;
    private String _userName;
    private String _domain;

    protected CredentialsException() {
    }

    protected CredentialsException(String msg) {
        super(msg);
    }

    protected CredentialsException(Throwable nestedException) {
        super(nestedException);
    }

    protected CredentialsException(String msg, Throwable nestedException) {
        super(msg, nestedException);
    }

    protected CredentialsException(String msg, Throwable nestedException, Credential badCredential) {
        super(msg, nestedException);
        this.setCredential(badCredential);
    }

    public boolean isPasswordCredential() {
        return this._passwordCredential;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getDomain() {
        return this._domain;
    }

    private void setCredential(Credential badCredential) {
        if (badCredential == null) {
            return;
        }
        this._domain = badCredential.getDomain();
        try {
            this._userName = ((PasswordCredential)badCredential).getUserName();
            this._passwordCredential = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

