/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@SASScope
@Immutable
final class Column
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String name;
    private final String label;
    private final int sqlType;
    private final String typeNm;
    private final int length;
    private final String formatNm;
    private final int formatLength;
    private final int formatWidth;
    private final int formatDecimal;
    private final String iformatNm;
    private final int informatWidth;
    private final int informatDecimal;

    private Column(Builder builder) {
        this.name = builder.name;
        this.label = builder.label;
        this.sqlType = builder.sqlType;
        this.typeNm = builder.typeName;
        this.length = builder.length;
        this.formatNm = builder.formatName;
        this.formatLength = builder.formatLength;
        this.formatWidth = builder.formatWidth;
        this.formatDecimal = builder.formatDecimal;
        this.iformatNm = builder.informatName;
        this.informatWidth = builder.informatWidth;
        this.informatDecimal = builder.informatDecimal;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public short getFormatLength() {
        return (short)this.formatLength;
    }

    public String getFormatName() {
        return this.formatNm;
    }

    public short getFormatWidth() {
        return (short)this.formatWidth;
    }

    public String getInformatName() {
        return this.iformatNm;
    }

    public short getFormatDecimal() {
        return (short)this.formatDecimal;
    }

    public short getInformatWidth() {
        return (short)this.informatWidth;
    }

    public short getInformatDecimal() {
        return (short)this.informatDecimal;
    }

    public String toString() {
        return "Column [name=" + this.name + ", sqlType=" + this.sqlType + ", typeNm=" + this.typeNm + "]";
    }

    @SASScope
    public static class Builder {
        private static final String EMPTY_STRING = "";
        private String name = "";
        private int sqlType;
        private int length;
        private String label = "";
        private String typeName = "";
        private String formatName = "";
        private int formatLength;
        private int formatWidth;
        private int formatDecimal;
        private String informatName = "";
        private int informatWidth;
        private int informatDecimal;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder formatName(String formatName) {
            this.formatName = formatName;
            return this;
        }

        public Builder formatLength(int formatLength) {
            this.formatLength = formatLength;
            return this;
        }

        public Builder formatWidth(int formatWidth) {
            this.formatWidth = formatWidth;
            return this;
        }

        public Builder formatDecimal(int formatDecimal) {
            this.formatDecimal = formatDecimal;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder informatName(String informatName) {
            this.informatName = informatName;
            return this;
        }

        public Builder informatWidth(int informatWidth) {
            this.informatWidth = informatWidth;
            return this;
        }

        public Builder informatDecimal(int informatDecimal) {
            this.informatDecimal = informatDecimal;
            return this;
        }

        public Builder sqlType(int sqlType) {
            this.sqlType = sqlType;
            return this;
        }

        public Column build() {
            return new Column(this);
        }
    }
}

