/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.GlobalInfoTable;
import com.sas.net.BaseResourceLocator;
import com.sas.net.ClassResourceLocator;
import com.sas.net.ContextResourceLocator;
import com.sas.net.ResourceLocatorInterface;
import com.sas.util.Util;
import java.applet.Applet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;

public class AppletResourceLocator
extends BaseResourceLocator
implements ResourceLocatorInterface {
    static final long serialVersionUID = -765029301747160495L;
    protected Applet _applet;
    protected boolean _isDocumentBaseRelative;
    protected boolean _isCodeBaseRelative = true;

    public AppletResourceLocator() {
    }

    public AppletResourceLocator(String resourceName) {
        super(resourceName);
    }

    public Applet getApplet() {
        if (this._applet != null) {
            return this._applet;
        }
        return (Applet)GlobalInfoTable.getObject();
    }

    public void setApplet(Applet newValue) {
        if (!Util.equal(this._applet, newValue)) {
            Applet oldValue = this._applet;
            this._applet = newValue;
            this.firePropertyChange("applet", oldValue, newValue);
        }
    }

    public boolean isDocumentBaseRelative() {
        return this._isDocumentBaseRelative;
    }

    public void setDocumentBaseRelative(boolean newValue) {
        if (this._isDocumentBaseRelative != newValue) {
            this._isDocumentBaseRelative = newValue;
            if (this._isDocumentBaseRelative) {
                this.setCodeBaseRelative(false);
            }
            this.firePropertyChange("documentBaseRelative", new Boolean(!newValue), new Boolean(newValue));
        }
    }

    public boolean isCodeBaseRelative() {
        return this._isCodeBaseRelative;
    }

    public void setCodeBaseRelative(boolean newValue) {
        if (this._isCodeBaseRelative != newValue) {
            this._isCodeBaseRelative = newValue;
            if (this._isCodeBaseRelative) {
                this.setDocumentBaseRelative(false);
            }
            this.firePropertyChange("codeBaseRelative", new Boolean(!newValue), new Boolean(newValue));
        }
    }

    @Override
    public URL getResource() throws MalformedURLException {
        if (this.getResourceName() == null) {
            return null;
        }
        Applet applet = this.getApplet();
        if (applet == null) {
            String projDir = this.getProjectDirectory();
            String fileLocation = null;
            fileLocation = projDir != null ? projDir + File.separatorChar + this.getResourceName() : this.getResourceName();
            try {
                File file = new File(fileLocation);
                if (file.exists()) {
                    return file.toURL();
                }
            }
            catch (AccessControlException ex) {
                // empty catch block
            }
            return null;
        }
        ClassResourceLocator clrl = new ClassResourceLocator();
        clrl.setResourceName(this.getResourceName());
        clrl.setRelativeClass(applet.getClass());
        URL url = clrl.getResource();
        if (url != null) {
            return url;
        }
        if (!this.isDocumentBaseRelative() && !this.isCodeBaseRelative()) {
            return null;
        }
        ContextResourceLocator crl = new ContextResourceLocator();
        crl.setResourceName(this.getResourceName());
        if (this.isDocumentBaseRelative()) {
            crl.setContext(applet.getDocumentBase());
        } else {
            String codeBase = applet.getCodeBase().toString();
            if ((codeBase = this.removeHTMFileName(codeBase)) != null) {
                crl.setContext(new URL(codeBase));
            }
        }
        return crl.getResource();
    }

    @Override
    public String encode() {
        String codeOrDocumentBase = null;
        codeOrDocumentBase = this.isCodeBaseRelative() ? "code" : (this.isDocumentBaseRelative() ? "document" : "neither");
        return new String("Applet: ~<" + codeOrDocumentBase + ">~ ~<" + this.getApplet() + ">~ ~<" + this.getResourceName() + ">~");
    }

    public static ResourceLocatorInterface decode(String resource) {
        AppletResourceLocator arl = new AppletResourceLocator();
        if (resource.startsWith("Applet: ")) {
            int index = resource.indexOf(">~");
            if (index != -1) {
                String temp = resource.substring(10, index);
                if (Util.equal(temp, "code")) {
                    arl.setCodeBaseRelative(true);
                } else if (Util.equal(temp, "document")) {
                    arl.setDocumentBaseRelative(true);
                }
                int indexCopy = index;
                index = resource.indexOf(">~", index + 2);
                if (index != -1) {
                    temp = resource.substring(indexCopy + 5, index - 1);
                    arl.setResourceName(resource.substring(index + 5, resource.length() - 2));
                }
            }
            return arl;
        }
        return null;
    }

    @Override
    protected ResourceLocatorInterface createInstance(String resource) {
        return AppletResourceLocator.decode(resource);
    }

    public String getRelativePath() {
        return this.getResourceName();
    }

    public String getAbsolutePath() {
        String absolutePath = this.getProjectDirectory();
        if (absolutePath != null && !absolutePath.endsWith(File.separator)) {
            absolutePath = absolutePath + File.separator;
        }
        absolutePath = absolutePath + this.getResourceName();
        return absolutePath;
    }

    @Override
    public String getProjectDirectory() {
        int mode = this.getMode();
        if (mode == 1) {
            return System.getProperty("webaf.project.directory");
        }
        if (mode == 2) {
            return System.getProperty("webeis.document.directory");
        }
        String base = null;
        Applet applet = this.getApplet();
        if (applet != null) {
            base = this.isDocumentBaseRelative() ? applet.getDocumentBase().toString() : applet.getCodeBase().toString();
            base = this.removeHTMFileName(base);
            base = this.removeFileString(base);
            return base;
        }
        return null;
    }

    private String removeHTMFileName(String path) {
        int index;
        String base = path;
        if (base != null && System.getProperty("java.vendor").indexOf("Sun") >= 0 && (index = base.lastIndexOf(".htm")) > 0) {
            base = base.substring(0, base.lastIndexOf("/") + 1);
        }
        return base;
    }

    private String removeFileString(String path) {
        String base = path;
        if (base != null && base.startsWith("file:")) {
            base = base.substring(6);
        }
        return base;
    }
}

