/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.util.LocalizableString;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

@SASScope
public class OLAPMemberName
implements OLAPMemberNameInterface,
Serializable {
    private DataSourceInterface dataSource;
    private String uniqueName;
    private transient LocalizableString label;
    private static final long serialVersionUID = 1809189366350498490L;

    public OLAPMemberName() {
        this.init();
    }

    public OLAPMemberName(DataSourceInterface dataSource, String uniqueName, String label, Locale locale) {
        this.init();
        this.setDataSource(dataSource);
        this.setUniqueName(uniqueName);
        this.setLabel(label, locale);
    }

    private void init() {
        this.label = new LocalizableString();
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    @Override
    public String getLabel(Locale locale) {
        return this.label.getText(locale);
    }

    @Override
    public LocalizableString getLabel() {
        try {
            return (LocalizableString)this.label.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setLabel(LocalizableString label) {
        ValidateArg.notNull(label, "label");
        this.label = label;
    }

    public void setLabel(String label, Locale locale) {
        ValidateArg.notNull(locale, "locale");
        this.label.setText(label, locale);
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof OLAPMemberNameInterface) {
            OLAPMemberNameInterface other = (OLAPMemberNameInterface)otherItem;
            if (!Util.equal(this.getDataSource(), other.getDataSource())) {
                return false;
            }
            if (!Strings.equal(this.getUniqueName(), other.getUniqueName(), true, false)) {
                return false;
            }
            return Util.equal(this.getLabel(), other.getLabel());
        }
        return false;
    }

    public String toString() {
        return this.getUniqueName();
    }

    public int hashCode() {
        int code = 0;
        if (this.getLabel() != null) {
            code += this.getLabel().hashCode();
        }
        if (this.getUniqueName() != null) {
            code += this.getUniqueName().hashCode();
        }
        if (this.getDataSource() != null) {
            code += this.getDataSource().hashCode();
        }
        return code;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.dataSource);
        out.writeObject(this.uniqueName);
        String text = null;
        Locale locale = null;
        List<Locale> list = this.label.getLocales();
        if (!list.isEmpty()) {
            locale = list.get(0);
            text = this.label.getText(locale);
        }
        out.writeObject(locale);
        out.writeObject(text);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        in.defaultReadObject();
        this.dataSource = (DataSourceInterface)in.readObject();
        this.uniqueName = (String)in.readObject();
        Locale locale = (Locale)in.readObject();
        String text = (String)in.readObject();
        if (null != locale && null != text) {
            this.label.setText(text, locale);
        }
    }
}

