/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.RB;
import com.sas.text.NLFormats;
import com.sas.util.CalendarUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class TimeStampType
extends BaseDateType {
    public static final String RB_KEY = "TimeStampType.";
    public static final TimeStampType DEFAULT_INSTANCE = new TimeStampType();
    public static final TimeStampType DEFAULT_LOCAL_INSTANCE = new TimeStampType(TimeZone.getDefault());

    public TimeStampType() {
    }

    public TimeStampType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof Timestamp) {
            DatePeriod timestamp = new DatePeriod((Timestamp)inputValue, DateTypes.TIMESTAMP, this.getTimeZone(), inputLocale);
            return timestamp;
        }
        if (inputValue instanceof Calendar) {
            return this.coerceValue(((Calendar)inputValue).getTime(), inputLocale);
        }
        if (inputValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)inputValue;
            if (Util.equal(dp.getTimeZone(), this.getTimeZone())) {
                return dp;
            }
            return this.coerceValue(dp.toString(null, inputLocale), inputLocale);
        }
        if (inputValue instanceof Date) {
            return new DatePeriod((Date)inputValue, DateTypes.TIMESTAMP, this.getTimeZone(), inputLocale);
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        if (inputValue instanceof String) {
            String value = (String)inputValue;
            if (value.trim().length() == 0) {
                return null;
            }
            MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
            if (missingValue != null) {
                return missingValue;
            }
            SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
            if (specialValue != null) {
                return specialValue;
            }
            try {
                DateTypes[] dateTypes = new DateTypes[]{DateTypes.TIMESTAMP};
                DatePeriod dp = DatePeriod.parseDatePeriod(value, dateTypes, this.getTimeZone(), inputLocale);
                if (dp != null) {
                    return dp;
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
            Object transformObj = StringToMissingValuesTransform.defaultInstance.transform(value);
            if (transformObj.equals(MissingValues.Dot)) {
                return MissingValues.Dot;
            }
        } else {
            if (inputValue instanceof MissingValues) {
                return inputValue;
            }
            if (inputValue instanceof SpecialValues) {
                return inputValue;
            }
            if (inputValue == null) {
                return null;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("TimeStampType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object out = null;
        try {
            out = new DatePeriod(CalendarUtil.parseDateString(input, null, this.timeZone), DateTypes.TIMESTAMP, this.timeZone, Locale.US);
        }
        catch (ParseException e) {
            out = this.coerceValue(input, Locale.US);
        }
        return out;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        String out = null;
        if (value == null) {
            return out;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return out;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return ((SpecialValues)value).getName();
        }
        out = value instanceof Calendar ? CalendarUtil.formatCalendar((Calendar)value, null) : (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate() ? ((DatePeriod)value).toString() : CalendarUtil.formatDate((Date)value, null));
        return out;
    }

    @Override
    public DateFormat getDateFormatter(Object value, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(NLFormats.getPattern(this.getDefaultFormatName(), locale), locale);
        sdf.setLenient(false);
        return sdf;
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.TIMESTAMP;
    }

    @Override
    public int getSQLType() {
        return 93;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        Date outputDate = (Date)value;
        if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            map.put(baseMacroVariableName, TimeStampType.getQueryString(outputDate));
            map.put(baseMacroVariableName + "_rel", value.toString());
        } else {
            map.put(baseMacroVariableName, TimeStampType.getQueryString((Date)value));
        }
        map.put(baseMacroVariableName + "_label", this.getLabelForDate(outputDate, locale));
        return map;
    }

    public static String getQueryString(Date timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyyyy H:mm:ss", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(timestamp);
    }

    public static String formatSASTimeStamp(Date timestamp) {
        SimpleDateFormat formatter = null;
        formatter = new SimpleDateFormat("MMM d, yyyy h:mm:ss a", Locale.US);
        formatter.setLenient(false);
        formatter.setTimeZone(gmtTimeZone);
        return formatter.format(timestamp);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object out = this.coerceValue(value, inputLocale);
        if (null != out && out == value && out instanceof DatePeriod) {
            out = ((DatePeriod)out).clone();
        }
        return out;
    }

    @Override
    public String getDefaultFormatName() {
        return "NLDATMAP";
    }
}

