"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackSetOrganizationsAutoDeployment = exports.StackSetDeploymentModel = exports.StackSetParameters = exports.StackInstances = exports.StackSetTemplate = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * The source of a StackSet template
 */
class StackSetTemplate {
    /**
     * Use a file in an artifact as Stack Template.
     */
    static fromArtifactPath(artifactPath) {
        return new class extends StackSetTemplate {
            constructor() {
                super(...arguments);
                this._artifactsReferenced = [artifactPath.artifact];
            }
            _render() {
                return artifactPath.location;
            }
        }();
    }
}
exports.StackSetTemplate = StackSetTemplate;
_a = JSII_RTTI_SYMBOL_1;
StackSetTemplate[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.StackSetTemplate", version: "1.152.0" };
/**
 * Where Stack Instances will be created from the StackSet
 */
class StackInstances {
    /**
     * Create stack instances in a set of accounts and regions passed as literal lists
     *
     * Stack Instances will be created in every combination of region and account.
     *
     * > NOTE: `StackInstances.inAccounts()` and `StackInstances.inOrganizationalUnits()`
     * > have exactly the same behavior, and you can use them interchangeably if you want.
     * > The only difference between them is that your code clearly indicates what entity
     * > it's working with.
     */
    static inAccounts(accounts, regions) {
        return StackInstances.fromList(accounts, regions);
    }
    /**
     * Create stack instances in all accounts in a set of Organizational Units (OUs) and regions passed as literal lists
     *
     * If you want to deploy to Organization Units, you must choose have created the StackSet
     * with `deploymentModel: DeploymentModel.organizations()`.
     *
     * Stack Instances will be created in every combination of region and account.
     *
     * > NOTE: `StackInstances.inAccounts()` and `StackInstances.inOrganizationalUnits()`
     * > have exactly the same behavior, and you can use them interchangeably if you want.
     * > The only difference between them is that your code clearly indicates what entity
     * > it's working with.
     */
    static inOrganizationalUnits(ous, regions) {
        return StackInstances.fromList(ous, regions);
    }
    /**
     * Create stack instances in a set of accounts or organizational units taken from the pipeline artifacts, and a set of regions
     *
     * The file must be a JSON file containing a list of strings. For example:
     *
     * ```json
     * [
     *   "111111111111",
     *   "222222222222",
     *   "333333333333"
     * ]
     * ```
     *
     * Stack Instances will be created in every combination of region and account, or region and
     * Organizational Units (OUs).
     *
     * If this is set of Organizational Units, you must have selected `StackSetDeploymentModel.organizations()`
     * as deployment model.
     */
    static fromArtifactPath(artifactPath, regions) {
        if (regions.length === 0) {
            throw new Error("'regions' may not be an empty list");
        }
        return new class extends StackInstances {
            constructor() {
                super(...arguments);
                this._artifactsReferenced = [artifactPath.artifact];
            }
            _bind(_scope) {
                return {
                    stackSetConfiguration: {
                        DeploymentTargets: artifactPath.location,
                        Regions: regions.join(','),
                    },
                };
            }
        }();
    }
    /**
     * Create stack instances in a literal set of accounts or organizational units, and a set of regions
     *
     * Stack Instances will be created in every combination of region and account, or region and
     * Organizational Units (OUs).
     *
     * If this is set of Organizational Units, you must have selected `StackSetDeploymentModel.organizations()`
     * as deployment model.
     */
    static fromList(targets, regions) {
        if (targets.length === 0) {
            throw new Error("'targets' may not be an empty list");
        }
        if (regions.length === 0) {
            throw new Error("'regions' may not be an empty list");
        }
        return new class extends StackInstances {
            _bind(_scope) {
                return {
                    stackSetConfiguration: {
                        DeploymentTargets: targets.join(','),
                        Regions: regions.join(','),
                    },
                };
            }
        }();
    }
}
exports.StackInstances = StackInstances;
_b = JSII_RTTI_SYMBOL_1;
StackInstances[_b] = { fqn: "@aws-cdk/aws-codepipeline-actions.StackInstances", version: "1.152.0" };
/**
 * Base parameters for the StackSet
 */
class StackSetParameters {
    /**
     * A list of template parameters for your stack set.
     *
     * You must specify all template parameters. Parameters you don't specify will revert
     * to their `Default` values as specified in the template.
     *
     * Specify the names of parameters you want to retain their existing values,
     * without specifying what those values are, in an array in the second
     * argument to this function. Use of this feature is discouraged. CDK is for
     * specifying desired-state infrastructure, and use of this feature makes the
     * parameter values unmanaged.
     *
     * @example
     *
     * const parameters = codepipeline_actions.StackSetParameters.fromLiteral({
     *  BucketName: 'my-bucket',
     *  Asset1: 'true',
     * });
     */
    static fromLiteral(parameters, usePreviousValues) {
        return new class extends StackSetParameters {
            constructor() {
                super(...arguments);
                this._artifactsReferenced = [];
            }
            _render() {
                return [
                    ...Object.entries(parameters).map(([key, value]) => `ParameterKey=${key},ParameterValue=${value}`),
                    ...(usePreviousValues !== null && usePreviousValues !== void 0 ? usePreviousValues : []).map((key) => `ParameterKey=${key},UsePreviousValue=true`),
                ].join(' ');
            }
        }();
    }
    /**
     * Read the parameters from a JSON file from one of the pipeline's artifacts
     *
     * The file needs to contain a list of `{ ParameterKey, ParameterValue, UsePreviousValue }` objects, like
     * this:
     *
     * ```
     * [
     *     {
     *         "ParameterKey": "BucketName",
     *         "ParameterValue": "my-bucket"
     *     },
     *     {
     *         "ParameterKey": "Asset1",
     *         "ParameterValue": "true"
     *     },
     *     {
     *         "ParameterKey": "Asset2",
     *         "UsePreviousValue": true
     *     }
     * ]
     * ```
     *
     * You must specify all template parameters. Parameters you don't specify will revert
     * to their `Default` values as specified in the template.
     *
     * For of parameters you want to retain their existing values
     * without specifying what those values are, set `UsePreviousValue: true`.
     * Use of this feature is discouraged. CDK is for
     * specifying desired-state infrastructure, and use of this feature makes the
     * parameter values unmanaged.
     */
    static fromArtifactPath(artifactPath) {
        return new class extends StackSetParameters {
            constructor() {
                super(...arguments);
                this._artifactsReferenced = [artifactPath.artifact];
            }
            _render() {
                return artifactPath.location;
            }
        }();
    }
}
exports.StackSetParameters = StackSetParameters;
_c = JSII_RTTI_SYMBOL_1;
StackSetParameters[_c] = { fqn: "@aws-cdk/aws-codepipeline-actions.StackSetParameters", version: "1.152.0" };
/**
 * Determines how IAM roles are created and managed.
 */
class StackSetDeploymentModel {
    /**
     * Deploy to AWS Organizations accounts.
     *
     * AWS CloudFormation StackSets automatically creates the IAM roles required
     * to deploy to accounts managed by AWS Organizations. This requires an
     * account to be a member of an Organization.
     *
     * Using this deployment model, you can specify either AWS Account Ids or
     * Organization Unit Ids in the `stackInstances` parameter.
     */
    static organizations(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_OrganizationsDeploymentProps(props);
        return new class extends StackSetDeploymentModel {
            _bind() {
                return {
                    stackSetConfiguration: {
                        PermissionModel: 'SERVICE_MANAGED',
                        OrganizationsAutoDeployment: props.autoDeployment,
                    },
                };
            }
        }();
    }
    /**
     * Deploy to AWS Accounts not managed by AWS Organizations
     *
     * You are responsible for creating Execution Roles in every account you will
     * be deploying to in advance to create the actual stack instances. Unless you
     * specify overrides, StackSets expects the execution roles you create to have
     * the default name `AWSCloudFormationStackSetExecutionRole`. See the [Grant
     * self-managed
     * permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html)
     * section of the CloudFormation documentation.
     *
     * The CDK will automatically create the central Administration Role in the
     * Pipeline account which will be used to assume the Execution Role in each of
     * the target accounts.
     *
     * If you wish to use a pre-created Administration Role, use `Role.fromRoleName()`
     * or `Role.fromRoleArn()` to import it, and pass it to this function:
     *
     * ```ts
     * const existingAdminRole = iam.Role.fromRoleName(this, 'AdminRole', 'AWSCloudFormationStackSetAdministrationRole');
     *
     * const deploymentModel = codepipeline_actions.StackSetDeploymentModel.selfManaged({
     *   // Use an existing Role. Leave this out to create a new Role.
     *   administrationRole: existingAdminRole,
     * });
     * ```
     *
     * Using this deployment model, you can only specify AWS Account Ids in the
     * `stackInstances` parameter.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html
     */
    static selfManaged(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_SelfManagedDeploymentProps(props);
        return new class extends StackSetDeploymentModel {
            _bind(scope) {
                var _e;
                let administrationRole = props.administrationRole;
                if (!administrationRole) {
                    administrationRole = new iam.Role(scope, 'StackSetAdministrationRole', {
                        assumedBy: new iam.ServicePrincipal('cloudformation.amazonaws.com', {
                            conditions: {
                                // Confused deputy protection
                                StringLike: {
                                    'aws:SourceArn': `arn:${cdk.Aws.PARTITION}:cloudformation:*:${cdk.Aws.ACCOUNT_ID}:stackset/*`,
                                },
                            },
                        }),
                    });
                    administrationRole.addToPrincipalPolicy(new iam.PolicyStatement({
                        actions: ['sts:AssumeRole'],
                        resources: [`arn:${cdk.Aws.PARTITION}:iam::*:role/${(_e = props.executionRoleName) !== null && _e !== void 0 ? _e : 'AWSCloudFormationStackSetExecutionRole'}`],
                    }));
                }
                return {
                    stackSetConfiguration: {
                        PermissionModel: 'SELF_MANAGED',
                        AdministrationRoleArn: administrationRole.roleArn,
                        ExecutionRoleName: props.executionRoleName,
                    },
                    passedRoles: [administrationRole],
                };
            }
        }();
    }
}
exports.StackSetDeploymentModel = StackSetDeploymentModel;
_d = JSII_RTTI_SYMBOL_1;
StackSetDeploymentModel[_d] = { fqn: "@aws-cdk/aws-codepipeline-actions.StackSetDeploymentModel", version: "1.152.0" };
/**
 * Describes whether AWS CloudFormation StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or
 * organizational unit (OU).
 */
var StackSetOrganizationsAutoDeployment;
(function (StackSetOrganizationsAutoDeployment) {
    /**
     * StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or
     * organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, AWS CloudFormation StackSets
     * deletes stack instances from the account in the specified Regions.
     */
    StackSetOrganizationsAutoDeployment["ENABLED"] = "Enabled";
    /**
     * StackSets does not automatically deploy additional stack instances to AWS Organizations accounts that are added to a target organization or
     * organizational unit (OU) in the specified Regions.
     */
    StackSetOrganizationsAutoDeployment["DISABLED"] = "Disabled";
    /**
     * Stack resources are retained when an account is removed from a target organization or OU.
     */
    StackSetOrganizationsAutoDeployment["ENABLED_WITH_STACK_RETENTION"] = "EnabledWithStackRetention";
})(StackSetOrganizationsAutoDeployment = exports.StackSetOrganizationsAutoDeployment || (exports.StackSetOrganizationsAutoDeployment = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2tzZXQtdHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFja3NldC10eXBlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx3Q0FBd0M7QUFDeEMscUNBQXFDO0FBd0NyQzs7R0FFRztBQUNILE1BQXNCLGdCQUFnQjtJQUNwQzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxZQUF1QztRQUNwRSxPQUFPLElBQUksS0FBTSxTQUFRLGdCQUFnQjtZQUE5Qjs7Z0JBQ08seUJBQW9CLEdBQXlDLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBS3ZHLENBQUM7WUFIUSxPQUFPO2dCQUNaLE9BQU8sWUFBWSxDQUFDLFFBQVEsQ0FBQztZQUMvQixDQUFDO1NBQ0YsRUFBRSxDQUFDO0tBQ0w7O0FBWkgsNENBK0JDOzs7QUFFRDs7R0FFRztBQUNILE1BQXNCLGNBQWM7SUFDbEM7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxRQUFrQixFQUFFLE9BQWlCO1FBQzVELE9BQU8sY0FBYyxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDbkQ7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxNQUFNLENBQUMscUJBQXFCLENBQUMsR0FBYSxFQUFFLE9BQWlCO1FBQ2xFLE9BQU8sY0FBYyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDOUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7O09Ba0JHO0lBQ0ksTUFBTSxDQUFDLGdCQUFnQixDQUFDLFlBQXVDLEVBQUUsT0FBaUI7UUFDdkYsSUFBSSxPQUFPLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUN4QixNQUFNLElBQUksS0FBSyxDQUFDLG9DQUFvQyxDQUFDLENBQUM7U0FDdkQ7UUFFRCxPQUFPLElBQUksS0FBTSxTQUFRLGNBQWM7WUFBNUI7O2dCQUNPLHlCQUFvQixHQUF5QyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztZQVN2RyxDQUFDO1lBUlEsS0FBSyxDQUFDLE1BQWlCO2dCQUM1QixPQUFPO29CQUNMLHFCQUFxQixFQUFFO3dCQUNyQixpQkFBaUIsRUFBRSxZQUFZLENBQUMsUUFBUTt3QkFDeEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO3FCQUMzQjtpQkFDRixDQUFDO1lBQ0osQ0FBQztTQUNGLEVBQUUsQ0FBQztLQUNMO0lBRUQ7Ozs7Ozs7O09BUUc7SUFDSyxNQUFNLENBQUMsUUFBUSxDQUFDLE9BQWlCLEVBQUUsT0FBaUI7UUFDMUQsSUFBSSxPQUFPLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUN4QixNQUFNLElBQUksS0FBSyxDQUFDLG9DQUFvQyxDQUFDLENBQUM7U0FDdkQ7UUFFRCxJQUFJLE9BQU8sQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3hCLE1BQU0sSUFBSSxLQUFLLENBQUMsb0NBQW9DLENBQUMsQ0FBQztTQUN2RDtRQUVELE9BQU8sSUFBSSxLQUFNLFNBQVEsY0FBYztZQUM5QixLQUFLLENBQUMsTUFBaUI7Z0JBQzVCLE9BQU87b0JBQ0wscUJBQXFCLEVBQUU7d0JBQ3JCLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO3dCQUNwQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7cUJBQzNCO2lCQUNGLENBQUM7WUFDSixDQUFDO1NBQ0YsRUFBRSxDQUFDO0tBQ0w7O0FBakdILHdDQXFIQzs7O0FBZ0JEOztHQUVHO0FBQ0gsTUFBc0Isa0JBQWtCO0lBQ3RDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FrQkc7SUFDSSxNQUFNLENBQUMsV0FBVyxDQUFDLFVBQWtDLEVBQUUsaUJBQTRCO1FBQ3hGLE9BQU8sSUFBSSxLQUFNLFNBQVEsa0JBQWtCO1lBQWhDOztnQkFDTyx5QkFBb0IsR0FBNEIsRUFBRSxDQUFDO1lBVXJFLENBQUM7WUFSQyxPQUFPO2dCQUNMLE9BQU87b0JBQ0wsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsQ0FDakQsZ0JBQWdCLEdBQUcsbUJBQW1CLEtBQUssRUFBRSxDQUFDO29CQUNoRCxHQUFHLENBQUMsaUJBQWlCLGFBQWpCLGlCQUFpQixjQUFqQixpQkFBaUIsR0FBSSxFQUFFLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUN2QyxnQkFBZ0IsR0FBRyx3QkFBd0IsQ0FBQztpQkFDL0MsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDZCxDQUFDO1NBQ0YsRUFBRSxDQUFDO0tBQ0w7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQStCRztJQUNJLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxZQUF1QztRQUNwRSxPQUFPLElBQUksS0FBTSxTQUFRLGtCQUFrQjtZQUFoQzs7Z0JBQ0YseUJBQW9CLEdBQTRCLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBS2pGLENBQUM7WUFIUSxPQUFPO2dCQUNaLE9BQU8sWUFBWSxDQUFDLFFBQVEsQ0FBQztZQUMvQixDQUFDO1NBQ0YsRUFBRSxDQUFDO0tBQ0w7O0FBM0VILGdEQTBGQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFzQix1QkFBdUI7SUFDM0M7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxRQUFzQyxFQUFFOztRQUNsRSxPQUFPLElBQUksS0FBTSxTQUFRLHVCQUF1QjtZQUM5QyxLQUFLO2dCQUNILE9BQU87b0JBQ0wscUJBQXFCLEVBQUU7d0JBQ3JCLGVBQWUsRUFBRSxpQkFBaUI7d0JBQ2xDLDJCQUEyQixFQUFFLEtBQUssQ0FBQyxjQUFjO3FCQUNsRDtpQkFDRixDQUFDO1lBQ0osQ0FBQztTQUNGLEVBQUUsQ0FBQztLQUNMO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7T0ErQkc7SUFDSSxNQUFNLENBQUMsV0FBVyxDQUFDLFFBQW9DLEVBQUU7O1FBQzlELE9BQU8sSUFBSSxLQUFNLFNBQVEsdUJBQXVCO1lBQzlDLEtBQUssQ0FBQyxLQUFnQjs7Z0JBQ3BCLElBQUksa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO2dCQUNsRCxJQUFJLENBQUMsa0JBQWtCLEVBQUU7b0JBQ3ZCLGtCQUFrQixHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsNEJBQTRCLEVBQUU7d0JBQ3JFLFNBQVMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyw4QkFBOEIsRUFBRTs0QkFDbEUsVUFBVSxFQUFFO2dDQUNWLDZCQUE2QjtnQ0FDN0IsVUFBVSxFQUFFO29DQUNWLGVBQWUsRUFBRSxPQUFPLEdBQUcsQ0FBQyxHQUFHLENBQUMsU0FBUyxxQkFBcUIsR0FBRyxDQUFDLEdBQUcsQ0FBQyxVQUFVLGFBQWE7aUNBQzlGOzZCQUNGO3lCQUNGLENBQUM7cUJBQ0gsQ0FBQyxDQUFDO29CQUNILGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQzt3QkFDOUQsT0FBTyxFQUFFLENBQUMsZ0JBQWdCLENBQUM7d0JBQzNCLFNBQVMsRUFBRSxDQUFDLE9BQU8sR0FBRyxDQUFDLEdBQUcsQ0FBQyxTQUFTLGdCQUFnQixNQUFBLEtBQUssQ0FBQyxpQkFBaUIsbUNBQUksd0NBQXdDLEVBQUUsQ0FBQztxQkFDM0gsQ0FBQyxDQUFDLENBQUM7aUJBQ0w7Z0JBRUQsT0FBTztvQkFDTCxxQkFBcUIsRUFBRTt3QkFDckIsZUFBZSxFQUFFLGNBQWM7d0JBQy9CLHFCQUFxQixFQUFFLGtCQUFrQixDQUFDLE9BQU87d0JBQ2pELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7cUJBQzNDO29CQUNELFdBQVcsRUFBRSxDQUFDLGtCQUFrQixDQUFDO2lCQUNHLENBQUM7WUFDekMsQ0FBQztTQUNGLEVBQUUsQ0FBQztLQUNMOztBQXZGSCwwREFpR0M7OztBQXVDRDs7O0dBR0c7QUFDSCxJQUFZLG1DQWtCWDtBQWxCRCxXQUFZLG1DQUFtQztJQUM3Qzs7OztPQUlHO0lBQ0gsMERBQW1CLENBQUE7SUFFbkI7OztPQUdHO0lBQ0gsNERBQXFCLENBQUE7SUFFckI7O09BRUc7SUFDSCxpR0FBMEQsQ0FBQTtBQUM1RCxDQUFDLEVBbEJXLG1DQUFtQyxHQUFuQywyQ0FBbUMsS0FBbkMsMkNBQW1DLFFBa0I5QyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tICdAYXdzLWNkay9hd3MtY29kZXBpcGVsaW5lJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIE9wdGlvbnMgaW4gY29tbW9uIGJldHdlZW4gYm90aCBTdGFja1NldCBhY3Rpb25zXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29tbW9uQ2xvdWRGb3JtYXRpb25TdGFja1NldE9wdGlvbnMge1xuXG4gIC8qKlxuICAgKiBUaGUgcGVyY2VudGFnZSBvZiBhY2NvdW50cyBwZXIgUmVnaW9uIGZvciB3aGljaCB0aGlzIHN0YWNrIG9wZXJhdGlvbiBjYW4gZmFpbCBiZWZvcmUgQVdTIENsb3VkRm9ybWF0aW9uIHN0b3BzIHRoZSBvcGVyYXRpb24gaW4gdGhhdCBSZWdpb24uIElmXG4gICAqIHRoZSBvcGVyYXRpb24gaXMgc3RvcHBlZCBpbiBhIFJlZ2lvbiwgQVdTIENsb3VkRm9ybWF0aW9uIGRvZXNuJ3QgYXR0ZW1wdCB0aGUgb3BlcmF0aW9uIGluIHN1YnNlcXVlbnQgUmVnaW9ucy4gV2hlbiBjYWxjdWxhdGluZyB0aGUgbnVtYmVyXG4gICAqIG9mIGFjY291bnRzIGJhc2VkIG9uIHRoZSBzcGVjaWZpZWQgcGVyY2VudGFnZSwgQVdTIENsb3VkRm9ybWF0aW9uIHJvdW5kcyBkb3duIHRvIHRoZSBuZXh0IHdob2xlIG51bWJlci5cbiAgICpcbiAgICogQGRlZmF1bHQgMCVcbiAgICovXG4gIHJlYWRvbmx5IGZhaWx1cmVUb2xlcmFuY2VQZXJjZW50YWdlPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBwZXJjZW50YWdlIG9mIGFjY291bnRzIGluIHdoaWNoIHRvIHBlcmZvcm0gdGhpcyBvcGVyYXRpb24gYXQgb25lIHRpbWUuIFdoZW4gY2FsY3VsYXRpbmcgdGhlIG51bWJlciBvZiBhY2NvdW50cyBiYXNlZCBvbiB0aGUgc3BlY2lmaWVkXG4gICAqIHBlcmNlbnRhZ2UsIEFXUyBDbG91ZEZvcm1hdGlvbiByb3VuZHMgZG93biB0byB0aGUgbmV4dCB3aG9sZSBudW1iZXIuIElmIHJvdW5kaW5nIGRvd24gd291bGQgcmVzdWx0IGluIHplcm8sIEFXUyBDbG91ZEZvcm1hdGlvbiBzZXRzIHRoZSBudW1iZXIgYXNcbiAgICogb25lIGluc3RlYWQuIEFsdGhvdWdoIHlvdSB1c2UgdGhpcyBzZXR0aW5nIHRvIHNwZWNpZnkgdGhlIG1heGltdW0sIGZvciBsYXJnZSBkZXBsb3ltZW50cyB0aGUgYWN0dWFsIG51bWJlciBvZiBhY2NvdW50cyBhY3RlZCB1cG9uIGNvbmN1cnJlbnRseVxuICAgKiBtYXkgYmUgbG93ZXIgZHVlIHRvIHNlcnZpY2UgdGhyb3R0bGluZy5cbiAgICpcbiAgICogQGRlZmF1bHQgMSVcbiAgICovXG4gIHJlYWRvbmx5IG1heEFjY291bnRDb25jdXJyZW5jeVBlcmNlbnRhZ2U/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBBV1MgUmVnaW9uIHRoZSBTdGFja1NldCBpcyBpbi5cbiAgICpcbiAgICogTm90ZSB0aGF0IGEgY3Jvc3MtcmVnaW9uIFBpcGVsaW5lIHJlcXVpcmVzIHJlcGxpY2F0aW9uIGJ1Y2tldHMgdG8gZnVuY3Rpb24gY29ycmVjdGx5LlxuICAgKiBZb3UgY2FuIHByb3ZpZGUgdGhlaXIgbmFtZXMgd2l0aCB0aGUgYFBpcGVsaW5lUHJvcHMuY3Jvc3NSZWdpb25SZXBsaWNhdGlvbkJ1Y2tldHNgIHByb3BlcnR5LlxuICAgKiBJZiB5b3UgZG9uJ3QsIHRoZSBDb2RlUGlwZWxpbmUgQ29uc3RydWN0IHdpbGwgY3JlYXRlIG5ldyBTdGFja3MgaW4geW91ciBDREsgYXBwIGNvbnRhaW5pbmcgdGhvc2UgYnVja2V0cyxcbiAgICogdGhhdCB5b3Ugd2lsbCBuZWVkIHRvIGBjZGsgZGVwbG95YCBiZWZvcmUgZGVwbG95aW5nIHRoZSBtYWluLCBQaXBlbGluZS1jb250YWluaW5nIFN0YWNrLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHNhbWUgcmVnaW9uIGFzIHRoZSBQaXBlbGluZVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhY2tTZXRSZWdpb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogVGhlIHNvdXJjZSBvZiBhIFN0YWNrU2V0IHRlbXBsYXRlXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTdGFja1NldFRlbXBsYXRlIHtcbiAgLyoqXG4gICAqIFVzZSBhIGZpbGUgaW4gYW4gYXJ0aWZhY3QgYXMgU3RhY2sgVGVtcGxhdGUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21BcnRpZmFjdFBhdGgoYXJ0aWZhY3RQYXRoOiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RQYXRoKTogU3RhY2tTZXRUZW1wbGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIFN0YWNrU2V0VGVtcGxhdGUge1xuICAgICAgcHVibGljIHJlYWRvbmx5IF9hcnRpZmFjdHNSZWZlcmVuY2VkPzogY29kZXBpcGVsaW5lLkFydGlmYWN0W10gfCB1bmRlZmluZWQgPSBbYXJ0aWZhY3RQYXRoLmFydGlmYWN0XTtcblxuICAgICAgcHVibGljIF9yZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiBhcnRpZmFjdFBhdGgubG9jYXRpb247XG4gICAgICB9XG4gICAgfSgpO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoaWNoIGFydGlmYWN0cyBhcmUgcmVmZXJlbmNlZCBieSB0aGlzIHRlbXBsYXRlXG4gICAqXG4gICAqIERvZXMgbm90IG5lZWQgdG8gYmUgY2FsbGVkIGJ5IGFwcCBidWlsZGVycy5cbiAgICpcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgX2FydGlmYWN0c1JlZmVyZW5jZWQ/OiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RbXSB8IHVuZGVmaW5lZDtcblxuICAvKipcbiAgICogUmVuZGVyIHRoZSB0ZW1wbGF0ZSB0byB0aGUgcGlwZWxpbmVcbiAgICpcbiAgICogRG9lcyBub3QgbmVlZCB0byBiZSBjYWxsZWQgYnkgYXBwIGJ1aWxkZXJzLlxuICAgKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfcmVuZGVyKCk6IGFueTtcbn1cblxuLyoqXG4gKiBXaGVyZSBTdGFjayBJbnN0YW5jZXMgd2lsbCBiZSBjcmVhdGVkIGZyb20gdGhlIFN0YWNrU2V0XG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTdGFja0luc3RhbmNlcyB7XG4gIC8qKlxuICAgKiBDcmVhdGUgc3RhY2sgaW5zdGFuY2VzIGluIGEgc2V0IG9mIGFjY291bnRzIGFuZCByZWdpb25zIHBhc3NlZCBhcyBsaXRlcmFsIGxpc3RzXG4gICAqXG4gICAqIFN0YWNrIEluc3RhbmNlcyB3aWxsIGJlIGNyZWF0ZWQgaW4gZXZlcnkgY29tYmluYXRpb24gb2YgcmVnaW9uIGFuZCBhY2NvdW50LlxuICAgKlxuICAgKiA+IE5PVEU6IGBTdGFja0luc3RhbmNlcy5pbkFjY291bnRzKClgIGFuZCBgU3RhY2tJbnN0YW5jZXMuaW5Pcmdhbml6YXRpb25hbFVuaXRzKClgXG4gICAqID4gaGF2ZSBleGFjdGx5IHRoZSBzYW1lIGJlaGF2aW9yLCBhbmQgeW91IGNhbiB1c2UgdGhlbSBpbnRlcmNoYW5nZWFibHkgaWYgeW91IHdhbnQuXG4gICAqID4gVGhlIG9ubHkgZGlmZmVyZW5jZSBiZXR3ZWVuIHRoZW0gaXMgdGhhdCB5b3VyIGNvZGUgY2xlYXJseSBpbmRpY2F0ZXMgd2hhdCBlbnRpdHlcbiAgICogPiBpdCdzIHdvcmtpbmcgd2l0aC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgaW5BY2NvdW50cyhhY2NvdW50czogc3RyaW5nW10sIHJlZ2lvbnM6IHN0cmluZ1tdKTogU3RhY2tJbnN0YW5jZXMge1xuICAgIHJldHVybiBTdGFja0luc3RhbmNlcy5mcm9tTGlzdChhY2NvdW50cywgcmVnaW9ucyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlIHN0YWNrIGluc3RhbmNlcyBpbiBhbGwgYWNjb3VudHMgaW4gYSBzZXQgb2YgT3JnYW5pemF0aW9uYWwgVW5pdHMgKE9VcykgYW5kIHJlZ2lvbnMgcGFzc2VkIGFzIGxpdGVyYWwgbGlzdHNcbiAgICpcbiAgICogSWYgeW91IHdhbnQgdG8gZGVwbG95IHRvIE9yZ2FuaXphdGlvbiBVbml0cywgeW91IG11c3QgY2hvb3NlIGhhdmUgY3JlYXRlZCB0aGUgU3RhY2tTZXRcbiAgICogd2l0aCBgZGVwbG95bWVudE1vZGVsOiBEZXBsb3ltZW50TW9kZWwub3JnYW5pemF0aW9ucygpYC5cbiAgICpcbiAgICogU3RhY2sgSW5zdGFuY2VzIHdpbGwgYmUgY3JlYXRlZCBpbiBldmVyeSBjb21iaW5hdGlvbiBvZiByZWdpb24gYW5kIGFjY291bnQuXG4gICAqXG4gICAqID4gTk9URTogYFN0YWNrSW5zdGFuY2VzLmluQWNjb3VudHMoKWAgYW5kIGBTdGFja0luc3RhbmNlcy5pbk9yZ2FuaXphdGlvbmFsVW5pdHMoKWBcbiAgICogPiBoYXZlIGV4YWN0bHkgdGhlIHNhbWUgYmVoYXZpb3IsIGFuZCB5b3UgY2FuIHVzZSB0aGVtIGludGVyY2hhbmdlYWJseSBpZiB5b3Ugd2FudC5cbiAgICogPiBUaGUgb25seSBkaWZmZXJlbmNlIGJldHdlZW4gdGhlbSBpcyB0aGF0IHlvdXIgY29kZSBjbGVhcmx5IGluZGljYXRlcyB3aGF0IGVudGl0eVxuICAgKiA+IGl0J3Mgd29ya2luZyB3aXRoLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBpbk9yZ2FuaXphdGlvbmFsVW5pdHMob3VzOiBzdHJpbmdbXSwgcmVnaW9uczogc3RyaW5nW10pOiBTdGFja0luc3RhbmNlcyB7XG4gICAgcmV0dXJuIFN0YWNrSW5zdGFuY2VzLmZyb21MaXN0KG91cywgcmVnaW9ucyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlIHN0YWNrIGluc3RhbmNlcyBpbiBhIHNldCBvZiBhY2NvdW50cyBvciBvcmdhbml6YXRpb25hbCB1bml0cyB0YWtlbiBmcm9tIHRoZSBwaXBlbGluZSBhcnRpZmFjdHMsIGFuZCBhIHNldCBvZiByZWdpb25zXG4gICAqXG4gICAqIFRoZSBmaWxlIG11c3QgYmUgYSBKU09OIGZpbGUgY29udGFpbmluZyBhIGxpc3Qgb2Ygc3RyaW5ncy4gRm9yIGV4YW1wbGU6XG4gICAqXG4gICAqIGBgYGpzb25cbiAgICogW1xuICAgKiAgIFwiMTExMTExMTExMTExXCIsXG4gICAqICAgXCIyMjIyMjIyMjIyMjJcIixcbiAgICogICBcIjMzMzMzMzMzMzMzM1wiXG4gICAqIF1cbiAgICogYGBgXG4gICAqXG4gICAqIFN0YWNrIEluc3RhbmNlcyB3aWxsIGJlIGNyZWF0ZWQgaW4gZXZlcnkgY29tYmluYXRpb24gb2YgcmVnaW9uIGFuZCBhY2NvdW50LCBvciByZWdpb24gYW5kXG4gICAqIE9yZ2FuaXphdGlvbmFsIFVuaXRzIChPVXMpLlxuICAgKlxuICAgKiBJZiB0aGlzIGlzIHNldCBvZiBPcmdhbml6YXRpb25hbCBVbml0cywgeW91IG11c3QgaGF2ZSBzZWxlY3RlZCBgU3RhY2tTZXREZXBsb3ltZW50TW9kZWwub3JnYW5pemF0aW9ucygpYFxuICAgKiBhcyBkZXBsb3ltZW50IG1vZGVsLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQXJ0aWZhY3RQYXRoKGFydGlmYWN0UGF0aDogY29kZXBpcGVsaW5lLkFydGlmYWN0UGF0aCwgcmVnaW9uczogc3RyaW5nW10pOiBTdGFja0luc3RhbmNlcyB7XG4gICAgaWYgKHJlZ2lvbnMubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXCIncmVnaW9ucycgbWF5IG5vdCBiZSBhbiBlbXB0eSBsaXN0XCIpO1xuICAgIH1cblxuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBTdGFja0luc3RhbmNlcyB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgX2FydGlmYWN0c1JlZmVyZW5jZWQ/OiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RbXSB8IHVuZGVmaW5lZCA9IFthcnRpZmFjdFBhdGguYXJ0aWZhY3RdO1xuICAgICAgcHVibGljIF9iaW5kKF9zY29wZTogQ29uc3RydWN0KTogU3RhY2tJbnN0YW5jZXNCaW5kUmVzdWx0IHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBzdGFja1NldENvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICAgIERlcGxveW1lbnRUYXJnZXRzOiBhcnRpZmFjdFBhdGgubG9jYXRpb24sXG4gICAgICAgICAgICBSZWdpb25zOiByZWdpb25zLmpvaW4oJywnKSxcbiAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgICAgfVxuICAgIH0oKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGUgc3RhY2sgaW5zdGFuY2VzIGluIGEgbGl0ZXJhbCBzZXQgb2YgYWNjb3VudHMgb3Igb3JnYW5pemF0aW9uYWwgdW5pdHMsIGFuZCBhIHNldCBvZiByZWdpb25zXG4gICAqXG4gICAqIFN0YWNrIEluc3RhbmNlcyB3aWxsIGJlIGNyZWF0ZWQgaW4gZXZlcnkgY29tYmluYXRpb24gb2YgcmVnaW9uIGFuZCBhY2NvdW50LCBvciByZWdpb24gYW5kXG4gICAqIE9yZ2FuaXphdGlvbmFsIFVuaXRzIChPVXMpLlxuICAgKlxuICAgKiBJZiB0aGlzIGlzIHNldCBvZiBPcmdhbml6YXRpb25hbCBVbml0cywgeW91IG11c3QgaGF2ZSBzZWxlY3RlZCBgU3RhY2tTZXREZXBsb3ltZW50TW9kZWwub3JnYW5pemF0aW9ucygpYFxuICAgKiBhcyBkZXBsb3ltZW50IG1vZGVsLlxuICAgKi9cbiAgcHJpdmF0ZSBzdGF0aWMgZnJvbUxpc3QodGFyZ2V0czogc3RyaW5nW10sIHJlZ2lvbnM6IHN0cmluZ1tdKTogU3RhY2tJbnN0YW5jZXMge1xuICAgIGlmICh0YXJnZXRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFwiJ3RhcmdldHMnIG1heSBub3QgYmUgYW4gZW1wdHkgbGlzdFwiKTtcbiAgICB9XG5cbiAgICBpZiAocmVnaW9ucy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcIidyZWdpb25zJyBtYXkgbm90IGJlIGFuIGVtcHR5IGxpc3RcIik7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIFN0YWNrSW5zdGFuY2VzIHtcbiAgICAgIHB1YmxpYyBfYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFN0YWNrSW5zdGFuY2VzQmluZFJlc3VsdCB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgc3RhY2tTZXRDb25maWd1cmF0aW9uOiB7XG4gICAgICAgICAgICBEZXBsb3ltZW50VGFyZ2V0czogdGFyZ2V0cy5qb2luKCcsJyksXG4gICAgICAgICAgICBSZWdpb25zOiByZWdpb25zLmpvaW4oJywnKSxcbiAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgICAgfVxuICAgIH0oKTtcbiAgfVxuXG5cbiAgLyoqXG4gICAqIFRoZSBhcnRpZmFjdHMgcmVmZXJlbmNlZCBieSB0aGUgcHJvcGVydGllcyBvZiB0aGlzIGRlcGxveW1lbnQgdGFyZ2V0XG4gICAqXG4gICAqIERvZXMgbm90IG5lZWQgdG8gYmUgY2FsbGVkIGJ5IGFwcCBidWlsZGVycy5cbiAgICpcbiAgICogQGludGVybmFsXG4gICAqL1xuICByZWFkb25seSBfYXJ0aWZhY3RzUmVmZXJlbmNlZD86IGNvZGVwaXBlbGluZS5BcnRpZmFjdFtdO1xuXG4gIC8qKlxuICAgKiBDYWxsZWQgdG8gYXR0YWNoIHRoZSBzdGFjayBzZXQgaW5zdGFuY2VzIHRvIGEgc3RhY2tzZXQgYWN0aW9uXG4gICAqXG4gICAqIERvZXMgbm90IG5lZWQgdG8gYmUgY2FsbGVkIGJ5IGFwcCBidWlsZGVycy5cbiAgICpcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgX2JpbmQoc2NvcGU6IENvbnN0cnVjdCk6IFN0YWNrSW5zdGFuY2VzQmluZFJlc3VsdDtcbn1cblxuLyoqXG4gKiBSZXR1cm5lZCBieSB0aGUgU3RhY2tJbnN0YW5jZXMuYmluZCgpIGZ1bmN0aW9uXG4gKlxuICogRG9lcyBub3QgbmVlZCB0byBiZSB1c2VkIGJ5IGFwcCBidWlsZGVycy5cbiAqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdGFja0luc3RhbmNlc0JpbmRSZXN1bHQge1xuICAvKipcbiAgICogUHJvcGVydGllcyB0byBtaXggaW50byB0aGUgQWN0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHN0YWNrU2V0Q29uZmlndXJhdGlvbjogYW55O1xufVxuXG4vKipcbiAqIEJhc2UgcGFyYW1ldGVycyBmb3IgdGhlIFN0YWNrU2V0XG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTdGFja1NldFBhcmFtZXRlcnMge1xuICAvKipcbiAgICogQSBsaXN0IG9mIHRlbXBsYXRlIHBhcmFtZXRlcnMgZm9yIHlvdXIgc3RhY2sgc2V0LlxuICAgKlxuICAgKiBZb3UgbXVzdCBzcGVjaWZ5IGFsbCB0ZW1wbGF0ZSBwYXJhbWV0ZXJzLiBQYXJhbWV0ZXJzIHlvdSBkb24ndCBzcGVjaWZ5IHdpbGwgcmV2ZXJ0XG4gICAqIHRvIHRoZWlyIGBEZWZhdWx0YCB2YWx1ZXMgYXMgc3BlY2lmaWVkIGluIHRoZSB0ZW1wbGF0ZS5cbiAgICpcbiAgICogU3BlY2lmeSB0aGUgbmFtZXMgb2YgcGFyYW1ldGVycyB5b3Ugd2FudCB0byByZXRhaW4gdGhlaXIgZXhpc3RpbmcgdmFsdWVzLFxuICAgKiB3aXRob3V0IHNwZWNpZnlpbmcgd2hhdCB0aG9zZSB2YWx1ZXMgYXJlLCBpbiBhbiBhcnJheSBpbiB0aGUgc2Vjb25kXG4gICAqIGFyZ3VtZW50IHRvIHRoaXMgZnVuY3Rpb24uIFVzZSBvZiB0aGlzIGZlYXR1cmUgaXMgZGlzY291cmFnZWQuIENESyBpcyBmb3JcbiAgICogc3BlY2lmeWluZyBkZXNpcmVkLXN0YXRlIGluZnJhc3RydWN0dXJlLCBhbmQgdXNlIG9mIHRoaXMgZmVhdHVyZSBtYWtlcyB0aGVcbiAgICogcGFyYW1ldGVyIHZhbHVlcyB1bm1hbmFnZWQuXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqXG4gICAqIGNvbnN0IHBhcmFtZXRlcnMgPSBjb2RlcGlwZWxpbmVfYWN0aW9ucy5TdGFja1NldFBhcmFtZXRlcnMuZnJvbUxpdGVyYWwoe1xuICAgKiAgQnVja2V0TmFtZTogJ215LWJ1Y2tldCcsXG4gICAqICBBc3NldDE6ICd0cnVlJyxcbiAgICogfSk7XG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21MaXRlcmFsKHBhcmFtZXRlcnM6IFJlY29yZDxzdHJpbmcsIHN0cmluZz4sIHVzZVByZXZpb3VzVmFsdWVzPzogc3RyaW5nW10pOiBTdGFja1NldFBhcmFtZXRlcnMge1xuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBTdGFja1NldFBhcmFtZXRlcnMge1xuICAgICAgcHVibGljIHJlYWRvbmx5IF9hcnRpZmFjdHNSZWZlcmVuY2VkOiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RbXSA9IFtdO1xuXG4gICAgICBfcmVuZGVyKCk6IHN0cmluZyB7XG4gICAgICAgIHJldHVybiBbXG4gICAgICAgICAgLi4uT2JqZWN0LmVudHJpZXMocGFyYW1ldGVycykubWFwKChba2V5LCB2YWx1ZV0pID0+XG4gICAgICAgICAgICBgUGFyYW1ldGVyS2V5PSR7a2V5fSxQYXJhbWV0ZXJWYWx1ZT0ke3ZhbHVlfWApLFxuICAgICAgICAgIC4uLih1c2VQcmV2aW91c1ZhbHVlcyA/PyBbXSkubWFwKChrZXkpID0+XG4gICAgICAgICAgICBgUGFyYW1ldGVyS2V5PSR7a2V5fSxVc2VQcmV2aW91c1ZhbHVlPXRydWVgKSxcbiAgICAgICAgXS5qb2luKCcgJyk7XG4gICAgICB9XG4gICAgfSgpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlYWQgdGhlIHBhcmFtZXRlcnMgZnJvbSBhIEpTT04gZmlsZSBmcm9tIG9uZSBvZiB0aGUgcGlwZWxpbmUncyBhcnRpZmFjdHNcbiAgICpcbiAgICogVGhlIGZpbGUgbmVlZHMgdG8gY29udGFpbiBhIGxpc3Qgb2YgYHsgUGFyYW1ldGVyS2V5LCBQYXJhbWV0ZXJWYWx1ZSwgVXNlUHJldmlvdXNWYWx1ZSB9YCBvYmplY3RzLCBsaWtlXG4gICAqIHRoaXM6XG4gICAqXG4gICAqIGBgYFxuICAgKiBbXG4gICAqICAgICB7XG4gICAqICAgICAgICAgXCJQYXJhbWV0ZXJLZXlcIjogXCJCdWNrZXROYW1lXCIsXG4gICAqICAgICAgICAgXCJQYXJhbWV0ZXJWYWx1ZVwiOiBcIm15LWJ1Y2tldFwiXG4gICAqICAgICB9LFxuICAgKiAgICAge1xuICAgKiAgICAgICAgIFwiUGFyYW1ldGVyS2V5XCI6IFwiQXNzZXQxXCIsXG4gICAqICAgICAgICAgXCJQYXJhbWV0ZXJWYWx1ZVwiOiBcInRydWVcIlxuICAgKiAgICAgfSxcbiAgICogICAgIHtcbiAgICogICAgICAgICBcIlBhcmFtZXRlcktleVwiOiBcIkFzc2V0MlwiLFxuICAgKiAgICAgICAgIFwiVXNlUHJldmlvdXNWYWx1ZVwiOiB0cnVlXG4gICAqICAgICB9XG4gICAqIF1cbiAgICogYGBgXG4gICAqXG4gICAqIFlvdSBtdXN0IHNwZWNpZnkgYWxsIHRlbXBsYXRlIHBhcmFtZXRlcnMuIFBhcmFtZXRlcnMgeW91IGRvbid0IHNwZWNpZnkgd2lsbCByZXZlcnRcbiAgICogdG8gdGhlaXIgYERlZmF1bHRgIHZhbHVlcyBhcyBzcGVjaWZpZWQgaW4gdGhlIHRlbXBsYXRlLlxuICAgKlxuICAgKiBGb3Igb2YgcGFyYW1ldGVycyB5b3Ugd2FudCB0byByZXRhaW4gdGhlaXIgZXhpc3RpbmcgdmFsdWVzXG4gICAqIHdpdGhvdXQgc3BlY2lmeWluZyB3aGF0IHRob3NlIHZhbHVlcyBhcmUsIHNldCBgVXNlUHJldmlvdXNWYWx1ZTogdHJ1ZWAuXG4gICAqIFVzZSBvZiB0aGlzIGZlYXR1cmUgaXMgZGlzY291cmFnZWQuIENESyBpcyBmb3JcbiAgICogc3BlY2lmeWluZyBkZXNpcmVkLXN0YXRlIGluZnJhc3RydWN0dXJlLCBhbmQgdXNlIG9mIHRoaXMgZmVhdHVyZSBtYWtlcyB0aGVcbiAgICogcGFyYW1ldGVyIHZhbHVlcyB1bm1hbmFnZWQuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21BcnRpZmFjdFBhdGgoYXJ0aWZhY3RQYXRoOiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RQYXRoKTogU3RhY2tTZXRQYXJhbWV0ZXJzIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgU3RhY2tTZXRQYXJhbWV0ZXJzIHtcbiAgICAgIHB1YmxpYyBfYXJ0aWZhY3RzUmVmZXJlbmNlZDogY29kZXBpcGVsaW5lLkFydGlmYWN0W10gPSBbYXJ0aWZhY3RQYXRoLmFydGlmYWN0XTtcblxuICAgICAgcHVibGljIF9yZW5kZXIoKTogc3RyaW5nIHtcbiAgICAgICAgcmV0dXJuIGFydGlmYWN0UGF0aC5sb2NhdGlvbjtcbiAgICAgIH1cbiAgICB9KCk7XG4gIH1cblxuICAvKipcbiAgICogQXJ0aWZhY3RzIHJlZmVyZW5jZWQgYnkgdGhpcyBwYXJhbWV0ZXIgc2V0XG4gICAqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IF9hcnRpZmFjdHNSZWZlcmVuY2VkOiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RbXTtcblxuICAvKipcbiAgICogQ29udmVydHMgUGFyYW1ldGVycyB0byBhIHN0cmluZy5cbiAgICpcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgX3JlbmRlcigpOiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lcyBob3cgSUFNIHJvbGVzIGFyZSBjcmVhdGVkIGFuZCBtYW5hZ2VkLlxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgU3RhY2tTZXREZXBsb3ltZW50TW9kZWwge1xuICAvKipcbiAgICogRGVwbG95IHRvIEFXUyBPcmdhbml6YXRpb25zIGFjY291bnRzLlxuICAgKlxuICAgKiBBV1MgQ2xvdWRGb3JtYXRpb24gU3RhY2tTZXRzIGF1dG9tYXRpY2FsbHkgY3JlYXRlcyB0aGUgSUFNIHJvbGVzIHJlcXVpcmVkXG4gICAqIHRvIGRlcGxveSB0byBhY2NvdW50cyBtYW5hZ2VkIGJ5IEFXUyBPcmdhbml6YXRpb25zLiBUaGlzIHJlcXVpcmVzIGFuXG4gICAqIGFjY291bnQgdG8gYmUgYSBtZW1iZXIgb2YgYW4gT3JnYW5pemF0aW9uLlxuICAgKlxuICAgKiBVc2luZyB0aGlzIGRlcGxveW1lbnQgbW9kZWwsIHlvdSBjYW4gc3BlY2lmeSBlaXRoZXIgQVdTIEFjY291bnQgSWRzIG9yXG4gICAqIE9yZ2FuaXphdGlvbiBVbml0IElkcyBpbiB0aGUgYHN0YWNrSW5zdGFuY2VzYCBwYXJhbWV0ZXIuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG9yZ2FuaXphdGlvbnMocHJvcHM6IE9yZ2FuaXphdGlvbnNEZXBsb3ltZW50UHJvcHMgPSB7fSk6IFN0YWNrU2V0RGVwbG95bWVudE1vZGVsIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgU3RhY2tTZXREZXBsb3ltZW50TW9kZWwge1xuICAgICAgX2JpbmQoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgc3RhY2tTZXRDb25maWd1cmF0aW9uOiB7XG4gICAgICAgICAgICBQZXJtaXNzaW9uTW9kZWw6ICdTRVJWSUNFX01BTkFHRUQnLFxuICAgICAgICAgICAgT3JnYW5pemF0aW9uc0F1dG9EZXBsb3ltZW50OiBwcm9wcy5hdXRvRGVwbG95bWVudCxcbiAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgICAgfVxuICAgIH0oKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXBsb3kgdG8gQVdTIEFjY291bnRzIG5vdCBtYW5hZ2VkIGJ5IEFXUyBPcmdhbml6YXRpb25zXG4gICAqXG4gICAqIFlvdSBhcmUgcmVzcG9uc2libGUgZm9yIGNyZWF0aW5nIEV4ZWN1dGlvbiBSb2xlcyBpbiBldmVyeSBhY2NvdW50IHlvdSB3aWxsXG4gICAqIGJlIGRlcGxveWluZyB0byBpbiBhZHZhbmNlIHRvIGNyZWF0ZSB0aGUgYWN0dWFsIHN0YWNrIGluc3RhbmNlcy4gVW5sZXNzIHlvdVxuICAgKiBzcGVjaWZ5IG92ZXJyaWRlcywgU3RhY2tTZXRzIGV4cGVjdHMgdGhlIGV4ZWN1dGlvbiByb2xlcyB5b3UgY3JlYXRlIHRvIGhhdmVcbiAgICogdGhlIGRlZmF1bHQgbmFtZSBgQVdTQ2xvdWRGb3JtYXRpb25TdGFja1NldEV4ZWN1dGlvblJvbGVgLiBTZWUgdGhlIFtHcmFudFxuICAgKiBzZWxmLW1hbmFnZWRcbiAgICogcGVybWlzc2lvbnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL3N0YWNrc2V0cy1wcmVyZXFzLXNlbGYtbWFuYWdlZC5odG1sKVxuICAgKiBzZWN0aW9uIG9mIHRoZSBDbG91ZEZvcm1hdGlvbiBkb2N1bWVudGF0aW9uLlxuICAgKlxuICAgKiBUaGUgQ0RLIHdpbGwgYXV0b21hdGljYWxseSBjcmVhdGUgdGhlIGNlbnRyYWwgQWRtaW5pc3RyYXRpb24gUm9sZSBpbiB0aGVcbiAgICogUGlwZWxpbmUgYWNjb3VudCB3aGljaCB3aWxsIGJlIHVzZWQgdG8gYXNzdW1lIHRoZSBFeGVjdXRpb24gUm9sZSBpbiBlYWNoIG9mXG4gICAqIHRoZSB0YXJnZXQgYWNjb3VudHMuXG4gICAqXG4gICAqIElmIHlvdSB3aXNoIHRvIHVzZSBhIHByZS1jcmVhdGVkIEFkbWluaXN0cmF0aW9uIFJvbGUsIHVzZSBgUm9sZS5mcm9tUm9sZU5hbWUoKWBcbiAgICogb3IgYFJvbGUuZnJvbVJvbGVBcm4oKWAgdG8gaW1wb3J0IGl0LCBhbmQgcGFzcyBpdCB0byB0aGlzIGZ1bmN0aW9uOlxuICAgKlxuICAgKiBgYGB0c1xuICAgKiBjb25zdCBleGlzdGluZ0FkbWluUm9sZSA9IGlhbS5Sb2xlLmZyb21Sb2xlTmFtZSh0aGlzLCAnQWRtaW5Sb2xlJywgJ0FXU0Nsb3VkRm9ybWF0aW9uU3RhY2tTZXRBZG1pbmlzdHJhdGlvblJvbGUnKTtcbiAgICpcbiAgICogY29uc3QgZGVwbG95bWVudE1vZGVsID0gY29kZXBpcGVsaW5lX2FjdGlvbnMuU3RhY2tTZXREZXBsb3ltZW50TW9kZWwuc2VsZk1hbmFnZWQoe1xuICAgKiAgIC8vIFVzZSBhbiBleGlzdGluZyBSb2xlLiBMZWF2ZSB0aGlzIG91dCB0byBjcmVhdGUgYSBuZXcgUm9sZS5cbiAgICogICBhZG1pbmlzdHJhdGlvblJvbGU6IGV4aXN0aW5nQWRtaW5Sb2xlLFxuICAgKiB9KTtcbiAgICogYGBgXG4gICAqXG4gICAqIFVzaW5nIHRoaXMgZGVwbG95bWVudCBtb2RlbCwgeW91IGNhbiBvbmx5IHNwZWNpZnkgQVdTIEFjY291bnQgSWRzIGluIHRoZVxuICAgKiBgc3RhY2tJbnN0YW5jZXNgIHBhcmFtZXRlci5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9zdGFja3NldHMtcHJlcmVxcy1zZWxmLW1hbmFnZWQuaHRtbFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBzZWxmTWFuYWdlZChwcm9wczogU2VsZk1hbmFnZWREZXBsb3ltZW50UHJvcHMgPSB7fSk6IFN0YWNrU2V0RGVwbG95bWVudE1vZGVsIHtcbiAgICByZXR1cm4gbmV3IGNsYXNzIGV4dGVuZHMgU3RhY2tTZXREZXBsb3ltZW50TW9kZWwge1xuICAgICAgX2JpbmQoc2NvcGU6IENvbnN0cnVjdCkge1xuICAgICAgICBsZXQgYWRtaW5pc3RyYXRpb25Sb2xlID0gcHJvcHMuYWRtaW5pc3RyYXRpb25Sb2xlO1xuICAgICAgICBpZiAoIWFkbWluaXN0cmF0aW9uUm9sZSkge1xuICAgICAgICAgIGFkbWluaXN0cmF0aW9uUm9sZSA9IG5ldyBpYW0uUm9sZShzY29wZSwgJ1N0YWNrU2V0QWRtaW5pc3RyYXRpb25Sb2xlJywge1xuICAgICAgICAgICAgYXNzdW1lZEJ5OiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2Nsb3VkZm9ybWF0aW9uLmFtYXpvbmF3cy5jb20nLCB7XG4gICAgICAgICAgICAgIGNvbmRpdGlvbnM6IHtcbiAgICAgICAgICAgICAgICAvLyBDb25mdXNlZCBkZXB1dHkgcHJvdGVjdGlvblxuICAgICAgICAgICAgICAgIFN0cmluZ0xpa2U6IHtcbiAgICAgICAgICAgICAgICAgICdhd3M6U291cmNlQXJuJzogYGFybjoke2Nkay5Bd3MuUEFSVElUSU9OfTpjbG91ZGZvcm1hdGlvbjoqOiR7Y2RrLkF3cy5BQ0NPVU5UX0lEfTpzdGFja3NldC8qYCxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgfSk7XG4gICAgICAgICAgYWRtaW5pc3RyYXRpb25Sb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgIGFjdGlvbnM6IFsnc3RzOkFzc3VtZVJvbGUnXSxcbiAgICAgICAgICAgIHJlc291cmNlczogW2Bhcm46JHtjZGsuQXdzLlBBUlRJVElPTn06aWFtOjoqOnJvbGUvJHtwcm9wcy5leGVjdXRpb25Sb2xlTmFtZSA/PyAnQVdTQ2xvdWRGb3JtYXRpb25TdGFja1NldEV4ZWN1dGlvblJvbGUnfWBdLFxuICAgICAgICAgIH0pKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgc3RhY2tTZXRDb25maWd1cmF0aW9uOiB7XG4gICAgICAgICAgICBQZXJtaXNzaW9uTW9kZWw6ICdTRUxGX01BTkFHRUQnLFxuICAgICAgICAgICAgQWRtaW5pc3RyYXRpb25Sb2xlQXJuOiBhZG1pbmlzdHJhdGlvblJvbGUucm9sZUFybixcbiAgICAgICAgICAgIEV4ZWN1dGlvblJvbGVOYW1lOiBwcm9wcy5leGVjdXRpb25Sb2xlTmFtZSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHBhc3NlZFJvbGVzOiBbYWRtaW5pc3RyYXRpb25Sb2xlXSxcbiAgICAgICAgfSBhcyBTdGFja1NldERlcGxveW1lbnRNb2RlbEJpbmRSZXN1bHQ7XG4gICAgICB9XG4gICAgfSgpO1xuICB9XG5cbiAgLyoqXG4gICAqIEJpbmQgdG8gdGhlIFN0YWNrIFNldCBhY3Rpb24gYW5kIHJldHVybiB0aGUgQWN0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogRG9lcyBub3QgbmVlZCB0byBiZSBjYWxsZWQgYnkgYXBwIGJ1aWxkZXJzLlxuICAgKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfYmluZChzY29wZTogQ29uc3RydWN0KTogU3RhY2tTZXREZXBsb3ltZW50TW9kZWxCaW5kUmVzdWx0O1xufVxuXG4vKipcbiAqIFJldHVybmVkIGJ5IHRoZSBTdGFja1NldERlcGxveW1lbnRNb2RlbC5iaW5kKCkgZnVuY3Rpb25cbiAqXG4gKiBEb2VzIG5vdCBuZWVkIHRvIGJlIHVzZWQgYnkgYXBwIGJ1aWxkZXJzLlxuICpcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0YWNrU2V0RGVwbG95bWVudE1vZGVsQmluZFJlc3VsdCB7XG4gIC8qKlxuICAgKiBQcm9wZXJ0aWVzIHRvIG1peCBpbnRvIHRoZSBBY3Rpb24gY29uZmlndXJhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgc3RhY2tTZXRDb25maWd1cmF0aW9uOiBhbnk7XG5cbiAgLyoqXG4gICAqIFJvbGVzIHRoYXQgbmVlZCB0byBiZSBwYXNzZWQgYnkgdGhlIHBpcGVsaW5lIGFjdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIHJvbGVzXG4gICAqL1xuICByZWFkb25seSBwYXNzZWRSb2xlcz86IGlhbS5JUm9sZVtdO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGNvbmZpZ3VyaW5nIHNlcnZpY2UtbWFuYWdlZCAoT3JnYW5pemF0aW9ucykgcGVybWlzc2lvbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPcmdhbml6YXRpb25zRGVwbG95bWVudFByb3BzIHtcbiAgLyoqXG4gICAqIEF1dG9tYXRpY2FsbHkgZGVwbG95IHRvIG5ldyBhY2NvdW50cyBhZGRlZCB0byBPcmdhbml6YXRpb25hbCBVbml0c1xuICAgKlxuICAgKiBXaGV0aGVyIEFXUyBDbG91ZEZvcm1hdGlvbiBTdGFja1NldHMgYXV0b21hdGljYWxseSBkZXBsb3lzIHRvIEFXU1xuICAgKiBPcmdhbml6YXRpb25zIGFjY291bnRzIHRoYXQgYXJlIGFkZGVkIHRvIGEgdGFyZ2V0IG9yZ2FuaXphdGlvbiBvclxuICAgKiBvcmdhbml6YXRpb25hbCB1bml0IChPVSkuXG4gICAqXG4gICAqIEBkZWZhdWx0IERpc2FibGVkXG4gICAqL1xuICByZWFkb25seSBhdXRvRGVwbG95bWVudD86IFN0YWNrU2V0T3JnYW5pemF0aW9uc0F1dG9EZXBsb3ltZW50O1xufVxuXG4vKipcbiAqIERlc2NyaWJlcyB3aGV0aGVyIEFXUyBDbG91ZEZvcm1hdGlvbiBTdGFja1NldHMgYXV0b21hdGljYWxseSBkZXBsb3lzIHRvIEFXUyBPcmdhbml6YXRpb25zIGFjY291bnRzIHRoYXQgYXJlIGFkZGVkIHRvIGEgdGFyZ2V0IG9yZ2FuaXphdGlvbiBvclxuICogb3JnYW5pemF0aW9uYWwgdW5pdCAoT1UpLlxuICovXG5leHBvcnQgZW51bSBTdGFja1NldE9yZ2FuaXphdGlvbnNBdXRvRGVwbG95bWVudCB7XG4gIC8qKlxuICAgKiBTdGFja1NldHMgYXV0b21hdGljYWxseSBkZXBsb3lzIGFkZGl0aW9uYWwgc3RhY2sgaW5zdGFuY2VzIHRvIEFXUyBPcmdhbml6YXRpb25zIGFjY291bnRzIHRoYXQgYXJlIGFkZGVkIHRvIGEgdGFyZ2V0IG9yZ2FuaXphdGlvbiBvclxuICAgKiBvcmdhbml6YXRpb25hbCB1bml0IChPVSkgaW4gdGhlIHNwZWNpZmllZCBSZWdpb25zLiBJZiBhbiBhY2NvdW50IGlzIHJlbW92ZWQgZnJvbSBhIHRhcmdldCBvcmdhbml6YXRpb24gb3IgT1UsIEFXUyBDbG91ZEZvcm1hdGlvbiBTdGFja1NldHNcbiAgICogZGVsZXRlcyBzdGFjayBpbnN0YW5jZXMgZnJvbSB0aGUgYWNjb3VudCBpbiB0aGUgc3BlY2lmaWVkIFJlZ2lvbnMuXG4gICAqL1xuICBFTkFCTEVEID0gJ0VuYWJsZWQnLFxuXG4gIC8qKlxuICAgKiBTdGFja1NldHMgZG9lcyBub3QgYXV0b21hdGljYWxseSBkZXBsb3kgYWRkaXRpb25hbCBzdGFjayBpbnN0YW5jZXMgdG8gQVdTIE9yZ2FuaXphdGlvbnMgYWNjb3VudHMgdGhhdCBhcmUgYWRkZWQgdG8gYSB0YXJnZXQgb3JnYW5pemF0aW9uIG9yXG4gICAqIG9yZ2FuaXphdGlvbmFsIHVuaXQgKE9VKSBpbiB0aGUgc3BlY2lmaWVkIFJlZ2lvbnMuXG4gICAqL1xuICBESVNBQkxFRCA9ICdEaXNhYmxlZCcsXG5cbiAgLyoqXG4gICAqIFN0YWNrIHJlc291cmNlcyBhcmUgcmV0YWluZWQgd2hlbiBhbiBhY2NvdW50IGlzIHJlbW92ZWQgZnJvbSBhIHRhcmdldCBvcmdhbml6YXRpb24gb3IgT1UuXG4gICAqL1xuICBFTkFCTEVEX1dJVEhfU1RBQ0tfUkVURU5USU9OID0gJ0VuYWJsZWRXaXRoU3RhY2tSZXRlbnRpb24nXG59XG5cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBjb25maWd1cmluZyBzZWxmLW1hbmFnZWQgcGVybWlzc2lvbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZWxmTWFuYWdlZERlcGxveW1lbnRQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgSUFNIHJvbGUgaW4gdGhlIGFkbWluaXN0cmF0b3IgYWNjb3VudCB1c2VkIHRvIGFzc3VtZSBleGVjdXRpb24gcm9sZXMgaW4gdGhlIHRhcmdldCBhY2NvdW50c1xuICAgKlxuICAgKiBZb3UgbXVzdCBjcmVhdGUgdGhpcyByb2xlIGJlZm9yZSB1c2luZyB0aGUgU3RhY2tTZXQgYWN0aW9uLlxuICAgKlxuICAgKiBUaGUgcm9sZSBuZWVkcyB0byBiZSBhc3N1bWFibGUgYnkgQ2xvdWRGb3JtYXRpb24sIGFuZCBpdCBuZWVkcyB0byBiZSBhYmxlXG4gICAqIHRvIGBzdHM6QXNzdW1lUm9sZWAgZWFjaCBvZiB0aGUgZXhlY3V0aW9uIHJvbGVzICh3aG9zZSBuYW1lcyBhcmUgc3BlY2lmaWVkXG4gICAqIGluIHRoZSBgZXhlY3V0aW9uUm9sZU5hbWVgIHBhcmFtZXRlcikgaW4gZWFjaCBvZiB0aGUgdGFyZ2V0IGFjY291bnRzLlxuICAgKlxuICAgKiBJZiB5b3UgZG8gbm90IHNwZWNpZnkgdGhlIHJvbGUsIHdlIGFzc3VtZSB5b3UgaGF2ZSBjcmVhdGVkIGEgcm9sZSBuYW1lZFxuICAgKiBgQVdTQ2xvdWRGb3JtYXRpb25TdGFja1NldEFkbWluaXN0cmF0aW9uUm9sZWAuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQXNzdW1lIGFuIGV4aXN0aW5nIHJvbGUgbmFtZWQgYEFXU0Nsb3VkRm9ybWF0aW9uU3RhY2tTZXRBZG1pbmlzdHJhdGlvblJvbGVgIGluIHRoZSBzYW1lIGFjY291bnQgYXMgdGhlIHBpcGVsaW5lLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL3N0YWNrc2V0cy1wcmVyZXFzLXNlbGYtbWFuYWdlZC5odG1sXG4gICAqL1xuICByZWFkb25seSBhZG1pbmlzdHJhdGlvblJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBJQU0gcm9sZSBpbiB0aGUgdGFyZ2V0IGFjY291bnRzIHVzZWQgdG8gcGVyZm9ybSBzdGFjayBzZXQgb3BlcmF0aW9ucy5cbiAgICpcbiAgICogWW91IG11c3QgY3JlYXRlIHRoZXNlIHJvbGVzIGluIGVhY2ggb2YgdGhlIHRhcmdldCBhY2NvdW50cyBiZWZvcmUgdXNpbmcgdGhlXG4gICAqIFN0YWNrU2V0IGFjdGlvbi5cbiAgICpcbiAgICogVGhlIHJvbGVzIG5lZWQgdG8gYmUgYXNzdW1hYmxlIGJ5IGJ5IHRoZSBgYWRtaW5pc3RyYXRpb25Sb2xlYCwgYW5kIG5lZWQgdG9cbiAgICogaGF2ZSB0aGUgcGVybWlzc2lvbnMgbmVjZXNzYXJ5IHRvIHN1Y2Nlc3NmdWxseSBjcmVhdGUgYW5kIG1vZGlmeSB0aGVcbiAgICogcmVzb3VyY2VzIHRoYXQgdGhlIHN1YnNlcXVlbnQgQ2xvdWRGb3JtYXRpb24gZGVwbG95bWVudHMgbmVlZC5cbiAgICogQWRtaW5pc3RyYXRvciBwZXJtaXNzaW9ucyB3b3VsZCBiZSBjb21tb25seSBncmFudGVkIHRvIHRoZXNlLCBidXQgaWYgeW91IGNhblxuICAgKiBzY29wZSB0aGUgcGVybWlzc2lvbnMgZG93biBmcm9tZSB0aGVyZSB5b3Ugd291bGQgYmUgc2FmZXIuXG4gICAqXG4gICAqIEBkZWZhdWx0IEFXU0Nsb3VkRm9ybWF0aW9uU3RhY2tTZXRFeGVjdXRpb25Sb2xlXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvc3RhY2tzZXRzLXByZXJlcXMtc2VsZi1tYW5hZ2VkLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IGV4ZWN1dGlvblJvbGVOYW1lPzogc3RyaW5nO1xufVxuIl19