# coding: utf-8

"""
    Prowlarr

    Prowlarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from prowlarr.models.book_search_param import BookSearchParam
from prowlarr.models.indexer_category import IndexerCategory
from prowlarr.models.movie_search_param import MovieSearchParam
from prowlarr.models.music_search_param import MusicSearchParam
from prowlarr.models.search_param import SearchParam
from prowlarr.models.tv_search_param import TvSearchParam

class IndexerCapabilityResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    limits_max: Optional[int]
    limits_default: Optional[int]
    categories: Optional[List]
    supports_raw_search: Optional[bool]
    search_params: Optional[List]
    tv_search_params: Optional[List]
    movie_search_params: Optional[List]
    music_search_params: Optional[List]
    book_search_params: Optional[List]
    __properties = ["id", "limitsMax", "limitsDefault", "categories", "supportsRawSearch", "searchParams", "tvSearchParams", "movieSearchParams", "musicSearchParams", "bookSearchParams"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IndexerCapabilityResource:
        """Create an instance of IndexerCapabilityResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item in self.categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['categories'] = _items
        # set to None if limits_max (nullable) is None
        if self.limits_max is None:
            _dict['limitsMax'] = None

        # set to None if limits_default (nullable) is None
        if self.limits_default is None:
            _dict['limitsDefault'] = None

        # set to None if categories (nullable) is None
        if self.categories is None:
            _dict['categories'] = None

        # set to None if search_params (nullable) is None
        if self.search_params is None:
            _dict['searchParams'] = None

        # set to None if tv_search_params (nullable) is None
        if self.tv_search_params is None:
            _dict['tvSearchParams'] = None

        # set to None if movie_search_params (nullable) is None
        if self.movie_search_params is None:
            _dict['movieSearchParams'] = None

        # set to None if music_search_params (nullable) is None
        if self.music_search_params is None:
            _dict['musicSearchParams'] = None

        # set to None if book_search_params (nullable) is None
        if self.book_search_params is None:
            _dict['bookSearchParams'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IndexerCapabilityResource:
        """Create an instance of IndexerCapabilityResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IndexerCapabilityResource.parse_obj(obj)

        _obj = IndexerCapabilityResource.parse_obj({
            "id": obj.get("id"),
            "limits_max": obj.get("limitsMax"),
            "limits_default": obj.get("limitsDefault"),
            "categories": [IndexerCategory.from_dict(_item) for _item in obj.get("categories")] if obj.get("categories") is not None else None,
            "supports_raw_search": obj.get("supportsRawSearch"),
            "search_params": obj.get("searchParams"),
            "tv_search_params": obj.get("tvSearchParams"),
            "movie_search_params": obj.get("movieSearchParams"),
            "music_search_params": obj.get("musicSearchParams"),
            "book_search_params": obj.get("bookSearchParams")
        })
        return _obj

