# Generated by Django 3.0.3 on 2020-03-29 14:33

import django.contrib.postgres.fields.jsonb
import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Execution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stats', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('time_started', models.DateTimeField(db_index=True)),
                ('time_ended', models.DateTimeField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Spider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True)),
                ('name', models.CharField(blank=True, max_length=200)),
                ('module', models.CharField(max_length=200, unique=True)),
                ('active', models.BooleanField(db_index=True, default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True)),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('processed', models.BooleanField(db_index=True, default=False)),
                ('execution', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='scratchy.Execution')),
                ('spider', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='scratchy.Spider')),
            ],
        ),
        migrations.AddField(
            model_name='execution',
            name='spider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='scratchy.Spider'),
        ),
    ]
