import { aws_logs as logs } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * The properties of a new AZ ID to name mapping
 */
export interface AzIdToNameMappingProps {
    /**
     * The target AZ IDs for mapping. Defaults to values for 3 zones in us-east-1.
     *
     * @default ['use1-az2', 'use1-az4', 'use1-az6']
     */
    readonly azIds?: string[];
    /**
     * The prefix to use for the SSM parameter names. Defaults to `/az-mapping/`.
     *
     * @default '/az-mapping/'
     */
    readonly ssmParameterPrefix?: string;
    /**
     * The number of days to retain log events in CloudWatch logs. Defaults to 30 days.
     *
     * @default logs.RetentionDays.ONE_MONTH
     */
    readonly logRetention?: logs.RetentionDays;
}
export declare class AzIdToNameMapping extends Construct {
    /**
     * The resulting mapping of AZ IDs to names
     */
    readonly mapping: string;
    constructor(scope: Construct, id: string, props: AzIdToNameMappingProps);
}
