# Generated by Django 4.2.20 on 2025-07-30 09:39

import django.db.models.deletion
from django.db import migrations, models

import djangocms_attributes_field.fields


class Migration(migrations.Migration):

    dependencies = [
        ("aldryn_forms", "0021_formsubmission_honeypot_filled"),
    ]

    operations = [
        migrations.CreateModel(
            name="URLFieldPlugin",
            fields=[
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Used to set the field name",
                        max_length=255,
                        verbose_name="Name",
                    ),
                ),
                (
                    "label",
                    models.CharField(blank=True, max_length=255, verbose_name="Label"),
                ),
                (
                    "required",
                    models.BooleanField(
                        default=False, verbose_name="Field is required"
                    ),
                ),
                (
                    "required_message",
                    models.TextField(
                        blank=True,
                        help_text='Error message displayed if the required field is left empty. Default: "This field is required".',
                        null=True,
                        verbose_name="Error message",
                    ),
                ),
                (
                    "placeholder_text",
                    models.CharField(
                        blank=True,
                        help_text='Default text in a form. Disappears when user starts typing. Example: "email@example.com"',
                        max_length=255,
                        verbose_name="Placeholder text",
                    ),
                ),
                (
                    "help_text",
                    models.TextField(
                        blank=True,
                        help_text="Explanatory text displayed next to input field. Just like this one.",
                        null=True,
                        verbose_name="Help text",
                    ),
                ),
                (
                    "attributes",
                    djangocms_attributes_field.fields.AttributesField(
                        blank=True, default=dict, verbose_name="Attributes"
                    ),
                ),
                (
                    "min_value",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="Min value"
                    ),
                ),
                (
                    "max_value",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="Max value"
                    ),
                ),
                (
                    "initial_value",
                    models.CharField(
                        blank=True,
                        help_text="Default value of field.",
                        max_length=255,
                        verbose_name="Initial value",
                    ),
                ),
                (
                    "custom_classes",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="custom css classes"
                    ),
                ),
                (
                    "cmsplugin_ptr",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="%(app_label)s_%(class)s",
                        serialize=False,
                        to="cms.cmsplugin",
                    ),
                ),
                (
                    "list",
                    models.TextField(
                        blank=None,
                        help_text="A list of predefined url values. Each url is on a separate line. The first word is the url. The next (optional) words are a description for the url.",
                        null=True,
                        verbose_name="List of urls",
                    ),
                ),
                (
                    "pattern",
                    models.CharField(
                        blank=None,
                        help_text="A regular expression to match for the value. It must be a valid JavaScript regular expression.",
                        null=True,
                        max_length=255,
                        verbose_name="Pattern",
                    ),
                ),
                (
                    "readonly",
                    models.BooleanField(
                        blank=None,
                        help_text="The field cannot be edited by the user.",
                        null=True,
                        verbose_name="Read only",
                    ),
                ),
                (
                    "size",
                    models.SmallIntegerField(
                        blank=None,
                        help_text="How many characters wide the input field should be. The default value is 20.",
                        null=True,
                        verbose_name="Size",
                    ),
                ),
                (
                    "spellcheck",
                    models.BooleanField(
                        blank=None,
                        help_text="To enable spell-checking for an element.",
                        null=True,
                        verbose_name="Spellcheck",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("cms.cmsplugin",),
        ),
    ]
