# Generated by Django 4.2.20 on 2025-04-29 12:27

from django.db import migrations

import aldryn_forms.fields


def populate_field_redirect_to(apps, schema_editor):
    if schema_editor.connection.alias != "default":
        return
    FormPlugin = apps.get_model("aldryn_forms", "FormPlugin")
    for instance in FormPlugin.objects.all():
        if instance.redirect_type == "redirect_to_page":
            if instance.redirect_page is not None:
                instance.redirect_to = {"internal_link": f"cms.page:{instance.redirect_page.pk}"}
                instance.save()
        elif instance.redirect_type == "redirect_to_url":
            instance.redirect_to = {"external_link": instance.url}
            instance.save()


class Migration(migrations.Migration):

    dependencies = [
        ('aldryn_forms', '0021_formsubmission_honeypot_filled'),
    ]

    operations = [
        migrations.AddField(
            model_name='formplugin',
            name='redirect_to',
            field=aldryn_forms.fields.AldrynFormsLinkField(blank=True, default=dict, help_text='-', null=True, verbose_name='Redirect to'),
        ),
        migrations.RunPython(populate_field_redirect_to),
    ]
