/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.StringToDateTransform;
import com.sas.util.transforms.TransformException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;

public class StringToSQLDateTransform
extends StringToDateTransform {
    static final long serialVersionUID = -7670709939329023996L;
    public static final StringToSQLDateTransform defaultInstance = new StringToSQLDateTransform();

    public StringToSQLDateTransform() {
        this(Locale.getDefault());
    }

    public StringToSQLDateTransform(Locale locale) {
        super(locale);
    }

    @Override
    public Object transform(Object input) throws TransformException {
        if (input != null) {
            if (this.dateFormatter == null) {
                this.dateFormatter = DateFormat.getDateInstance(2, this.locale);
            }
            try {
                return new Date(this.dateFormatter.parse((String)input).getTime());
            }
            catch (ParseException e) {
                TransformException te = new TransformException(e.getMessage());
                te.initCause(e);
                throw te;
            }
        }
        return this.nullString;
    }

    @Override
    public Class getOutputClass() {
        return Date.class;
    }
}

