/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.RB;
import com.sas.util.RangeSegment;
import java.text.Format;

public class StringRangeSegment
extends RangeSegment {
    public static final String RB_KEY = "StringRangeSegment.";
    private String min;
    private String max;

    public StringRangeSegment() {
        this(null, null, false, true, null);
    }

    public StringRangeSegment(String min, String max) {
        this(min, max, false, true, null);
    }

    public StringRangeSegment(String min, String max, Object value) {
        this(min, max, false, true, value);
    }

    public StringRangeSegment(String min, String max, boolean minExcl, boolean maxExcl, Object value) {
        this.min = min;
        this.max = max;
        this.setValue(value);
        this.setMinExclude(minExcl);
        this.setMaxExclude(maxExcl);
    }

    public void setMin(String min) {
        this.min = min;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    @Override
    public int inRange(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return this.inRange((String)value);
            }
            throw new RuntimeException(RB.getStringResource(RB_KEY, "invalidType.txt"));
        }
        return -2;
    }

    public int inRange(String value) {
        int result = 0;
        if (value != null) {
            int ectv;
            int sctv = this.min == null ? 1 : value.compareTo(this.min);
            int n = ectv = this.max == null ? -1 : value.compareTo(this.max);
            if (sctv < 0 || this.minExclude && sctv == 0) {
                result = -1;
            } else if (ectv > 0 || this.maxExclude && ectv == 0) {
                result = 1;
            }
        } else {
            result = -2;
        }
        return result;
    }

    public String toString() {
        return this.min + (this.minExclude ? "<" : "") + "-" + (this.maxExclude ? "<" : "") + this.max;
    }

    public String toString(Format format) {
        return format.format(this.min) + (this.minExclude ? "<" : "") + "-" + (this.maxExclude ? "<" : "") + format.format(this.max);
    }
}

