/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.WeekType;
import com.sas.text.Message;
import com.sas.text.NLFormats;
import com.sas.text.NLInformats;
import com.sas.util.DateTypes;
import com.sas.util.RB;
import com.sas.util.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

@SASScope
public class DatePeriod
extends Date
implements Cloneable {
    private static final long serialVersionUID = 1137516962942545506L;
    public static final String RB_KEY = "DatePeriod.";
    private DateTypes periodType;
    private Date beginPeriod;
    private Date endPeriod;
    private Date dateInPeriod;
    private Locale locale;
    private int nYears;
    private int nQuarters;
    private int nMonths;
    private int nWeeks;
    private int nDays;
    private int nHours;
    private int nMinutes;
    private boolean dirty;
    private DateTypes alignmentType;
    private int alignment;
    private TimeZone timezone;
    private static char[] specialChars = new char[]{'m', 'H', 'D', 'W', 'M', 'Q', 'Y'};
    public static final int NO_ALIGNMENT = 0;
    public static final int BEGINNING_OF = 1;
    public static final int END_OF = 2;
    private static Map formatCache = null;

    public DatePeriod(DateTypes datePeriodType, Locale localeValue) {
        this(datePeriodType, null, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, DateTypes alignmentType, int alignment, Locale localeValue) {
        this(datePeriodType, alignmentType, alignment, null, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, int nYears, int nQuarters, int nMonths, int nWeeks, int nDays, int nHours, int nMinutes, Locale localeValue) {
        this(datePeriodType, nYears, nQuarters, nMonths, nWeeks, nDays, nHours, nMinutes, null, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, int nYears, int nQuarters, int nMonths, int nWeeks, int nDays, int nHours, int nMinutes, DateTypes alignmentType, int alignment, Locale localeValue) {
        this(datePeriodType, nYears, nQuarters, nMonths, nWeeks, nDays, nHours, nMinutes, alignmentType, alignment, null, localeValue);
    }

    public DatePeriod(Date dateInPeriodValue, DateTypes datePeriodType, Locale localeValue) {
        this(dateInPeriodValue, datePeriodType, null, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, TimeZone timeZone, Locale localeValue) {
        this(datePeriodType, null, 0, timeZone, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, DateTypes alignmentType, int alignment, TimeZone timeZone, Locale localeValue) {
        this(datePeriodType, 0, 0, 0, 0, 0, 0, 0, alignmentType, alignment, timeZone, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, int nYears, int nQuarters, int nMonths, int nWeeks, int nDays, int nHours, int nMinutes, TimeZone timeZone, Locale localeValue) {
        this(datePeriodType, nYears, nQuarters, nMonths, nWeeks, nDays, nHours, nMinutes, null, 0, timeZone, localeValue);
    }

    public DatePeriod(DateTypes datePeriodType, int nYears, int nQuarters, int nMonths, int nWeeks, int nDays, int nHours, int nMinutes, DateTypes alignmentType, int alignment, TimeZone timeZone, Locale localeValue) {
        this.setPeriodType(datePeriodType);
        this.timezone = timeZone;
        this.locale = localeValue;
        this.setNYears(nYears);
        this.setNQuarters(nQuarters);
        this.setNMonths(nMonths);
        this.setNWeeks(nWeeks);
        this.setNDays(nDays);
        this.setNHours(nHours);
        this.setNMinutes(nMinutes);
        this.setAlignment(alignmentType, alignment);
        this.dirty = true;
    }

    public DatePeriod(Date dateInPeriodValue, DateTypes datePeriodType, TimeZone timeZone, Locale localeValue) {
        this(datePeriodType, timeZone, localeValue);
        this.setDateInPeriod(dateInPeriodValue);
    }

    public DateTypes getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(DateTypes type) {
        if (this.periodType != type) {
            this.periodType = type;
            this.dirty = true;
        }
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setTimeZone(TimeZone newTimeZone) {
        if (this.timezone != newTimeZone) {
            this.timezone = newTimeZone;
            this.dirty = true;
        }
    }

    @Override
    public int getTimezoneOffset() {
        if (this.timezone != null) {
            return -this.timezone.getOffset(this.getStartOfPeriod().getTime()) / 60000;
        }
        return super.getTimezoneOffset();
    }

    @Override
    public long getTime() {
        return this.getStartOfPeriod().getTime();
    }

    public void setAlignment(DateTypes type, int alignment) {
        if (type != null && alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalAlignment.txt"));
        }
        if (type != this.alignmentType || this.alignment != alignment) {
            this.alignmentType = type;
            this.alignment = alignment;
            if (this.alignmentType == null) {
                alignment = 0;
            }
            this.dirty = true;
        }
    }

    public DateTypes getAlignmentType() {
        return this.alignmentType;
    }

    public int getAlignment() {
        return this.alignment;
    }

    private Calendar getCalendar() {
        return DataTypeUtil.getCalendar(this.getTimeZone(), this.locale);
    }

    public DatePeriod next() {
        if (this.isRelativeDate()) {
            return null;
        }
        Calendar cal = this.getCalendar();
        cal.setTime(this.getStartOfPeriod());
        DatePeriod newPeriod = null;
        if (this.periodType == DateTypes.WEEK) {
            cal.set(6, cal.get(6) + 7);
        } else if (this.periodType == DateTypes.MONTH) {
            cal.set(2, cal.get(2) + 1);
        } else if (this.periodType == DateTypes.QUARTER) {
            cal.set(2, cal.get(2) + 3);
        } else if (this.periodType == DateTypes.YEAR) {
            cal.set(1, cal.get(1) + 1);
        } else if (this.periodType == DateTypes.DATE) {
            cal.set(5, cal.get(5) + 1);
        } else if (this.periodType == DateTypes.HOUR) {
            cal.set(11, cal.get(11) + 1);
        } else if (this.periodType == DateTypes.MINUTE) {
            cal.set(12, cal.get(12) + 1);
        } else if (this.periodType == DateTypes.WEEKDAY) {
            int dayOfWeek = cal.get(7);
            int increment = 1;
            if (dayOfWeek == 6) {
                increment = 3;
            }
            cal.set(5, cal.get(5) + increment);
        } else if (this.periodType == DateTypes.TIMESTAMP) {
            cal.set(14, cal.get(14) + 1);
        } else if (this.periodType == DateTypes.TIME) {
            cal.set(14, cal.get(14) + 1);
        }
        newPeriod = new DatePeriod(cal.getTime(), this.periodType, this.timezone, this.locale);
        return newPeriod;
    }

    public DatePeriod previous() {
        if (this.isRelativeDate()) {
            return null;
        }
        Calendar cal = this.getCalendar();
        cal.setTime(this.getStartOfPeriod());
        DatePeriod newPeriod = null;
        if (this.periodType == DateTypes.WEEK) {
            cal.set(6, cal.get(6) - 7);
        } else if (this.periodType == DateTypes.MONTH) {
            cal.set(2, cal.get(2) - 1);
        } else if (this.periodType == DateTypes.QUARTER) {
            cal.set(2, cal.get(2) - 3);
        } else if (this.periodType == DateTypes.YEAR) {
            cal.set(1, cal.get(1) - 1);
        } else if (this.periodType == DateTypes.DATE) {
            cal.set(5, cal.get(5) - 1);
        } else if (this.periodType == DateTypes.HOUR) {
            cal.set(11, cal.get(11) - 1);
        } else if (this.periodType == DateTypes.MINUTE) {
            cal.set(12, cal.get(12) - 1);
        } else if (this.periodType == DateTypes.WEEKDAY) {
            int dayOfWeek = cal.get(7);
            int decrement = 1;
            if (dayOfWeek == 2) {
                decrement = 3;
            }
            cal.set(5, cal.get(5) - decrement);
        } else if (this.periodType == DateTypes.TIMESTAMP) {
            cal.set(14, cal.get(14) - 1);
        } else if (this.periodType == DateTypes.TIME) {
            cal.set(14, cal.get(14) - 1);
        }
        newPeriod = new DatePeriod(cal.getTime(), this.periodType, this.timezone, this.locale);
        return newPeriod;
    }

    public void setDateInPeriod(Date dateInPeriodValue) {
        if (!Util.equal(this.dateInPeriod, dateInPeriodValue)) {
            this.dateInPeriod = dateInPeriodValue;
            this.dirty = true;
        }
    }

    private void updateCalendarField(Calendar cal, int field, int nAmount) {
        if (nAmount != 0) {
            if (field == 2 || field == 1) {
                int month = cal.get(2);
                int year = cal.get(1);
                cal.set(field, cal.get(field) + nAmount);
                int newMonth = cal.get(2);
                int newYear = cal.get(1);
                if (field == 2) {
                    int changedAmount = newMonth - month + (newYear - year) * 12;
                    if (changedAmount != nAmount) {
                        cal.set(field, cal.get(field) - (changedAmount - nAmount));
                        cal.set(5, cal.getActualMaximum(5));
                    }
                } else if (field == 1 && month != newMonth) {
                    cal.set(2, month);
                    cal.set(5, cal.getActualMaximum(5));
                }
            } else if (field == 3) {
                cal.set(6, cal.get(6) + nAmount * 7);
                cal.get(6);
            } else {
                cal.set(field, cal.get(field) + nAmount);
            }
        }
    }

    private void setStartAndEndValues() {
        int change;
        int dayOfWeek;
        int month;
        int maxDays;
        int quarter;
        int month2;
        int year;
        Calendar cal = this.getCalendar();
        int currentYear = cal.get(1);
        int currentDay = cal.get(6);
        if (this.dateInPeriod != null) {
            cal.setTime(this.dateInPeriod);
        } else {
            cal.setTime(DataTypeUtil.convertDateToTimeZone(new Date(), null, this.timezone, this.locale));
        }
        this.updateCalendarField(cal, 12, this.getNMinutes());
        this.updateCalendarField(cal, 11, this.getNHours());
        this.updateCalendarField(cal, 5, this.getNDays());
        this.updateCalendarField(cal, 3, this.getNWeeks());
        this.updateCalendarField(cal, 2, this.getNMonths());
        this.updateCalendarField(cal, 2, this.getNQuarters() * 3);
        this.updateCalendarField(cal, 1, this.getNYears());
        if (this.getAlignment() != 0) {
            if (this.getAlignmentType() == DateTypes.YEAR) {
                year = cal.get(1);
                if (this.getAlignment() == 1) {
                    cal.set(year, 0, 1, 0, 0, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(year, 11, 31, 23, 59, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.QUARTER) {
                month2 = cal.get(2);
                quarter = month2 / 3;
                if (this.getAlignment() == 1) {
                    cal.set(2, quarter * 3);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(2, quarter * 3 + 2);
                    maxDays = cal.getActualMaximum(5);
                    cal.set(5, maxDays);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.MONTH) {
                year = cal.get(1);
                month = cal.get(2);
                maxDays = cal.getActualMaximum(5);
                if (this.getAlignment() == 1) {
                    cal.set(year, month, 1, 0, 0, 0);
                    cal.set(14, 0);
                } else {
                    cal.set(year, month, maxDays, 23, 59, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.WEEK) {
                if (this.getAlignment() == 1) {
                    cal.set(7, cal.getFirstDayOfWeek());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(7, cal.getFirstDayOfWeek() + 6);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.DATE || this.getAlignmentType() == DateTypes.WEEKDAY) {
                if (this.periodType == DateTypes.WEEKDAY) {
                    dayOfWeek = cal.get(7);
                    change = 0;
                    if (dayOfWeek == 7) {
                        change = -1;
                    }
                    if (dayOfWeek == 1) {
                        change = 1;
                    }
                    if (change != 0) {
                        cal.set(5, cal.get(5) + change);
                    }
                }
                if (this.getAlignment() == 1) {
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.HOUR) {
                if (this.getAlignment() == 1) {
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.MINUTE) {
                if (this.getAlignment() == 1) {
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(13, 59);
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.TIMESTAMP) {
                if (this.getAlignment() == 1) {
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(14, 999);
                }
            } else if (this.getAlignmentType() == DateTypes.TIME) {
                currentYear = cal.get(1);
                currentDay = cal.get(6);
                cal.set(6, currentDay);
                cal.set(1, currentYear);
                if (this.getAlignment() == 1) {
                    cal.set(14, 0);
                } else if (this.getAlignment() == 2) {
                    cal.set(14, 999);
                }
            }
        }
        if (this.periodType == DateTypes.YEAR) {
            year = cal.get(1);
            cal.set(year, 0, 1, 0, 0, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(year, 11, 31, 23, 59, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.QUARTER) {
            month2 = cal.get(2);
            quarter = month2 / 3;
            cal.set(2, quarter * 3);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(2, quarter * 3 + 2);
            maxDays = cal.getActualMaximum(5);
            cal.set(5, maxDays);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.MONTH) {
            year = cal.get(1);
            month = cal.get(2);
            maxDays = cal.getActualMaximum(5);
            cal.set(year, month, 1, 0, 0, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(year, month, maxDays, 23, 59, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.WEEK) {
            cal.set(7, cal.getFirstDayOfWeek());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(7, cal.getFirstDayOfWeek() + 6);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.DATE || this.periodType == DateTypes.WEEKDAY) {
            if (this.periodType == DateTypes.WEEKDAY) {
                dayOfWeek = cal.get(7);
                change = 0;
                if (dayOfWeek == 7) {
                    change = -1;
                }
                if (dayOfWeek == 1) {
                    change = 1;
                }
                if (change != 0) {
                    cal.set(5, cal.get(5) + change);
                }
            }
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.HOUR) {
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.MINUTE) {
            cal.set(13, 0);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(13, 59);
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.TIMESTAMP) {
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        } else if (this.periodType == DateTypes.TIME) {
            cal.set(6, currentDay);
            cal.set(1, currentYear);
            cal.set(14, 0);
            this.beginPeriod = cal.getTime();
            cal.set(14, 999);
            this.endPeriod = cal.getTime();
        }
        this.dirty = false;
    }

    public Date getStartOfPeriod() {
        if (this.dirty || this.isRelativeDate()) {
            this.setStartAndEndValues();
        }
        return this.beginPeriod;
    }

    public Date getEndOfPeriod() {
        if (this.dirty || this.isRelativeDate()) {
            this.setStartAndEndValues();
        }
        return this.endPeriod;
    }

    @Override
    public Object clone() {
        DatePeriod d = null;
        d = (DatePeriod)super.clone();
        d.setTimeZone(this.getTimeZone());
        if (this.dateInPeriod != null) {
            d.setDateInPeriod(this.dateInPeriod);
        }
        d.setPeriodType(this.getPeriodType());
        d.setNYears(this.getNYears());
        d.setNQuarters(this.getNQuarters());
        d.setNMonths(this.getNMonths());
        d.setNWeeks(this.getNWeeks());
        d.setNDays(this.getNDays());
        d.setNHours(this.getNHours());
        d.setNMinutes(this.getNMinutes());
        d.setAlignment(this.getAlignmentType(), this.getAlignment());
        return d;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        if (this.dateInPeriod != null) {
            this.dateInPeriod.setTime(time);
            this.dirty = true;
        }
    }

    @Override
    public boolean before(Date when) {
        return this.getEndOfPeriod().getTime() < when.getTime();
    }

    @Override
    public boolean after(Date when) {
        return this.getStartOfPeriod().getTime() > when.getTime();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DatePeriod) {
            long start1;
            long start;
            DatePeriod dp = (DatePeriod)obj;
            if (this.getPeriodType() == dp.getPeriodType() && this.isRelativeDate() == dp.isRelativeDate() && (this.isRelativeDate() ? this.toString().equals(dp.toString()) : (start = this.getStartOfPeriod().getTime()) == (start1 = dp.getStartOfPeriod().getTime()))) {
                return true;
            }
        } else if (!this.isRelativeDate()) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int compareTo(Date anotherDate) {
        long anotherTime;
        if (anotherDate instanceof DatePeriod) {
            if (this.isRelativeDate() && ((DatePeriod)anotherDate).isRelativeDate() && this.equals(anotherDate)) {
                return 0;
            }
            long startTime = this.getStartOfPeriod().getTime();
            long endTime = this.getEndOfPeriod().getTime();
            long anotherStartTime = ((DatePeriod)anotherDate).getStartOfPeriod().getTime();
            long anotherEndTime = ((DatePeriod)anotherDate).getEndOfPeriod().getTime();
            if (endTime < anotherStartTime) {
                return -1;
            }
            if (startTime > anotherEndTime) {
                return 1;
            }
            return 0;
        }
        long startTime = this.getStartOfPeriod().getTime();
        long endTime = this.getEndOfPeriod().getTime();
        if (endTime < (anotherTime = anotherDate.getTime())) {
            return -1;
        }
        if (startTime > anotherTime) {
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        long ht1 = this.getStartOfPeriod().getTime();
        long ht2 = this.getEndOfPeriod().getTime();
        return (int)(ht1 ^ (long)((int)(ht1 >> 32))) + (int)(ht2 ^ (long)((int)(ht2 >> 32)));
    }

    @Override
    public String toString() {
        return this.toString(null, this.locale);
    }

    public String toString(DateFormat format, Locale locale) {
        if (this.dateInPeriod != null) {
            Date startOfPeriod = this.getStartOfPeriod();
            if (format == null) {
                String formatString = "";
                Calendar cal = this.getCalendar();
                if (this.periodType == DateTypes.YEAR) {
                    formatString = NLFormats.getPattern("NLDATEYR", locale);
                } else if (this.periodType == DateTypes.QUARTER) {
                    formatString = QuarterType.getQuarterFormatString(this.dateInPeriod, this.getTimeZone(), locale);
                } else if (this.periodType == DateTypes.MONTH) {
                    formatString = NLFormats.getPattern("NLDATEYM", locale);
                } else if (this.periodType == DateTypes.WEEK) {
                    Date week = startOfPeriod;
                    formatString = WeekType.getWeekFormatString(week, locale, cal);
                } else if (this.periodType == DateTypes.DATE) {
                    formatString = NLFormats.getPattern("NLDATE", locale);
                } else if (this.periodType == DateTypes.HOUR) {
                    formatString = NLFormats.getPattern("NLTIMNAP", locale);
                } else if (this.periodType == DateTypes.MINUTE) {
                    formatString = NLFormats.getPattern("NLTIMNAP", locale);
                } else if (this.periodType == DateTypes.TIMESTAMP) {
                    formatString = NLFormats.getPattern("NLDATMAP", locale);
                } else if (this.periodType == DateTypes.TIME) {
                    formatString = NLFormats.getPattern("NLTIMAP", locale);
                }
                format = new SimpleDateFormat(formatString, locale);
                format.setLenient(false);
                if (this.timezone != null) {
                    format.setTimeZone(this.timezone);
                }
                format.setCalendar(cal);
            }
            return format.format(startOfPeriod);
        }
        char periodChar = DatePeriod.getCharFor(this.periodType);
        StringBuffer buffer = new StringBuffer(String.valueOf(periodChar));
        this.appendBuffer(buffer, specialChars[0], this.getNMinutes(), periodChar);
        this.appendBuffer(buffer, specialChars[1], this.getNHours(), periodChar);
        this.appendBuffer(buffer, specialChars[2], this.getNDays(), periodChar);
        this.appendBuffer(buffer, specialChars[3], this.getNWeeks(), periodChar);
        this.appendBuffer(buffer, specialChars[4], this.getNMonths(), periodChar);
        this.appendBuffer(buffer, specialChars[5], this.getNQuarters(), periodChar);
        this.appendBuffer(buffer, specialChars[6], this.getNYears(), periodChar);
        if (buffer.length() == 1) {
            buffer.append("0m");
        }
        if (this.getAlignment() != 0) {
            if (this.getAlignment() == 1) {
                buffer.append('B');
            } else if (this.getAlignment() == 2) {
                buffer.append('E');
            }
            buffer.append(DatePeriod.getCharFor(this.getAlignmentType()));
        }
        return buffer.toString();
    }

    public static int getISOYear(Calendar cal) {
        int woy = cal.get(3);
        int isoYear = cal.get(1);
        if (cal.get(2) == 0) {
            if (woy >= 52) {
                --isoYear;
            }
        } else if (woy == 1) {
            ++isoYear;
        }
        return isoYear;
    }

    public String toDisplayString(DateFormat format, Locale locale) {
        if (this.dateInPeriod != null) {
            return this.toString(format, locale);
        }
        String returnString = "";
        ArrayList<String> stringList = new ArrayList<String>();
        if (this.getAlignment() != 0) {
            if (this.getAlignment() == 1) {
                if (this.getAlignmentType() == DateTypes.YEAR) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfYear.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.QUARTER) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfQuarter.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.MONTH) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfMonth.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.WEEK) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfWeek.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.DATE) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfDay.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.WEEKDAY) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfWeekDay.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.HOUR) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfHour.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.MINUTE) {
                    stringList.add(RB.getStringResource(RB_KEY, "startOfMinute.txt", locale));
                }
            } else if (this.getAlignment() == 2) {
                if (this.getAlignmentType() == DateTypes.YEAR) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfYear.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.QUARTER) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfQuarter.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.MONTH) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfMonth.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.WEEK) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfWeek.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.DATE) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfDay.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.WEEKDAY) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfWeekDay.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.HOUR) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfHour.txt", locale));
                } else if (this.getAlignmentType() == DateTypes.MINUTE) {
                    stringList.add(RB.getStringResource(RB_KEY, "endOfMinute.txt", locale));
                }
            }
        }
        this.updateAgoOrFromNowList(DateTypes.MINUTE, this.getNMinutes(), "Minute", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.HOUR, this.getNHours(), "Hour", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.DATE, this.getNDays(), "Day", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.WEEK, this.getNWeeks(), "Week", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.MONTH, this.getNMonths(), "Month", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.QUARTER, this.getNQuarters(), "Quarter", stringList, locale);
        this.updateAgoOrFromNowList(DateTypes.YEAR, this.getNYears(), "Year", stringList, locale);
        if (stringList.size() <= 2) {
            int nMinute;
            int nHour;
            int nMonth;
            int nYear = this.getNYears();
            if (nYear == 1) {
                if (this.getAlignment() == 0) {
                    if (this.periodType == DateTypes.DATE) {
                        return RB.getStringResource(RB_KEY, "currentDayNextYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "currentWeekNextYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "currentMonthNextYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.QUARTER) {
                        return RB.getStringResource(RB_KEY, "currentQuarterNextYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.TIMESTAMP) {
                        return RB.getStringResource(RB_KEY, "currentDateTimeNextYear.txt", locale);
                    }
                } else if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.DATE) {
                        if (this.getAlignmentType() == DateTypes.YEAR) {
                            return RB.getStringResource(RB_KEY, "dayStartOfNextYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.QUARTER) {
                            return RB.getStringResource(RB_KEY, "dayStartOfQuarterNextYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.MONTH) {
                            return RB.getStringResource(RB_KEY, "dayStartOfMonthNextYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.WEEK) {
                            return RB.getStringResource(RB_KEY, "dayStartOfWeekNextYear.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && this.periodType == DateTypes.DATE) {
                    if (this.getAlignmentType() == DateTypes.YEAR) {
                        return RB.getStringResource(RB_KEY, "dayEndOfNextYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.QUARTER) {
                        return RB.getStringResource(RB_KEY, "dayEndOfQuarterNextYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "dayEndOfMonthNextYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "dayEndOfWeekNextYear.txt", locale);
                    }
                }
            } else if (nYear == -1) {
                if (this.getAlignment() == 0) {
                    if (this.periodType == DateTypes.DATE) {
                        return RB.getStringResource(RB_KEY, "currentDayPreviousYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "currentWeekPreviousYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "currentMonthPreviousYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.QUARTER) {
                        return RB.getStringResource(RB_KEY, "currentQuarterPreviousYear.txt", locale);
                    }
                    if (this.periodType == DateTypes.TIMESTAMP) {
                        return RB.getStringResource(RB_KEY, "currentDateTimePreviousYear.txt", locale);
                    }
                } else if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.DATE) {
                        if (this.getAlignmentType() == DateTypes.YEAR) {
                            return RB.getStringResource(RB_KEY, "dayStartOfPreviousYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.QUARTER) {
                            return RB.getStringResource(RB_KEY, "dayStartOfQuarterPreviousYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.MONTH) {
                            return RB.getStringResource(RB_KEY, "dayStartOfMonthPreviousYear.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.WEEK) {
                            return RB.getStringResource(RB_KEY, "dayStartOfWeekPreviousYear.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && this.periodType == DateTypes.DATE) {
                    if (this.getAlignmentType() == DateTypes.YEAR) {
                        return RB.getStringResource(RB_KEY, "dayEndOfPreviousYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.QUARTER) {
                        return RB.getStringResource(RB_KEY, "dayEndOfQuarterPreviousYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "dayEndOfMonthPreviousYear.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "dayEndOfWeekPreviousYear.txt", locale);
                    }
                }
            }
            if ((nMonth = this.getNMonths()) == 1) {
                if (this.getAlignment() == 0) {
                    if (this.periodType == DateTypes.DATE) {
                        return RB.getStringResource(RB_KEY, "currentDayNextMonth.txt", locale);
                    }
                } else if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.DATE) {
                        if (this.getAlignmentType() == DateTypes.MONTH) {
                            return RB.getStringResource(RB_KEY, "dayStartOfMonthNextMonth.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.WEEK) {
                            return RB.getStringResource(RB_KEY, "dayStartOfWeekNextMonth.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && this.periodType == DateTypes.DATE) {
                    if (this.getAlignmentType() == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "dayEndOfMonthNextMonth.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "dayEndOfWeekNextMonth.txt", locale);
                    }
                }
            } else if (nMonth == -1) {
                if (this.getAlignment() == 0) {
                    if (this.periodType == DateTypes.DATE) {
                        return RB.getStringResource(RB_KEY, "currentDayPreviousMonth.txt", locale);
                    }
                } else if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.DATE) {
                        if (this.getAlignmentType() == DateTypes.MONTH) {
                            return RB.getStringResource(RB_KEY, "dayStartOfMonthPreviousMonth.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.WEEK) {
                            return RB.getStringResource(RB_KEY, "dayStartOfWeekPreviousMonth.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && this.periodType == DateTypes.DATE) {
                    if (this.getAlignmentType() == DateTypes.MONTH) {
                        return RB.getStringResource(RB_KEY, "dayEndOfMonthPreviousMonth.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.WEEK) {
                        return RB.getStringResource(RB_KEY, "dayEndOfWeekPreviousMonth.txt", locale);
                    }
                }
            }
            if ((nHour = this.getNHours()) == 1) {
                if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) {
                        if (this.getAlignmentType() == DateTypes.HOUR) {
                            return RB.getStringResource(RB_KEY, "timeStartOfHourNextHour.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.MINUTE) {
                            return RB.getStringResource(RB_KEY, "timeStartOfMinuteNextHour.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP)) {
                    if (this.getAlignmentType() == DateTypes.HOUR) {
                        return RB.getStringResource(RB_KEY, "timeEndOfHourNextHour.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.MINUTE) {
                        return RB.getStringResource(RB_KEY, "timeEndOfMinuteNextHour.txt", locale);
                    }
                }
            } else if (nHour == -1) {
                if (this.getAlignment() == 1) {
                    if (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) {
                        if (this.getAlignmentType() == DateTypes.HOUR) {
                            return RB.getStringResource(RB_KEY, "timeStartOfHourPreviousHour.txt", locale);
                        }
                        if (this.getAlignmentType() == DateTypes.MINUTE) {
                            return RB.getStringResource(RB_KEY, "timeStartOfMinutePreviousHour.txt", locale);
                        }
                    }
                } else if (this.getAlignment() == 2 && (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP)) {
                    if (this.getAlignmentType() == DateTypes.HOUR) {
                        return RB.getStringResource(RB_KEY, "timeEndOfHourPreviousHour.txt", locale);
                    }
                    if (this.getAlignmentType() == DateTypes.MINUTE) {
                        return RB.getStringResource(RB_KEY, "timeEndOfMinutePreviousHour.txt", locale);
                    }
                }
            }
            if ((nMinute = this.getNMinutes()) == 1) {
                if (this.getAlignment() == 1) {
                    if ((this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) && this.getAlignmentType() == DateTypes.MINUTE) {
                        return RB.getStringResource(RB_KEY, "timeStartOfMinuteNextMinute.txt", locale);
                    }
                } else if (this.getAlignment() == 2 && (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) && this.getAlignmentType() == DateTypes.MINUTE) {
                    return RB.getStringResource(RB_KEY, "timeEndOfMinuteNextMinute.txt", locale);
                }
            } else if (nMinute == -1) {
                if (this.getAlignment() == 1) {
                    if ((this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) && this.getAlignmentType() == DateTypes.MINUTE) {
                        return RB.getStringResource(RB_KEY, "timeStartOfMinutePreviousMinute.txt", locale);
                    }
                } else if (this.getAlignment() == 2 && (this.periodType == DateTypes.TIME || this.periodType == DateTypes.TIMESTAMP) && this.getAlignmentType() == DateTypes.MINUTE) {
                    return RB.getStringResource(RB_KEY, "timeEndOfMinutePreviousMinute.txt", locale);
                }
            }
        }
        if (!stringList.isEmpty()) {
            int size = stringList.size();
            for (int i = 0; i < size; ++i) {
                String s = (String)stringList.get(i);
                returnString = i <= size - 1 && i != 0 ? Message.format(RB.getStringResource(RB_KEY, "commaSeperated.fmt.txt", locale), (Object)returnString, (Object)s) : s;
            }
        } else if (this.periodType == DateTypes.DATE) {
            returnString = RB.getStringResource(RB_KEY, "today.txt", locale);
        } else if (this.periodType == DateTypes.MONTH) {
            returnString = RB.getStringResource(RB_KEY, "currentMonth.txt", locale);
        } else if (this.periodType == DateTypes.QUARTER) {
            returnString = RB.getStringResource(RB_KEY, "currentQuarter.txt", locale);
        } else if (this.periodType == DateTypes.YEAR) {
            returnString = RB.getStringResource(RB_KEY, "currentYear.txt", locale);
        } else if (this.periodType == DateTypes.HOUR) {
            returnString = RB.getStringResource(RB_KEY, "currentHour.txt", locale);
        } else if (this.periodType == DateTypes.MINUTE) {
            returnString = RB.getStringResource(RB_KEY, "currentMinute.txt", locale);
        } else if (this.periodType == DateTypes.WEEK) {
            returnString = RB.getStringResource(RB_KEY, "currentWeek.txt", locale);
        } else if (this.periodType == DateTypes.TIMESTAMP) {
            returnString = RB.getStringResource(RB_KEY, "currentDateTime.txt", locale);
        } else if (this.periodType == DateTypes.TIME) {
            returnString = RB.getStringResource(RB_KEY, "currentTime.txt", locale);
        }
        return returnString;
    }

    private void updateAgoOrFromNowList(DateTypes type, int period, String key, List stringList, Locale locale) {
        if (period == 1) {
            if (type == this.getPeriodType()) {
                if (type == DateTypes.DATE) {
                    stringList.add(RB.getStringResource(RB_KEY, "tomorrow.txt", locale));
                } else {
                    stringList.add(RB.getStringResource(RB_KEY, "next" + key + ".txt", locale));
                }
            } else {
                stringList.add(RB.getStringResource(RB_KEY, "one" + key + "FromNow.txt", locale));
            }
        } else if (period == -1) {
            if (type == this.getPeriodType()) {
                if (type == DateTypes.DATE) {
                    stringList.add(RB.getStringResource(RB_KEY, "yesterday.txt", locale));
                } else {
                    stringList.add(RB.getStringResource(RB_KEY, "previous" + key + ".txt", locale));
                }
            } else {
                stringList.add(RB.getStringResource(RB_KEY, "one" + key + "Ago.txt", locale));
            }
        } else if (period > 1) {
            Integer periodValue = new Integer(Math.abs(period));
            String stringValue = periodValue.toString();
            stringList.add(Message.format(RB.getStringResource(RB_KEY, key.toLowerCase() + "sFromNow.fmt.txt", locale), (Object)stringValue));
        } else if (period < -1) {
            Integer periodValue = new Integer(Math.abs(period));
            String stringValue = periodValue.toString();
            stringList.add(Message.format(RB.getStringResource(RB_KEY, key.toLowerCase() + "sAgo.fmt.txt", locale), (Object)stringValue));
        } else if (type == this.getPeriodType() && this.getAlignment() == 0) {
            if (type == DateTypes.DATE) {
                stringList.add(0, RB.getStringResource(RB_KEY, "today.txt", locale));
            } else {
                stringList.add(0, RB.getStringResource(RB_KEY, "current" + key + ".txt", locale));
            }
        }
    }

    private void appendBuffer(StringBuffer buffer, char key, int period, char periodChar) {
        if (period != 0 || key == periodChar) {
            buffer.append(period + String.valueOf(key));
        }
    }

    private static char getCharFor(DateTypes periodType) {
        if (periodType == DateTypes.YEAR) {
            return specialChars[6];
        }
        if (periodType == DateTypes.QUARTER) {
            return specialChars[5];
        }
        if (periodType == DateTypes.MONTH) {
            return specialChars[4];
        }
        if (periodType == DateTypes.WEEK) {
            return specialChars[3];
        }
        if (periodType == DateTypes.DATE) {
            return specialChars[2];
        }
        if (periodType == DateTypes.HOUR) {
            return specialChars[1];
        }
        if (periodType == DateTypes.MINUTE) {
            return specialChars[0];
        }
        if (periodType == DateTypes.TIMESTAMP) {
            return 'T';
        }
        if (periodType == DateTypes.TIME) {
            return 't';
        }
        if (periodType == DateTypes.WEEKDAY) {
            return 'w';
        }
        return ' ';
    }

    private static DateTypes getDateTypesFor(char periodType) {
        if (periodType == specialChars[6]) {
            return DateTypes.YEAR;
        }
        if (periodType == specialChars[5]) {
            return DateTypes.QUARTER;
        }
        if (periodType == specialChars[4]) {
            return DateTypes.MONTH;
        }
        if (periodType == specialChars[3]) {
            return DateTypes.WEEK;
        }
        if (periodType == specialChars[2]) {
            return DateTypes.DATE;
        }
        if (periodType == specialChars[1]) {
            return DateTypes.HOUR;
        }
        if (periodType == specialChars[0]) {
            return DateTypes.MINUTE;
        }
        if (periodType == 'T') {
            return DateTypes.TIMESTAMP;
        }
        if (periodType == 't') {
            return DateTypes.TIME;
        }
        if (periodType == 'w') {
            return DateTypes.WEEKDAY;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getBusinessDateFormats(Locale locale) {
        ArrayList<String> formats = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String cacheKey = "BusinessDate" + locale.hashCode();
        Map map = formatCache;
        synchronized (map) {
            formats = (ArrayList<String>)formatCache.get(cacheKey);
            if (formats != null) {
                return formats;
            }
            formats = new ArrayList<String>();
            Collection formatCollection = null;
            formatCollection = NLInformats.getNLBusinessDateFormats(locale);
            for (NLFormats.FormatPattern formatPattern : formatCollection) {
                String pattern = formatPattern.pattern;
                formats.add(pattern);
            }
            formatCache.put(cacheKey, formats);
        }
        return formats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getFormats(DateTypes dateType, Locale locale) {
        ArrayList<String> formats = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String cacheKey = dateType.toString() + locale.hashCode();
        Map map = formatCache;
        synchronized (map) {
            formats = (ArrayList<String>)formatCache.get(cacheKey);
            if (formats != null) {
                return formats;
            }
            formats = new ArrayList<String>();
            Collection formatCollection = null;
            if (dateType == DateTypes.DATE) {
                formatCollection = NLInformats.getNLDateFormats(locale);
            } else if (dateType == DateTypes.TIME) {
                formatCollection = NLInformats.getNLTimeFormats(locale);
            } else if (dateType == DateTypes.TIMESTAMP) {
                formatCollection = NLInformats.getNLDateTimeFormats(locale);
            } else if (dateType == DateTypes.QUARTER) {
                formatCollection = NLInformats.getNLQuarterFormats(locale);
            } else if (dateType == DateTypes.MONTH) {
                formatCollection = NLInformats.getNLMonthYearFormats(locale);
            } else if (dateType == DateTypes.WEEK) {
                formatCollection = NLInformats.getNLWeekFormats(locale);
            } else if (dateType == DateTypes.YEAR) {
                formatCollection = NLInformats.getNLYearFormats(locale);
            }
            for (NLFormats.FormatPattern formatPattern : formatCollection) {
                String pattern = formatPattern.pattern;
                formats.add(pattern);
            }
            formatCache.put(cacheKey, formats);
        }
        return formats;
    }

    public static DatePeriod parseDatePeriod(String stringToParse, Locale locale) throws ParseException {
        return DatePeriod.parseDatePeriod(stringToParse, null, locale);
    }

    public static DatePeriod parseDatePeriod(String stringToParse, TimeZone timeZone, Locale locale) throws ParseException {
        DateTypes[] dateTypes = new DateTypes[]{DateTypes.YEAR, DateTypes.QUARTER, DateTypes.MONTH, DateTypes.WEEK, DateTypes.DATE, DateTypes.TIMESTAMP, DateTypes.TIME};
        return DatePeriod.parseDatePeriod(stringToParse, dateTypes, timeZone, locale);
    }

    private static boolean containsDateType(DateTypes[] dateTypes) {
        if (dateTypes != null) {
            for (int i = 0; i < dateTypes.length; ++i) {
                if (dateTypes[i] != DateTypes.DATE) continue;
                return true;
            }
        }
        return false;
    }

    public static DatePeriod parseDatePeriod(String stringToParse, DateTypes[] dateTypes, TimeZone timeZone, Locale locale) throws ParseException {
        DatePeriod dp = null;
        if (stringToParse != null) {
            stringToParse = stringToParse.trim();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((dp = DatePeriod.tryParsing(stringToParse, dateTypes, timeZone, locale)) == null) {
                if (!Locale.ENGLISH.equals(locale) && !Locale.US.equals(locale)) {
                    dp = DatePeriod.tryParsing(stringToParse, dateTypes, timeZone, Locale.ENGLISH);
                }
                if (dp == null && DatePeriod.containsDateType(dateTypes)) {
                    List formats = DatePeriod.getBusinessDateFormats(locale);
                    dp = DatePeriod.tryParsing(stringToParse, formats, DateTypes.DATE, timeZone, locale);
                }
            }
            if (dp == null && stringToParse.length() > 0) {
                char charPeriodType = stringToParse.charAt(0);
                DateTypes dateTypeForChar = DatePeriod.getDateTypesFor(charPeriodType);
                if (dateTypeForChar != null) {
                    DateTypes alignmentType;
                    dp = timeZone != null ? new DatePeriod(dateTypeForChar, timeZone, locale) : new DatePeriod(dateTypeForChar, locale);
                    int index = (stringToParse = stringToParse.substring(1)).indexOf(66);
                    if (index != -1) {
                        if (stringToParse.length() >= index + 2) {
                            alignmentType = DatePeriod.getDateTypesFor(stringToParse.charAt(index + 1));
                            dp.setAlignment(alignmentType, 1);
                        }
                        stringToParse = stringToParse.substring(0, index);
                    }
                    if ((index = stringToParse.indexOf(69)) != -1) {
                        if (stringToParse.length() >= index + 2) {
                            alignmentType = DatePeriod.getDateTypesFor(stringToParse.charAt(index + 1));
                            dp.setAlignment(alignmentType, 2);
                        }
                        stringToParse = stringToParse.substring(0, index);
                    }
                    String delims = new String(specialChars);
                    StringTokenizer st = new StringTokenizer(stringToParse, delims, true);
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken();
                        if (st.hasMoreTokens()) {
                            String delim = st.nextToken();
                            try {
                                int intValue = Integer.valueOf(value.trim());
                                DateTypes periodType = DatePeriod.getDateTypesFor(delim.charAt(0));
                                if (periodType == DateTypes.YEAR) {
                                    dp.setNYears(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.QUARTER) {
                                    dp.setNQuarters(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.MONTH) {
                                    dp.setNMonths(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.WEEK) {
                                    dp.setNWeeks(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.DATE) {
                                    dp.setNDays(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.HOUR) {
                                    dp.setNHours(intValue);
                                    continue;
                                }
                                if (periodType == DateTypes.MINUTE) {
                                    dp.setNMinutes(intValue);
                                    continue;
                                }
                                throw new ParseException(stringToParse, stringToParse.indexOf(delim));
                            }
                            catch (NumberFormatException ex) {
                                throw new ParseException(stringToParse, stringToParse.indexOf(value));
                            }
                        }
                        throw new ParseException(stringToParse, stringToParse.indexOf(value));
                    }
                } else {
                    throw new ParseException(stringToParse, 0);
                }
            }
        }
        return dp;
    }

    private static DatePeriod tryParsing(String stringToParse, DateTypes[] dateTypes, TimeZone timeZone, Locale locale) {
        Object date = null;
        String formatString = "";
        String parseString = stringToParse;
        for (int i = 0; i < dateTypes.length; ++i) {
            List formats = DatePeriod.getFormats(dateTypes[i], locale);
            DatePeriod dp = DatePeriod.tryParsing(stringToParse, formats, dateTypes[i], timeZone, locale);
            if (dp == null) continue;
            return dp;
        }
        return null;
    }

    private static DatePeriod tryParsing(String stringToParse, Collection formats, DateTypes type, TimeZone timeZone, Locale locale) {
        Date date = null;
        String formatString2 = "";
        String parseString = stringToParse;
        for (String formatString2 : formats) {
            Calendar cal = DataTypeUtil.getCalendar(timeZone, locale);
            ParsePosition position = new ParsePosition(0);
            if (type == DateTypes.QUARTER) {
                try {
                    date = NLFormats.parseQuarterString(parseString, position, locale, cal);
                }
                catch (ParseException e) {}
            } else {
                SimpleDateFormat format = new SimpleDateFormat(formatString2, locale);
                if (timeZone != null) {
                    format.setTimeZone(timeZone);
                }
                format.setCalendar(cal);
                if (type != DateTypes.WEEK) {
                    format.setLenient(false);
                }
                date = format.parse(parseString, position);
            }
            if (date == null || position.getErrorIndex() != -1 || position.getIndex() != parseString.length()) continue;
            if (timeZone != null) {
                return new DatePeriod(date, type, timeZone, locale);
            }
            return new DatePeriod(date, type, locale);
        }
        return null;
    }

    public int getNDays() {
        return this.nDays;
    }

    public void setNDays(int days) {
        if (this.nDays != days) {
            this.nDays = days;
            this.dirty = true;
        }
    }

    public int getNYears() {
        return this.nYears;
    }

    public void setNYears(int years) {
        if (this.nYears != years) {
            this.nYears = years;
            this.dirty = true;
        }
    }

    public int getNHours() {
        return this.nHours;
    }

    public void setNHours(int hours) {
        if (this.nHours != hours) {
            this.nHours = hours;
            this.dirty = true;
        }
    }

    public int getNMinutes() {
        return this.nMinutes;
    }

    public void setNMinutes(int minutes) {
        if (this.nMinutes != minutes) {
            this.nMinutes = minutes;
            this.dirty = true;
        }
    }

    public int getNMonths() {
        return this.nMonths;
    }

    public void setNMonths(int months) {
        if (this.nMonths != months) {
            this.nMonths = months;
            this.dirty = true;
        }
    }

    public int getNQuarters() {
        return this.nQuarters;
    }

    public void setNQuarters(int quarters) {
        if (this.nQuarters != quarters) {
            this.nQuarters = quarters;
            this.dirty = true;
        }
    }

    public int getNWeeks() {
        return this.nWeeks;
    }

    public void setNWeeks(int weeks) {
        if (this.nWeeks != weeks) {
            this.nWeeks = weeks;
            this.dirty = true;
        }
    }

    public boolean isRelativeDate() {
        return this.dateInPeriod == null;
    }

    @Override
    public int getDate() {
        return this.getField(5);
    }

    @Override
    public int getDay() {
        return this.getField(7) - 1;
    }

    @Override
    public int getHours() {
        return this.getField(11);
    }

    @Override
    public int getMinutes() {
        return this.getField(12);
    }

    @Override
    public int getMonth() {
        return this.getField(2);
    }

    @Override
    public int getSeconds() {
        return this.getField(13);
    }

    @Override
    public int getYear() {
        return this.getField(1) - 1900;
    }

    public int getWeek() {
        return this.getField(3);
    }

    public int getQuarter() {
        return this.getField(2) / 3 + 1;
    }

    public int getHour() {
        return this.getField(10);
    }

    public int getAMPM() {
        return this.getField(9);
    }

    private final int getField(int field) {
        Calendar cal = this.getCalendar();
        if (this.dateInPeriod == null) {
            Date start = this.getStartOfPeriod();
            cal.setTime(start);
            return cal.get(field);
        }
        cal.setTime(this.dateInPeriod);
        return cal.get(field);
    }

    @Override
    public void setDate(int date) {
        this.setField(5, date);
    }

    @Override
    public void setHours(int hours) {
        this.setField(11, hours);
    }

    @Override
    public void setMinutes(int minutes) {
        this.setField(12, minutes);
    }

    @Override
    public void setMonth(int month) {
        this.setField(2, month);
    }

    @Override
    public void setSeconds(int seconds) {
        this.setField(13, seconds);
    }

    @Override
    public void setYear(int year) {
        this.setField(1, year + 1900);
    }

    public void setWeek(int week) {
        this.setField(3, week);
    }

    public void setQuarter(int quarter) {
        this.setField(2, (quarter - 1) * 3);
    }

    public void setHour(int hour) {
        this.setField(10, hour);
    }

    public void setAMPM(int ampm) {
        this.setField(9, ampm);
    }

    private final void setField(int field, int value) {
        Calendar cal = this.getCalendar();
        if (this.dateInPeriod != null) {
            cal.setTime(this.dateInPeriod);
            cal.set(field, value);
            this.dateInPeriod = cal.getTime();
        } else {
            cal.set(field, value);
            this.dateInPeriod = cal.getTime();
        }
    }

    static {
        formatCache = Collections.synchronizedMap(new LinkedHashMap(1000, 0.75f, true));
    }
}

