/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BooleanType;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataSourceColumnType;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

@SASScope
public class AttributeConfigurationUtil {
    protected AttributeConfigurationUtil() {
    }

    public static String getStringOption(String optionName, Map options, Map context) {
        return (String)options.get(optionName);
    }

    public static int getIntOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (Integer)IntegerType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }

    public static Object getIntCollectionOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return CollectionType.DEFAULT_INSTANCE_INTEGER.coerceValue(value, Locale.US);
    }

    public static double getDoubleOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (Double)DoubleType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }

    public static boolean getBoolOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (Boolean)BooleanType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }

    public static Date getDateOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (Date)DateType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }

    public static DataSourceInterface getDataSourceOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (DataSourceInterface)DataSourceType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }

    public static DataSourceColumnInterface getDataSourceColumnOption(String optionName, Map options, Map context) {
        Object value = options.get(optionName);
        return (DataSourceColumnInterface)DataSourceColumnType.DEFAULT_INSTANCE.coerceValue(value, Locale.US);
    }
}

