/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

@SASScope(value="ALL")
@SubjectToChange
class TimeValue
extends SASDateTimeFormat {
    private static int SECONDS_PER_HOUR = 3600;
    private static int SECONDS_PER_MINUTE = 60;
    private static String TIMEAMPM = "TIMEAMPM";
    private static String NLTIM = "NLTIM";
    StringBuffer tb1 = new StringBuffer(10);
    StringBuffer tb2 = new StringBuffer(10);
    StringBuffer tb3 = new StringBuffer(10);
    private static Object[] timeValueFormats;

    protected TimeValue() {
    }

    @Override
    public StringBuffer format(Date value) {
        return this.format(this.javaDateToSASTime(value.getTime(), this.getTimeZone()));
    }

    @Override
    public StringBuffer format(double date) {
        StringBuffer result = null;
        String formatName = this.info.getBaseFormat();
        int width = this.info.getWidth();
        if (formatName.equals(TIMEAMPM) || formatName.startsWith(NLTIM)) {
            double rdate = this.round(date, this.info.isDecimalWidthSupported() ? this.info.getDValue() : 0);
            result = this.formatValue(this.SASTimeToJavaDate(rdate, this.getTimeZone()), false);
            if (result.length() > width) {
                int rlength = result.length();
                result.setCharAt(rlength - 6, ' ');
                result.setCharAt(rlength - 5, result.charAt(rlength - 2));
                result.setCharAt(rlength - 4, result.charAt(rlength - 1));
                result.setLength(rlength - 3);
            }
            if (this.info.isDecimalWidthSupported() && width > this.info.getDefaultWidth()) {
                int dvalue = this.info.getDValue();
                if (result.length() + dvalue + 1 > width) {
                    dvalue = width - (result.length() + 1);
                    rdate = this.round(date, dvalue);
                    result = this.formatValue(this.SASTimeToJavaDate(rdate, this.getTimeZone()), false);
                }
                if (dvalue > 0) {
                    double v2 = Math.floor(rdate);
                    String decimal = String.valueOf(v2 = this.round(rdate - v2, dvalue));
                    int startAt = decimal.indexOf(46);
                    if (startAt != -1) {
                        if (dvalue < (decimal = decimal.substring(startAt + 1, decimal.length())).length()) {
                            decimal = decimal.substring(0, dvalue);
                        }
                        int insertIndex = result.length() - 1;
                        while (!Character.isDigit(result.charAt(insertIndex))) {
                            --insertIndex;
                        }
                        result.insert(insertIndex + 1, "." + decimal);
                        this.insertTrailingZeros(result, dvalue - decimal.length());
                    }
                }
            }
        } else {
            double rdate = date;
            if (!this.info.isDecimalWidthSupported()) {
                rdate = this.round(rdate, 0);
            }
            char c = formatName.charAt(1);
            switch (c) {
                case 'O': 
                case 'o': {
                    result = this.formatHOUR(rdate, width);
                    break;
                }
                case 'M': 
                case 'm': {
                    result = this.formatMMSS(rdate, width);
                    break;
                }
                case 'H': 
                case 'h': {
                    result = this.formatHHMM(rdate, width);
                    break;
                }
                case 'I': 
                case 'L': 
                case 'i': 
                case 'l': {
                    result = this.formatTIME(rdate, width);
                }
            }
        }
        this.insertLeadingBlanks(result);
        return result;
    }

    private StringBuffer formatTIME(double value, int width) {
        String sign = "";
        if (value < 0.0) {
            sign = "-";
            --width;
            value = -1.0 * value;
        }
        StringBuffer result = new StringBuffer(25);
        StringBuffer mbuf = this.tb1;
        StringBuffer sbuf = this.tb2;
        StringBuffer fbuf = this.tb3;
        result.append(sign);
        result.append((int)value / SECONDS_PER_HOUR);
        mbuf.setLength(0);
        sbuf.setLength(0);
        fbuf.setLength(0);
        if (this.info.isDecimalWidthSupported()) {
            int availableDecimalWidth = width - (result.length() + 7);
            value = availableDecimalWidth > 0 ? this.round(value, Math.min(availableDecimalWidth, this.info.getDValue())) : this.round(value, 0);
            result.setLength(0);
            result.append(sign);
            result.append((int)value / SECONDS_PER_HOUR);
            if (availableDecimalWidth > 0) {
                availableDecimalWidth = width - (result.length() + 7);
                int decimalWidth = Math.min(availableDecimalWidth, this.info.getDValue());
                fbuf.append(this.round(value - (double)((int)value), decimalWidth));
                for (int i = 0; i < fbuf.length(); ++i) {
                    if (i + 2 < fbuf.length()) {
                        fbuf.setCharAt(i, fbuf.charAt(i + 2));
                        continue;
                    }
                    fbuf.setCharAt(i, '0');
                }
                if (decimalWidth > fbuf.length()) {
                    int deff = decimalWidth - fbuf.length();
                    for (int i = 0; i < deff; ++i) {
                        fbuf.append('0');
                    }
                }
                fbuf.setLength(decimalWidth);
            }
        }
        mbuf.append((int)value % SECONDS_PER_HOUR / SECONDS_PER_MINUTE);
        if (mbuf.length() == 1) {
            mbuf.insert(0, '0');
        }
        sbuf.append((int)value % SECONDS_PER_HOUR % SECONDS_PER_MINUTE);
        if (sbuf.length() == 1) {
            sbuf.insert(0, '0');
        }
        if (result.length() > width) {
            this.asteriskArray(result);
        } else if (result.length() + sbuf.length() + 1 <= width) {
            result.append(':');
            result.append(mbuf);
            if (result.length() + sbuf.length() + 1 <= width) {
                result.append(':');
                result.append(sbuf);
                if (fbuf.length() > 0 && result.length() + fbuf.length() + 1 <= width) {
                    result.append('.');
                    result.append(fbuf);
                }
            }
        }
        return result;
    }

    private StringBuffer formatMMSS(double value, int width) {
        StringBuffer result = new StringBuffer(25);
        StringBuffer sbuf = this.tb1;
        StringBuffer fbuf = this.tb2;
        int minutes = (int)value / SECONDS_PER_MINUTE;
        if (minutes == 0 && Double.compare(value, 0.0) < 0) {
            result.append('-');
        }
        result.append(minutes);
        sbuf.setLength(0);
        fbuf.setLength(0);
        if (this.info.isDecimalWidthSupported()) {
            int availableDecimalWidth = width - (result.length() + 4);
            value = availableDecimalWidth > 0 ? this.round(value, Math.min(availableDecimalWidth, this.info.getDValue())) : this.round(value, 0);
            minutes = (int)value / SECONDS_PER_MINUTE;
            result.setLength(0);
            result.append(minutes);
            if (availableDecimalWidth > 0) {
                availableDecimalWidth = width - (result.length() + 4);
                int decimalWidth = Math.min(availableDecimalWidth, this.info.getDValue());
                fbuf.append(this.round(value - (double)((int)value), decimalWidth));
                for (int i = 0; i < decimalWidth; ++i) {
                    if (i + 2 < fbuf.length()) {
                        fbuf.setCharAt(i, fbuf.charAt(i + 2));
                        continue;
                    }
                    fbuf.setCharAt(i, '0');
                }
                fbuf.setLength(decimalWidth);
            }
        }
        sbuf.append(Math.abs((int)value % SECONDS_PER_MINUTE));
        if (sbuf.length() == 1) {
            sbuf.insert(0, '0');
        }
        if (result.length() > width) {
            this.asteriskArray(result);
        } else if (result.length() + sbuf.length() + 1 <= width) {
            result.append(':');
            result.append(sbuf);
            if (fbuf.length() > 0 && result.length() + fbuf.length() + 1 <= width) {
                result.append('.');
                result.append(fbuf);
            }
        }
        return result;
    }

    private StringBuffer formatHOUR(double value, int width) {
        StringBuffer result = new StringBuffer(25);
        StringBuffer fractionBuffer = this.tb1;
        int hours = (int)value / SECONDS_PER_HOUR;
        double fraction = value % (double)SECONDS_PER_HOUR;
        result.append(hours);
        fractionBuffer.setLength(0);
        if (this.info.isDecimalWidthSupported()) {
            fraction /= (double)SECONDS_PER_HOUR;
            int availableDecimalWidth = width - (result.length() + 1);
            if (availableDecimalWidth > 0) {
                int decimalWidth = Math.min(availableDecimalWidth, this.info.getDValue());
                if ((fraction = this.round(fraction, decimalWidth)) == 1.0) {
                    result.setLength(0);
                    result.append(++hours);
                    availableDecimalWidth = width - (result.length() + 1);
                    decimalWidth = Math.min(availableDecimalWidth, decimalWidth);
                    for (int i = 0; i < decimalWidth; ++i) {
                        fractionBuffer.append('0');
                    }
                } else {
                    String temp = String.valueOf(fraction);
                    for (int i = 0; i < decimalWidth; ++i) {
                        if (i + 2 < temp.length()) {
                            fractionBuffer.append(temp.charAt(i + 2));
                            continue;
                        }
                        fractionBuffer.append('0');
                    }
                }
            }
        } else if (fraction >= 1800.0) {
            ++hours;
        }
        result.setLength(0);
        result.append(hours);
        if (result.length() > width) {
            this.asteriskArray(result);
        } else if (fractionBuffer.length() > 0) {
            result.append('.');
            result.append(fractionBuffer);
        }
        return result;
    }

    private StringBuffer formatHHMM(double value, int width) {
        int availableDecimalWidth;
        StringBuffer result = new StringBuffer(25);
        StringBuffer mbuf = this.tb1;
        StringBuffer fbuf = this.tb2;
        int hours = (int)value / SECONDS_PER_HOUR;
        int minutes = (int)value % SECONDS_PER_HOUR / SECONDS_PER_MINUTE;
        double fraction = (int)value % SECONDS_PER_HOUR % SECONDS_PER_MINUTE;
        result.append(hours);
        mbuf.setLength(0);
        fbuf.setLength(0);
        if (this.info.isDecimalWidthSupported() && (availableDecimalWidth = width - (result.length() + 4)) > 0) {
            fraction /= (double)SECONDS_PER_MINUTE;
            if ((fraction = this.round(fraction, Math.min(availableDecimalWidth, this.info.getDValue()))) == 1.0) {
                if (++minutes == 60) {
                    minutes = 0;
                    ++hours;
                }
                fraction = 0.0;
            }
        }
        if (fraction >= 30.0 && ++minutes == 60) {
            ++hours;
            minutes = 0;
        }
        result.setLength(0);
        if (hours == 0 && Double.compare(minutes, 0.0) < 0) {
            result.append('-');
        }
        result.append(hours);
        mbuf.append(Math.abs(minutes));
        if (mbuf.length() == 1) {
            mbuf.insert(0, '0');
        }
        if (result.length() > width) {
            this.asteriskArray(result);
        } else if (result.length() + mbuf.length() + 1 <= width) {
            result.append(':');
            result.append(mbuf);
            int decimalWidth = Math.min(width - (result.length() + 1), this.info.getDValue());
            if (this.info.isDecimalWidthSupported() && decimalWidth > 0) {
                fbuf.setLength(0);
                fbuf.append(fraction);
                for (int i = 0; i < decimalWidth; ++i) {
                    if (i + 2 < fbuf.length()) {
                        fbuf.setCharAt(i, fbuf.charAt(i + 2));
                        continue;
                    }
                    fbuf.setCharAt(i, '0');
                }
                fbuf.setLength(decimalWidth);
                result.append('.');
                result.append(fbuf);
            }
        }
        return result;
    }

    private void asteriskArray(StringBuffer result) {
        result.setLength(0);
        int width = this.info.getWidth();
        for (int i = 0; i < width; ++i) {
            result.append('*');
        }
    }

    @Override
    public boolean isTimeFormat() {
        return true;
    }

    @Override
    public double convertFromJavaDate(long javaDate) {
        return this.javaDateToSASTime(javaDate, this.getTimeZone());
    }

    @Override
    public long convertToJavaDate(double sasTime) {
        return this.SASTimeToJavaDate(sasTime, this.getTimeZone());
    }

    static Object[] getDefinedFormats(Locale locale) {
        Vector<SingleEntry> temp = new Vector<SingleEntry>(5, 1);
        String className = TimeValue.class.getName();
        SingleEntry entry = new SingleEntry("HHMMw.d", className);
        ((SASFormatEntry)entry).addPattern(5, 20, null, true);
        ((SASFormatEntry)entry).addPattern(2, 4, null);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("HOURw.d", className);
        ((SASFormatEntry)entry).addPattern(2, 20, null, true);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("MMSSw.d", className);
        ((SASFormatEntry)entry).addPattern(5, 20, null, true);
        ((SASFormatEntry)entry).addPattern(2, 4, null);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("TIMEw.d", className);
        ((SASFormatEntry)entry).addPattern(8, 20, null, true);
        ((SASFormatEntry)entry).addPattern(2, 7, null);
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("TIMEAMPMw.d", className);
        ((SASFormatEntry)entry).addPattern(11, 20, "h:mm:ss a", true);
        ((SASFormatEntry)entry).addPattern(2, 4, "a");
        ((SASFormatEntry)entry).addPattern(5, 6, "h a");
        ((SASFormatEntry)entry).addPattern(7, 9, "h:mm a");
        ((SASFormatEntry)entry).addPattern(10, 10, "h:mm:ss a");
        entry.setFormatLocale(Locale.US);
        temp.addElement(entry);
        entry = new SingleEntry("NLTIMEw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(20, 200, "t", true);
        ((SASFormatEntry)entry).addResourceString(10, 20, "t");
        temp.addElement(entry);
        entry = new SingleEntry("NLTIMAPw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addResourceString(4, 200, 10, new String[]{"t_ap", "t_ap_s"});
        temp.addElement(entry);
        timeValueFormats = new Object[temp.size()];
        temp.copyInto(timeValueFormats);
        return timeValueFormats;
    }
}

