/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.net.BaseResourceLocator;
import com.sas.net.ResourceLocatorInterface;
import com.sas.util.Util;
import java.net.MalformedURLException;
import java.net.URL;

public class ContextResourceLocator
extends BaseResourceLocator
implements ResourceLocatorInterface {
    static final long serialVersionUID = -507629717298299238L;
    protected URL _context;

    public ContextResourceLocator() {
    }

    public ContextResourceLocator(String resourceName) {
        super(resourceName);
    }

    public URL getContext() {
        return this._context;
    }

    public void setContext(URL newValue) {
        if (!Util.equal(this._context, newValue)) {
            URL oldValue = this._context;
            this._context = newValue;
            this.firePropertyChange("context", oldValue, newValue);
        }
    }

    @Override
    public URL getResource() throws MalformedURLException {
        return new URL(this.getContext(), this.getResourceName());
    }

    @Override
    public String encode() {
        return new String("Context: ~<" + this.getContext() + ">~ ~<" + this.getResourceName() + ">~");
    }

    public static ResourceLocatorInterface decode(String resource) {
        ContextResourceLocator crl = new ContextResourceLocator();
        if (resource.startsWith("Context: ")) {
            int index = resource.indexOf(">~");
            if (index != -1) {
                try {
                    crl.setContext(new URL(resource.substring(11, index)));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                crl.setResourceName(resource.substring(index + 5, resource.length() - 2));
            }
            return crl;
        }
        return null;
    }

    @Override
    protected ResourceLocatorInterface createInstance(String resource) {
        return ContextResourceLocator.decode(resource);
    }
}

