/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.crypto.SealedString;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.Credential;
import java.util.Arrays;
import java.util.Locale;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PasswordCredential
extends Credential {
    private static final long serialVersionUID = -7129081732710136136L;
    private String _userName;
    private SealedString _passwordAsSealedString;

    public PasswordCredential(String userName, String password, String domain) {
        super(domain);
        this.setUserName(userName);
        this.setPassword(password);
    }

    public PasswordCredential(String userName, String password) {
        this(userName, password, null);
    }

    protected PasswordCredential(String domain) {
        super(domain);
    }

    public static PasswordCredential newInstance(String userName, SealedString passwordAsSealedString, String domain) {
        PasswordCredential cred = new PasswordCredential(domain);
        cred.setUserName(userName);
        cred.setPasswordAsSealedString(passwordAsSealedString);
        return cred;
    }

    public static PasswordCredential newInstance(String userName, char[] passwordAsChars, String domain) {
        PasswordCredential cred = new PasswordCredential(domain);
        cred.setUserName(userName);
        cred.setPasswordAsChars(passwordAsChars);
        return cred;
    }

    public synchronized void setUserName(String userName) {
        this._userName = userName != null ? userName : "";
    }

    public synchronized String getUserName() {
        return this._userName;
    }

    public synchronized void setPassword(String password) {
        SealedString passwordAsSealedString = new SealedString(password != null ? password : "");
        this.setPasswordAsSealedString(passwordAsSealedString);
    }

    public synchronized void setPasswordAsSealedString(SealedString passwordAsSealedString) {
        this._passwordAsSealedString = passwordAsSealedString != null ? passwordAsSealedString : new SealedString("");
    }

    public synchronized void setPasswordAsChars(char[] passwordAsChars) {
        SealedString passwordAsSealedString = new SealedString(passwordAsChars != null ? passwordAsChars : "".toCharArray());
        this.setPasswordAsSealedString(passwordAsSealedString);
    }

    public synchronized String getPassword() {
        SealedString passwordAsSealedString = this.getPasswordAsSealedString();
        char[] passwordAsChars = passwordAsSealedString.getCharacters();
        String password = new String(passwordAsChars);
        PasswordCredential.clearCharArray(passwordAsChars);
        return password;
    }

    public synchronized SealedString getPasswordAsSealedString() {
        if (this._passwordAsSealedString == null) {
            throw new IllegalStateException("password cannot be null");
        }
        return this._passwordAsSealedString;
    }

    public synchronized char[] getPasswordAsChars() {
        SealedString passwordAsSealedString = this.getPasswordAsSealedString();
        return passwordAsSealedString.getCharacters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        PasswordCredential thatPasswordCredential = (PasswordCredential)that;
        String thatUserName = thatPasswordCredential.getUserName();
        if (!this._userName.equals(thatUserName)) {
            return false;
        }
        char[] passwordAsChars = this.getPasswordAsChars();
        char[] thatPasswordAsChars = thatPasswordCredential.getPasswordAsChars();
        try {
            if (!Arrays.equals(passwordAsChars, thatPasswordAsChars)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            PasswordCredential.clearCharArray(passwordAsChars);
            PasswordCredential.clearCharArray(thatPasswordAsChars);
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        int hc = super.hashCode();
        hc ^= this._userName.hashCode();
        char[] passwordAsChars = this.getPasswordAsChars();
        PasswordCredential.clearCharArray(passwordAsChars);
        return hc ^= Arrays.hashCode(passwordAsChars);
    }

    public synchronized String toString() {
        Locale locale = this.getLocale();
        String localeS = locale != null ? locale.toString() : "";
        String[][] nvPairArr = new String[][]{{"domain", this.getDomain()}, {"username", this.getUserName()}, {"locale", localeS}};
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }

    private static void clearCharArray(char[] chars) {
        Arrays.fill(chars, '\u0000');
    }
}

