/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactoryException;
import com.sas.iom.WorkspacePoolCookie;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.net.util.WriterHandler;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.jndi.JNDIConnectionFactoryConfiguration;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

@SASScope
public final class WorkspacePool {
    private static Map poolTable = new HashMap();
    private static Map poolTable2 = new WeakHashMap();
    private static Map contextTable = new HashMap();
    WeakReference cookieRef = null;
    ConnectionFactoryConfiguration cxfConfig = null;
    ConnectionFactoryInterface cxf = null;
    Set connectorRefSet = new HashSet();

    private WorkspacePool(WorkspacePoolCookie cookie, ConnectionFactoryConfiguration cxfConfig, ConnectionFactoryInterface cxf) {
        this.cookieRef = new WeakReference<WorkspacePoolCookie>(cookie);
        this.cxfConfig = cxfConfig;
        this.cxf = cxf;
    }

    protected WorkspacePoolCookie getCookie() {
        return (WorkspacePoolCookie)this.cookieRef.get();
    }

    protected ConnectionFactoryConfiguration getConfig() {
        return this.cxfConfig;
    }

    protected Set getConnectorRefSet() {
        return this.connectorRefSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WorkspacePoolCookie startPool(ConnectionFactoryConfiguration cxfConfig, PrintWriter logWriter) throws WorkspaceFactoryException {
        Map map = poolTable;
        synchronized (map) {
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            String loggerName = ORBImpl.class.getPackage().getName();
            WorkspacePool.configLogger(loggerName, logWriter, 0);
            int hc = cxfConfig.hashCode();
            WorkspacePoolCookie cookie = new WorkspacePoolCookie(hc);
            ConnectionFactoryInterface cxf = null;
            try {
                cxf = cxfManager.getFactory(cxfConfig);
            }
            catch (ConnectionFactoryException cfe) {
                throw new WorkspaceFactoryException(cfe);
            }
            WorkspacePool pool = new WorkspacePool(cookie, cxfConfig, cxf);
            poolTable.put(cookie, pool);
            poolTable2.put(cookie, pool);
            return cookie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WorkspacePoolCookie matchPool(String userDN, String userPassword, Hashtable repositoryProperties, String baseDN, String logicalName) {
        Map map = poolTable;
        synchronized (map) {
            Set poolSet = poolTable.entrySet();
            for (Map.Entry poolEntry : poolSet) {
                JNDIConnectionFactoryConfiguration jndiConfig;
                WorkspacePool pool = (WorkspacePool)poolEntry.getValue();
                ConnectionFactoryConfiguration thatConfig = pool.getConfig();
                if (!(thatConfig instanceof JNDIConnectionFactoryConfiguration) || !WorkspacePool.matchConfigs(jndiConfig = (JNDIConnectionFactoryConfiguration)thatConfig, repositoryProperties, baseDN, logicalName)) continue;
                if (jndiConfig.isUserAuth()) {
                    try {
                        WorkspaceConnector connector = pool.getConnector(userDN, userPassword, 0L);
                        connector.close();
                    }
                    catch (WorkspaceFactoryException wfe) {
                        continue;
                    }
                }
                WorkspacePoolCookie cookie = pool.getCookie();
                return cookie;
            }
            return null;
        }
    }

    protected static WorkspacePool lookupPool(WorkspacePoolCookie cookie) throws WorkspaceFactoryException {
        return (WorkspacePool)poolTable2.get(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WorkspaceConnector getConnectorByUUID(String userDN, String userPassword, String uuid) throws WorkspaceFactoryException {
        Map map = poolTable;
        synchronized (map) {
            Set poolSet = poolTable.entrySet();
            for (Map.Entry poolEntry : poolSet) {
                Set connectorRefSet;
                WorkspacePool pool = (WorkspacePool)poolEntry.getValue();
                Set set = connectorRefSet = pool.getConnectorRefSet();
                synchronized (set) {
                    for (WeakReference connectorRef : connectorRefSet) {
                        WorkspaceConnector connector;
                        IWorkspace iWorkspace;
                        String ui;
                        java.lang.Object obj = connectorRef.get();
                        if (obj == null || !uuid.equals(ui = (iWorkspace = (connector = (WorkspaceConnector)obj).getWorkspace()).UniqueIdentifier())) continue;
                        ConnectionFactoryConfiguration cxfConfig = pool.getConfig();
                        if (cxfConfig instanceof JNDIConnectionFactoryConfiguration && ((JNDIConnectionFactoryConfiguration)cxfConfig).isUserAuth()) {
                            try {
                                WorkspaceConnector wc = pool.getConnector(userDN, userPassword, 0L);
                                wc.close();
                            }
                            catch (WorkspaceFactoryException wfe) {
                                return null;
                            }
                        }
                        return connector;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceConnector getConnector(String userDN, String password, long waitMilliseconds) throws WorkspaceFactoryException {
        ConnectionInterface cx = null;
        try {
            cx = this.cxf.getConnection(userDN, password, waitMilliseconds);
        }
        catch (ConnectionFactoryException cfe) {
            throw new WorkspaceFactoryException(cfe);
        }
        IWorkspace iWorkspace = null;
        try {
            Object obj = cx.getObject();
            iWorkspace = IWorkspaceHelper.narrow(obj);
        }
        catch (SystemException se) {
            throw new WorkspaceFactoryException(se);
        }
        WorkspaceConnector connector = new WorkspaceConnector(this, cx, iWorkspace);
        Set set = this.connectorRefSet;
        synchronized (set) {
            this.connectorRefSet.add(new WeakReference<WorkspaceConnector>(connector));
        }
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void stashContext(WorkspacePoolCookie cookie, DirContext ctx) {
        Map map = contextTable;
        synchronized (map) {
            contextTable.put(cookie, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DirContext removeContext(WorkspacePoolCookie cookie) {
        Map map = contextTable;
        synchronized (map) {
            return (DirContext)contextTable.remove(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnector(WorkspaceConnector connector) {
        Set set = this.connectorRefSet;
        synchronized (set) {
            Iterator connectorRefItor = this.connectorRefSet.iterator();
            while (connectorRefItor.hasNext()) {
                WeakReference connectorRef = (WeakReference)connectorRefItor.next();
                java.lang.Object obj = connectorRef.get();
                if (obj != connector) continue;
                connectorRefItor.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(String adminDN, String adminPassword) throws WorkspaceFactoryException {
        Map map = poolTable;
        synchronized (map) {
            try {
                ConnectionFactoryAdminInterface cxfAdmin = this.cxf.getAdminInterface(adminDN, adminPassword);
                cxfAdmin.shutdown();
            }
            catch (ConnectionFactoryException cfe) {
                throw new WorkspaceFactoryException(cfe);
            }
            WorkspacePoolCookie cookie = this.getCookie();
            poolTable.remove(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(String adminDN, String adminPassword) throws WorkspaceFactoryException {
        Map map = poolTable;
        synchronized (map) {
            try {
                ConnectionFactoryAdminInterface cxfAdmin = this.cxf.getAdminInterface(adminDN, adminPassword);
                cxfAdmin.destroy();
            }
            catch (ConnectionFactoryException cfe) {
                throw new WorkspaceFactoryException(cfe);
            }
            WorkspacePoolCookie cookie = this.getCookie();
            poolTable.remove(cookie);
            poolTable2.remove(cookie);
        }
    }

    protected static void configLogger(String loggerName, final PrintWriter logWriter, int debugLevel) {
        final Logger logger = Logger.getLogger(loggerName);
        final int dl = debugLevel > 3 ? 3 : debugLevel;
        PrivilegedAction action = new PrivilegedAction(){

            public java.lang.Object run() {
                if (logWriter != null) {
                    WriterHandler handler = new WriterHandler((Writer)logWriter);
                    logger.addHandler((Handler)handler);
                    Level level = null;
                    switch (dl) {
                        case 1: {
                            level = Level.FINE;
                            break;
                        }
                        case 2: {
                            level = Level.FINER;
                            break;
                        }
                        case 3: {
                            level = Level.FINEST;
                            break;
                        }
                        default: {
                            level = Level.INFO;
                        }
                    }
                    handler.setLevel(level);
                    if (!logger.isLoggable(level)) {
                        logger.setLevel(level);
                    }
                }
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static boolean matchConfigs(JNDIConnectionFactoryConfiguration thatConfig, Hashtable env, String baseDN, String logicalName) {
        String thatBaseDN;
        Hashtable<?, ?> thatEnv = null;
        try {
            DirContext thatCtx = thatConfig.getContext();
            thatEnv = thatCtx.getEnvironment();
        }
        catch (NamingException ne) {
            return false;
        }
        if (env != thatEnv) {
            if (env == null || thatEnv == null) {
                return false;
            }
            String thisFact = (String)env.get("java.naming.factory.initial");
            String thatFact = (String)thatEnv.get("java.naming.factory.initial");
            if (thisFact == null ? thatFact != null : !thisFact.equals(thatFact)) {
                return false;
            }
            String thisProv = (String)env.get("java.naming.provider.url");
            String thatProv = (String)thatEnv.get("java.naming.provider.url");
            if (thisProv == null ? thatProv != null : !thisProv.equals(thatProv)) {
                return false;
            }
            String thisDNS = (String)env.get("java.naming.dns.url");
            String thatDNS = (String)thatEnv.get("java.naming.dns.url");
            if (thisDNS == null ? thatDNS != null : !thisDNS.equals(thatDNS)) {
                return false;
            }
            String thisObjFact = (String)env.get("java.naming.factory.object");
            String thatObjFact = (String)thatEnv.get("java.naming.factory.object");
            if (thisObjFact == null ? thatObjFact != null : !thisObjFact.equals(thatObjFact)) {
                return false;
            }
            String thisPre = (String)env.get("java.naming.factory.url.pkgs");
            String thatPre = (String)thatEnv.get("java.naming.factory.url.pkgs");
            if (thisPre == null ? thatPre != null : !thisPre.equals(thatPre)) {
                return false;
            }
        }
        if (baseDN != (thatBaseDN = thatConfig.getBaseDN())) {
            String normThat;
            if (baseDN == null || thatBaseDN == null) {
                return false;
            }
            String normThis = JNDIConnectionFactoryConfiguration.normalizeDN(baseDN);
            if (!normThis.equals(normThat = JNDIConnectionFactoryConfiguration.normalizeDN(thatBaseDN))) {
                return false;
            }
        }
        String thatLogicalName = thatConfig.getLogicalName();
        return !(logicalName == null ? thatLogicalName != null : !logicalName.equals(thatLogicalName));
    }
}

