from typing import List
import warnings


"""
https://universaldependencies.org/tagset-conversion/de-smor-uposf.html
"""
db_smor_conllu = {
    "<+ADJ><Comp>": {"upos": "ADJ", "Degree": "Cmp"},
    "<+ADJ><Comp><Adv>": {"upos": "ADJ", "Degree": "Cmp"},
    "<+ADJ><Comp><Fem><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Gen><Sg><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Gen><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Fem><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Masc><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Acc><Sg><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Acc><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><Neut><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Comp><NoGend><Acc><Pl>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Acc><Pl><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Acc><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Dat><Pl>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Number": "Sing",
    },
    "<+ADJ><Comp><NoGend><Dat><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Cmp",
        "Number": "Sing",
    },
    "<+ADJ><Comp><NoGend><Gen><Pl>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Gen><Pl><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Gen><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Nom><Pl>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Nom><Pl><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><NoGend><Nom><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Cmp",
        "Number": "Plur",
    },
    "<+ADJ><Comp><Pred>": {"upos": "ADJ", "Degree": "Cmp"},
    "<+ADJ><Pos>": {"upos": "ADJ", "Degree": "Pos"},
    "<+ADJ><Pos><Adv>": {"upos": "ADJ", "Degree": "Pos"},
    "<+ADJ><Pos><Fem><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Gen><Sg><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Gen><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Fem><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Invar>": {"upos": "ADJ", "Degree": "Pos"},
    "<+ADJ><Pos><Masc><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Masc><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Acc><Sg><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Acc><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><Neut><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Pos><NoGend><Acc><Pl>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Acc><Pl><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Acc><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Dat><Pl>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Number": "Sing",
    },
    "<+ADJ><Pos><NoGend><Dat><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Pos",
        "Number": "Sing",
    },
    "<+ADJ><Pos><NoGend><Gen><Pl>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Gen><Pl><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Gen><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Nom><Pl>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Nom><Pl><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><NoGend><Nom><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Pos",
        "Number": "Plur",
    },
    "<+ADJ><Pos><Pred>": {"upos": "ADJ", "Degree": "Pos"},
    "<+ADJ><Sup>": {"upos": "ADJ", "Degree": "Sup"},
    "<+ADJ><Sup><Adv>": {"upos": "ADJ", "Degree": "Sup"},
    "<+ADJ><Sup><Fem><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Gen><Sg><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Gen><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Fem><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Masc><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Acc><Sg><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Acc><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><Neut><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+ADJ><Sup><NoGend><Acc><Pl>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Acc><Pl><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Acc><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Dat><Pl>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Number": "Sing",
    },
    "<+ADJ><Sup><NoGend><Dat><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Degree": "Sup",
        "Number": "Sing",
    },
    "<+ADJ><Sup><NoGend><Gen><Pl>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Gen><Pl><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Gen><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Nom><Pl>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Nom><Pl><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><NoGend><Nom><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Degree": "Sup",
        "Number": "Plur",
    },
    "<+ADJ><Sup><Pred>": {"upos": "ADJ", "Degree": "Sup"},
    "<+ADV>": {"upos": "ADV"},
    "<+ART><Def><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Fem><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Masc><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><Neut><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Acc><Pl>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Acc><Pl><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Dat><Pl>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Dat><Pl><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Nom><Pl>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Def><NoGend><Nom><Pl><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Def",
        "Number": "Plur",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Fem><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Masc><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Acc><Sg><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+ART><Indef><Neut><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Definite": "Ind",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Art",
    },
    "<+CARD><Attr><Masc><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Attr><Masc><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Attr><Neut><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Attr><Neut><Acc><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Attr><Neut><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Attr><Neut><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Fem><Acc><Sg>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Fem><Dat><Sg>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Fem><Gen><Sg>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Fem><Nom><Sg>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Masc><Acc><Sg>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Masc><Dat><Sg>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Masc><Gen><Sg>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Masc><Nom><Sg>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Neut><Acc><Sg>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Neut><Dat><Sg>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Neut><Gen><Sg>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Neut><Nom><Sg>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Acc><Pl>": {
        "upos": "NUM",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Dat><Pl>": {
        "upos": "NUM",
        "Case": "Dat",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Dat><Sg>": {
        "upos": "NUM",
        "Case": "Dat",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Gen><Pl>": {
        "upos": "NUM",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Gen><Sg>": {
        "upos": "NUM",
        "Case": "Gen",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><NoGend><Nom><Pl>": {
        "upos": "NUM",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Pro><Fem><Acc><Sg>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Fem><Dat><Sg><St>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Fem><Gen><Sg><St>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Fem><Nom><Sg>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Masc><Acc><Sg>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Masc><Dat><Sg><St>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Masc><Gen><Sg><St>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Masc><Nom><Sg><Wk>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Neut><Acc><Sg><Wk>": {
        "upos": "NUM",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Neut><Dat><Sg><St>": {
        "upos": "NUM",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Neut><Gen><Sg><St>": {
        "upos": "NUM",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><Neut><Nom><Sg><Wk>": {
        "upos": "NUM",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Acc><Pl><Wk>": {
        "upos": "NUM",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Dat><Pl><Wk>": {
        "upos": "NUM",
        "Case": "Dat",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Dat><Sg><Wk>": {
        "upos": "NUM",
        "Case": "Dat",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Gen><Pl><St>": {
        "upos": "NUM",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Gen><Pl><Wk>": {
        "upos": "NUM",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Gen><Sg><Wk>": {
        "upos": "NUM",
        "Case": "Gen",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Pro><NoGend><Nom><Pl><Wk>": {
        "upos": "NUM",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><Masc><Nom><Sg>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><Masc><Nom><Sg><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><Neut><Acc><Sg>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><Neut><Acc><Sg><St>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><Neut><Nom><Sg>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><Neut><Nom><Sg><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Acc><Pl>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Acc><Pl><St>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Dat><Pl>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Dat><Pl><St>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Nom><Pl>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CARD><Subst><NoGend><Nom><Pl><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Card",
    },
    "<+CONJ><Compar>": {"upos": "CCONJ", "ConjType": "Comp"},
    "<+CONJ><Coord>": {"upos": "CCONJ"},
    "<+CONJ><Sub>": {"upos": "SCONJ"},
    "<+DEM><Attr><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Fem><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Acc><Sg><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Masc><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><Neut><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Acc><Pl>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Acc><Pl><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Acc><Pl><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Dat><Pl>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Dat><Pl><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Dat><Pl><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Dat><Sg><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Gen><Pl><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Gen><Sg><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Nom><Pl>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Nom><Pl><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Attr><NoGend><Nom><Pl><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Fem><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Acc><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Masc><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><Neut><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Acc><Pl>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Acc><Pl><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Acc><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Dat><Pl>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Dat><Pl><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Dat><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Dat><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Gen><Pl>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Gen><Pl><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Gen><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Gen><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Nom><Pl>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Nom><Pl><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+DEM><Subst><NoGend><Nom><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Dem",
    },
    "<+INDEF><Attr>": {"upos": "DET", "PronType": "Ind"},
    "<+INDEF><Attr><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Fem><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Invar>": {"upos": "DET", "PronType": "Ind"},
    "<+INDEF><Attr><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Masc><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Acc><Sg><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><Neut><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Acc><Pl>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Acc><Pl><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Acc><Pl><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Dat><Pl>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Dat><Pl><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Dat><Pl><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Dat><Sg><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Gen><Pl><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Gen><Sg><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Nom><Pl>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Nom><Pl><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Attr><NoGend><Nom><Pl><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst>": {"upos": "PRON", "PronType": "Ind"},
    "<+INDEF><Subst><Fem><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Fem><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Invar>": {"upos": "PRON", "PronType": "Ind"},
    "<+INDEF><Subst><Masc><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Masc><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Acc><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><Neut><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Acc><Pl>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Acc><Pl><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Acc><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Pl>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Pl><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Dat><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Gen><Pl>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Gen><Pl><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Gen><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Gen><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Nom><Pl>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Nom><Pl><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Nom><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INDEF><Subst><NoGend><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Ind",
    },
    "<+INTJ>": {"upos": "INTJ"},
    "<+NN><Fem><Acc><Pl>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "<+NN><Fem><Acc><Sg>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Dat><Pl>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "<+NN><Fem><Dat><Sg>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Dat><Sg><St>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Gen><Pl>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "<+NN><Fem><Gen><Sg>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Gen><Sg><St>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Gen><Sg><Wk>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Fem><Nom><Pl>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Plur",
    },
    "<+NN><Fem><Nom><Sg>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NN><Masc><Acc><Pl>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Acc><Pl><St>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Acc><Pl><Wk>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Acc><Sg>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Acc><Sg><Simp>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Variant": "Short",
    },
    "<+NN><Masc><Dat><Pl>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Dat><Sg>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Dat><Sg><Old>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Style": "Arch",
    },
    "<+NN><Masc><Dat><Sg><Simp>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Variant": "Short",
    },
    "<+NN><Masc><Dat><Sg><St>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Dat><Sg><Wk>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Gen><Pl>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Gen><Pl><St>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Gen><Pl><Wk>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Gen><Sg>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Nom><Pl>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Nom><Pl><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Nom><Pl><Wk>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Plur",
    },
    "<+NN><Masc><Nom><Sg>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Nom><Sg><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Masc><Nom><Sg><Wk>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NN><Neut><Acc><Pl>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Plur",
    },
    "<+NN><Neut><Acc><Sg>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Acc><Sg><St>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Acc><Sg><Wk>": {
        "upos": "NOUN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Dat><Pl>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Plur",
    },
    "<+NN><Neut><Dat><Sg>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Dat><Sg><Old>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Style": "Arch",
    },
    "<+NN><Neut><Dat><Sg><St>": {
        "upos": "NOUN",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Gen><Pl>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Plur",
    },
    "<+NN><Neut><Gen><Sg>": {
        "upos": "NOUN",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Nom><Pl>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Plur",
    },
    "<+NN><Neut><Nom><Sg>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Nom><Sg><St>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><Neut><Nom><Sg><Wk>": {
        "upos": "NOUN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NN><NoGend><Acc><Pl>": {
        "upos": "NOUN", "Case": "Acc", "Number": "Plur"},
    "<+NN><NoGend><Acc><Pl><St>": {
        "upos": "NOUN", "Case": "Acc", "Number": "Plur"},
    "<+NN><NoGend><Acc><Pl><Wk>": {
        "upos": "NOUN", "Case": "Acc", "Number": "Plur"},
    "<+NN><NoGend><Dat><Pl>": {
        "upos": "NOUN", "Case": "Dat", "Number": "Plur"},
    "<+NN><NoGend><Dat><Sg>": {
        "upos": "NOUN", "Case": "Dat", "Number": "Sing"},
    "<+NN><NoGend><Dat><Sg><Wk>": {
        "upos": "NOUN", "Case": "Dat", "Number": "Sing"},
    "<+NN><NoGend><Gen><Pl>": {
        "upos": "NOUN", "Case": "Gen", "Number": "Plur"},
    "<+NN><NoGend><Gen><Pl><St>": {
        "upos": "NOUN", "Case": "Gen", "Number": "Plur"},
    "<+NN><NoGend><Gen><Pl><Wk>": {
        "upos": "NOUN", "Case": "Gen", "Number": "Plur"},
    "<+NN><NoGend><Nom><Pl>": {
        "upos": "NOUN", "Case": "Nom", "Number": "Plur"},
    "<+NN><NoGend><Nom><Pl><St>": {
        "upos": "NOUN", "Case": "Nom", "Number": "Plur"},
    "<+NN><NoGend><Nom><Pl><Wk>": {
        "upos": "NOUN", "Case": "Nom", "Number": "Plur"},
    "<+NPROP><Fem><Acc><Sg>": {
        "upos": "PROPN",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NPROP><Fem><Dat><Sg>": {
        "upos": "PROPN",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NPROP><Fem><Gen><Sg>": {
        "upos": "PROPN",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NPROP><Fem><Nom><Sg>": {
        "upos": "PROPN",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+NPROP><Masc><Acc><Sg>": {
        "upos": "PROPN",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NPROP><Masc><Dat><Sg>": {
        "upos": "PROPN",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NPROP><Masc><Gen><Sg>": {
        "upos": "PROPN",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NPROP><Masc><Nom><Sg>": {
        "upos": "PROPN",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+NPROP><Neut><Acc><Sg>": {
        "upos": "PROPN",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NPROP><Neut><Dat><Sg>": {
        "upos": "PROPN",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NPROP><Neut><Gen><Sg>": {
        "upos": "PROPN",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NPROP><Neut><Nom><Sg>": {
        "upos": "PROPN",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+NPROP><NoGend><Acc><Pl>": {
        "upos": "PROPN", "Case": "Acc", "Number": "Plur"},
    "<+NPROP><NoGend><Acc><Sg>": {
        "upos": "PROPN", "Case": "Acc", "Number": "Sing"},
    "<+NPROP><NoGend><Dat><Pl>": {
        "upos": "PROPN", "Case": "Dat", "Number": "Plur"},
    "<+NPROP><NoGend><Dat><Sg>": {
        "upos": "PROPN", "Case": "Dat", "Number": "Sing"},
    "<+NPROP><NoGend><Gen><Pl>": {
        "upos": "PROPN", "Case": "Gen", "Number": "Plur"},
    "<+NPROP><NoGend><Gen><Sg>": {
        "upos": "PROPN", "Case": "Gen", "Number": "Sing"},
    "<+NPROP><NoGend><Nom><Pl>": {
        "upos": "PROPN", "Case": "Nom", "Number": "Plur"},
    "<+NPROP><NoGend><Nom><Sg>": {
        "upos": "PROPN", "Case": "Nom", "Number": "Sing"},
    "<+ORD>": {"upos": "ADJ", "NumType": "Ord"},
    "<+ORD><Fem><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Gen><Sg><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Gen><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Fem><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Masc><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Acc><Sg>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Acc><Sg><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Acc><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Dat><Sg><St>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Gen><Sg>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Nom><Sg>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Nom><Sg><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><Neut><Nom><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Acc><Pl>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Acc><Pl><St>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Acc><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Acc",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Dat><Pl>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Dat><Sg>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Dat><Sg><Wk>": {
        "upos": "ADJ",
        "Case": "Dat",
        "Number": "Sing",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Gen><Pl>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Gen><Pl><St>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Gen><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Gen",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Nom><Pl>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Nom><Pl><St>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><NoGend><Nom><Pl><Wk>": {
        "upos": "ADJ",
        "Case": "Nom",
        "Number": "Plur",
        "NumType": "Ord",
    },
    "<+ORD><Pred>": {"upos": "ADJ", "NumType": "Ord"},
    "<+POSS><Attr><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Masc><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Acc><Sg><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><Neut><Nom><Sg><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Acc><Pl>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Acc><Pl><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Acc><Pl><Wk>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Dat><Pl>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Dat><Pl><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Dat><Pl><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Dat><Sg><Wk>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Gen><Pl><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Gen><Sg><Wk>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Nom><Pl>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Nom><Pl><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Attr><NoGend><Nom><Pl><Wk>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Fem><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Masc><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Acc><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><Neut><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Acc><Pl>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Acc><Pl><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Acc><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Dat><Pl>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Dat><Pl><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Dat><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Dat><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Gen><Pl>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Gen><Pl><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Gen><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Gen><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Nom><Pl>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Nom><Pl><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSS><Subst><NoGend><Nom><Pl><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Poss": "Yes",
        "PronType": "Prs",
    },
    "<+POSTP><Acc>": {"upos": "ADP", "AdpType": "Post", "Case": "Acc"},
    "<+POSTP><Dat>": {"upos": "ADP", "AdpType": "Post", "Case": "Dat"},
    "<+POSTP><Gen>": {"upos": "ADP", "AdpType": "Post", "Case": "Gen"},
    "<+PPRO><Pers><1><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Pl><NoGend><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><1><Sg><NoGend><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Pl><NoGend><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><2><Sg><NoGend><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Pl><NoGend><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Fem><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Masc><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Gen>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Gen><Wk>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Nom>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Pers><3><Sg><Neut><Nom><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
    },
    "<+PPRO><Rec>": {"upos": "PRON", "PronType": "Rcp"},
    "<+PPRO><Rec><Invar>": {"upos": "PRON", "PronType": "Rcp"},
    "<+PPRO><Refl><1><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Sg><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Sg><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Sg><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><1><Sg><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "1",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Sg><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Sg><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Sg><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><2><Sg><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "2",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Pl><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Pl><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Pl><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Pl><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Sg><NoGend><Acc>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Sg><NoGend><Acc><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Sg><NoGend><Dat>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PPRO><Refl><3><Sg><NoGend><Dat><Wk>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "Person": "3",
        "PronType": "Prs",
        "Reflex": "Yes",
    },
    "<+PREP><Acc>": {"upos": "ADP", "AdpType": "Prep", "Case": "Acc"},
    "<+PREP><Dat>": {"upos": "ADP", "AdpType": "Prep", "Case": "Dat"},
    "<+PREP><Gen>": {"upos": "ADP", "AdpType": "Prep", "Case": "Gen"},
    "<+PREPART><Fem><Dat><Sg>": {
        "upos": "ADP",
        "AdpType": "Preppron",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
    },
    "<+PREPART><Masc><Dat><Sg>": {
        "upos": "ADP",
        "AdpType": "Preppron",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
    },
    "<+PREPART><Neut><Acc><Sg>": {
        "upos": "ADP",
        "AdpType": "Preppron",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+PREPART><Neut><Dat><Sg>": {
        "upos": "ADP",
        "AdpType": "Preppron",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
    },
    "<+PROADV>": {"upos": "ADV", "PronType": "Dem,Rel"},
    "<+PTCL><Ans>": {"upos": "PART", "PartType": "Res"},
    "<+PTCL><Neg>": {"upos": "PART", "Polarity": "Neg"},
    "<+PUNCT><Comma>": {"upos": "PUNCT", "PunctType": "Comm"},
    "<+PUNCT><Left>": {"upos": "PUNCT", "PunctSide": "Ini"},
    "<+PUNCT><Norm>": {"upos": "PUNCT", "PunctType": "Peri"},
    "<+PUNCT><Right>": {"upos": "PUNCT", "PunctSide": "Fin"},
    "<+REL><Attr><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Attr><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Attr><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Fem><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Masc><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Acc><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><Neut><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Acc><Pl>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Acc><Pl><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Dat><Pl>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Dat><Pl><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Gen><Pl>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Gen><Pl><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Nom><Pl>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+REL><Subst><NoGend><Nom><Pl><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Rel",
    },
    "<+SYMBOL>": {"upos": "SYM"},
    "<+TRUNC>": {"upos": "X", "Hyph": "Yes"},
    "<+V><1><Pl><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "1",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><1><Pl><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "1",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><1><Pl><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "1",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><1><Pl><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "1",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><1><Sg><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><1><Sg><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><1><Sg><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "1",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><1><Sg><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "1",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><2><Pl><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "2",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><2><Pl><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "2",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><2><Pl><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "2",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><2><Pl><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "2",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><2><Sg><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><2><Sg><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "2",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><2><Sg><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "2",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><2><Sg><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "2",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><3><Pl><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><3><Pl><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "3",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><3><Pl><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Plur",
        "Person": "3",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><3><Pl><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Plur",
        "Person": "3",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><3><Sg><Past><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><3><Sg><Past><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Tense": "Past",
        "VerbForm": "Fin",
    },
    "<+V><3><Sg><Pres><Ind>": {
        "upos": "VERB",
        "Mood": "Ind",
        "Number": "Sing",
        "Person": "3",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><3><Sg><Pres><Subj>": {
        "upos": "VERB",
        "Mood": "Sub",
        "Number": "Sing",
        "Person": "3",
        "Tense": "Pres",
        "VerbForm": "Fin",
    },
    "<+V><Imp><Pl>": {
        "upos": "VERB",
        "Mood": "Imp",
        "Number": "Plur",
        "VerbForm": "Fin",
    },
    "<+V><Imp><Sg>": {
        "upos": "VERB",
        "Mood": "Imp",
        "Number": "Sing",
        "VerbForm": "Fin",
    },
    "<+V><Inf>": {"upos": "VERB", "VerbForm": "Inf"},
    "<+V><Inf><zu>": {"upos": "VERB", "VerbForm": "Inf"},
    "<+V><PPast>": {"upos": "VERB", "Tense": "Past", "VerbForm": "Part"},
    "<+V><PPres>": {"upos": "VERB", "Tense": "Pres", "VerbForm": "Part"},
    "<+VPART>": {"upos": "PART", "PartType": "Vbp"},
    "<+WADV>": {"upos": "ADV", "PronType": "Int"},
    "<+WPRO><Attr>": {"upos": "DET", "PronType": "Int"},
    "<+WPRO><Attr><Fem><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Fem><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Invar>": {"upos": "DET", "PronType": "Int"},
    "<+WPRO><Attr><Masc><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Masc><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Acc><Sg>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Acc><Sg><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Dat><Sg>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Dat><Sg><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Gen><Sg>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Gen><Sg><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Nom><Sg>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><Neut><Nom><Sg><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Acc><Pl>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Acc><Pl><St>": {
        "upos": "DET",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Dat><Pl>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Dat><Pl><St>": {
        "upos": "DET",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Gen><Pl>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Gen><Pl><St>": {
        "upos": "DET",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Nom><Pl>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Attr><NoGend><Nom><Pl><St>": {
        "upos": "DET",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Fem><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Fem",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Masc><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Masc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Acc><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Acc",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><Neut><Nom><Sg><Wk>": {
        "upos": "PRON",
        "Case": "Nom",
        "Gender": "Neut",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Acc><Pl>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Acc><Pl><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Acc><Sg>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Acc><Sg><St>": {
        "upos": "PRON",
        "Case": "Acc",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Dat><Pl>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Dat><Pl><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Dat><Sg>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Dat><Sg><St>": {
        "upos": "PRON",
        "Case": "Dat",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Gen><Pl>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Gen><Pl><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Gen><Sg>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Gen><Sg><St>": {
        "upos": "PRON",
        "Case": "Gen",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Nom><Pl>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Nom><Pl><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Plur",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Nom><Sg>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Int",
    },
    "<+WPRO><Subst><NoGend><Nom><Sg><St>": {
        "upos": "PRON",
        "Case": "Nom",
        "Number": "Sing",
        "PronType": "Int",
    },
}


def smor_to_conllu(smortags: str) -> dict:
    """ Lookup the Conll-U UPOS and FEATS from SMOR tags

    Examples:
    ---------
    smortags = "<+ADJ><Comp><Adv>"
    posfeats = smor_to_conllu(smortags)
    assert posfeats == {"upos": "ADJ", "Degree": "Cmp"}
    """
    # lookup from `db_smor_conllu`
    tmp = db_smor_conllu.get(smortags, None)
    # try rule-based utilit function
    if tmp is None:
        warnings.warn("Not implemented")
        return None
    else:
        return tmp


def conllu_to_smor(posfeats: dict) -> List[str]:
    """ Find the possivle SMOR-tags implied by Conll-U's UPOS and FEATS

    Examples:
    ---------
    # posfeats = {"upos": token.get("upos"), **token.get("feats")}
    posfeats = {"upos": "ADJ", "Degree": "Pos"}
    smortags = conllu_to_smor(posfeats)
    assert smortags == ["<+ADJ><Pos>", "<+ADJ><Pos><Adv>"]
    """
    n_keys = len(posfeats)
    smortags = {}
    for sm, cd in db_smor_conllu.items():
        matches = [v in posfeats.get(k, "").split(",")
                   for k, v in cd.items()]
        if all(matches):
            smortags[sm] = sum(matches) / n_keys
    return smortags


def get_best_smortag(smortags):
    bestpct = 0.0
    best = None
    for sm, pct in smortags.items():
        if pct > bestpct:
            best, bestpct = sm, pct
    return best


def match_smor_and_conllu(token: dict, analysis: List[str]) -> List[str]:
    """ Check which SMOR analysis matches Conll-U's morphological features
    """
    # abort
    if token.get("upos") is None:
        return []
    if token.get("feats") is None:
        return []

    # read data from Conll-U token
    posfeats = {
        "upos": token.get("upos"),
        **token.get("feats")
    }

    # lookup the possible smortags
    implied_smortags = conllu_to_smor(posfeats)

    # filter the `<+...` tags from analysis
    smortags = []
    for s in analysis:
        idx = s.find('<+')
        if idx >= 0:
            # check which SMOR analysis matches the Conll-U features
            if s[idx:] in implied_smortags.keys():
                smortags.append(s)
    # done
    return smortags
