# Generated by Django 2.0.4 on 2019-07-15 19:44

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [("unplugged", "0008_auto_20190715_1944")]

    operations = [
        migrations.CreateModel(
            name="SimpleAdminPlugin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Slugified name, used for actual name (and be able to find the plugin again)",
                        max_length=200,
                        null=True,
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        blank=True,
                        help_text="Human readable name",
                        max_length=200,
                        null=True,
                    ),
                ),
                ("config", jsonfield.fields.JSONField(blank=True, default=dict)),
                ("priority", models.SmallIntegerField(default=1)),
                (
                    "auto_created_plugins",
                    models.ManyToManyField(
                        blank=True,
                        related_name="auto_created_plugins",
                        to="unplugged.Plugin",
                    ),
                ),
                (
                    "plugin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="unplugged.Plugin",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Simple Admin Plugin",
                "db_table": "services_admin_simpleadmin_plugin",
                "ordering": ["priority"],
            },
        ),
        migrations.CreateModel(
            name="SimpleAdminTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("display_name", models.CharField(max_length=200)),
                ("description", models.TextField(default="No description found")),
                ("template_id", models.CharField(max_length=100)),
                ("plugin_type", models.CharField(max_length=100)),
                ("plugin_name", models.CharField(max_length=100)),
                ("modify_key", models.CharField(blank=True, max_length=40, null=True)),
                ("template", jsonfield.fields.JSONField()),
                (
                    "update_method",
                    models.CharField(
                        choices=[("full", "Full"), ("modify_key", "Modify Key")],
                        max_length=100,
                    ),
                ),
                ("automatic_created", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name_plural": "Simple Admin Templates",
                "db_table": "services_admin_simpleadmin_template",
            },
        ),
        migrations.AlterUniqueTogether(
            name="simpleadmintemplate",
            unique_together={("template_id", "plugin_type", "plugin_name")},
        ),
        migrations.AddField(
            model_name="simpleadminplugin",
            name="template",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="services_admin.SimpleAdminTemplate",
            ),
        ),
    ]
