# Generated by Django 2.2 on 2019-04-06 07:25

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("unplugged", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="SimpleAdminTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("display_name", models.CharField(max_length=200)),
                ("description", models.TextField(default="No description found")),
                ("template_id", models.CharField(max_length=100)),
                ("plugin_type", models.CharField(max_length=100)),
                ("plugin_name", models.CharField(max_length=100)),
                ("modify_key", models.CharField(blank=True, max_length=40, null=True)),
                ("template", jsonfield.fields.JSONField()),
                (
                    "update_method",
                    models.CharField(
                        choices=[("full", "Full"), ("modify_key", "Modify Key")],
                        max_length=100,
                    ),
                ),
                ("automatic_created", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name_plural": "Simple Admin Templates",
                "db_table": "services_admin_simpleadmin_template",
                "unique_together": {("template_id", "plugin_type", "plugin_name")},
            },
        ),
        migrations.CreateModel(
            name="SimpleAdminPlugin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=200, null=True)),
                ("config", jsonfield.fields.JSONField(default=dict)),
                ("priority", models.SmallIntegerField(default=1)),
                (
                    "auto_created_plugins",
                    models.ManyToManyField(
                        related_name="auto_created_plugins", to="unplugged.Plugin"
                    ),
                ),
                (
                    "plugin",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="unplugged.Plugin",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="unplugged.SimpleAdminTemplate",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Simple Admin Plugin",
                "db_table": "services_admin_simpleadmin_plugin",
                "ordering": ["priority"],
            },
        ),
    ]
