"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ecr = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-ecr-integ-stack');
const repo = new ecr.Repository(stack, 'Repo', {
    imageScanOnPush: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
repo.onImageScanCompleted('ImageScanComplete');
new cdk.CfnOutput(stack, 'RepositoryURI', {
    value: repo.repositoryUri,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuaW1hZ2VzY2FuLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuaW1hZ2VzY2FuLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLDhCQUE4QjtBQUU5QixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLHFCQUFxQixDQUFDLENBQUM7QUFFeEQsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7SUFDN0MsZUFBZSxFQUFFLElBQUk7SUFDckIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTztDQUN6QyxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsb0JBQW9CLENBQUMsbUJBQW1CLENBQUMsQ0FBQztBQUUvQyxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRTtJQUN4QyxLQUFLLEVBQUUsSUFBSSxDQUFDLGFBQWE7Q0FDMUIsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgZWNyIGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWVjci1pbnRlZy1zdGFjaycpO1xuXG5jb25zdCByZXBvID0gbmV3IGVjci5SZXBvc2l0b3J5KHN0YWNrLCAnUmVwbycsIHtcbiAgaW1hZ2VTY2FuT25QdXNoOiB0cnVlLFxuICByZW1vdmFsUG9saWN5OiBjZGsuUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxufSk7XG5cbnJlcG8ub25JbWFnZVNjYW5Db21wbGV0ZWQoJ0ltYWdlU2NhbkNvbXBsZXRlJyk7XG5cbm5ldyBjZGsuQ2ZuT3V0cHV0KHN0YWNrLCAnUmVwb3NpdG9yeVVSSScsIHtcbiAgdmFsdWU6IHJlcG8ucmVwb3NpdG9yeVVyaSxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==