#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# This file is execfile()d with the current directory set to its
# containing dir.

import sphinx_utils

import introspection as project_module


DEFAULT_LIGHT_SYNTAX_THEME = 'friendly'
DEFAULT_DARK_SYNTAX_THEME = 'monokai'


def setup(app):
    # Note: After enabling/disabling an augment, run sphinx with
    #
    #   sphinx-build -b html -a -E docs/source docs/build/html
    #
    # to suppress build output and rebuild all files.
    
    augment = sphinx_utils.augment(app)
    augment.bugfixes()
    augment.public_identifiers()
    augment.better_reprs()
    # augment.copy_init_params_to_class()
    augment.no_wrong_aliases()
    # augment.no_object_base()
    augment.theme_switcher(
        [
            {'id': 'light', 'icon': '☼'},
            {'id': 'dark', 'icon': '☽'},
        ],
        syntax_themes=[
            DEFAULT_LIGHT_SYNTAX_THEME,
            DEFAULT_DARK_SYNTAX_THEME,
            'sphinx_utils.pygments_styles.cobalt2.Cobalt2Style',
        ],
        default_theme=f'window.matchMedia("(prefers-color-scheme: dark)").matches ? "{DEFAULT_DARK_SYNTAX_THEME}" : "{DEFAULT_LIGHT_SYNTAX_THEME}"',
        default_syntax_theme=f'siteThemeId === "dark" ? "{DEFAULT_DARK_SYNTAX_THEME}" : "{DEFAULT_LIGHT_SYNTAX_THEME}"',
    )

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '3.0.0'

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.autosectionlabel',
    'sphinx_autodoc_typehints',
    'sphinx_copybutton',
]

intersphinx_mapping = {'python': ('https://docs.python.org/3', None)}
autodoc_class_signature = 'separated'
autodoc_default_options = {
    'members': True,
    'member-order': 'bysource',
    'show-inheritance': True,
    # 'special-members': '__init__',
    # 'undoc-members': True,
    'exclude-members': '__weakref__',
}
typehints_defaults = 'comma'
copybutton_prompt_text = r">>> |\.\.\. "
copybutton_prompt_is_regexp = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'introspection'
author = 'Paul Pinterits'
copyright = '2020, ' + author

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = project_module.__version__
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# -- Options for HTML output ----------------------------------------------

html_show_copyright = False
html_show_sphinx = False

html_copy_source = False

html_title = "Introspection documentation"
html_favicon = "favicon.svg"

html_theme = "nightsky"
html_theme_path = [sphinx_utils.HTML_THEMES_DIR]
html_sidebars = {
    '**': [
        'globaltoc.html',
        'localtoc.html',
        'relations.html',
        'searchbox.html',
        'theme_switcher.html',
    ],
}
