from enum import Enum


class SensorType(str, Enum):
    RADONSHORTTERMAVG = "radonShortTermAvg"
    RADONLONGTERMAVG = "radonLongTermAvg"
    TEMP = "temp"
    OUTDOORTEMP = "outdoorTemp"
    HUMIDITY = "humidity"
    OUTDOORHUMIDITY = "outdoorHumidity"
    CO2 = "co2"
    VOC = "voc"
    PRESSURE = "pressure"
    OUTDOORPRESSURE = "outdoorPressure"
    PRESSUREDIFFERENCE = "pressureDifference"
    LIGHT = "light"
    BATTERYPERCENTAGE = "batteryPercentage"
    ORIENTATION = "orientation"
    PM1 = "pm1"
    OUTDOORPM1 = "outdoorPm1"
    PM25 = "pm25"
    OUTDOORPM25 = "outdoorPm25"
    PM10 = "pm10"
    OUTDOORPM10 = "outdoorPm10"
    MOLD = "mold"
    STALEAIR = "staleAir"
    TRANSMISSIONEFFICIENCY = "transmissionEfficiency"
    VIRUSSURVIVALRATE = "virusSurvivalRate"
    VIRUSRISK = "virusRisk"
    WINDSPEED = "windSpeed"
    WINDDIRECTION = "windDirection"
    WINDGUST = "windGust"
    DEWPOINT = "dewPoint"
    CLOUDCOVER = "cloudCover"
    VISIBILITY = "visibility"
    OUTDOORWEATHER = "outdoorWeather"
    HOURLYRADONSTANDARDDEVIATION = "hourlyRadonStandardDeviation"
    HOURLYRADON = "hourlyRadon"
    ENERGYWASTAGE = "energyWastage"
    ENERGYSCENARIOS = "energyScenarios"
    HISTORICVENTILATIONCONFIDENCE = "historicVentilationConfidence"
    HISTORICVENTILATION = "historicVentilation"
    VENTILATIONRUNNINGCONFIDENCE = "ventilationRunningConfidence"
    OCCUPANTS = "occupants"
    OCCUPANTSUPPER = "occupantsUpper"
    OCCUPANTSLOWER = "occupantsLower"
    VENTILATIONAMOUNT = "ventilationAmount"
    HISTORICVENTILATIONRUNNING = "historicVentilationRunning"
    VENTILATIONRUNNING = "ventilationRunning"
    AGGREGATED = "aggregated"
    DAYTIMEBASELINE = "daytimeBaseline"
    DAYTIMEPEAK = "daytimePeak"
    NIGHTBASELINE = "nightBaseline"
    SLA = "sla"
    PRESSUREATMINHEIGHT = "pressureAtMinHeight"
    PRESSUREATMAXHEIGHT = "pressureAtMaxHeight"
    REGULATIONPRESSURE = "regulationPressure"
    REGULATIONHEIGHT = "regulationHeight"
    ZEROPRESSUREHEIGHT = "zeroPressureHeight"
    TOTALPOWERLOST = "totalPowerLost"
    MOISTGUARD = "moistGuard"
    POTENTIALPOWERSAVED = "potentialPowerSaved"
    POTENTIALPOWERSAVEDPERCENT = "potentialPowerSavedPercent"
    ZEROHEIGHTPERCENT = "zeroHeightPercent"
    ZONE = "zone"
    CONTROLSIGNAL = "controlSignal"
    LASTBESTCONTROLSIGNAL = "lastBestControlSignal"
    LASTBESTCONTROLSIGNALERROR = "lastBestControlSignalError"
    BALANCECONTROL = "balanceControl"
    OUTDOORNO2 = "outdoorNo2"
    OUTDOORO3 = "outdoorO3"
    OUTDOORSO2 = "outdoorSo2"
    OUTDOORCO = "outdoorCo"
    AIRLY = "airly"
    AIRLYNO2 = "airlyNo2"
    AIRLYCO = "airlyCo"

    def __str__(self) -> str:
        return str(self.value)
