from vectordb_bench.models import DB

# style const
DB_SELECTOR_COLUMNS = 6
DB_CONFIG_SETTING_COLUMNS = 3
CASE_CONFIG_SETTING_COLUMNS = 2
DB_CASE_CONFIG_SETTING_COLUMNS = 4
CHECKBOX_INDENT = 30
TASK_LABEL_INPUT_COLUMNS = 2
CHECKBOX_MAX_COLUMNS = 4
DB_CONFIG_INPUT_MAX_COLUMNS = 2
CASE_CONFIG_INPUT_MAX_COLUMNS = 3
DB_CONFIG_INPUT_WIDTH_RADIO = 2
CASE_CONFIG_INPUT_WIDTH_RADIO = 0.98
CASE_INTRO_RATIO = 3
SIDEBAR_CONTROL_COLUMNS = 3
LEGEND_RECT_WIDTH = 24
LEGEND_RECT_HEIGHT = 16
LEGEND_TEXT_FONT_SIZE = 14
STREAMING_CHART_COLUMNS = 2
SCATTER_MAKER_SIZE = 8
SCATTER_LINE_WIDTH = 2

PATTERN_SHAPES = ["", "+", "\\", "x", ".", "|", "/", "-"]


def getPatternShape(i):
    return PATTERN_SHAPES[i % len(PATTERN_SHAPES)]


# run_test page auto-refresh config
MAX_AUTO_REFRESH_COUNT = 999999
MAX_AUTO_REFRESH_INTERVAL = 5000  # 5s

PAGE_TITLE = "VectorDB Benchmark"
FAVICON = "https://assets.zilliz.com/VDB_Bench_icon_d3276bedc4.png"
HEADER_ICON = "https://assets.zilliz.com/VDB_Bench_text_icon_6c5f52a458.png"

# RedisCloud icon: https://assets.zilliz.com/Redis_Cloud_74b8bfef39.png
# Elasticsearch icon: https://assets.zilliz.com/elasticsearch_beffeadc29.png
# Chroma icon: https://assets.zilliz.com/chroma_ceb3f06ed7.png
DB_TO_ICON = {
    DB.Milvus: "https://assets.zilliz.com/milvus_c30b0d1994.png",
    DB.ZillizCloud: "https://assets.zilliz.com/zilliz_5f4cc9b050.png",
    DB.ElasticCloud: "https://assets.zilliz.com/Elatic_Cloud_dad8d6a3a3.png",
    DB.Pinecone: "https://assets.zilliz.com/pinecone_94d8154979.png",
    DB.QdrantCloud: "https://assets.zilliz.com/qdrant_b691674fcd.png",
    DB.QdrantLocal: "https://assets.zilliz.com/qdrant_b691674fcd.png",
    DB.WeaviateCloud: "https://assets.zilliz.com/weaviate_4f6f171ebe.png",
    DB.PgVector: "https://assets.zilliz.com/PG_Vector_d464f2ef5f.png",
    DB.PgVectoRS: "https://assets.zilliz.com/PG_Vector_d464f2ef5f.png",
    DB.PgVectorScale: "data:image/jpeg;base64,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",
    DB.PgDiskANN: "https://assets.zilliz.com/PG_Vector_d464f2ef5f.png",
    DB.AlloyDB: "data:image/png;base64,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",
    DB.MemoryDB: "data:image/jpeg;base64,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",
    DB.AliyunElasticsearch: "data:image/jpeg;base64,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",
    DB.Redis: "https://assets.zilliz.com/Redis_Cloud_74b8bfef39.png",
    DB.MariaDB: "data:image/png;base64,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",
    DB.Chroma: "https://assets.zilliz.com/chroma_ceb3f06ed7.png",
    DB.AliyunOpenSearch: "data:image/png;base64,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",
    DB.AWSOpenSearch: "https://assets.zilliz.com/opensearch_1eee37584e.jpeg",
    DB.OSSOpenSearch: "https://images.seeklogo.com/logo-png/50/1/opensearch-icon-logo-png_seeklogo-500356.png",
    DB.MongoDB: "data:image/png;base64,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",
    DB.TiDB: "https://img2.pingcap.com/forms/3/d/3d7fd5f9767323d6f037795704211ac44b4923d6.png",
    DB.Clickhouse: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAO4AAADUCAMAAACs0e/bAAAANlBMVEX/////zAD/yQD/AAD//fX/8Mf/9uD/ygD/6a7/0C3/CAj/rq7/0QD/hQz/67T/zhv/fwD/za9VhqZUAAABG0lEQVR4nO3auQ3DQBRDQa1un7L7b1YVUJkB4++8nMHkHFpq24fUPKbRuMTRmkdrHC15NMfRVbi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLi4uLj/xn0ft1RF7h5HrSR3w8XFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXF/Rm3rytKZ0ejq3BxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXFxcXGLcZ+pVpL7Sn2+Fbn3KfXAxcXFxcXFxcXFxcXFxcXFxcXFxcXFxe2ZewKjx49mqHXf2AAAAABJRU5ErkJggg==",
    DB.Vespa: "https://vespa.ai/vespa-content/uploads/2025/01/Vespa-symbol-green-rgb.png.webp",
    DB.LanceDB: "data:image/png;base64,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",
    DB.OceanBase: "data:image/png;base64,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",
    DB.S3Vectors: "https://assets.zilliz.com/s3_vectors_daf370b4e5.png",
    DB.Hologres: "https://img.alicdn.com/imgextra/i3/O1CN01d9qrry1i6lTNa2BRa_!!6000000004364-2-tps-218-200.png",
}

# RedisCloud color: #0D6EFD
# Chroma color: #FFC107
COLOR_MAP = {
    DB.Milvus.value: "#0DCAF0",
    DB.ZillizCloud.value: "#0D6EFD",
    DB.ElasticCloud.value: "#04D6C8",
    DB.Pinecone.value: "#6610F2",
    DB.QdrantCloud.value: "#D91AD9",
    DB.WeaviateCloud.value: "#20C997",
    DB.PgVector.value: "#4C779A",
    DB.Redis.value: "#0D6EFD",
    DB.AWSOpenSearch.value: "#0DCAF0",
    DB.OSSOpenSearch.value: "#0DCAF0",
    DB.TiDB.value: "#0D6EFD",
    DB.Vespa.value: "#61d790",
}

COLORS_10 = [
    "#a6cee3",
    "#1f78b4",
    "#b2df8a",
    "#33a02c",
    "#fb9a99",
    "#e31a1c",
    "#fdbf6f",
    "#ff7f00",
    "#cab2d6",
    "#6a3d9a",
]

COLORS_2 = ["#1f78b4", "#d8b365"]
