# libgpt
libgpt is a Python module that provides functions to interact with GPT3 and GPT4 models using different backends.

### Cookie files:
 - This module only accepts cookie files in JSON format.

### GPT3 Backends:
 - This module supports two GPT3 backends: freegpt and thebai.

### GPT4 Backend:
 - This module supports only one GPT4 backend: Bing Chat.

### Dependencies:
 - This module requires selenium and undetected_chromedriver libraries.

### How to Extract a Cookie File? (Required for GPT4)
To extract a cookie file, please follow these instructions:

- Install the cookie editor extension for Chrome or Firefox.
- Go to bing.com.
- Open the extension.
- Click "Export" on the bottom right, then "Export as JSON" (This saves your cookies to clipboard).
- Paste your cookies into a file called cookies.json.

# Usage:
## GPT3

To use the GPT3 backend, you can call the function GPT3() with the prompt you want to provide as the only argument.

```
from libgpt import GPT3

response = GPT3("I need a prompt for my essay about quantum mechanics.")
print(response)
```
This will return a string with the response generated by the GPT3 model using the freegpt backend.

You can also specify the backend you want to use by passing the backend parameter.
```
from libgpt import GPT3

response = GPT3("I need a prompt for my essay about quantum mechanics.", backend="thebai")
print(response)
```
This will return a string with the response generated by the GPT3 model using the thebai backend, which may produce different results.

## GPT4

To use the GPT4 backend, you can call the function GPT4() with the prompt you want to provide and the path to the cookie file you extracted as parameters.

```
from libgpt import GPT4

response = GPT4("I need a prompt for my essay about quantum mechanics.", "cookies.json")
print(response)
```
This will return a string with the response generated by the GPT4 model using the Bing Chat backend and the Creative conversation style by default.

You can also specify the conversation style you want to use by passing the style parameter.

```
from libgpt import GPT4

response = GPT4("I need a prompt for my essay about quantum mechanics.", "cookies.json", style="Precise")
print(response)
```
This will return a string with the response generated by the GPT4 model using the Bing Chat backend and the Precise conversation style.
