/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import java.util.ArrayList;
import java.util.List;
import net.razorvine.pickle.objects.ClassDictConstructor;
import numpy.core.NDArray;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.python.CustomPythonObject;
import org.jpmml.python.HasArray;
import org.jpmml.python.PythonObject;

public class Index
extends CustomPythonObject
implements HasArray {
    private static final String[] INIT_ATTRIBUTES = new String[]{"cls", "data"};
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"state"};

    public Index(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        super.__setstate__(Index.createAttributeMap(INIT_ATTRIBUTES, args));
    }

    @Override
    public void __setstate__(Object[] args) {
        super.__setstate__(Index.createAttributeMap(SETSTATE_ATTRIBUTES, args));
    }

    @Override
    public List<?> getArrayContent() {
        return this.getValues();
    }

    @Override
    public int[] getArrayShape() {
        List<?> values = this.getArrayContent();
        return new int[]{values.size()};
    }

    @Override
    public Object getArrayType() {
        return this.getDescr();
    }

    public Object getDescr() {
        Data data = this.getData();
        return data.getDescr();
    }

    public List<?> getValues() {
        Data data = this.getData();
        return data.getValues();
    }

    public String getCls() {
        ClassDictConstructor dictConstructor = this.get("cls", ClassDictConstructor.class);
        return ClassDictConstructorUtil.getClassName(dictConstructor);
    }

    public Data getData() {
        String cls;
        switch (cls = this.getCls()) {
            case "pandas.core.indexes.range.RangeIndex": {
                return this.getPythonObject("data", new RangeData());
            }
        }
        return this.getPythonObject("data", new NDArrayData(this.getPythonModule(), "data"));
    }

    public abstract class Data
    extends PythonObject {
        public Data(String module, String name) {
            super(module, name);
        }

        public abstract Object getDescr();

        public abstract List<?> getValues();
    }

    public class NDArrayData
    extends Data {
        public NDArrayData(String module, String name) {
            super(module, name);
        }

        @Override
        public Object getDescr() {
            NDArray data = this.getData();
            return data.getDescr();
        }

        @Override
        public List<?> getValues() {
            NDArray data = this.getData();
            return data.getArrayContent();
        }

        public NDArray getData() {
            return this.get("data", NDArray.class);
        }
    }

    public class RangeData
    extends Data {
        public RangeData() {
            super("pandas.core.indexes.range", "RangeIndex");
        }

        @Override
        public Object getDescr() {
            return "i4";
        }

        @Override
        public List<?> getValues() {
            int start = this.getStart();
            int stop = this.getStop();
            int step = this.getStep();
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = start; i < stop; i += step) {
                result.add(i);
            }
            return result;
        }

        public Integer getStart() {
            return this.getInteger("start");
        }

        public Integer getStop() {
            return this.getInteger("stop");
        }

        public Integer getStep() {
            return this.getInteger("step");
        }
    }
}

