/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.sequence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.sequence.Constraints;
import org.dmg.pmml.sequence.PMMLAttributes;
import org.dmg.pmml.sequence.PMMLElements;
import org.dmg.pmml.sequence.Sequence;
import org.dmg.pmml.sequence.SequenceRule;
import org.dmg.pmml.sequence.SetPredicate;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="SequenceModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "modelStats", "localTransformations", "constraints", "items", "itemsets", "setPredicates", "sequences", "sequenceRules"})
@JsonRootName(value="SequenceModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "numberOfTransactions", "maxNumberOfItemsPerTransaction", "avgNumberOfItemsPerTransaction", "numberOfTransactionGroups", "maxNumberOfTAsPerTAGroup", "avgNumberOfTAsPerTAGroup", "minimumSupport", "minimumConfidence", "lengthLimit", "numberOfItems", "numberOfSets", "numberOfSequences", "numberOfRules", "timeWindowWidth", "minimumTime", "maximumTime", "scorable", "mathContext", "extensions", "miningSchema", "modelStats", "localTransformations", "constraints", "items", "itemsets", "setPredicates", "sequences", "sequenceRules"})
public class SequenceModel
extends Model
implements HasExtensions<SequenceModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTransactions")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name="maxNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="maxNumberOfItemsPerTransaction")
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name="avgNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="avgNumberOfItemsPerTransaction")
    private Number avgNumberOfItemsPerTransaction;
    @XmlAttribute(name="numberOfTransactionGroups")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="numberOfTransactionGroups")
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name="maxNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="maxNumberOfTAsPerTAGroup")
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name="avgNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="avgNumberOfTAsPerTAGroup")
    private Number avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name="minimumSupport", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="minimumSupport")
    private Number minimumSupport;
    @XmlAttribute(name="minimumConfidence", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="minimumConfidence")
    private Number minimumConfidence;
    @XmlAttribute(name="lengthLimit")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="lengthLimit")
    private Integer lengthLimit;
    @XmlAttribute(name="numberOfItems", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="numberOfItems")
    private Integer numberOfItems;
    @XmlAttribute(name="numberOfSets", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name="numberOfSequences", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="numberOfSequences")
    private Integer numberOfSequences;
    @XmlAttribute(name="numberOfRules", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="numberOfRules")
    private Integer numberOfRules;
    @XmlAttribute(name="timeWindowWidth")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="timeWindowWidth")
    private Integer timeWindowWidth;
    @XmlAttribute(name="minimumTime")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="minimumTime")
    private Integer minimumTime;
    @XmlAttribute(name="maximumTime")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @Removed(value=Version.PMML_3_1)
    @JsonProperty(value="maximumTime")
    private Integer maximumTime;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @Added(value=Version.XPMML)
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="Constraints", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="Constraints")
    private Constraints constraints;
    @XmlElement(name="Item", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Item")
    private List<Item> items;
    @XmlElement(name="Itemset", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Itemset")
    private List<Itemset> itemsets;
    @XmlElement(name="SetPredicate", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SetPredicate")
    private List<SetPredicate> setPredicates;
    @XmlElement(name="Sequence", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Sequence")
    private List<Sequence> sequences;
    @XmlElement(name="SequenceRule", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SequenceRule")
    private List<SequenceRule> sequenceRules;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371270L;

    public SequenceModel() {
    }

    @ValueConstructor
    public SequenceModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="minimumSupport") Number minimumSupport, @Property(value="minimumConfidence") Number minimumConfidence, @Property(value="numberOfItems") Integer numberOfItems, @Property(value="numberOfSets") Integer numberOfSets, @Property(value="numberOfSequences") Integer numberOfSequences, @Property(value="numberOfRules") Integer numberOfRules, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="sequences") List<Sequence> sequences) {
        this.miningFunction = miningFunction;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public SequenceModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public SequenceModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public SequenceModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public SequenceModel setNumberOfTransactions(@Property(value="numberOfTransactions") Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTransaction() {
        return this.maxNumberOfItemsPerTransaction;
    }

    public SequenceModel setMaxNumberOfItemsPerTransaction(@Property(value="maxNumberOfItemsPerTransaction") Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    public Number getAvgNumberOfItemsPerTransaction() {
        return this.avgNumberOfItemsPerTransaction;
    }

    public SequenceModel setAvgNumberOfItemsPerTransaction(@Property(value="avgNumberOfItemsPerTransaction") Number avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    public Integer getNumberOfTransactionGroups() {
        return this.numberOfTransactionGroups;
    }

    public SequenceModel setNumberOfTransactionGroups(@Property(value="numberOfTransactionGroups") Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    public Integer getMaxNumberOfTAsPerTAGroup() {
        return this.maxNumberOfTAsPerTAGroup;
    }

    public SequenceModel setMaxNumberOfTAsPerTAGroup(@Property(value="maxNumberOfTAsPerTAGroup") Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    public Number getAvgNumberOfTAsPerTAGroup() {
        return this.avgNumberOfTAsPerTAGroup;
    }

    public SequenceModel setAvgNumberOfTAsPerTAGroup(@Property(value="avgNumberOfTAsPerTAGroup") Number avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    public Number requireMinimumSupport() {
        if (this.minimumSupport == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MINIMUMSUPPORT);
        }
        return this.minimumSupport;
    }

    public Number getMinimumSupport() {
        return this.minimumSupport;
    }

    public SequenceModel setMinimumSupport(@Property(value="minimumSupport") Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number requireMinimumConfidence() {
        if (this.minimumConfidence == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MINIMUMCONFIDENCE);
        }
        return this.minimumConfidence;
    }

    public Number getMinimumConfidence() {
        return this.minimumConfidence;
    }

    public SequenceModel setMinimumConfidence(@Property(value="minimumConfidence") Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public SequenceModel setLengthLimit(@Property(value="lengthLimit") Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer requireNumberOfItems() {
        if (this.numberOfItems == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFITEMS);
        }
        return this.numberOfItems;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public SequenceModel setNumberOfItems(@Property(value="numberOfItems") Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer requireNumberOfSets() {
        if (this.numberOfSets == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFSETS);
        }
        return this.numberOfSets;
    }

    public Integer getNumberOfSets() {
        return this.numberOfSets;
    }

    public SequenceModel setNumberOfSets(@Property(value="numberOfSets") Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer requireNumberOfSequences() {
        if (this.numberOfSequences == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFSEQUENCES);
        }
        return this.numberOfSequences;
    }

    public Integer getNumberOfSequences() {
        return this.numberOfSequences;
    }

    public SequenceModel setNumberOfSequences(@Property(value="numberOfSequences") Integer numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    public Integer requireNumberOfRules() {
        if (this.numberOfRules == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFRULES);
        }
        return this.numberOfRules;
    }

    public Integer getNumberOfRules() {
        return this.numberOfRules;
    }

    public SequenceModel setNumberOfRules(@Property(value="numberOfRules") Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public Integer getTimeWindowWidth() {
        return this.timeWindowWidth;
    }

    public SequenceModel setTimeWindowWidth(@Property(value="timeWindowWidth") Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    public Integer getMinimumTime() {
        return this.minimumTime;
    }

    public SequenceModel setMinimumTime(@Property(value="minimumTime") Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    public Integer getMaximumTime() {
        return this.maximumTime;
    }

    public SequenceModel setMaximumTime(@Property(value="maximumTime") Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public SequenceModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public SequenceModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SequenceModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.SEQUENCEMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public SequenceModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public SequenceModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public SequenceModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public SequenceModel setConstraints(@Property(value="constraints") Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public SequenceModel addItems(Item ... items) {
        this.getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return this.itemsets != null && !this.itemsets.isEmpty();
    }

    public List<Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public SequenceModel addItemsets(Itemset ... itemsets) {
        this.getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return this.setPredicates != null && !this.setPredicates.isEmpty();
    }

    public List<SetPredicate> getSetPredicates() {
        if (this.setPredicates == null) {
            this.setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    public SequenceModel addSetPredicates(SetPredicate ... setPredicates) {
        this.getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return this.sequences != null && !this.sequences.isEmpty();
    }

    public List<Sequence> requireSequences() {
        if (this.sequences == null || this.sequences.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.SEQUENCEMODEL_SEQUENCES);
        }
        return this.sequences;
    }

    public List<Sequence> getSequences() {
        if (this.sequences == null) {
            this.sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    public SequenceModel addSequences(Sequence ... sequences) {
        this.getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return this.sequenceRules != null && !this.sequenceRules.isEmpty();
    }

    public List<SequenceRule> getSequenceRules() {
        if (this.sequenceRules == null) {
            this.sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    public SequenceModel addSequenceRules(SequenceRule ... sequenceRules) {
        this.getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getModelStats(), this.getLocalTransformations(), this.getConstraints());
            }
            if (status == VisitorAction.CONTINUE && this.hasItems()) {
                status = PMMLObject.traverse(visitor, this.getItems());
            }
            if (status == VisitorAction.CONTINUE && this.hasItemsets()) {
                status = PMMLObject.traverse(visitor, this.getItemsets());
            }
            if (status == VisitorAction.CONTINUE && this.hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, this.getSetPredicates());
            }
            if (status == VisitorAction.CONTINUE && this.hasSequences()) {
                status = PMMLObject.traverse(visitor, this.getSequences());
            }
            if (status == VisitorAction.CONTINUE && this.hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, this.getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

