/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Decision;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Decisions", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "decisions"})
@Added(value=Version.PMML_4_1)
@JsonRootName(value="Decisions")
@JsonPropertyOrder(value={"businessProblem", "description", "extensions", "decisions"})
public class Decisions
extends PMMLObject
implements Iterable<Decision>,
HasExtensions<Decisions> {
    @XmlAttribute(name="businessProblem")
    @JsonProperty(value="businessProblem")
    private String businessProblem;
    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    private String description;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="Decision", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Decision")
    private List<Decision> decisions;
    private static final long serialVersionUID = 67371270L;

    public Decisions() {
    }

    @ValueConstructor
    public Decisions(@Property(value="decisions") List<Decision> decisions) {
        this.decisions = decisions;
    }

    public String getBusinessProblem() {
        return this.businessProblem;
    }

    public Decisions setBusinessProblem(@Property(value="businessProblem") String businessProblem) {
        this.businessProblem = businessProblem;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Decisions setDescription(@Property(value="description") String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Decisions addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Decision> iterator() {
        return this.requireDecisions().iterator();
    }

    public boolean hasDecisions() {
        return this.decisions != null && !this.decisions.isEmpty();
    }

    public List<Decision> requireDecisions() {
        if (this.decisions == null || this.decisions.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.DECISIONS_DECISIONS);
        }
        return this.decisions;
    }

    public List<Decision> getDecisions() {
        if (this.decisions == null) {
            this.decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public Decisions addDecisions(Decision ... decisions) {
        this.getDecisions().addAll(Arrays.asList(decisions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasDecisions()) {
                status = PMMLObject.traverse(visitor, this.getDecisions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

