/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.naive_bayes;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.jpmml.evaluator.PMMLTransformer;
import org.jpmml.model.visitors.AbstractVisitor;

public class ExtractBayesInputsTransformer
implements PMMLTransformer<RuntimeException> {
    @Override
    public PMML apply(PMML pmml) {
        AbstractVisitor visitor = new AbstractVisitor(){

            public VisitorAction visit(BayesInputs bayesInputs) {
                if (bayesInputs.hasExtensions()) {
                    List extensions = bayesInputs.getExtensions();
                    Iterator it = extensions.iterator();
                    while (it.hasNext()) {
                        Extension extension = (Extension)it.next();
                        List objects = extension.getContent();
                        BayesInput bayesInput = this.extractBayesInput(objects);
                        if (bayesInput == null) continue;
                        bayesInputs.addBayesInputs(new BayesInput[]{bayesInput});
                        if (!objects.isEmpty()) continue;
                        it.remove();
                    }
                }
                return super.visit(bayesInputs);
            }

            private BayesInput extractBayesInput(List<?> objects) {
                Iterator<?> it = objects.iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (!(object instanceof BayesInput)) continue;
                    BayesInput bayesInput = (BayesInput)object;
                    it.remove();
                    return bayesInput;
                }
                return null;
            }
        };
        visitor.applyTo((Visitable)pmml);
        return pmml;
    }
}

