# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['ankh', 'ankh.models']

package_data = \
{'': ['*']}

install_requires = \
['biopython>=1.80,<2.0',
 'datasets>=2.7.1,<3.0.0',
 'sentencepiece>=0.1.97,<0.2.0',
 'transformers>=4.25.1,<5.0.0']

setup_kwargs = {
    'name': 'ankh',
    'version': '1.0.0',
    'description': 'Optimized Protein Language Model',
    'long_description': '<br/>\n\n<h1 align="center">Ankh ☥: Optimized Protein Language Model Unlocks General-Purpose Modelling </h1>\n<br/>\n\n<br/>\n\n[Ankh](https://github.com/agemagician/Ankh/) is the first general-purpose protein language model trained on Google\'s **TPU-V4** surpassing the state-of-the-art performance with dramatically less parameters, promoting accessibility to research innovation via attainable resources.\n\n<div align="center"><img width=700 height=500 src="https://github.com/agemagician/Ankh/blob/main/images/logo.jpeg?raw=true"></div>\n\nThis repository will be updated regulary with **new pre-trained models for proteins** in part of supporting the **biotech** community in revolutinizing protein engineering using AI.\n\n\nTable of Contents\n=================\n* [&nbsp; Models Availability](#models)\n* [&nbsp; Dataset Availability](#datasets)\n* [&nbsp; Usage](#usage)\n* [&nbsp; Original downstream Predictions](#results)\n* [&nbsp; Followup use-cases](#inaction)\n* [&nbsp; Comparisons to other tools](#comparison)\n* [&nbsp; Community and Contributions](#community)\n* [&nbsp; Have a question?](#question)\n* [&nbsp; Found a bug?](#bug)\n* [&nbsp; Requirements](#requirements)\n* [&nbsp; Sponsors](#sponsors)\n* [&nbsp; Team](#team)\n* [&nbsp; License](#license)\n* [&nbsp; Citation](#citation)\n\n\n\n<a name="models"></a>\n## &nbsp; Models Availability\n\n|               Model                |              ankh                 |                        HuggingFace                        |\n|------------------------------------|-----------------------------------|-----------------------------------------------------------|\n|             Ankh Large             |     `ankh.load_large_model()`     |[Ankh Large](https://huggingface.co/ElnaggarLab/ankh-large)| \n|             Ankh Base              |     `ankh.load_base_model()`      |[Ankh Base](https://huggingface.co/ElnaggarLab/ankh-base)  |\n\n\n<a name="datasets"></a>\n\n## &nbsp; Datasets Availability\n|            Dataset            |                                            HuggingFace                                            |  \n| ----------------------------- |---------------------------------------------------------------------------------------------------|\n|\tRemote Homology       \t      |    `load_dataset("proteinea/remote_homology")`                                                    |\n|\tCASP12\t\t\t                  |    `load_dataset("proteinea/secondary_structure_prediction", data_files={\'test\': [\'CASP12.csv\']})`|\n|\tCASP14\t\t\t                  |    `load_dataset("proteinea/secondary_structure_prediction", data_files={\'test\': [\'CASP14.csv\']})`|\n|\tCB513\t\t\t                    |    `load_dataset("proteinea/secondary_structure_prediction", data_files={\'test\': [\'CB513.csv\']})` |\n|\tTS115\t\t\t                    |    `load_dataset("proteinea/secondary_structure_prediction", data_files={\'test\': [\'TS115.csv\']})` |\n|\tDeepLoc\t\t                    |    `load_dataset("proteinea/deeploc")`                                                            |\n| Fluorosence                   |    `load_dataset("proteinea/flourosence")`                                                        |\n| Solubility                    |    `load_dataset("proteinea/solubility")`                                                         |\n| Nearest Neighbor Search       |    `load_dataset("proteinea/nearest_neighbor_search")`                                            |\n\n\n\n<a name="usage"></a>\n## &nbsp; Usage\n\n* Loading pre-trained models:\n```python\n  import ankh\n\n  # To load large model:\n  model, tokenizer = ankh.load_large_model()\n  model.eval()\n\n\n  # To load base model.\n  model, tokenizer = ankh.load_base_model()\n  model.eval()\n```\n\n* Feature extraction using ankh large example:\n```python\n\n  model, tokenizer = ankh.load_large_model()\n  model.eval()\n\n  protein_sequences = [\'MKALCLLLLPVLGLLVSSKTLCSMEEAINERIQEVAGSLIFRAISSIGLECQSVTSRGDLATCPRGFAVTGCTCGSACGSWDVRAETTCHCQCAGMDWTGARCCRVQPLEHHHHHH\', \n  \'GSHMSLFDFFKNKGSAATATDRLKLILAKERTLNLPYMEEMRKEIIAVIQKYTKSSDIHFKTLDSNQSVETIEVEIILPR\']\n\n  protein_sequences = [list(seq) for seq in protein_sequences]\n\n\n  ids = tokenizer.batch_encode_plus(protein_sequences, \n                                    add_special_tokens=True, \n                                    padding=True, \n                                    is_split_into_words=True, \n                                    return_tensors="pt")[\'input_ids\']\n  with torch.no_grad():\n    embeddings = model(input_ids=ids)\n```\n\n* Loading downstream models example:\n```python\n  # To use downstream model for binary classification:\n  binary_classification_model = ankh.ConvBertForBinaryClassification(input_dim=768, \n                                                                     nhead=4, \n                                                                     hidden_dim=384, \n                                                                     num_hidden_layers=1, \n                                                                     num_layers=1, \n                                                                     kernel_size=7, \n                                                                     dropout=0.2, \n                                                                     pooling=\'max\')\n\n  # To use downstream model for multiclass classification:\n  multiclass_classification_model = ankh.ConvBertForMultiClassClassification(num_tokens=2, \n                                                                             input_dim=768, \n                                                                             nhead=4, \n                                                                             hidden_dim=384, \n                                                                             num_hidden_layers=1, \n                                                                             num_layers=1, \n                                                                             kernel_size=7, \n                                                                             dropout=0.2)\n\n  # To use downstream model for regression:\n  # training_labels_mean is optional parameter and it\'s used to fill the output layer\'s bias with it, \n  # it\'s useful for faster convergence.\n  regression_model = ankh.ConvBertForRegression(input_dim=768, \n                                                nhead=4, \n                                                hidden_dim=384, \n                                                num_hidden_layers=1, \n                                                num_layers=1, \n                                                kernel_size=7, \n                                                dropout=0, \n                                                pooling=\'max\', \n                                                training_labels_mean=0.38145)\n```\n\n\n<a name="results"></a>\n## &nbsp; Original downstream Predictions \n\n<a name="q3"></a>\n * <b>&nbsp; Secondary Structure Prediction (Q3):</b><br/>\n \n|         Model            |      CASP12      | CASP14 (HARD) |     TS115     |    CB513     |\n|--------------------------|:----------------:|:-------------:|:-------------:|:------------:|\n|**Ankh Large**            |      83.59%      |     77.48%    |    88.22%     |    88.48%    |\n|Ankh Base                 |      80.81%      |     76.67%    |    86.92%     |    86.94%    |\n|ProtT5-XL-UniRef50        |      83.34%      |     75.09%    |    86.82%     |    86.64%    |\n|ESM2-15B                  |      83.16%      |     76.56%    |    87.50%     |    87.35%    |\n|ESM2-3B                   |      83.14%      |     76.75%    |    87.50%     |    87.44%    |\n|ESM2-650M                 |      82.43%      |     76.97%    |    87.22%     |    87.18%    |\n|ESM-1b                    |      79.45%      |     75.39%    |    85.02%     |    84.31%    |\n\n\n<a name="q8"></a>\n * <b>&nbsp; Secondary Structure Prediction (Q8):</b><br/>\n \n|         Model            |      CASP12      | CASP14 (HARD) |     TS115     |    CB513     |\n|--------------------------|:----------------:|:-------------:|:-------------:|:------------:|\n|**Ankh Large**            |      71.69%      |     63.17%    |    79.10%     |    78.45%    |\n|Ankh Base                 |      68.85%      |     62.33%    |    77.08%     |    75.83%    |\n|ProtT5-XL-UniRef50        |      70.47%      |     59.71%    |    76.91%     |    74.81%    |\n|ESM2-15B                  |      71.17%      |     61.81%    |    77.67%     |    75.88%    |\n|ESM2-3B                   |      71.69%      |     61.52%    |    77.62%     |    75.95%    |\n|ESM2-650M                 |      70.50%      |     62.10%    |    77.68%     |    75.89%    |\n|ESM-1b                    |      66.02%      |     60.34%    |    73.82%     |    71.55%    |\n\n<a name="CP"></a>\n * <b>&nbsp; Contact Prediction Long Precision Using Embeddings:</b><br/>\n \n|         Model            | ProteinNet (L/1) | ProteinNet (L/5) | CASP14 (L/1)  | CASP14 (L/5) |\n|--------------------------|:----------------:|:----------------:|:-------------:|:------------:|\n|**Ankh Large**            |      48.93%      |      73.49%      |    16.01%     |    29.91%    |\n|Ankh Base                 |      43.21%      |      66.63%      |    13.50%     |    28.65%    |\n|ProtT5-XL-UniRef50        |      44.74%      |      68.95%      |    11.95%     |    24.45%    |\n|ESM2-15B                  |      31.62%      |      52.97%      |    14.44%     |    26.61%    |\n|ESM2-3B                   |      30.24%      |      51.34%      |    12.20%     |    21.91%    |\n|ESM2-650M                 |      29.36%      |      50.74%      |    13.71%     |    22.25%    |\n|ESM-1b                    |      29.25%      |      50.69%      |    10.18%     |    18.08%    |\n\n\n<a name="CP"></a>\n * <b>&nbsp; Contact Prediction Long Precision Using attention scores:</b><br/>\n \n|         Model            | ProteinNet (L/1) | ProteinNet (L/5) | CASP14 (L/1)  | CASP14 (L/5) |\n|--------------------------|:----------------:|:----------------:|:-------------:|:------------:|\n|**Ankh Large**            |      31.44%      |      55.58%      |     11.05%    |    20.74%    |\n|Ankh Base                 |      25.93%      |      46.28%      |     9.32%     |    19.51%    |\n|ProtT5-XL-UniRef50        |      30.85%      |      51.90%      |     8.60%     |    16.09%    |\n|ESM2-15B                  |      33.32%      |      57.44%      |     12.25%    |    24.60%    |\n|ESM2-3B                   |      33.92%      |      56.63%      |     12.17%    |    21.36%    |\n|ESM2-650M                 |      31.87%      |      54.63%      |     10.66%    |    21.01%    |\n|ESM-1b                    |      25.30%      |      42.03%      |     7.77%     |    15.77%    |\n\n\n<a name="Loc"></a>\n * <b>&nbsp; Localization (Q10):</b><br/>\n \n|         Model            |  DeepLoc Dataset |\n|--------------------------|:----------------:|\n|**Ankh Large**            |      83.01%      |\n|Ankh Base                 |      81.38%      |\n|ProtT5-XL-UniRef50        |      82.95%      |\n|ESM2-15B                  |      81.22%      |\n|ESM2-3B                   |      81.22%      |\n|ESM2-650M                 |      82.08%      |\n|ESM-1b                    |      80.51%      |\n\n\n<a name="RH"></a>\n * <b>&nbsp; Remote Homology:</b><br/>\n \n|         Model            |   SCOPe (Fold)   |\n|--------------------------|:----------------:|\n|Ankh Large                |      61.01%      |\n|**Ankh Base**             |      61.14%      |\n|ProtT5-XL-UniRef50        |      59.38%      |\n|ESM2-15B                  |      54.48%      |\n|ESM2-3B                   |      59.24%      |\n|ESM2-650M                 |      51.36%      |\n|ESM-1b                    |      56.93%      |\n\n\n<a name="Sol"></a>\n * <b>&nbsp; Solubility:</b><br/>\n \n|         Model            |    Solubility    |\n|--------------------------|:----------------:|\n|**Ankh Large**            |      76.41%      |\n|Ankh Base                 |      76.36%      |\n|ProtT5-XL-UniRef50        |      76.26%      |\n|ESM2-15B                  |      60.52%      |\n|ESM2-3B                   |      74.91%      |\n|ESM2-650M                 |      74.56%      |\n|ESM-1b                    |      74.91%      |\n\n\n<a name="Flu"></a>\n * <b>&nbsp; Fluorosence (Spearman Correlation):</b><br/>\n \n|         Model            |    Fluorosence   |\n|--------------------------|:----------------:|\n|**Ankh Large**            |        0.62      |\n|Ankh Base                 |        0.62      |\n|ProtT5-XL-UniRef50        |        0.61      |\n|ESM2-15B                  |        0.56      |\n|ESM-1b                    |        0.48      |\n|ESM2-650M                 |        0.48      |\n|ESM2-3B                   |        0.46      |\n\n\n<a name="CATH"></a>\n * <b>&nbsp; Nearest Neighbor Search using Global Pooling:</b><br/>\n \n|         Model            |   Lookup69K (C)  |   Lookup69K (A)  |   Lookup69K (T)  |   Lookup69K (H)  |\n|--------------------------|:----------------:|:----------------:|:----------------:|:----------------:|\n|Ankh Large                |       0.83       |       0.72       |       0.60       |       0.70       |\n|**Ankh Base**             |       0.85       |       0.77       |       0.63       |       0.72       |\n|ProtT5-XL-UniRef50        |       0.83       |       0.69       |       0.57       |       0.73       |\n|ESM2-15B                  |       0.78       |       0.63       |       0.52       |       0.67       |\n|ESM2-3B                   |       0.79       |       0.65       |       0.53       |       0.64       |\n|ESM2-650M                 |       0.72       |       0.56       |       0.40       |       0.53       |\n|ESM-1b                    |       0.78       |       0.65       |       0.51       |       0.63       |\n\n\n\n<a name="team"></a>\n## &nbsp; Team\n\n* <b>Technical University of Munich:</b><br/>\n\n| [Ahmed Elnaggar](https://github.com/agemagician) |       Burkhard Rost       |\n|:------------------------------------------------:|:-------------------------:|\n| <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/AhmedElNaggar.jpg?raw=true"> | <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/Rost.jpg?raw=true"> |\n\n\n* <b>Proteinea:</b><br/>\n\n| [Hazem Essam](https://github.com/hazemessamm) | [Wafaa Ashraf](https://github.com/wafaaashraf) | [Walid Moustafa](https://github.com/wmustafaawad) | [Mohamed Elkerdawy](https://github.com/melkerdawy) |\n|:-------------------------:|:-------------------------:|:-------------------------:|:-------------------------:|\n| <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/HazemEssam.jpeg?raw=true"> | <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/WafaaAshraf.jpeg?raw=true"> | <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/WalidMoustafa.jpg?raw=true"> | <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/MohamedElKerdawy.jpeg?raw=true"> |\n\n\n* <b>University of Columbia:</b><br/>\n\n| [Charlotte Rochereau](https://github.com/crochereau) |\n|:----------------------------------------------------:|\n| <img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/CharlotteRochereau.jpg?raw=true"> |\n\n\n<a name="sponsors"></a>\n## &nbsp; Sponsors\n\n\n|                                                    Google Cloud                                                         |\n:------------------------------------------------------------------------------------------------------------------------:|\n<img width=120 src="https://github.com/agemagician/Ankh/blob/main/images/google_cloud_logo.jpg?raw=true"> |\n\n\n\n<a name="license"></a>\n## &nbsp; License\nAnkh pretrained models are released under the under terms of the [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International](https://creativecommons.org/licenses/by/4.0/).\n\n<a name="community"></a>\n## &nbsp; Community and Contributions\n\nThe Ankh project is a **open source project** supported by various partner companies and research institutions. We are committed to **share all our pre-trained models and knowledge**. We are more than happy if you could help us on sharing new ptrained models, fixing bugs, proposing new feature, improving our documentation, spreading the word, or support our project.\n\n<a name="question"></a>\n## &nbsp; Have a question?\n\nWe are happy to hear your question in our issues page [Ankh](https://github.com/agemagician/Ankh/issues)! Obviously if you have a private question or want to cooperate with us, you can always **reach out to us directly** via [Hello](mailto:hello@proteinea.com?subject=[GitHub]Ankh). \n\n<a name="bug"></a>\n## &nbsp; Found a bug?\n\nFeel free to **file a new issue** with a respective title and description on the the [Ankh](https://github.com/agemagician/Ankh/issues) repository. If you already found a solution to your problem, **we would love to review your pull request**!.\n',
    'author': 'Ahmed Elnaggar',
    'author_email': 'amit.najjar@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/agemagician/Ankh',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
