# 6.0 {: #\6.0}

## Upgrade Notes

While there are a number of new features and bug fixes, the only backwards incompatible changes are with SuperFences'
custom fences. In an effort to make custom fences more useful, we wanted to be able to pass the `Markdown` object to the
formatters. This gives custom formats access to things like metadata if required.

The format of custom fence formatters already had two different versions: ones without custom options and one with
custom options. As adding yet another parameter would cause more complexity behind the scenes, we decided to introduce
the breaking change of creating a unified format for formatters with custom options and without. In addition to unifying
the format, we also now pass the `Markdown` object to the formatters as an additional parameter.

While we were breaking custom formats, it seemed like a good time to go ahead and change the defaults for the
`custom_fences` options. Most people who are using SuperFences aren't even using the default, niche `flow` and
`sequence` custom fences. Instead of hijacking fence names that most people aren't even using, it seemed more
appropriate to define no custom fences.

Below are instructions on how to upgrade if you were relying on the either the default settings of `custom_fences` or if
you had written your own custom fence formatters.

1. If you've written your own custom fence formatters, the number of parameters needed has changed, so you must update
  your existing formatters.  The needed parameters are the same regardless of whether you are using an options validator
  or not.

    ```py3
    def custom_formatter(source, language, css_class, options, md):
        return string
    ```

2. `flow` and `sequence` are no longer defined by default. If you were relying on the default custom fences, you will
  have to define them manually now. The needed settings are found below:

    ```py3
    extension_configs = {
        "pymdownx.superfences": {
            "custom_fences": [
                {
                    'name': 'flow',
                    'class': 'uml-flowchart',
                    'format': pymdownx.superfences.fence_code_format
                },
                {
                    'name': 'sequence',
                    'class': 'uml-sequence-diagram',
                    'format': pymdownx.superfences.fence_code_format
                }
            ]
        }
    }
    ```

    If you are attempting to configure these options in a YAML based configuration (like in [MkDocs][mkdocs]), please
    see the [FAQ](../../faq.md#function-references-in-yaml) to see how to specify function references in YAML.

--8<-- "refs.txt"
