# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_model.ipynb.

# %% auto 0
__all__ = ['make_model', 'train', 'predict']

# %% ../nbs/00_model.ipynb 3
import pandas as pd 
import numpy as np
from sktime.forecasting.base import ForecastingHorizon
from sktime.forecasting.fbprophet import Prophet

# %% ../nbs/00_model.ipynb 9
def make_model():
    forecaster = Prophet(  
        add_seasonality=dict(period=30, fourier_order=2, name='monthly'),
        yearly_seasonality=True)
    
    return forecaster

# %% ../nbs/00_model.ipynb 11
def train(forecaster, y):
    forecaster.fit(y)

# %% ../nbs/00_model.ipynb 13
def predict(forecaster, pred_n_days_ahead):
    fh = ForecastingHorizon(values=np.arange(pred_n_days_ahead)+1)

    y_pred = forecaster.predict(fh=fh)
    y_pred_int = forecaster.predict_interval(fh=fh)

    return y_pred, y_pred_int
