/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.graph;

import codeintelligence.codeanalysis.utils.graph.AbstractPropertyGraph;
import codeintelligence.codeanalysis.utils.graph.Edge;
import codeintelligence.codeanalysis.utils.graph.GraphTraversal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;

public class DepthFirstTraversal<V, E>
implements GraphTraversal<V, E> {
    public final AbstractPropertyGraph<V, E> GRAPH;
    public final V START_VERTEX;
    private V nextVertex;
    private Edge<V, E> nextEdge;
    private final Deque<V> visited;
    private final Deque<Edge<V, E>> visiting;
    private final Deque<Edge<V, E>> reverStack;

    public DepthFirstTraversal(AbstractPropertyGraph graph, V start) {
        this.GRAPH = graph;
        this.nextEdge = null;
        this.nextVertex = null;
        this.START_VERTEX = start;
        this.visited = new ArrayDeque<V>(this.GRAPH.allVertices.size());
        this.visiting = new ArrayDeque<Edge<V, E>>(this.GRAPH.allEdges.size());
        this.reverStack = new ArrayDeque<Edge<V, E>>();
        Edge<Object, Object> startEdge = new Edge<Object, Object>(null, null, this.START_VERTEX);
        this.visiting.add(startEdge);
    }

    @Override
    public boolean hasNext() {
        return !this.visiting.isEmpty();
    }

    @Override
    public V nextVertex() {
        if (this.visiting.isEmpty()) {
            throw new NoSuchElementException("No more vertices to traverse!");
        }
        this.next();
        return this.nextVertex;
    }

    @Override
    public Edge<V, E> nextEdge() {
        if (this.visiting.isEmpty()) {
            throw new NoSuchElementException("No more edges to traverse!");
        }
        this.next();
        if (this.nextEdge.source == null) {
            if (this.visiting.isEmpty()) {
                return null;
            }
            this.next();
        }
        return this.nextEdge;
    }

    private void next() {
        block8: {
            block7: {
                this.nextEdge = this.visiting.pop();
                if (!this.GRAPH.isDirected()) break block7;
                this.nextVertex = this.nextEdge.target;
                if (!this.visited.add(this.nextVertex)) break block8;
                for (Edge out : this.GRAPH.outEdges.get(this.nextVertex)) {
                    if (this.visited.contains(out.target)) continue;
                    this.reverStack.push(out);
                }
                while (!this.reverStack.isEmpty()) {
                    this.visiting.push(this.reverStack.pop());
                }
                break block8;
            }
            this.nextVertex = this.visited.contains(this.nextEdge.source) ? this.nextEdge.target : this.nextEdge.source;
            if (this.visited.add(this.nextVertex)) {
                for (Edge out : this.GRAPH.outEdges.get(this.nextVertex)) {
                    if (this.visited.contains(out.target)) continue;
                    this.reverStack.push(out);
                }
                while (!this.reverStack.isEmpty()) {
                    this.visiting.push(this.reverStack.pop());
                }
                for (Edge in : this.GRAPH.inEdges.get(this.nextVertex)) {
                    if (this.visited.contains(in.source)) continue;
                    this.reverStack.push(in);
                }
                while (!this.reverStack.isEmpty()) {
                    this.visiting.push(this.reverStack.pop());
                }
            }
        }
    }
}

