/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Logger {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE yyyy/MMM/dd HH:mm:ss:SSS");
    private static Lock ioLock;
    private static Level activeLevel;
    private static boolean stdOutEcho;
    private static Level stdOutEchoLevel;
    private static PrintStream logStream;
    private static PrintWriter logWriter;
    private static boolean timeTagEnabled;
    private static boolean enabled;

    public static void init(String path) throws IOException {
        enabled = true;
        stdOutEcho = false;
        timeTagEnabled = true;
        logStream = System.out;
        stdOutEchoLevel = activeLevel = Level.INFO;
        try {
            File logFile;
            ioLock = new ReentrantLock();
            if (!((String)path).toLowerCase().endsWith(".log")) {
                path = (String)path + ".log";
            }
            if (!(logFile = new File((String)path)).createNewFile()) {
                logFile.delete();
                logFile.createNewFile();
            }
            logStream = new PrintStream(new FileOutputStream(logFile), true);
        }
        finally {
            logWriter = new PrintWriter(logStream, true);
            logWriter.println("======= LOG CREATED on " + Logger.date() + " =======");
        }
    }

    public static void init() {
        enabled = true;
        stdOutEcho = false;
        timeTagEnabled = true;
        logStream = System.out;
        stdOutEchoLevel = activeLevel = Level.INFO;
        try {
            ioLock = new ReentrantLock();
        }
        finally {
            logWriter = new PrintWriter(logStream, true);
            logWriter.println("======= LOG CREATED on " + Logger.date() + " =======");
        }
    }

    public static void redirectStandardError(String path) throws IOException {
        File errorFile;
        if (!((String)path).toLowerCase().endsWith(".err")) {
            path = (String)path + ".err";
        }
        if (!(errorFile = new File((String)path)).createNewFile()) {
            errorFile.delete();
            errorFile.createNewFile();
        }
        PrintStream stdErr = new PrintStream(new FileOutputStream(errorFile), true);
        System.setErr(stdErr);
        System.err.println("======= ERROR CREATED on " + Logger.date() + " =======");
    }

    public static void setActiveLevel(Level level) {
        activeLevel = level;
    }

    public static void setEchoToStdOut(boolean echo) {
        stdOutEcho = echo;
    }

    public static void setStdOutEchoLevel(Level echoLevel) {
        stdOutEchoLevel = echoLevel;
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static void setTimeTagEnabled(boolean enabled) {
        timeTagEnabled = enabled;
    }

    public static String time() {
        int h = Calendar.getInstance().get(11);
        int m = Calendar.getInstance().get(12);
        int s = Calendar.getInstance().get(13);
        int ms = Calendar.getInstance().get(14);
        return String.format("%02d:%02d:%02d:%03d", h, m, s, ms);
    }

    public static String date() {
        return DATE_FORMAT.format(Calendar.getInstance().getTime());
    }

    public static void log(String msg) {
        Logger.log(msg, Level.RAW);
    }

    public static void printf(String format, Object ... args) {
        Logger.printf(Level.RAW, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printf(Level level, String format, Object ... args) {
        if (!enabled) {
            return;
        }
        if (level.ORDER <= Logger.activeLevel.ORDER) {
            ioLock.lock();
            try {
                if (level.ORDER > Level.RAW.ORDER && timeTagEnabled) {
                    Object[] fmtArgs;
                    if (args != null && args.length > 0) {
                        fmtArgs = new Object[2 + args.length];
                        fmtArgs[0] = Logger.date();
                        fmtArgs[1] = level.LABEL;
                        for (int i = 0; i < args.length; ++i) {
                            fmtArgs[i + 2] = args[i];
                        }
                    } else {
                        fmtArgs = new Object[]{Logger.date(), level.LABEL};
                    }
                    logWriter.printf("%s [%s] | " + format + "\n", fmtArgs);
                } else {
                    logWriter.printf(format + "\n", args);
                }
                if (stdOutEcho && logStream != System.out && level.ORDER <= Logger.stdOutEchoLevel.ORDER) {
                    System.out.printf(format + "\n", args);
                }
            }
            finally {
                ioLock.unlock();
            }
        }
    }

    public static void log(String msg, Level level) {
        if (!enabled) {
            return;
        }
        if (level.ORDER <= Logger.activeLevel.ORDER) {
            ioLock.lock();
            try {
                if (level.ORDER > Level.RAW.ORDER && timeTagEnabled) {
                    logWriter.printf("%s [%s] | %s\n", Logger.date(), level.LABEL, msg);
                } else {
                    logWriter.println(msg);
                }
                if (stdOutEcho && logStream != System.out && level.ORDER <= Logger.stdOutEchoLevel.ORDER) {
                    System.out.println(msg);
                }
            }
            finally {
                ioLock.unlock();
            }
        }
    }

    public static void log(Exception ex, Level level) {
        if (!enabled) {
            return;
        }
        if (level.ORDER <= Logger.activeLevel.ORDER) {
            ioLock.lock();
            try {
                if (level.ORDER > Level.RAW.ORDER && timeTagEnabled) {
                    logWriter.printf("%s [%s] | %s\n", Logger.date(), level.LABEL, ex.toString());
                } else {
                    logWriter.println(ex.toString());
                }
                ex.printStackTrace(logWriter);
                if (stdOutEcho && logStream != System.out && level.ORDER <= Logger.stdOutEchoLevel.ORDER) {
                    System.out.println(ex.toString());
                    ex.printStackTrace(System.out);
                }
            }
            finally {
                ioLock.unlock();
            }
        }
    }

    public static void log(Object obj, Level lvl) {
        Logger.log(obj.toString(), lvl);
    }

    public static void debug(String msg) {
        Logger.log(msg, Level.DEBUG);
    }

    public static void info(String msg) {
        Logger.log(msg, Level.INFO);
    }

    public static void warn(String msg) {
        Logger.log(msg, Level.WARNING);
    }

    public static void warn(Exception ex) {
        Logger.log(ex, Level.WARNING);
    }

    public static void error(String msg) {
        Logger.log(msg, Level.ERROR);
    }

    public static void error(Exception ex) {
        Logger.log(ex, Level.ERROR);
    }

    public static PrintStream getStream() {
        return logStream;
    }

    public static void close() {
        logWriter.close();
    }

    static {
        enabled = false;
    }

    public static enum Level {
        RAW(0, null),
        ERROR(1, "ERR"),
        WARNING(2, "WRN"),
        INFO(3, "INF"),
        DEBUG(4, "DBG");

        public final int ORDER;
        public final String LABEL;

        private Level(int order, String label) {
            this.ORDER = order;
            this.LABEL = label;
        }
    }
}

